#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path
from time import sleep
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

def populate(self):
        # pre-populate checkboxes and flags
        prefs = self.bk.getPrefs() 
        self.removehi.set(prefs['remove_hanging_indents'])
        self.removeif.set(prefs['remove_italics'])
        self.removehf.set(prefs['remove_hyperlink_format'])
        self.deletehl.set(prefs['delete_hyperlinks'])       
        self.usetj.set(prefs['use_text_justify'])
        
        options.REMOVE_HANGING_INDENTS = prefs['remove_hanging_indents']
        options.REMOVE_ITALICS = prefs['remove_italics']
        options.REMOVE_HYPERLINK_FORMAT = prefs['remove_hyperlink_format']
        options.DELETE_HYPERLINKS = prefs['delete_hyperlinks']
        options.USE_TEXT_JUSTIFY = prefs['use_text_justify']      
        return(0)    

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
class UserDialog(tk.Frame):

    def __init__(self, parent, bk):
        tk.Frame.__init__(self, parent, background='#E0E0E0')
        self.parent = parent
        self.bk = bk
        centeredWindow(self.parent, 330, 280)
        parent.minsize(150, 150)
        parent.maxsize(600, 600)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
        
    def setup_UI(self):
    
        self.labelf1 = LabelFrame(self, text='Formatting Options', 
                        bg     = '#E0E0E0',  
                        font   = ('Helvetica', 10),                         
                        relief = RIDGE
                        )
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True, ipady=27, pady=3, padx=3)
        
        """
        self.InfoLabel = Label(self.labelf1, text=" ",
                        fg     = '#000000',                         
                        bg     = '#E0E0E0', 
                        anchor = E
                        )
        self.InfoLabel.grid(columnspan=2, sticky=E, row=0, padx=10)       
        """
        
        self.save = BooleanVar() 
        self.save.set(False)
        self.chkbSave = Checkbutton(self.labelf1, 
                        text     = '  Save Settings',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.save                     
                        )
        self.chkbSave.grid(column=1, sticky=E, row=0, pady=0, padx=50) 
        
        clearButton = Button(self.labelf1, 
                        text    = "Clear All", 
                        font    = ('Helvetica', 10),
                        bg      = '#F0F0F0', 
                        relief  = GROOVE, 
                        command = self.onClear
                        ).grid(row=1, sticky=W, column=1, pady=5, padx=45)  
        
        self.removehi = BooleanVar() 
        self.removehi.set(False)
        self.chkbRemoveHI = Checkbutton(self.labelf1, 
                        text     = '  Remove all hanging indents',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.removehi,
                        command = self.onRemoveHI                         
                        )
        self.chkbRemoveHI.grid(column=1, sticky=W, row=2, padx=50)    
       
        self.removeif = BooleanVar() 
        self.removeif.set(False)
        self.chkbRemoveIF = Checkbutton(self.labelf1, 
                        text     = '  Remove all italic formatting',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.removeif,
                        command = self.onRemoveIF                         
                        )
        self.chkbRemoveIF.grid(column=1, sticky=W, row=3, padx=50)      
         
        self.removehf = BooleanVar() 
        self.removehf.set(False)
        self.chkbRemoveHF = Checkbutton(self.labelf1, 
                        text     = '  Remove all hyperlink formatting',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.removehf,
                        command = self.onRemoveHF                         
                        )
        self.chkbRemoveHF.grid(column=1, sticky=W, row=4, padx=50)      

        self.deletehl = BooleanVar() 
        self.deletehl.set(False)
        self.chkbDeleteHL = Checkbutton(self.labelf1, 
                        text     = '  Delete all hyperlinks',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.deletehl,
                        command = self.onDeleteHL                    
                        )
        self.chkbDeleteHL.grid(column=1, sticky=W, row=5, padx=50)      
        
        self.usetj = BooleanVar() 
        self.usetj.set(False)
        self.chkbUseTJ = Checkbutton(self.labelf1, 
                        text     = '  Add text justification for all entries',
                        font   = ('Helvetica', 10),
                        bg       = '#E0E0E0', 
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.usetj,
                        command = self.onUseTJ                    
                        )
        self.chkbUseTJ.grid(column=1, sticky=W, row=6, padx=50)      
        
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', '10'), background='#E0E0E0', width=14, relief=FLAT) 
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=7, column=1, pady=10)     

        #**** Create the statusbar *****#
        self.status = Label(self.labelf1, text=" ",
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.grid(row = 8, columnspan=2, sticky=W, padx=5) 
        
        # show new plugin version msg if available
        if options.NEW_PLUGIN_VERSION: 
            centeredWindow(self.parent, 330, 295)   
            self.status.config(text=options.MSG_NEW_VERSION_AVAILABLE)
            
        populate(self)   
        self.grab_set()
              
    def onClear(self):
        self.removehi.set(False)
        self.removeif.set(False)
        self.removehf.set(False)
        self.deletehl.set(False)        
        self.usetj.set(False)
        
        options.REMOVE_HANGING_INDENTS = False
        options.REMOVE_ITALICS = False
        options.REMOVE_HYPERLINK_FORMAT = False
        options.DELETE_HYPERLINKS = False
        options.USE_TEXT_JUSTIFY = False    
        return(0)          
           
    def onRemoveHI(self):
        print('\n>>> In on Remove hanging indent...' + str(self.removehi.get()))
        
        if self.removehi.get() == True:
            options.REMOVE_HANGING_INDENTS = True
        else:
            options.REMOVE_HANGING_INDENTS = False
        
        print('>>> options.REMOVE_HANGING_INDENTS = ' + str(options.REMOVE_HANGING_INDENTS))               
        return(0)       
        
    def onRemoveIF(self):
        print('\n>>> In on Remove Italics...' + str(self.removeif.get()))
        
        if self.removeif.get() == True:
            options.REMOVE_ITALICS = True
        else:
            options.REMOVE_ITALICS = False
        
        print('>>> options.REMOVE_ITALICS = ' + str(options.REMOVE_ITALICS))               
        return(0)
        
    def onRemoveHF(self):
        print('\n>>> In on Remove hyperlink formatting...' + str(self.removehf.get()))
        
        if self.removehf.get() == True:
            options.REMOVE_HYPERLINK_FORMAT = True
        else: 
            options.REMOVE_HYPERLINK_FORMAT = False
        
        print('>>> options.REMOVE_HYPERLINK_FORMAT = ' + str(options.REMOVE_HYPERLINK_FORMAT))        
        return(0)
        
    def onDeleteHL(self):
        print('\n>>> In on Delete hyperlinks...' + str(self.deletehl.get()))
        
        if self.deletehl.get() == True:
            options.DELETE_HYPERLINKS = True
        else:
            options.DELETE_HYPERLINKS = False
        
        print('>>> options.DELETE_HYPERLINKS = ' + str(options.DELETE_HYPERLINKS)) 

    def onUseTJ(self):
        print('\n>>> In on use text justify...' + str(self.usetj.get()))
        
        if self.usetj.get() == True:
            options.USE_TEXT_JUSTIFY = True
        else:
            options.USE_TEXT_JUSTIFY = False
        
        print('>>> options.REMOVE_HANGING_INDENTS = ' + str(options.USE_TEXT_JUSTIFY))               
        return(0)           
        
        return(0)        
          
    def onOK(self):     
    
        # save all settings
        if self.save.get() == True:
            prefs = self.bk.getPrefs()
            prefs['remove_hanging_indents'] = self.removehi.get()
            prefs['remove_italics'] = self.removeif.get()
            prefs['remove_hyperlink_format'] = self.removehf.get()
            prefs['delete_hyperlinks'] = self.deletehl.get()
            prefs['use_text_justify'] = self.usetj.get()   
            self.bk.savePrefs(prefs)      
            
        self.parent.destroy() 
        self.quit()
            
    def onCancel(self):
        options.SYS_EXIT = True
        self.parent.destroy()  
       
  