#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#

import os, sys, shutil, inspect
from tempfile import mkdtemp 
from cutils import *
from dialog import UserDialog
import options
from updater import updateCheck
import tkinter as tk


SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=3651030&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
    
def runUserDialog(bk):
    root = tk.Toplevel()
    root.title('ZoteroBibRefsImport')
    root.option_add('*font', 'Arial -12')
    root.resizable(width=True, height=True)
    if not sys.platform.startswith('darwin'):
        img = tk.Image('photo', file=os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'images/penwrench.png'))
        root.tk.call('wm','iconphoto', root._w, img)
    UserDialog(root, bk).pack(fill="both", expand=True)
    root.mainloop()
    return(0)        
    
# borrowed from DiapDealer with thanks...    
def is_connected():
    try:
        sock = socket.create_connection(('8.8.8.8', 53), 1)
        sock.close()
        return True
    except:
        pass
        
    return False        
	
def run(bk):  
    print('Python version: ', sys.version, '\n')
    print('Running ZoteroBibRefsImport...Please wait\n') 
    
    if is_connected:
        # check for new plugin versions
        latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
        if latest_version and latest_version != installed_version:
            options.NEW_PLUGIN_VERSION = True
            options.MSG_NEW_VERSION_AVAILABLE = "A new plugin version is available on MR - v" + latest_version
    
    prefs = bk.getPrefs()
    if 'user_dir_path' not in prefs:
        prefs['user_dir_path'] = os.path.expanduser('~')
    if 'remove_hanging_indents' not in prefs:
        prefs['remove_hanging_indents'] = False    
    if 'remove_italics' not in prefs:
        prefs['remove_italics'] = False
    if 'remove_hyperlink_format' not in prefs:
        prefs['remove_hyperlink_format'] = False  
    if 'delete_hyperlinks' not in prefs:
        prefs['delete_hyperlinks'] = False      
    if 'use_text_justify' not in prefs: 
        prefs['use_text_justify'] = False    
        bk.savePrefs(prefs)
      
    # create a work directory
    WDIR = mkdtemp()  
    options.WDIR = WDIR
	
    # get the user selected Sigil file name
    try:
        s_id, selected_file = getUserSelectedFileName(bk, WDIR)
    except:
        pass
        
    # exit on error
    if options.SYS_EXIT == True:
        return(-1) 
       
    # choose and import the Zotero file
    new_zot_file = importZoteroFile(bk, WDIR)
    # exit on error
    if options.SYS_EXIT == True:
        shutil.rmtree(WDIR, ignore_errors=True)
        return(0)
    
    # some formatting options for the user
    runUserDialog(bk)
 
    # safe exit from dialog on Cancel/Exit
    if options.SYS_EXIT == True:
        shutil.rmtree(WDIR, ignore_errors=True)
        return(0)
    
    # format imported Zotero refs file.
    formatZoteroRefsFile(WDIR, new_zot_file) 
    if options.SYS_EXIT == True:
        shutil.rmtree(WDIR, ignore_errors=True)
        return(-1)    
    
    # write/append Zotero refs data to the selected Sigil file
    copyRefs2SelectedSigilFile(WDIR, new_zot_file, selected_file) 
        
    # prettify selected Sigil file.
    prettifyXHTMLFile(WDIR, selected_file)	
        
    # write Sigil selected file back to the epub
    writeFile2Epub(bk, WDIR, s_id, selected_file)	
    
    print('\n -- Completed SUCCESSFULLY...')
    # remove the temp work dir
    shutil.rmtree(WDIR, ignore_errors=True)
        
    return(0)                

def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())        