#!/usr/bin/env python2

__license__   = 'GPL v3'
__copyright__ = '2018, Steven Dick <kg4ydw@gmail.com>'

class PropIndex:
    use=0
    efilter=1
    wlabel=2
    colname=3
    priority=4
    overwrite=5
    hidden = 6
class EntityIndex:  # "tags"
    use=0
    wlabel=1
    ylabel=2
    hidden=3
class IdIndex:
    dispenable=0
    description=1
    idtag=2
    template=3
    regex=4
    importids=5
    search=6
    #searchpriority=7  # not used!
    pastepriority=8
    hidden = 9

class DefaultModel:
  # don't allow these properties, they need special handling
  rejectprops = frozenset((
    'P179', # series
    'P50', # author
    'P1476', # title
    'P18', # image url
    'P212', # ISBN13
    'P957', # ISBN10
    ))
  # include a few default properties and tags
  # include IDs handled by the wikidata metadata plugin
  # * later, copy new ones there and allow this preference to disble old ones
  # copy these to prefs if prefs is empty
  # copy new parts of these to prefs if arrays are longer

  # template used to create and expand entities not in the defaults
  # note that ids[9] and properties[6] are not in model!
  defOptTemplate = {
      'properties': [ False, False, "", "", 1, False, False],
      'tags': [ False, "", "", False ],
      'ids': [ False, "", "", "", "", False, False, 10, 10, False]
  }
  modelHideCol = {
      'properties': PropIndex.hidden,
      'tags': EntityIndex.hidden,
      'ids': IdIndex.hidden
      }
  defaults = {
    'options' : {
        'deflang' : 'en',
        'limit' : 1000,
        'debugquery': False,
        'selectMode' : 0,
        'pubdateMode' : 0,
        'ptconfirmdel' : True,
        'preconvert': True,
        'enableSeries': False,
        'seriesMode': 0, # ifempty
        'series1col': 'series',
        'series2col': None, # or null string
        'seriesOrder': 0, # wikidata order
	'mark_updated': False,
	'mark_newtags': False,
	'mark_errors': True,
        },
    # these are mostly disabled by default, especially custom columns
    # publication date and series should get their own special handling code
      ## use, efilter, wikidata-label, column, priority, overwrite, hidden
    'properties' : {
        'P31' : [ 0, 1, 'instance of', 'tags', 0, 0 ],
        'P577' : [ 5, 0, 'publication date', 'pubdate', 1, 0],
        'P571' : [ 0, 0, 'inception', 'pubdate', 10, 0 ],
        'P136' : [ 0, 1, 'genre' , '#genre', 1, 0 ],
        'P110' : [ 0, 0, 'illustrator', '#illustrator', 1 , 0],
        #'P179' : [ 0, 0, 'series' ...won't work for series index ]
        },
    # these are really meant to be examples, user should heavily modify these preferences
      ##  'use', 'wikidata label', 'your label', hidden
    'tags' : {
        'Q571' : [ 0, 'book', 'book' ],
        'Q47461344' : [ 0, 'written work', 'book' ], # may not be strictly correct
        'Q732577' : [ 0, 'publication', 'book' ],
        'Q7725634' : [ 2, 'literary work', 'literature' ],
        'Q482' : [ 2, 'poetry genre', 'poem' ],
        'Q5185279' : [ 2, 'poem' ,'poem' ],
        'Q25379' : [ 2, 'play' ,'play' ],
        'Q8261' : [ 2, 'novel', 'fiction' ],
        'Q1347298' : [ 2, 'serial fiction', 'fiction' ],
        'Q319226' : [ 2, 'adventure novel', 'fiction' ],
        'Q12132683' : [ 2, 'science fiction novel', 'science fiction' ],
        'Q10992055'  : [ 2, 'speculative fiction novel', 'science fiction' ],
        'Q24925' : [ 2, 'science fiction' ,'science fiction' ],
        'Q20667180' : [ 2, 'horror novel', 'horror' ],
        'Q1543778' : [ 2, 'horror and terror', 'horror' ]
        },
      ## display enabled, description, IDtag, URL template, regex match, import, search, id search order, pasteoder, hidden
    # wdid is omitted here because it is always enabled and used first
    'ids' : {
        'P2034' : [ True, 'Project Gutenberg ebook ID', 'gutenberg',
                    'https://www.gutenberg.org/ebooks/%s',
                    'https?.//www.gutenberg.org/ebooks/(?P<id>\d+)', True, True, 1, 1],
        'P1274' : [ False, 'isfdb title ID', 'isfdb' ,
                    'http://www.isfdb.org/cgi-bin/title.cgi?%s',
                    'http://www.isfdb.org/cgi-bin/title.cgi\?([1-9]\d{0,6})', False, False, 5, 5]
        }
    }

  def __init__(self, prefs):
      # XXD this is all about expanding existing optons saved to match defaults
      # initialize prefs with defaults if empty
      print("Initializing wikidata gui preferences")
      if 'options' not in prefs:
            for key in self.defaults:
                prefs[key] = self.defaults[key]
      else:
          # even if prefs is not empty, check to see if it needs expanding
          # copy options values for expanded items in defaults
          for itemkey in self.defaults['options']:
              if itemkey not in prefs['options']:
                  prefs['options'][itemkey] = self.defaults['options'][itemkey]
          for dataset in self.defOptTemplate:
              for itemkey in self.defaults[dataset]:
                  if itemkey in prefs[dataset] and len(prefs[dataset][itemkey]) < len(self.defaults[dataset][itemkey]):
                      print("update prefs %s,%s += %d"%(dataset,itemkey,len(self.defaults[dataset][itemkey])-len(prefs[dataset][itemkey]) ))
                      # copy added defaults to end of prefs
                      pfxlen = len(prefs[dataset][itemkey])
                      prefs[dataset][itemkey] += self.defaults[dataset][itemkey][pfxlen:]
              # match everything against defaults templates
              for itemkey in prefs[dataset]:
                  if len(prefs[dataset][itemkey]) < len(self.defOptTemplate[dataset]):
                      pfxlen = len(prefs[dataset][itemkey])
                      prefs[dataset][itemkey] += self.defOptTemplate[dataset][pfxlen:]
