#

__license__   = 'GPL v3'
__copyright__ = '2018, Steven Dick <kg4ydw@gmail.com>'


from PyQt5 import QtGui, QtCore
from PyQt5.QtWidgets import QAbstractItemView, QDialog
from PyQt5.Qt import QMenu, QToolButton, QPixmap, Qt, QDialog, QProgressDialog, QWidget

from calibre_plugins.wikidata_gui.dictdicttable import StatusModel

from calibre_plugins.wikidata_gui.importbooks_ui import Ui_importBooksDialog

from calibre_plugins.wikidata_gui.common_utils import get_icon

class ImportBooks(object):
    def __init__(self, gui, title, booktable, columns=None, colmap=None, readonly=set()):
        self.gui = gui
        if not columns: columns = ('author','title')
        if not colmap: colmap={}
        colmap['key'] = 'wdid'
        marked_ids = self.gui.current_db.data.marked_ids.copy()
        # let user select / reject books to import
        # accept or cancel
        #print("Got %d books"%len(booktable))
        # match booktable to books in library
        db = self.gui.current_db.new_api
        # XXG progress?
        for bookid in booktable:
            book = booktable[bookid]
            # get the easy pickings
            book['match'] = db.find_identical_books( book['mi'])
            book['status'] = len(book['match'])
            if book['status']>2: book['status'] = 2 # 0, 1, multiple
            book['mi'].set_identifier('wd',bookid) # save for later
            #print(book)
            #print("mi=%s"%book['mi'])
        if marked_ids: self.gui.current_db.data.set_marked_ids(marked_ids)
        model = StatusModel(booktable, columns=columns, colmap=colmap, exclude=('mi', 'match', 'authorset'), readonly=readonly )
        proxymodel = QtCore.QSortFilterProxyModel(self.gui)
        proxymodel.setSourceModel(model)
        proxymodel.setDynamicSortFilter(False)
        dialog = Importbooksdialog(gui, title, proxymodel)
        answer = dialog.exec_()
        # accept or reject
        if answer == QDialog.Accepted:
            # XXX insert books with progress bar
            ## XXX only use author/title/wdid, redownload the rest separately
            ## XXX should ignore the built mi field when the user edited
            count = 0
            if not marked_ids: marked_ids={}
            for book in booktable.keys():
                if booktable[book]['status']==3:
                    id = self.gui.current_db.import_book(booktable[book]['mi'],[])
                    marked_ids[id] = 'new'
                    count += 1
            self.gui.current_db.commit()
            
            print("Added %d books"%count)
        if (marked_ids): self.gui.current_db.data.set_marked_ids(marked_ids)


class  Importbooksdialog(QDialog):
    def addImportBooks(self):
        self.setBookStatus(3)
    def clearImportBooks(self):
        self.setBookStatus(0)
    def importMeta(self):
        # XXX is this a good idea without the user previewing it??
        # merge series data and wikidata identifier?
        #for index in selected rows:
        #   row = index.datarow()
        #   for m in row.matches:
        #       m.mergemdatadata(row.mi)
        pass
    def setBookStatus(self, value):
        view = self.ui.bookTableView
        m = view.model()
        s = set()
        for index in view.selectedIndexes():
            row = index.row()
            if row not in s:
                m.setData(m.index(index.row(), 0), value)
                s.add(row)

    def __init__(self, gui, title, proxymodel):
        QDialog.__init__(self)
        self.gui = gui
        self.ui = Ui_importBooksDialog()
        self.ui.setupUi(self)
        # allow user to select books to import
        self.ui.addButton.clicked.connect(self.addImportBooks)
        try:
            self.ui.addButton.setIcon(get_icon('add_book.png'))
        except:
            pass  # ono! we have to use a text label
        self.ui.clearButton.clicked.connect(self.clearImportBooks)
        try:
            self.ui.clearButton.setIcon(get_icon('edit-clear.png'))
        except:
            pass
        # XXX self.ui.importMetadata.clicked.connect(self.importMeta)
        btv = self.ui.bookTableView
        btv.setModel(proxymodel)
        # resize entire dialog to fit
        self.adjustSize()

# XXX missing features
# book button icons:
# import: metadata.png
#
# overall buttons:
# generate series index: button/menu? (in selected books only?)
#   series increment?
#   flatten indexes (int->float by spreading)

