#!/usr/bin/env python

__license__   = 'GPL v3'
__copyright__ = '2018, Steven Dick <kg4ydw@gmail.com>'


import calibre.customize
from calibre.customize import InterfaceActionBase

class WikidataGUIBase(InterfaceActionBase):
    name        = 'Wikidata gui'
    description = "Advanced wikidata metadata manager"
    supported_platforms     = ['windows', 'osx', 'linux']
    author      = "Steven Dick"
    version     = (1,3,0)
    # requires PyQt5
    minimum_calibre_version = (3, 0, 0)

    actual_plugin = 'calibre_plugins.wikidata_gui.ui:WikidataAction'

    def is_customizable(self):
        return True

    def config_widget(self):
        from calibre_plugins.wikidata_gui.config import ConfigWidget
        if self.actual_plugin_:
            return ConfigWidget(self.actual_plugin_)

    def save_settings(self, config_widget):
        config_widget.save_settings()
