# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2016, 2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.11"   # Miscellany

from PyQt5.Qt import QMenu, QDialog, QIcon, QAction

from functools import partial

from calibre.constants import DEBUG
from calibre.gui2.actions import InterfaceAction

from polyglot.builtins import as_unicode

from calibre_plugins.drop_search_results.common_utils import set_plugin_icon_resources, get_icon,create_menu_action_unique
from calibre_plugins.drop_search_results.drop_widget_dialog import DropSearchResultsDialog

PLUGIN_ICONS = ['images/drop.png']

#-------------------------------------------------------------------------------------------
class ActionDropSearchResults(InterfaceAction):

    name = 'Drop Search Results'
    action_spec = ('DSR','images/drop.png', "Drag search result file paths and Drop them to automatically mark and select those books within Calibre.", None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 9
    popup_type = 1

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def genesis(self):
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )

        self.menu = QMenu(self.gui)
        self.build_menus(self.gui)

        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.drag_and_drop_control)

        self.gui.keyboard.finalize()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def initialization_complete(self):
        self.guidb = self.gui.library_view.model().db
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def library_changed(self,guidb):
        self.guidb = self.gui.library_view.model().db
        try:
            self.dropsearchresultsdialog.close()
        except:
            pass
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def build_menus(self,gui):
        # Create a simple menu so there can be a Preferences > Keyboard shortcut.
        # Not a menu action that is unique since the main icon already has that action, so no menu will be shown, but the shortcut is enabled anyway.

        self.gui = gui

        m = self.menu
        m.clear()
        unique_name = "Drop Search Results"
        shortcut_name = "Drop Search Results"
        create_menu_action_unique(self, m, 'Drop Search Results', 'images/drop.png',shortcut=None,
                                                      triggered=partial(self.drag_and_drop_control), is_checked=None,
                                                      shortcut_name=shortcut_name,unique_name=unique_name, favourites_menu_unique_name=unique_name)

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def drag_and_drop_control(self):
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.dropsearchresultsdialog = DropSearchResultsDialog(self.gui,self.qaction.icon(),self.process_file_paths)
        self.dropsearchresultsdialog.show()
        self.guidb = self.gui.library_view.model().db
   #-----------------------------------------------------------------------------------------
    def process_file_paths(self,book_list):

        self.dropsearchresultsdialog.close()

        book_dict = {}
        s_true = 'true'
        for row in book_list:
            id,path = row
            if DEBUG: print(as_unicode(id),'   ',path)
            key = int(id)
            book_dict[key] = s_true

        marked_ids = dict.fromkeys(book_dict, s_true)
        self.guidb.set_marked_ids(marked_ids)
        self.gui.search.clear()
        self.gui.search.set_search_string('marked:true')

        del book_list
        del book_dict
#-------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#END of ui.py