# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.2.3"   #  Miscellany

from calibre.customize import InterfaceActionBase

class ActionAuthorBookCountHierarchy(InterfaceActionBase):

    name                    = 'Author Book Count Hierarchy'
    description             = 'Creates a Hierarchy of Author Book Counts designed for perusing complex Co-Author relationships, not just simple ABC counts for a single Author.'
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 2, 3)
    minimum_calibre_version = (4, 6, 0)

    actual_plugin           = 'calibre_plugins.author_book_count_hierarchy.ui:AuthorBookCountHierarchyUpdate'

    gui_name = "author_book_count_hierarchy"

    def is_customizable(self):
        return False
#END of __init__py