# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "2.0.38"  # Miscellany

from PyQt5.Qt import QMenu, QDialog, QIcon, QAction, QSize, QWidget, QRegularExpression, QApplication

import os, sys
import apsw

from calibre import isbytestring
from calibre.constants import filesystem_encoding, iswindows, DEBUG
from calibre.gui2 import error_dialog, info_dialog, Dispatcher
from calibre.gui2.actions import InterfaceAction
from calibre.utils.config import config_dir, JSONConfig

from functools import partial
import subprocess
import time
from time import sleep
import zipfile

from polyglot.builtins import as_unicode

from calibre_plugins.consolidate_all_library_metadata.config import prefs
from calibre_plugins.consolidate_all_library_metadata.common_utils import set_plugin_icon_resources, get_icon, get_pixmap, get_local_images_dir, create_menu_action_unique
from calibre_plugins.consolidate_all_library_metadata.calm_dialog import CALMDialog
from calibre_plugins.consolidate_all_library_metadata.jobs import start_threaded_calm_consolidation, start_threaded_calm_derive_genres
from calibre_plugins.consolidate_all_library_metadata.ui_toastdialog import UIToastDialog


PLUGIN_ICONS = ['images/calmicon.png', 'images/calmsmallicon.png']

MOST_CURRENT_VERSION_OF_METADATA_TOOLS = as_unicode(2)

selected_books_list = []

my_count_of_total_currently_running_jobs = 0

class ActionConsolidateAllLibraryMetadata(InterfaceAction):

    name = 'Consolidate All Library Metadata'
    action_spec = ('CALM','images/calmicon.png', "Consolidate a Snapshot of All Metadata, including Custom Columns, from All of the Books in All of your Libraries for Review, Analysis and Standardization using Powerful Tools; Shuffle Books Among your Calibre Library Ecosystem; Perform Centralized Library Maintenance.", None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 9
    popup_type = 1

    #-----------------------------------------------------------------------------------------
    def genesis(self):

        self.is_library_selected = True

        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )
        self.menu = QMenu(self.gui)
        self.build_menus(self.gui)

        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.init_calm_dialog)
        self.gui.keyboard.finalize()

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def build_menus(self,gui):
        self.gui = gui
        m = self.menu
        m.clear()
        unique_name = "CALM"
        shortcut_name = "CALM"
        create_menu_action_unique(self, m, 'CALM', 'images/calmicon.png',shortcut=None,
                                                      triggered=partial(self.init_calm_dialog), is_checked=None,
                                                      shortcut_name=shortcut_name,unique_name=unique_name,
                                                      favourites_menu_unique_name=unique_name)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def initialization_complete(self):

        from calibre.gui2.ui import get_gui
        self.maingui = get_gui()

        self.guidb = self.maingui.library_view.model().db

        global my_count_of_total_currently_running_jobs
        my_count_of_total_currently_running_jobs = 0

        global selected_books_list
        selected_books_list[:] = []   #clear it

        if DEBUG:  print("CALM: initialization_complete............")

        self.my_jobs_dialog_object = "unknown"
        try:
            sre = QRegularExpression(".+")
            answer  = self.maingui.findChildren(QWidget,sre)
            if answer:
                if isinstance(answer,list):
                    for item in answer:
                        if item:
                            s = as_unicode(item)
                            #~ print(s)
                            if "JobsDialog" in s:
                                self.my_jobs_dialog_object = item
                                break
        except:
            self.my_jobs_dialog_object = "unknown"

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def library_changed(self,guidb):

        self.guidb = self.maingui.library_view.model().db

        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))

        try:
            self.calm_dialog.close()
        except:
            pass

        try:
            self.ui_toast_dialog.close()
        except:
            pass

        global my_count_of_total_currently_running_jobs
        my_count_of_total_currently_running_jobs = 0

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def init_calm_dialog(self):

        self.guidb = self.maingui.library_view.model().db

        my_db = self.guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        try:
            self.ui_toast_dialog.close()
        except:
            pass

        if path.count("/CALM") > 0:
            if as_unicode(prefs['CALM_DB_VERSION_METADATA_TOOLS_DB']) != MOST_CURRENT_VERSION_OF_METADATA_TOOLS:
                self.create_ui_toast_dialog(2)
                return

        try:
            self.calm_dialog.close()
        except:
            pass

        global my_count_of_total_currently_running_jobs
        if my_count_of_total_currently_running_jobs > 0 :
             return error_dialog(self.maingui, _('CALM Has a Running Job'),_('Sorry, but the currently running CALM job is already using the identical files that you wish to use.  Please wait until that job finishes before continuing.'), show=True)
        else:
            my_count_of_total_currently_running_jobs = 0  #no negatives
            self.create_ui_toast_dialog(0)
            self.qaction.setIcon(get_icon(PLUGIN_ICONS[1]))
            self.calm_dialog = CALMDialog(self.maingui,self.qaction.icon(),self.guidb,self.plugin_path,self.calm_dialog_restart_immediately,self.calm_consolidation_job_control,self.calm_derivegenres_job_control)
            self.calm_dialog.show()
            self.ui_toast_dialog.close()
            self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
            try:
                self.maingui.library_view.model().stop_metadata_backup()
            except:
                pass
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def calm_dialog_restart_immediately(self):
        self.calm_dialog.close()
        self.init_calm_dialog()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def calm_consolidation_job_control(self,target_db, param_dict):

        try:
            self.calm_dialog.close()
        except:
            pass

        try:
            global my_count_of_total_currently_running_jobs
            my_count_of_total_currently_running_jobs = my_count_of_total_currently_running_jobs + 1
            start_threaded_calm_consolidation(self, target_db, param_dict, Dispatcher(self.calm_finish_consolidation))
            msg = ('CALM Consolidation Job was submitted')
            self.maingui.status_bar.showMessage(msg)
        except Exception as e:
            my_count_of_total_currently_running_jobs = my_count_of_total_currently_running_jobs - 1
            msg = "Sorry, but the Job Submission failed for this reason: " + unicode(e)
            return error_dialog(self.maingui, _('CALM Consolidation Job Submission Error'),_(msg), show=True)

        if self.my_jobs_dialog_object:
            if self.my_jobs_dialog_object != "unknown":
                try:
                    self.my_jobs_dialog_object.show()
                except:
                    pass

    #-----------------------------------------------------------------------------------------
    def calm_finish_consolidation(self, job):

        global my_count_of_total_currently_running_jobs
        my_count_of_total_currently_running_jobs = my_count_of_total_currently_running_jobs - 1

        if job.failed:
            self.maingui.job_exception(job, dialog_title=_('CALM Consolidation Job Failed...'))

        self.maingui.status_bar.show_message(_('CALM Consolidation Job Has Finished'), 5000)

        try:
            del job
        except:
            pass

        #~ info_dialog(self.maingui, _("CALM"), _("You may switch to the Consolidated Target Library now."), show=True)

    #-----------------------------------------------------------------------------------------
    def calm_derivegenres_job_control(self, param_dict):

        try:
            self.calm_dialog.close()
        except:
            pass
        try:
            global my_count_of_total_currently_running_jobs
            my_count_of_total_currently_running_jobs = my_count_of_total_currently_running_jobs + 1
            db = self.maingui.current_db.new_api
            work_book_ids_frozenset = db.all_book_ids()
            book_ids = []
            for row in work_book_ids_frozenset:      #ALL books in Target
                book_ids.append(row)
            #END FOR
            results_status = []
            start_threaded_calm_derive_genres(self,self.maingui, param_dict, book_ids, results_status, Dispatcher(self.calm_finish_derive_genres))
            msg = ('CALM Derive Genres Job was submitted')
            self.maingui.status_bar.showMessage(msg)
        except Exception as e:
            my_count_of_total_currently_running_jobs = my_count_of_total_currently_running_jobs - 1
            msg = "Sorry, but the Job Submission failed for this reason: " + unicode(e)
            return error_dialog(self.maingui, _('CALM Derive Genres Job Submission Error'),_(msg), show=True)

        if self.my_jobs_dialog_object:
            if self.my_jobs_dialog_object != "unknown":
                try:
                    self.my_jobs_dialog_object.show()
                except:
                    pass

    #-----------------------------------------------------------------------------------------
    def calm_finish_derive_genres(self, job):

        global my_count_of_total_currently_running_jobs
        my_count_of_total_currently_running_jobs = my_count_of_total_currently_running_jobs - 1

        self.force_refresh_of_cache()

        if job.failed:
            self.maingui.job_exception(job, dialog_title=_('CALM Derive Genres Job Failed...'))

        self.maingui.status_bar.show_message(_('CALM Derive Genres Job Has Finished'), 10000)

        try:
            del job
        except:
            pass

  #-------------------------------------------------------------------------------------------------------------------------------------
    def create_ui_toast_dialog(self,msg_num):

        #msg_num = 0 : CALM...
        #msg_num = 1 : Job Parameters are Being Validated...


        self.ui_toast_dialog = UIToastDialog(self.maingui,self.qaction.icon(),msg_num)

        self.ui_toast_dialog.show()

        self.ui_toast_dialog.setModal(True)

        self.ui_toast_dialog.update()

        QApplication.instance().processEvents()

    #-------------------------------------------------------------------------------------------------------------------------------------
    def create_ui_toast_dialog_for_jobs(self):
        #msg_num = 1 : Job Submitted

        self.create_ui_toast_dialog(1)
        sleep(0.75)
        self.ui_toast_dialog.close()

    #-------------------------------------------------------------------------------------------------------------------------------------
    def force_refresh_of_cache(self):
        db = self.maingui.current_db.new_api
        frozen = db.all_book_ids()
        books = list(frozen)
        db.reload_from_db(clear_caches=False)
        self.maingui.library_view.model().refresh_ids(books)
        self.maingui.tags_view.recount()
#--------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#END of ui.py