# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "2.0.34"  # Technical changes after Python 3.8 testing with Calibre 4.99.2

from PyQt5.Qt import (Qt, QDialog, QTableWidgetItem, QIcon, QByteArray, QSize)

from calibre.constants import DEBUG
from calibre.gui2 import question_dialog, error_dialog, info_dialog, gprefs
from calibre.utils.icu import sort_key

from polyglot.builtins import as_unicode, iteritems, map, range, unicode_type

from calibre_plugins.consolidate_all_library_metadata.cc_activation_list_editor_ui import Ui_CCActivationListEditor


class SourceLibraryCustomColumnTableWidgetItem(QTableWidgetItem):

    def __init__(self, txt):
        QTableWidgetItem.__init__(self, txt)
        self.initial_value = txt
        self.current_value = txt
        self.previous_value = txt

    def data(self, role):
        return self.current_value
        #~ if role == Qt.DisplayRole:
            #~ return self.current_value
        #~ elif role == Qt.EditRole:
            #~ return self.current_value
        #~ else:
            #~ return QTableWidgetItem.data(self, role)

    def setData(self, role, data):
        role = Qt.DisplayRole
        #~ if role == Qt.EditRole:
            #~ self.current_value = self.initial_value
        QTableWidgetItem.setData(self, role, data)

    def text(self):
        return self.initial_value

    def initial_text(self):
        return self.initial_value

    def previous_text(self):
        return self.initial_value

    def setText(self, txt):
        QTableWidgetItem.setText(self.initial_value)

    def __ge__(self, other):
        return sort_key(unicode_type(self.text())) >= sort_key(unicode_type(other.text()))

    def __lt__(self, other):
        return sort_key(unicode_type(self.text())) < sort_key(unicode_type(other.text()))

class ActivateForCALMTableWidgetItem(QTableWidgetItem):

    def __init__(self, txt):
        QTableWidgetItem.__init__(self, txt)
        self.initial_value = txt
        self.current_value = txt
        self.previous_value = txt

    def data(self, role):
        if role == Qt.DisplayRole:
            return self.current_value
        elif role == Qt.EditRole:
            return self.current_value
        else:
            return QTableWidgetItem.data(self, role)

    def setData(self, role, data):
        if role == Qt.EditRole:
            self.previous_value = self.current_value
            self.current_value = data
        QTableWidgetItem.setData(self, role, data)

    def text(self):
        return self.current_value

    def initial_text(self):
        return self.initial_value

    def previous_text(self):
        return self.previous_value

    def setText(self, txt):
        self.current_value = txt
        QTableWidgetItem.setText(txt)

    def __ge__(self, other):
        return sort_key(unicode_type(self.text())) >= sort_key(unicode_type(other.text()))

    def __lt__(self, other):
        return sort_key(unicode_type(self.text())) < sort_key(unicode_type(other.text()))


class CCActivationListEditor(QDialog, Ui_CCActivationListEditor):

    def __init__(self, window, cat_name, dummy, data, sorter,guidb,my_db,my_cursor):
        QDialog.__init__(self, window)
        Ui_CCActivationListEditor.__init__(self)
        self.setupUi(self)

        self.guidb = guidb

        self.my_db = my_db
        self.my_cursor = my_cursor

        self.update_dict = {}  #~ self.s_key_dict[s_key] = s_key_real

        # Put the category name into the title bar
        t = self.windowTitle()
        self.setWindowTitle(t + ' (' + cat_name + ')')
        # Remove help icon on title bar
        icon = self.windowIcon()
        self.setWindowFlags(self.windowFlags()&(~Qt.WindowContextHelpButtonHint))
        self.setWindowIcon(icon)

        # Get saved geometry info
        try:
            self.table_column_widths = gprefs.get('calm_cc_activation_list_editor_table_widths', None)
        except:
            pass

        # initialization
        self.to_update_in_cc_activation_table_list = []
        self.all_cc_activation_list = []
        self.activations_dict = {}
        self.s_key_dict = {}
        self.update_dict = {}

        for row in data:
            #~ if DEBUG:  print("init:  data row is: ", as_unicode(row))
            source_library,source_library_cc_label,activate_for_calm = row
            s_key = source_library + "-" + source_library_cc_label
            self.all_cc_activation_list.append(row)
            self.activations_dict[s_key] = activate_for_calm
        #END FOR

        # Set up the column headings
        self.down_arrow_icon = QIcon(I('arrow-down.png'))
        self.up_arrow_icon = QIcon(I('arrow-up.png'))
        self.blank_icon = QIcon(I('blank.png'))

        self.table.setColumnCount(2)

        self.name_col = QTableWidgetItem(_('Source Library-Custom Column Combinations'))
        self.table.setHorizontalHeaderItem(0, self.name_col)
        self.name_col.setIcon(self.up_arrow_icon)

        self.active_indicator_col = QTableWidgetItem(_('Activate for Generation? [1 = True, Blank or 0 = False]'))
        self.table.setHorizontalHeaderItem(1, self.active_indicator_col)
        self.active_indicator_col.setIcon(self.blank_icon)

        # Capture clicks on the horizontal header to sort the table columns
        hh = self.table.horizontalHeader()
        hh.setSectionsClickable(True)
        hh.sectionClicked.connect(self.header_clicked)
        hh.sectionResized.connect(self.table_column_resized)
        self.name_order = 0

        select_item = None
        self.table.setRowCount(len(self.all_cc_activation_list))
        self.all_cc_activation_list.sort()
        row_number = 0
        for row in self.all_cc_activation_list:
            source_library,source_library_cc_label,activate_for_calm = row
            s_key_real = source_library + "-" + source_library_cc_label
            s_key = as_unicode(source_library) + as_unicode("-") + as_unicode(source_library_cc_label)   # str is better than unicode for the Qt overloaded call...
            s_key = as_unicode(s_key)
            self.s_key_dict[s_key] = s_key_real    # to revert later to the real unicode version...
            item = SourceLibraryCustomColumnTableWidgetItem(s_key)
            item.setFlags(item.flags() | Qt.ItemIsSelectable)        # original
            self.table.setItem(row_number, 0, item)
            activate_for_calm = self.activations_dict[s_key]
            item = ActivateForCALMTableWidgetItem(activate_for_calm)
            #~ item.setFlags(item.flags() | Qt.ItemIsSelectable | Qt.ItemIsEditable)
            item.setFlags(item.flags() | Qt.ItemIsEditable)
            self.table.setItem(row_number, 1, item)
            row_number = row_number + 1
        #END FOR

        # Scroll to the selected item if there is one
        if select_item is not None:
            self.table.setCurrentItem(select_item)

        self.change_button.clicked.connect(self.add_cc_activation_to_update_list)
        self.buttonBox.accepted.connect(self.accepted)

        try:
            geom = gprefs.get('calm_cc_activation_list_editor_dialog_geometry', None)
            if geom is not None:
                self.restoreGeometry(QByteArray(geom))
            else:
                self.resize(self.sizeHint()+QSize(150, 100))
        except:
            pass

    def table_column_resized(self, col, old, new):
        self.table_column_widths = []
        for c in range(0, self.table.columnCount()):
            self.table_column_widths.append(self.table.columnWidth(c))

    def resizeEvent(self, *args):
        QDialog.resizeEvent(self, *args)
        if self.table_column_widths is not None:
            for c,w in enumerate(self.table_column_widths):
                self.table.setColumnWidth(c, w)
        else:
            # the vertical scroll bar might not be rendered, so might not yet
            # have a width. Assume 25. Not a problem because user-changed column
            # widths will be remembered
            w = self.table.width() - 25 - self.table.verticalHeader().width()
            w /= self.table.columnCount()
            for c in range(0, self.table.columnCount()):
                self.table.setColumnWidth(c, w)

    def save_geometry(self):
        gprefs['calm_cc_activation_list_editor_table_widths'] = self.table_column_widths
        gprefs['calm_cc_activation_list_editor_dialog_geometry'] = bytearray(self.saveGeometry())

    def accepted(self):
        self.save_geometry()
        self.update_cc_activation_to_table_source_custom_columns()

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def update_cc_activation_to_table_source_custom_columns(self):

        #~ if DEBUG:  print("Entering  update_cc_activation_to_table_source_custom_columns(self)...")

        #~ for s_key,activate_for_calm in self.update_dict.iteritems():     # self.update_dict[s_key] = active_indicator
        for s_key,activate_for_calm in iteritems(self.update_dict):     # self.update_dict[s_key] = active_indicator
            if DEBUG: print("s_key: ", s_key)
            #~ n = s_key.rfind("|||")
            #~ s_key1 = s_key[0:n+1]
            #~ if DEBUG:  print("s_key1: ", s_key1)
            if DEBUG: print(as_unicode(activate_for_calm))
            if not s_key in self.s_key_dict:
                if DEBUG: print("key error:    s_key is not in self.s_key_dict: ", s_key)
                continue
            s_real_key = self.s_key_dict[s_key]
            if DEBUG: print("s_real_key: ", s_real_key)
            s_split = s_real_key.split("-")
            source_library = s_split[0]
            source_library_cc_label = s_split[1]
            del s_split
            try:
                # ensure user set either a 1 or 0...and not "one" or "zero"...
                s = as_unicode(activate_for_calm)
                if not s.isdigit():
                    continue
                if activate_for_calm >= 1:
                    activate_for_calm = 1
                else:
                    activate_for_calm = 0
            except Exception as e:
                if DEBUG: print("bad activate_for_calm: ", s_real_key, source_library,source_library_cc_label, as_unicode(activate_for_calm))
                if DEBUG: print("exception for activate_for_calm: ", as_unicode(e))
                continue

            if DEBUG: print("Now Updating metadata.db: ", s_real_key, source_library,source_library_cc_label, as_unicode(activate_for_calm))
            self.my_cursor.execute("begin")
            mysql = "UPDATE  _source_library_custom_columns  SET activate_for_calm = ? WHERE source_library = ? AND source_library_cc_label = ?"
            self.my_cursor.execute(mysql,(activate_for_calm,source_library,source_library_cc_label))
            self.my_cursor.execute("commit")
        #END FOR

        self.my_db.close()

        del self.s_key_dict
        del self.update_dict
        del self.to_update_in_cc_activation_table_list
        del self.all_cc_activation_list
        del self.activations_dict

        self.close()

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------

    def add_cc_activation_to_update_list(self):

        mappings = self.table.selectedItems()
        if not mappings:
            error_dialog(self, _('No items selected'),
                         _('You must select at least one item from the list.')).exec_()
            return
        ct = ', '.join([unicode_type(item.text()) for item in mappings])
        if not question_dialog(self, _('Are you sure?'),
            '<p>'+_('Are you sure you want to Activate the following items for Generation and Consolidation?')+'<br><br>'+ct):
            return

        i = 0
        for item in mappings:
            if i == 0:                              #each column in each row is a separate row in this list.  so, CC is row 1, IS_ACTIVE for that CC is row 2, next CC is row 3...
                s_key = item.text()
                i = i + 1
            else:
                activate_for_calm = as_unicode(item.text())
                activate_for_calm = activate_for_calm.strip()
                if not activate_for_calm.isdigit():
                    continue
                activate_for_calm = int(activate_for_calm)
                self.update_dict[s_key] = activate_for_calm
                if DEBUG: print("added to self.update_dict[s_key] = activate_for_calm:  ", s_key, as_unicode(activate_for_calm))
                i = 0
        #END FOR


    def header_clicked(self, idx):
        self.do_sort_by_name()

    def do_sort_by_name(self):
        self.name_order = 1 if self.name_order == 0 else 0
        self.table.sortByColumn(0, self.name_order)
        self.name_col.setIcon(self.down_arrow_icon if self.name_order
                                                    else self.up_arrow_icon)




    #--------------------------------------------------------------------
    #END
