# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "2.0.34"  # Technical changes after Python 3.8 testing with Calibre 4.99.2

from calibre.constants import DEBUG, iswindows
from calibre.db.legacy import LibraryDatabase
from calibre.utils.config import prefs

from polyglot.builtins import as_unicode

#-----------------------------------------------------------------------------------------
def calm_cli_add_custom_column(param,dbpath):

    #~ param = '--is-multiple(or mdummy)|||' + display  + '|||' + label + '|||' + '"[NAME]"' + '|||' +  datatype


    if "is-multiple" in param:
        is_multiple = True
        param = param.replace("--is-multiple","").strip()
    else:
        is_multiple = False
        param = param.replace("mdummy","").strip()

    if param.startswith("|||"):
        param = param.replace("|||","",1).strip()

    param = param.strip()

    if DEBUG: print("final param:", param)

    args = param.split("|||")
    args_list = []
    for s in args:
        args_list.append(s)
        if DEBUG: print("arg: ", as_unicode(s))
    #END FOR

    display = args_list[0]

    if "dblank" in display:
        display = {}
    else:
        #~ --display="{\"enum_values\":[\"a\", \"b\", \"c\", \"d\", \"e\", \"f\", \"g\", \"h\"]}"      # JSON format works too...since calibredb uses a JSON format...
        display = display.replace("--display=","")
        display = display.strip()

    label = args_list[1]

    name = args_list[2]
    name = name.replace('"','').strip()

    datatype = args_list[3]

    if DEBUG:
        msg = "The final values to be used are: " + as_unicode(label) + " " + as_unicode(name) + " " + as_unicode(datatype) +" with display: " +  as_unicode(display) + " with is-multiple: " + as_unicode(is_multiple)

    db = LibraryDatabase(dbpath)

    msg = None

    try:
        db.create_custom_column(label, name, datatype, is_multiple, display=display)
    except Exception as e:
        msg = "Exception in db.create_custom_column creating new custom column: " + as_unicode(e)
        msg = msg + "   The failed parameter used was: "  + as_unicode(label) + " " + as_unicode(name) + " " + as_unicode(datatype) +" with display: " +  as_unicode(display) + " with is-multiple: " + as_unicode(is_multiple)
        if (as_unicode("unique") in msg or as_unicode("Unique") in msg) and (as_unicode("enumeration") in msg):
            msg = msg + "<br><br> You MUST standardize your enumeration (fixed set of values) custom column search names (labels) before continuing!  <br><br>"
        if DEBUG: print(msg)
        return msg

    if DEBUG: print("CALM Custom Column created:  ", label, "  ", name, "  ", datatype)

    # Re-open the DB so that  field_metadata is reflects the column changes
    db.prefs['field_metadata'] = db.field_metadata.all_metadata()

    del param

    return msg

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
#END of calm_cli_custom_columns.py
