# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "2.0.40"  #CalibreSpy template settings for the CALM Target Library; Information and Error Messages improved

from calibre.customize import InterfaceActionBase

class ActionBaseConsolidateAllLibraryMetadata(InterfaceActionBase):

    name                    = 'Consolidate All Library Metadata'
    description           = "Consolidate a Snapshot of All Metadata, including Custom Columns, from All of the Books in All of your Libraries for Review, Analysis and Custom Column Standardization using Powerful Tools; Perform Centralized Library Custom Column Metadata Maintenance."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (2, 0, 40)
    minimum_calibre_version = (4, 6, 0)

    actual_plugin           = 'calibre_plugins.consolidate_all_library_metadata.ui:ActionConsolidateAllLibraryMetadata'                             # the special .txt file name has the substring "consolidate_all_library_metadata"

    gui_name = 'Consolidate All Library Metadata'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return True
    #--------------------------------------------------------------------------------------------------------------------------
    def config_widget(self):
        from calibre_plugins.consolidate_all_library_metadata.config import ConfigWidget
        return ConfigWidget()
    #--------------------------------------------------------------------------------------------------------------------------
    def save_settings(self, ConfigWidget):
        ConfigWidget.save_settings()
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()
    #-------------------------------------------
#~ END of __init__py