# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.11"     #  Technical changes after Python 3.8 testing with Calibre 4.99.2

from PyQt5.Qt import (Qt, QDialog, QLabel, QVBoxLayout, QFont, QWidget)

class UIToastDialog(QDialog):

    def __init__(self,gui,icon,msg_num):

        QDialog.__init__(self, gui)

        self.gui = gui

        self.msg_num = msg_num

        s_msg = "Wait"

        if self.msg_num == 0:
            s_msg = "Please Wait While Your User Custom Word Rules are Loaded and Cross-Checked"
        else:
            if self.msg_num == 1:
                s_msg = "Job Submitted"

        self.setWindowFlags( Qt.Widget | Qt.CustomizeWindowHint )

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()
        font.setBold(True)
        font.setPointSize(20)

        self.text_line = QLabel()
        self.text_line.setTextFormat(1)
        self.text_line.setFont(font)
        self.text_line.setText("<center><font color='#0404B4'>" + s_msg + "</font></center>")
        self.layout.addWidget(self.text_line)

        self.resize(self.sizeHint())
#END OF ui_toastdialog.py