# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.11"     #  Technical changes after Python 3.8 testing with Calibre 4.99.2

#~ import os, sys
#~ import traceback
#~ from functools import partial
#~ from threading import RLock
#~ from threading import Thread, RLock, Event

#~ from calibre.utils.ipc.job import BaseJob
from calibre.gui2.threaded_jobs import ThreadedJob
from calibre.utils.logging import Log

from polyglot.io import PolyglotStringIO

from polyglot.builtins import is_py3

if is_py3:
    from queue import Queue
else:
    from Queue import Queue

from calibre_plugins.english_noun_frequency.enf_main import main_english_noun_frequency

# ------------------------------------------------------------------------------
#    Functions to perform English Noun Frequency using ThreadedJob
# ------------------------------------------------------------------------------
def start_threaded_enf(self, guidb, plugin_path, book_ids, param_dict, callback):

    job = ThreadedJob('englishnounfrequencyplugin','English Noun Frequency',main_english_noun_frequency,(self,guidb, plugin_path, book_ids, param_dict), {}, callback)
    self.gui.job_manager.run_threaded_job(job)

#END of jobs.py
