# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.11"     #  Technical changes after Python 3.8 testing with Calibre 4.99.2

import unicodedata
from polyglot.builtins import as_bytes, unicode_type

#~ ENF is for "English", which was the original basis of ASCII.  Hence, 'ignore'.

def enf_as_unicode(x):
    if isinstance(x, unicode_type):
        return x
    if isinstance(x, bytes):
        x = x.decode('utf-8', 'ignore')
    return unicode_type(x)

def enf_as_bytes(x):
    if isinstance(x, bytes):
        return x
    if isinstance(x, unicode_type):
        x = unicodedata.normalize('NFKD', x).encode('ASCII', 'ignore')        # we want Désirée  to become Desiree, not Dsire ...
        x = as_bytes(x)
        return x
    #~ ...not bytes and not unicode_type...
    ans = enf_as_unicode(x)
    ans = unicodedata.normalize('NFKD', ans).encode('ASCII', 'ignore')      # we want Désirée  to become Desiree, not Dsire ..
    ans = as_bytes(ans)
    return ans


