# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.11"     #  Technical changes after Python 3.8 testing with Calibre 4.99.2

from PyQt5.Qt import (Qt, QLabel, QVBoxLayout, QWidget, QPushButton,
                                        QGridLayout, QFont, QIcon, QGroupBox,
                                        QSizePolicy, QSize, QMargins)

from calibre.utils.config import JSONConfig

from polyglot.builtins import unicode_type

# This is where all preferences for this plugin are stored
prefs = JSONConfig('plugins/English Noun Frequency')

# Set defaults
prefs.defaults['COMMENTS_MAX'] = unicode_type(100)
prefs.defaults['COMMENTS_CHECKBOX'] = unicode_type("True")
prefs.defaults['COMMENTS_PREPEND_APPEND_REPLACE'] = unicode_type("append")
prefs.defaults['COMMENTS_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] = unicode_type("True")

prefs.defaults['TAGS_MAX']  = unicode_type(3)
prefs.defaults['TAGS_CHECKBOX'] = unicode_type("False")
prefs.defaults['TAGS_REPLACE_ADD'] = unicode_type("add")

prefs.defaults['CUSTOM_COLUMN_MAX'] = unicode_type(10)
prefs.defaults['CUSTOM_COLUMN_CHECKBOX'] = unicode_type("False")
prefs.defaults['CUSTOM_COLUMN_NAME'] = unicode_type("#enf")
prefs.defaults['CUSTOM_COLUMN_SORT_ALPHA'] = unicode_type("False")

prefs.defaults['OTHER_CHECKBOX_ONLY_LOG_COMMENTS'] = unicode_type("False")
prefs.defaults['OTHER_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] = unicode_type("False")

prefs.defaults['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE']  = unicode_type("False")
prefs.defaults['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH']  = unicode_type("/")
prefs.defaults['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE_PAUSE']  = unicode_type("False")

prefs.defaults['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']  = unicode_type("/")
prefs.defaults['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']  = unicode_type("/")

prefs.defaults['REMOVE_GLOBAL_FIRST_NAMES'] = unicode_type("True")
prefs.defaults['REMOVE_TOP_100_NOUNS'] = unicode_type("True")

prefs.defaults['TRANSLATE_ENGLISH_TO_OTHER_IS_ACTIVE'] = unicode_type("False")
prefs.defaults['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE'] = unicode_type("Español")
prefs.defaults['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE_USER_DICT_FILE'] = unicode_type("Select Custom Translation File")

prefs.defaults['OBFUSCATE_OBSCENITIES'] = unicode_type("True")


class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        self.layout_1 = QVBoxLayout()
        self.setLayout(self.layout_1)

        self.layout_1.setSpacing(0)
        self.layout_1.setContentsMargins(QMargins(0,0,0,0));

        self.paths_groupbox = QGroupBox('Preferences')
        self.layout_1.addWidget(self.paths_groupbox)

        self.paths_layout = QGridLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(12)

        self.label1 = QLabel()
        self.label1.setTextFormat(1)
        self.label1.setText("<center><font color='#0404B4'>               Please Customize Directly Within ENF               </font></center>")
        self.label1.setFont(font)
        self.paths_layout.addWidget(self.label1)

        self.resize(self.sizeHint())

    def save_settings(self):
        return
    def validate(self):
        return False
#END of config.py

