# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.13"     # Miscellany

from calibre.customize import InterfaceActionBase

class ActionBaseEnglishNounFrequency(InterfaceActionBase):

    name                    = 'English Noun Frequency'
    description           = "Determine 'English Noun Frequencies' for words in a particular book's text, and optionally: 1) Add frequences for the chosen number of frequent nouns to the book's Comments; 2) Create new Tags using the chosen number of frequent nouns for Tags; 3) Update a Custom Column with the chosen number of frequent nouns for a Custom Column.; 4) Update nothing but log the frequent nouns using the number chosen for Comments; 5) Translate the English Comments to another language, showing both; 6) Accumulate the Top 100 English Nouns with frequency counts across all of your books and all of you libraries."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 13)
    minimum_calibre_version = (4, 6, 0)

    actual_plugin           = 'calibre_plugins.english_noun_frequency.ui:ActionEnglishNounFrequency'

    gui_name = "EnglishNounFrequency"

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return True
    #--------------------------------------------------------------------------------------------------------------------------
    def config_widget(self):
        from calibre_plugins.english_noun_frequency.config import ConfigWidget
        return ConfigWidget()
    #--------------------------------------------------------------------------------------------------------------------------
    def save_settings(self, ConfigWidget):
        ConfigWidget.save_settings()
        # Apply the changes
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()
    #-------------------------------------------
#END of __init__py