#!/usr/bin/env python

__license__   = 'GPL v3'
__copyright__ = '2018, Steven Dick <kg4ydw@gmail.com>'


import re

# shared resources with the wikidata UI plugin and the wikidata metadata plugin

# identifier: [ priority, name, template, matchRE ]
IDdict = {
    'wd': [ 1, 'http://www.wikidata.org/entity/%s',
             r"https?.//www.wikidata.org/(entity|wiki)/(?P<id>Q\w+)$"],
    'gutenberg': [ 2, 'http://www.gutenberg.org/ebooks/%s',
                   r"https?.//www.gutenberg.org/ebooks/(\d+)$" ]
}

# have to just iterate through these
# If we need speedup, could try extracting the hostname as an index
# but there will be dups (coalsced hashing required).
# This list is sorted by priority.


class UrlFixer:
    def __init__(self):
    #    if len(IDpriority)==0:
    #        self.updateIDs()
        print "Initialized urlfixer"
        return None

    #def updateIDs(self):

    def IDpriority(self):
        return sorted(IDdict.keys(), key=lambda(k): IDdict[k][0])

    def id_from_url(self, url):
        #print("Testing '%s' against %d"%(url, len(IDdict)))
        for id in self.IDpriority():
            #print("Test %s for %s"%(id,IDdict[id][2]))
            result = re.match(IDdict[id][2], url)
            if result:
                try:
                    return (id, result.group('id'))
                except:
                    return (id, result.group(1))
        return None

    def get_book_urls(self, identifiers):
        result = []
        for id in identifiers:
            if id in IDdict:
                idv = identifiers[id]
                result.append((id, idv , IDdict[id][1]%idv))
        return result

    def get_book_url_name(self, idtype, idval, url):
        if idtype in IDdict:
            return idtype  # XXX translate names?
        else: # XXX
            return None
        
    def addID(self, id, v):
        if id=='wd': return  # don't mess with our ID
        IDdict[id] = v
        #self.updateIDs()

    def delID(self, id):
        if id=='wd': return  # don't mess with our ID
        del IDdict[id]
        #self.updateIDs()
        
    # bulk operations
    # ids could be an array of tuples, a dictionary, a generator...
    def addIDs(self, ids):
        for id, v in ids:
            if id=='wd': continue  # don't mess with our ID
            IDdict[id] = v
        #self.updateIDs()
            
    def delIDs(self, ids):
        if not ids: return
        for id in ids:
            if id!='wd' and id in IDdict:
                del IDdict[id]
        #self.updateIDs()
