#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import options
import os.path, shutil
import zipfile
import time
__All__="ZipArc"

def ZipArc(file, LDIR, WDIR, file_name_paths, images, cover_path):
        
    new_zip = file.split('.')[0]
    new_zip = new_zip + '.zip'
    new_arc = new_zip
    
    print('\n>>> NEW_ARC zip...' + new_arc)
    
    # create the new zip archive and populate the ziptree
    new_arc = new_zip
    print(' ')
    print(' -- Create the zip file archive...')
    print(' -- Adding files to the new zip file...')
    myZipFile = zipfile.ZipFile(new_arc, "w", zipfile.ZIP_DEFLATED )
    print(' -- Add mimetype file')
    myZipFile.writestr("mimetype", "application/epub+zip", zipfile.ZIP_STORED)
    print(' -- Add container.xml file')
    myZipFile.write(os.path.join(WDIR, 'container.xml'), os.path.join('META-INF', 'container.xml'), zipfile.ZIP_DEFLATED)
    print(' -- Add toc.ncx file')
    myZipFile.write(os.path.join(WDIR, 'toc.ncx'),  os.path.join('OEBPS', 'toc.ncx'), zipfile.ZIP_DEFLATED)
    print(' -- Add content.opf file')
    myZipFile.write(os.path.join(WDIR, 'content.opf'), os.path.join('OEBPS', 'content.opf'), zipfile.ZIP_DEFLATED)
    print(' -- Add ebook cover file')
    myZipFile.write(os.path.join(WDIR, 'cover.xhtml'), os.path.join('OEBPS', 'Text', 'cover.xhtml'), zipfile.ZIP_DEFLATED)
    print(' -- Add content.xhtml file')
    
    if options.TOC_SELECTED  == True:
        myZipFile.write(os.path.join(WDIR, 'contents.xhtml'), os.path.join('OEBPS','Text', 'contents.xhtml'), zipfile.ZIP_DEFLATED)
    
    print(' -- Add stylesheet file')   
    myZipFile.write(os.path.join(WDIR, 'stylesheet.css'), os.path.join('OEBPS', 'Styles', 'stylesheet.css'), zipfile.ZIP_DEFLATED)
    print(' -- Add cover image file')   
    myZipFile.write(cover_path, os.path.join('OEBPS', 'Images', os.path.basename(cover_path)), zipfile.ZIP_DEFLATED)   
    
    print('\n -- Add all ebook image files to the zip Images directory')
    if len(images) != 0:
        for fname in images:
            fname = os.path.basename(fname)
            print(fname)
            if fname == os.path.basename(cover_path):
                continue
            # no spaces allowed in image filename
            fname = fname.replace(' ', '_')     
            myZipFile.write(os.path.join(WDIR, fname), os.path.join('OEBPS', 'Images', fname), zipfile.ZIP_DEFLATED)           
    
    print('\n>>> Before zutils text iter...') 
    for f in file_name_paths:
        if '.xhtml' in f:
            print(f)            
        
    print('>>> zip text files...')    
    for fn in file_name_paths:
        print(fn)
    
    print(' -- Add all XHTML text header files to the zip Text directory')
    files = file_name_paths
    for fname in files:
        fname = os.path.basename(fname)
        if '.xhtml' in fname:        
            myZipFile.write(os.path.join(WDIR, fname), os.path.join('OEBPS', 'Text', fname), zipfile.ZIP_DEFLATED)        
    myZipFile.close()
    
    # create the epub file
    epub_fname = new_zip.replace('.zip', '.epub') 
    epub_fpath = os.path.join(WDIR, epub_fname)
    shutil.copy(new_zip, epub_fpath)
    
    return(epub_fpath)
    