#!/Python35/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path
from time import sleep
from updater import updateCheck
from splits import show_msgbox
import options
            
import tkinter as tk
from tkinter import *
from tkinter import Tk
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 


def centeredWindow(self, w, h):

    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y))) 
    
class MetadataDialog(Tk):
    
    def __init__(self, bk):
        super().__init__()
        self.bk = bk
        self.resizable(width=False, height=False)
        self.option_add('*font', 'Arial -12')
        #if not sys.platform.startswith('darwin'):
        #    img = tk.Image('photo', file=os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'images/penwrench.png'))
        #    self.tk.call('wm','iconphoto', self._w, img)
        self.title('HTML2Epub')    
        centeredWindow(self, 470, 305)
        self.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
        
    def setup_UI(self):
    
        self.labelf1 = LabelFrame(self, text='Edit eBook Metadata',
                        font   = ('Helvetica', 10),                           
                        width  = 300, height=195, 
                        relief = RIDGE
                        )
        self.labelf1.pack(fill=BOTH, expand=1, ipady=27, pady=3, padx=3)
        
        InfoLabel = Label(self.labelf1, 
                        text   = "", 
                        anchor = S
                        )
        InfoLabel.grid(column=1, row=0)
        
        bookLabel = Label(self.labelf1, 
                        text  = "Book title",     
                        font  = ('Helvetica', 10)                        
                        )
        bookLabel.grid(row=1, sticky=E, padx=10, pady=8)
        
        authorLabel = Label(self.labelf1, 
                        text = "Author",
                        font  = ('Helvetica', 10)
                        )
        authorLabel.grid(row=2, sticky=E, padx=10, pady=8)
        
        publisherLabel = Label(self.labelf1, 
                        text = "Publisher", 
                        font  = ('Helvetica', 10)
                        )
        publisherLabel.grid(row=3, sticky=E, padx=10, pady=8)
        
        bookLabel = Label(self.labelf1, 
                        text = "HTML file path",   
                        font  = ('Helvetica', 10)
                        )
        bookLabel.grid(row=4, sticky=E, padx=10, pady=8)
        
        coverLabel = Label(self.labelf1, 
                        text = "Book cover file path",   
                        font  = ('Helvetica', 10)
                        )
        coverLabel.grid(row=5, sticky=E, padx=10, pady=8)
                         
        self.title = StringVar()
        self.author = StringVar()
        self.publisher = StringVar()
        self.book = StringVar()
        self.cover = StringVar()
        
        titleEntry = Entry(self.labelf1, 
                        width        = 33, 
                        textvariable = self.title, 
                        relief       = GROOVE
                        )
        authorEntry = Entry(self.labelf1, 
                        width        = 33, 
                        textvariable = self.author,
                        relief       = GROOVE
                        )
        publisherEntry = Entry(self.labelf1,  
                        width        = 33, 
                        textvariable = self.publisher,
                        relief       = GROOVE
                        )
        coverEntry = Entry(self.labelf1,  
                        width        = 27, 
                        textvariable = self.cover,
                        relief       = GROOVE                   
                        )
        bookEntry = Entry(self.labelf1,  
                        width        = 27, 
                        textvariable = self.book,
                        relief       = GROOVE                   
                        )                
        titleEntry.grid(sticky=W, row=1, column=1, pady=5)
        authorEntry.grid(sticky=W, row=2, column=1, pady=6)           
        publisherEntry.grid(sticky=W, row=3, column=1, pady=6)   
        bookEntry.grid(sticky=W, row=4, column=1, pady=6)
        coverEntry.grid(sticky=W, row=5, column=1, pady=6)
        
        styler = ttk.Style()
        styler.configure('TButton', font=('Helvetica', 9), width=5, relief=GROOVE)       
        bookButton = ttk.Button(self.labelf1, 
                        text    = "Select",    
                        style   = 'TButton', 
                        command = self.onBookSelect
                        ).grid(row=4, column=1, sticky=W, padx=192, pady=0)    
        
        styler = ttk.Style()
        styler.configure('TButton', font=('Helvetica', 9), width=5, relief=GROOVE)
        coverButton = ttk.Button(self.labelf1, 
                        text    = "Select",  
                        style   = 'TButton', 
                        command = self.onCoverSelect
                        ).grid(row=5, column=1, sticky=W, padx=192, pady=0)            
                        
        InfoLabel2 = Label(self.labelf1, 
                        text   = "",
                        anchor = S
                        )
        InfoLabel2.grid(row=6, column=1)               
        
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), width=16, relief=GROOVE)
        cancelButton = ttk.Button(self.labelf1, 
                        text    = "Cancel", 
                        style   = 'New.TButton', 
                        command = self.onCancel
                        ).grid(row=7, column=1, sticky=W, padx=95, pady=0)
        
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), width=16, relief=GROOVE)
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=7, columnspan=2, sticky=W, pady=0, padx=100)       
                        
        #**** Create the statusbar *****#
        self.status = Label(self.labelf1,
                        font     = ('Helvetica', 10),      
                        relief = FLAT,
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.grid(row=8, columnspan=2, sticky=W, padx=3, pady=15)
        
        # show new plugin version msg if available
        if options.NEW_PLUGIN_VERSION: 
            centeredWindow(self, 470, 325)   
            self.status.config(text=options.MSG_NEW_VERSION_AVAILABLE)
  
        titleEntry.focus_set()
        self.populateMetaDialog()
        self.grab_set()      
        
    def populateMetaDialog(self):
        if options.LAST_META == True:
            self.title.set(options.META_OPTIONS['title'])
            self.author.set(options.META_OPTIONS['author'])
            self.publisher.set(options.META_OPTIONS['publisher'])
            self.cover.set(options.META_OPTIONS['cover'])
            self.book.set(options.META_OPTIONS['filename'])
            
     
    def onCoverSelect(self):
        prefs = self.bk.getPrefs()
        self.file_opt = options.COVER_OPTIONS  
        self.file_opt['parent'] = self  
        self.file_opt['initialdir'] = prefs['cover_dir_path']
        
        sleep(0.25)
        filename = fdbox.askopenfilename(**self.file_opt)
        if filename == '':  # on Cancel --> return
            options.SYS_EXIT = True
            return(0)
            
        prefs = self.bk.savePrefs(prefs)    
        self.cover.set(filename)
        return(0)
        
    def onBookSelect(self):
        prefs = self.bk.getPrefs()
        self.file_opt = options.BOOK_OPTIONS  
        self.file_opt['parent'] = self 
        self.file_opt['initialdir'] = prefs['book_dir_path']        

        sleep(0.25)
        filename = fdbox.askopenfilename(**self.file_opt)
        if filename == '':  # on Cancel --> return
            options.SYS_EXIT = True
            return(0)
            
        self.book.set(filename)
        return(0)    
           
    def onOK(self):
    
        if self.title.get() == '' or \
            self.author.get() == '' or \
            self.publisher.get() == '' or \
            self.book.get() == '' or \
            self.cover.get() == '':
            show_msgbox('Warning', 'Completing the ebook metadata is mandatory. The conversion to ' + \
                              'epub cannot continue without this data. \n\nPlease fill in all the required data.', msgtype='warning')
            sleep(0.25)
            shutil.rmtree(options.WDIR, ignore_errors=True)   
            options.SYS_EXIT = True
            return(0)                
             
        # Set options for later use      
        options.META_OPTIONS['title'] = self.title.get().strip()
        options.META_OPTIONS['author'] = self.author.get().strip()
        options.META_OPTIONS['publisher'] = self.publisher.get().strip()
        options.META_OPTIONS['cover'] = self.cover.get().strip()
        options.META_OPTIONS['filename'] = os.path.basename(self.book.get().strip())
        options.FILEPATH = self.book.get().strip()
        options.LDIR = os.path.split(options.FILEPATH)[0]
     
        options.LAST_META = True  
        self.destroy()
       
    def onCancel(self):
        options.SYS_EXIT = True
        print('\n -- Plugin abort...!!')
        self.destroy()
            

class UserDialog(tk.Frame):

    def __init__(self, parent):
        tk.Frame.__init__(self, parent)
        self.parent = parent
        centeredWindow(self.parent, 340, 245)
        parent.minsize(100, 100)
        parent.maxsize(600, 700)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
        
    def setup_UI(self):
    
        #width  = 300, height=200, 
        self.labelf1 = LabelFrame(self, text='User Options',                        
                        relief = RIDGE
                        )
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True, ipady=27, pady=3, padx=3)
        
        InfoLabel = Label(self.labelf1, text="Choose the heading style that you've used \n" + \
                                             "to style all your chapter headings and main \n" + 
                                             "headings in your html doc:",    
                        font     = ('Helvetica', 10),                     
                        justify = LEFT,                                             
                        anchor = W
                        )
        InfoLabel.grid(column=1, sticky=W, row=0, padx=40, pady=5)       
       
        self.radioVar = IntVar()
        self.radioVar.set(1)
        radioH1 = Radiobutton(self.labelf1, 
                        text     = '  Heading 1',
                        font     = ('Helvetica', 10),
                        value    = 1, 
                        variable = self.radioVar                  
                        )
        radioH1.grid(column=1, sticky=W, row=1, padx=60, pady=0)       
       
        radioH2 = Radiobutton(self.labelf1, 
                        text     = '  Heading 2',
                        font     = ('Helvetica', 10),
                        value    = 2, 
                        variable = self.radioVar,                      
                        )
        radioH2.grid(column=1, sticky=W, row=2, padx=60, pady=0)

        self.selectTOC = BooleanVar() 
        chkbSelectTOC = Checkbutton(self.labelf1, 
                        text     = 'Add Table of Contents to epub.',
                        font     =('Helvetica', '11'),                   
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.selectTOC      
                        )
        chkbSelectTOC.grid(column=1, sticky=W, row=3, padx=40, pady=10)                  
        
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), background='#E0E0E0', width=12, relief=GROOVE) 
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=4, column=1, pady=15)          
        
        #**** Create the statusbar *****#
        self.status = Label(self.labelf1,
                        font     = ('Helvetica', 10),
                        relief = FLAT,
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.grid(row=5, column=1, sticky=W, padx=5) 
        
        self.grab_set()       
                    
    def onOK(self):    
        
        if self.radioVar.get() == 1:
            options.H1_SELECTED = True 
   			
        if self.radioVar.get() == 2:
            options.H2_SELECTED = True
            
        if self.selectTOC.get() == True:
            options.TOC_SELECTED = True
        else: 
            options.TOC_SELECTED = False       
        
        self.parent.destroy() 
     
    def onCancel(self):
        options.SYS_EXIT = True
        self.parent.destroy()  
        return(0)
        