#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function
from random import sample

__all__ = ["generateSmallUID", "getLargeUID"]

def generateSmallUID():
    """ Generate a small UID 
    """
    
    # create a decimal count sample
    a = ['1','2','3','4','5','6','7','8','9','0']
    
    # randomize sample length values
    b = sample(a, 5)
    c = ''.join(b)
    uid = c
    
    return(uid)
    
def getLargeUID():
    
    """ Generate a large UID 
    """
    # create a hex count sample
    a = ['1','2','3','4','5','6','7','8','9','a','b','c','d','e','f']
    
    # randomize sample length values for 36 chars
    b = sample(a, 8)
    c = sample(a, 4)
    d = sample(a, 4)
    e = sample(a, 4)
    f = sample(a, 12)
    
    # force the first letter of the uid to be an alphabet character
    # and not a digit -- otherwise you will get an XML failure
    # with IDPF Epubcheck
    g = ['a','b','c','d','e','f']
    lst = sample(g, 1)
    b[0] = lst[0]
    
    # merge into strings
    b = ''.join(b)
    c = ''.join(c)
    d = ''.join(d)
    e = ''.join(e)
    f = ''.join(f)
    
    # build the uid
    uid = b + '-' + c + '-' + d + '-' + e + '-' + f
    
    return(uid)        
    
    
                  

