#!/Python35/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#


import os, os.path, sys, codecs, shutil, inspect, time, threading
from os.path import expanduser
from tempfile import mkdtemp                 
from updater import updateCheck
from dialog import MetadataDialog, UserDialog
import options
from cleaner import cleanHTML
from cleanup_utils import show_msgbox
from cutils import prettifyXHTMLFile
from doc_tidy import *
import tkinter as tk
from tkinter import *
from time import sleep

from splits import (convert2Epub, 
                   fileNotLoadedError,                
                   show_msgbox,
                   cleanExit,
                   isTablePresent,
                   hasHeadingStyle
                   )        

PLUGIN_PATH = ''
SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=3673712&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))

def isValidHTML(wdir, file):
    
    # tables are not supported
    if isTablePresent(wdir, file) == True:
        return(False)
        
    # checks that either <h1> or <h2> is used in the html    
    if hasHeadingStyle(wdir,file) == False:
        return(False)
  
    return(True)        
    
def runUserDialog(bk):
    root = tk.Tk()
    root.title('HTML2Epub')
    root.resizable(width=True, height=True)
    #if not sys.platform.startswith('darwin'):
    #    img = tk.Image('photo', file=os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'images/penwrench.png'))
    #    root.tk.call('wm','iconphoto', root._w, img)
    UserDialog(root).pack(fill=tk.BOTH, expand=True)
    root.mainloop()
    return(0)    

def run(bk):
    print('Python version: ', sys.version, '\n')
    print('Running HTML2Epub...Please wait...this might take several minutes.\n')
    
    # check for correct python version
    if bk.launcher_version() < 20160130:
        msg = "This plugin requires Sigil v0.9.3 or later"
        print('>>> Error: ' + msg + '\n\nAbort plugin...')  
        show_msgbox('Incompatible Sigil Version', msg, msgtype="error")
        options.SYS_EXIT = True
        return(0)
    
    # check for new plugin versions
    latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
    if latest_version and latest_version != installed_version:
        options.NEW_PLUGIN_VERSION = True
        options.MSG_NEW_VERSION_AVAILABLE = " A new version of this plugin is now available from MR - v" + latest_version    
    
    # set pref defaults
    prefs = bk.getPrefs()
    if 'book_dir_path' not in prefs:
        prefs['book_dir_path'] = expanduser('~')
        prefs['cover_dir_path'] = expanduser('~')
        bk.savePrefs(prefs)
        
    # collect ebook metadata from user
    meta_form = MetadataDialog(bk)
    meta_form.mainloop()
    if options.SYS_EXIT == True:
        return(0)    
    
    # file split options
    sleep(0.25)
    runUserDialog(bk)    
    if options.SYS_EXIT == True:
        return(0)
    
    # create a working dir and local dir
    WDIR = mkdtemp()
    LDIR = os.path.split(options.FILEPATH)[0]
    meta = options.META_OPTIONS
    COVER_DIR = os.path.split(meta['cover'])[0] 
      
    # set user dir defaults for next run
    prefs = bk.getPrefs()
    prefs['book_dir_path'] = LDIR
    prefs['cover_dir_path'] = COVER_DIR
    bk.savePrefs(prefs)
    
    # copy the html file to WDIR
    from_file = options.FILEPATH
    to_file = os.path.join(WDIR, os.path.basename(from_file))
    shutil.copy(from_file, to_file)
    html_file = to_file
    
    if isValidHTML(WDIR, html_file) == False:
        cleanExit(WDIR)
        return(-1)
    
    if html_file:        
        
        # cleanup the html file and ensure epub 2 html compliance
        cleanHTML(WDIR, os.path.join(WDIR, html_file))
        if options.SYS_EXIT == True:
            cleanExit(WDIR)
            return(0)            
        
        # convert the html file to epub format
        epub_path = convert2Epub(bk, WDIR, html_file)
        if options.SYS_EXIT == True:
            cleanExit(WDIR)
            return(0)         

        # import the epub into Sigil
        if os.path.isfile(epub_path):
            with open(epub_path,'rb') as fp:
                data = fp.read()
            bk.addotherfile('dummy.epub', data)
            os.remove(epub_path)
            cleanExit(WDIR)
            print('\n -- Completed SUCESSFULLY...')
            return(0)
                   
    else:
        print('\n >>> Error: Unable to process html file due to critical errors.')
        cleanExit(WDIR)
        return(0)

def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())                   