# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.170"   #Technical changes after Python 3.8 testing with Calibre 4.99.3

from PyQt5.Qt import Qt, QDialog, QVBoxLayout, QFont, QWidget, QTextEdit, QTextOption, QSize, QPushButton

from calibre.gui2 import gprefs

from polyglot.builtins import iteritems

#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):
    initial_extra_size = QSize(100, 100)

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)

    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class VLHelperDialog(SizePersistedDialog):

    def __init__(self,gui,icon):

        parent = gui
        unique_pref_name = 'job_spy:vl_helper_dialog_'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)

        self.gui = gui

        self.setWindowTitle('JS+ GUI Tool: VL Helper')
        self.setWindowIcon(icon)

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()
        font.setBold(False)
        font.setPointSize(10)

        db = self.gui.current_db
        vl_dict = db.prefs.get('virtual_libraries', {})
        if len(vl_dict) == 0:
            return
        vl_list = []
        #~ for vlname,vlcriteria in vl_dict.iteritems():
        for vlname,vlcriteria in iteritems(vl_dict):
            row = vlcriteria,vlname
            vl_list.append(row)
        #END FOR
        vl_list.sort()

        self.vl_qtextedit =  QTextEdit("")
        self.vl_qtextedit.setAcceptRichText(True)
        self.vl_qtextedit.setReadOnly(True)
        self.vl_qtextedit.setFont(font)
        self.vl_qtextedit.setWordWrapMode(QTextOption.WordWrap)
        self.vl_qtextedit.clear()

        s_text = 'VL Name  ---->> VL Criteria \n\n'

        for vl in vl_list:
            vlcriteria,vlname = vl
            s_text = s_text + vlname + ' ---->> ' + vlcriteria + '\n\n'
        #END FOR

        self.vl_qtextedit.setPlainText(s_text)

        self.layout.addWidget(self.vl_qtextedit)

        self.vl_qtextedit.setToolTip("<p style='white-space:wrap'>Current Virtual Libraries sorted first by VL Criteria, then by VL Name.  View the Criteria, not just the Name.  Also, Copy and Paste the VL Criteria into the Search Bar, then change as needed.")

        font.setPointSize(6)

        self.push_button_save_geometry = QPushButton(" ", self)
        self.push_button_save_geometry.setText("Save")
        self.push_button_save_geometry.clicked.connect(self.save_current_geometry)
        self.push_button_save_geometry.setFont(font)
        self.push_button_save_geometry.setMaximumWidth(100)
        self.push_button_save_geometry.setToolTip("<p style='white-space:wrap'>Save the current size of this dialog box.")
        self.layout.addWidget(self.push_button_save_geometry)

        self.resize_dialog()

    #----------------------------------------------------
    def save_current_geometry(self):
        self.save_dialog_geometry()
    #----------------------------------------------------

#END OF vl_menu_dialog.py