# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.170"   #Technical changes after Python 3.8 testing with Calibre 4.99.3

from PyQt5.Qt import Qt, QTextEdit, QVBoxLayout, QDialog, QPushButton, QTextOption, QAbstractScrollArea

LOG_DEFAULT_WIDTH = 900

class GenericLogViewerDialog(QDialog):
    def __init__(self,icon,title,log):
        super(GenericLogViewerDialog, self).__init__()

        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.WindowCloseButtonHint | Qt.WindowMinMaxButtonsHint)
        self.setModal(False)
        self.setWindowIcon(icon)
        title = "JS+:   " + title
        self.setWindowTitle(title)
        self.setSizeGripEnabled(True)
        self.setModal(False)

        self.setToolTip("<p style='white-space:wrap'>To save this log prior to exiting:  Right-Click and 'Select All', 'Copy' to the clipboard, and then paste into a text document.\
                                                                                <br><br>Tip:  To make Tag Scrubbing run <i>much</i> faster, 'close' the Tag Browser so it does not waste time constantly updating itself while Tag Scrubbing is running.")

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout)

        self.log_qtextedit =  QTextEdit("")
        self.log_qtextedit.setReadOnly(True)
        self.log_qtextedit.setWordWrapMode(QTextOption.NoWrap)
        self.log_qtextedit.setSizeAdjustPolicy(QAbstractScrollArea.AdjustToContents)
        self.log_qtextedit.setMinimumWidth(LOG_DEFAULT_WIDTH)
        self.log_qtextedit.setMaximumWidth(LOG_DEFAULT_WIDTH)
        self.log_qtextedit.clear()
        self.log_qtextedit.setPlainText(log)
        self.layout.addWidget(self.log_qtextedit)

        self.resize(self.log_qtextedit.size())

        self.exit_pushbutton = QPushButton("Exit", self)
        self.exit_pushbutton.clicked.connect(self.done)
        self.layout.addWidget(self.exit_pushbutton)

        self.show()

#~ # end of generic_log_viewer_dialog.py