# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.170"   #Technical changes after Python 3.8 testing with Calibre 4.99.3

from PyQt5.Qt import QTimer
from functools import wraps
from calibre.constants import DEBUG
#~ --------------------------------------------------------------------------------------------------------------
def decorated_do_add(fn,jobspyaction):
    @wraps(fn)
    def new_do_add(*args, **kwargs):
        fn(*args, **kwargs)
        if DEBUG: print("Job Spy: self.gui.auto_add.do_add() is enhanced per user customization...")
        QTimer.singleShot(1,jobspyaction)
    return new_do_add
#~ --------------------------------------------------------------------------------------------------------------
def decorated_tags_view_recount(fn,jobspyaction):
    @wraps(fn)
    def new_tags_view_recount(*args, **kwargs):
        fn(*args, **kwargs)
        if DEBUG: print("Job Spy: self.gui.tags_view.recount() is enhanced for showing icons of user category child values...")
        QTimer.singleShot(1,jobspyaction)
    return new_tags_view_recount
#~ --------------------------------------------------------------------------------------------------------------
#~ --------------------------------------------------------------------------------------------------------------