# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

from __future__ import absolute_import

__license__   = 'GPL v3'
__copyright__ = '2011-2018, meme'
__docformat__ = 'restructuredtext en'

#####################################################################
# Save function shared by Create and Edit
#####################################################################

import os
import calibre_plugins.kindle_collections.messages as msg
import calibre_plugins.kindle_collections.config as cfg
import calibre_plugins.kindle_collections.kindle_books as kindle_books
import calibre_plugins.kindle_collections.kindle_device as kindle_device
import calibre_plugins.kindle_collections.kindle_collections as kindle_collections
from calibre_plugins.kindle_collections.utilities import debug_print, wording

status = None

#####################################################################

def save_kindle_collections(compare):
    # Not particularly pretty, but we need to check if we're the first run in diff_db_only only mode (before save_collections) in order to avoid showing a confusing message to users...
    if cfg.config_settings['diff_db_only']:
        diff_file = kindle_device.kdevice.get_collections_filename(override=True)
        if not os.path.isfile(diff_file):
            diff_first_run = True
        else:
            diff_first_run = False
    try:
        kindle_device.kdevice.save_collections(kindle_collections.kc.get_raw_collections(), kindle_collections.kcd.get_raw_collections(), compare)
    except ValueError as error:
        msg.message.error(str(error))
    else:
        # Print the stats for the right db if we asked for diff only
        if cfg.config_settings['diff_db_only']:
            if kindle_collections.kcd.get_len():
                msg.message.info('<P>%d updated %s saved to the Kindle.' % (kindle_collections.kcd.get_len(), wording('collection', 'collections', kindle_collections.kcd.get_len())))
            else:
                if diff_first_run:
                    msg.message.info('No existing database found, assume this is the first run and use the full database. <P>%s saved to the Kindle.' % wording('Collection', 'Collections', kindle_collections.kc.get_len()))
                else:
                    msg.message.info('No changes were made to the collection file on the Kindle since there were no updated collections to save.')
        else:
            if kindle_collections.kc.get_len():
                msg.message.info('<P>%s saved to the Kindle.' % wording('Collection', 'Collections', kindle_collections.kc.get_len()))
            else:
                msg.message.info('Collection file removed from the Kindle since there were no collections to save.')

        msg.message.info('%s' % get_summary())

        save_fast_reboot()

def save_fast_reboot():
        if cfg.config_settings['kindle_model_version'] >= 5000:
            msg.message.info('<P><B>Eject and unplug the Kindle - depending on your favorite tool, you\'ll need to <I>either</I> run an \'Import collections from Calibre\' in Collections Manager\'s \'Synchronization\' menu, <I>or</I> an \'Update collections (from calibre plugin json)\' in LibrarianSync to load your changes.<B>')
        else:
            if cfg.config_settings and 'fast_reboot' in cfg.config_settings and cfg.config_settings['fast_reboot'] and kindle_device.kdevice.get_kindle_hack_reboot_trigger_file():
                kindle_device.kdevice.create_kindle_hack_reboot_trigger_file()
                msg.message.info('<P><B>Eject and unplug the Kindle - it will automatically reboot and load your changes without restarting the Kindle.<B>')
            else:
                msg.message.info('<P><B>Eject and <U>Restart</U> the Kindle to load your changes.<B><P><INDENT>To Restart: press the Home key, then press Menu, select Settings, then press Menu again and select Restart.</INDENT>')

def get_summary():
    collections = kindle_collections.kc.get_len()
    books = len(kindle_books.kbooks.code_paths)
    summary = '\n%d %s' % (collections, wording('collection', 'collections',collections))
    c = kindle_books.kbooks.counts['books']
    if c > 0:
        summary += ', %d %s' % (c, wording('book', 'books', c))
    c = kindle_books.kbooks.counts['newspapers']
    if c > 0:
        summary += ', %d %s' % (c, wording('newspaper', 'newspapers', c))
    c = kindle_books.kbooks.counts['magazines']
    if c > 0:
        summary += ', %d %s' % (c, wording('magazine', 'magazines', c))
    c = kindle_books.kbooks.counts['feeds']
    if c > 0:
        summary += ', %d %s' % (c, wording('news feed', 'news feeds', c))
    summary += ' found on the Kindle.'
    return summary

