# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

from __future__ import absolute_import

__license__   = 'GPL v3'
__copyright__ = '2011-2018, meme'
__docformat__ = 'restructuredtext en'

#####################################################################
# Restore collection file on Kindle
#####################################################################

from calibre.gui2 import question_dialog

import calibre_plugins.kindle_collections.messages as msg
import calibre_plugins.kindle_collections.config as cfg
import calibre_plugins.kindle_collections.calibre_info as calibre_info
import calibre_plugins.kindle_collections.kindle_device as kindle_device
from calibre_plugins.kindle_collections.utilities import debug_print
from calibre_plugins.kindle_collections.__init__ import PLUGIN_NAME

#####################################################################

# Menu item Restore
def run(parent):
    debug_print('BEGIN Restore collections file')
    gui = parent.gui

    if not cfg.init(parent):
        msg.message.display()
        debug_print('END Restore collections File - initialization failed')
        return False

    # Make sure the settings are up to date, we rely on the model being accurate here...
    if not cfg.store.is_current_store_format():
        msg.message.info('Please run "Customize collections" and select OK to save your customizations before running Restore Collections.')
        msg.message.display()
        return False

    calibre_info.ci.load_column_book_info()
    kindle_device.init(calibre_info.ci.device_path)

    # Depending on the settings, this might be a bad idea on >= K5, warn about it.
    if cfg.config_settings['kindle_model_version'] >= 5000:
        restore_dialog_body = 'Are you sure you want to restore the previous Collections file saved on the Kindle?' + '</P>' + '<P>' + 'Note that, with your Kindle model, this might be counterproductive, depending on your settings, and how you use CM/LS!'
    else:
        restore_dialog_body = 'Are you sure you want to restore the previous Collections file saved on the Kindle?'
    if question_dialog(gui, _('Restore ' + PLUGIN_NAME), '<P>'+
            restore_dialog_body, show_copy_button=False):
        try:
            kindle_device.kdevice.restore_collections()
        except ValueError as e:
            msg.message.error(str(e))
        else:
            msg.message.info('Collections restored.')
        msg.message.display()

    debug_print('END Restore collections File')
