# -*- coding: utf-8 -*-

from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__ = 'GPL v3'
__docformat__ = 'restructuredtext en'

from calibre.customize import EditBookToolPlugin

PLUGIN_NAME = "Typex"
PLUGIN_DESCRIPTION = _('Corrige la typo des epub')
PLUGIN_VERSION_TUPLE = (1, 4, 3)
PLUGIN_VERSION = '.'.join([str(x) for x in PLUGIN_VERSION_TUPLE])
PLUGIN_AUTHORS = 'EbookMakers'
ICON_FILE = 'resources/typex_icon.png'


class TypexPlugin(EditBookToolPlugin):

    name = PLUGIN_NAME
    version = PLUGIN_VERSION_TUPLE
    author = PLUGIN_AUTHORS
    supported_platforms = ['windows', 'osx', 'linux']
    description = PLUGIN_DESCRIPTION
    minimum_calibre_version = (1, 46, 0)
