#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = 'Christophe'
__docformat__ = 'restructuredtext en'

import time, re
from urllib.parse import quote

from lxml.html import fromstring, tostring
from calibre import browser

from calibre import as_unicode
from calibre.utils.icu import lower
from calibre.ebooks.metadata.sources.base import Source
from calibre.utils.cleantext import clean_ascii_chars
from calibre.utils.localization import get_udc

class DownloadTranslatorWorker(Source):

    def __init__(self, title, authors, timeout=20):
        self.timeout = timeout
        self.traducteur = None
        self.title = title
        self.authors = authors
        self.run()

    def run(self):
        
        matches = []
        br = browser()
        print(('self authors %s' %self.authors))
        print(('self title %s' %self.title))
        query = self.create_query(title=self.title, authors=self.authors)
        print(('query %s' %query))

        response = br.open_novisit(query, timeout=self.timeout)
        try:
            raw = response.read().strip()        
            raw = raw.decode('utf8', errors='replace')
            #print('raw %s' %raw)
            root = fromstring(clean_ascii_chars(raw))
        except:
            return None

        try:
            self._parse_search_results(root, matches)
        except:
            print('erreur parse')
            return None
            raise
        print('avant notice')

        if len(matches) == 0:
            print('liste vide')
        else:
            save_final = []
            a_verifier = False
            traducteur_trouve = False
            for notice in matches:
                print(('notice %s' %notice))        
                response = br.open_novisit(notice, timeout=self.timeout)
                raw = response.read().strip()
                raw = raw.decode('utf8', errors='replace')
                root = fromstring(clean_ascii_chars(raw))
                #print('raw traducteurs %s' %raw)
                traducteur = root.xpath('//meta[@name="DC.contributor"]/@content')
                print(('traducteur %s' %traducteur))
                
                if traducteur:
                    # traitement des traducteurs trouvés pour ne conserver que le nom et le prénom

                    # transforme la liste en string
                    traducteurs = ' &'.join(traducteur)
                    print(('traducteurs %s' %traducteurs))
                    # string en list avec &
                    traducteurs_split = re.split ('&',traducteurs)
                    print(('traducteurs_split %s' %traducteurs_split))
                    # ne conserver que les traducteurs
                    r = re.compile(".*raducteur")
                    que_traducteurs = list(filter(r.match, traducteurs_split))
                    print(('que_traducteurs %s' %que_traducteurs))
                    # tout supprimer après (
                    parenthese = []
                    for s in que_traducteurs:
                        x = re.sub(r'^(.*?) *\(.*',r'\1',s)
                        parenthese.append(x)
                        print(('parenthese %s' %parenthese))
                    # tout supprimer après .
                    point = []
                    for s in parenthese:
                        x = re.sub(r'^(.*?) *\..*',r'\1',s)
                        point.append(x)
                        print(('point %s' %point))
                    final = []
                    # supprimer la chaîne de caractères Traducteur
                    for s in point:
                        x = re.sub('Traducteur','',s)
                        final.append(x)
                        print(('final %s' %final))
                        
                    # si différents traducteurs pour les éditions => ajouter le(s) traducteur(s) pour vérification manuelle 
                    for s in final:
                        if s not in save_final:
                            save_final.append(s)
                            if traducteur_trouve == True:
                                a_verifier = True
                            
                    if len(final) > 0:
                        traducteur_trouve = True
                        
            # concaténation des traducteurs
            if a_verifier == True:
                save_final.append(' A_vérifier')
            self.traducteur = ' &'.join(save_final)
            print(('self.traducteur %s' %self.traducteur))            
         
                    

    def create_query(self, title=None, authors=None):


        BASE_URL = 'http://catalogue.bnf.fr/search.do?mots1=TIT;0;0;'
        BASE_URL_MID = '&mots0=NRI;-1;0;'
        BASE_URL_LAST = '&facDocs=a&langue1=LAN;0;0&langue0=LAN;-1;fre;1&&pageRech=rav'
    
        q = ''
        au = ''
        authors = self.authors
        if title:          
            #title = get_udc().decode(title)
            title_tokens = list(self.get_title_tokens(title,
                                strip_joiners=False, strip_subtitle=True))
            if title_tokens:
                tokens = [quote(t.encode('utf-8') if isinstance(t, str) else t) for t in title_tokens]               
                q='+'.join(tokens)
                #log.info('tokens title: %s'%tokens)     
        if authors:
            #authors = [get_udc().decode(a) for a in authors]
            author_tokens = self.get_author_tokens(authors,
                    only_first_author=True)
            if author_tokens:
                tokens = [quote(t.encode('utf-8') if isinstance(t, str) else t) for t in author_tokens]
                au='+'.join(tokens)
        #log.info('tokens author: %s'%tokens)        
        if not q:
            return None
        return '%s%s%s%s%s'%(BASE_URL,q,BASE_URL_MID,au,BASE_URL_LAST)

    def _parse_search_results(self, root, matches):

        BASE_URL0 = 'http://catalogue.bnf.fr'
        print('parse')
        results = root.xpath('//div [@class="notice-synthese"]')
        print('results')
        if not results:
            print('not results')
            return    
        for result in results:
           print('in results')
           result_url=result.xpath('a/@href')
           print('result_url')
           matches.append( '%s%s'%(BASE_URL0,result_url[0]))
           print(('matches : %r' %matches))
        print('fin parse')           
       

