# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.66"  # Python 3 compatibility for users who had never previously installed Python 2 Calibre.

from PyQt5.Qt import Qt, QApplication

from calibre.constants import DEBUG
from calibre.gui2 import error_dialog
from calibre.gui2.actions import InterfaceAction

from polyglot.builtins import as_unicode, as_bytes, is_py3, iteritems

from calibre_plugins.zotero_metadata_importer.config import prefs
from calibre_plugins.zotero_metadata_importer.common_utils import set_plugin_icon_resources, get_icon, create_menu_action_unique
from calibre_plugins.zotero_metadata_importer.zmi_dialog import ZoteroMetadataImporterDialog


PLUGIN_ICONS = ['images/z.png']

S_FALSE = "False"
S_TRUE = "True"

selected_books_list = []

#--------------------------------------------------------------------------------------------
class ActionZoteroMetadataImporter(InterfaceAction):

    name = 'Zotero Metadata Importer'
    action_spec = ('ZMI','images/z.png', "Add Zotero documents and files plus their metadata to Calibre as books using a normal .csv file exported by Zotero.<br><br>Compare items in Zotero to books in Calibre.<br><br>Export an RIS file with Calibre books and their metadata for import into Zotero.", None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 9
    popup_type = 1

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def genesis(self):

        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )

        self.gui.keyboard.finalize()

        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))

        self.qaction.triggered.connect(self.zmi_control)

        global my_plugin_path
        my_plugin_path = self.plugin_path
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def initialization_complete(self):

        must_save = False
        for k,v in iteritems(prefs.defaults):
            if k in prefs:
                pass
            else:
                prefs[k] = v
                must_save = True
        #END FOR
        if must_save:
            prefs

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def library_changed(self,guidb):

        self.guidb = guidb

        try:
            self.zmidialog.close()
        except:
            pass
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def shutting_down(self):

        try:
            self.zmidialog.close()
        except:
            pass

        try:
            import ast
            import atexit
            s = prefs['ZMI_TEMP_DIRECTORY_TO_DELETE_AT_SHUTDOWN']
            if is_py3:
                s = as_unicode(s)
            else:
                s = as_bytes()
            tmp_directory_list = ast.literal_eval(s)
            if isinstance(tmp_directory_list,list):
                from calibre.ptempfile import remove_dir
                for dir in tmp_directory_list:
                    atexit.register(remove_dir, dir)
                #END FOR
        except Exception as e:
            pass

        empty_list = []
        prefs['ZMI_TEMP_DIRECTORY_TO_DELETE_AT_SHUTDOWN'] = as_unicode(empty_list)
        prefs

        return True
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def zmi_control(self):

        self.guidb = self.gui.library_view.model().db

        try:
            self.zmidialog.close()
        except:
            pass

        current_library_path = self.guidb.library_path
        if "/CALM" in current_library_path or "\CALM" in current_library_path:
            s = "Sorry, but ZMI may <b>not</b> be used with a CALM Target Library.<br><br>Use ZMI only with normal, 'real' Calibre Libraries, not: " + current_library_path
            error_dialog(self.gui, _('ZMI'),_(s), show=True)
            return

        #important to do this now in this thread, before the ZMI dialog's thread...due to library_view focus and other issues...
        QApplication.instance().processEvents()
        self.gui.current_db.data.set_marked_ids(())
        self.gui.library_view.clearSelection()
        self.gui.search.clear()
        self.gui.search.set_search_string('')
        self.gui.do_search_button()
        QApplication.instance().processEvents()

        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.zmidialog = ZoteroMetadataImporterDialog(self.gui,self.qaction.icon(),self.guidb, self.plugin_path,self.ui_exit,self.action_type)
        self.zmidialog.setAttribute(Qt.WA_DeleteOnClose)
        self.zmidialog.show()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def ui_exit(self,restart=False):
        self.zmidialog.close()
        if restart:
            self.zmi_control()
        else:
            QApplication.instance().processEvents()
#-------------------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#END of ui.py