# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.68"  # Qt tweaks so ZMI dialog displays the same in Linux as it does in Windows.

from calibre.customize import InterfaceActionBase

class ActionBaseZoteroMetadataImporter(InterfaceActionBase):

    name                    = 'Zotero Metadata Importer'
    description           = "Add Zotero documents and files plus their metadata to Calibre as books using the normal .csv file exported by Zotero.  Compare items in Zotero to books in Calibre. Export an RIS file with Calibre books and their metadata for import into Zotero."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 68)
    minimum_calibre_version = (4, 6, 0)

    actual_plugin           = 'calibre_plugins.zotero_metadata_importer.ui:ActionZoteroMetadataImporter'

    gui_name = 'Zotero Metadata Importer'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #-------------------------------------------
#END of __init__py