# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "3.6.106"    # Technical changes after Python 3.8 testing with Calibre 4.99.4

from polyglot.builtins import as_unicode

def add_global_authors(my_db, my_cursor, log):
    #Also used by authorlevel.py, which also updates the Sort and Link columns automatically as needed.

    try:
        my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
    except:
        pass

    #-----------------------------------------------------------------------------------------------------
    try:
        my_cursor.execute("\
            BEGIN TRANSACTION; \
            INSERT OR IGNORE INTO _pristine_authors (id,name,sort,link) SELECT null,name,' ',' ' FROM _author_mapping WHERE name NOT NULL AND newname NOT NULL; \
            INSERT OR IGNORE INTO _pristine_authors (id,name,sort,link) SELECT null,newname,' ',' ' FROM _author_mapping WHERE name NOT NULL AND newname NOT NULL; \
            COMMIT; ")
    except:
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass
    #-----------------------------------------------------------------------------------------------------


    try:
        my_cursor.execute("\
            BEGIN TRANSACTION; \
            INSERT OR IGNORE INTO _global_authors VALUES(NULL,'Dr Seuss',' ',' ');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'William Bass','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Willard F. Harley','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Vaseem Khan','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Tyrese Gibson','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Tim Gerard Reynolds','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Terrie Todd','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Tara Fields','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Sunjeev Sahota','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Sue Johnson','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Simon Critchley','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Sherwin B. Nuland','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Sherry Argov','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Sabrina Alexis','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Ruth Ware','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Robert D. Lupton','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Robert A. Glover','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Richard Ferber','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Rebecca Wells','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Pierrick Bourgault','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Pia Mellody','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Paula J. Giddings','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Patti Stanger','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Nina George','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Neil Smith','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Mike Gilbert','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Michelle Skeen','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Michelle Alexander','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Michael Punke','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Michael Griesbach','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Melanie Dickerson','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Matthew Hussey','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Mark Fuhrman','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Marie Forleo','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Maharishi Mahesh Yogi','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Maggie Ford','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Lexy Timms','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Laura Berman','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Laura Barnett','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Kate Hamer','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'John Gottman','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'John Dickie','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Joanna Cannon','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jill Leovy','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jesper Bugge Kold','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jenny Eclair','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jennifer L. Pozner','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jennifer Arnold','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jacob Riis','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Indiana Wake','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Hetty van de Rijt','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Heidi Murkoff','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Harville Hendrix','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Greg Behrendt','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'George Anastasia','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'G.L. Lambert','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Fernando Gamboa','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Emerson Eggerichs','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Eli Sanders','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Dr. Ari Brown','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Dinah Jefferies','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Diana Kirschner','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Devon Franklin','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Debbie Howells','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'David Schnarch','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'David Ebershoff','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'David Brooks','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Dani Atkins','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Corey Wayne','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Cokie Roberts','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Clare Mackintosh','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Christopher Ryan','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Christopher Hodapp','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Charles Brandt','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Celia Imrie','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Cathy Bramley','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'C.L. Taylor','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Bob Halloran','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Bianca Blythe','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Barbara Steffens','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Angela Y. Davis','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Angela Clarke','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Andrew Solomon','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Allan Hall','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Alexandra Burt','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Alexander Chee','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'William Bass','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Willard F. Harley','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Vaseem Khan','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Tyrese Gibson','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Tim Gerard Reynolds','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Terrie Todd','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Tara Fields','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Sunjeev Sahota','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Sue Johnson','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Simon Critchley','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Sherwin B. Nuland','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Sherry Argov','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Sabrina Alexis','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Ruth Ware','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Robert D. Lupton','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Robert A. Glover','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Richard Ferber','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Rebecca Wells','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Pierrick Bourgault','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Pia Mellody','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Paula J. Giddings','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Patti Stanger','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Nina George','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Neil Smith','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Mike Gilbert','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Michelle Skeen','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Michelle Alexander','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Michael Punke','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Michael Griesbach','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Melanie Dickerson','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Matthew Hussey','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Mark Fuhrman','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Marie Forleo','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Maharishi Mahesh Yogi','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Maggie Ford','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Lexy Timms','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Laura Berman','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Laura Barnett','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Kate Hamer','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'John Gottman','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'John Dickie','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Joanna Cannon','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jill Leovy','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jesper Bugge Kold','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jenny Eclair','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jennifer L. Pozner','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jennifer Arnold','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Jacob Riis','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Indiana Wake','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Hetty van de Rijt','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Heidi Murkoff','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Harville Hendrix','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Greg Behrendt','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'George Anastasia','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'G.L. Lambert','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Fernando Gamboa','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Emerson Eggerichs','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Eli Sanders','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Ari Brown','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Dinah Jefferies','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Diana Kirschner','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Devon Franklin','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Debbie Howells','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'David Schnarch','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'David Ebershoff','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'David Brooks','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Dani Atkins','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Corey Wayne','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Cokie Roberts','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Clare Mackintosh','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Christopher Ryan','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Christopher Hodapp','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Charles Brandt','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Celia Imrie','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Cathy Bramley','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'C.L. Taylor','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Bob Halloran','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Bianca Blythe','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Barbara Steffens','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Angela Y. Davis','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Angela Clarke','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Andrew Solomon','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Allan Hall','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Alexandra Burt','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Alexander Chee','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Robert Stallman','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Tina Connolly','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Katherine Addison','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Richard Bowes','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Hayden Howard','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Caitlín R. Kiernan','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Caitlin R. Kiernan','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Theodore L. Thomas','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Randall Munroe','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Charlie Jane Anders','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Brian K. Vaughan','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Ursula Vernon','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Stuart Lilie','','');\
            INSERT OR IGNORE INTO _global_authors VALUES (NULL,'Winston Churchill','','');\
            COMMIT; ")
    except Exception as e:
        log("Error in creating new Global Authors [1]")
        log(as_unicode(e))
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass

    try:
        s_quote = "'"
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "UPDATE OR IGNORE _global_authors SET name = replace(name,'!',?)"          #may cause duplicate key
        my_cursor.execute(mysql,([s_quote]))
        my_cursor.execute("COMMIT")
    except Exception as e:
        if DEBUG: print(as_unicode(e))
        try:
            my_cursor.execute("commit")
        except:
            pass

    #----------------------

    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "UPDATE OR IGNORE _global_authors SET name = replace(name,'  ',' ')"          #may cause duplicate key
        my_cursor.execute(mysql)
        my_cursor.execute("COMMIT")
    except Exception as e:
        if DEBUG: print(as_unicode(e))
        try:
            my_cursor.execute("commit")
        except:
            pass

    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "UPDATE OR IGNORE _global_authors SET name = trim(name)"          #may cause duplicate key
        my_cursor.execute(mysql)
        my_cursor.execute("COMMIT")
    except Exception as e:
        if DEBUG: print(as_unicode(e))
        try:
            my_cursor.execute("commit")
        except:
            pass

    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "UPDATE OR IGNORE _global_authors SET sort = replace(sort,'  ',' ')"
        my_cursor.execute(mysql)
        mysql = "UPDATE OR IGNORE _global_authors SET sort = trim(sort) "
        my_cursor.execute(mysql)
        mysql = "UPDATE OR IGNORE _global_authors SET link = replace(link,'  ',' ')"
        my_cursor.execute(mysql)
        my_cursor.execute("COMMIT")
    except Exception as e:
        if DEBUG: print(as_unicode(e))
        try:
            my_cursor.execute("commit")
        except:
            pass

    #----------------------

    try:
        my_cursor.execute("\
            BEGIN TRANSACTION;\
            DELETE FROM _global_authors WHERE name LIKE '%!%' ; \
            DELETE FROM _global_authors WHERE name LIKE '%  %' ; \
            DELETE FROM _global_authors WHERE name LIKE '%(%' ; \
            DELETE FROM _global_authors WHERE name LIKE '%[%' ; \
            DELETE FROM _global_authors WHERE name LIKE '%editor%' ; \
            DELETE FROM _global_authors WHERE name LIKE '%translator%' ; \
            DELETE FROM _global_authors WHERE name LIKE '% trans %' ; \
            DELETE FROM _global_authors WHERE name LIKE '%;%' ; \
            DELETE FROM _pristine_authors WHERE name LIKE '%;%' ; \
            DELETE FROM _global_authors WHERE name LIKE '%, The %' ; \
            DELETE FROM _pristine_authors WHERE name LIKE '%, The %' ; \
            DELETE FROM _global_authors WHERE name LIKE '% in %' ; \
            DELETE FROM _pristine_authors WHERE name LIKE '% in %' ; \
            DELETE FROM _global_authors WHERE name LIKE '%Europe%' ; \
            DELETE FROM _pristine_authors WHERE name LIKE '%Europe%' ; \
            DELETE FROM _global_authors WHERE name LIKE '%Paper%' ; \
            DELETE FROM _pristine_authors WHERE name LIKE '%Paper%' ; \
            DELETE FROM _global_authors WHERE name LIKE '% it %' ; \
            DELETE FROM _pristine_authors WHERE name LIKE '% it %' ; \
            DELETE FROM _global_authors WHERE substr(name,1,4) = 'The ' ; \
            DELETE FROM _pristine_authors WHERE substr(name,1,4) = 'The ' ; \
            DELETE FROM _global_authors WHERE name LIKE '% last %' ; \
            DELETE FROM _pristine_authors WHERE name LIKE '% last %' ; \
            DELETE FROM _global_authors WHERE name NOT LIKE '% %' ; \
            DELETE FROM _pristine_authors WHERE name NOT LIKE '% %' ; \
            DELETE FROM _global_authors WHERE link LIKE '%ERROR%' ; \
            DELETE FROM _pristine_authors WHERE link LIKE '%ERROR%' ; \
            DELETE FROM _global_authors WHERE name LIKE '%._._._.%' ; \
            DELETE FROM _pristine_authors WHERE name LIKE '%._._._.%' ; \
            COMMIT;")
    except Exception as e:
        if DEBUG: print(as_unicode(e))
        try:
            my_cursor.execute("commit")
        except:
            pass

    #----------------------


#END OF sqlobjects_global_authors.py
