# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "3.6.111"  
import os, sys
import apsw
from copy import deepcopy
import re
import socket
import time
from time import sleep
import unicodedata
from calibre import isbytestring
from calibre.constants import filesystem_encoding, DEBUG
from calibre.utils.logging import Log as log
from polyglot.builtins import as_unicode, is_py3, iteritems, unicode_type
from polyglot.queue import Queue
if is_py3:
    from urllib import request as urlrequest
    urlopen = urlrequest.urlopen
else:
    from urllib2 import urlopen
    from urllib2 import Request as urlrequest
from calibre.ebooks.BeautifulSoup import BeautifulSoup
from calibre_plugins.quarantine_and_scrub.titlecase import titlecase
from calibre_plugins.quarantine_and_scrub.booklevel import (scrub_tags, add_book_awards, build_book_awards_list,
                                                                                                    scrub_isbn_in_tags, apply_tag_capitalization_rules,
                                                                                                    convert_isbn_check_digit_13, convert_isbn_convert_10_to_13,
                                                                                                    build_regex_list_from_tag_rules,
                                                                                                    build_regex_list_from_tag_capitalization_rules,
                                                                                                    explode_custom_column_8_if_needed,
                                                                                                    explode_custom_column_10_if_needed,
                                                                                                    explode_custom_column_13_if_needed,
                                                                                                    refresh_custom_column_15,
                                                                                                    add_tag_combinations,
                                                                                                    do_uppercase,
                                                                                                    apply_tag_string_replacement_rules,
                                                                                                    insert_single_tags_into_work_tags_single,
                                                                                                    add_missing_seriesname_from_web_detail,
                                                                                                    change_work_title_to_web_title_for_previously_validated_work_series,
                                                                                                    update_non_qs_custom_columns_generic,
                                                                                                    miscellany_change_work_index_to_web_index_standalone )
from calibre_plugins.quarantine_and_scrub.naturalsort import natsort, natsort_key, natsort_coerce
from calibre_plugins.quarantine_and_scrub.heading import log_heading_common
from calibre_plugins.quarantine_and_scrub.convert_types_to_other_types import (qs_standardize_any_string,
                                                            qs_convert_list_of_nominal_book_ids_to_integers, qs_standardize_string_numerics)
from calibre_plugins.quarantine_and_scrub.debug_nicely import debug_nicely
notifications = Queue()
mynothing = ""
my_miscellany_option = "0"
my_run_type = "0"
my_guidb = ""
set_of_letters = set('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ')
set_of_letters.add('äëöüÜËÄÖáéíóúñçãÕõ')
set_of_numbers =  set('0123456789')
set_of_symbols = set(".,[]{}|?!=;:-_=+*#@&!`~\\//")
set_of_symbols.add('"')
set_of_symbols.add("'")
set_of_symbols.add("'.,&-")
set_of_numbers_letters = deepcopy(set_of_letters)
set_of_numbers_letters.add('0123456789')
set_of_numbers_letters_spaces = deepcopy(set_of_numbers_letters)
set_of_numbers_letters_spaces.add(" ")
set_of_numbers_letters_spaces.add("  ")
set_of_title_characters = deepcopy(set_of_numbers_letters)
set_of_title_characters.add(".,[]{}|?!=;:-_=+*#@&!`~\\//")
set_of_numbers_and_symbols = deepcopy(set_of_numbers)
set_of_numbers_and_symbols.add(".,[]{}|?!=;:-_=+*#@&!`~\\//")
probable_tags_to_add = []
tag_regex_rules = []
tag_capitalization_regex_rules = []
single_work_tags_all = []
this_date = "2014-11-02"
my_selected_book_list = []
current_library_path = ""
header_s1 = None
header_s2 = None
header_s3 = None
header_s4 = None
header_s5 = None
def main_scrub_miscellany(self, guidb, miscellany_option, run_type, selected_book_list, log=None, abort=None, notifications=True):
    global mynothing
    global my_run_type
    global my_miscellany_option
    global my_guidb
    global this_date
    global my_selected_book_list
    global current_library_path
    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    my_miscellany_option = as_unicode(miscellany_option)
    my_run_type = as_unicode(run_type)
    my_selected_book_list = deepcopy(selected_book_list)
    del selected_book_list
    notifications.put((0.01, 'Beginning Miscellaneous Scrubbing'))
    sleep(0.5)
    db = guidb
    path = db.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')
    current_library_path  = path
    log("Library DB: " + path)
    try:
        my_db =apsw.Connection(path)
    except Exception as e:
        log(as_unicode(e))
        raise e
        return
    my_cursor = my_db.cursor()
    mysql = "PRAGMA main.busy_timeout = 15000;"    
    my_cursor.execute(mysql)
    my_guidb = guidb
    header_s1 =  "SQLite Version: " + as_unicode(apsw.SQLITE_VERSION_NUMBER) + "  [APSW]"
    header_s2 = "Database is SHARED, not EXCLUSIVE"
    sleep(0.5)
    Create_SQLite_User_Functions(my_db, my_cursor, log)
    Scrub_Control(my_db, my_cursor, notifications, log)
    my_db.close()
    log(" ")
    log(" ")
    log(" ")
    log(" ")
    log("=============")
    log("Job complete.")
def Scrub_Control(my_db, my_cursor, notifications, log):
    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    global mynothing
    global my_run_type
    global my_miscellany_option
    header_s3 = "Beginning Miscellaneous Scrubbing"
    if my_miscellany_option == "1": 
        header_s4 = "Propagation of Work Tags"
        header_s5 = 'Propagating Work Tags from/to Books With The Identical Work Series'
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
        mysql = "PRAGMA main.busy_timeout = 15000;"    
        my_cursor.execute(mysql)
        misc1_control(my_db, my_cursor, notifications, log)
        apply_tag_string_replacement_rules(my_db, my_cursor, log)
        return
    if my_miscellany_option == "3": 
        header_s4 = "Book Level Tag Scrubbing for Selected Books"
        header_s5 = None
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
        mysql = "PRAGMA main.busy_timeout = 15000;"    
        my_cursor.execute(mysql)
        misc3_control(my_db, my_cursor, notifications, log)
        apply_tag_string_replacement_rules(my_db, my_cursor, log)
        remove_duplicate_work_tags(my_db, my_cursor, log)       
        return
    if my_miscellany_option == "4": 
        header_s4 = "Verify Work Series Index Using Web Lookup"
        header_s5 = "<font size='4'><b><font color='#990000'>Always Consolidate/Rename Series Prior To Running This Job</b></font>"
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
        mysql = "PRAGMA main.busy_timeout = 15000;"    
        my_cursor.execute(mysql)
        misc4_control(my_db, my_cursor, notifications, log)
        return
    if my_miscellany_option == "5": 
        header_s4 = "Rename Work Series Name to Web Series Name"
        header_s5 = None
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
        log("<font size='4'><b><font color='#990000'>This job uses the Historically Cumulative Web Source Series Validation Data previously downloaded anywhere in your Q&S ecosystem.</b></font>")
        log("<font size='4'><b><font color='#990000'>First run the Copy Tag & Title Rules and WSSVD job to copy all WSSVD among all of your Q&S Libraries.</b></font>")
        log("<font size='4'><b><font color='#990000'>WSSVD is created by the 2 jobs, [A] and [B], listed below:</b></font>")
        log("<font size='4'><b><font color='#990000'>[A] Download Web Series/Title/Indexes from Web Source for All Series for a Single Author (Regardless of Work Series).</b></font>")
        log("<font size='4'><b><font color='#990000'>[B] Validate Work Series/Title/Indexes from Web Source for All Selected Work Series.</b></font>")
        log("===============================================================================================================================")
        mysql = "PRAGMA main.busy_timeout = 15000;"    
        my_cursor.execute(mysql)
        misc5_control(my_db, my_cursor, notifications, log)
        return
    if my_miscellany_option == "9": 
        header_s4 =  "Minimize Work Tags Using Tag Priorities for All Books"
        header_s5 = None
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
        mysql = "PRAGMA main.busy_timeout = 15000;"    
        my_cursor.execute(mysql)
        remove_duplicate_work_tags(my_db, my_cursor, log)
        misc9_control(my_db, my_cursor, notifications, log)
        apply_tag_string_replacement_rules(my_db, my_cursor, log)
        return
    if my_miscellany_option == "10": 
        header_s4 = "Copy Tag & Title Rules From/To Previously Configured Q&S Libraries"
        header_s5 = None
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
        mysql = "PRAGMA main.busy_timeout = 15000;"    
        my_cursor.execute(mysql)
        misc10_control(my_db, my_cursor, notifications, log)
        return
    if my_miscellany_option == "14": 
        header_s4 = "Download Work Series/Titles/Indexes from Web Source for All Series for a Single Author [Single Author Only]"
        header_s5 = None
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
        mysql = "PRAGMA main.busy_timeout = 15000;"    
        my_cursor.execute(mysql)
        misc14_control(my_db, my_cursor, notifications, log)
        return
    if my_miscellany_option == "15": 
        header_s4 = 'Copy Work Tags to Custom Columns(s) Per Table "Tags CC Mapping Control" [Selected Books]'
        header_s5 = None
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
        mysql = "PRAGMA main.busy_timeout = 15000;"    
        my_cursor.execute(mysql)
        misc15_control(my_db, my_cursor, notifications, log)
        return
    if my_miscellany_option == "16": 
        header_s4 = 'Update Pseudonym Custom Column [Selected Books]'
        header_s5 = None
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
        mysql = "PRAGMA main.busy_timeout = 15000;"    
        my_cursor.execute(mysql)
        misc16_control(my_db, my_cursor, notifications, log)
        return
def misc1_control(my_db, my_cursor, notifications, log):
    notifications.put((0.01, 'Beginning Propagation of Tags'))
    global mynothing
    global my_run_type
    global my_miscellany_option
    sleep(0.02)
    build_regex_list_from_tag_capitalization_rules(my_db, my_cursor, log)
    sleep(0.02)
    mysql = as_unicode('DELETE FROM _tags_by_series ')
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.5)
    mysql = as_unicode("INSERT OR REPLACE INTO _tags_by_series SELECT seriesname,tagsall FROM __book_series_tags  \
                        WHERE seriesname NOT NULL AND tagsall NOT NULL AND tagsall != 'None' ")
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(1.5)
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT book,award,newtag FROM _tag_rules,_book_awards_mapping WHERE _book_awards_mapping.award = _tag_rules.oldtag and _tag_rules.purgetag = '0'  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        pass
    else:
        if len(tmp_rows) == 0:
            pass
        else:
            for row in tmp_rows:
                book,award,newtag = row
                mysql = "DELETE FROM _book_awards_mapping WHERE book = ?  AND  award = ?"
                execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql,book,award)
                mysql = "INSERT OR REPLACE INTO _book_awards_mapping (book,award) VALUES (?,?)"
                execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, book,newtag)
    book_awards_mapping_list = []
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT book,award FROM _book_awards_mapping "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        pass
    else:
        if len(tmp_rows) == 0:
            pass
        else:
            for row in tmp_rows:
                book_awards_mapping_list.append(row)
    book_awards_mapping_list.sort()
    awards_list = []
    tag_rules_list = []
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT oldtag,newtag FROM _book_awards,_tag_rules WHERE  (oldtag = award) AND purgetag = 0  GROUP BY oldtag,newtag"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        pass
    else:
        if len(tmp_rows) == 0:
            pass
        else:
            for row in tmp_rows:
                oldtag,newtag = row     
                awards_list.append(as_unicode(newtag))
                tag_rules_list.append(as_unicode(oldtag))
    mysql = "SELECT award FROM _book_awards "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        pass
    else:
        if len(tmp_rows) == 0:
            pass
        else:
            for row in tmp_rows:
                for col in row:
                    award = as_unicode(col)       
                    if not award in tag_rules_list:
                        if as_unicode(award) != as_unicode("Award"):
                            award = as_unicode(award.title())
                            awards_list.append(as_unicode(award))
    awards_list = list(set(awards_list))
    awards_list.sort(reverse=True)  
    mysql = "SELECT workseries,worktags FROM _tags_by_series WHERE workseries NOT NULL AND worktags NOT NULL"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        pass
    else:
        if len(tmp_rows) == 0:
            pass
        else:
            for row in tmp_rows:
                workseries,worktags  = row       
                orig_tags = worktags
                orig_workseries = workseries
                worktags = as_unicode(worktags.lower())
                for award in awards_list:
                    award = as_unicode(award.lower())
                    s0 = as_unicode( ", " + as_unicode(award) + ",")
                    worktags = as_unicode(worktags.replace(s0,"",10))
                    s0 = as_unicode(as_unicode(award) + ",")
                    worktags = as_unicode(worktags.replace(s0,"",10)) #  Fiction:-Paranormal, Fiction:Alternative-History, Fiction:Fantasy-Dark-Fantasy, Fiction:Thrillers-Medical, , Fiction:Thrillers-Espionage
                    s0 = as_unicode( ", " + as_unicode(award))
                    worktags = as_unicode(worktags.replace(s0,"",10))
                    if not "," in worktags:
                        s0 = as_unicode(award)
                        worktags = as_unicode(worktags.replace(s0,""))
                if worktags.endswith(","):
                    worktags = as_unicode(worktags[0: -1])
                if worktags.startswith(","):
                    worktags = as_unicode(worktags[1: ])
                worktags = as_unicode(worktags.replace(",,",","))
                worktags = as_unicode(worktags.replace(", ,",","))     
                worktags = as_unicode(worktags.replace("  "," "))
                if worktags.endswith(","):
                    worktags = as_unicode(worktags[0: -1])
                if worktags.startswith(","):
                    worktags = as_unicode(worktags[1: ])
                worktags = as_unicode(worktags.strip())
                mysql = "DELETE FROM _tags_by_series WHERE workseries = ? AND worktags = ? "
                execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, orig_workseries, orig_tags)
                mysql = "INSERT OR REPLACE INTO _tags_by_series (workseries,worktags) VALUES (?,?) "
                execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, orig_workseries, worktags)
    notifications.put((0.40, 'Collecting Tags By Series'))
    mysql = as_unicode("SELECT book, seriesname from __book_series_tags WHERE book NOT NULL AND seriesname NOT NULL ")
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        log("No Tags for Books With Series Found: " + as_unicode(seriesname))
        return
    else:
        notifications.put((0.60, 'Propagating Work Tags by Book'))
        for row in tmp_rows:
            book, seriesname = row
            utf8_seriesname = seriesname
            misc1__process_tags(my_db, my_cursor, log, book, seriesname, utf8_seriesname, book_awards_mapping_list)
    mysql = 'DELETE FROM custom_column_13 WHERE id IN __tags_unused'
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "UPDATE custom_column_13 SET value = (update_utf8_for_display(value) ) WHERE value NOT NULL;"
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = as_unicode('DELETE FROM _tags_by_series ')
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
def misc1__process_tags(my_db, my_cursor, log, book, seriesname, utf8_seriesname, book_awards_mapping_list):
    global mynothing
    mysql = "SELECT Count(*) FROM __book_series_tags WHERE seriesname = ? AND seriesname NOT NULL"
    my_cursor.execute(mysql,[utf8_seriesname])
    count1 = my_cursor.fetchall()
    count1 = "0"
    for row in count1:
        for col in row:
            count1 = col
    count1 = as_unicode(count1)
    if count1 == "1" or count1 == "0" :
        return
    else:
        pass
    tmp_tagsall_list = misc1_fetch_tagsall(my_db, my_cursor, log, seriesname)
    tmp_list_all = []
    for row in tmp_tagsall_list:
        s = as_unicode(row)
        s_list = s.split(",")
        for item in s_list:
            s1 = as_unicode(item)
            if as_unicode(s1) == as_unicode('None'):
                continue
            try:
                s1 = s1.lower()
            except:
                pass
            tmp_list_all.append(as_unicode(s1))
    tmp_set = set(tmp_list_all)       
    tmp_list_all = list(tmp_set)
    tmp_list_all.sort()
    del tmp_set
    new_tagsall = as_unicode("")
    for row in tmp_list_all:
        s = as_unicode(row)
        try:
            s = as_unicode(s.lowercase())
        except:
            pass
        if not "\\" in s:
            s = as_unicode(apply_tag_capitalization_rules(as_unicode(s),log))
        if s > " ":
            if "isbn" in s or s == "None" or s == "none" :
                pass
            else:
                new_tagsall = as_unicode(new_tagsall + ", " + as_unicode(s))
    for row in book_awards_mapping_list:
        awardbook,award = row
        awardbook = as_unicode(awardbook)
        award = as_unicode(award)
        book = as_unicode(book)
        if as_unicode(book) == as_unicode(awardbook):
            if not award in new_tagsall:   
                if not "\\" in award:
                    award = as_unicode(apply_tag_capitalization_rules(as_unicode(award),log))
                new_tagsall = new_tagsall + ", " + award
    if new_tagsall.startswith(","):
        new_tagsall = as_unicode(new_tagsall[1: ])
        new_tagsall = as_unicode(new_tagsall.strip())
    if new_tagsall.endswith(","):
        new_tagsall = as_unicode(new_tagsall[0: -1])
        new_tagsall = as_unicode(new_tagsall.strip())
    if new_tagsall == mynothing:
        return
    else:
        new_tagsall = unicode_type(new_tagsall)
    sleep(0.02)
    mysql = as_unicode('DELETE FROM books_custom_column_13_link WHERE book = "' + book  + '" ;')
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = as_unicode("INSERT OR REPLACE INTO custom_column_13 (id,value) VALUES (?,?)")
    execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, book, new_tagsall)
    sleep(0.02)
    mysql = as_unicode("INSERT OR REPLACE INTO books_custom_column_13_link (id,book,value) VALUES (?,?,?)")
    execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, book,book,book)
    sleep(0.02)
def misc1_fetch_tagsall(my_db, my_cursor, log, seriesname):
    tmp_tagsall_list = []
    del tmp_tagsall_list
    tmp_tagsall_list = []
    sleep(0.05)
    mysql = as_unicode('SELECT worktags  from  _tags_by_series  WHERE workseries = "' + seriesname + '" ;')
    tmp_tagsall = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    for row in tmp_tagsall:
        tagsall = as_unicode(row)
        try:
            tagsall = as_unicode(tagsall.lower())
        except:
            pass
        tmp_tagsall_list.append(tagsall)
    sleep(0.05)
    return tmp_tagsall_list
def misc3_control(my_db, my_cursor, notifications, log):
    global mynothing
    global set_of_letters
    global set_of_numbers
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_numbers_and_symbols
    global probable_tags_to_add
    global tag_regex_rules
    global single_work_tags_all  
    global my_selected_book_list
    if isinstance(probable_tags_to_add, list):
        probable_tags_to_add[:] = []
    else:
        probable_tags_to_add = []
    n = len(my_selected_book_list)
    log(" ")
    log("Number of books selected for Tag Scrubbing: " + as_unicode(n))
    log("New Work Tags also will be derived from Comments per table _tags_by_comment.")
    log("New Work Tags also will be derived per table _tag_combination_rules.")
    log(" ")
    sleep(0.02)
    build_regex_list_from_tag_rules(my_db, my_cursor, log)
    sleep(0.02)
    build_regex_list_from_tag_capitalization_rules(my_db, my_cursor, log)
    sleep(0.02)
    explode_custom_column_13_if_needed(my_db, my_cursor, log)
    sleep(0.02)
    build_book_awards_list(my_db, my_cursor, log)
    sleep(0.02)
    tmp_books_list = []
    for row in my_selected_book_list:
        books = as_unicode(row)
        books = as_unicode(qs_standardize_string_numerics(books))
        tmp_books_list.append(books)
    del my_selected_book_list
    n_total_tags_added = 0
    n_total = len(tmp_books_list)
    n_count = 0
    if n_total == 0:
        log("No books selected for Tag Scrubbing")
        return
    for row in tmp_books_list:
        my_current_book = as_unicode(row)
        probable_tags_to_add[:] = []
        probable_tags_to_add = misc3_derive_tags_from_comments(my_db, my_cursor, my_current_book, notifications, log)
        n = len(probable_tags_to_add)
        n_total_tags_added  = n_total_tags_added + n
        sleep(0.02)
        probable_tags_to_add = add_book_awards(my_db, my_cursor, my_current_book, notifications, log, probable_tags_to_add)
        scrub_tags(my_db, my_cursor, my_current_book, notifications, log,probable_tags_to_add)
        n_count = n_count + 1
        n_progress = float(n_count/n_total)
        notifications.put((n_progress, 'Deriving & Scrubbing Tags for Selected Books'))
    log(" ")
    log("Total New Work Tags Derived From Comments Prior to Tag Scrubbing:  " + as_unicode(n_total_tags_added))
    log(" ")
    sleep(0.02)
    add_tag_combinations(my_db, my_cursor, notifications, log)
    mysql = 'DELETE FROM custom_column_13 WHERE id IN __tags_unused'
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = 'UPDATE custom_column_13 SET value = (update_utf8_for_display(value) ) WHERE  id NOT NULL  ;'
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.5)
    mysql = 'DELETE FROM _tags_work_single'          
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.5)
    insert_single_tags_into_work_tags_single(my_db, my_cursor, notifications, log)
def misc3_derive_tags_from_comments(my_db, my_cursor, my_current_book, notifications, log):
    tags_to_add = []
    mysql = as_unicode("SELECT tag FROM _tags_by_comment WHERE EXISTS (SELECT text FROM comments  WHERE book = '[CURRENTBOOK]' \
                        AND comments.text LIKE '%'||_tags_by_comment.comment||'%'  ) ")
    mysql = as_unicode(mysql.replace("[CURRENTBOOK]", my_current_book))
    tmp_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_list:
        return tags_to_add
    else:
        if len(tmp_list) == 0:
            return tags_to_add
        else:
            for row in tmp_list:
                for col in row:
                    u0 = col
                    try:
                        tmp_tag = unicodedata.normalize('NFKD',u0).encode('ascii', 'ignore')
                    except:
                        pass
                    tmp_tag = as_unicode(tmp_tag)
                    if tmp_tag != mynothing:
                        tags_to_add.append(tmp_tag)
    n = len(tags_to_add)
    if n  == 0:
        return tags_to_add
    temp = set(tags_to_add)
    tags_to_add = list(temp)
    del temp
    return tags_to_add
def misc4_control(my_db, my_cursor, notifications, log):
    global mynothing
    global my_run_type
    global this_date
    global my_selected_book_list
    log("A Series need have only one (1) book selected to invoke the Series Validation for all books having that Series.")
    n = len(my_selected_book_list)
    log("Number of books selected for Series Validation: " + as_unicode(n))
    tmp_books_list = []
    for book in my_selected_book_list:
        book = int(qs_standardize_string_numerics(book))
        tmp_books_list.append(book)
    del my_selected_book_list
    n_total = len(tmp_books_list)
    if n_total == 0:
        log("No books selected for Series Validation")
        return
    explode_custom_column_10_if_needed(my_db, my_cursor, log)   
    socket.setdefaulttimeout(15)
    text_list = []
    misc4_purge_old_web_table_data(my_db, my_cursor, log)
    tmp_series_list = misc4_fetch_series(my_db, my_cursor, log, tmp_books_list)
    n_total = len(tmp_series_list)
    log("Number of Series Being Validated: " + as_unicode(n_total))
    log(" ")
    if n_total == 0:
        return
    n_counter = 0
    start_time = time.time()
    for row in tmp_series_list:
        authname, seriesname = row
        firstname = ""
        middlename = ""
        lastname = ""
        if "-" in authname:    
            n = authname.find("-")
            if n > 0:  
                authname = authname[0:n]
                if authname.endswith("-"):
                    authname = authname[0:-1]
                authname = authname.strip()
        if not "," in authname:
            if " " in authname:
                auth_split = authname.split(" ")
                n = len(auth_split)
                if n == 2: 
                    firstname = auth_split[0]
                    lastname = auth_split[1]
                elif n == 3:
                    firstname = auth_split[0]
                    middlename = auth_split[1]
                    lastname = auth_split[2]
                elif n == 4:
                    firstname = auth_split[0]
                    middlename = auth_split[1] + "-" + auth_split[2]
                    lastname = auth_split[3]
                else: 
                    firstname = auth_split[0]
                    middlename = ""
                    lastname = auth_split[n-1]
            else:
                firstname = " "
                middlename = ""
                lastname = authname
        else:
            auth_split = authname.split(",")
            lastname = auth_split[0].strip()
            middlename = ""
            firstname = auth_split[1].strip()
            if " " in firstname:
                auth_split = firstname.split(" ")
                n = len(auth_split)
                if n == 2: 
                    firstname = auth_split[0]
                    middlename = auth_split[1]
                elif n == 3:
                    firstname = auth_split[0]
                    middlename = auth_split[1] + "-" + auth_split[2]
                else: 
                    firstname = auth_split[0]
                    middlename = ""
                    lastname = auth_split[n-1]
        firstname = firstname.strip()
        middlename = middlename.strip()
        lastname = lastname.strip()
        seriesname = seriesname.strip()
        firstname = firstname.replace(".",mynothing)  
        n_progress = float(n_counter/n_total)
        notifications.put((n_progress, 'Validating Series'))
        n_counter = n_counter + 1
        text_list[:] = []
        log(" ")
        log("===================================================================================================================================================")
        log(" ")
        log(as_unicode(n_counter) + " of: " + as_unicode(n_total) )
        log(" ")
        if middlename > " ":
            middlename = " " + middlename + " "
        else:
            middlename = " "
        log("Current Actual Work Series:    " + seriesname + "   --- for Work Author: " + firstname + middlename  + lastname)
        orig_series = seriesname
        seriesname = misc4_genericize_seriesname(seriesname)
        log("Current Generic Work Series:   " + seriesname)
        my_url_domain = "www.fictiondb.com"
        my_url = "http://www.fictiondb.com/series/author-series~[LETTER].htm"
        try:
            elapsed_time = time.time() - start_time
            if elapsed_time < 2.0 :
                sleep((2.0 - elapsed_time))
            start_time = time.time()
            n_real_work_book_count, tmp_auth = misc4_unpack_soup_www_fictiondb_com(my_db, my_cursor,orig_series, seriesname, firstname, middlename, lastname, log)
            misc4_delete_web_table_duplicates(my_db, my_cursor, log)
            if n_real_work_book_count == 0 or tmp_auth == "None":
                log("<font size='3'><b><font color='#FF0000'>Web Source Did Not Respond For This Work Series</b></font>")
                continue
            misc4_validate_work_series_index(my_db, my_cursor, log, tmp_auth, orig_series, my_url, n_real_work_book_count, notifications)
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            return
    sleep(0.05)
    mysql = "INSERT OR REPLACE INTO _web_source_url_control (source_url) VALUES('" + my_url_domain + "')"
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = 'INSERT OR REPLACE INTO _global_web_author_series SELECT * FROM _web_author_series'
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = 'INSERT OR REPLACE INTO _global_web_series_detail SELECT * FROM _web_series_detail'
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "DELETE FROM _global_web_author_series WHERE authname LIKE '%-%' OR authname like '%0%' or  authname like '%1%' \
            OR authname like '%2%' or  authname like '%3%' OR authname like '%4%' OR  authname like '%5%' OR authname like '%6%' \
            OR  authname like '%7%' OR authname like '%8%' OR  authname like '%9%' OR  authname like '%\%' \
            OR authname LIKE '%</span>%' OR authname LIKE '%</a>%' OR authname LIKE '%~%'  OR authname LIKE '%unknown%' \
            OR seriesname LIKE '%</span>%'   "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "DELETE FROM _global_web_series_detail WHERE authname LIKE '%-%' OR authname like '%0%' or  authname like '%1%' \
            OR authname like '%2%' or  authname like '%3%' OR authname like '%4%' OR  authname like '%5%' OR authname like '%6%' \
            OR  authname like '%7%' OR authname like '%8%' OR  authname like '%9%' OR  authname like '%\%' \
            OR authname LIKE '%</span>%' OR authname LIKE '%</a>%' OR authname LIKE '%~%'  OR authname LIKE '%unknown%'  \
            OR seriesname LIKE '%</span>%' OR seriesindex = '0' \
            OR booktitle LIKE '%</span>%' OR booktitle LIKE '%</a>%' OR booktitle LIKE '%~%' \
            OR seriesname LIKE '%</span>%' OR booktitle LIKE '%</a>%' OR booktitle LIKE '%~%'    "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "INSERT OR IGNORE INTO _global_authors SELECT null,authname,'none',' ' FROM _web_author_series"
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "INSERT OR IGNORE INTO _global_series SELECT null,seriesname,seriesname FROM _web_author_series"
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    misc4_delete_web_table_duplicates(my_db, my_cursor, log)
    my_db.close()
def misc4_genericize_seriesname(seriesname):
    global mynothing
    orig_seriesname = seriesname
    seriesname = seriesname.replace("!", mynothing)
    seriesname = seriesname.replace("?", mynothing)
    seriesname = seriesname.replace(",", mynothing)
    seriesname = seriesname.replace(";", mynothing)
    seriesname = seriesname.replace(":", mynothing)
    seriesname = seriesname.replace(".", mynothing)
    seriesname = seriesname.replace("&", mynothing)
    seriesname = seriesname.replace("'s", mynothing)
    seriesname = seriesname.replace("'", mynothing)
    seriesname = seriesname.replace('"', mynothing)
    seriesname = seriesname.replace("/", " ")
    seriesname = seriesname.replace(" and ", " ")
    seriesname = seriesname.replace(" or ", " ")
    seriesname = seriesname.replace(" of ", " ")
    seriesname = seriesname.strip()
    if seriesname.startswith("Dr "):
        seriesname = seriesname[2: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("In the "):
        seriesname = seriesname[6: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("The "):
        seriesname = seriesname[4: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("An "):
        seriesname = seriesname[3: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("A "):
        seriesname = seriesname[2: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("It Is "):  
        seriesname = seriesname[6: ]
        seriesname = seriesname.strip()
    seriesname = seriesname.replace(" & the ", " ")
    seriesname = seriesname.replace(" and the ", " ")
    if seriesname.startswith("D.I. "):
        seriesname = seriesname[5: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("DI "):
        seriesname = seriesname[3: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("DS "):
        seriesname = seriesname[3: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("DCI "):
        seriesname = seriesname[4: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("D.i. "):
        seriesname = seriesname[5: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("Di "):
        seriesname = seriesname[3: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("Ds "):
        seriesname = seriesname[3: ]
        seriesname = seriesname.strip()
    if seriesname.startswith("Dci "):
        seriesname = seriesname[4: ]
        seriesname = seriesname.strip()
    seriesname = seriesname.replace("  ", " ")
    seriesname = seriesname.strip()
    for x in range(1,10):
        n = seriesname.count(" ")
        if n > 1:
            n1 = seriesname.find(" ")
            n2 = seriesname.rfind(" ")
            if n1 != n2:
                seriesname = seriesname[0:n2]
                seriesname = seriesname.strip()
            else:
               break
        else:
            pass
    if seriesname.endswith("s"):  
        seriesname = seriesname[0:-1]
        seriesname = seriesname.strip()
    if seriesname.endswith("Volume"):
        seriesname = seriesname[0:-6]
        seriesname = seriesname.strip()
    if seriesname.endswith("Novel"):
        seriesname = seriesname[0:-5]
        seriesname = seriesname.strip()
    if seriesname.endswith("'"):
        seriesname = seriesname[0:-1]
        seriesname = seriesname.strip()
    if seriesname.endswith("Mystery"):
        seriesname = seriesname[0:-7]
        seriesname = seriesname.strip()
    if seriesname.endswith(" and"):
        seriesname = seriesname[0:-3]
        seriesname = seriesname.strip()
    if seriesname.endswith("Trilogy"):
        seriesname = seriesname[0:-7]
        seriesname = seriesname.strip()
    if seriesname.endswith("&"):
        seriesname = seriesname[0:-1]
        seriesname = seriesname.strip()
    if seriesname.endswith(" by"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith("Mysterie"):
        seriesname = seriesname[0:-8]
        seriesname = seriesname.strip()
    if seriesname.endswith(" of"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith(" the"):
        seriesname = seriesname[0:-3]
        seriesname = seriesname.strip()
    if seriesname.endswith(" 01"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith(" 02"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith(" 03"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith(" 04"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith(" 05"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith(" 06"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith(" 07"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith(" 08"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith(" 09"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    if seriesname.endswith(" 10"):
        seriesname = seriesname[0:-2]
        seriesname = seriesname.strip()
    seriesname = seriesname.replace("  ", " ")
    seriesname = seriesname.strip()
    n = len(seriesname)
    if seriesname == mynothing or (not seriesname > " ") or (n <= 3):
        seriesname = orig_seriesname  
    return seriesname
def misc4_unpack_soup_www_fictiondb_com(my_db, my_cursor,orig_series, seriesname, firstname, middlename, lastname, log):
    my_list1 = []
    results = []
    results1 = []
    results2 = []
    results3 = []
    results_final = []
    firstname = firstname.replace(".",mynothing)  
    try:
        my_letter = lastname[0].lower()
    except:
        my_letter = lastname[0]
    firstname = firstname.strip()
    middlename = middlename.strip()
    lastname = lastname.strip()
    if middlename > " ":
        my_author_link = firstname + "-" + middlename  + "-" + lastname  
    else:
        my_author_link = firstname + "-"  + lastname    
    my_author_link = my_author_link.lower()
    my_series_link = seriesname.replace(" ", "-")          
    my_series_link = my_series_link.lower()                  
    my_series_link = my_series_link.replace(".", "")          
    my_find_link = "<../author/[FIRST-LAST]~series"
    my_find_link = my_find_link.replace("[FIRST-LAST]", my_author_link)
    my_url = "http://www.fictiondb.com/series/author-series~[LETTER].htm"
    my_url = my_url.replace("[LETTER]", my_letter)
    try:
        connection = urlopen(my_url)
        if not connection:
            return 0, "None"
        html_raw = connection.read()
        connection.close()
        if html_raw is None:
            return 0, "None"
        soup = BeautifulSoup(html_raw)
        if not soup:
            return 0, "None"
    except Exception as e:
        return 0, "None"
    results = soup.tbody
    if not results:
        return 0, "None"
    n = len(results)
    if n == 0:
        return 0, "None"
    for row in results:
        s = as_unicode(row)
        n = s.find(my_author_link)
        if not n >= 0:
            n = s.find(firstname)
            if not n >= 0:
                n = s.find(lastname)
                if not n >= 0:
                    continue
        n = s.find(seriesname)
        if not n >= 0:
            n = s.find(my_series_link) 
            if not n >= 0:
                n = s.find(orig_series) 
                if not n >= 0:
                    continue
        my_list1.append(s)
        break
    '''
        single soup results row:  <tr><td><span class="hide">Morganvill</span><a class="hghlt" href="../series/the-morganville-vampires-rachel-caine~9655.htm">The Morganville Vampires</a></td><td><a href="../author/rachel-caine~39124.htm">Caine, Rachel</a></td></tr>
    '''
    n = len(my_list1)
    if n == 0:
        return 0, "None"
    '''
        regex will search:
        <tr><td><span class="hide">Morganvill</span><a class="hghlt" href="../series/the-morganville-vampires-rachel-caine~9655.htm">The Morganville Vampires</a></td><td><a href="../author/rachel-caine~39124.htm">Caine, Rachel</a></td></tr>
    '''
    my_re_auth_series = 'href=.+[SERIES-NAME][a-z -]*[~][0-9]+[.]htm["]' 
    my_re_auth_series = my_re_auth_series.replace("[SERIES-NAME]", my_series_link)
    try:
        p = re.compile(my_re_auth_series, re.IGNORECASE)
    except:
        log("REGEX COMPILE ERROR in Parsing Web Page for: " + my_series_link )
        log("REGEX COMPILE ERROR in misc4_unpack_soup_www_fictiondb_com for: "  + my_re_auth_series )
        log("REGEX COMPILE ERROR: Please Forward This Log to the Developer.  Thank you.")
        return 0, "None"
    s_new_url = mynothing
    s_new_url_raw = mynothing
    for s in my_list1:
        match1 = p.search(s)
        if not match1:
            continue
        else:
            s_new_url = as_unicode(match1.group(0))
            s_new_url_raw = s
            break
    if s_new_url == mynothing:
        return 0, "None"
    s_new_url = s_new_url.replace('href="..', 'http://www.fictiondb.com')
    s_new_url = s_new_url.replace('.htm"', '.htm')
    s_web_series_name = misc4_parse_web_series_name(orig_series,my_author_link,s_new_url,s_new_url_raw,log)
    log("Retrieved Web Series Name:     " + s_web_series_name)
    log(" ")
    try:
        connection = urlopen(s_new_url)         
        if not connection:
            return
        html_raw = connection.read()
        connection.close()
        if not html_raw:
            return
        soup = BeautifulSoup(html_raw)
    except Exception as e:
        return
    if not soup:
        return
    results2 = soup.tbody
    if results2 is None:
        return
    for row in results2:
        if row is not None:
            s = as_unicode(row)
            n = s.find("td>")   
            if n >= 0:
                results3.append(s)
    n = len(results3)
    s_total_books = as_unicode(n)
    if n == 0:
        return 0, "None"
    '''   now have as a row:
        <td>1</td> [...and...] <td><a itemprop="url" href="../author/rachel-caine~glass-houses~159550~b.htm"><span itemprop='name'>Glass Houses</span></a>
    '''
    book_dict = {}
    my_re_index       = '<td class="text-center" nowrap="">[0-9][0-9]*</td>'     
    my_re_booktitle = '<span itemprop="name">.+</span></a></h2></td>' 
    try:
        p1 = re.compile(my_re_index, re.IGNORECASE)
        p2 = re.compile(my_re_booktitle, re.IGNORECASE)
    except:
        log("REGEX COMPILE ERROR in Parsing Web Page for: " + as_unicode(my_re_index) + " and: " + as_unicode(my_re_booktitle) )
        log("REGEX COMPILE ERROR in misc4_unpack_soup_www_fictiondb_com for: "  + as_unicode(s_new_url) )
        log("REGEX COMPILE ERROR: Please Forward This Log to the Developer.  Thank you.")
        return 0, "None"
    tmp_index = "0"
    tmp_title = ""
    for row in results3:
        if row is None:
            continue
        s = row
        match1 = p1.search(s)
        match2 = p2.search(s)
        if match1:      
            s = as_unicode(match1.group())
            s = s.replace('<td class="text-center" nowrap="">', mynothing)
            s = s.replace('</td>', mynothing)
            tmp_index = s.strip()
        if match2 :     
            s = as_unicode(match2.group())
            s = s.replace('<span itemprop="name">', mynothing)
            s = s.replace('</span></a></h2></td>', mynothing)
            tmp_title = s.strip()
            tmp_title = titlecase(tmp_title)
            book_dict[tmp_title] = as_unicode(tmp_index)
            tmp_index = "0"
            tmp_title = "NOTHINGTITLE"
        continue
    seriesname = as_unicode(orig_series)
    seriesname = misc4_genericize_seriesname(seriesname)
    mysql = "SELECT Count(*) FROM __books_work_populate WHERE seriesname LIKE '%" + seriesname + "%'  OR seriesname = ?"
    my_cursor.execute(mysql,([orig_series]))
    tmp_rows = my_cursor.fetchall()
    for row in tmp_rows:
        for col in row:
            n_real_work_book_count = as_unicode(col)
        break
    log("Number of Related Books In the Q&S Library:    " + n_real_work_book_count)
    log(" ")
    mysql = "SELECT authname,'dummy' FROM __books_work_populate WHERE seriesname LIKE '%" + seriesname + "%'  OR seriesname = ? "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=orig_series)
    if not tmp_rows:
        tmp_auth = "unknown"
    else:
        for row in tmp_rows:
            tmp_auth,dummy = row
            try:
                tmp_auth = unicodedata.normalize('NFKD', tmp_auth).encode('ascii', 'ignore')
            except:
                pass
            break
    if not s_total_books.isdigit():
        s_total_books = "0"
    for title,index in iteritems(book_dict):
        tmp_title = titlecase(title)
        tmp_index = index
        if tmp_title > " ":
            if not tmp_index[0].isdigit():
                pass
            else:
                log("Accumulating newly downloaded WSSVD:  ", s_web_series_name, "  -  ", tmp_title, "  -  ", tmp_index)
                sleep(0.05)
                mysql = 'INSERT OR REPLACE INTO _web_author_series (authname,seriesname,source_url,book_count) VALUES (?,?,?,?) '
                execute_mysql_for_custom_column_generic_4_args(my_db, my_cursor, log, mysql, tmp_auth, s_web_series_name, my_url, s_total_books)
                sleep(0.05)
                mysql = "INSERT OR  REPLACE INTO _web_series_detail (authname, seriesname, booktitle, seriesindex, source_url) VALUES (?,?,?,?,?) "
                execute_mysql_for_custom_column_generic_5_args(my_db, my_cursor, log, mysql, tmp_auth, s_web_series_name, tmp_title, tmp_index, my_url)
                sleep(0.05)
                mysql = 'INSERT OR REPLACE INTO _web_series_rename_detail (work_series,work_author,web_series,web_author) VALUES (?,?,?,?) '
                execute_mysql_for_custom_column_generic_4_args(my_db, my_cursor, log, mysql, orig_series, tmp_auth, s_web_series_name, tmp_auth)
                sleep(0.05)
    log(" ")
    mysql = "INSERT OR REPLACE INTO _web_series_rename_detail_cumulative SELECT * FROM _web_series_rename_detail "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "DELETE FROM _web_series_rename_detail"
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    return n_real_work_book_count, tmp_auth
def misc4_parse_web_series_name(orig_series,my_author_link,s_new_url,s_new_url_raw,log):
    if orig_series in s_new_url_raw:
        s_web_series_name = orig_series
        return s_web_series_name
    s_web_series_name = s_new_url.replace("http://www.fictiondb.com/series/","") #   the-morganville-vampires-rachel-caine~9655.htm
    n = s_web_series_name.rfind("~")
    s_web_series_name = s_web_series_name[0:n]
    s_web_series_name = s_web_series_name.replace(my_author_link,"")
    s_web_series_name = s_web_series_name.replace("-", " ")
    s_web_series_name = s_web_series_name.strip()
    s_web_series_name = titlecase(s_web_series_name)
    return s_web_series_name
def misc4_validate_work_series_index(my_db, my_cursor, log, tmp_auth, orig_series, my_url, n_real_work_book_count, notifications):
    global my_run_type
    seriesname = orig_series
    seriesname = misc4_genericize_seriesname(seriesname)
    mysql = "SELECT authname, booktitle, seriesname, seriesindex FROM __books_work_populate \
                   WHERE seriesname LIKE  '%" + seriesname + "%' OR seriesname = ? "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=orig_series)
    if not tmp_rows:
        log("Warning: Odd Abbreviations and/or Punctuation Exist.):  " + orig_series)
    num_work_series_books = len(tmp_rows)
    log(" ")
    log("Validation Results:")
    log(" ")
    all_books_okay = True
    tmp_rows.sort()
    for row in tmp_rows:  
        work_auth,work_title,work_series,work_index = row
        work_title_unaltered = titlecase(work_title)
        work_title = work_title.replace("'s", mynothing)     
        work_title = work_title.replace("'", "")      
        work_title = titlecase(work_title)
        work_index = as_unicode(work_index)
        work_index = work_index.replace(".0", mynothing)   
        mysql = "SELECT exists (SELECT booktitle FROM _web_series_detail WHERE (booktitle LIKE  '%The " + work_title + "%'  \
                                                                                                                                OR booktitle = '" + work_title + "'  \
                                                                                                                                OR booktitle LIKE  '%A " + work_title + "%'  \
                                                                                                                                OR booktitle LIKE  '%An " + work_title + "%' )  \
                                                                                                                                OR booktitle = ? )"
        results_list = my_cursor.execute(mysql,([work_title_unaltered]))
        n_title_exists = 0
        n_index_exists = 0
        for row in results_list:
            for col in row:
                n_title_exists = as_unicode(col)
        if n_title_exists == "1":
            s_msg = as_unicode("Work Title Same As Web Title.")
            title_same = True
        else:
            s_msg = as_unicode("<font color='#FF0000'>Work Title Was Not Found As A Web Title For This Web Author</font>")
            title_same = False
            index_same = False
            all_books_okay = False
        if title_same:
            mysql = "SELECT exists (SELECT seriesindex FROM _web_series_detail WHERE (booktitle LIKE  '%The " + work_title + "%'  \
                                                                                                                                    OR booktitle = '" + work_title + "'  \
                                                                                                                                    OR booktitle LIKE  '%A " + work_title + "%'  \
                                                                                                                                    OR booktitle LIKE  '%An " + work_title + "%' \
                                                                                                                                    OR booktitle = ? )  "
            mysql = mysql + " AND (seriesindex = '" + work_index + "' ) ) "
            results_list = my_cursor.execute(mysql,([work_title_unaltered]))
            for row in results_list:
                for col in row:
                    n_index_exists = as_unicode(col)
            if n_index_exists == "1":
                web_index = as_unicode(work_index + "     ")
                web_index = as_unicode(web_index[0:4])
                s_msg = "<font color='#21610B'>Web Series Index:" + as_unicode(web_index) + "  -- Identical</font>"
                index_same = True
            else:
                s_msg = "<font color='#FF0000'>Work Series Index Not Same as Web Series Index</font>"
                index_same = False
                all_books_okay = False
                mysql = "SELECT seriesindex,'dummy' FROM _web_series_detail WHERE (booktitle LIKE  '%The " + work_title + "%'  \
                                                                                                                                                    OR booktitle = '" + work_title + "'  \
                                                                                                                                                    OR booktitle LIKE  '%A " + work_title + "%'  \
                                                                                                                                                    OR booktitle LIKE  '%An " + work_title + "%' \
                                                                                                                                                    OR booktitle = ? )  "
                results_list = my_cursor.execute(mysql,([work_title_unaltered]))
                if not results_list:
                    s_msg = s_msg + " -- <font color='#FF0000'>Web Series Index Not Found in WSSVD to Compare</font>"
                else:
                    for row in results_list:
                        web_index,dummy = row
                        web_index = as_unicode(web_index)
                        web_index = web_index + "     "
                        web_index = web_index[0:4].strip()
                        s_msg = s_msg + " -- <font color='#FF0000'>Web Series Index: " + web_index  + "  -- DIFFERENT</font>"
                        break
        else:
            pass
        s_work_title = as_unicode(work_title_unaltered) + "                                             "  
        s_work_title = as_unicode(s_work_title[0:30])
        s_work_index = as_unicode(work_index) + "             "
        s_work_index = as_unicode(s_work_index[0:3])
        msg = "[Work Series]: " + orig_series + " [Work Title]: " + s_work_title + " [Work Index]: " + s_work_index + " : " + s_msg + "<br>"
        log(msg)
        msg = ""
        s_msg = ""
    if all_books_okay :
        log("<font size='5'><b><font color='#21610B'>All Valid</b></font>")
    else:
        log("<font size='5'><b><font color='#FF0000'>Discrepencies Noted</b></font>")
def misc4_fetch_series(my_db, my_cursor, log, tmp_books_list):
    tmp_series_list = []
    tmp_rows_save = []
    for book in tmp_books_list:
        book = int(book)
        mysql = 'SELECT authname,seriesname FROM __books_work_populate  WHERE seriesname NOT NULL AND book = ? '
        sleep(0.01)
        tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=book)
        if not tmp_rows:
            continue
        else:
            for item in tmp_rows:
                tmp_rows_save.append(item)
            del tmp_rows
    tmp_rows_save = list(set(tmp_rows_save))
    n = len(tmp_rows_save)
    log("Number of Unique Author-Series Selected: " + as_unicode(n))
    if n == 0:
        return tmp_series_list
    for row in tmp_rows_save:
        authname, seriesname = row
        try:
            authname = unicodedata.normalize('NFKD', authname).encode('ascii', 'ignore')
        except:
            pass
        authname = as_unicode(authname)
        try:
            seriesname = unicodedata.normalize('NFKD', seriesname).encode('ascii', 'ignore')
        except:
            pass
        seriesname = as_unicode(seriesname)
        s = authname, seriesname
        tmp_series_list.append(s)
    del tmp_rows_save
    tmp_series_list = list(set(tmp_series_list))
    tmp_series_list.sort()
    return tmp_series_list
def misc4_purge_old_web_table_data(my_db, my_cursor, log):
    sleep(0.05)
    mysql = 'DELETE FROM _web_author_series'
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = 'DELETE FROM _web_series_detail'
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "DELETE FROM _global_web_series_detail WHERE  seriesname LIKE '%fictiondb%' "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "DELETE FROM _global_web_author_series WHERE  seriesname LIKE '%fictiondb%' "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = as_unicode('DELETE FROM _global_web_author_series WHERE date_added  <  "2014-11-06" ') 
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = as_unicode('DELETE FROM _global_web_series_detail WHERE date_added  <  "2014-11-06" ') 
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
def misc4_delete_web_table_duplicates(my_db, my_cursor, log):
    mysql = "DELETE FROM _web_series_detail WHERE  seriesname LIKE '%fictiondb%' "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "DELETE FROM _web_author_series WHERE  seriesname LIKE '%fictiondb%' "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "DELETE FROM _web_series_detail WHERE  rowid NOT IN (SELECT min(rowid) FROM   _web_series_detail GROUP BY authname,seriesname,booktitle) "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "DELETE FROM _web_author_series WHERE  rowid NOT IN (SELECT min(rowid) FROM   _web_author_series GROUP BY authname,seriesname) "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "DELETE FROM _global_web_series_detail WHERE  seriesname LIKE '%fictiondb%' "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "DELETE FROM _global_web_author_series WHERE  seriesname LIKE '%fictiondb%' "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "DELETE FROM _global_web_author_series WHERE  rowid NOT IN (SELECT min(rowid) FROM   _global_web_author_series GROUP BY authname,seriesname) "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "DELETE FROM _global_web_series_detail WHERE  rowid NOT IN (SELECT min(rowid) FROM   _global_web_series_detail GROUP BY authname,seriesname,booktitle) "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
def misc5_control(my_db, my_cursor, notifications, log):
    global mynothing
    there_are_renamable = True
    sleep(0.5)
    explode_custom_column_8_if_needed(my_db, my_cursor, log)   
    sleep(0.5)
    explode_custom_column_10_if_needed(my_db, my_cursor, log)   
    sleep(0.02)
    misc5_mine_global_historical_data_for_use_in_renaming(my_db, my_cursor, notifications, log)
    sleep(0.25)
    mysql = "DELETE FROM _web_series_rename_detail_cumulative WHERE  work_series = web_series \
                        OR web_series IS NULL OR work_series IS NULL OR work_series = 'Novel'  OR  work_series = 'novel' \
                        OR work_series = ' '  OR  work_series = ''      ;  "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = "INSERT OR IGNORE INTO _web_series_rename_detail SELECT * FROM _web_series_rename_detail_cumulative \
                                                    WHERE work_series IN(SELECT value FROM custom_column_10 WHERE value NOT NULL)  "
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = "SELECT book, work_series FROM __web_series_rename_detail_view_part1"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
            log("Not able to rename any Work Series to Web Series.  Perhaps renaming was previously done, and/or nothing now needs renaming.  Refer to the notes at the top of this log. ")
            log(" ")
            renamable = False 
    notifications.put((0.01, 'Work Title to Web Title Renaming'))
    log("Beginning Work Title to Web Title Renaming.")
    log(" ")
    change_work_title_to_web_title_for_previously_validated_work_series(my_db, my_cursor, notifications, log)
    if not there_are_renamable:   
        tmp_rows = []
        del tmp_rows
        notifications.put((0.50, 'Adding Missing Work Series If Found in Web Data'))
        mysql = "SELECT book FROM __books_work_populate WHERE __books_work_populate.authname NOT NULL \
                    AND __books_work_populate.booktitle NOT NULL AND __books_work_populate.seriesname IS NULL "
        tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
        if tmp_rows:
            n = len(tmp_rows)
            if n > 0:
                log("Missing Work Series will be added if any Web Series for the Author/Title is found in the historical Web Data for: " + as_unicode(n) + " potential books.")
                log(" ")
                for row in tmp_rows:
                    book = as_unicode(row)
                    book = as_unicode(qs_standardize_string_numerics(book))
                    book = as_unicode(book.strip())
                    add_missing_seriesname_from_web_detail(my_db, my_cursor, book,notifications, log)
                    refresh_custom_column_15(my_db, my_cursor, book, notifications, log)
                pass
            else:
                pass
        else:
            pass
    if not there_are_renamable:
        log(" ")
        log("Changing Work Series Index to Web Series Index if appropriate.")
        miscellany_change_work_index_to_web_index_standalone(my_db, my_cursor, notifications, log)
        return
    sleep(0.02)
    notifications.put((0.50, 'Renaming Work Series to Web Series'))
    n_total = len(tmp_rows)
    n_counter = 0
    for row in tmp_rows:
        id,work_series = row
        id = as_unicode(id)  
        id = as_unicode(id.strip())
        work_series = as_unicode(work_series)  
        work_series = as_unicode(work_series.strip())
        work_series = as_unicode(work_series + "                                   ")
        work_series = as_unicode(work_series[0:35])
        sleep(0.02)
        mysql = as_unicode("UPDATE custom_column_10 SET value = ( SELECT web_series FROM __web_series_rename_detail_view_part2 \
                      WHERE __web_series_rename_detail_view_part2.work_series =  custom_column_10.value \
                      AND __web_series_rename_detail_view_part2.web_series != custom_column_10.value \
                      AND __web_series_rename_detail_view_part2.web_series NOT NULL ) \
                      WHERE (custom_column_10.value NOT NULL AND custom_column_10.id = ? AND custom_column_10.id = ? ) \
                      AND (EXISTS (SELECT * FROM __web_series_rename_detail_view_part2 \
                                            WHERE __web_series_rename_detail_view_part2 .work_series = custom_column_10.value \
                                                AND __web_series_rename_detail_view_part2.web_series != custom_column_10.value \
                                                AND __web_series_rename_detail_view_part2.web_series NOT NULL )) ")
        execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, id, id)
        log(" ")
        log("[Invalid Work Series Name]: " + as_unicode(work_series) + "   --- Changed to the correct Web Source Web Series Name per previously downloaded WSSVD.")
        sleep(0.02)
        refresh_custom_column_15(my_db, my_cursor, id, None, log)
        n_counter = n_counter + 1
        n_progress = float((.50*(n_counter/n_total)) + 0.50)
        notifications.put((n_progress, 'Renaming Work Series to Web Series'))
    notifications.put((0.99, 'Renaming Other Work Values to Web Values'))
    log(" ")
    log("-------------------------------------------------------------------------------------------------------------------------------------------")
    log(" ")
    log("Total Invalid Work Series Names Changed to Valid Web Series Names Previously Logged: " + as_unicode(n_counter))
    log(" ")
    log("-------------------------------------------------------------------------------------------------------------------------------------------")
    log(" ")
    tmp_rows = []
    del tmp_rows
    sleep(0.02)
    mysql = "SELECT book FROM __web_global_seriesindex_not_match_work_seriesindex WHERE web_seriesindex NOT NULL and web_seriesindex != '0'  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_rows:
        n = len(tmp_rows)
        if n > 0:
            for row in tmp_rows:
                book = as_unicode(row)
                book = qs_standardize_string_numerics(book)
                book = as_unicode(book.strip())
                mysql = as_unicode("UPDATE custom_column_12 SET value = (SELECT web_seriesindex FROM __web_global_seriesindex_not_match_work_seriesindex \
                                    WHERE __web_global_seriesindex_not_match_work_seriesindex.book = custom_column_12.book \
                                    AND __web_global_seriesindex_not_match_work_seriesindex.work_seriesindex = custom_column_12.value ) \
                                    WHERE custom_column_12.book =?  AND custom_column_12.book = ?  ;")
                execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, book, book)
                refresh_custom_column_15(my_db, my_cursor, book, None, log)
            log("Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + as_unicode(n))
            log(" ")
            log("-------------------------------------------------------------------------------------------------------------------------------------------")
            log(" ")
    tmp_rows = []
    del tmp_rows
    change_work_title_to_web_title_for_previously_validated_work_series(my_db, my_cursor, notifications, log)
    sleep(0.02)
    mysql = as_unicode("DELETE FROM _web_series_rename_detail WHERE work_series NOT NULL")
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    log(" ")
    log(" ")
    log(" ")
    sleep(0.02)
    tmp_rows = []
    del tmp_rows
    notifications.put((0.99, 'Adding Missing Work Series If Found in Web Data'))
    mysql = "SELECT book FROM __books_work_populate WHERE __books_work_populate.authname NOT NULL \
                AND __books_work_populate.booktitle NOT NULL AND __books_work_populate.seriesname IS NULL "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_rows:
        n = len(tmp_rows)
        if n > 0:
            log("Missing Work Series will be added if any Web Series for the Author/Title is found in the historical Web Data.")
            log(" ")
            for row in tmp_rows:
                book = as_unicode(row)
                book = as_unicode(qs_standardize_string_numerics(book))
                book = as_unicode(book.strip())
                add_missing_seriesname_from_web_detail(my_db, my_cursor, book,notifications, log)
                refresh_custom_column_15(my_db, my_cursor, book, notifications, log)
    sleep(0.02)
    my_db.close()
    return
def misc5_mine_global_historical_data_for_use_in_renaming(my_db, my_cursor, notifications, log):
    mynothing = ""
    n_count = 0
    tmp_books_list = misc5_fetch_all_books_with_series(my_db, my_cursor, log)
    tmp_series_list = misc4_fetch_series(my_db, my_cursor, log, tmp_books_list)
    for row in tmp_series_list:       
        work_auth, work_series = row
        work_series = work_series.replace("'", mynothing)
        work_series = work_series.replace('"', mynothing)
        work_auth = work_auth.replace("'", mynothing)
        work_auth = work_auth.replace('"', mynothing)
        generic_series = misc4_genericize_seriesname(work_series)
        mysql = "SELECT authname,seriesname FROM _global_web_author_series \
                                WHERE (authname = " + "'[work_auth]'" + " ) \
                                    AND ( (seriesname = " + "'[work_series]'" + " ) OR \
                                             (seriesname like '%[work_series]%' ) OR \
                                             (seriesname like '%[generic_series]%' ) OR \
                                             (seriesname = " + "'[generic_series]'" + " )   ) "
        mysql = mysql.replace("[work_auth]", work_auth)
        mysql = mysql.replace("[work_series]", work_series)
        mysql = mysql.replace("[generic_series]", generic_series)
        tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
        if not tmp_rows:
            continue
        else:
            for row in tmp_rows:
                web_auth, web_series_name = row
                mysql = 'INSERT OR IGNORE INTO _web_series_rename_detail_cumulative (work_series,work_author,web_series,web_author) VALUES (?,?,?,?) '
                execute_mysql_for_custom_column_generic_4_args(my_db, my_cursor, log, mysql, work_series, work_auth, web_series_name, web_auth)
                sleep(0.02)
                n_count = n_count + 1
            del tmp_rows
    log("Number of Historically Cumulative Web Source Records Matching Current List of Work Series Names: " + as_unicode(n_count) )
    mysql = as_unicode('INSERT OR REPLACE INTO _web_author_series SELECT * FROM _global_web_author_series')
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = as_unicode('INSERT OR REPLACE INTO _web_series_detail SELECT * FROM _global_web_series_detail')
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    log(" ")
    log("All Historically Cumulative Web Source Records from All Q&S Libraries are Available for Use in Renaming in This Q&S Library.")
    log(" ")
def misc5_fetch_all_books_with_series(my_db, my_cursor, log):
    tmp_books_list = []
    mysql = as_unicode('SELECT id FROM custom_column_10 ;')
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            book = as_unicode(row)
            book = as_unicode(qs_standardize_string_numerics(book))
            tmp_books_list.append(book)
    return  tmp_books_list
def misc9_control(my_db, my_cursor, notifications, log):
    build_regex_list_from_tag_capitalization_rules(my_db, my_cursor, log)
    sleep(0.02)
    explode_custom_column_13_if_needed(my_db, my_cursor, log)      
    sleep(0.5)
    awards_list = []
    mysql = "SELECT newtag FROM _tag_rules WHERE oldtag IN(SELECT award FROM _book_awards) AND purgetag = '0'  AND newtag NOT NULL "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            for col in row:
                award = as_unicode(col)
                award = as_unicode(award.title())
                awards_list.append(award)
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT award FROM _book_awards GROUP BY award"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            for col in row:
                award = as_unicode(col)
                award = as_unicode(award.title())
                awards_list.append(as_unicode(award))
    tmp_set = set(awards_list)
    awards_list = list(tmp_set)
    awards_list.sort(reverse=True)   
    global my_selected_book_list
    tmp_books_list = []
    for row in my_selected_book_list:
        books = as_unicode(row)
        books = as_unicode(qs_standardize_string_numerics(books))
        tmp_books_list.append(books)
    del my_selected_book_list
    n_total = len(tmp_books_list)
    if n_total == 0:
        log("No books selected for Minimizing Work Tags Using Tag Priorities")
        return
    else:
        log("Books selected for Minimizing Work Tags Using Tag Priorities: " + as_unicode(n_total))
    log(" ")
    from calibre_plugins.quarantine_and_scrub.config import prefs
    maximum_tags = prefs['maximum_tags']
    if not maximum_tags:
        maximum_tags = 10
    log("Configured 'maximum tags' to be used is:  " + as_unicode(maximum_tags))
    ignore_award_tags_prefs = prefs['ignore_award_tags']
    log(" ")
    if ignore_award_tags_prefs == "True" or ignore_award_tags_prefs[0] == 'T' :
        ignore_award_tags = 'True'
    else:
        ignore_award_tags = 'False'
        del awards_list
        awards_list = [] 
    log("Configured 'Ignore Award Tags' is:  " + as_unicode(ignore_award_tags))
    if ignore_award_tags:
        n = len(awards_list)
        log("The number of Awards as Work Tags to be ignored: " + as_unicode(n))
        for row in awards_list:
            log("Award as Work Tag to be Ignored: " + as_unicode(row))
        log(" ")
    try:
        maximum_tags = int(float(maximum_tags))
        if maximum_tags <= 0 or maximum_tags > 100:
            log("ERROR.  Configured maximum_tags is invalid.  Terminating.")
            return
    except:
        log("ERROR.  Configured maximum_tags is invalid.  Terminating.")
        return
    maximum_commas = maximum_tags - 1   
    award_maximum_commas = maximum_tags
    book_dict = {}
    tmp_rows = []
    for row in tmp_books_list:
        del tmp_rows
        my_current_book = as_unicode(row)
        mysql = as_unicode("SELECT id, value FROM custom_column_13 WHERE (value NOT NULL) AND ( instr(value,',') > 0 ) AND  (instr(value,',') NOT NULL) \
                                                                                                        AND id = [BOOK] ")
        mysql = as_unicode(mysql.replace("[BOOK]", as_unicode(my_current_book)))
        tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
        if not tmp_rows:
            continue
        else:
            for row in tmp_rows:
                id, value = row
                try:
                    tagsconcat = unicodedata.normalize('NFKD', value).encode('ascii', 'ignore')
                except:
                    pass
                tagsconcat = as_unicode(tagsconcat)
                found_award = False
                for award in awards_list:
                    if tagsconcat.count(as_unicode(award)) > 0:
                        found_award = True
                        break
                    else:
                        continue
                n1 = tagsconcat.count(",")
                if not found_award:
                    if n1 < maximum_commas:
                        continue
                else:
                    if n1 < award_maximum_commas:
                        continue
                    else:
                        pass
                book = as_unicode(id)
                book_dict[book] = as_unicode(tagsconcat)
    n = len(book_dict)
    if n == 0:
        log("[2] Nothing found to minimize.  Finished.")
        return
    else:
        priority_dict = misc9_fetch_tag_priorities(my_db, my_cursor, notifications, log)
        new_book_dict = misc9_process_tags(my_db, my_cursor, notifications, log, book_dict, priority_dict, maximum_tags, awards_list)
        misc9_update_custom_column_13(my_db, my_cursor, notifications, log, new_book_dict)
def misc9_fetch_tag_priorities(my_db, my_cursor, notifications, log):
    priority_dict = {}
    mysql = as_unicode("SELECT tag, priority FROM _tag_priorities ")
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        log("[3] No Tag Priorities Found in the Tag Priorities Table.  Finished.")
        return
    else:
        for row in tmp_rows:
            tag, priority = row
            try:
                tag = unicodedata.normalize('NFKD', tag).encode('ascii', 'ignore')
            except:
                pass
            tag = as_unicode(tag)
            priority = as_unicode(priority)
            priority = as_unicode(qs_standardize_string_numerics(priority))
            priority = int(float(priority))
            priority_dict[tag] = priority
    return priority_dict
def misc9_process_tags(my_db, my_cursor, notifications, log, book_dict, priority_dict, maximum_tags, awards_list):
    have_awards = False
    n0 = len(awards_list)
    if n0 > 0:
        have_awards = True
    awards_list.sort(reverse=True)
    new_book_dict = {}
    tmp_list = []
    list_of_tags = []
    for book, tagsconcat in iteritems(book_dict):
        b = as_unicode(book)
        t = as_unicode(tagsconcat)
        del tmp_list
        if not "," in t:   
            t = as_unicode(as_unicode(t) + as_unicode(", "))
        tmp_list = t.split(",")
        del list_of_tags
        list_of_tags = []
        for row in tmp_list:
            tag = as_unicode(row)
            tag = as_unicode(tag.strip())
            tag = as_unicode(tag.title())
            list_of_tags.append(as_unicode(tag))
        award_count = 0
        if have_awards:
            for tag in list_of_tags:
                for award in awards_list:
                    award = as_unicode(award.title())
                    if as_unicode(tag) == as_unicode(award):
                        award_count = award_count + 1   
                    else:
                        pass
        else:
            pass
        n = len(list_of_tags)
        if n >  (maximum_tags + award_count) :
            new_list_of_tags = misc9_prioritize_tags_for_book(my_db, my_cursor, log, list_of_tags,priority_dict, maximum_tags, award_count, awards_list)
            tagsconcat = as_unicode(misc9_concat_tags_for_book(new_list_of_tags))
            new_book_dict[book] = as_unicode(tagsconcat)
        else:
            continue
    return new_book_dict
def misc9_prioritize_tags_for_book(my_db, my_cursor, log, list_of_tags,priority_dict, maximum_tags, award_count, awards_list):
    new_list_of_tags = []
    tmp_list_of_tags = []
    tags_to_add_to_table_tag_priorities = []
    for row in list_of_tags:
        t = as_unicode(row)
        t = as_unicode(t.title())
        p = 0
        for award in awards_list: 
            award = as_unicode(award.title())
            if as_unicode(award) == as_unicode(t):
                p = 999
                break
        if p == 999:
            pass
        else:
            try:
                p = priority_dict[t]
            except:
                log("No Priority in Table _tag_priorities for Tag: " + as_unicode(t) + "  so Priority Defaulted to 0 and Added to Table _tag_priorities.  Now needs review.")
                p = 0
                tags_to_add_to_table_tag_priorities.append(as_unicode(t))
        if p < 100:
            if p < 10:
                x = as_unicode("00" + as_unicode(p))
            else:
                x = as_unicode("0" + as_unicode(p))
        else:
            if p > 999 :
                p = 999
            x = as_unicode(p)
        tmp_s = as_unicode(as_unicode(x) + as_unicode("|||") + as_unicode(t))
        tmp_list_of_tags.append(as_unicode(tmp_s))
    sorted_list = natsort(tmp_list_of_tags, reverse=True) 
    maximum_tags = maximum_tags + award_count
    n_count = len(sorted_list)
    n_index = 0
    while (n_index < n_count) and (n_index <= (maximum_tags - 1)) :
        s = sorted_list[n_index]
        s_list = s.split("|||")
        t = as_unicode(s_list[1])
        t = as_unicode(apply_tag_capitalization_rules(as_unicode(t),log))
        new_list_of_tags.append(as_unicode(t))
        n_index = n_index + 1
    n = len(tags_to_add_to_table_tag_priorities)
    if n > 0:
        mysql = "INSERT OR IGNORE INTO _tag_priorities (tag,priority) VALUES (?,?) "
        for row in tags_to_add_to_table_tag_priorities:
            tag = as_unicode(row)
            priority = 0
            execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, tag, priority)
    else:
        pass
    return new_list_of_tags
def misc9_concat_tags_for_book(list_of_tags):
    list_of_tags.sort()
    tagsconcat = as_unicode("")
    for row in list_of_tags:
        tagsconcat = as_unicode(as_unicode(tagsconcat) + as_unicode(row) + as_unicode(", "))
    tagsconcat = as_unicode(tagsconcat[0:-2])   
    return as_unicode(tagsconcat)
def misc9_update_custom_column_13(my_db, my_cursor, notifications, log, new_book_dict):
    n = len(new_book_dict)
    if n == 0:
        log("[4] Nothing Needs to Be Changed (Verify Configuration Settings).  Finished.")
        return
    mysql = as_unicode("UPDATE custom_column_13 SET value = ? WHERE id = ? ")
    for book, tagsconcat in iteritems(new_book_dict):
        b = as_unicode(book)
        t = as_unicode(tagsconcat)
        t = as_unicode(apply_tag_capitalization_rules(as_unicode(t),log))
        execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, t, b)
def misc10_control(my_db, my_cursor, notifications, log):
    from calibre_plugins.quarantine_and_scrub.config import prefs
    global current_library_path
    qs_library_best_rules = prefs['qs_library_best_rules']
    qs_library_1 = prefs['qs_library_1']
    qs_library_2 = prefs['qs_library_2']
    qs_library_3 = prefs['qs_library_3']
    qs_library_4 = prefs['qs_library_4']
    log(" ")
    log("Q&S Library with the Best Tag, Title & Series Rules and Web Source Series Validation Data (WSSVD) is:   " + as_unicode(qs_library_best_rules) )
    log(" ")
    log("Q&S Target Library [1] for Tag, Title & Series Rules and WSSVD is:   " + as_unicode(qs_library_1))
    log(" ")
    log("Q&S Target Library [2] for Tag, Title & Series Rules and WSSVD is:   " + as_unicode(qs_library_2))
    log(" ")
    log("Q&S Target Library [3] for Tag, Title & Series Rules and WSSVD is:   " + as_unicode(qs_library_3))
    log(" ")
    log("Q&S Target Library [4] for Tag, Title & Series Rules and WSSVD is:   " + as_unicode(qs_library_4))
    log(" ")
    nb= len(qs_library_best_rules)
    n1 = len(qs_library_1)
    n2 = len(qs_library_2)
    n3 = len(qs_library_3)
    n4 = len(qs_library_4)
    if nb < 16:
        log("Incorrect Q&S Configuration for the Q&S Library with the Best Tag, Title & Series Rules:   " + as_unicode(qs_library_best_rules) )
        return
    if n1 < 16 and n2 < 16 and n3 < 16 and n4 < 16:
        log("Incorrect Q&S Configuration for the 4 possible Q&S Target Libraries.  At least one (1) of them must be valid.")
        return
    if (qs_library_best_rules == qs_library_1 or \
         qs_library_best_rules == qs_library_2 or \
         qs_library_best_rules == qs_library_3 or \
         qs_library_best_rules == qs_library_4):
        log("Your Best Q&S Library Cannot Be a Target Q&S Library!  Invalid Configuration.  Terminating.")
        return
    if qs_library_best_rules != current_library_path :
        path1 = as_unicode(qs_library_best_rules)
        path1 = as_unicode(path1.replace(os.sep, '/'))
        path2 = as_unicode(current_library_path)
        path2 = as_unicode(path2.replace(os.sep, '/'))
        if path1 != path2:
            log("This job MUST be run from your Best Q&S Library.  Terminating.")
            log("If you feel this message is in error, verify  '/'s and '\\'s in your configuration of the path of your Best Q&S Library.")
            return
    status = True
    status_best = False
    status_t1 = False
    status_t2 = False
    status_t3 = False
    status_t4 = False
    name = as_unicode("Best")
    path = qs_library_best_rules
    status = misc10_attach_qs_metadata_db(my_db, my_cursor, path, name, log)
    if not status:
        return
    else:
        status_best = True
    if n1 >= 16:
        name = as_unicode("T1")
        path = qs_library_1
        status = misc10_attach_qs_metadata_db(my_db, my_cursor, path, name, log)
        if not status:
            return
        else:
            status_t1 = True
    if n2 >= 16:
        name = as_unicode("T2")
        path = qs_library_2
        status = misc10_attach_qs_metadata_db(my_db, my_cursor, path, name, log)
        if not status:
            return
        else:
            status_t2 = True
    if n3 >= 16:
        name = as_unicode("T3")
        path = qs_library_3
        status = misc10_attach_qs_metadata_db(my_db, my_cursor, path, name, log)
        if not status:
            return
        else:
            status_t3 = True
    if n4 >= 16:
        name = as_unicode("T4")
        path = qs_library_4
        status = misc10_attach_qs_metadata_db(my_db, my_cursor, path, name, log)
        if not status:
            return
        else:
            status_t4 = True
    if status_best and (status_t1 or status_t2 or status_t3 or status_t4):
        misc10_create_in_memory_db(my_db, my_cursor, log)
        misc10_copy_rules_among_qs_databases(my_db, my_cursor, log, status_t1, status_t2, status_t3, status_t4)
        misc10_log_results(my_db, my_cursor, notifications, log)
        misc10_copy_tags_to_best_db(my_db, my_cursor, log)
        return
    else:
        log("Incorrect Q&S Configuration for the 4 possible Q&S Target Libraries.  At least one of them must be valid.")
        return
def misc10_create_in_memory_db(my_db, my_cursor, log):
    try:
        sleep(0.5)
        mysql = "ATTACH DATABASE ':memory:' AS 'Mem1'   ;"
        my_cursor.execute(mysql)
        my_cursor.execute("begin")
        mysql = 'CREATE TABLE IF NOT EXISTS Mem1._tags_copied_from_other_libraries ( id   INTEGER PRIMARY KEY,name TEXT NOT NULL COLLATE NOCASE,UNIQUE (name) )'
        my_cursor.execute(mysql)
        mysql = 'CREATE TABLE IF NOT EXISTS Mem1._tags_work_single (tag TEXT NOT NULL , subject TEXT NOT NULL , PRIMARY KEY (tag, subject))'
        my_cursor.execute(mysql)
        mysql = "CREATE TABLE IF NOT EXISTS Mem1._global_web_author_series (authname TEXT NOT NULL , seriesname TEXT NOT NULL , source_url TEXT NOT NULL , \
                        book_count INTEGER NOT NULL  DEFAULT 0, date_added DATETIME NOT NULL  DEFAULT CURRENT_TIMESTAMP, \
                        PRIMARY KEY (authname, seriesname)  UNIQUE (authname, seriesname) ON CONFLICT REPLACE )"
        my_cursor.execute(mysql)
        mysql = "CREATE TABLE IF NOT EXISTS Mem1._global_web_series_detail (authname TEXT NOT NULL, seriesname TEXT NOT NULL, booktitle TEXT NOT NULL ,\
                        seriesindex TEXT NOT NULL , source_url TEXT NOT NULL , date_added DATETIME NOT NULL  DEFAULT CURRENT_TIMESTAMP,\
                        PRIMARY KEY (authname, seriesname, booktitle) UNIQUE (authname, seriesname, booktitle) ON CONFLICT REPLACE )"
        my_cursor.execute(mysql)
        mysql = "CREATE TABLE IF NOT EXISTS Mem1._pristine_authors  ( id   INTEGER PRIMARY KEY, \
                              name TEXT NOT NULL COLLATE NOCASE, \
                              sort TEXT COLLATE NOCASE, \
                              link TEXT NOT NULL DEFAULT ' ' ,  \
                              UNIQUE(name) )"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.02)
    except Exception as e:
        log(as_unicode(e))
        log("FAILED:  CREATE TABLE IF NOT EXISTS Mem1._tags_copied_from_other_libraries ")
        pass 
def misc10_copy_tags_to_best_db(my_db, my_cursor, log):
    try:
        mysql = "DETACH 'T1'"
        my_cursor.execute(mysql)
    except:
        pass
    try:
        mysql = "DETACH 'T2'"
        my_cursor.execute(mysql)
    except:
        pass
    try:
        mysql = "DETACH 'T3'"
        my_cursor.execute(mysql)
    except:
        pass
    try:
        mysql = "DETACH 'T4'"
        my_cursor.execute(mysql)
    except:
        pass
    try:
        mysql = "DETACH 'Best'"
        my_cursor.execute(mysql)
    except:
        pass
    try:
        my_cursor.execute("begin")
        mysql = "DELETE FROM main._tags_copied_from_other_libraries"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO main._tags_copied_from_other_libraries  SELECT null, name FROM Mem1._tags_copied_from_other_libraries \
                                                                        WHERE name NOT IN(SELECT oldtag FROM main._tag_rules )"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO main._tags_work_single  SELECT tag, subject FROM Mem1._tags_work_single \
                                                                        WHERE tag NOT IN(SELECT oldtag FROM main._tag_rules )"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO main._global_web_author_series SELECT * FROM Mem1._global_web_author_series;"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO main._global_web_series_detail SELECT * FROM Mem1._global_web_series_detail;"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO main._pristine_authors SELECT * FROM Mem1._pristine_authors;"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
    except Exception as e:
        log(as_unicode(e))
        log("FAILED: INSERT OR IGNORE INTO main._tags_copied_from_other_libraries  SELECT * FROM Mem1._tags_copied_from_other_libraries")
        pass
def misc10_log_results(my_db, my_cursor, notifications, log):
    log(" ")
    log("===================================")
    log(" ")
    mysql = "SELECT Count(*) FROM Best._tag_rules"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Tag Rules Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._tag_priorities"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Tag Priorities Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._title_rules"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Title Rules Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._series_rules"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Series Rules Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._pristine_authors"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Pristine Authors Copied from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._global_web_author_series"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Web Source Series Validation Author/Series Records Copied from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._global_web_series_detail"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Web Source Series Validation Series/Book/Index Records Copied from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._tags_by_author_default"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Author-Tag Defaults Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._tags_by_comment"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Tags by Comment Rules Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._tag_combination_rules"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Tag Combination Rules Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._tag_capitalization_rules"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Tag Capitalization Rules Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._tag_string_replacement_rules"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Tag String Replacement Rules Copied from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._dg_genre_author_rules"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Derive Genres Author Rules Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._dg_genre_tag_rules_factual"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Derive Genres Factual Tag Rules Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._dg_genre_tag_rules_fiction"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Derive Genres Fiction Tag Rules Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*) FROM Best._dg_nf_language_keywords"
    my_cursor.execute(mysql)
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    log("Number of Derive Genres Non-Fiction Language Keywords Cloned from Best to Target(s):  ", as_unicode(count1))
    log(" ")
    log(" ")
    log("Cloned:  the Target table was emptied, and then all new records from the Best library were copied to the Target")
    log("Copied:  the Target table had new records added, or existing records changed to the Best library values, but no deletes.")
    log(" ")
    log("Real Tags from all Target Libraries were copied to a Best Q&S Table used to offer choices for the 'Easy-Add' Tags-to-Purge Rules.")
    log("When you once again run this job to copy the Best tag rules back to the Targets, they will inherit any Best Tags-to-Purge Rules created using their own Tags.")
    log(" ")
    log("Work Tags from all Target Libraries were copied to a Best Q&S Table used to offer choices for the 'Easy-Add' Work Tags-to-NEWTAG Mapping Rules.")
    log("When you once again run this job to copy the Best tag rules back to the Targets, they will inherit any Best Work Tags-to-NEWTAG Mapping Rules created using their own Work Tags.")
    log(" ")
    log("Any Target Web Source Series Validation Series/Book/Index Records have been added to the Best Q&S Library for its own use plus future copying to all Targets.")
    log(" ")
    log("===================================")
    log(" ")
def misc10_copy_rules_among_qs_databases(my_db, my_cursor, log, status_t1, status_t2, status_t3, status_t4):
    try:
        my_cursor.execute("commit")  
    except:
        pass
    if status_t1:
        try:
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION;\
                DELETE FROM T1._tag_priorities;\
                DELETE FROM T1._tag_rules;\
                DELETE FROM T1._title_rules;\
                DELETE FROM T1._series_rules;\
                DELETE FROM T1._tags_by_author_default;\
                DELETE FROM T1._tags_by_comment;\
                DELETE FROM T1._tag_combination_rules;\
                DELETE FROM T1._tag_capitalization_rules;\
                DELETE FROM T1._dg_genre_author_rules;\
                DELETE FROM T1._dg_genre_tag_rules_factual;\
                DELETE FROM T1._dg_genre_tag_rules_fiction;\
                DELETE FROM T1._dg_nf_language_keywords;\
                COMMIT; ")
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            raise e
            return
        try:
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION; \
                INSERT OR IGNORE INTO T1._tags_by_author_default  SELECT * FROM Best._tags_by_author_default; \
                COMMIT; ")
        except:
            try:
                my_cursor.execute("commit")  
                sleep(6.0)  
            except:
                sleep(6.0)  
                pass
        try:
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION; \
                INSERT OR REPLACE INTO T1._tags_by_author_default  SELECT * FROM Best._tags_by_author_default; \
                INSERT OR REPLACE INTO T1._tags_by_comment  SELECT * FROM Best._tags_by_comment; \
                INSERT OR REPLACE INTO T1._tag_priorities    SELECT * FROM Best._tag_priorities;\
                COMMIT; ")
            sleep(0.02)
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            raise e
            return
        try:
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION; \
                INSERT OR REPLACE INTO T1._tag_rules          SELECT * FROM Best._tag_rules;\
                INSERT OR REPLACE INTO T1._tag_combination_rules          SELECT * FROM Best._tag_combination_rules;\
                INSERT OR REPLACE INTO T1._tag_capitalization_rules          SELECT * FROM Best._tag_capitalization_rules;\
                INSERT OR REPLACE INTO T1._tag_string_replacement_rules          SELECT * FROM Best._tag_string_replacement_rules;\
                INSERT OR REPLACE INTO T1._title_rules         SELECT * FROM Best._title_rules;\
                INSERT OR REPLACE INTO T1._series_rules         SELECT * FROM Best._series_rules;\
                INSERT OR IGNORE INTO T1._book_awards         SELECT * FROM Best._book_awards;\
                INSERT OR IGNORE INTO T1._global_authors         SELECT * FROM Best._global_authors;\
                INSERT OR REPLACE INTO T1._dg_genre_author_rules               SELECT * FROM Best._dg_genre_author_rules ;\
                INSERT OR REPLACE INTO T1._dg_genre_tag_rules_factual        SELECT * FROM Best._dg_genre_tag_rules_factual ;\
                INSERT OR REPLACE INTO T1._dg_genre_tag_rules_fiction         SELECT * FROM Best._dg_genre_tag_rules_fiction ;\
                INSERT OR REPLACE INTO T1._dg_nf_language_keywords         SELECT * FROM Best._dg_nf_language_keywords ;\
                COMMIT; ")
            sleep(0.02)
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            raise e
            return
        try:
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION;\
                INSERT OR REPLACE INTO T1._global_web_author_series        SELECT * FROM Best._global_web_author_series;\
                INSERT OR REPLACE INTO T1._global_web_series_detail          SELECT * FROM Best._global_web_series_detail;\
                INSERT OR IGNORE INTO T1._pristine_authors                         SELECT * FROM Best._pristine_authors;\
                INSERT OR IGNORE INTO Mem1._tags_copied_from_other_libraries  SELECT null, name FROM T1.tags WHERE name NOT LIKE '%978%' AND name NOT LIKE '%isbn%'; \
                INSERT OR IGNORE INTO Mem1._tags_work_single SELECT tag, subject FROM T1._tags_work_single  ;\
                INSERT OR IGNORE INTO Mem1._global_web_author_series SELECT * FROM T1._global_web_author_series;\
                INSERT OR IGNORE INTO Mem1._global_web_series_detail SELECT * FROM T1._global_web_series_detail;\
                INSERT OR IGNORE INTO Mem1._pristine_authors SELECT * FROM T1._pristine_authors;\
                COMMIT; ")
            sleep(0.02)
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            raise e
            return
    if status_t2:
        try:
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION;\
                DELETE FROM T2._tag_priorities;\
                DELETE FROM T2._tag_rules;\
                DELETE FROM T2._title_rules;\
                DELETE FROM T2._series_rules;\
                DELETE FROM T2._tags_by_author_default;\
                DELETE FROM T2._tags_by_comment;\
                DELETE FROM T2._tag_combination_rules;\
                DELETE FROM T2._tag_capitalization_rules;\
                DELETE FROM T2._dg_genre_author_rules;\
                DELETE FROM T2._dg_genre_tag_rules_factual;\
                DELETE FROM T2._dg_genre_tag_rules_fiction;\
                DELETE FROM T2._dg_nf_language_keywords;\
                COMMIT; ")
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION;\
                INSERT OR REPLACE INTO T2._tags_by_author_default  SELECT * FROM Best._tags_by_author_default; \
                INSERT OR REPLACE INTO T2._tags_by_comment  SELECT * FROM Best._tags_by_comment; \
                INSERT OR REPLACE INTO T2._tag_priorities    SELECT * FROM Best._tag_priorities;\
                INSERT OR REPLACE INTO T2._tag_rules          SELECT * FROM Best._tag_rules;\
                INSERT OR REPLACE INTO T2._tag_combination_rules          SELECT * FROM Best._tag_combination_rules;\
                INSERT OR REPLACE INTO T2._tag_capitalization_rules          SELECT * FROM Best._tag_capitalization_rules;\
                INSERT OR REPLACE INTO T2._tag_string_replacement_rules          SELECT * FROM Best._tag_string_replacement_rules;\
                INSERT OR REPLACE INTO T2._title_rules         SELECT * FROM Best._title_rules;\
                INSERT OR REPLACE INTO T2._series_rules         SELECT * FROM Best._series_rules;\
                INSERT OR IGNORE INTO T2._book_awards         SELECT * FROM Best._book_awards;\
                INSERT OR IGNORE INTO T2._global_authors         SELECT * FROM Best._global_authors;\
                INSERT OR REPLACE INTO T2._dg_genre_author_rules               SELECT * FROM Best._dg_genre_author_rules ;\
                INSERT OR REPLACE INTO T2._dg_genre_tag_rules_factual        SELECT * FROM Best._dg_genre_tag_rules_factual ;\
                INSERT OR REPLACE INTO T2._dg_genre_tag_rules_fiction         SELECT * FROM Best._dg_genre_tag_rules_fiction ;\
                INSERT OR REPLACE INTO T2._dg_nf_language_keywords         SELECT * FROM Best._dg_nf_language_keywords ;\
                INSERT OR REPLACE INTO T2._global_web_author_series        SELECT * FROM Best._global_web_author_series;\
                INSERT OR REPLACE INTO T2._global_web_series_detail          SELECT * FROM Best._global_web_series_detail;\
                INSERT OR IGNORE INTO T2._pristine_authors                         SELECT * FROM Best._pristine_authors;\
                INSERT OR IGNORE INTO Mem1._tags_copied_from_other_libraries  SELECT null, name FROM T2.tags WHERE name NOT LIKE '%978%' AND name NOT LIKE '%isbn%'; \
                INSERT OR IGNORE INTO Mem1._tags_work_single SELECT tag, subject FROM T2._tags_work_single  ;\
                INSERT OR IGNORE INTO Mem1._global_web_author_series SELECT * FROM T2._global_web_author_series;\
                INSERT OR IGNORE INTO Mem1._global_web_series_detail SELECT * FROM T2._global_web_series_detail;\
                INSERT OR IGNORE INTO Mem1._pristine_authors SELECT * FROM T2._pristine_authors;\
                COMMIT; ")
            sleep(0.02)
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            raise e
            return
    if status_t3:
        try:
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION;\
                DELETE FROM T3._tag_priorities;\
                DELETE FROM T3._tag_rules;\
                DELETE FROM T3._title_rules;\
                DELETE FROM T3._series_rules;\
                DELETE FROM T3._tags_by_author_default;\
                DELETE FROM T3._tags_by_comment;\
                DELETE FROM T3._tag_combination_rules;\
                DELETE FROM T3._tag_capitalization_rules;\
                DELETE FROM T3._dg_genre_author_rules;\
                DELETE FROM T3._dg_genre_tag_rules_factual;\
                DELETE FROM T3._dg_genre_tag_rules_fiction;\
                DELETE FROM T3._dg_nf_language_keywords;\
                COMMIT; ")
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION;\
                INSERT OR REPLACE INTO T3._tags_by_author_default  SELECT * FROM Best._tags_by_author_default; \
                INSERT OR REPLACE INTO T3._tags_by_comment  SELECT * FROM Best._tags_by_comment; \
                INSERT OR REPLACE INTO T3._tag_priorities    SELECT * FROM Best._tag_priorities;\
                INSERT OR REPLACE INTO T3._tag_rules          SELECT * FROM Best._tag_rules;\
                INSERT OR REPLACE INTO T3._tag_combination_rules          SELECT * FROM Best._tag_combination_rules;\
                INSERT OR REPLACE INTO T3._tag_capitalization_rules          SELECT * FROM Best._tag_capitalization_rules;\
                INSERT OR REPLACE INTO T3._tag_string_replacement_rules          SELECT * FROM Best._tag_string_replacement_rules;\
                INSERT OR REPLACE INTO T3._title_rules         SELECT * FROM Best._title_rules;\
                INSERT OR REPLACE INTO T3._series_rules         SELECT * FROM Best._series_rules;\
                INSERT OR IGNORE INTO T3._book_awards         SELECT * FROM Best._book_awards;\
                INSERT OR IGNORE INTO T3._global_authors         SELECT * FROM Best._global_authors;\
                INSERT OR REPLACE INTO T3._dg_genre_author_rules               SELECT * FROM Best._dg_genre_author_rules ;\
                INSERT OR REPLACE INTO T3._dg_genre_tag_rules_factual        SELECT * FROM Best._dg_genre_tag_rules_factual ;\
                INSERT OR REPLACE INTO T3._dg_genre_tag_rules_fiction         SELECT * FROM Best._dg_genre_tag_rules_fiction ;\
                INSERT OR REPLACE INTO T3._dg_nf_language_keywords         SELECT * FROM Best._dg_nf_language_keywords ;\
                INSERT OR REPLACE INTO T3._global_web_author_series        SELECT * FROM Best._global_web_author_series;\
                INSERT OR REPLACE INTO T3._global_web_series_detail          SELECT * FROM Best._global_web_series_detail;\
                INSERT OR IGNORE INTO T3._pristine_authors                         SELECT * FROM Best._pristine_authors;\
                INSERT OR IGNORE INTO Mem1._tags_copied_from_other_libraries  SELECT null, name FROM T3.tags WHERE name NOT LIKE '%978%' AND name NOT LIKE '%isbn%'; \
                INSERT OR IGNORE INTO Mem1._tags_work_single SELECT tag, subject FROM T3._tags_work_single  ;\
                INSERT OR IGNORE INTO Mem1._global_web_author_series SELECT * FROM T3._global_web_author_series;\
                INSERT OR IGNORE INTO Mem1._global_web_series_detail SELECT * FROM T3._global_web_series_detail;\
                INSERT OR IGNORE INTO Mem1._pristine_authors SELECT * FROM T3._pristine_authors;\
                COMMIT; ")
            sleep(0.02)
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            raise e
            return
    if status_t4:
        try:
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION;\
                DELETE FROM T4._tag_priorities;\
                DELETE FROM T4._tag_rules;\
                DELETE FROM T4._title_rules;\
                DELETE FROM T4._series_rules;\
                DELETE FROM T4._tags_by_author_default;\
                DELETE FROM T4._tags_by_comment;\
                DELETE FROM T4._tag_combination_rules;\
                DELETE FROM T4._tag_capitalization_rules;\
                DELETE FROM T4._dg_genre_author_rules;\
                DELETE FROM T4._dg_genre_tag_rules_factual;\
                DELETE FROM T4._dg_genre_tag_rules_fiction;\
                DELETE FROM T4._dg_nf_language_keywords;\
                COMMIT; ")
            sleep(0.02)
            my_cursor.execute("\
                BEGIN TRANSACTION;\
                INSERT OR REPLACE INTO T4._tags_by_author_default  SELECT * FROM Best._tags_by_author_default; \
                INSERT OR REPLACE INTO T4._tags_by_comment  SELECT * FROM Best._tags_by_comment; \
                INSERT OR REPLACE INTO T4._tag_priorities    SELECT * FROM Best._tag_priorities;\
                INSERT OR REPLACE INTO T4._tag_rules          SELECT * FROM Best._tag_rules;\
                INSERT OR REPLACE INTO T4._tag_combination_rules          SELECT * FROM Best._tag_combination_rules;\
                INSERT OR REPLACE INTO T4._tag_capitalization_rules          SELECT * FROM Best._tag_capitalization_rules;\
                INSERT OR REPLACE INTO T4._tag_string_replacement_rules          SELECT * FROM Best._tag_string_replacement_rules;\
                INSERT OR REPLACE INTO T4._title_rules         SELECT * FROM Best._title_rules;\
                INSERT OR REPLACE INTO T4._series_rules         SELECT * FROM Best._series_rules;\
                INSERT OR IGNORE INTO T4._book_awards         SELECT * FROM Best._book_awards;\
                INSERT OR IGNORE INTO T4._global_authors         SELECT * FROM Best._global_authors;\
                INSERT OR REPLACE INTO T4._dg_genre_author_rules               SELECT * FROM Best._dg_genre_author_rules ;\
                INSERT OR REPLACE INTO T4._dg_genre_tag_rules_factual        SELECT * FROM Best._dg_genre_tag_rules_factual ;\
                INSERT OR REPLACE INTO T4._dg_genre_tag_rules_fiction         SELECT * FROM Best._dg_genre_tag_rules_fiction ;\
                INSERT OR REPLACE INTO T4._dg_nf_language_keywords         SELECT * FROM Best._dg_nf_language_keywords ;\
                INSERT OR REPLACE INTO T4._global_web_author_series        SELECT * FROM Best._global_web_author_series;\
                INSERT OR REPLACE INTO T4._global_web_series_detail          SELECT * FROM Best._global_web_series_detail;\
                INSERT OR IGNORE INTO T4._pristine_authors                         SELECT * FROM Best._pristine_authors;\
                INSERT OR IGNORE INTO Mem1._tags_copied_from_other_libraries  SELECT null, name FROM T4.tags WHERE name NOT LIKE '%978%' AND name NOT LIKE '%isbn%'; \
                INSERT OR IGNORE INTO Mem1._tags_work_single SELECT tag, subject FROM T4._tags_work_single  ;\
                INSERT OR IGNORE INTO Mem1._global_web_author_series SELECT * FROM T4._global_web_author_series;\
                INSERT OR IGNORE INTO Mem1._global_web_series_detail SELECT * FROM T4._global_web_series_detail;\
                INSERT OR IGNORE INTO Mem1._pristine_authors SELECT * FROM T4._pristine_authors;\
                COMMIT; ")
            sleep(0.02)
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            raise e
            return
    log(" ")
    log(" ")
    log("Tag Rules, Title Rules, Series Rules, Web Source Series Validation Data, Author-Tag Defaults, DG Rules, ")
    log("Global Authors and Pristine Authors were copied from your Best Q&S library to your other configured libraries.")
def misc10_attach_qs_metadata_db(my_db, my_cursor, path, name, log):
    status = True
    try:
        s1 = "ATTACH DATABASE '"
        s2 =  "'  As '[NAME]';"
        s2 = as_unicode(s2.replace("[NAME]", as_unicode(name)))
        path = as_unicode(path)
        path = as_unicode(path.replace(os.sep, '/'))        
        mysql = s1 + path + s2
        if isbytestring(mysql):
            mysql = mysql.decode(filesystem_encoding)
        my_cursor.execute(mysql)
        log("Q&S Library metadata.db has been properly attached:     " + as_unicode(path))
        return True
    except Exception as e:
        log("Q&S Library metadata.db has NOT been properly attached")
        log(mysql)
        s = as_unicode(e)
        log(s)
        my_db.close()
        log("terminating early...")
        return False
def misc14_control(my_db, my_cursor, notifications, log):
    global mynothing
    global my_run_type
    global this_date
    global my_selected_book_list
    tmp_books_list = []
    book = None
    tmp_list = qs_convert_list_of_nominal_book_ids_to_integers(my_selected_book_list)
    for row in tmp_list:
        book = as_unicode(row)
        tmp_books_list.append(book)
        break
    del my_selected_book_list
    del tmp_list
    n_total = len(tmp_books_list)
    if n_total == 0:
        log("No Authors Selected.")
        return
    if book is None:
        log("No Author's Book Selected.")
        return
    socket.setdefaulttimeout(15)
    text_list = []
    n_counter = 0
    my_url_domain = as_unicode("www.fictiondb.com")
    my_url = as_unicode("http://www.fictiondb.com/series/author-series~[LETTER].htm")  
    try:
        authname = mynothing
        mysql = "SELECT name,'dummy' FROM __book_author_name_sort WHERE book = ? "
        tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=book)
        if not tmp_rows:
            log("Invalid Author")
            return
        else:
            n = len(tmp_rows)
            if n == 0:
                log("Invalid Author")
                return
            else:
                for row in tmp_rows:
                    authname,dummy = row
                    break
        if authname is None:
            log("Invalid Author")
            return
        if not authname > " ":
            log("Invalid Author")
            return
        try:
            authname = unicodedata.normalize('NFKD', authname).encode('ascii', 'ignore')
        except:
            pass
        authname = as_unicode(authname)
        firstname = ""
        middlename = ""
        lastname = ""
        if "-" in authname:    
            n = authname.find("-")
            if n > 0:  
                authname = authname[0:n]
                if authname.endswith("-"):
                    authname = authname[0:-1]
                authname = authname.strip()
        if not "," in authname:
            if " " in authname:
                auth_split = authname.split(" ")
                n = len(auth_split)
                if n == 2: 
                    firstname = auth_split[0]
                    lastname = auth_split[1]
                elif n == 3:
                    firstname = auth_split[0]
                    middlename = auth_split[1]
                    lastname = auth_split[2]
                elif n == 4:
                    firstname = auth_split[0]
                    middlename = auth_split[1] + "-" + auth_split[2]
                    lastname = auth_split[3]
                else: 
                    firstname = auth_split[0]
                    middlename = ""
                    lastname = auth_split[n-1]
            else:
                firstname = " "
                middlename = ""
                lastname = authname
        else:
            auth_split = authname.split(",")
            lastname = auth_split[0].strip()
            middlename = ""
            firstname = auth_split[1].strip()
            if " " in firstname:
                auth_split = firstname.split(" ")
                n = len(auth_split)
                if n == 2: 
                    firstname = auth_split[0]
                    middlename = auth_split[1]
                elif n == 3:
                    firstname = auth_split[0]
                    middlename = auth_split[1] + "-" + auth_split[2]
                else: 
                    firstname = auth_split[0]
                    middlename = ""
                    lastname = auth_split[n-1]
        firstname = firstname.strip()
        middlename = middlename.strip()
        lastname = lastname.strip()
        log("Author Selected Was: " + authname)
        series_list = misc14_get_all_series_for_single_author(my_db, my_cursor, firstname, middlename, lastname, notifications, log)
        n = len(series_list)
        if n == 0:
            log("<font size='3'><b><font color='#FF0000'>Web Source Found No <u>Series</u> For This Author</b></font>")
            return
        else:
            notifications.put((0.10, 'Retrieving Web Booktitles/Indexes for Series of Selected Author'))
            misc14_update_temp_web_tables(my_db, my_cursor, authname, firstname, middlename, lastname, series_list, notifications, log)
    except Exception as e:
        log("ERROR in Retrieving Web Booktitles/Indexes for Series of Selected Author: " + authname )
        log(as_unicode(e))
        my_db.close()
        return
    sleep(0.02)
    mysql = as_unicode('INSERT OR REPLACE INTO _web_source_url_control (source_url) VALUES( "' + my_url_domain + '") ')
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = as_unicode('INSERT OR REPLACE INTO _global_web_author_series SELECT * FROM _web_author_series')
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = as_unicode('INSERT OR REPLACE INTO _global_web_series_detail SELECT * FROM _web_series_detail')
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = as_unicode("DELETE FROM _global_web_author_series WHERE authname LIKE '%-%' OR authname like '%0%' or  authname like '%1%' \
            OR authname like '%2%' or  authname like '%3%' OR authname like '%4%' OR  authname like '%5%' OR authname like '%6%' \
            OR  authname like '%7%' OR authname like '%8%' OR  authname like '%9%' OR  authname like '%\%' \
            OR authname LIKE '%</span>%' OR authname LIKE '%</a>%' OR authname LIKE '%~%'  OR authname LIKE '%unknown%' \
            OR seriesname LIKE '%</span>%'   ")
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02) 
    mysql = as_unicode("DELETE FROM _global_web_series_detail WHERE authname LIKE '%-%' OR authname like '%0%' or  authname like '%1%' \
            OR authname like '%2%' or  authname like '%3%' OR authname like '%4%' OR  authname like '%5%' OR authname like '%6%' \
            OR  authname like '%7%' OR authname like '%8%' OR  authname like '%9%' OR  authname like '%\%' \
            OR authname LIKE '%</span>%' OR authname LIKE '%</a>%' OR authname LIKE '%~%'  OR authname LIKE '%unknown%'  \
            OR seriesname LIKE '%</span>%' \
            OR booktitle LIKE '%</span>%' OR booktitle LIKE '%</a>%' OR booktitle LIKE '%~%' \
            OR seriesname LIKE '%</span>%' OR booktitle LIKE '%</a>%' OR booktitle LIKE '%~%'    ")
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = as_unicode("INSERT OR IGNORE INTO _global_authors SELECT null,authname,'none',' ' FROM _web_author_series")
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = as_unicode("INSERT OR IGNORE INTO _global_series SELECT null,seriesname,seriesname FROM _web_author_series")
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    log(".")
    sleep(0.02)
    for row in my_cursor.execute('SELECT authname,seriesname,booktitle,seriesindex FROM _web_series_detail ORDER BY seriesname,seriesindex'):
        authname,seriesname,booktitle,seriesindex = row
        log(as_unicode(authname) + "  " + as_unicode(seriesname) + "  " + as_unicode(booktitle) + "  " + as_unicode(seriesindex))
    my_db.close()
    log(" ")
    log("The Rename Work Series Name job now will have new WSSVD to use, as will Book Level Scrubbing for Work Title and Work Series Renaming.")
    log(" ")
def misc14_get_all_series_for_single_author(my_db, my_cursor, firstname, middlename, lastname, notifications, log):
    global mynothing
    series_list = []    
    firstname = firstname.lower().strip()
    middlename = middlename.lower().strip()
    lastname = lastname.lower().strip()
    firstname = firstname.replace(".",mynothing)            
    middlename = middlename.replace(".",mynothing)  
    my_url = 'http://www.fictiondb.com/series/author-series~[?].htm'
    my_url = my_url.replace("[?]",lastname[0:1])
    search_series_row = 'href="../author/[FIRSTNAME]-[MIDDLENAME]-[LASTNAME]'
    search_series_row = search_series_row.replace("[FIRSTNAME]",firstname)
    if middlename > " ":
        search_series_row = search_series_row.replace("[MIDDLENAME]",middlename)
    else:
        search_series_row = search_series_row.replace("-[MIDDLENAME]",mynothing)
    search_series_row = search_series_row.replace("[LASTNAME]",lastname)
    try:
        connection = urlopen(my_url)
        html_raw = connection.read()
        connection.close()
        soup = BeautifulSoup(html_raw)
    except Exception as e:
        return series_list
    if not soup:
        return series_list
    results = soup.tbody
    if not results:
        return series_list
    n = len(results)
    if n == 0:
        return series_list
    for row in results:
        s = as_unicode(row)
        n = s.count(search_series_row)
        if not n > 0:
            continue
        s = s + "</a></td>"
        ssplit = s.split("</a></td>")
        series = ssplit[0]
        n = series.rfind('>')
        if n > 0:
            series = series[n+1: ].strip()  
            if len(series) > 1:
                series_list.append(series)
                log("Web Series for Author: " + series)
    log(" ")
    '''
    Author Selected Was: Bella Andre
    Firstname: Bella   Lastname: Andre
    http://www.fictiondb.com/series/author-series~a.htm
    href="../author/bella-andre
    soup was found
    results row: <tr><td><span class="hide">Hot Shots</span><a class="hghlt" href="../series/hot-shots-bella-andre~15693.htm">Hot Shots</a></td><td><a href="../author/bella-andre~40263.htm">Andre, Bella</a></td></tr>
    results row: <tr><td><span class="hide">London Sul</span><a class="hghlt" href="../series/london-sullivans-bella-andre~62701.htm">London Sullivans</a></td><td><a href="../author/bella-andre~40263.htm">Andre, Bella</a></td></tr>
    results row: <tr><td><span class="hide">Love On Ro</span><a class="hghlt" href="../series/love-on-rockwell-island-bella-andre~52693.htm">Love On Rockwell Island</a></td><td><a href="../author/bella-andre~40263.htm">Andre, Bella</a></td></tr>
    results row: <tr><td><span class="hide">Maine Sull</span><a class="hghlt" href="../series/maine-sullivans-bella-andre~58410.htm">Maine Sullivans</a></td><td><a href="../author/bella-andre~40263.htm">Andre, Bella</a></td></tr>
    results row: <tr><td><span class="hide">Married in</span><a class="hghlt" href="../series/married-in-malibu-bella-andre~58409.htm">Married in Malibu</a></td><td><a href="../author/bella-andre~40263.htm">Andre, Bella</a></td></tr>
    results row: <tr><td><span class="hide">Maverick B</span><a class="hghlt" href="../series/the-maverick-billionaires-bella-andre~44998.htm">The Maverick Billionaires</a></td><td><a href="../author/bella-andre~40263.htm">Andre, Bella</a></td></tr>
    results row: <tr><td><span class="hide">Morrisons</span><a class="hghlt" href="../series/the-morrisons-bella-andre~36567.htm">The Morrisons</a></td><td><a href="../author/bella-andre~40263.htm">Andre, Bella</a></td></tr>
    results row: <tr><td><span class="hide">New York S</span><a class="hghlt" href="../series/new-york-sullivans-bella-andre~52692.htm">New York Sullivans</a></td><td><a href="../author/bella-andre~40263.htm">Andre, Bella</a></td></tr>
    results row: <tr><td><span class="hide">Sullivans</span><a class="hghlt" href="../series/the-sullivans-bella-andre~21394.htm">The Sullivans</a></td><td><a href="../author/bella-andre~40263.htm">Andre, Bella</a></td></tr>
    results row: <tr><td><span class="hide">Summer Lak</span><a class="hghlt" href="../series/summer-lake-bella-andre~52694.htm">Summer Lake</a></td><td><a href="../author/bella-andre~40263.htm">Andre, Bella</a></td></tr>
    '''
    return series_list
def misc14_update_temp_web_tables(my_db, my_cursor,authname,firstname,middlename,lastname,series_list,notifications, log):
    misc4_purge_old_web_table_data(my_db, my_cursor, log)
    firstname = firstname.replace(".",mynothing)  
    for seriesname in series_list:
        orig_series = seriesname
        misc14_unpack_soup_www_fictiondb_com(my_db, my_cursor,authname,orig_series,seriesname,firstname,middlename,lastname, log)
    misc4_delete_web_table_duplicates(my_db, my_cursor, log)
    mysql = "SELECT Count(*),'dummy' FROM _web_author_series"
    my_cursor.execute(mysql)
    rows = my_cursor.fetchall()
    for row in rows:
        count1,dummy = row
        count1 = as_unicode(count1)
    log(" ")
    log("Number of Series Downloaded as WSSVD for Selected Author:", as_unicode(count1))
    log(" ")
    mysql = "SELECT Count(*),'dummy' FROM _web_series_detail"
    my_cursor.execute(mysql)
    rows = my_cursor.fetchall()
    for row in rows:
        count1,dummy = row
        count1 = as_unicode(count1)
    log(" ")
    log("Number of Series/Book Title Combinations Downloaded as WSSVD for Selected Author:", as_unicode(count1))
    log(" ")
    log(" ")
    log("This new WSSVD is now available to all Series Level Scrubbing functions.")
    log(" ")
def misc14_unpack_soup_www_fictiondb_com(my_db, my_cursor, authname,orig_series,seriesname,firstname,middlename,lastname, log):
    my_list1 = []
    results = []
    results1 = []
    results2 = []
    results3 = []
    results_final = []
    try:
        my_letter = lastname[0].lower()
    except:
        my_letter = lastname[0]
    my_author_link = firstname + "-"
    if middlename > " ":
        my_author_link = my_author_link + middlename  + "-" + lastname  
    else:
        my_author_link = firstname + "-"  + lastname    
    my_author_link = my_author_link.lower()
    my_series_link = seriesname.replace(" ", "-")          
    my_series_link = my_series_link.lower()                  
    log(" ")
    my_url = "http://www.fictiondb.com/series/author-series~[LETTER].htm"
    my_url = my_url.replace("[LETTER]", my_letter)
    try:
        connection = urlopen(my_url)
        html_raw = connection.read()
        connection.close()
        soup = BeautifulSoup(html_raw)
    except Exception as e:
        return
    if not soup:
        return
    results = soup.tbody
    if not results:
        return
    n = len(results)
    if n == 0:
        return
    s_new_url_raw = mynothing
    for row in results:
        s = as_unicode(row)
        n = s.count(my_author_link)
        if not n > 0:
            continue
        my_list1.append(s)
        s_new_url_raw = s
    '''       now have (single line):
            <tr><td><span class="hide">Morganvill</span><a class="hghlt" href="../series/the-morganville-vampires-rachel-caine~9655.htm">The Morganville Vampires</a></td><td><a href="../author/rachel-caine~39124.htm">Caine, Rachel</a></td></tr>
    '''
    n = len(my_list1)
    if n == 0:
        return
    '''
                regex will search:
                <tr><td><span class="hide">Morganvill</span><a class="hghlt" href="../series/the-morganville-vampires-rachel-caine~9655.htm">The Morganville Vampires</a></td><td><a href="../author/rachel-caine~39124.htm">Caine, Rachel</a></td></tr>
                <tr><td><span class="hide">Iron Knife</span><a class="hghlt" href="../series/iron-knifes-family-georgina-gentry~12432.htm">Iron Knife's Family</a></td><td><a href="../author/georgina-gentry~2780.htm">Gentry, Georgina</a></td></tr>
    '''
    my_series_link = my_series_link.replace("'","") 
    my_series_link = my_series_link.replace(".","") 
    my_re_auth_series = 'href=.+[SERIES-NAME][a-z -]*[~][0-9]+[.]htm["]' 
    my_re_auth_series = my_re_auth_series.replace("[SERIES-NAME]", my_series_link)
    try:
        p = re.compile(my_re_auth_series, re.IGNORECASE)
    except:
        log("REGEX COMPILE ERROR in Parsing Web Page for: " + my_series_link)
        log("REGEX COMPILE ERROR in misc14_unpack_soup_www_fictiondb_com for: "  + my_re_auth_series)
        log("REGEX COMPILE ERROR: Please Forward This Log to the Developer.  Thank you.")
        return
    s_new_url = mynothing
    for s in my_list1:
        match1 = p.search(s)
        if not match1:
            continue
        else:
            s_new_url = as_unicode(match1.group(0))
            break
    if s_new_url == mynothing:
        return
    s_new_url = as_unicode(s_new_url.replace('href="..', 'http://www.fictiondb.com'))
    s_new_url = as_unicode(s_new_url.replace('.htm"', '.htm'))
    s_web_series_name = misc14_parse_web_series_name(orig_series,s_new_url,s_new_url_raw,log)
    try:
        connection = urlopen(s_new_url)         
        html_raw = connection.read()
        connection.close()
        soup = BeautifulSoup(html_raw)
    except Exception as e:
        return
    if not soup:
        return
    results2 = soup.tbody
    if results2 is None:
        return
    for row in results2:
        if row is not None:
            s = as_unicode(row)
            n = s.find("td>")   
            if n >= 0:
                results3.append(as_unicode(s))
    n = len(results3)
    s_total_books = as_unicode(n)
    if n == 0:
        return
    '''   now have as a row:
        <td>1</td> [...and...] <td><a itemprop="url" href="../author/rachel-caine~glass-houses~159550~b.htm"><span itemprop='name'>Glass Houses</span></a>
    '''
    book_dict = {}
    my_re_index       = as_unicode('<td class="text-center" nowrap="">[0-9][0-9]*</td>')     
    my_re_booktitle = as_unicode('<span itemprop="name">.+</span></a></h2></td>') 
    try:
        p1 = re.compile(my_re_index, re.IGNORECASE)
        p2 = re.compile(my_re_booktitle, re.IGNORECASE)
    except:
        log("REGEX COMPILE ERROR in Parsing Web Page for: " + as_unicode(my_re_index) + " and: " + as_unicode(my_re_booktitle) )
        log("REGEX COMPILE ERROR in misc4_unpack_soup_www_fictiondb_com for: "  + as_unicode(s_new_url) )
        log("REGEX COMPILE ERROR: Please Forward This Log to the Developer.  Thank you.")
        return
    tmp_index = "0"
    tmp_title = ""
    for row in results3:
        if row is None:
            continue
        s = as_unicode(row)
        match1 = p1.search(s)
        match2 = p2.search(s)
        if match1:      
            s = as_unicode(match1.group())
            s = s.replace('<td class="text-center" nowrap="">', mynothing)
            s = s.replace('</td>', mynothing)
            tmp_index = s.strip()
        if match2 :     
            s = as_unicode(match2.group())
            s = s.replace('<span itemprop="name">', mynothing)
            s = s.replace('</span></a></h2></td>', mynothing)
            tmp_title = s.strip()
            tmp_title = titlecase(tmp_title)
            book_dict[tmp_title] = as_unicode(tmp_index)
            tmp_index = "0"
            tmp_title = "NOTHINGTITLE"
        continue
    authname = authname.title()
    tmp_auth = authname
    seriesname = titlecase(seriesname)
    seriesname = seriesname.replace("'S ","'s ")
    s_web_series_name  = seriesname
    orig_series = seriesname 
    if not s_total_books[0].isdigit():
        s_total_books = "0"
    for title,index in iteritems(book_dict):
        tmp_title = title
        tmp_title = titlecase(tmp_title)
        tmp_index = index.strip()
        if tmp_title > " ":
            if (("Search by This Series Name" or "&nbsp") in tmp_title) or  (not tmp_index[0].isdigit()):
                pass
            else:
                sleep(0.02)
                mysql = 'INSERT OR REPLACE INTO _web_author_series (authname,seriesname,source_url,book_count) VALUES (?,?,?,?) '
                execute_mysql_for_custom_column_generic_4_args(my_db, my_cursor, log, mysql, tmp_auth, s_web_series_name, my_url, s_total_books)
                sleep(0.02)
                mysql = "INSERT OR  REPLACE INTO _web_series_detail (authname, seriesname, booktitle, seriesindex, source_url) VALUES (?,?,?,?,?) "
                execute_mysql_for_custom_column_generic_5_args(my_db, my_cursor, log, mysql, tmp_auth, s_web_series_name, tmp_title, tmp_index, my_url)
                sleep(0.02)
    mysql = "DELETE FROM _web_series_rename_detail_cumulative WHERE work_series = web_series"
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
def misc14_parse_web_series_name(orig_series, s_new_url,s_new_url_raw, log):
    if orig_series in s_new_url_raw:
        s_web_series_name = orig_series
        return s_web_series_name
    n = s_new_url.find("~series~")         
    n = n + 8
    s_web_series_name = s_new_url[n: ]
    n = s_web_series_name.find("~")
    s_web_series_name = s_web_series_name[0:n]
    s_web_series_name = s_web_series_name.replace("-", " ")
    s_web_series_name = s_web_series_name.strip()
    s_web_series_name = titlecase(s_web_series_name)
    return s_web_series_name
def misc15_control(my_db, my_cursor, notifications, log):
    global my_selected_book_list
    mysql = "SELECT tag,cc_number,datatype,rule,cc_value FROM _tag_cc_mapping_control WHERE active = '1'  ORDER BY rule DESC, tag ASC, cc_number ASC ;"
    rules_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not rules_list:
        log("No Active Rules in Table _tag_cc_mapping_control.  ")
        my_db.close()
        return
    else:
        n = len(rules_list)
        if n == 0:
            log("No Active Rules in Table _tag_cc_mapping_control.  ")
            my_db.close()
            return
    explode_custom_column_13_if_needed(my_db, my_cursor, log)
    sleep(0.02)
    log(" ")
    log("Table _tags_cc_mapping_control entries to be used by this job in the sort sequence shown (by rule, descending, then all else, ascending): ")
    for row in rules_list:
        tag,cc_number,datatype,rule,cc_value = row
        if not cc_value:
            cc_value = "NULL"
        log(tag,cc_number,datatype,rule,cc_value)
    log(" ")
    log(" ")
    log("Note:  if your table rules have the incorrect Custom Column Datatype for the specified Custom Column Number, this job will fail with odd error messages.")
    log(" ")
    log(" ")
    my_selected_book_list.sort()
    log("Selected books that have Work Tags: ")
    tagsall_list = []
    for row in my_selected_book_list:
        book = as_unicode(row)
        mysql = "SELECT book,tagsall FROM __books_work_populate WHERE book = ? AND tagsall NOT NULL AND tagsall > ' '  "
        my_cursor.execute(mysql,([book]))
        tmp_list = my_cursor.fetchall()
        if not tmp_list:
            continue
        else:
            n = len(tmp_list)
            if n == 0:
                continue
            else:
                for item in tmp_list:
                    tagsall_list.append(item)
                    book,tagsall = item
                    log(as_unicode(book),tagsall)
    log(" ")
    log(" ")
    if len(tagsall_list) == 0:
        log("No Work Tags Exist for Selected Books")
        my_db.close()
        return
    n = len(tagsall_list)
    log("Number of books to be further processed: " + as_unicode(n))
    log(" ")
    tagsall_list.sort()
    new_tagsall_dict = {} 
    deleted_tags = []
    for row in tagsall_list: 
        book,tagsall = row
        new_tagsall = ""
        tagsall = tagsall + ", DUMMY"  
        tag_list = tagsall.split(",")
        tag_list.sort()
        rules_found = False
        del deleted_tags
        deleted_tags = []
        for tag in tag_list:
            tag = tag.strip()
            if tag == "DUMMY":
                continue
            else:
                try:
                    l_tag = tag.lower()
                except:
                    pass
                for item in rules_list:      
                    tabletag,cc_number,datatype,rule,cc_value = item
                    try:
                        l_tabletag = tabletag.lower()
                    except:
                        pass
                    if l_tag == l_tabletag:
                        rules_found = True
                        new_tag = misc15_custom_column_control(my_db, my_cursor, notifications, log,book,item,tag)
                        if new_tag != "DELETE" and new_tag not in deleted_tags:
                            new_tag = new_tag.strip()
                            new_tagsall = new_tagsall + ", " + new_tag
                        else:
                            if new_tag == "DELETE":  
                                tag = tag.strip()
                                deleted_tags.append(tag) 
                    else:
                        if tag not in deleted_tags and tag > " ":
                            new_tagsall = new_tagsall + ", " + tag
                        else:
                            pass
        if not rules_found:
            continue
        new_tagsall = new_tagsall.strip()
        if new_tagsall == "" or new_tagsall == "," :
            new_tagsall = "DELETETAGSALL"
        new_tagsall = misc15_finalize_book_tagsall(new_tagsall, deleted_tags)
        if new_tagsall != tagsall:
            new_tagsall_dict[book] = new_tagsall
    if len(new_tagsall_dict) > 0:
        misc15_create_final_tagsall(my_db, my_cursor, notifications, log,new_tagsall_dict)
    my_db.close()
def misc15_finalize_book_tagsall(new_tagsall,deleted_tags):
    new_tagsall = new_tagsall + ", DUMMY"  
    tag_list = new_tagsall.split(",")
    tag_list.sort()
    final_tagsall = ""
    for tag in tag_list:
        tag = tag.strip()
        if tag == "DUMMY":
            continue
        else:
            if tag in deleted_tags:
                continue
            else:
                if tag > " ":
                    tag = tag.strip()
                    final_tagsall = final_tagsall + ", " + tag
    new_tagsall = final_tagsall
    new_tagsall = new_tagsall.strip()
    if new_tagsall.startswith(","):
        new_tagsall = new_tagsall[1: ]
    if new_tagsall.endswith(","):
        new_tagsall = new_tagsall[0:-1 ]
    new_tagsall = new_tagsall.strip()
    return new_tagsall
def misc15_custom_column_control(my_db, my_cursor, notifications, log,book,item,tag):
    t1 = "T1"
    t2 = "T2"
    v1 = "V1"
    v2 = "V2"
    tabletag,cc_number,datatype,rule,cc_value = item
    rule = rule.upper()
    if rule == t2 or rule == v2:
        new_tag = "DELETE"
    else:
        new_tag = tag
    if rule == t1 or rule == t2:
        cc_value = tabletag  
    else:
        pass
    if cc_number > 19 and cc_value > " ":
        misc15_update_non_qs_custom_columns_generic(my_db, my_cursor, log,cc_number,datatype,cc_value,book)
    return new_tag
def misc15_create_final_tagsall(my_db, my_cursor, notifications, log,new_tagsall_dict):
    log(" ")
    for k,v in iteritems(new_tagsall_dict):
        book = k
        tagsall = v
        if not tagsall > " ":
            tagsall = "DELETETAGSALL"
        tagsall = tagsall + ", DUMMY"
        tag_list = tagsall.split(", ") 
        tag_set = set(tag_list)
        tag_list = list(tag_set)
        del tag_set
        tag_list.sort()
        final_tagsall = ""
        for tag in tag_list:
            tag = tag.strip()
            if tag == "DUMMY":
                continue
            else:
                if tag > " ":
                    final_tagsall = final_tagsall + ", " + tag
        final_tagsall = final_tagsall.strip()
        if final_tagsall.startswith(","):
            final_tagsall = final_tagsall[1: ]
        if final_tagsall.endswith(","):
            final_tagsall = final_tagsall[0:-1 ]
        final_tagsall = final_tagsall.strip()
        misc15_update_final_tagsall(my_db, my_cursor, notifications, log,final_tagsall,book)
def misc15_update_final_tagsall(my_db, my_cursor, notifications, log,final_tagsall,book):
    if final_tagsall != "DELETETAGSALL":
        log("Final Work Tags for Book: " + as_unicode(book) + " - " + final_tagsall)
        mysql = "INSERT OR REPLACE INTO custom_column_13 (id,value) VALUES(?,?) "
        execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, book, final_tagsall)
        mysql = "INSERT OR REPLACE INTO books_custom_column_13_link VALUES(?,?,?) "
        execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, book, book, book)
    else:
        log("No Remaining Work Tags Now Exist for Book: " + as_unicode(book))
        mysql = "DELETE FROM books_custom_column_13_link WHERE book = ? AND book = ?"
        execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, book, book)
def misc15_update_non_qs_custom_columns_generic(my_db, my_cursor, log,cc_number,datatype,new_cc_value,book):
    global mynothing
    text_cc_table = as_unicode("custom_column_ZZ")
    text_cc_link_table = as_unicode("books_custom_column_ZZ_link")
    comment_cc_table = as_unicode("custom_column_ZZ")
    if datatype != 'text' and datatype != 'comments' :
        log("ERROR: table _title_cc_control row has a datatype value error: " + as_unicode(datatype))
        return
    else:
        if datatype == "text":
            text_cc_table = as_unicode(text_cc_table.replace("ZZ", as_unicode(cc_number)))
            text_cc_link_table = as_unicode(text_cc_link_table.replace("ZZ", as_unicode(cc_number)))
            normalized = True
        else:
            comment_cc_table = as_unicode(comment_cc_table.replace("ZZ", as_unicode(cc_number)))
            normalized = False
    sleep(0.02)
    if not normalized:
        mysql = as_unicode("DELETE FROM  [TABLE]  WHERE book = [BOOK]  ")
        mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(comment_cc_table),1))
        mysql = as_unicode(mysql.replace("[BOOK]", as_unicode(book),1))
        execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        sleep(0.02)
        mysql = as_unicode("INSERT OR REPLACE INTO  [TABLE]  (id,book,value) VALUES (?,?,?) ")
        mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(comment_cc_table),1))
        execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, book, book, new_cc_value)
        return
    if normalized:
        mysql = "SELECT id,'dummy' FROM [TABLE]  WHERE value = ?"
        mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(text_cc_table),1))
        tmp_rows = []
        del tmp_rows
        my_cursor.execute(mysql, (new_cc_value,))
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            id = "0"
        else:
            if len(tmp_rows) == 0:
                id = "0"
            else:
                id = "0"
                for row in tmp_rows:
                    id,dummy = row
        if as_unicode(id) == "0":    
            mysql = as_unicode("INSERT OR REPLACE INTO  [TABLE]  (id,value) VALUES (?,?) ")
            mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(text_cc_table),1))
            my_null = None
            execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, my_null, new_cc_value)
            sleep(0.02)
        mysql = as_unicode("DELETE FROM  [TABLE]  WHERE book = [BOOK]  ")
        mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(text_cc_link_table),1))
        mysql = as_unicode(mysql.replace("[BOOK]", as_unicode(book),1))
        execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        sleep(0.02)
        mysql = "SELECT id FROM [TABLE]  WHERE value = ?"
        mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(text_cc_table),1))
        my_cursor.execute(mysql, (new_cc_value,))
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            id = "0"
        else:
            if len(tmp_rows) == 0:
                id = "0"
            else:
                id = "0"
                for row in tmp_rows:
                    for col in row:
                        id = col
        if as_unicode(id) == "0":
            log("ERROR: base custom table value does not exist although it was just added; continuing.")
            log("Book: " + as_unicode(book) + "  Table: " + as_unicode(text_cc_table))
            return
        mysql = as_unicode("INSERT OR REPLACE INTO [LINKTABLE]  (id,book,value) VALUES ( null,?,?) ")
        mysql = as_unicode(mysql.replace("[LINKTABLE]", as_unicode(text_cc_link_table),1))
        execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, book, id)
        sleep(0.02)
        mysql = as_unicode("DELETE FROM  [TABLE]  WHERE id NOT IN(SELECT value FROM [LINKTABLE] WHERE book NOT NULL )")       
        mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(text_cc_table),1))
        mysql = as_unicode(mysql.replace("[LINKTABLE]", as_unicode(text_cc_link_table),1))
        execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        return
def misc16_control(my_db, my_cursor, notifications, log):
    global my_selected_book_list
    global mynothing
    from calibre_plugins.quarantine_and_scrub.config import prefs
    custom_field = prefs['pseudonyms']
    if not custom_field:
        custom_field = "none"
    custom_field = custom_field.strip()
    if custom_field == "none" or custom_field == "#none" or custom_field == "#" or (not custom_field > ' '):
        log("Error: No Custom Column Exists for Configured Pseudonyms: " + custom_field)
        return
    log(" ")
    log("-----------------------------------------------------------------------------------------------")
    log(" ")
    log("Q&S Configured Pseudonym Custom Column #Name to be used is:  " + as_unicode(custom_field))
    log(" ")
    log("-----------------------------------------------------------------------------------------------")
    log(" ")
    log(" ")
    log("This job uses Real Author, not Work Author.")
    log(" ")
    log(" ")
    custom_field = as_unicode(custom_field.replace("#", mynothing))
    mysql = as_unicode("SELECT id,datatype,display,is_multiple,normalized FROM custom_columns WHERE label = '[pseudonyms]' ")
    mysql = as_unicode(mysql.replace("[pseudonyms]", as_unicode(custom_field)))
    my_cursor.execute(mysql)
    rows = my_cursor.fetchall()
    if not rows:
        log("ERROR: Configured Pseudonym Custom Column does NOT Exist")
        return
    if len(rows) == 0:
        log("ERROR: Configured Pseudonym Custom Column does NOT Exist")
        return
    for row in rows:
        custom_id,datatype,display,is_multiple,normalized = row
    if datatype != "text" or normalized != 1:
        log(" ")
        log("ERROR: Datatype of Pseudonym Custom Column is NOT 'text'")
        log(" ")
        return
    if is_multiple != 1:
        log(" ")
        log("ERROR: Pseudonym Custom Column was NOT configured as 'People' ")
        log(" ")
        return
    if not '"is_names": true' in display:
        log(" ")
        log("ERROR: Pseudonym Custom Column was NOT configured as 'People' ")
        log(" ")
        return
    if custom_id < 20:
        log(" ")
        log("ERROR: Pseudonym Custom Column ID Is Invalid.  It must be >= 20' ")
        log(" ")
        return
    custom_id = as_unicode(custom_id)
    custom_table = as_unicode("custom_column_X")
    custom_table = as_unicode(custom_table.replace("X",custom_id,1))
    books_custom_column_link = as_unicode("books_custom_column_X_link")
    books_custom_column_link = as_unicode(books_custom_column_link.replace("X",custom_id,1))
    my_selected_book_list.sort()
    for row in my_selected_book_list:
        book = as_unicode(row)
        mysql = "SELECT pseudonym,author FROM _global_pseudonyms \
                            WHERE author IN(SELECT name FROM __book_author_name_sort WHERE book = ? ) ORDER BY pseudonym "
        my_cursor.execute(mysql,([book]))
        tmp_rows = my_cursor.fetchall()
        new_value = ""
        for item in tmp_rows:
            pseudonym,author = item
            new_value = new_value + ", " + pseudonym
        new_value = new_value.strip()
        if new_value.startswith(","):
            new_value = new_value[1: ]
        if new_value.endswith(","):
            new_value = new_value[0:-1]
        new_value = new_value.strip()
        if new_value > " ":
            log("New Pseudonym(s) for Author and Book: " + author + " - " + as_unicode(book) + " - " + new_value)
            misc16_update_pseudonyms_custom_column(my_db, my_cursor, notifications, log,custom_table, books_custom_column_link, book, new_value)
def misc16_update_pseudonyms_custom_column(my_db, my_cursor, notifications, log,custom_table, books_custom_column_link, book, new_value):
    global mynothing
    mysql = "SELECT id FROM [TABLE]  WHERE value = ?"
    mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(custom_table),1))
    tmp_rows = []
    del tmp_rows
    my_cursor.execute(mysql,(new_value,))
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        id = "0"
    else:
        if len(tmp_rows) == 0:
            id = "0"
        else:
            for row in tmp_rows:
                for col in row:
                    id = col
    if as_unicode(id) == "0":    
        mysql = as_unicode("INSERT OR REPLACE INTO  [TABLE]  (id,value) VALUES (NULL,?) ")
        mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(custom_table),1))
        execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, [new_value], mynothing)
        sleep(0.02)
    mysql = as_unicode("DELETE FROM  [TABLE]  WHERE book = [BOOK]  ")
    mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(books_custom_column_link),1))
    mysql = as_unicode(mysql.replace("[BOOK]", as_unicode(book),1))
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = "SELECT id FROM [TABLE]  WHERE value = ?"
    mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(custom_table),1))
    tmp_rows = []
    del tmp_rows
    my_cursor.execute(mysql, (new_value,))
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        id = "0"
    else:
        if len(tmp_rows) == 0:
            id = "0"
        else:
            for row in tmp_rows:
                for col in row:
                    id = col
    if as_unicode(id) == "0":
        log("ERROR: base custom table value does not exist although it was just added; continuing.")
        log("Book: " + as_unicode(book) + "  Table: " + as_unicode(custom_table))
        return
    mysql = as_unicode("INSERT OR REPLACE INTO [LINKTABLE]  (id,book,value) VALUES ( null,?,?) ")
    mysql = as_unicode(mysql.replace("[LINKTABLE]", as_unicode(books_custom_column_link),1))
    execute_mysql_for_custom_column_generic_2_args(my_db, my_cursor, log, mysql, book, id)
    sleep(0.02)
    mysql = as_unicode("DELETE FROM  [TABLE]  WHERE id NOT IN(SELECT value FROM [LINKTABLE] WHERE book NOT NULL )")       
    mysql = as_unicode(mysql.replace("[TABLE]", as_unicode(custom_table),1))
    mysql = as_unicode(mysql.replace("[LINKTABLE]", as_unicode(books_custom_column_link),1))
    execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
def count_global_series(my_db, my_cursor, log):
    log("===================================")
    log("For Your Reference Only")
    log("===================================")
    mysql = "SELECT Count(*) FROM _global_series"
    my_cursor.execute(mysql)
    count2 = my_cursor.fetchall()
    count2 = qs_standardize_string_numerics(count2)
    log("Number of Global Series:    ", as_unicode(count2))
    mysql = "SELECT Count(*) FROM _pristine_series"
    my_cursor.execute(mysql)
    count4 = my_cursor.fetchall()
    count4 = qs_standardize_string_numerics(count4)
    log("Number of Pristine Series:  ", as_unicode(count4))
    log("===================================")
    log("===================================")
def Create_SQLite_User_Functions(my_db, my_cursor, log):
        global my_terminate_early
        try:
            my_db.createscalarfunction("update_utf8_for_display", SQLite_User_Function_1)
        except Exception as e:
            log("Create_SQLite_User_Function 1 failed...cannot proceed...")
            my_db.close()
            raise e
        sleep(0.5)
def SQLite_User_Function_1(s):
    if s is None: #ignore Nulls being passed by SQLite
        return s
    if not s > " ":
        return s
    t = as_unicode(s)
    if t.count(".") < 2:
        t = titlecase(t) #uses custom function for advanced English-only titlecase
    t = t.strip()
    return t
def remove_duplicate_work_tags(my_db, my_cursor, log):
    try:
        mysql = "SELECT id,value FROM custom_column_13 WHERE value LIKE '%, %'  "
        tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
        if not tmp_rows:
            return
        else:
            if len(tmp_rows) == 0:
                return
            else:
                pass
        my_cursor.execute("begin")
        for row in tmp_rows:
            id,value = row
            if value.count(", ") == 0:   
                continue
            s_list = value.split(", ")
            s_set = set(s_list)
            s_list = list(s_set) 
            s_list.sort()
            new_tagsall = ""
            for item in s_list:
                item = item.strip()
                new_tagsall = new_tagsall + ", " + item
            if new_tagsall.startswith(","):
                new_tagsall = new_tagsall[1: ]
                new_tagsall = new_tagsall.strip()
            mysql = "UPDATE custom_column_13 SET value = ? WHERE id = ? "
            my_cursor.execute(mysql,(new_tagsall,id))
            sleep(0.02)
        try:
            my_cursor.execute("commit")
            sleep(0.5)
        except Exception as e:
            log(as_unicode(e))
            pass
    except Exception as e:
        log(as_unicode(e))
        try:
            my_cursor.execute("commit")
        except:
            pass
def execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None):
    sleep(0.1)
    try:
        if v1 is None:
            my_cursor.execute(mysql)
        else:
            if v1 == 'null':
                v1 = None
            my_cursor.execute(mysql,([v1]))
        tmp_rows = my_cursor.fetchall()
        if tmp_rows:
            return tmp_rows
        else:
            tmp_rows = []
            return tmp_rows
    except Exception as e:
        log("v1: " + as_unicode(v1))
        log(as_unicode(e))
        my_db.close()
        raise e
def execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=None,v2=None):
    sleep(0.05)
    tmp_rows = []
    if v1 is None:
        return tmp_rows
    v2_was_null = False
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2_was_null = True
        v2 = None
    try:
        if v2 is None and not v2_was_null:
            my_cursor.execute(mysql,([v1]))
        else:
            my_cursor.execute(mysql,(v1,v2))
        tmp_rows = my_cursor.fetchall()
        if tmp_rows:
            return tmp_rows
        else:
            tmp_rows = []
            return tmp_rows
    except Exception as e:
        log("execute_mysql_fetchall_complex_generic ", as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
def execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql):
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.05)
def execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    s1 = ""
    if v1 == None:
        s1 = "IGNORE"
    if v1 == 'null':
        v1 = None
    try:
        my_cursor.execute("begin")
        if s1 == "IGNORE":
            my_cursor.execute(mysql)
        else:
            my_cursor.execute(mysql,([v1]))
        my_cursor.execute("commit")
    except Exception as e:
        e = as_unicode(e)
        log("execute_mysql_for_custom_column_generic_1_arg: " + e )
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.05)
def execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,v1=None,v2=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    s2 = ""
    if v2 == "" or v2 is None:     
        s2 = "IGNORE"
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2 = None
    try:
        my_cursor.execute("begin")
        if s2 != "IGNORE":
            my_cursor.execute(mysql,(v1,v2))
        else:
            my_cursor.execute(mysql,([v1]))
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic_2_arg: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.05)
def execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,v1=None,v2=None,v3=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2 = None
    if v3 == 'null':
        v3 = None
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(v1,v2,v3))
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic_3_arg: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.05)
def execute_mysql_for_custom_column_generic_4_args(my_db,my_cursor,log,mysql,v1=None,v2=None,v3=None,v4=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2 = None
    if v3 == 'null':
        v3 = None
    if v4 == 'null':
        v4 = None
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(v1,v2,v3,v4))
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic_4_arg: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.05)
def execute_mysql_for_custom_column_generic_5_args(my_db,my_cursor,log,mysql,v1=None,v2=None,v3=None,v4=None,v5=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2 = None
    if v3 == 'null':
        v3 = None
    if v4 == 'null':
        v4 = None
    if v5 == 'null':
        v5 = None
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(v1,v2,v3,v4,v5))
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic_5_arg: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.05)
