# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "3.6.106"    # Technical changes after Python 3.8 testing with Calibre 4.99.4
import os, sys, apsw
from calibre import isbytestring
from calibre.constants import filesystem_encoding, DEBUG
from calibre.utils.logging import Log as log
from time import sleep

from polyglot.builtins import as_unicode
from polyglot.queue import Queue

notifications = Queue()

mynothing = ""


from calibre_plugins.quarantine_and_scrub.heading import log_heading_common
header_s1 = None
header_s2 = None
header_s3 = None
header_s4 = None
header_s5 = None

from calibre_plugins.quarantine_and_scrub.convert_types_to_other_types import (qs_standardize_any_string,
                                                            qs_convert_list_of_nominal_book_ids_to_integers, qs_standardize_string_numerics)
from calibre_plugins.quarantine_and_scrub.debug_nicely import debug_nicely
from calibre_plugins.quarantine_and_scrub.titlecase import titlecase

 #----------------------------------------------------------------------------------------------------------------
def util_copy_original_metadata(self, guidb, log=None, abort=None, notifications=True):  # <<<<====called from jobs.py

    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    global mynothing


    db = guidb
    path = db.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')
    if DEBUG: print(path)
    log(path)
    try:
        my_db = apsw.Connection(path)
    except Exception as e:
        return (self,gui,None,None,None)

    my_cursor = my_db.cursor()

    header_s1 =  "SQLite Version: " + as_unicode(apsw.SQLITE_VERSION_NUMBER) + "  [APSW]"

    mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds
    my_cursor.execute(mysql)

    header_s2 = mysql

    header_s3 = "Beginning Copying Real to Work Data"

    #check library uuid.  it must be:  07111111-0000-4000-b000-f00000000001
    my_cursor.execute("SELECT count(*) FROM library_id WHERE uuid = '07111111-0000-4000-b000-f00000000001'  ;")
    data = my_cursor.fetchone()[0]
    if data > 0:
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
    else:
        header_s4 = "Library UUID is NOT correct."
        log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
        my_db.close()
        return

    #now check for custom sqlite objects:
    mysql = "SELECT id, label FROM custom_columns WHERE label = 'work_author' or label = 'work_tags' \
            or label = 'work_title' or label = 'work_series' or label = 'work_series_number' or label = 'work_freeze' or label = 'status'     ;"
    try:
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) == 0:
            log("[1] custom columns for this plugin were not found in the custom_column table.")
            my_db.close()
            return
    except Exception as e:
        raise e
        log(as_unicode(e))
        my_db.close()
        return

    r1 = ""
    r2 = ""
    r3 = ""
    r4 = ""
    r5 = ""
    r6 = ""
    r7 = ""

    for row in tmp_rows:
        id, label = row
        s = as_unicode(id) + ',' + label.lower()
        if DEBUG: print(s)
        tmp_list = s.split(",")
        for item in tmp_list:
            n1 = tmp_list[1].find("work_author")
            n2 = tmp_list[1].find("work_title")
            n3 = tmp_list[1].find("work_series")
            n4 =  tmp_list[1].find("work_series_number")
            n5 =  tmp_list[1].find("work_tags")
            n6 =  tmp_list[1].find("work_freeze")
            n7 =  tmp_list[1].find("status")

            if n1 >= 0:
                r1 = tmp_list[0]
            else:
                if n2 >= 0:
                    r2  = tmp_list[0]
                else:
                    if n4 >= 0: #must do prior to n3...substring match on 'series'
                        r4 = tmp_list[0]
                    else:
                        if n3 >= 0:
                            r3  = tmp_list[0]
                        else:
                            if n5 >= 0:
                                r5  = tmp_list[0]
                            else:
                                if n6 >= 0:
                                    r6 = tmp_list[0]
                                else:
                                    if n7 >= 0:
                                        r7 = tmp_list[0]
                                    else:
                                        pass
        #END FOR
    #END FOR

    if DEBUG: print("custom column number for work_author is:        ", as_unicode(r1))
    if DEBUG: print("custom column number for work_title is:         ", as_unicode(r2))
    if DEBUG: print("custom column number for work_series is:        ", as_unicode(r3))
    if DEBUG: print("custom column number for work_series_number is: ", as_unicode(r4))
    if DEBUG: print("custom column number for work_tags is:          ", as_unicode(r5))
    if DEBUG: print("custom column number for work_freeze is:        ", as_unicode(r6))
    if DEBUG: print("custom column number for status           is:        ", as_unicode(r7))

    if r1 != '4' or r2 != '8' or r3 != '10' or r4 != '12' or r5 != '13' or r6 != '16' or r7 != '18' :
        if DEBUG: print("r1 != 4 or r2 != 8 or r3 != 10 or r4 != 12 or r5 != 13 or r6 != 16 or r7 != 18")
        log("This Metadata.db Has Been Corrupted. Custom Columns Incorrect for Plugin. Reinstall Plugin From Beginning.")
        log("This Metadata.db Is Special, and was designed for this Plugin.  Download it, replace this one, and Check Library")
        log("The Calibre Check Library function will check the books not showing in the replacement metadata.db, and add them to it.")
        log("You will NOT lose your books.  However, you will lose the Metadata if you have not let Calibre write out the .opf files.")
        log("In which case, you will have to 'Add Books' again for the replaced metadata.db so it will rebuild the Metadata.")
        log("Moral of this story:  Do Not Mess With the Custom Columns of this Plugin's Special metadata.db")
        log("The tables, views and indices have been hand-crafted to make this Plugin work efficiently and effectively.")
        my_db.close()
        return
    else:
        pass
        #log("The 7 Custom Columns for Q&S were verified as being present and unchanged.")

    ##Create_SQLite_objects(my_db, my_cursor, log)       #not used at this time

    log("Erasing All Work Custom Column Data")
    notifications.put((0.01, 'Erasing All Work Custom Column Data'))
    #----------------------------------------------------------------------------------------------
    c_work_author_table = "custom_column_4"
    mysql = "DELETE FROM custom_column_4  "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    l_work_author_table = "books_custom_column_4_link"
    mysql = "DELETE FROM books_custom_column_4_link  "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_title_table = "custom_column_8"
    mysql = "DELETE FROM custom_column_8  "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    l_work_title_table = "books_custom_column_8_link"
    mysql = "DELETE FROM books_custom_column_8_link  "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_series_table = "custom_column_10"
    mysql = "DELETE FROM custom_column_10  "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    l_work_series_table = "books_custom_column_10_link"
    mysql = "DELETE FROM books_custom_column_10_link  "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_series_index_table = "custom_column_12"  #this is an integer.  this table IS the link table.
    mysql = "DELETE FROM custom_column_12  "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_tags_table = "custom_column_13"
    mysql = "DELETE FROM custom_column_13  "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    l_work_tags_table = "books_custom_column_13_link"
    mysql = "DELETE FROM books_custom_column_13_link  "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_tags_table = "custom_column_15"
    mysql = "DELETE FROM custom_column_15  "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_freeze_table = "custom_column_16"
    mysql = "DELETE FROM custom_column_16 WHERE id >= '0' "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "DELETE FROM _tags_work_single WHERE tag NOT NULL"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "DELETE FROM _dg_missing_tag_rules"       #avoid having it grow forever because the user doesn't purge it after it is no longer is useful.
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "DELETE FROM _books_work"                       #used to explode cc4 for "bad authors", such as the Cowgirl example...
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "DELETE FROM _book_awards_mapping"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    if DEBUG: print("sleep 1")
    sleep(0.25)

    #----------------------------------------------------------------------------------------------
    log("Populating All Work Custom Columns From Real Metadata")
    notifications.put((0.02, 'Populating All Work Custom Columns From Real Metadata'))
    #----------------------------------------------------------------------------------------------

    #IMPORTANT NOTE:  Calibre will "on its own"  relink duplicate authors in custom column 4 so the authors are unique regardless of the sqlite constraints!
    #Calibre will do this whenever the metadata is edited in the GUI.  Example!  copy real to work for a selected book (no job; normal Calibre GUI processing).
    #So, the only way to fix what Calibre does is to run authorlevel or booklevel, which both do the same thing as shown below.
    # __book_author_name_sort is a *view* using table authors & table books_authors_link
    c_work_author_table = "custom_column_4"        #work author    is unique to each book, but multiple real authors can exist, so ignore all but first
    mysql = "INSERT OR IGNORE INTO custom_column_4 SELECT book,name FROM __book_author_name_sort  WHERE name not null"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    l_work_author_table = "books_custom_column_4_link"   #work author book link with a work author unique to each book,
    #                                                                                        but multiple real authors can exist, so ignore all but first
    mysql = "INSERT or IGNORE INTO books_custom_column_4_link SELECT book,book,book FROM __book_author_name_sort "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return
    sleep(0.5)

    fix_bad_authors_to_conform_to_explosion_logic(my_db, my_cursor)     #concatenates "bad authors" and makes them a single work author. example:  Cowgirls Up & Rodeo (2009)
    sleep(0.2)
    mysql = "UPDATE custom_column_4 SET value = (SELECT authorname FROM _books_work WHERE book = custom_column_4.id) WHERE custom_column_4.id IN(SELECT book FROM   _books_work)"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return
    sleep(0.5)
    #leave the existing entries in table _books_work for use by authorlevel scrubbing or booklevel scrubbing when the explode cc4...

    c_work_title_table = "custom_column_8"   #work title
    mysql = "INSERT or IGNORE INTO custom_column_8 SELECT id, title FROM books "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    l_work_title_table = "books_custom_column_8_link"   #work title book link
    mysql = "INSERT or IGNORE INTO books_custom_column_8_link SELECT id, id, id FROM custom_column_8 "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_title_table = "custom_column_10"   #work series
    mysql = "INSERT or IGNORE INTO custom_column_10 SELECT id, name FROM series "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    l_work_title_table = "books_custom_column_10_link"   #work series book link
    mysql = "INSERT or IGNORE INTO books_custom_column_10_link SELECT * FROM books_series_link "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    #now, give each book its own row in custom_column_10 by making the id = book
    c_work_title_table = "custom_column_10"   #work series
    mysql = "INSERT or IGNORE INTO custom_column_10 SELECT book, seriesname FROM __books_work_populate "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    #now link the book to its personal row in cc10
    l_work_title_table = "books_custom_column_10_link"   #work series book link
    mysql = "UPDATE books_custom_column_10_link  SET value = book"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    #now delete the original non-redundant cc10 entries now that each book has its own cc10 entry.  they are no longer used.
    mysql = "DELETE FROM custom_column_10 WHERE id NOT IN(SELECT value FROM books_custom_column_10_link)"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_title_table = "custom_column_12"   #work series index (this table IS the link table)
    mysql = "INSERT or IGNORE INTO custom_column_12 SELECT id, id, series_index FROM books "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    #set the seriesindex to 0 if the seriesname is null to make updates to the work_seriesindex obvious and noticeable
    c_work_title_table = "custom_column_12"   #work series index (this table IS the link table)
    mysql =  "UPDATE custom_column_12 SET value = 0  WHERE book IN (SELECT book FROM  __books_work_populate WHERE seriesname is null)"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_title_table = "custom_column_15"   #work series full (this table IS the link table)
    mysql = "INSERT or IGNORE INTO custom_column_15 SELECT book,book,seriesfull FROM __series_work_full WHERE book > 0 "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_title_table = "custom_column_15"   #work series index (this table IS the link table)
    mysql =  "UPDATE custom_column_15 SET value=REPLACE(value,'.0','') "  #remove the .0 from all series indexes in the work series full table
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_title_table = "custom_column_15"   #work series index (this table IS the link table)
    mysql =  "UPDATE custom_column_15 SET value=REPLACE(value,'.5]','.50]') " #tweak the series index of 0.5 to look identical to Calibre's 0.50
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    c_work_freeze_table = "custom_column_16"
    mysql = "INSERT OR REPLACE INTO custom_column_16 (id,book,value) SELECT book, book,'0' FROM books_custom_column_4_link "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    if DEBUG: print("sleep 2")
    sleep(0.25)

    notifications.put((0.10, 'Populating Work Tables for Tags'))

    concatenate_tags_for_books(my_db, my_cursor)  #custom_column_13 and its link table

    if DEBUG: print("sleep 3")
    sleep(0.25)

    notifications.put((0.20, 'Populating Work Custom Columns From Real Metadata'))

    #remove leading and trailing spaces from everything
    mysql =   "UPDATE _global_subject_codes SET subject = trim(subject); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql =   "UPDATE _global_authors SET name = trim(name); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql =   "UPDATE _global_authors SET sort = trim(sort); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql =   "UPDATE _global_series SET name = trim(name); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql =   "UPDATE _global_series SET sort = trim(sort); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql =   "UPDATE _pristine_authors SET name = trim(name); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql =   "UPDATE _pristine_authors SET sort = trim(sort); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    notifications.put((0.55, 'Populating Work Custom Columns From Real Columns'))

    mysql =   "UPDATE _pristine_series SET name = trim(name); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql =   "UPDATE custom_column_4 SET value = trim(value); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql =   "UPDATE custom_column_8 SET value = trim(value); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql =   "UPDATE custom_column_10 SET value = trim(value); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql =   "UPDATE custom_column_13 SET value = trim(value); "
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    s1 = '"'
    s2 = ''
    s1 = as_unicode(s1)
    s2 = as_unicode(s2)
    # double quotes cause sql errors
    try:
        my_cursor.execute("begin")
        mysql = 'UPDATE custom_column_4 SET value = replace(custom_column_4.value,?,?)'  # work_author
        my_cursor.execute(mysql,(s1,s2))
        mysql = 'UPDATE custom_column_8 SET value = replace(custom_column_8.value,?,?)'  # work_title
        my_cursor.execute(mysql,(s1,s2))
        mysql = 'UPDATE custom_column_10 SET value = replace(custom_column_10.value,?,?)'  # work_series
        my_cursor.execute(mysql,(s1,s2))
        mysql = 'UPDATE custom_column_13 SET value = replace(custom_column_13.value,?,?)'  # work_tags
        my_cursor.execute(mysql,(s1,s2))
        mysql = 'UPDATE custom_column_15 SET value = replace(custom_column_15.value,?,?)'  # work_series_full
        my_cursor.execute(mysql,(s1,s2))
        my_cursor.execute("commit")
    except Exception as e:
        my_db.close()
        if DEBUG: print(mysql)
        if DEBUG: print(as_unicode(e))
        log (mysql, as_unicode(e))
        return


    if DEBUG: print("sleep 4")
    sleep(0.25)

    titlecase_authors(my_db,my_cursor,log)

    update_status(my_db, my_cursor) #change the status to 'dirty'

    notifications.put((0.95, 'Reindexing Custom Column Tables'))

    if DEBUG: print("Q&S Custom Column Tables Will Now Be Reindexed")
    log("Q&S Custom Column Tables Will Now Be Reindexed")

    if DEBUG: print("sleep 7")
    sleep(0.25)

    mysql = "REINDEX _custom_column_4"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX _custom_column_8"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX _custom_column_10"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX _custom_column_12"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX _custom_column_13"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX  books_custom_column_4_link_aidx"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX  books_custom_column_4_link_bidx"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX  books_custom_column_8_link_aidx"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX  books_custom_column_8_link_bidx"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX  books_custom_column_10_link_aidx"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX  books_custom_column_10_link_bidx"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX  books_custom_column_13_link_aidx"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    mysql = "REINDEX  books_custom_column_13_link_bidx"
    is_valid = execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if not is_valid:
        return

    notifications.put((0.98, 'Scrubbing ISBNs'))

    if DEBUG: print("sleep 8")
    sleep(0.25)

    try:
        my_cursor.execute("begin")
        mysql = "UPDATE identifiers SET val = (replace(val,'-','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%-%')"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.1)
        my_cursor.execute("begin")
        mysql = "UPDATE identifiers SET val = (replace(val,'isbn:','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%isbn:%') "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.1)
        my_cursor.execute("begin")
        mysql = "UPDATE identifiers SET val = (replace(val,'eBook ISBN:','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%eBook ISBN:%') "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.1)
        my_cursor.execute("begin")
        mysql = "UPDATE identifiers SET val = (replace(val,' ','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '% %') "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        if DEBUG: print("All ISBN13s have been standardized by removing any dashes and prefixes.")
        log("All ISBN13s have been standardized by removing any dashes and prefixes.")
    except Exception as e:
        my_db.close()
        if DEBUG: print(mysql)
        if DEBUG: print(as_unicode(e))
        return

    convert_identifiers_isbn_from_10_to_13(my_db, my_cursor, log)

    notifications.put((0.99, 'Q&S Database Being Vacuumed [Defragmented]') )
    #~ if DEBUG: print("Q&S Database Will Now Be Vacuumed [Defragmented]")
    log("Q&S Database Will Now Be Vacuumed [Defragmented]")

    sleep(0.1)

    try:
        mysql = "Vacuum"
        my_cursor.execute(mysql)
    except Exception as e:
        my_db.close()
        if DEBUG: print(mysql)
        if DEBUG: print(as_unicode(e))
        return

    my_db.close()

    if DEBUG: debug_nicely(locals(),sys._getframe(0).f_code.co_name,sys._getframe(1).f_code.co_name, 'Complete.')

    log("Job complete.")
 #----------------------------------------------------------------------------------------------------------------
def concatenate_tags_for_books(my_db, my_cursor):

    try:
        my_cursor.execute("begin")
        mysql = "DELETE FROM _tags_work "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        if DEBUG: print(mysql)
        if DEBUG: print(as_unicode(e))
        raise e

    #initially populate it with the key of every book that has a tag; the value of tagsconcat is defaulted to Unknown temporarily
    try:
        my_cursor.execute("begin")
        mysql = "INSERT or IGNORE INTO _tags_work SELECT book, 'Unknown'  FROM books_tags_link "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        if DEBUG: print(mysql)
        if DEBUG: print(as_unicode(e))
        raise e

    #since there are multiple tags per book, must concatenate them into the work_tags column separated by a comma

    tmp_rows = []
    del tmp_rows
    tmp_rows = []
    mysql = as_unicode("SELECT book,'dummy' FROM _tags_work ")
    try:
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall() #will get all of the rows from the query
    except Exception as e:
        if DEBUG: print(mysql)
        if DEBUG: print(as_unicode(e))
        raise e

    my_counter = 0
    my_cursor.execute("begin")
    for row in tmp_rows:
        book,dummy = row
        my_counter = my_counter + 1
        #~ book = as_unicode(qs_standardize_string_numerics(book))
        try:
            mysql = "UPDATE _tags_work SET tagsconcat = (SELECT tagsconcat FROM __tags_work_concatenate WHERE book = _tags_work.book ) \
                                                             WHERE _tags_work.book = ? "
            #~ mysql = as_unicode(mysql.replace("[BOOK]", as_unicode(book), 2))
            my_cursor.execute(mysql,([book]))
            if my_counter > 499:
                my_cursor.execute("commit")
                my_counter = 0
                sleep(0.02)
                my_cursor.execute("begin")
            else:
                pass
        except Exception as e:
            if DEBUG: print(mysql)
            if DEBUG: print(as_unicode(e))
            raise e
    #END FOR
    if my_counter > 0:
        try:
            my_cursor.execute("commit")
        except:
            pass

    #now update the 2 work custom_column tag tables using table _tags_work

    try:
        c_work_tag_table = "custom_column_13"   #work tags       the id == book
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO custom_column_13 (id,value) SELECT book,tagsconcat FROM _tags_work"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        if DEBUG: print(mysql)
        if DEBUG: print(as_unicode(e))
        raise e

    try:
        l_work_tag_table = "books_custom_column_13_link"   #work tags  the id == book == value == id from above which == book
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO books_custom_column_13_link (id,book,value) SELECT book,book,book FROM _tags_work"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        if DEBUG: print(mysql)
        if DEBUG: print(as_unicode(e))
        raise e
 #----------------------------------------------------------------------------------------------------------------
def update_status(my_db, my_cursor):
   #now update status
    tmp_id_rows = []
    del tmp_id_rows

    mysql = "SELECT id,'dummy' FROM custom_column_18 WHERE value = 'dirty' "
    tmp_id_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_id_rows:
        sleep(0.25) #avoid db locks
        mysql = "INSERT OR IGNORE INTO custom_column_18 (id,value) VALUES (null, 'dirty') "
        execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        if DEBUG: print("sleep 5")
        sleep(0.25)
        mysql = "SELECT id,'dummy' FROM custom_column_18 WHERE value = 'dirty' "
        tmp_id_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)

    if not tmp_id_rows:
        if DEBUG: print("sql error: custom_column_18 WHERE value = 'dirty' ")
        return

    if len(tmp_id_rows) == 0:
        if DEBUG: print("sql error: custom_column_18 WHERE value = 'dirty' ")
        return

    row = tmp_id_rows[0]
    tmp_id,dummy = row
    if not isinstance(tmp_id,int):
        tmp_id = qs_standardize_string_numerics(tmp_id,return_integer=True)

    sleep(0.25) #avoid db locks
    mysql = "DELETE FROM books_custom_column_18_link"       # 'dirty'
    execute_mysql_commit_simple(my_db, my_cursor, log, mysql)
    if DEBUG: print("sleep 6")
    sleep(0.25)
    mysql = "INSERT OR REPLACE INTO books_custom_column_18_link (id,book,value) SELECT book, book, ? FROM __books_work_populate WHERE book > ? "
    execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_id, 0)

def execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql):

    sleep(0.02) #avoid db locks

    tmp_rows = []
    del tmp_rows
    tmp_rows = []

    mysql = as_unicode(mysql)
    try:
        sleep(0.25)  #avoid lock errors
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if tmp_rows:
            return tmp_rows
        else:
            tmp_rows = []
            return tmp_rows
    except:
        #likely due to database lock; sleep then try again...
        if DEBUG: print("database LOCK error; sleeping and will then try again")
        sleep(10.0)
        tmp_rows = []
        del tmp_rows
        tmp_rows = []
        try:
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if tmp_rows:
                return tmp_rows
            else:
                tmp_rows = []
                return tmp_rows
        except Exception as e:
            log(as_unicode(e))
            printsafely(as_unicode(e))
            printsafely(mysql)
            printsafely("execute_mysql_fetchall_generic:   try-except failure")
            my_db.close()
            printsafely("database has been CLOSED")
            raise e
            sys.exit("ERROR in execute_mysql_fetchall_generic....")
#-----------------------------------------------------------------------------------------------------------------
def execute_mysql_commit_simple(my_db, my_cursor, log, mysql):
    is_valid = True
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        log(as_unicode(e))
        if DEBUG: print(as_unicode(e))
        my_db.close()
        if DEBUG: ("database has been CLOSED")
        is_valid = False
    sleep(0)
    return is_valid
#-----------------------------------------------------------------------------------------------------------------
def execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql):

    global freeze_current_book
    freeze_current_book = True

    try:
        sleep(0.25)  #avoid lock errors
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except:
        if DEBUG: print("database locked; sleeping and then will retry")
        sleep(10.0)
        try:
            try:
                my_cursor.execute("begin")
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
            except:
                my_cursor.execute(mysql)
                try:
                    my_cursor.execute("commit")
                except:
                    pass
        except Exception as e:
            log(as_unicode(e))
            printsafely(as_unicode(e))
            my_db.close()
            printsafely("database has been CLOSED")
            raise e
            sys.exit("ERROR in execute_mysql_with_commit_generic....")

    sleep(0.03) #avoid db locks
#-----------------------------------------------------------------------------------------------------------------
def printsafely(*arg):
    try:
        if DEBUG: print(arg)
        return
    except:
        if DEBUG: print("...cannot be printed...")
        return
 #----------------------------------------------------------------------------------------------------------------
def execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, v1, v2=""):

    global mynothing

    global freeze_current_book
    freeze_current_book = True

    printsafely("v1: ", as_unicode(v1), " v2: ", as_unicode(v2))

    s2 = as_unicode(v2)  #second parameter is optional

    if s2 == mynothing:
        s2 = "IGNORE"

    try:
        sleep(0.25)  #avoid lock errors
        my_cursor.execute("begin")
        if s2 != "IGNORE":
            my_cursor.execute(mysql,(v1,v2))
        else:
            my_cursor.execute(mysql,(v1))
        my_cursor.execute("commit")
    except:
        if DEBUG: print("database locked; sleeping and then will retry")
        sleep(5.0)
        try:
            if s2 != "IGNORE":
                my_cursor.execute(mysql,(v1,v2))
            else:
                my_cursor.execute(mysql,(v1))
                my_cursor.execute("commit")
        except Exception as e:
            log(as_unicode(e))
            printsafely(as_unicode(e))
            my_db.close()
            printsafely("database has been CLOSED")
            raise e
            sys.exit("ERROR in execute_mysql_for_custom_column_generic")

    sleep(0.03) #avoid db locks
 #----------------------------------------------------------------------------------------------------------------
 #----------------------------------------------------------------------------------------------------------------
def convert_identifiers_isbn_from_10_to_13(my_db, my_cursor, log):
    #optimized for speed: version 3.1.3

    mysql = "SELECT book, val FROM identifiers WHERE type = 'isbn'  AND val NOT LIKE '978%'  \
                    AND val NOT LIKE '979%' AND val NOT LIKE '%isbn%'  AND val NOT NULL;"
    tmp_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        return
    else:
        n = len(tmp_rows)
        log("Number of ISBNs Requiring Conversion: " + as_unicode(n))
        if n == 0 :
            return
        my_counter = 0
        my_total = 0
        my_cursor.execute("begin")
        for row in tmp_rows:
            my_counter = my_counter + 1
            my_total = my_total + 1
            book, val = row
            old_isbn = as_unicode(qs_standardize_string_numerics(val))
            old_isbn = old_isbn.strip()
            if len(old_isbn) == 10:
                new_isbn = as_unicode(convert_isbn_convert_10_to_13(old_isbn))
                if len(new_isbn) == 13:
                    mysql = "UPDATE identifiers SET val = ? WHERE book = ? AND type = 'isbn' "
                    #execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, new_isbn, book)
                    my_cursor.execute(mysql,(new_isbn, book))
                    log("ISBN10 Converted to ISBN13: " + as_unicode(old_isbn) + " >>> " + as_unicode(new_isbn))
                else:
                    log("This ISBN10 appears to not really be an ISBN10, and was deleted:  " + as_unicode(old_isbn) )
                    mysql = "DELETE FROM identifiers WHERE val = ? AND book = ? AND type = 'isbn' "
                    #execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, old_isbn, book)
                    my_cursor.execute(mysql,(old_isbn, book))
            else:
                log("This ISBN appears to not really be any kind of ISBN, and was deleted:  " + as_unicode(old_isbn) )
                mysql = "DELETE FROM identifiers WHERE val = ? AND book = ? AND type = 'isbn' "
                #execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, old_isbn, book)
                my_cursor.execute(mysql,(old_isbn, book))
            sleep(0.05)
            if my_counter > 500 :
                try:
                    my_cursor.execute("commit")
                    my_cursor.execute("begin")
                except:
                    pass
                my_counter = 0
                log("Total ISBNs Processed So Far: " + as_unicode(my_total) + "  " + as_unicode((my_total/n)) )
        #END FOR
        if my_counter > 0:
            try:
                my_cursor.execute("commit")
            except:
                pass
        log("Total ISBNs Converted or Deleted: " + as_unicode(my_total))
 #----------------------------------------------------------------------------------------------------------------
 #----------------------------------------------------------------------------------------------------------------
def convert_isbn_check_digit_13(isbn):
    try:
        assert len(isbn) == 12
        sum = 0
        for i in range(len(isbn)):
            c = int(isbn[i])
            if i % 2: w = 3
            else: w = 1
            sum += w * c
        r = 10 - (sum % 10)
        if r == 10: return '0'
        else: return as_unicode(r)
    except:
        return isbn
 #----------------------------------------------------------------------------------------------------------------
 #----------------------------------------------------------------------------------------------------------------
def convert_isbn_convert_10_to_13(isbn):
    try:
        assert len(isbn) == 10
        prefix = '978' + isbn[:-1]
        check = convert_isbn_check_digit_13(prefix)
        return prefix + check
    except:
        return isbn
 #----------------------------------------------------------------------------------------------------------------
 #----------------------------------------------------------------------------------------------------------------
def fix_bad_authors_to_conform_to_explosion_logic(my_db, my_cursor):
    #concatenates "bad authors" and makes them a single work author. example:  Cowgirls Up & Rodeo (2009)
    #do what ui.py does with copying real to work for only selected books...

    list_of_books_with_2_authors = []

    try:
        mysql = "SELECT book,name FROM __book_author_name_sort  WHERE book NOT NULL"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            return
        else:
            n_rows = len(tmp_rows)
            if n_rows == 0:
                return
        for row in tmp_rows:
            tmp_rows2 = []
            del tmp_rows2
            book,name = row
            mysql = "SELECT COUNT(book) FROM __book_author_name_sort  WHERE book = ?  GROUP BY book"
            my_cursor.execute(mysql,([book]))
            tmp_rows2 = my_cursor.fetchall()
            if not tmp_rows2:
                continue
            else:
                n_rows = len(tmp_rows2)
                if n_rows == 0:
                    continue
                for item in tmp_rows2:
                    for col in item:
                        count = as_unicode(col)
                if count != '2' :       #Cowgirls Up & Rodeo (2009)
                    continue
                list_of_books_with_2_authors.append(book)
    except Exception as e:
        raise e
        log(as_unicode(e))
        my_db.close()
        return

    n = len(list_of_books_with_2_authors)
    if n == 0:
        return

    list_of_books_with_2_authors = list(set(list_of_books_with_2_authors))
    list_of_books_with_2_authors = qs_convert_list_of_nominal_book_ids_to_integers(list_of_books_with_2_authors)
    list_of_books_with_2_authors.sort()

    for book in list_of_books_with_2_authors:
        mysql = "SELECT book,name FROM __book_author_name_sort  WHERE book = ?"
        my_cursor.execute(mysql,([book]))
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            continue
        else:
            n_rows = len(tmp_rows)
            if n_rows != 2:
                continue
        author_is_bad = False        #same logic  as in ui.py for Cowgirl Up & Ride (2009)
        for row in tmp_rows:   #always 2 rows for a single book because of "count" logic above...
            book,name = row
            if any(char.isdigit() for char in name):
                author_is_bad = True
            if ":" in name or "{" in name:
                author_is_bad = True
        if not author_is_bad:
            continue
        author = " "
        for row in tmp_rows:
            book,name = row
            author = author + " & " + name
        #END FOR
        author = author.strip()
        if author.startswith("&"):
            author = author[1: ]
        author = author.strip()
        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO _books_work (book,booktitle,authorname,seriesname,seriesindex) VALUES (?,null,?,null,null) "
        my_cursor.execute(mysql,(book,author))
        my_cursor.execute("commit")
        del tmp_rows
        if DEBUG: debug_nicely(locals(),sys._getframe(0).f_code.co_name,sys._getframe(1).f_code.co_name)
#----------------------------------------------------------------------------------------------------------------
def titlecase_authors(my_db,my_cursor,log):
    if DEBUG: print("current function being executed: ", sys._getframe(0).f_code.co_name)
    sleep(.1)
    rows = list(my_cursor.execute("SELECT id,value FROM custom_column_4") )
    mysql = "UPDATE custom_column_4 SET value = ? WHERE id = ?"
    my_cursor.execute("begin")
    for row in rows:
        id,value = row
        value = titlecase(value)
        value = value.strip()
        my_cursor.execute(mysql,(value,id))
    #END FOR
    my_cursor.execute("commit")
    log("Work Authors title-cased: " +as_unicode(len(rows)) )
    sleep(0)
 #-----------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
#END of copywork.py
