# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "3.6.106"    # Technical changes after Python 3.8 testing with Calibre 4.99.4

from PyQt5.Qt import (Qt, QDialog, QLabel, QLineEdit, QVBoxLayout, QHBoxLayout, QWidget, QPushButton,
        QGridLayout, pyqtSignal, QDialogButtonBox, QScrollArea, QFont, QPalette, QColor,
        QTabWidget, QIcon, QToolButton, QSplitter, QGroupBox, QSpacerItem, QCheckBox,
        QSizePolicy, QFrame, QSize, QKeySequence, QMenu, QShortcut)


from polyglot.builtins import as_unicode

class WorkSeriesDestroyDialog(QDialog):

    def __init__(self, gui,icon,guidb,execute_work_series_search_and_destroy):


        QDialog.__init__(self, gui)
        self.gui = gui

        self.guidb = guidb

        self.execute_work_series_search_and_destroy = execute_work_series_search_and_destroy

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(11)

        self.layout.addSpacing(2)

        self.text_heading = QLabel()
        self.text_heading.setTextFormat(1)
        self.text_heading.setText("<center><font color='#0404B4'>Search & Destroy a Specific Work Series Name [Selected Books]</font></center>")
        self.text_heading.setFont(font)
        self.layout.addWidget(self.text_heading)
        self.layout.addSpacing(20)


        self.setWindowTitle('Quarantine And Scrub                                                                                                                          ')
        self.setWindowIcon(icon)

        font.setBold(True)
        font.setPointSize(8)

        self.label1 = QLabel()
        self.label1.setTextFormat(1)
        self.label1.setText("<center><font color='#0404B4'>Work Series Name for which to Search && Destroy</font></center>")
        self.label1.setFont(font)
        self.layout.addWidget(self.label1)

        self.msg1 = QLineEdit(self)
        self.msg1.setText('?')
        self.layout.addWidget(self.msg1)
        self.label1.setBuddy(self.msg1)

        self.layout.addSpacing(10)

        self.use_substring_checkbox = QCheckBox('Is a Partial Match Sufficient to Destroy a Work Series Name?')
        self.layout.addWidget(self.use_substring_checkbox)

        self.layout.addSpacing(30)

        self.push_button1 = QPushButton(" ", self)
        self.push_button1.setText("Execute: Work Series Name Search && Destroy [Selected Books]")
        self.push_button1.clicked.connect(self.__do_push_button1)
        self.push_button1.setFont(font)
        self.layout.addWidget(self.push_button1)

        self.layout.addSpacing(20)

        font.setBold(True)
        font.setPointSize(8)

        button_box = QDialogButtonBox(QDialogButtonBox.Cancel)
        button_box.rejected.connect(self.reject)
        self.layout.addWidget(button_box)

        self.resize(self.sizeHint())


    def __do_push_button1(self):
        self.work_series_keyword = as_unicode(self.msg1.text())
        self.work_series_keyword = self.work_series_keyword.strip()
        self.use_substring = as_unicode(self.use_substring_checkbox.isChecked())
        self.execute_work_series_search_and_destroy(self.work_series_keyword,self.use_substring)



#END of workseriesdestroydialog.py
