# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "3.6.106"    # Technical changes after Python 3.8 testing with Calibre 4.99.4
from PyQt5.Qt import (QMenu, QDialog, QIcon, QAction, QVBoxLayout,
                                      QPushButton, QMessageBox, QLabel, QWidget, QRegularExpression)
import os, sys
import apsw
from copy import deepcopy
from functools import partial
import subprocess
from time import sleep
import unicodedata
import zipfile
from calibre import isbytestring
from calibre.constants import filesystem_encoding, iswindows, DEBUG
from calibre.db.cache import Cache as dbcache
from calibre.ebooks.metadata.meta import set_metadata
from calibre.ebooks.metadata.book.base import Metadata
from calibre.gui2 import info_dialog, question_dialog, error_dialog, Dispatcher
from calibre.gui2.actions import InterfaceAction
from polyglot.builtins import as_unicode, iteritems, map, unicode_type
from polyglot.queue import Queue
from calibre_plugins.quarantine_and_scrub.config import prefs
from calibre_plugins.quarantine_and_scrub.config import ConfigWidget
from calibre_plugins.quarantine_and_scrub.configdialog import ConfigDialog
from calibre_plugins.quarantine_and_scrub.tag_rules_list_editor import TagRulesListEditor
from calibre_plugins.quarantine_and_scrub.tag_rules_list_editor_ui import Ui_TagRulesListEditor
from calibre_plugins.quarantine_and_scrub.tag_rules_list_editor_2 import TagRulesListEditor2
from calibre_plugins.quarantine_and_scrub.tag_rules_list_editor_ui_2 import Ui_TagRulesListEditor2
from calibre_plugins.quarantine_and_scrub.ui_toastdialog import UIToastDialog
from calibre_plugins.quarantine_and_scrub.workauthorchangedialog import WorkAuthorChangeDialog
from calibre_plugins.quarantine_and_scrub.workseriesadddialog import WorkSeriesAddDialog
from calibre_plugins.quarantine_and_scrub.workseriesdestroydialog import WorkSeriesDestroyDialog
from calibre_plugins.quarantine_and_scrub.workseriesreplacedialog import WorkSeriesReplaceDialog
from calibre_plugins.quarantine_and_scrub.workseriesindexchangedialog import WorkSeriesIndexChangeDialog
from calibre_plugins.quarantine_and_scrub.worktagadddialog import WorkTagAddDialog
from calibre_plugins.quarantine_and_scrub.worktagdestroydialog import WorkTagDestroyDialog
from calibre_plugins.quarantine_and_scrub.worktagreplacedialog import WorkTagReplaceDialog
from calibre_plugins.quarantine_and_scrub.worktitlechangedialog import WorkTitleChangeDialog
from calibre_plugins.quarantine_and_scrub.autopopchoicesdialog import AutoPopChoicesDialog
from calibre_plugins.quarantine_and_scrub.seriesconsolchoicesdialog import SeriesConsolChoicesDialog
from calibre_plugins.quarantine_and_scrub.common_utils import set_plugin_icon_resources, get_icon, create_menu_action_unique
from calibre_plugins.quarantine_and_scrub.jobs import (start_threaded_book_level, start_threaded_util_copy_original_metadata,
                                                                                            start_threaded_author_level, start_threaded_util_copy_pristine_metadata,
                                                                                            start_threaded_series_level,
                                                                                            start_threaded_miscellany, start_threaded_derive_genres,
                                                                                            start_threaded_purge_work_data, start_threaded_create_sqlite_objects)
from calibre_plugins.quarantine_and_scrub.classify_web_service_api import oclc_classify_api
from calibre_plugins.quarantine_and_scrub.convert_types_to_other_types import (qs_standardize_any_string,
                                                                                qs_convert_list_of_nominal_book_ids_to_integers, qs_standardize_string_numerics)
from calibre_plugins.quarantine_and_scrub.debug_nicely import debug_nicely
PLUGIN_ICONS = ['images/quarantineicon.png','images/view_refresh.png','images/idea.png','images/good.png','images/import.png',\
                            'images/readinstructionsicon.png','images/copy.png','images/qs_config.png','images/tags.png','images/ddc.png',\
                            'images/genre.png','images/ddclccicon.png','images/plus.png','images/search_and_replace.png','images/change.png',\
                            'images/tag_rules_menu.png','images/copy_circle.png','images/series.png','images/swap.png','images/wrench-hammer.png',\
                            'images/spraybottleicon.png','images/greenquarantineicon.png','images/sqldbcustomize.png','images/minus.png',\
                            'images/download.png','images/rename.png', 'images/update_cc.png','images/consolidate.png','images/minimize.png',
                            'images/propagate.png']
class QuarantineAndScrub(InterfaceAction):
    name = 'QuarantineAndScrub'
    action_spec = (_('Q+S'), None, _('Scrub Metadata for Books in the QuarantineAndScrub Special Library'), ())
    action_type = 'current'
    accepts_drops = False
    auto_repeat = False
    priority = 9
    popup_type = 1
    work_book_ids_list = []
    book_ids_list = []
    scrubbed_books_final_list = []
    selected_book_list = []
    def genesis(self):
        self.is_library_selected = True
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )
        self.menu = QMenu(self.gui)
        self.rebuild_menus()
        self.qaction.setMenu(self.menu)
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.create_ui_toast_dialog_for_main_icon)
        global work_book_ids_list
        global book_ids_list
        global scrubbed_books_final_list
        global selected_book_list
    def initialization_complete(self):
        global work_book_ids_list
        global book_ids_list
        global scrubbed_books_final_list
        global selected_book_list
        work_book_ids_list = []
        book_ids_list = []
        scrubbed_books_final_list = []
        selected_book_list = []
        self.guidb = self.gui.library_view.model().db
        self.my_jobs_dialog_object = None
        try:
            sre = QRegularExpression(".+")
            answer  = self.gui.findChildren(QWidget,sre)
            if answer:
                if isinstance(answer,list):
                    for item in answer:
                        if item:
                            s = as_unicode(item)
                            if "JobsDialog" in s:
                                self.my_jobs_dialog_object = item
                                break
        except:
            self.my_jobs_dialog_object = None
        self.library_is_quarantine_db = False
        self.library_db_path = None
    def ensure_correct_library(self):
        self.library_is_quarantine_db = False
        self.guidb = self.gui.library_view.model().db
        path = self.guidb.library_path
        n = path.find("QuarantineAndScrub")
        if n < 0:
            self.library_is_quarantine_db = False
            self.create_ui_toast_dialog(0)
            sleep(2.0)
        else:
            self.library_is_quarantine_db = True
            try:
                self.gui.library_view.model().stop_metadata_backup()
            except:
                pass
        try:
            self.ui_toast_dialog.close()
        except:
            pass
    def library_changed(self,guidb=None):
        self.guidb = self.gui.library_view.model().db
        global work_book_ids_list
        global book_ids_list
        global scrubbed_books_final_list
        global selected_book_list
        work_book_ids_list = []
        book_ids_list = []
        scrubbed_books_final_list = []
        selected_book_list = []
        self.rebuild_menus()
        self.qaction.setMenu(self.menu)
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        try:
            self.worktagdestroy_dialog.close()       #modal; avoids a "no backend" error if they switch while the dialog is still open.
        except:
            pass
        try:
            self.worktagadd_dialog.close()       #modal; avoids a "no backend" error if they switch while the dialog is still open.
        except:
            pass
        try:
            self.worktagreplace_dialog.close()       #modal; avoids a "no backend" error if they switch while the dialog is still open.
        except:
            pass
        try:
            self.workseriesreplace_dialog.close()       #modal; avoids a "no backend" error if they switch while the dialog is still open.
        except:
            pass
        try:
            self.workseriesdestroy_dialog.close()       #modal; avoids a "no backend" error if they switch while the dialog is still open.
        except:
            pass
        try:
            self.workseriesadd_dialog.close()       #modal; avoids a "no backend" error if they switch while the dialog is still open.
        except:
            pass
        try:
            self.workseriesindexchange_dialog.close()       #modal; avoids a "no backend" error if they switch while the dialog is still open.
        except:
            pass
        try:
            self.worktitlechange_dialog.close()       #modal; avoids a "no backend" error if they switch while the dialog is still open.
        except:
            pass
        try:
            self.workauthorchange_dialog.close()       #modal; avoids a "no backend" error if they switch while the dialog is still open.
        except:
            pass
        try:
            self.ui_toast_dialog.close()                #modal; avoids a "no backend" error if they switch while the dialog is still open.
        except:
            pass
    def rebuild_menus(self):
        m = self.menu
        m.clear()
        m.setTearOffEnabled(True)
        m.setWindowTitle('Quarantine And Scrub')
        m.addSeparator()
        create_menu_action_unique(self, m, 'Read Q&&S Instructions/User Guide', 'images/readinstructionsicon.png',
                      triggered=partial(self.view_user_instructions))
        m.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        create_menu_action_unique(self, m, 'Configure Q&&S [Path to Pristine Library; Maximum for Tag Minimizer; More]', 'images/qs_config.png',
                              triggered=partial(self.config))
        m.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        create_menu_action_unique(self, m, 'After Version Upgrade: Create New SQLite Database Objects [Important]', 'images/sqldbcustomize.png',
                              triggered=partial(self.create_sqlite_objects_begin_dialogs_with_user))
        m.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        self.m5 = QMenu(_('[Menu] Q&&S Pristine Validation Data Maintenance'))
        self.m5_action = m.addMenu(self.m5)
        self.m5.setIcon(get_icon('images/copy_circle.png'))
        self.m5.setTearOffEnabled(True)
        self.m5.setWindowTitle('Quarantine And Scrub: Pristine Validation Data Maintenance')
        self.m5.addSeparator()
        create_menu_action_unique(self, self.m5, 'Purge Pristine Authors/Series Validation Tables in Q&&S [If Not Really 100% Clean]', 'images/minus.png',
                              triggered=partial(self.purge_pristine_tables))
        self.m5.addSeparator()
        create_menu_action_unique(self, self.m5, ' ', ' ',
                              triggered=None)
        self.m5.addSeparator()
        create_menu_action_unique(self, self.m5, 'Copy Pristine Library Author/Series Tables to Q&&S as Validation Data [Only If 100% Clean]', 'images/copy_circle.png',
                              triggered=partial(self.copy_pristine_level_begin_dialogs_with_user))
        self.m5.addSeparator()
        create_menu_action_unique(self, self.m5, ' ', ' ',
                              triggered=None)
        self.m5.addSeparator()
        create_menu_action_unique(self, self.m5, 'Copy Valid Q&&S Real Authors to Q&&S Pristine Author Validation Table [Selected Books]', 'images/good.png',
                              triggered=partial(self.copy_real_author_to_pristine_author_table))
        self.m5.addSeparator()
        create_menu_action_unique(self, self.m5, ' ', ' ',
                              triggered=None)
        self.m5.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        self.m4 = QMenu(_('[Menu] Q&&S Purge Work Data'))
        self.m4_action = m.addMenu(self.m4)
        self.m4.setIcon(get_icon('images/minus.png'))
        self.m4.setTearOffEnabled(True)
        self.m4.setWindowTitle('Quarantine And Scrub: Purge Work Data')
        self.m4.addSeparator()
        create_menu_action_unique(self, self.m4, 'Purge All Work Data [All Books] [Routine Use]', 'images/minus.png',
                              triggered=partial(self.purge_work_data_begin_dialogs_with_user))
        self.m4.addSeparator()
        create_menu_action_unique(self, self.m4, ' ', ' ',
                              triggered=None)
        self.m4.addSeparator()
        create_menu_action_unique(self, self.m4, 'Purge All Work Data [Selected Books (Max=100)] [Spot Cleaning]', 'images/minus.png',
                              triggered=partial(self.purge_work_data_selected_books))
        self.m4.addSeparator()
        create_menu_action_unique(self, self.m4, ' ', ' ',
                              triggered=None)
        self.m4.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        self.m3 = QMenu(_('[Menu] Q&&S Copy Real to Work'))
        self.m3_action = m.addMenu(self.m3)
        self.m3.setIcon(get_icon('images/view_refresh.png'))
        self.m3.setTearOffEnabled(True)
        self.m3.setWindowTitle('Quarantine And Scrub: Copy Real to Work')
        self.m3.addSeparator()
        create_menu_action_unique(self, self.m3, 'Copy Q&&S Only Dirty Tags to Work Tags [Selected Books][For Standalone Tag Scrubber]', 'images/tags.png',
                              triggered=partial(self.copy_selected_tags_only_begin_dialogs_with_user))
        self.m3.addSeparator()
        create_menu_action_unique(self, self.m3, ' ', ' ',
                              triggered=None)
        self.m3.addSeparator()
        create_menu_action_unique(self, self.m3, 'Copy Q&&S All Dirty Data to Work Data [All Books] [Routine Use]', 'images/view_refresh.png',
                              triggered=partial(self.copy_work_level_begin_dialogs_with_user))
        self.m3.addSeparator()
        create_menu_action_unique(self, self.m3, 'Copy Q&&S All Dirty Data to Work Data [Selected Books (Max=100)] [Spot Cleaning]', 'images/view_refresh.png',
                              triggered=partial(self.copy_selected_work_level))
        self.m3.addSeparator()
        create_menu_action_unique(self, self.m3, ' ', ' ',
                              triggered=None)
        self.m3.addSeparator()
        create_menu_action_unique(self, self.m3, 'Copy Q&&S Only Dirty Series to Work Series [Selected Books][Work Author && Work Title Required]', 'images/series.png',
                              triggered=partial(self.copy_selected_series_only_begin_dialogs_with_user))
        self.m3.addSeparator()
        create_menu_action_unique(self, self.m3, ' ', ' ',
                              triggered=None)
        self.m3.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        create_menu_action_unique(self, m, 'Scrub Work Data at Author Level [All Books]', 'images/quarantineicon.png',
                              triggered=partial(self.scrub_begin_dialog_author_level))
        m.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        create_menu_action_unique(self, m, 'Scrub Work Data at Book Level [Selected Books]  [Confirmation]', 'images/quarantineicon.png',
                              triggered=partial(self.scrub_begin_dialog_book_level))
        m.addSeparator()
        create_menu_action_unique(self, m, 'Scrub Work Data at Book Level [Selected Books]  [Immediate]', 'images/quarantineicon.png',
                              triggered=partial(self.scrub_selected_book_level))
        m.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        self.m2 = QMenu(_('[Menu] Q&&S Scrub at Series Level'))
        self.m2_action = m.addMenu(self.m2)
        self.m2.setIcon(get_icon('images/quarantineicon.png'))
        self.m2.setTearOffEnabled(True)
        self.m2.setWindowTitle('Quarantine And Scrub: Scrub at Series Level')
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Rename Fiction Work Series Names Using Existing Historical Web Series Names [All]', 'images/rename.png',
                              triggered=partial(self.start_miscellany_option_5_standalone))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, ' ', ' ',
                              triggered=None)
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Consolidate Work Series at Series Level [All Books]  [What-If Only]', 'images/consolidate.png',
                              triggered=partial(self.scrub_begin_dialog_series_level_whatif))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Consolidate Work Series at Series Level [All Books]  [Actual]', 'images/consolidate.png',
                              triggered=partial(self.scrub_begin_dialog_series_level))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, ' ', ' ',
                              triggered=None)
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Validate Work Series/Titles/Indexes Via Web Source [Fiction Series of Selected Books]', 'images/download.png',
                              triggered=partial(self.start_miscellany_option_4_standalone))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, ' ', ' ',
                              triggered=None)
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Rename Work Series Name to Web Series Name [Previously Validated Fiction Series Only]', 'images/rename.png',
                              triggered=partial(self.start_miscellany_option_5_standalone))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, ' ', ' ',
                              triggered=None)
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Download Web Series/Titles/Indexes from Web Source for All Fiction Series for a Single Real Author [Selected Real Author]', 'images/download.png',
                              triggered=partial(self.start_miscellany_option_14_standalone))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, ' ', ' ',
                              triggered=None)
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Add a Specific Work Series Name && Index [Selected Books]', 'images/plus.png',
                              triggered=partial(self.work_series_add_dialog))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, ' ', ' ',
                              triggered=None)
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Change a Specific Work Series Index [Single Book]', 'images/change.png',
                              triggered=partial(self.work_series_index_change_dialog))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, ' ', ' ',
                              triggered=None)
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Search && Replace Specific Work Series Name [Selected Books]', 'images/search_and_replace.png',
                              triggered=partial(self.work_series_replace_dialog))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, ' ', ' ',
                              triggered=None)
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Search && Destroy Specific Work Series Name [Selected Books]', 'images/minus.png',
                              triggered=partial(self.work_series_destroy_dialog))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, ' ', ' ',
                              triggered=None)
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, 'Swap Work Title and Work Series  (Must Have Both)  [Selected Books]', 'images/swap.png',
                              triggered=partial(self.swap_work_title_and_work_series))
        self.m2.addSeparator()
        create_menu_action_unique(self, self.m2, ' ', ' ',
                              triggered=None)
        self.m2.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        self.m0 = QMenu(_('[Menu] Q&&S Scrub Work Tags Using Power Tools'))
        self.m0_action = m.addMenu(self.m0)
        self.m0.setIcon(get_icon('images/quarantineicon.png'))
        self.m0.setTearOffEnabled(True)
        self.m0.setWindowTitle('Quarantine And Scrub: Scrub Work Tags Using Power Tools')
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, 'Propagate Tags from/to Books with the Identical Series', 'images/propagate.png',
                              triggered=partial(self.start_miscellany_option_1_standalone))
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, ' ', ' ',
                              triggered=None)
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, "Change Selected Work Tags to Default Tag of 'Real' Author [Selected Books]", 'images/change.png',
                              triggered=partial(self.start_miscellany_option_11_standalone))
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, ' ', ' ',
                              triggered=None)
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, 'Book Level Tag Scrubber [Selected Books]', 'images/quarantineicon.png',
                              triggered=partial(self.start_miscellany_option_3_standalone))
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, ' ', ' ',
                              triggered=None)
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, 'Minimize Work Tags Per Book Using Tag Priorities [Selected Books]', 'images/minimize.png',
                              triggered=partial(self.start_miscellany_option_9_standalone))
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, ' ', ' ',
                              triggered=None)
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, 'Add a Single Work Tag [Selected Books]', 'images/plus.png',
                              triggered=partial(self.work_tag_add_dialog))
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, ' ', ' ',
                              triggered=None)
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, 'Search && Replace Specific Work Tag [Selected Books]', 'images/search_and_replace.png',
                              triggered=partial(self.work_tag_replace_dialog))
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, ' ', ' ',
                              triggered=None)
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, 'Search && Destroy Specific Work Tag [Selected Books]', 'images/minus.png',
                              triggered=partial(self.work_tag_destroy_dialog))
        self.m0.addSeparator()
        create_menu_action_unique(self, self.m0, ' ', ' ',
                              triggered=None)
        self.m0.addSeparator()
        m.addSeparator()
        self.m6 = QMenu(_('[Menu] Q&&S Tag Rules Tables Maintenance'))
        self.m6_action = m.addMenu(self.m6)
        self.m6.setIcon(get_icon('images/tag_rules_menu.png'))
        self.m6.setTearOffEnabled(True)
        self.m6.setWindowTitle('Quarantine And Scrub: Tag Rules Tables Maintenance')
        self.m6.addSeparator()
        create_menu_action_unique(self, self.m6, 'Auto-Populate Tags-by-Comment Table Using Tag Rules and Comments', 'images/tags.png',
                              triggered=partial(self.autopopulate_tags_by_comment))
        self.m6.addSeparator()
        create_menu_action_unique(self, self.m6, ' ', ' ',
                              triggered=None)
        self.m6.addSeparator()
        create_menu_action_unique(self, self.m6, "Tag Scrubber: 'Easy-Add' New 'Real' Tags to Purge to Tag Rules Table", 'images/tags.png',
                              triggered=partial(self.start_miscellany_option_6_standalone))
        self.m6.addSeparator()
        create_menu_action_unique(self, self.m6, ' ', ' ',
                              triggered=None)
        self.m6.addSeparator()
        create_menu_action_unique(self, self.m6, "Tag Scrubber: 'Easy-Add' Work Tags-to-NEWTAG Mappings to Tag Rules Table", 'images/tags.png',
                              triggered=partial(self.start_miscellany_option_7_standalone))
        self.m6.addSeparator()
        create_menu_action_unique(self, self.m6, ' ', ' ',
                              triggered=None)
        self.m6.addSeparator()
        create_menu_action_unique(self, self.m6, "Change Default Tag of 'Real' Author to Selected Work Tag [Selected Books]", 'images/change.png',
                              triggered=partial(self.start_miscellany_option_12_standalone))
        self.m6.addSeparator()
        create_menu_action_unique(self, self.m6, ' ', ' ',
                              triggered=None)
        self.m6.addSeparator()
        m.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        self.m7 = QMenu(_('[Menu] Q&S Special Tools'))
        self.m7_action = m.addMenu(self.m7)
        self.m7.setIcon(get_icon('images/wrench-hammer.png'))
        self.m7.setTearOffEnabled(True)
        self.m7.setWindowTitle('Quarantine And Scrub: Special Tools')
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, 'Change Work Author (Green Only) [Single Book Only] [Spot Cleaning]', 'images/change.png',
                              triggered=partial(self.work_author_change_dialog))
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, ' ', ' ',
                              triggered=None)
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, 'Change Work Title [Single Book Only] [Spot Cleaning]', 'images/change.png',
                              triggered=partial(self.work_title_change_dialog))
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, ' ', ' ',
                              triggered=None)
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, 'Update Pseudonym Custom Column Using Real Authors [Selected Books]', 'images/update_cc.png',
                              triggered=partial(self.start_miscellany_option_16_standalone))
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, ' ', ' ',
                              triggered=None)
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, 'Update Custom Column(s) per Table "Tags CC Mapping Control" [Selected Books]', 'images/update_cc.png',
                              triggered=partial(self.start_miscellany_option_15_standalone))
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, ' ', ' ',
                              triggered=None)
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, 'Delete Non-ISBN/ISSN/OCLC Identifiers [Selected Books]', 'images/minus.png',
                              triggered=partial(self.start_miscellany_option_2_standalone))
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, ' ', ' ',
                              triggered=None)
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, 'Copy Tag && Title && Other Rules plus WSSVD From/To Previously Configured Q&&S Libraries', 'images/copy_circle.png',
                              triggered=partial(self.start_miscellany_option_10_standalone))
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, ' ', ' ',
                              triggered=None)
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, 'Pristine Library: Reset Last-Modified Date to (Now - 24 hours) [All Books Modified in Last 24 Hours]', 'images/spraybottleicon.png',
                              triggered=partial(self.start_miscellany_option_8_standalone))
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, ' ', ' ',
                              triggered=None)
        self.m7.addSeparator()
        create_menu_action_unique(self, self.m7, ' ', ' ',
                              triggered=None)
        self.m7.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        self.m1 = QMenu(_('[Menu] Q&&S Copy Work to Real'))
        self.m1_action = m.addMenu(self.m1)
        self.m1.setIcon(get_icon('images/good.png'))
        self.m1.setTearOffEnabled(True)
        self.m1.setWindowTitle('Quarantine And Scrub: Copy Work to Real')
        self.m1.addSeparator()
        create_menu_action_unique(self, self.m1, 'Copy WorkAuthor to Author                     [Selected Books]', 'images/good.png',
                              triggered=partial(self.copy_work_author_to_author))
        self.m1.addSeparator()
        create_menu_action_unique(self, self.m1, 'Copy WorkTitle to Title                              [Selected Books]', 'images/good.png',
                              triggered=partial(self.copy_work_title_to_title))
        self.m1.addSeparator()
        create_menu_action_unique(self, self.m1, 'Copy WorkSeries to Series                         [Selected Books]', 'images/good.png',
                              triggered=partial(self.copy_work_series_to_series))
        self.m1.addSeparator()
        create_menu_action_unique(self, self.m1, 'Copy WorkSeries Index to Series Index    [Selected Books]', 'images/good.png',
                              triggered=partial(self.copy_work_series_number_to_series_index))
        self.m1.addSeparator()
        create_menu_action_unique(self, self.m1, 'Copy WorkTags to Tags                             [Selected Books]', 'images/good.png',
                              triggered=partial(self.copy_work_tags_to_tags))
        self.m1.addSeparator()
        create_menu_action_unique(self, self.m1, ' ', ' ',
                              triggered=None)
        self.m1.addSeparator()
        create_menu_action_unique(self, self.m1, 'Copy All Work to Real Metadata              [Single Book Only]', 'images/good.png',
                              triggered=partial(self.copy_all_work_to_all_real))
        self.m1.addSeparator()
        create_menu_action_unique(self, self.m1, ' ', ' ',
                              triggered=None)
        self.m1.addSeparator()
        create_menu_action_unique(self, self.m1, 'Copy Valid Q&&S Real Authors to Q&&S Pristine Author Validation Table [Selected Books]', 'images/good.png',
                              triggered=partial(self.copy_real_author_to_pristine_author_table))
        self.m1.addSeparator()
        create_menu_action_unique(self, self.m1, ' ', ' ',
                              triggered=None)
        self.m1.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        create_menu_action_unique(self, m, 'Derive Genres [Q&&S] [Selected Books]', 'images/genre.png',
                              triggered=partial(self.scrub_begin_dialog_derive_genres))
        m.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        create_menu_action_unique(self, m, 'Classify: DDC && LCC  [Selected Books]', 'images/ddclccicon.png',
                              triggered=partial(self.populate_ddc_lcc_using_classify_api))
        m.addSeparator()
        create_menu_action_unique(self, m, ' ', ' ',
                              triggered=None)
        m.addSeparator()
        self.gui.keyboard.finalize()
        qs_stylesheet = "QToolTip { color: #ffffff; background-color: #2a82da; border: 1px solid white; }"  # the '#' in the stylesheet will cause sed.exe in the .bat to strip what follows it during the build...
        m.setStyleSheet(qs_stylesheet)
        m.setToolTip("<p style='white-space:wrap'>The menu items in the Q&S Main Menu are meant to be generally used in a 'top-to-bottom' sequence. \
                                                                                <br><br>[1] Purge All Work Data [Routine Use].\
                                                                                <br><br>[2] Copy Real Data to Work Data [Routine Use].\
                                                                                <br><br>[3] Scrub Work Data at Author-Level.\
                                                                                <br><br>[4] Scrub Work Data at Book-Level.\
                                                                                <br><br>[5] Scrub Work Data at Series-Level.\
                                                                                <br><br>[6] Perform Spot-Cleaning as Desired.\
                                                                                <br><br>[7] Copy Work Data to Real Data.\
                                                                                <br><br>[8] Purge All Work Data [Routine Use].\
                                                                                <br><br>[9] Derive Genres.\
                                                                                <br><br>[10] Derive Library Codes.\
                                                                                <br><br>[11] Move your Cleaned Books from Q&S to your 'Real' Calibre Pristine Library.\
                                                                                <br><br>Refer to the User Guide for details and examples.\
                                                                                <br><br><b>Use Q&S in small batches of ~150 or fewer Books.</b>")
        self.m0.setStyleSheet(qs_stylesheet)
        self.m0.setToolTip("<p style='white-space:wrap'>This submenu is used to scrub Work Tags using power tools.")
        self.m1.setStyleSheet(qs_stylesheet)
        self.m1.setToolTip("<p style='white-space:wrap'>This submenu is used to copy Work Data to Real Data.  Copy all, some, or none for all, some, or no Books.  Pick and choose as you wish.")
        self.m2.setStyleSheet(qs_stylesheet)
        self.m2.setToolTip("<p style='white-space:wrap'>This submenu is used to scrub Work Data at the Series-Level.")
        self.m3.setStyleSheet(qs_stylesheet)
        self.m3.setToolTip("<p style='white-space:wrap'>This submenu is used to copy Real Data to Work Data.")
        self.m4.setStyleSheet(qs_stylesheet)
        self.m4.setToolTip("<p style='white-space:wrap'>This submenu is used to Purge Work Data.")
        self.m5.setStyleSheet(qs_stylesheet)
        self.m5.setToolTip("<p style='white-space:wrap'>This submenu is used to copy Pristine Authors and Pristine Series into Q&S for use as validation data.")
        self.m6.setStyleSheet(qs_stylesheet)
        self.m6.setToolTip("<p style='white-space:wrap'>This submenu is used to maintain the Tag Rules Tables.")
        self.m7.setStyleSheet(qs_stylesheet)
        self.m7.setToolTip("<p style='white-space:wrap'>This submenu is used to perform spot-cleaning and other specialized functions.")
    def scrub_begin_dialog_author_level(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            self.gui.library_view.model().stop_metadata_backup()
            book_ids_list = []   #not used at author level; no need to select any books
            self.question_then_go_author_level(book_ids_list)
    def scrub_begin_dialog_book_level(self):
        global book_ids_list
        global work_book_ids_list
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
            n = len(book_ids_list)
            if n == 0:
                return error_dialog(self.gui, _('Cannot Scrub Metadata'),
                                                          _('You must select one or more books to perform this action.'), show=True)
            else:
                work_book_ids_list = deepcopy(book_ids_list)
                self.question_then_go_book_level()
    def question_then_go_book_level(self):
        global scrubbed_books_final_list
        global book_ids_list
        scrubbed_books_final_list = [] #not used at this time
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
            book_ids_list[:] = []
            payload = book_ids
            n = len(book_ids)
            if not n == 0:
                if question_dialog(self.gui, "QuarantineAndScrub", (as_unicode(n) + "  Book(s) Have Been Selected for Book-Level Scrubbing \
                                                                        <br><br><font color='#0404B4'>[Author-Level Must Always Be Run Prior to Initial Book-Level] \
                                                                        <br><br>[Author-Level Must Never Be Run After a Previous Author-Level Without First Refreshing All Work Data]</font>\
                                                                        <br><br>GUI Will Be Locked While Job Runs <br><br>Continue with Book-Level? ")):
                    start_threaded_book_level(self, self.gui, book_ids, scrubbed_books_final_list, self.plugin_path, Dispatcher(self.scrub_book_level_no_restart))  #<<<<<== in jobs.py
                    self.create_ui_toast_dialog_for_jobs()
                else:
                     info_dialog(self.gui, 'Canceled',
                         'QuarantineAndScrub is Canceled').show()
        if self.my_jobs_dialog_object:
            if self.my_jobs_dialog_object != None:
                try:
                    self.my_jobs_dialog_object.show()
                except:
                    pass
    def question_then_go_author_level(self, book_ids_list):
        global scrubbed_books_final_list
        scrubbed_books_final_list = [] #not used at this time
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
            del book_ids_list
            if question_dialog(self.gui, "QuarantineAndScrub", ("  Author-Level Scrubbing Is for All Books\
                                                    <br><br>[Author-Level Must Be Run Prior to Initial Book-Level]\
                                                    <br><br><font color='#0404B4'><b>[Never Rerun This Job Once It Has Already Been Run Without First Purging All Work Data] \
                                                    <br><br><font color='#FF0000'>[No Book Statuses of 'auth_ok' Should Exist At This Moment Or Job Will Terminate Immediately]</b> </font>\
                                                    <br><br>GUI Will Be Locked While Job Runs <br><br>Continue?")):
                start_threaded_author_level(self, self.gui, book_ids, scrubbed_books_final_list, Dispatcher(self.scrub_author_level_no_restart))  #<<<<<== in jobs.py
                self.create_ui_toast_dialog_for_jobs()
            else:
                 info_dialog(self.gui, 'Canceled',
                     'Author-Level Scrubbing is Canceled').show()
        if self.my_jobs_dialog_object:
            if self.my_jobs_dialog_object != None:
                try:
                    self.my_jobs_dialog_object.show()
                except:
                    pass
    def scrub_begin_dialog_series_level(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            book_ids_list = []   #not used at series level; no need to select any books
            self.question_then_go_series_level("1")
    def question_then_go_series_level(self, run_type):
        global scrubbed_books_final_list
        scrubbed_books_final_list = [] #not used at this time
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        if run_type == "0":
            s_msg = "Series-Level Consolidation/Renaming:  What-if Only.  No Updates."
        else:
            s_msg = "Series-Level Consolidation/Renaming:  Actual Updates"
        self.series_choices_dialog = SeriesConsolChoicesDialog(self.gui,self.qaction.icon(),self.guidb,run_type,s_msg,self.question_then_go_series_level_part2)
        self.series_choices_dialog.show()
    def question_then_go_series_level_part2(self,chosen_option,run_type):
        global scrubbed_books_final_list
        scrubbed_books_final_list = [] #not used at this time
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            my_dummy = []
            payload = my_dummy  #payload required even if not used
            series_source_priority_1 = "Pristine,Global,Work"
            series_source_priority_2 = "Global,Work"
            series_source_priority_3 = "Work"
            series_source_priority = as_unicode(series_source_priority_3)      #default
            if chosen_option == "W":
                series_source_priority = as_unicode(series_source_priority_3)
            if chosen_option == "GW":
                series_source_priority = as_unicode(series_source_priority_2)
            if chosen_option == "PGW":
                series_source_priority = as_unicode(series_source_priority_1)
            start_threaded_series_level(self, self.gui, series_source_priority, run_type, Dispatcher(self.scrub_series_level_no_restart))  #<<<<<== in jobs.py
            self.series_choices_dialog.close()
            self.create_ui_toast_dialog_for_jobs()
            if self.my_jobs_dialog_object:
                if self.my_jobs_dialog_object != None:
                    try:
                        self.my_jobs_dialog_object.show()
                    except:
                        pass
    def scrub_begin_dialog_series_level_whatif(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            self.question_then_go_series_level("0")
    def start_miscellany_option_1_standalone(self):
        global selected_book_list
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        miscellany_option = "1"
        run_type = "X"
        s_option = "Propagate Tags from/to Books With The Identical Series"
        selected_book_list = []
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if n == 0:
            return
        else:
            selected_book_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        if question_dialog(self.gui, "QuarantineAndScrub", ("  <big>Miscellaneous Scrubbing <br><br>GUI Will Be Locked While Job Runs </big>\
                                                                    <br><br><big><font color='#0404B4'><B>" + s_option + "  </B></font></big>\
                                                                    <br><br><big>Continue? <font color='#800000'><B> To Cancel: Click NO </B></font></big> ") ):
            start_threaded_miscellany(self, self.gui, miscellany_option, run_type, selected_book_list, Dispatcher(self.generic_finish_with_refresh))  #<<<<<== in jobs.py
            self.create_ui_toast_dialog_for_jobs()
            if self.my_jobs_dialog_object:
                if self.my_jobs_dialog_object != None:
                    try:
                        self.my_jobs_dialog_object.show()
                    except:
                        pass
        else:
            pass
    def start_miscellany_option_2_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.delete_all_identifiers_except_isbn()
    def start_miscellany_option_3_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        global selected_book_list
        miscellany_option = "3"
        run_type = "X"
        s_option = "Book Level Tag Scrubber [Selected Books]"
        selected_book_list = []
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if n == 0:
            return
        else:
            selected_book_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        if question_dialog(self.gui, "QuarantineAndScrub", ("  <big>Miscellaneous Scrubbing <br><br>GUI Will Be Locked While Job Runs </big>\
                                                                    <br><br><big><font color='#0404B4'><B>" + s_option + "  </B></font></big>\
                                                                    <br><br><big>Continue? <font color='#800000'><B> To Cancel: Click NO </B></font></big> ") ):
            start_threaded_miscellany(self, self.gui, miscellany_option, run_type, selected_book_list, Dispatcher(self.generic_finish_with_refresh))  #<<<<<== in jobs.py
            self.create_ui_toast_dialog_for_jobs()
            if self.my_jobs_dialog_object:
                if self.my_jobs_dialog_object != None:
                    try:
                        self.my_jobs_dialog_object.show()
                    except:
                        pass
    def start_miscellany_option_4_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        global selected_book_list
        miscellany_option = "4"
        run_type = "0"
        s_option = "Validate Work Series Book Titles & Indexes[Selected Fiction Series]"
        selected_book_list = []
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if n == 0:
            return
        else:
            selected_book_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        if question_dialog(self.gui, "QuarantineAndScrub", ("  <big>Miscellaneous Scrubbing <br><br>GUI Will Be Locked While Job Runs </big>\
                                                                    <br><br><big><font color='#0404B4'><B>" + s_option + "  </B></font></big>\
                                                                    <br><br><big>Continue? <font color='#800000'><B> To Cancel: Click NO </B></font></big> ") ):
            start_threaded_miscellany(self, self.gui, miscellany_option, run_type, selected_book_list, Dispatcher(self.generic_finish_with_refresh))  #<<<<<== in jobs.py
            self.create_ui_toast_dialog_for_jobs()
            if self.my_jobs_dialog_object:
                if self.my_jobs_dialog_object != None:
                    try:
                        self.my_jobs_dialog_object.show()
                    except:
                        pass
    def start_miscellany_option_5_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        global selected_book_list
        miscellany_option = "5"
        run_type = "1"
        s_option = "Rename Work Series Name to Web Series Name <br>[Previously Verified Fiction Series Only]<br><font color='#FF0000'>[This Job Actually Performs Updates]"
        selected_book_list = []   #dummy; not used by this option.
        if question_dialog(self.gui, "QuarantineAndScrub", ("  <big>Miscellaneous Scrubbing <br><br>GUI Will Be Locked While Job Runs </big>\
                                                                    <br><br><big><font color='#0404B4'><B>" + s_option + "  </B></font></big>\
                                                                    <br><br><big>Continue? <font color='#800000'><B> To Cancel: Click NO </B></font></big> ") ):
            start_threaded_miscellany(self, self.gui, miscellany_option, run_type, selected_book_list, Dispatcher(self.generic_finish_with_refresh))  #<<<<<== in jobs.py
            self.create_ui_toast_dialog_for_jobs()
            if self.my_jobs_dialog_object:
                if self.my_jobs_dialog_object != None:
                    try:
                        self.my_jobs_dialog_object.show()
                    except:
                        pass
    def start_miscellany_option_6_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.tagruleseditor_dialog(self.actually_insert_tag_rules_rows)
    def start_miscellany_option_7_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.tagruleseditor_2_dialog(self.actually_insert_tag_rules_rows)
    def start_miscellany_option_8_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.reset_last_modified_date()
    def start_miscellany_option_9_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        global selected_book_list
        miscellany_option = "9"
        run_type = "1"
        s_option = "Minimize Work Tags Using Tag Priorities [Selected Books]"
        selected_book_list = []
        self.guidb = self.gui.library_view.model().db
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if n == 0:
            return
        else:
            selected_book_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        if question_dialog(self.gui, "QuarantineAndScrub", ("  <big>Miscellaneous Scrubbing <br><br>GUI Will Be Locked While Job Runs </big>\
                                                                    <br><br><big><font color='#0404B4'><B>" + s_option + "  </B></font></big>\
                                                                    <br><br><big>Continue? <font color='#800000'><B> To Cancel: Click NO </B></font></big> ") ):
            start_threaded_miscellany(self, self.gui, miscellany_option, run_type, selected_book_list, Dispatcher(self.generic_finish_with_refresh))  #<<<<<== in jobs.py
            self.create_ui_toast_dialog_for_jobs()
            if self.my_jobs_dialog_object:
                if self.my_jobs_dialog_object != None:
                    try:
                        self.my_jobs_dialog_object.show()
                    except:
                        pass
    def start_miscellany_option_10_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        global selected_book_list
        miscellany_option = "10"
        run_type = "1"
        s_option = "Copy Tag & Title Rules From/To Previously Configured Q&S Libraries"
        selected_book_list = []
        if question_dialog(self.gui, "QuarantineAndScrub", ("  <big>Miscellaneous Scrubbing <br><br>GUI Will Be Locked While Job Runs </big>\
                                                                    <br><br><big><font color='#0404B4'><B>" + s_option + "  </B></font></big>\
                                                                    <br><br><big>Continue? <font color='#800000'><B> To Cancel: Click NO </B></font></big> ") ):
            start_threaded_miscellany(self, self.gui, miscellany_option, run_type, selected_book_list, Dispatcher(self.generic_finish_with_refresh))  #<<<<<== in jobs.py
            self.create_ui_toast_dialog_for_jobs()
            if self.my_jobs_dialog_object:
                if self.my_jobs_dialog_object != None:
                    try:
                        self.my_jobs_dialog_object.show()
                    except:
                        pass
    def start_miscellany_option_11_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.default_work_tags_by_author()
    def start_miscellany_option_12_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.reset_default_work_tag_by_author()
    def start_miscellany_option_13_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.autopopulate_tags_by_comment()
    def start_miscellany_option_14_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        miscellany_option = "14"
        run_type = "1"
        s_option = "Download Work Series/Titles/Indexes from Web Source for All Series for a Single Author [Single Author Only]"
        selected_book_list = []
        self.guidb = self.gui.library_view.model().db
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if  n != 1:
            return
        else:
            selected_book_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        start_threaded_miscellany(self, self.gui, miscellany_option, run_type, selected_book_list, Dispatcher(self.generic_finish_with_refresh))  #<<<<<== in jobs.py
        self.create_ui_toast_dialog_for_jobs()
        if self.my_jobs_dialog_object:
            if self.my_jobs_dialog_object != None:
                try:
                    self.my_jobs_dialog_object.show()
                except:
                    pass
    def start_miscellany_option_15_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        miscellany_option = "15"
        run_type = "1"
        s_option = 'Copy Work Tags to Custom Columns(s) Per Table "Tags CC Mapping Control" [Selected Books]'
        selected_book_list = []
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if  n == 0:
            return
        else:
            selected_book_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        start_threaded_miscellany(self, self.gui, miscellany_option, run_type, selected_book_list, Dispatcher(self.generic_finish_with_refresh))  #<<<<<== in jobs.py
        self.create_ui_toast_dialog_for_jobs()
        if self.my_jobs_dialog_object:
            if self.my_jobs_dialog_object != None:
                try:
                    self.my_jobs_dialog_object.show()
                except:
                    pass
    def start_miscellany_option_16_standalone(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        miscellany_option = "16"
        run_type = "1"
        s_option = 'Update Pseudonym Custom Column [Selected Books]'
        selected_book_list = []
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if  n == 0:
            return
        else:
            selected_book_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        start_threaded_miscellany(self, self.gui, miscellany_option, run_type, selected_book_list, Dispatcher(self.generic_finish_with_refresh))  #<<<<<== in jobs.py
        self.create_ui_toast_dialog_for_jobs()
        if self.my_jobs_dialog_object:
            if self.my_jobs_dialog_object != None:
                try:
                    self.my_jobs_dialog_object.show()
                except:
                    pass
    def tagruleseditor_dialog(self,actually_insert_tag_rules_rows):
        tags_list_of_lists = self.get_all_tags()
        tagruleslisteditor_dialog = TagRulesListEditor(self.gui, 'Quarantine And Scrub:  Tag Rules for Tag Scrubbing', 'None',\
                                                                                    tags_list_of_lists, None, self.actually_insert_tag_rules_rows,self.guidb)
        tagruleslisteditor_dialog.show()
    def tagruleseditor_2_dialog(self,actually_insert_tag_rules_rows):
        tags_list_of_lists = self.get_all_tags_2()
        tagruleslisteditor_2_dialog = TagRulesListEditor2(self.gui, 'Quarantine And Scrub:  Tag Rules for Tag Scrubbing', 'None',\
                                                                                    tags_list_of_lists, None, self.actually_insert_tag_rules_rows_2,self.guidb)
        tagruleslisteditor_2_dialog.show()
    def finish_displaying_results(self,payload):
        books_updated = payload
        self.gui.library_view.model().refresh_ids(list(books_updated))
        self.gui.tags_view.recount()
        marked_ids = {}
        for line in books_updated:
            marked_ids[line] = 'metadata_scrubbed'
        self.gui.current_db.set_marked_ids(marked_ids)
        self.gui.search.set_search_string('marked:metadata_scrubbed')
        self.gui.status_bar.show_message(_('Metadata Was Scrubbed'), 5000)
    def copy_selected_work_level_begin_dialogs_with_user(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            copy_selected_work_level()
    def copy_work_level_begin_dialogs_with_user(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            if question_dialog(self.gui, "Copy Real Book Metadata to Work Columns","\
                                                            <br><br>GUI Will Be Locked While Job Runs \
                                                           <br><br>This Is For All Books. <br><br> Continue?"):
                start_threaded_util_copy_original_metadata(self, self.guidb, Dispatcher(self.copy_real_to_work_no_restart))  #<<<<<== in jobs.py
                self.create_ui_toast_dialog_for_jobs()
                if self.my_jobs_dialog_object:
                    if self.my_jobs_dialog_object != None:
                        try:
                            self.my_jobs_dialog_object.show()
                        except:
                            pass
            else:
                 info_dialog(self.gui, 'Canceled',
                     'Copy is Canceled').show()
    def copy_selected_tags_only_begin_dialogs_with_user(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            self.copy_selected_tags_only()
    def copy_selected_series_only_begin_dialogs_with_user(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            self.copy_selected_series_only()
    def purge_work_data_begin_dialogs_with_user(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            if question_dialog(self.gui, "Purge All Work Data","\
                                                            <br><br>GUI Will Be Locked While Job Runs \
                                                           <br><br>This Is For All Books. <br><br> Continue?"):
                start_threaded_purge_work_data(self, self.guidb, Dispatcher(self.purge_work_data_no_restart))  #<<<<<== in jobs.py
                self.create_ui_toast_dialog_for_jobs()
                if self.my_jobs_dialog_object:
                    if self.my_jobs_dialog_object != None:
                        try:
                            self.my_jobs_dialog_object.show()
                        except:
                            pass
            else:
                 info_dialog(self.gui, 'Canceled', 'Purge is Canceled').show()
    def create_sqlite_objects_begin_dialogs_with_user(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            if question_dialog(self.gui, "Create New SQLite Objects After Plugin Upgrade","\
                                                            <br><br>GUI Will Be Locked While Job Runs \
                                                           <br><br> Continue?"):
                start_threaded_create_sqlite_objects(self, self.guidb, Dispatcher(self.create_sqlite_objects_no_restart))  #<<<<<== in jobs.py
                self.create_ui_toast_dialog_for_jobs()
                if self.my_jobs_dialog_object:
                    if self.my_jobs_dialog_object != None:
                        try:
                            self.my_jobs_dialog_object.show()
                        except:
                            pass
            else:
                 info_dialog(self.gui, 'Canceled', 'Creation of SQLite Objects is Canceled').show()
    def copy_pristine_level_begin_dialogs_with_user(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            if question_dialog(self.gui, "Copy Calibre Pristine Data to Q+S Work Database?","<br> This Is For All Authors/Series. <br><br> Continue?"):
                start_threaded_util_copy_pristine_metadata(self, self.guidb, Dispatcher(self.copy_pristine_no_restart))  #<<<<<== in jobs.py
                self.create_ui_toast_dialog_for_jobs()
            if self.my_jobs_dialog_object:
                if self.my_jobs_dialog_object != None:
                    try:
                        self.my_jobs_dialog_object.show()
                    except:
                        pass
            else:
                 info_dialog(self.gui, 'Canceled',
                     'Copy is Canceled').show()
    def generic_finish_with_refresh(self, job):
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Q+S Job Failed...'))
        db = self.gui.current_db.new_api                           #see:  http://manual.calibre-ebook.com/db_api.html
        work_book_ids_frozenset = db.all_book_ids()
        books_to_refresh = []
        for row in work_book_ids_frozenset:      #ALL books in the database will be refreshed!  This is the only safe way to avoid a total restart.
            books_to_refresh.append(row)
        del work_book_ids_frozenset
        self.gui.status_bar.show_message(_('Q+S Job Finished'), 5000)
        self.force_refresh_of_cache(books_to_refresh)
    def copy_real_to_work_no_restart(self, job):
        global work_book_ids_list #created from a deepcopy of payload
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Failed to Copy Work Data...'))
        db = self.gui.current_db.new_api                           #see:  http://manual.calibre-ebook.com/db_api.html
        work_book_ids_frozenset = db.all_book_ids()
        books_to_refresh = []
        for row in work_book_ids_frozenset:      #ALL books in the database will be refreshed!  This is the only safe way to avoid a total restart.
            books_to_refresh.append(row)
        n = len(books_to_refresh)
        try:
            self.gui.status_bar.show_message(_('Copying of Calibre Real Metadata to the Work Q+S Database Has Completed'), 5000)
            info_dialog(self.gui, 'Job Successful','Copying of Calibre Real Metadata to the Work Q+S Database Has Completed.\
                                            <br><br> A Calibre Restart Is Recommended If Any DB Locking Issues Are Experienced.').show()
            self.force_refresh_of_cache(books_to_refresh)
        except:
            self.gui.quit(restart=True)
    def purge_work_data_no_restart(self, job):
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Failed to Purge Work Data...'))
        db = self.gui.current_db.new_api                           #see:  http://manual.calibre-ebook.com/db_api.html
        work_book_ids_frozenset = db.all_book_ids()
        books_to_refresh = []
        for row in work_book_ids_frozenset:      #ALL books in the database will be refreshed!  This is the only safe way to avoid a total restart.
            books_to_refresh.append(row)
        del work_book_ids_frozenset
        try:
            self.gui.status_bar.show_message(_('Purging All Work Data Has Completed'), 5000)
            self.force_refresh_of_cache(books_to_refresh)
        except:
            self.gui.quit(restart=True)
    def create_sqlite_objects_no_restart(self, job):
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Failed to Create SQLite Objects...'))
            return
        else:
            self.gui.status_bar.show_message(_('Creation of SQLite Objects Has Completed'), 15000)
    def copy_pristine_no_restart(self, job):
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Failed to Copy Pristine Data...'))
            return
        else:
            pass
        self.gui.status_bar.show_message(_('Copying of Calibre Pristine Author/Series Data to the Work Q+S Database Has Completed'), 5000)
        info_dialog(self.gui, 'Job Successful','Copying of Calibre Pristine Author/Series Data to the Q+S Database Has Completed').show()
    def scrub_book_level_no_restart(self, job):
        global book_ids_list
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Failed to Scrub at Book Level...'))
        self.gui.status_bar.show_message(_('Scrubbing at the Book Level Has Completed'), 5000)
        self.force_refresh_of_cache(book_ids_list)
    def scrub_author_level_no_restart(self, job):
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Failed to Scrub at Author Level...'))
        db = self.gui.current_db.new_api                           #see:  http://manual.calibre-ebook.com/db_api.html
        work_book_ids_frozenset = db.all_book_ids()
        books_to_refresh = []
        for row in work_book_ids_frozenset:      #ALL books in the database will be refreshed!  This is the only safe way to avoid a total restart.
            books_to_refresh.append(row)
        self.gui.status_bar.show_message(_('Scrubbing at the Author Level Has Completed'), 5000)
        self.force_refresh_of_cache(books_to_refresh)
    def scrub_series_level_no_restart(self, job):
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Failed to Scrub at Series Level...'))
        db = self.gui.current_db.new_api                           #see:  http://manual.calibre-ebook.com/db_api.html
        work_book_ids_frozenset = db.all_book_ids()
        books_to_refresh = []
        for row in work_book_ids_frozenset:      #ALL books in the database will be refreshed!  This is the only safe way to avoid a total restart.
            books_to_refresh.append(row)
        self.gui.status_bar.show_message(_('Scrubbing at the Series Level Has Completed'), 5000)
        self.force_refresh_of_cache( books_to_refresh)
    def convert_id_to_book(self, idval):
        book = {}
        book['calibre_id'] = idval
        return book
    def manually_restart(self):
        self.gui.quit(restart=True)
    def swap_work_title_and_work_series(self):
        global work_book_ids_list
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(work_book_ids_list)
        if n == 0:
            return error_dialog(self.gui, _('Cannot Swap Work Title and Work Series Metadata'),
                                                      _('You must select one or more books to perform this action.'), show=True)
        self.create_ui_toast_dialog(1)
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        work_dict_title = self.get_work_titles(book_ids)
        work_dict_series = self.get_work_series(book_ids)
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_book_list = []  #for refreshing bcc13link etc.
        for book in book_ids:
            my_book_list.append(book)  #for refreshing bccxxlink etc.
            try:
                old_title = work_dict_title[book]
                old_series = work_dict_series[book]
            except:
                continue
            if not old_title or not old_series:
                continue
            try:
                my_cursor.execute("begin")
                mysql = 'DELETE FROM custom_column_8 WHERE id = ? '
                my_cursor.execute(mysql,([book]))
                mysql = 'DELETE FROM books_custom_column_8_link WHERE book =  ? '
                my_cursor.execute(mysql,([book]))
                mysql = 'DELETE FROM custom_column_10 WHERE id = ? '
                my_cursor.execute(mysql,([book]))
                mysql = 'DELETE FROM books_custom_column_10_link WHERE book =  ? '
                my_cursor.execute(mysql,([book]))
                my_cursor.execute("commit")
                sleep(.05)
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE into custom_column_8 (id,value) VALUES (?,?) "
                my_cursor.execute(mysql,(book,old_series))
                my_cursor.execute("commit")
                sleep(.05)
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE into custom_column_10 (id,value) VALUES (?,?) "
                my_cursor.execute(mysql,(book,old_title))
                my_cursor.execute("commit")
                sleep(.05)
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE into books_custom_column_8_link (id,book,value) VALUES (?,?,?) "
                my_cursor.execute(mysql,(book,book,book))
                mysql = "INSERT OR REPLACE into books_custom_column_10_link (id,book,value) VALUES (?,?,?) "
                my_cursor.execute(mysql,(book,book,book))
                my_cursor.execute("commit")
                sleep(.05)
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE INTO custom_column_15 (id,book,value) SELECT book,book,seriesfull FROM __series_work_full WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                my_cursor.execute("commit")
                sleep(.05)
                my_cursor.execute("begin")
                mysql =  "UPDATE custom_column_15 SET value=REPLACE(value,'.0','') WHERE book = ?  ; "
                my_cursor.execute(mysql,([book]))
                my_cursor.execute("commit")
                sleep(.05)
                my_cursor.execute("begin")
                mysql =  "UPDATE custom_column_15 SET value=REPLACE(value,'.5]','.50]') WHERE book = ? ; "
                my_cursor.execute(mysql,([book]))
                my_cursor.execute("commit")
                sleep(.05)
            except Exception as e:
                pass
        del book_ids
        sleep(0.1)
        my_db.close()
        self.ui_toast_dialog.close()
        self.force_refresh_of_cache(my_book_list)
        del my_book_list
    def copy_work_author_to_author(self, s_callback):
        global work_book_ids_list
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        if not s_callback == mynothing:           #re: copy all work to all real
            try:
                if not isinstance(work_book_ids_list,list):
                    work_book_ids_list = []
                else:
                    pass
            except:
                work_book_ids_list = []
            work_book_ids_list[:] = []
        try:
            n = len(work_book_ids_list)  #if called from copy_all_work_to_real...
        except:
            work_book_ids_list = []
            n = 0
        if not n > 0:
            work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
            n = len(work_book_ids_list)
            if n == 0:
                return
        payload = work_book_ids_list
        work_dict_auth = self.get_work_authors(work_book_ids_list)
        id_map = {}
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            mi = Metadata(_('Unknown'))  #only set the fields you want changed; rest are null and will be ignored
            authors = work_dict_auth[book] #currently, work_author is only the first author found by the scrub
            if not authors:
                continue
            s = as_unicode(authors)
            auth_list = []
            auth_list.append(authors)
            mi.authors = auth_list            #'authors',          # Ordered list. Must never be None, can be [_('Unknown')]
            id_map[book] = mi
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        if s_callback == mynothing:                #re: copy all work to all real
            edit_metadata_action.apply_metadata_changes(id_map, callback=self.finish_displaying_copy_work_to_real_results)
            work_book_ids_list[:] = []  #empties it only
        else:
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)
    def copy_work_title_to_title(self, s_callback):
        global work_book_ids_list
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        if not  s_callback == mynothing:
            work_book_ids_list = []
            work_book_ids_list[:] = []
        try:
            n = len(work_book_ids_list)
        except:
            work_book_ids_list = []
            work_book_ids_list[:] = []
            n = 0
        if not n > 0:
            work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
            n = len(work_book_ids_list)
            if n == 0:
                return error_dialog(self.gui, _('Cannot Copy Work Title to Real Title Metadata'),
                                                          _('You must select one or more books to perform this action.'), show=True)
        work_dict_title = {}
        del work_dict_title
        payload = work_book_ids_list     # list of dicts of book ids
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        work_dict_title = self.get_work_titles(book_ids)
        id_map = {}
        for book in book_ids:
            mi = Metadata(_('Unknown'))
            title = work_dict_title[book]
            if not title:
                continue
            if title == "?":
                continue
            mi.title = title
            id_map[book] = mi
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        if s_callback == mynothing:          #re:  copy_all_work_to_all_real
            edit_metadata_action.apply_metadata_changes(id_map, callback=self.finish_displaying_copy_work_to_real_results)
            work_book_ids_list[:] = []           #empties it only
        else:
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)
    def copy_work_series_to_series(self, s_callback):
        global work_book_ids_list
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        if not  s_callback == mynothing:           #re: copy all work to all real
            work_book_ids_list = []
            work_book_ids_list[:] = []
        try:
            n = len(work_book_ids_list)  #if called from copy_all_work_to_real...
        except:
            work_book_ids_list = []
            n = 0
        if not n > 0:
            work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
            n = len(work_book_ids_list)
            if n == 0:
                return
                return error_dialog(self.gui, _('Cannot Copy Work Title to Real Title Metadata'),
                                                          _('You must select one or more books to perform this action.'), show=True)
        payload = work_book_ids_list
        work_dict_series = self.get_work_series(work_book_ids_list)
        id_map = {}
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            mi = Metadata(_('Unknown'))
            try:
                series = work_dict_series[book]
                if not series:
                    continue
            except:
                continue
            mi.series = series
            id_map[book] = mi
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        if s_callback == mynothing:
            edit_metadata_action.apply_metadata_changes(id_map, callback=self.finish_displaying_copy_work_to_real_results)
            work_book_ids_list[:] = []  #empties it only
        else:
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)
    def copy_work_series_number_to_series_index(self, s_callback):
        global work_book_ids_list
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        db = self.gui.current_db.new_api
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        if not  s_callback == mynothing:           #re: copy all work to all real
            work_book_ids_list = []
            work_book_ids_list[:] = []
        try:
            n = len(work_book_ids_list)  #if called from copy_all_work_to_real...
        except:
            work_book_ids_list = []
            n = 0
        if not n > 0:
            work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
            n = len(work_book_ids_list)
            if n == 0:
                return
                return error_dialog(self.gui, _('Cannot Copy WorkSeries Number to Real Series Index Metadata'),
                                                          _('You must select one or more books to perform this action.'), show=True)
        payload = work_book_ids_list
        work_dict_series_index = self.get_work_series_number(work_book_ids_list)
        id_map = {}
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            mi = Metadata(_('Unknown'))  #only set the fields you want changed; rest are null and will be ignored
            series_index = as_unicode(work_dict_series_index[book])
            if not series_index:
                continue
            try:
                series_index = qs_standardize_any_string(series_index)
                series_index = float(series_index)
            except:
                continue
            old_series = db.field_for('series', book, default_value=None)
            if not old_series or old_series == mynothing:
                continue
            mi.series = old_series
            mi.series_index = series_index
            id_map[book] = mi
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        if s_callback == mynothing:
            edit_metadata_action.apply_metadata_changes(id_map, callback=self.finish_displaying_copy_work_to_real_results)
            work_book_ids_list[:] = []
        else:
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)
    def copy_work_tags_to_tags(self, s_callback):
        global work_book_ids_list
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        if not  s_callback == mynothing:           #re: copy all work to all real
            work_book_ids_list = []
            work_book_ids_list[:] = []
        try:
            n = len(work_book_ids_list)  #if called from copy_all_work_to_real...
        except:
            work_book_ids_list = []
            n = 0
        if not n > 0:
            work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
            n = len(work_book_ids_list)
            if n == 0:
                return
        payload = work_book_ids_list
        work_dict_tags = self.get_work_tags(work_book_ids_list)
        id_map = {}
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            mi = Metadata(_('Unknown'))  #only set the fields you want changed; rest are null and will be ignored
            tags = work_dict_tags[book]     # must remain utf8...
            if not tags:
                tags = " "
            if tags == "None" or tags == "NONE" or tags == "none":
                tags = " "
            mi.tags = tags
            id_map[book] = mi
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        if s_callback == mynothing:
            edit_metadata_action.apply_metadata_changes(id_map, callback=self.finish_displaying_copy_work_to_real_results, merge_tags=False)
            try:
                work_book_ids_list[:] = []  #empties it only
            except:
                work_book_ids_list = []
        else:
            try:
                del work_book_ids_list
            except:
                pass
            edit_metadata_action.apply_metadata_changes(id_map, callback=None, merge_tags=False)
    def copy_all_work_to_all_real(self):
        global work_book_ids_list
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        work_book_ids_list = []
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        else:
            work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
            work_book_ids_list_save = deepcopy(work_book_ids_list)
            n = len(work_book_ids_list)
            if n == 0:
                return
            if  n > 1:
                return error_dialog(self.gui, _('More Than One (1) Book Selected'),_('You must select only one (1) book to perform this action.'), show=True)
            else:
                pass
        s_callback = mynothing
        self.copy_work_author_to_author(s_callback)
        work_book_ids_list = deepcopy(work_book_ids_list_save)
        s_callback = mynothing
        self.copy_work_title_to_title(s_callback)
        work_book_ids_list = deepcopy(work_book_ids_list_save)
        s_callback = mynothing
        self.copy_work_series_to_series(s_callback)
        work_book_ids_list = deepcopy(work_book_ids_list_save)
        s_callback = mynothing
        self.copy_work_series_number_to_series_index(s_callback)
        work_book_ids_list = deepcopy(work_book_ids_list_save)
        s_callback = mynothing
        self.copy_work_tags_to_tags(s_callback)
        work_book_ids_list = deepcopy(work_book_ids_list_save)
        try:
            if isinstance(work_book_ids_list[0],dict):  #the list is comprised of row dicts:  {u'calibre_id': 2595}
                payload = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
            else:
                payload = work_book_ids_list     #the list is comprised of row dicts:  {u'calibre_id': 2595}
            self.finish_displaying_copy_work_to_real_results(payload)
        except Exception as e:
            msg = "Error in copying All Work to Real: " + as_unicode(e)
            return error_dialog(self.gui, _('Copy All Work to Real'),_(msg), show=True)
    def finish_displaying_copy_work_to_real_results(self, payload):
        work_book_ids_list = payload
        self.gui.library_view.model().refresh_ids(list(work_book_ids_list))
        self.gui.tags_view.recount()
    def view_user_instructions(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        self.extract_documentation_from_zip() #every time to ensure latest copy is available after plugin upgrade
        try:
            p_pid = subprocess.Popen(self.documentation_path, shell=True)
        except:
            return error_dialog(self.gui, _('Documentation .pdf Not Found. Try reinstalling this plugin, and restarting Calibre.'),
                                       _('It is supposed to be: ' + self.documentation_path), show=True)
    def extract_documentation_from_zip(self):
        zipfile_path = self.plugin_path
        destination_path = self.plugin_path
        destination_path = destination_path.replace("\QuarantineAndScrub.zip", "")
        destination_path = destination_path.replace("/QuarantineAndScrub.zip", "")
        zfile = zipfile.ZipFile(zipfile_path)
        dir_name = "quarantine_documentation"
        file_name = 'quarantine_instructions.pdf'
        file_name = os.path.join(dir_name, file_name )
        documentation_path = None
        for name in zfile.namelist(): #all files in zip with full internal paths
            n = name.find(dir_name)
            if n >= 0:
                zfile.extract(name, destination_path)
                documentation_path = os.path.join(destination_path, file_name)
        self.documentation_path = documentation_path
    def config(self):
        self.library_is_quarantine_db = False
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        base_plugin_object = self.interface_action_base_plugin
        do_user_config = base_plugin_object.do_user_config
        d = ConfigDialog(self.gui, self.qaction.icon(), do_user_config)
        d.close()
    def apply_settings(self):
        prefs
    def get_work_authors(self, book_list):
        db = self.gui.current_db.new_api    #see:  http://manual.calibre-ebook.com/db_api.html
        work_dict_auth = {}
        name = "#work_author"
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_list)
        for book in book_ids:
            work_author = db.field_for(name, book, default_value=None)
            if not work_author:
                continue
            if not isinstance(work_author,unicode_type):
                work_author = as_unicode(work_author)
            work_dict_auth[book] = work_author
        del book_list
        del book_ids
        return work_dict_auth
    def get_work_titles(self, book_list):
        db = self.gui.current_db.new_api
        work_dict_title = {}
        name = "#work_title"
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_list)
        for book in book_ids:
            work_title = db.field_for(name, book, default_value=None)
            if (not work_title):
                work_title = "?"
            if work_title == "":
                work_title = "?"
            if not isinstance(work_title,unicode_type):
                work_title = as_unicode(work_title)
            work_dict_title[book] = work_title
        del book_list
        del book_ids
        return work_dict_title
    def get_work_series(self, book_list):
        db = self.gui.current_db.new_api    #see:  http://manual.calibre-ebook.com/db_api.html
        work_dict_series = {}
        name = "#work_series"
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_list)
        for book in book_ids:
            work_series = db.field_for(name, book, default_value=None)
            if not work_series:
                continue
            if not isinstance(work_series,unicode_type):
                work_series = as_unicode(work_series)
            work_dict_series[book] = work_series
        del book_list
        del book_ids
        return work_dict_series
    def get_work_series_number(self, book_list):
        mynothing = ""
        db = self.gui.current_db.new_api    #see:  http://manual.calibre-ebook.com/db_api.html
        work_dict_series_index = {}
        name = "#work_series_number"
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_list)
        for book in book_ids:
            work_series_number = as_unicode(db.field_for(name, book, default_value=None))
            if not work_series_number:
                continue
            if not isinstance(work_series_number,unicode_type):
                work_series_number = as_unicode(work_series_number)
            work_dict_series_index[book] = work_series_number
        del book_list
        del book_ids
        return work_dict_series_index
    def get_work_tags(self, book_list):
        mynothing = ""
        db = self.gui.current_db.new_api    #see:  http://manual.calibre-ebook.com/db_api.html
        work_dict_tags = {}
        name = "#work_tags"
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_list)
        for book in book_ids:
            work_tags= as_unicode(db.field_for(name, book, default_value="None"))
            if not work_tags:
                continue
            work_tags = work_tags.replace(",", ", ", 50) #make it look just like the normal tags column...
            if not isinstance(work_tags,unicode_type):
                work_tags = as_unicode(work_tags)
            work_dict_tags[book] = work_tags
        del book_list
        del book_ids
        return work_dict_tags
    def copy_selected_tags_only(self):
        global work_book_ids_list
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(work_book_ids_list)
        if n == 0:
            return error_dialog(self.gui, _('Cannot Copy Selected Real Tags to Work Tags'),
                                                      _('You must select books to perform this action.'), show=True)
        db = self.gui.current_db.new_api    #see:  http://manual.calibre-ebook.com/db_api.html
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_book_list = []  #for refreshing bcc13link etc.
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            my_book_list.append(book)
            try:
                my_cursor.execute("begin")
                mysql = "DELETE FROM custom_column_13 WHERE id = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_13_link WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "'DELETE FROM _book_awards_mapping WHERE book = ?"
                my_cursor.execute(mysql,([book]))
                my_cursor.execute("commit")
                sleep(.5)
            except Exception as e:
                pass
        try:  #delete any orphan rows
            my_cursor.execute("begin")
            mysql = "DELETE FROM books_custom_column_13_link WHERE value NOT IN (SELECT id FROM custom_column_13 WHERE id > '0')"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.5)
            my_cursor.execute("begin")
            mysql = "DELETE FROM custom_column_13 WHERE id NOT IN (SELECT value FROM books_custom_column_13_link WHERE value > '0')"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.5)
            my_cursor.execute("begin")
            mysql = "DELETE FROM _book_awards_mapping WHERE book NOT IN (SELECT id FROM custom_column_13 WHERE id > '0')"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.5)
        except Exception as e:
            pass
        sleep(1.0)
        my_db.close()
        self.force_refresh_of_cache(my_book_list)
        real_dict_tags = {}
        name_tags = "tags"
        name = name_tags
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            tags = db.field_for(name, book, default_value=None)
            if not tags:
                continue
            s = ""
            for item in tags:
                s = s + item + ","
            s = s.strip()
            s = s[0:-1] #remove ending comma
            s = s.replace(",", ", ") #make it look just like the gui tag column...
            tags = s
            if not isinstance(tags,unicode_type):
                tags = as_unicode(tags)
            real_dict_tags[book] = tags
        custom_columns = self.gui.current_db.field_metadata.custom_field_metadata()
        id_map = {}
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            mi = Metadata(_('Unknown'))
            try:  #avoid dict key errors if no data for book
                custcol6 = custom_columns["#work_tags"]
                custcol6['#value#'] = real_dict_tags[book]
                mi.set_user_metadata('#work_tags', custcol6)
            except:  #blank it out
                custcol6 = custom_columns["#work_tags"]
                custcol6['#value#'] = ""
                mi.set_user_metadata('#work_tags', custcol6)
            id_map[book] = mi
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)
        del my_book_list
        del book_ids
        del real_dict_tags
        work_book_ids_list[:] = []
    def copy_selected_series_only(self):
        global work_book_ids_list
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(work_book_ids_list)
        if  n == 0:
            return error_dialog(self.gui, _('Cannot Copy Selected Real Series to Work Series'),
                                                      _('You must select books to perform this action.'), show=True)
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        real_dict_series = {}
        real_dict_series_index = {}
        name_series = "series"
        name_series_index = "series_index"
        my_book_list = []  #for refreshing bcc10link etc.
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            my_book_list.append(book)
            try:
                my_cursor.execute("begin")
                mysql = "DELETE FROM custom_column_10 WHERE id = ? "   #since we make the id == book for some cc tables
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_10_link WHERE id = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM custom_column_12  WHERE id = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM custom_column_15  WHERE id = ? "
                my_cursor.execute(mysql,([book]))
                my_cursor.execute("commit")
                sleep(.5)
            except Exception as e:
                pass
        try:  #delete any orphan rows
            my_cursor.execute("begin")
            mysql = "DELETE FROM books_custom_column_10_link WHERE value NOT IN (SELECT id FROM custom_column_10 WHERE id > '0')"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.5)
            my_cursor.execute("begin")
            mysql = "DELETE FROM custom_column_10 WHERE id NOT IN (SELECT value FROM books_custom_column_10_link WHERE value > '0')"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.5)
        except Exception as e:
            pass
        sleep(0.5)
        my_db.close()
        self.force_refresh_of_cache(my_book_list)
        name = name_series
        db = self.gui.current_db.new_api    #see:  http://manual.calibre-ebook.com/db_api.html
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            series = db.field_for(name, book, default_value=None)
            if not series:
                continue
            if not isinstance(series,unicode_type):
                series = as_unicode(series)
            real_dict_series[book] = series
        name = name_series_index
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            series_index = db.field_for(name, book, default_value=None)
            if not series_index:
                continue
            series_index = as_unicode(series_index)
            series_index = series_index.replace(".0", "")
            series_index = series_index.replace(".50", ".5")
            real_dict_series_index[book] = series_index
        custom_columns = self.gui.current_db.field_metadata.custom_field_metadata()
        id_map = {}
        for book in book_ids:
            mi = Metadata(_('Unknown'))
            try:  #avoid dict key errors if no data for book
                custcol3 = custom_columns["#work_series"]
                custcol3['#value#'] = real_dict_series[book]
                mi.set_user_metadata('#work_series', custcol3)
            except:   #blank it out
                custcol3 = custom_columns["#work_series"]
                custcol3['#value#'] = ""
                mi.set_user_metadata('#work_series', custcol3)
            try:  #avoid dict key errors if no data for book
                custcol4 = custom_columns["#work_series_number"]
                s = real_dict_series_index[book]
                s = qs_standardize_any_string(s)
                try:
                    n = float(s)
                except:
                    try:
                        n = int(s)
                    except:
                        n = 0
                custcol4['#value#'] = n
                mi.set_user_metadata('#work_series_number', custcol4)
            except:  #blank it out
                custcol4 = custom_columns["#work_series_number"]
                custcol4['#value#'] = ""
                mi.set_user_metadata('#work_series_number', custcol4)
            try:    #avoid dict key errors if no data for book
                custcol5 = custom_columns["#work_series_full"]
                w_series = real_dict_series[book]
                w_seriesindex = real_dict_series_index[book]
                s = as_unicode(n)
                w_seriesfull = w_series + " [" + s + "]"
                w_seriesfull = w_seriesfull.replace(".0", "")
                w_seriesfull = w_seriesfull.replace(".50", ".5")
                custcol5['#value#'] = w_seriesfull
                mi.set_user_metadata('#work_series_full', custcol5)
            except:  #blank it out
                custcol5 = custom_columns["#work_series_full"]
                custcol5['#value#'] = ""
                mi.set_user_metadata('#work_series_full', custcol5)
            id_map[book] = mi
        del real_dict_series
        del real_dict_series_index
        work_book_ids_list[:] = []
        payload = my_book_list   #payload is always required for a non-null callback
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=self.explode_custom_column_10_if_needed)
    def copy_selected_work_level(self):
        global work_book_ids_list
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            return
        self.create_ui_toast_dialog(1)
        work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(work_book_ids_list)
        if  n == 0 or n > 100:
            return error_dialog(self.gui, _('Cannot Copy Selected Real to Work Metadata'),
                                                      _('You may select up to 100 books (only) to perform this action.'), show=True)
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        real_dict_authors = {}
        real_dict_title = {}
        real_dict_series = {}
        real_dict_series_index = {}
        real_dict_tags = {}
        name_auth = "authors"
        name_title = "title"
        name_series = "series"
        name_series_index = "series_index"
        name_tags = "tags"
        my_book_list = []  #for refreshing bcc4link etc.
        name = name_auth
        db = self.gui.current_db.new_api
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            my_book_list.append(book)
            try:
                my_cursor.execute("begin")
                mysql = "DELETE FROM custom_column_4  WHERE id = ? "   #since we make the id == book for some cc tables
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_4_link WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM custom_column_8  WHERE id = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_8_link  WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM custom_column_10 WHERE id = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_10_link  WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM custom_column_12  WHERE id = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM custom_column_13  WHERE id = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_13_link  WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM custom_column_15  WHERE id = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_17_link  WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_18_link  WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM _book_awards_mapping WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                my_cursor.execute("commit")
                sleep(.5)
            except Exception as e:
                pass
            authors = db.field_for(name, book, default_value=None)    #multiple authors.....must use the first with the lowest id......
            if not authors:
                continue
            author_is_bad = False
            for item in authors:
                if any(char.isdigit() for char in item):
                    author_is_bad = True
                if ":" in item or "{" in item:
                    author_is_bad = True
            if author_is_bad:
                author = " "
                for item in authors:
                    author = author + " & " + item
                author = author.strip()
                if author.startswith("&"):
                    author = author[1: ]
                author = author.strip()
            else:
                for item in authors:
                    author = item
                    break             #use only the very first one
            if not isinstance(author,unicode_type):
                author = as_unicode(author)
            real_dict_authors[book] = author
        try:  #delete any orphan rows
            my_cursor.execute("begin")
            mysql = "DELETE FROM custom_column_4 WHERE value = null "   #apparently ui.py edit_metadata via copy single real to work does this all on its own
            my_cursor.execute(mysql)
            mysql = "DELETE FROM books_custom_column_4_link WHERE value NOT IN (SELECT id FROM custom_column_4 WHERE id > '0')"
            my_cursor.execute(mysql)
            mysql = "DELETE FROM books_custom_column_8_link WHERE value NOT IN (SELECT id FROM custom_column_8 WHERE id > '0')"
            my_cursor.execute(mysql)
            mysql = "DELETE FROM books_custom_column_10_link WHERE value NOT IN (SELECT id FROM custom_column_10 WHERE id > '0')"
            my_cursor.execute(mysql)
            mysql = "DELETE FROM books_custom_column_13_link WHERE value NOT IN (SELECT id FROM custom_column_13 WHERE id > '0')"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.5)
            my_cursor.execute("begin")
            mysql = "DELETE FROM custom_column_4 WHERE id NOT IN (SELECT value FROM books_custom_column_4_link WHERE value > '0')"
            my_cursor.execute(mysql)
            mysql = "DELETE FROM custom_column_8 WHERE id NOT IN (SELECT value FROM books_custom_column_8_link WHERE value > '0')"
            my_cursor.execute(mysql)
            mysql = "DELETE FROM custom_column_10 WHERE id NOT IN (SELECT value FROM books_custom_column_10_link WHERE value > '0')"
            my_cursor.execute(mysql)
            mysql = "DELETE FROM custom_column_13 WHERE id NOT IN (SELECT value FROM books_custom_column_13_link WHERE value > '0')"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.5)
        except Exception as e:
            pass
        sleep(1.0)
        my_db.close()
        self.force_refresh_of_cache(my_book_list)
        name = name_title
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            title = db.field_for(name, book, default_value=None)
            if not title:
                continue
            real_dict_title[book] = title
        name = name_series
        for book in book_ids:
            series = db.field_for(name, book, default_value=None)
            if not series:
                continue
            if not isinstance(series,unicode_type):
                series = as_unicode(series)
            real_dict_series[book] = series
        name = name_series_index
        for book in book_ids:
            series_index = db.field_for(name, book, default_value=None)
            if not series_index:
                continue
            if not isinstance(series_index,unicode_type):
                 series_index = as_unicode(series_index)
            series_index = series_index.replace(".0", "")
            series_index = series_index.replace(".50", ".5")
            real_dict_series_index[book] = series_index
        name = name_tags
        for book in book_ids:
            tags = db.field_for(name, book, default_value=None)
            if not tags:
                continue
            s = ""
            for item in tags:
                s = s + item + ","
            s = s.strip()
            s = s[0:-1] #remove ending comma
            s = s.replace(",", ", ") #make it look just like the gui tag column...
            tags = s
            real_dict_tags[book] = tags
        name_auth = "authors"
        name_title = "title"
        name_series = "series"
        name_series_index = "series_index"
        name_tags = "tags"
        custom_columns = self.gui.current_db.field_metadata.custom_field_metadata()
        id_map = {}
        for book in book_ids:
            mi = Metadata(_('Unknown'))
            try:  #avoid dict key errors if no data for book
                custcol1 = custom_columns["#work_author"]
                custcol1['#value#'] = real_dict_authors[book]
                mi.set_user_metadata('#work_author', custcol1)
            except:  #should never happen
                pass
            try:  #avoid dict key errors if no data for book
                custcol2 = custom_columns["#work_title"]
                custcol2['#value#'] = real_dict_title[book]
                mi.set_user_metadata('#work_title', custcol2)
            except: #should never happen
                pass
            try:  #avoid dict key errors if no data for book
                custcol3 = custom_columns["#work_series"]
                custcol3['#value#'] = real_dict_series[book]
                mi.set_user_metadata('#work_series', custcol3)
            except:  #blank it out
                custcol3 = custom_columns["#work_series"]
                custcol3['#value#'] = ""
                mi.set_user_metadata('#work_series', custcol3)
            try:  #avoid dict key errors if no data for book
                custcol4 = custom_columns["#work_series_number"]
                s = real_dict_series_index[book]
                s = qs_standardize_any_string(s)
                try:
                    n = float(s)
                except:
                    try:
                        n = int(s)
                    except:
                        n = 0
                custcol4['#value#'] = n
                mi.set_user_metadata('#work_series_number', custcol4)
            except:  #blank it out
                custcol4 = custom_columns["#work_series_number"]
                custcol4['#value#'] = ""
                mi.set_user_metadata('#work_series_number', custcol4)
            try:  #avoid dict key errors if no data for book
                custcol5 = custom_columns["#work_series_full"]
                w_series = real_dict_series[book]
                w_seriesindex = real_dict_series_index[book]
                s = as_unicode(n)
                w_seriesfull = w_series + " [" + s + "]"
                w_seriesfull = w_seriesfull.replace(".0", "", 1)
                w_seriesfull = w_seriesfull.replace(".50", ".5", 1)
                custcol5['#value#'] = w_seriesfull
                mi.set_user_metadata('#work_series_full', custcol5)
            except:  #blank it out
                custcol5 = custom_columns["#work_series_full"]
                custcol5['#value#'] = ""
                mi.set_user_metadata('#work_series_full', custcol5)
            try:  #avoid dict key errors if no data for book
                custcol6 = custom_columns["#work_tags"]
                custcol6['#value#'] = real_dict_tags[book]
                mi.set_user_metadata('#work_tags', custcol6)
            except:  #blank it out
                custcol6 = custom_columns["#work_tags"]
                custcol6['#value#'] = ""
                mi.set_user_metadata('#work_tags', custcol6)
            custcol7 = custom_columns["#work_freeze"]
            custcol7['#value#'] = "0"
            mi.set_user_metadata('#work_freeze', custcol7)
            custcol8 = custom_columns["#status"]
            custcol8['#value#'] = "dirty"
            mi.set_user_metadata('#status', custcol8)
            id_map[book] = mi
        del real_dict_authors
        del real_dict_title
        del real_dict_series
        del real_dict_series_index
        del real_dict_tags
        work_book_ids_list[:] = []
        payload = my_book_list   #payload is always required for a non-null callback
        try:
            self.ui_toast_dialog.close()
        except:
            pass
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=self.explode_custom_column_4_if_needed)
        try:
            self.ui_toast_dialog.close()
        except:
            pass
    def scrub_selected_book_level(self):
        global work_book_ids_list
        global scrubbed_books_final_list
        work_book_ids_list = []
        scrubbed_books_final_list = []
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
            n = len(book_ids_list0)
            if n == 0:
                return error_dialog(self.gui, _('Cannot Scrub Metadata'),
                                                          _('You must select one or more books to perform this action.'), show=True)
            else:
                book_ids_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
                del book_ids_list0
                n = len(book_ids_list)
                if n == 0:
                    return error_dialog(self.gui, _('Cannot Scrub Metadata'),
                                                          _('You must select one or more books to perform this action.'), show=True)
                else:
                    start_threaded_book_level(self, self.gui, book_ids_list, scrubbed_books_final_list, self.plugin_path, Dispatcher(self.scrub_selected_book_level_foreground))  #<<<<<== in jobs.py
                    self.create_ui_toast_dialog_for_jobs()
        if self.my_jobs_dialog_object:
            if self.my_jobs_dialog_object != None:
                try:
                    self.my_jobs_dialog_object.show()
                except:
                    pass
    def scrub_selected_book_level_foreground(self, job):
        global work_book_ids_list
        global scrubbed_books_final_list
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Failed to Scrub Selected Books in Foreground/GUI'))
        scrubbed_books_final_list = job.result
        if not scrubbed_books_final_list:
            scrubbed_books_final_list = []
        books_to_refresh = []
        for row in scrubbed_books_final_list: #sequence is a *dict* for each of:  book, authname, booktitle, seriesname, seriesindex, seriesfull, tagsall
            work_dict_book, authname, booktitle, seriesname, seriesindex, seriesfull,tagsall = row
            book = work_dict_book['calibre_id']
            books_to_refresh.append(book)
        self.force_refresh_of_cache(books_to_refresh) #due to issues with changing a field in the gui to match what the table already says, this will be done instead.
        del books_to_refresh
        del job
    def finish_displaying_foreground_scrub(self, payload):
        global work_book_ids_list
        books_to_refresh = payload
        self.gui.library_view.model().refresh_ids(list(books_to_refresh))   #class EditMetadataAction in src>calibre>gui2>actions>edit_metadata.py
        self.gui.tags_view.recount()
        work_book_ids_list = []
        marked_ids = {}
        for line in books_to_refresh:
            marked_ids[line] = 'book_scrubbed'
        self.gui.current_db.set_marked_ids(marked_ids)
        self.gui.search.set_search_string('marked:book_scrubbed')
        del payload
        del books_to_refresh
        del marked_ids
    def force_refresh_of_cache(self, books_to_refresh):
        if len(books_to_refresh) == 0:
            return
        backend = self.gui.library_view.model().db.backend
        mydbcache = dbcache(self.gui.library_view.model().db.backend)
        mydbcache.init()  #refreshes the cache from the physical metadata.db.  refer to:   \src\calibre\db\cache.py
        self.gui.library_view.model().refresh_ids(list(books_to_refresh))  #refreshes the gui from the cache
        self.gui.tags_view.recount()  #refreshes the tag browser
    def purge_pristine_tables(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        if question_dialog(self.gui, "QuarantineAndScrub","Purge The Pristine Authors/Series Tables in Q&S? [Advisable if Not Really Pristine]"):
            pass
        else:
            return
        self.create_ui_toast_dialog(1)
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;  (obviously just for this connection)
        my_cursor.execute(mysql)
        my_cursor.execute("begin")
        mysql = "DELETE FROM _pristine_authors WHERE id NOT NULL"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.02)
        my_cursor.execute("begin")
        mysql = "DELETE FROM _pristine_author_series_link WHERE id NOT NULL"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.02)
        my_cursor.execute("begin")
        mysql = "DELETE FROM _pristine_series WHERE id NOT NULL"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.02)
        self.ui_toast_dialog.close()
    def copy_real_author_to_pristine_author_table(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        mynothing = ""
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if n == 0:
            return
        else:
            book_ids_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_cursor.execute("begin")
        for book in book_ids_list:  #the list of simple integers for each selected book
            try:
                mysql = "SELECT name,'dummy' FROM __book_author_name_sort WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                tmp_auth_rows = my_cursor.fetchall()
                if tmp_auth_rows:
                    for row in tmp_auth_rows:
                        name,dummy = row
                        s_string = qs_standardize_any_string(name)
                        s_author = s_string.replace("|", ",")
                        n1 = s_author.count(",")
                        if n1 == 0:
                            s_list = s_author.split(" ")
                            s_lastname = s_list[1]
                            s_firstname = s_list[0]
                            s_sort = s_lastname + ", " + s_firstname
                        else:
                            s_sort = s_author
                            s_list = s_author.split(",")
                            s_lastname = s_list[0]
                            s_firstname = s_list[1]
                            s_author = s_firstname + " " + s_lastname
                        s_author = s_author.strip()
                        s_sort =s_sort.strip()
                        break
                else:
                    continue
                del tmp_auth_rows
                n1 = s_author.count("-")
                n2 = s_author.count(":")
                if n1 == 0 and n2 == 0:
                    mysql = "INSERT OR IGNORE INTO _pristine_authors (id,name,sort) VALUES (null, '" + s_author + "','" + s_sort + "') ;"
                    my_cursor.execute(mysql)
                else:
                    pass
            except Exception as e:
                pass
        my_cursor.execute("commit")
        sleep(0.02)
        my_db.close()
        del book_ids_list
        info_dialog(self.gui, _('Copy Selected Real Author to Pristine Author Table'), _('The Selected Real Authors Were Copied to the Pristine Author Table'), show=True)
    def delete_all_identifiers_except_isbn(self):
        self.create_ui_toast_dialog(1)
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if n == 0:
            return
        else:
            book_ids_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_cursor.execute("begin")
        for book in book_ids_list:  #the list of simple integers for each selected book
            try:
                mysql = "DELETE FROM identifiers WHERE book = ? AND (type != 'isbn') AND (type != 'oclc-owi') AND (type != 'issn');"
                my_cursor.execute(mysql,([book]))
            except Exception as e:
                pass
        try:
            my_cursor.execute("commit")
            sleep(0.5)
        except:
            pass
        my_db.close()
        self.force_refresh_of_cache(book_ids_list)
        del book_ids_list
        try:
            self.ui_toast_dialog.close()
        except:
            pass
        info_dialog(self.gui, _('Non-ISBN/ISSN/OCLC Identifiers Deleted for Selected Book(s)'),
                                        _('The Non-ISBN/ISSN/OCLC Identifiers Were Deleted for the Selected Book(s)'), show=True )
    def reset_last_modified_date(self):
        if question_dialog(self.gui, "QuarantineAndScrub", "Reset Pristine Library Books' Last Modified Date Per the 24 Hour Rule? "):
            pass
        else:
            return
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        from datetime import datetime, date, time, timedelta
        today = datetime.utcnow()     #  2014-11-18 16:57:43.298000
        h = -24                                    #                -24
        t = timedelta(hours=h)           #                  -1 day, 0:00:00
        yesterday = as_unicode(today + t)       #   2014-11-17 16:57:43.298000
        yesterday = as_unicode(yesterday + "+00:00")
        pristine_path = prefs['pristine_library']
        try:
            s1 = "ATTACH DATABASE '"
            s2 =  "'  As 'Calibre';"
            mysql = s1 + pristine_path + s2
            if isbytestring(mysql):
                mysql = mysql.decode(filesystem_encoding)
            my_cursor.execute(mysql)
        except Exception as e:
            s = as_unicode(e)
            my_db.close()
            return
        try:
            my_cursor.execute("begin")
            mysql = "DROP TRIGGER IF EXISTS Calibre.books_update_trg"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.02)
            my_cursor.execute("begin")
            mysql = "UPDATE Calibre.books SET last_modified = ? WHERE last_modified >= ? "
            my_cursor.execute(mysql, (yesterday, yesterday))
            my_cursor.execute("commit")
            sleep(0.02)
        except:
            pass
        try:
            my_cursor.execute("begin")
            mysql = "CREATE TRIGGER IF NOT EXISTS Calibre.books_update_trg AFTER UPDATE ON books \
             BEGIN UPDATE books SET sort=title_sort(NEW.title) WHERE id=NEW.id AND OLD.title != NEW.title; END "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except:
            pass
        mysql = "DETACH DATABASE 'Calibre' "
        my_cursor.execute(mysql)
        my_db.close()
        info_dialog(self.gui, _('Last Modified Date Changed in Pristine Library Per the 24 Hour Rule'),
                                        _('Last Modified Date Changed in Pristine Library Per the 24 Hour Rule'), show=True)
    def default_work_tags_by_author(self):
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if n == 0:
            return
        else:
            book_ids_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        path = self.library_db_path
        best_path = prefs['qs_library_best_rules']
        best_path = as_unicode(best_path.replace(os.sep, '/'))
        nq = best_path.count("QuarantineAndScrub")    #best path in config preferences may not be valid if there is only one(1) Q&S library...
        if as_unicode(best_path) == as_unicode(path):
            do_freshen = True
        else:
            if nq == 0:    #no Best configured, so treat the current library just like the Best would be if there were one
                do_freshen = True
            else:
                do_freshen = False
        if do_freshen:
            my_cursor.execute("begin")
            mysql = "DELETE FROM _tags_by_author "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.1)
            my_cursor.execute("begin")
            mysql = "INSERT OR REPLACE INTO _tags_by_author SELECT authname,tagname,book_count FROM __tags_by_author_with_count;   "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.1)
            my_cursor.execute("begin")
            mysql = "INSERT OR IGNORE INTO _tags_by_author_default SELECT name,tag  FROM _tags_by_author \
                                WHERE name NOT LIKE '%9%' AND name NOT LIKE '%(%' AND name NOT LIKE '%#%' AND name NOT LIKE '%*%' \
                                    AND name NOT LIKE '%0%' AND name NOT LIKE '%[%'  ;"  #first row selected will always have the highest count, so it gets inserted and the next rows if any are ignored
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.1)
            list_of_tags = []
            mysql = "SELECT name FROM tags WHERE name IN(SELECT oldtag FROM _tag_rules WHERE newtag NOT NULL AND purgetag = 0 )"
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                pass
            else:
                for item in tmp_rows:
                    for col in item:
                        tag = col
                        list_of_tags.append(tag)
                del tmp_rows
            sleep(0.1)
            my_cursor.execute("begin")
            for row in list_of_tags:
                tag = row
                if tag == None or tag == mynothing:
                    continue
                try:
                    mysql = "UPDATE  _tags_by_author_default SET tag =(SELECT newtag FROM _tag_rules WHERE  _tag_rules.oldtag = _tags_by_author_default.tag \
                                            AND  _tag_rules.newtag NOT NULL AND  _tag_rules.purgetag = 0 AND _tags_by_author_default.tag NOT NULL) WHERE tag = ? \
                                            AND tag NOT NULL"
                    my_cursor.execute(mysql,(tag,))
                except Exception as e:
                    continue
            try:
                my_cursor.execute("commit")
            except:
                pass
        else:
            pass
        my_cursor.execute("begin")
        mysql = "INSERT or REPLACE INTO custom_column_13 (id,value) SELECT book, tagsall FROM __books_work_populate WHERE tagsall not null  ; "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.1)
        my_cursor.execute("begin")
        mysql = "UPDATE books_custom_column_13_link  SET value = books_custom_column_13_link.book "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.1)
        my_cursor.execute("begin")
        mysql = "DELETE FROM custom_column_13 WHERE id NOT IN (SELECT value FROM books_custom_column_13_link)"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.1)
        n = len(book_ids_list)
        book_tag_dict = {}
        for book in book_ids_list:
            if not isinstance(book,int):
                book = int(book)
            tmp_rows = []
            try:
                mysql = "SELECT authname,'dummy' FROM __books_work_populate WHERE book = ?"
                my_cursor.execute(mysql,([book]))
                tmp_rows = my_cursor.fetchall()
                if not tmp_rows:
                    continue
                else:
                    for item in tmp_rows:
                        authname,dummy = item
                del tmp_rows
                mysql = "SELECT tag,'dummy' FROM _tags_by_author_default WHERE name = ? "
                my_cursor.execute(mysql,([authname]))
                tmp_rows = my_cursor.fetchall()
                if not tmp_rows:
                    continue
                else:
                    tag = None
                    for item in tmp_rows:
                        tag,dummy = item
                        break
                    if tag is not None:
                        book_tag_dict[book] = tag
            except Exception as e:
                continue
        if len(book_tag_dict) == 0:
            pass
        else:
            my_cursor.execute("begin")
            for book,tag in iteritems(book_tag_dict):
                mysql = "DELETE FROM custom_column_13 WHERE id IN(SELECT value FROM books_custom_column_13_link WHERE book = ? )"
                my_cursor.execute(mysql,(book,))
                mysql = "DELETE FROM books_custom_column_13_link WHERE book = ? "
                my_cursor.execute(mysql,(book,))
            try:
                my_cursor.execute("commit")
                sleep(0.1)
            except:
                pass
            my_cursor.execute("begin")
            for book,tag in iteritems(book_tag_dict):
                mysql = "INSERT OR REPLACE INTO custom_column_13 (id,value) VALUES(?,?)"
                my_cursor.execute(mysql,(book,tag))
            try:
                my_cursor.execute("commit")
                sleep(0.1)
            except:
                pass
            my_cursor.execute("begin")
            for book,tag in iteritems(book_tag_dict):
                mysql = "INSERT OR REPLACE INTO books_custom_column_13_link (id,book,value) VALUES(?,?,?)"
                my_cursor.execute(mysql,(book,book,book))
            try:
                my_cursor.execute("commit")
                sleep(0.1)
            except:
                pass
            my_cursor.execute("begin")
            mysql = "DELETE FROM custom_column_13 WHERE id NOT IN(SELECT value FROM books_custom_column_13_link)"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.1)
        my_db.close()
        self.force_refresh_of_cache(book_ids_list)
    def reset_default_work_tag_by_author(self):
        mynothing = ""
        self.guidb = self.gui.library_view.model().db
        book_ids_list0 = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list0)
        if n == 0:
            return
        else:
            book_ids_list = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list0)
            del book_ids_list0
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        n = len(book_ids_list)
        if not n > 0:
            return
        my_cursor.execute("begin")
        for book in book_ids_list:
            try:
                mysql = "SELECT authname,tagsall FROM __books_work_populate WHERE book = ? AND tagsall NOT NULL AND authname NOT NULL"
                my_cursor.execute(mysql,([book]))
                tmp_rows = my_cursor.fetchall()
                if not tmp_rows:
                    continue
                else:
                    tagsall = ""
                    for item in tmp_rows:
                        authname,tagsall = item
                    if ( "," in tagsall) or (tagsall == mynothing) or (tagsall == None) or (not tagsall > " ") :
                        continue
                    else:
                        mysql = "INSERT OR REPLACE INTO _tags_by_author_default (name,tag) VALUES (?,?)"
                        my_cursor.execute(mysql,(authname,tagsall))
            except:
                continue
        try:
            my_cursor.execute("commit")
            sleep(0.1)
        except:
            pass
        my_db.close()
    def get_all_tags(self):
        tags_list_of_lists = []
        tags = []
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO _tags_copied_from_other_libraries SELECT null, name FROM tags WHERE tags.name NOT LIKE '%978%' "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        mysql = "SELECT name FROM _tags_copied_from_other_libraries WHERE ('/'||name||'/'  NOT IN(SELECT oldtag FROM _tag_rules \
                                                WHERE oldtag NOT NULL) ) AND (name NOT IN(SELECT oldtag FROM _tag_rules \
                                                WHERE oldtag NOT NULL) ) AND (name NOT IN(SELECT newtag \
                                                FROM _tag_rules WHERE newtag NOT NULL) ) "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if tmp_rows:
            r = []
            for row in tmp_rows:
                del r
                r = []
                n_col = 0
                for col in row:   #there is only 1 column
                    s1 = col
                    r.append(s1)
                    tags.append(r)
        else:
            return tags_list_of_lists
        tagset = set(map(tuple,tags))           #need to convert the inner lists to tuples so they are hashable
        tags = list(map(list,tagset))              #Now convert tuples back into lists - with no duplicates
        tags.sort()
        for row in tags:
            tags_list_of_lists.append(row)
        n = len(tags_list_of_lists)
        return tags_list_of_lists
    def get_all_tags_2(self):
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        mysql = "SELECT tag, subject FROM __tags_work_single_subject WHERE tag NOT NULL \
                            AND tag NOT IN(SELECT oldtag FROM _tag_rules) \
                            AND tag NOT IN(SELECT oldtag FROM _tag_rules WHERE oldtag LIKE '%'||'/'||tag||'/'||'%'  ) \
                            AND tag NOT IN(SELECT oldtag FROM _tag_rules WHERE oldtag = '/'||tag||'/'   )  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        tags_list_of_lists = []
        tags = []
        if tmp_rows:
            if len(tmp_rows) == 0:
                info_dialog(self.gui, _('Nothing to Show You'),
                    _('Nothing to Show You.  Perhaps: (1) nothing needs to be done; or, (2) a Tag Scrubber job for all books (to identify tags with no rules) needs to be run.'), show=True)
                return tags_list_of_lists
            else:
                pass
            r = []
            for row in tmp_rows:
                del r
                r = []
                n_col = 0
                for col in row:
                    if (not col) or (col is None):       #Null value
                        col = "No BISAC Match"
                    if n_col == 0:
                        s1 = col
                        r.append(s1)
                        n_col = 1
                    else:
                        s2 = col
                        if s2.endswith("-*"):
                            s2 = s2[0:-2]
                        if s2.endswith("-") or s2.endswith("*"):
                            s2 = s2[0:-1]
                        r.append(s2)
                        tags.append(r)
                        break
        else:
            info_dialog(self.gui, _('Nothing to Show You'),
                _('Nothing to Show You.  Perhaps: (1) nothing needs to be done; or, (2) a Tag Scrubber job for all books (to identify tags with no rules) needs to be run.'), show=True)
            return tags_list_of_lists
        tagset = set(map(tuple,tags))   #need to convert the inner lists to tuples so they are hashable
        tags = list(map(list,tagset))              #Now convert tuples back into lists - with no duplicates
        tags.sort()
        for row in tags:
            tags_list_of_lists.append(row)
        n = len(tags_list_of_lists)
        return tags_list_of_lists
    def actually_insert_tag_rules_rows(self, list):
        mynothing = ""
        if list:
            n = len(list)
            if n == 0:
                return
        else:
            return
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_cursor.execute("begin")
        for row in list:
            s = row.split("|||")
            a = s[0]      #tag (i.e., oldtag)
            b = s[1]      #make regex (1 = True else False)
            a = a.strip()
            b = b.strip()
            if (not a > " "):
                continue
            if isinstance(a, str):
                try:
                    a = as_unicode(a, errors='ignore')
                except:
                    pass
            else:
                pass
            if as_unicode(b) == '1':     #from list editor, should create regex
                s1 = "/" + a + "/"        #case insensitive regex match
            else:
                s1 = a
            s2 = '1'   #purge tag = 1 to purge; always 1 here
            if as_unicode(a) != as_unicode(s1):
                mysql = 'INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, null, ?)   '
                my_cursor.execute(mysql,(s1,s2))
            mysql = 'INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, null, ?)   '
            my_cursor.execute(mysql,(a,s2))
        my_cursor.execute("commit")
        sleep(0.5)
        my_db.close()
    def actually_insert_tag_rules_rows_2(self, list):
        mynothing = ""
        if list:
            n_rows = len(list)
            if n_rows == 0:
                return
        else:
            return
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        for row in list:
            s = row.split("|||")
            a = s[0]      #tag (i.e., oldtag)
            b = s[1]      #subject (i.e., newtag)
            c = s[2]      #make regex (1 = True else False)
            a = a.strip()
            b = b.strip()
            if (not a > " ")  and (not b > " ") :
                continue
            if a == b:
                pass
            if isinstance(a, str):
                try:
                    a = as_unicode(a, errors='ignore')
                except:
                    pass
            else:
                pass
            if as_unicode(c) == '1':
                s1 = "/" + a + "/"        #case insensitive regex match
            else:
                s1 = a
            s2 = b
            if s2 == "No BISAC Match":
                continue
            my_cursor.execute("begin")
            if b == "DELETE" or b == "delete" or b == "" or b == '""' or b == "''":
                s2 = None
                mysql = 'INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, ?, 1 )   '
                my_cursor.execute(mysql,(s1,s2))
                if s1 != a:   #for every /oldtag/, insert a simple match rule 'oldtag' too
                    mysql = 'INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, ?, 1 )   '
                    my_cursor.execute(mysql,(a,s2))
            else:
                mysql = 'INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, ?, 0 )   '
                my_cursor.execute(mysql,(s1,s2))
                if s1 != a:   #for every /oldtag/, insert a simple match rule 'oldtag' too
                    mysql = 'INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, ?, 0 )   '
                    my_cursor.execute(mysql,(a,s2))
            my_cursor.execute("commit")
            sleep(0.2)
        sleep(0.5)
        my_cursor.execute("begin")
        mysql = "UPDATE _tag_rules SET purgetag = 1 WHERE newtag = 'delete' OR newtag = 'DELETE' "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
        my_cursor.execute("begin")
        mysql = "UPDATE _tag_rules SET newtag = NULL WHERE purgetag = 1 "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
        my_cursor.execute("begin")
        mysql = "DELETE FROM _tag_rules WHERE newtag = 'No BISAC Match' "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
        my_cursor.execute("begin")
        mysql = "INSERT or IGNORE INTO _tag_rules SELECT null,newtag,newtag,'0'  FROM _tag_rules \
                                                    WHERE newtag NOT NULL AND newtag NOT IN (SELECT oldtag FROM _tag_rules) "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
        my_db.close()
    def purge_work_data_selected_books(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(work_book_ids_list)
        if  n == 0 or n > 100:
            return error_dialog(self.gui, _('Cannot Purge Workd Data for Selected Books'),
                                                      _('You may select a maximum of 100 books to perform this action.'), show=True)
        self.create_ui_toast_dialog(1)
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        book_ids_list = []
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        my_cursor.execute("begin")
        for book in book_ids:
            book_ids_list.append(book)
            try:
                mysql = "DELETE FROM books_custom_column_4_link WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_8_link WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_10_link WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM custom_column_12 WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_13_link WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM custom_column_15 WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM custom_column_16 WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_17_link WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM books_custom_column_18_link WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM _books_work WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM _tags_work WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM _instr_title_author WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                mysql = "DELETE FROM _book_awards_mapping WHERE book = ? "
                my_cursor.execute(mysql,([book]))
            except Exception as e:
                pass
        try:
            my_cursor.execute("commit")
        except:
            pass
        sleep(0.5)
        my_cursor.execute("begin")
        mysql = "DELETE FROM custom_column_4 WHERE id NOT IN (SELECT value FROM books_custom_column_4_link WHERE value > '0')"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM custom_column_8 WHERE id NOT IN (SELECT value FROM books_custom_column_8_link WHERE value > '0')"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM custom_column_10 WHERE id NOT IN (SELECT value FROM books_custom_column_10_link WHERE value > '0')"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM custom_column_13 WHERE id NOT IN (SELECT value FROM books_custom_column_13_link WHERE value > '0')"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM custom_column_17 WHERE id NOT IN (SELECT value FROM books_custom_column_17_link WHERE value > '0')"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM custom_column_18 WHERE id NOT IN (SELECT value FROM books_custom_column_18_link WHERE value > '0')"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(1.0)
        my_db.close()
        sleep(0.1)
        self.force_refresh_of_cache(book_ids_list)
        try:
            self.ui_toast_dialog.close()
        except:
            pass
    def explode_custom_column_4_if_needed(self, payload):
        try:
            self.ui_toast_dialog.close()
        except:
            pass
        try:
            self.create_ui_toast_dialog(2)
        except:
            pass
        my_book_list = payload   #from callback=
        self.guidb = self.gui.library_view.model().db
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_book_list = qs_convert_list_of_nominal_book_ids_to_integers(my_book_list)
        for book in my_book_list:
            try:
                mysql = "SELECT value FROM  custom_column_4 WHERE id IN (SELECT value FROM books_custom_column_4_link WHERE book = ?  )"
                my_cursor.execute(mysql,([book]))
                tmp_rows = my_cursor.fetchall()
                if tmp_rows:
                    for item in tmp_rows:
                        for col in item:
                            correct_value = col
                    my_cursor.execute("begin")
                    mysql = "INSERT OR REPLACE INTO _books_work (book,booktitle,authorname,seriesname,seriesindex) VALUES (?,null,?,null,null)"         #save for later cc4 explosion in authorlevel.py
                    my_cursor.execute(mysql,(book,correct_value))       #temporarily using table _books_work to temporarily hold the correct_value for later cc4 explosion in authorlevel.py
                    my_cursor.execute("commit")
                    sleep(0.01)
                else:
                    correct_value = ""
                my_cursor.execute("begin")
                mysql = "DELETE FROM books_custom_column_4_link WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                my_cursor.execute("commit")
                sleep(0.01)
                my_cursor.execute("begin")
                mysql = "DELETE FROM custom_column_4 WHERE id NOT IN(SELECT value FROM books_custom_column_4_link)"
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.01)
                my_cursor.execute("begin")
                if correct_value == "":
                    mysql = "INSERT OR REPLACE INTO custom_column_4 SELECT book,name FROM __book_author_name_sort \
                                WHERE book = ? "
                    my_cursor.execute(mysql,([book]))
                else:
                    mysql = "INSERT OR REPLACE INTO custom_column_4 (id,value) VALUES (?,?)"
                    my_cursor.execute(mysql,(book,correct_value))
                my_cursor.execute("commit")
                sleep(0.01)
                my_cursor.execute("begin")
                mysql = "INSERT or REPLACE INTO books_custom_column_4_link SELECT book,book,book FROM __book_author_name_sort \
                                                                                                                         WHERE book = ? "
                my_cursor.execute(mysql,([book]))
                my_cursor.execute("commit")
                sleep(0.01)
            except Exception as e:
                my_db.close()
                raise e
                return
        sleep(0.05)
        my_db.close()
        self.force_refresh_of_cache(my_book_list)
        sleep(1.0)
        try:
            self.ui_toast_dialog.close()
        except:
            pass
    def explode_custom_column_10_if_needed(self, payload):
        my_book_list = payload   #from callback=
        self.guidb = self.gui.library_view.model().db
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        error_found = False
        my_book_list = [int(book) for book in my_book_list]
        for book in my_book_list:
            try:
                mysql = "SELECT count(*),NULL FROM __books_work_populate WHERE book = ? AND authname NOT NULL AND booktitle NOT NULL "
                my_cursor.execute(mysql,([book]))
                tmp_rows = my_cursor.fetchall()
                count1 = 0
                for row in tmp_rows:
                    count1,dummy = row
                if not count1 > 0 :
                    try:
                        error_found = True
                        my_cursor.execute("begin")
                        mysql = "DELETE FROM books_custom_column_10_link WHERE book = ? "
                        my_cursor.execute(mysql,([book]))
                        mysql = "DELETE FROM custom_column_12 WHERE book = ? "
                        my_cursor.execute(mysql,([book]))
                        mysql = "DELETE FROM custom_column_15 WHERE book = ? "
                        my_cursor.execute(mysql,([book]))
                        my_cursor.execute("commit")
                        sleep(0.01)
                        my_cursor.execute("begin")
                        mysql = "DELETE FROM custom_column_10 WHERE id NOT IN(SELECT value FROM books_custom_column_10_link)"
                        my_cursor.execute(mysql)
                        my_cursor.execute("commit")
                        sleep(0.01)
                        continue
                    except Exception as e:
                        my_db.close()
                        raise e
                        return
                else:
                    try:
                        sleep(0.01)
                        my_cursor.execute("begin")
                        mysql = "DELETE FROM books_custom_column_10_link WHERE book = ? "
                        my_cursor.execute(mysql,([book]))
                        my_cursor.execute("commit")
                        sleep(0.01)
                        my_cursor.execute("begin")
                        mysql = "INSERT OR REPLACE INTO custom_column_10 SELECT book,name FROM __book_series_name_sort \
                                                                                                                WHERE book = ? "
                        my_cursor.execute(mysql,([book]))
                        my_cursor.execute("commit")
                        sleep(0.01)
                        my_cursor.execute("begin")
                        mysql = "INSERT or REPLACE INTO books_custom_column_10_link SELECT book,book,book FROM __book_series_name_sort \
                                                                                                                                 WHERE book = ? "
                        my_cursor.execute(mysql,([book]))
                        my_cursor.execute("commit")
                        sleep(0.01)
                    except Exception as e:
                        my_db.close()
                        raise e
                        return
            except Exception as e:
                my_db.close()
                raise e
                return
        sleep(0.01)
        my_cursor.execute("begin")
        mysql = "DELETE FROM custom_column_10 WHERE id NOT IN(SELECT value FROM books_custom_column_10_link)"
        my_cursor.execute(mysql)
        sleep(0.01)
        mysql = "DELETE FROM custom_column_12 WHERE book NOT IN(SELECT book FROM books_custom_column_10_link)"
        my_cursor.execute(mysql)
        sleep(0.01)
        mysql = "DELETE FROM custom_column_15 WHERE book NOT IN(SELECT book FROM books_custom_column_10_link)"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.05)
        my_db.close()
        self.force_refresh_of_cache(my_book_list)
        if  error_found:
            info_dialog(self.gui, 'Invalid Action(s) Requested','Cannot Have Work Series Without a Work Author and Work Title!').show()
            return
    def scrub_begin_dialog_derive_genres(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            book_ids_list = []
            book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
            n = len(book_ids_list)
            if  n == 0:
                info_dialog(self.gui, 'No Books Selected','No Books Were Selected for Derive Genres').show()
                return
            else:
                pass
            self.question_then_go_derive_genres(book_ids_list)
    def question_then_go_derive_genres(self, book_ids_list):
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        else:
            book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
            del book_ids_list
            results_status = []
            if question_dialog(self.gui, "QuarantineAndScrub", (" Derive Genres [Q&S Version] \
                                                    <br><br>GUI Will Be Locked While Job Runs <br><br>Continue?")):
                start_threaded_derive_genres(self, self.gui, book_ids, results_status, Dispatcher(self.scrub_derive_genres_no_restart))  #<<<<<== in jobs.py
                self.create_ui_toast_dialog_for_jobs()
                if self.my_jobs_dialog_object:
                    if self.my_jobs_dialog_object != None:
                        try:
                            self.my_jobs_dialog_object.show()
                        except:
                            pass
            else:
                 info_dialog(self.gui, 'Canceled','Derive Genres is Canceled').show()
    def scrub_derive_genres_no_restart(self, job):
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Failed: Q&S Derive Genres.....'))
            pass
        else:
            pass
        db = self.gui.current_db.new_api                           #see:  http://manual.calibre-ebook.com/db_api.html
        work_book_ids_frozenset = db.all_book_ids()
        books_to_refresh = []
        for row in work_book_ids_frozenset:      #ALL books in the database will be refreshed!  This is the only safe way to avoid a total restart.
            books_to_refresh.append(row)
        self.gui.status_bar.show_message(_('Q&S Derive Genres Has Completed'), 5000)
        self.force_refresh_of_cache(books_to_refresh)
    def autopopulate_tags_by_comment(self):
        chosen_option = '0'
        self.choices_dialog = AutoPopChoicesDialog(self.gui,self.qaction.icon(),self.guidb,chosen_option,self.autopopulate_tags_by_comment_part2)
        self.choices_dialog.show()
    def autopopulate_tags_by_comment_part2(self,chosen_option):
        if chosen_option == '1':
            candidates_only = True
            info_dialog(self.gui, "Candidates Only Selected"\
                                            ,"<big><font color='#0404B4'><B>[1] Review Table _tags_by_comment_candidates</B></font></big>").show()
        else:
            self.choices_dialog.close()
            candidates_only = False
            info_dialog(self.gui, "Full Update Selected"\
                                            ,"<big><font color='#0404B4'><B>[2] Review Table _tags_by_comment Prior to Tag Scrubbing</B></font></big>").show()
        self.guidb = self.gui.library_view.model().db
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        if candidates_only:
            my_cursor.execute("begin")
            mysql = "INSERT OR IGNORE INTO _tags_by_comment_candidates SELECT oldtag,newtag FROM __tags_by_comment_potential_rules;"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.01)
        else:
            my_cursor.execute("begin")
            mysql = "INSERT OR IGNORE INTO _tags_by_comment SELECT null,comment,tag FROM  _tags_by_comment_candidates \
                            WHERE comment NOT IN(SELECT comment FROM _tags_by_comment WHERE tag = _tags_by_comment_candidates.tag ) ;"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.01)
            my_cursor.execute("begin")
            mysql = "DELETE FROM _tags_by_comment_candidates;"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            sleep(0.01)
    def populate_ddc_lcc_using_classify_api(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        ddc_name = prefs['ddc']
        lcc_name = prefs['lcc']
        is_active = False
        active = prefs['classify']
        if active == "True":
            is_active = True
        if not is_active:
            return error_dialog(self.gui, _('Cannot Update DDC & LCC for Selected Books'),
                                                      _('You Have Not Activated This Functionality in Configuration.'), show=True)
        ddc_exists = True
        lcc_exists = True
        n = len(ddc_name)
        if (not ddc_name.startswith("#")) or (n < 2) or (ddc_name == "#none") or (ddc_name == "none"):
            ddc_exists = False
        n = len(lcc_name)
        if (not lcc_name.startswith("#")) or (n < 2) or (lcc_name == "#none") or (lcc_name == "none"):
            lcc_exists = False
        if ((not ddc_exists) and (not lcc_exists)):
            return error_dialog(self.gui, _('Cannot Update DDC & LCC for Selected Books'),
                                                      _('You Must Configure the Lookup Name for at least one of DDC or LCC.'), show=True)
        work_book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(work_book_ids_list)
        if  n == 0:
            return error_dialog(self.gui, _('Cannot Update DDC & LCC for Selected Books'),
                                                      _('You must select at least one (1) book to perform this action.'), show=True)
        isbn_dict = self.get_isbn_identifiers_for_selected_books(work_book_ids_list, ddc_name, lcc_name)
        if not isbn_dict:
            return error_dialog(self.gui, _('Cannot Update DDC & LCC for Selected Books'),
                                                      _('ISBN/ISSN for at least one of the selected books, plus DDC and/or LCC Custom Columns, must exist in this specific Q&S library order to perform this action.'), show=True)
        self.create_ui_toast_dialog(1)
        book_ids_list = []
        ddc_dict = {}
        lcc_dict = {}
        owi_dict = {}
        final_list = []
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        del work_book_ids_list #not a global here
        for book in book_ids:
            try:
                isbn = isbn_dict[book]
                if isbn:
                    paramtype = "stdnbr"          # "stdnbr"  includes isbn, issn, upc, owi, etc.
                    paramvalue = isbn               # isbn OR issn...
                    ddc,lcc,owi = oclc_classify_api(paramtype,paramvalue)        #http://classify.oclc.org/classify2/Classify?stdnbr=0047-2689&summary=true
                    was_found = False
                    if ddc != "NONE":
                        ddc_dict[book] = ddc
                        was_found = True
                    if lcc != "NONE":
                        lcc_dict[book] = lcc
                        was_found = True
                    if owi != "NONE":
                        owi_dict[book] = owi
                    if was_found:
                        book_ids_list.append(book)     #list of books
                else:
                    continue
            except Exception as e:
                continue
        nd = len(ddc_dict)
        nl = len(lcc_dict)
        if nd == 0 and nl == 0:
            try:
                self.ui_toast_dialog.close()
            except:
                pass
            info_dialog(self.gui, "DDC & LCC ", "Nothing Found For Any Selected Book")
            return
        custom_columns = self.gui.current_db.field_metadata.custom_field_metadata()
        n = len(book_ids_list)
        if n > 0:
            id_map = {}
            for book in book_ids_list:
                data_changed = False
                mi = Metadata(_('Unknown'))
                try:
                    custcol1 = custom_columns[ddc_name]         #  custcol = custom_columns["#ddc"]
                    custcol1['#value#'] = as_unicode(ddc_dict[book])
                    mi.set_user_metadata(ddc_name, custcol1)   # class Metadata in  src>calibre>ebooks>metadata>book>base.py
                    data_changed = True
                except Exception as e:
                    pass
                try:
                    custcol2 = custom_columns[lcc_name]
                    custcol2['#value#'] = as_unicode(lcc_dict[book])
                    mi.set_user_metadata(lcc_name, custcol2)
                    data_changed = True
                except Exception as e:
                    pass
                if data_changed:
                    id_map[book] = mi
                    final_list.append(book)
            n = len(final_list)
            if n == 0:
                try:
                    self.ui_toast_dialog.close()
                except:
                    pass
                info_dialog(self.gui, "DDC & LCC ", "Nothing Updated For Any Book")
                return
            final_list = qs_convert_list_of_nominal_book_ids_to_integers(final_list)
            payload = final_list, owi_dict
            edit_metadata_action = self.gui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=self.finish_displaying_results_of_ddc_lcc(payload))
        else:
            info_dialog(self.gui, "DDC & LCC ", "Nothing Updated For Any Book")
        del book_ids_list
        try:
            self.ui_toast_dialog.close()
        except:
            pass
    def finish_displaying_results_of_ddc_lcc(self, payload):
        final_list, owi_dict = payload
        if len(owi_dict) > 0 and len(final_list) > 0:
            self.add_owi_identifiers(owi_dict,final_list)
        self.force_refresh_of_cache(final_list)
        try:
            self.ui_toast_dialog.close()
        except:
            pass
    def get_isbn_identifiers_for_selected_books(self, work_book_ids_list, ddc_name, lcc_name):
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        ddc_name = ddc_name.replace("#","")
        lcc_name = lcc_name.replace("#","")
        mysql = "SELECT count(*) FROM custom_columns WHERE label = ? OR label = ?"
        my_cursor.execute(mysql,(ddc_name,lcc_name))
        rows = my_cursor.fetchall()
        if not rows:
            rows = []
        count1 = 0
        for row in rows:
            for col in row:
                count1 = col
                break
        if not count1 > 0:
            my_db.close()
            sleep(0.2)
            isbn_dict = {}
            return isbn_dict
        isbn_dict = {}
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(work_book_ids_list)
        for book in book_ids:
            mysql = "SELECT val FROM identifiers WHERE book = ? AND (type = 'isbn' OR type = 'issn') AND val NOT NULL "
            my_cursor.execute(mysql,([book]))
            tmp_rows = []
            del tmp_rows
            tmp_rows = my_cursor.fetchall()
            if tmp_rows:
                tmp_rows.sort(reverse=True)    #this forces isbn to be used instead of issn if both exist
                for row in tmp_rows:
                    for col in row:
                        isbn_dict[book] = col
                    break  #can have BOTH isbn and issn; isbn.  The ISBN identifies the individual book in a series or a specific year for an annual or biennial. The ISSN identifies the ongoing series, or the ongoing annual or biennial serial.
            else:
                continue
        my_db.close()
        sleep(0.2)
        return isbn_dict
    def add_owi_identifiers(self, owi_dict,final_list):
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_cursor.execute("begin")
        for book in final_list:
            try:
                owi = owi_dict[book]
                mysql = "INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,'oclc-owi', ?)  "
                my_cursor.execute(mysql,(book,owi))
            except:
                continue
        try:
            my_cursor.execute("commit")
        except:
            pass
        my_db.close()
        sleep(0.2)
    def import_data_no_restart(self, job):
        if job.failed:
            self.gui.job_exception(job, dialog_title=_('Failed to Import Data...'))
            return
        else:
            self.gui.status_bar.show_message(_('Importing of Data Has Completed'), 15000)
    def work_tag_destroy_dialog(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.worktagdestroy_dialog = WorkTagDestroyDialog(self.gui,self.qaction.icon(),self.guidb,self.execute_work_tag_search_and_destroy)
        self.worktagdestroy_dialog.show()
    def execute_work_tag_search_and_destroy(self, work_tag_keyword, use_substring_param):
        if not work_tag_keyword > " ":
            return
        if work_tag_keyword == "?":
            return
        self.worktagdestroy_dialog.hide()  #otherwise, user won't see refreshed values on gui until manually closed
        if use_substring_param == "True":
            use_substring = True
        else:
            use_substring = False
        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
        del book_ids_list
        n = len(book_ids)
        if n == 0:
            return error_dialog(self.gui, _('No Books Selected'),
                                                      _('You must select one or more books to perform this action.'), show=True)
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_cursor.execute("begin")
        mysql = "INSERT or REPLACE INTO custom_column_13 (id,value) SELECT book, tagsall FROM __books_work_populate WHERE tagsall not null  ; "
        my_cursor.execute(mysql)
        sleep(0.1)
        mysql = "UPDATE books_custom_column_13_link  SET value = books_custom_column_13_link.book "
        my_cursor.execute(mysql)
        sleep(0.1)
        my_cursor.execute("commit")
        sleep(0.1)
        my_cursor.execute("begin")
        mysql = "DELETE FROM custom_column_13 WHERE id NOT IN (SELECT value FROM books_custom_column_13_link)"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.1)
        my_cursor.execute("begin")
        for book in book_ids:
            mysql = "SELECT book,tagsall, \
                                (SELECT value FROM books_custom_column_13_link \
                                    WHERE book = __books_work_populate.book AND value NOT NULL) as link_value \
                            FROM  __books_work_populate WHERE tagsall NOT NULL AND book = ?"
            my_cursor.execute(mysql,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                continue
            else:
                if len(tmp_rows) == 0:
                    continue
                else:
                    for item in tmp_rows:
                        book,tagsall,link_value = item      #  Fiction, General, Mystery&Detective, Suspense, Thrillers
                        break
                    orig_tagsall = tagsall
                    if tagsall.count(", ") == 0:     #single tag
                        tagsall = tagsall + ", DUMMY"     #now can be split
                    new_tagsall = ""
                    s_split = tagsall.split(", ")
                    for  tag in s_split:
                        tag = tag.strip()
                        if not tag > " ":
                            continue
                        if tag == "DUMMY":
                            continue
                        if not use_substring:
                            if tag == work_tag_keyword:
                                continue
                            else:
                                new_tagsall = new_tagsall + ", " + tag
                        else:
                            if not tag.count(work_tag_keyword) > 0:   #just a partial match works here...
                                new_tagsall = new_tagsall + ", " + tag
                            else:
                                continue
                    new_tagsall = new_tagsall.replace("DUMMY","")
                    new_tagsall = new_tagsall.replace(", ,", ",", 1)
                    new_tagsall = new_tagsall.strip()
                    if new_tagsall.startswith(","):         #  , General, Mystery&Detective, Suspense, Thrillers
                        new_tagsall = new_tagsall[1: ]
                        new_tagsall = new_tagsall.strip()      #  General, Mystery&Detective, Suspense, Thrillers
                    if new_tagsall.endswith(","):     #  General, Mystery&Detective, Suspense,
                        new_tagsall = new_tagsall[0:-1]
                        new_tagsall = new_tagsall.strip()      #  General, Mystery&Detective, Suspense
                    if orig_tagsall == new_tagsall:    #nothing was changed, net net
                        continue
                    if new_tagsall > " ":
                        mysql = "UPDATE custom_column_13 SET value = ? WHERE id = ? "
                        my_cursor.execute(mysql,(new_tagsall,link_value))
                        sleep(0.02)
                    else:
                        mysql = "DELETE FROM custom_column_13 WHERE id = ? "
                        my_cursor.execute(mysql,([link_value]))
                        sleep(0.02)
                        mysql = "DELETE FROM books_custom_column_13_link WHERE book = ? "
                        my_cursor.execute(mysql,([book]))
                        sleep(0.02)
        try:
            my_cursor.execute("commit")
            sleep(0.1)
        except:
            pass
        my_db.close()
        self.force_refresh_of_cache(book_ids)
        sleep(0.1)
        self.worktagdestroy_dialog.show()
    def work_tag_add_dialog(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.worktagadd_dialog = WorkTagAddDialog(self.gui,self.qaction.icon(),self.guidb,self.execute_work_tag_add)
        self.worktagadd_dialog.show()
    def execute_work_tag_add(self, work_tag_keyword):
        if not (work_tag_keyword > " " and work_tag_keyword != '?' ):
            return
        self.worktagadd_dialog.hide()  #otherwise, user won't see refreshed values on gui until permanently closed
        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
        del book_ids_list
        n = len(book_ids)
        if n == 0:
            return error_dialog(self.gui, _('No Books Selected'),
                                                      _('You must select one or more books to perform this action.'), show=True)
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_cursor.execute("begin")
        mysql = "INSERT or REPLACE INTO custom_column_13 (id,value) SELECT book, tagsall FROM __books_work_populate WHERE tagsall not null  ; "
        my_cursor.execute(mysql)
        sleep(0.1)
        mysql = "UPDATE books_custom_column_13_link  SET value = books_custom_column_13_link.book "
        my_cursor.execute(mysql)
        sleep(0.1)
        my_cursor.execute("commit")
        sleep(0.1)
        my_cursor.execute("begin")
        mysql = "DELETE FROM custom_column_13 WHERE id NOT IN (SELECT value FROM books_custom_column_13_link)"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.1)
        for book in book_ids:
            book_has_no_tags = False
            mysql = "SELECT book,tagsall, \
                                (SELECT value FROM books_custom_column_13_link \
                                    WHERE book = __books_work_populate.book AND value NOT NULL) as link_value \
                            FROM  __books_work_populate WHERE tagsall NOT NULL AND book = ?"
            my_cursor.execute(mysql,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                book_has_no_tags = True
                tagsall = work_tag_keyword
                link_value = book
            else:
                if len(tmp_rows) == 0:
                    book_has_no_tags = True
                    tagsall = work_tag_keyword
                    link_value = book
                else:
                    for item in tmp_rows:
                        book,tagsall,link_value = item
                        break
                    tagsall = tagsall + ", " + work_tag_keyword    #if tag duplicated, okay, since removed below
                    del tmp_rows
            tagsall = self.sort_tags(tagsall)        #also removes duplicates
            if not book_has_no_tags:
                my_cursor.execute("begin")
                mysql = "UPDATE custom_column_13 SET value = ? WHERE id = ? "
                my_cursor.execute(mysql,(tagsall,link_value))
                my_cursor.execute("commit")
                sleep(0.02)
            else:
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE INTO custom_column_13 (id,value) VALUES(?,?)"
                my_cursor.execute(mysql,(link_value,tagsall))
                sleep(0.02)
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE INTO books_custom_column_13_link (id,book,value) VALUES(?,?,?)"
                my_cursor.execute(mysql,(book,book,link_value))
                sleep(0.02)
                my_cursor.execute("commit")
                sleep(0.1)
        try:
            my_cursor.execute("commit")
            sleep(0.1)
        except:
            pass
        my_db.close()
        self.force_refresh_of_cache(book_ids)
        sleep(0.1)
        self.worktagadd_dialog.show()
        return
    def sort_tags(self, tagsall):
        tagsall = tagsall.strip()
        if not tagsall.count(", ") > 0:
            return tagsall
        s_list = tagsall.split(", ")   #must split with the space too, or will not eliminate duplicates
        s_set = set(s_list)
        s_list = list(s_set)   #now no duplicates
        s_list.sort()
        new_tagsall = ""
        for item in s_list:
            item = item.strip()
            new_tagsall = new_tagsall + ", " + item
        if new_tagsall.startswith(","):
            new_tagsall = new_tagsall[1: ]
            new_tagsall = new_tagsall.strip()
        return new_tagsall
    def work_tag_replace_dialog(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.worktagreplace_dialog = WorkTagReplaceDialog(self.gui,self.qaction.icon(),self.guidb,self.execute_work_tag_search_and_replace)
        self.worktagreplace_dialog.show()
    def execute_work_tag_search_and_replace(self, work_tag_keyword, use_substring_param, work_tag_new):
        if not work_tag_keyword > " ":
            return
        if work_tag_keyword == "?":
            return
        if not work_tag_new > " ":
            return
        if work_tag_new == "?":
            return
        self.worktagreplace_dialog.hide()  #otherwise, user won't see refreshed values on gui until manually closed
        if use_substring_param == "True":
            use_substring = True
        else:
            use_substring = False
        if  work_tag_keyword == "*":
            use_wildcard = True
        else:
            use_wildcard = False
        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list)
        if n == 0:
            self.worktagreplace_dialog.show()
            return error_dialog(self.gui, _('No Books Selected'),
                                                      _('You must select one or more books to perform this action.'), show=True)
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
        del book_ids_list
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        my_cursor.execute("begin")
        mysql = "INSERT or REPLACE INTO custom_column_13 (id,value) SELECT book, tagsall FROM __books_work_populate WHERE tagsall IS NOT NULL  ; "
        my_cursor.execute(mysql)
        sleep(0.1)
        mysql = "UPDATE books_custom_column_13_link  SET value = books_custom_column_13_link.book "
        my_cursor.execute(mysql)
        sleep(0.1)
        my_cursor.execute("commit")
        sleep(0.1)
        my_cursor.execute("begin")
        mysql = "DELETE FROM custom_column_13 WHERE id NOT IN (SELECT value FROM books_custom_column_13_link)"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.1)
        my_cursor.execute("begin")
        for book in book_ids:
            mysql = "SELECT book,tagsall, \
                                (SELECT value FROM books_custom_column_13_link \
                                    WHERE book = __books_work_populate.book AND value NOT NULL) as link_value \
                            FROM  __books_work_populate WHERE tagsall NOT NULL AND book = ?"
            my_cursor.execute(mysql,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                continue
            else:
                if len(tmp_rows) == 0:
                    continue
                else:
                    for item in tmp_rows:
                        book,tagsall,link_value = item      #  Fiction, General, Mystery&Detective, Suspense, Thrillers
                        break
                    orig_tagsall = tagsall
                    if tagsall.count(", ") == 0:     #single tag
                        tagsall = tagsall + ", DUMMY"     #now can be split
                    new_tagsall = ""
                    s_split = tagsall.split(", ")
                    for  tag in s_split:
                        tag = tag.strip()
                        if not tag > " ":
                            continue
                        if tag == "DUMMY":
                            continue
                        if not use_substring:
                            if tag == work_tag_keyword:
                                new_tagsall = new_tagsall + ", " + work_tag_new
                            else:
                                new_tagsall = new_tagsall + ", " + tag
                        else:
                            if use_wildcard:
                                new_tagsall = new_tagsall + ", " + work_tag_new
                            else:
                                if not tag.count(work_tag_keyword) > 0:   #just a partial match works here...
                                    new_tagsall = new_tagsall + ", " + tag
                                else:
                                    new_tagsall = new_tagsall + ", " + work_tag_new
                    new_tagsall = new_tagsall.replace("DUMMY","",4)
                    new_tagsall = new_tagsall.replace(", ,", ",", 1)
                    new_tagsall = new_tagsall.strip()
                    if new_tagsall.startswith(","):         #  , General, Mystery&Detective, Suspense, Thrillers
                        new_tagsall = new_tagsall[1: ]
                        new_tagsall = new_tagsall.strip()      #  General, Mystery&Detective, Suspense, Thrillers
                    if new_tagsall.endswith(","):     #  General, Mystery&Detective, Suspense,
                        new_tagsall = new_tagsall[0:-1]
                        new_tagsall = new_tagsall.strip()      #  General, Mystery&Detective, Suspense
                    try:
                        orig_tagsall = as_unicode(orig_tagsall)
                        new_tagsall = as_unicode(new_tagsall)
                    except:
                        pass
                    if orig_tagsall == new_tagsall:    #nothing was changed, net net
                        continue
                    new_tagsall = self.sort_tags(new_tagsall)     #and also removes duplicates
                    if new_tagsall > " ":
                        mysql = "UPDATE custom_column_13 SET value = ? WHERE id = ? "
                        my_cursor.execute(mysql,(new_tagsall,link_value))
                        sleep(0.02)
        try:
            my_cursor.execute("commit")
            sleep(0.1)
        except:
            pass
        my_db.close()
        self.force_refresh_of_cache(book_ids)
        sleep(0.1)
        self.worktagreplace_dialog.show()
    def work_series_replace_dialog(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.workseriesreplace_dialog = WorkSeriesReplaceDialog(self.gui,self.qaction.icon(),self.guidb,self.execute_work_series_search_and_replace)
        self.workseriesreplace_dialog.show()
    def execute_work_series_search_and_replace(self, work_series_keyword, use_substring_param, work_series_new):
        if not work_series_keyword > " ":
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series'), show=True)
        if work_series_keyword == "?":
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series'), show=True)
        if not work_series_new > " ":
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series'), show=True)
        if work_series_new == "?":
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series'), show=True)
        if work_series_keyword.count("[") > 0:
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series, not the Name Plus Series Index (e.g. [2] )'), show=True)
        if work_series_new.count("[") > 0:
            return error_dialog(self.gui, _('No Books Selected'),
                                                      _('The Work Series is the Name of the Series, not the Name Plus Series Index (e.g. [2] )'), show=True)
        self.workseriesreplace_dialog.hide()  #otherwise, user won't see refreshed values on gui until manually closed
        if use_substring_param == "True":
            use_substring = True
        else:
            use_substring = False
        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list)
        if n == 0:
            self.workseriesreplace_dialog.show()
            return error_dialog(self.gui, _('No Books Selected'),
                                                      _('You must select one or more books to perform this action.'), show=True)
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
        del book_ids_list
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        for book in book_ids:
            mysql = "SELECT book,seriesname, seriesindex, \
                                (SELECT value FROM books_custom_column_10_link \
                                    WHERE book = __books_work_populate.book ) as link_value \
                            FROM  __books_work_populate WHERE seriesname NOT NULL AND book = ?"
            my_cursor.execute(mysql,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                continue
            else:
                if len(tmp_rows) == 0:
                    continue
                else:
                    for item in tmp_rows:
                        book,seriesname,seriesindex,link_value = item      #  "2639","Women's Murder Club","5"              full is: "Women's Murder Club [5]"
                        break
            orig_seriesname = seriesname
            if not use_substring:
                if seriesname == work_series_keyword:
                    new_seriesname = work_series_new
                else:
                    new_seriesname = seriesname
            else:
                if not seriesname.count(work_series_keyword) > 0:   #just a partial match works here...
                    new_seriesname = seriesname
                else:
                    new_seriesname =  work_series_new
            new_seriesname = new_seriesname.strip()
            try:
                orig_seriesname = as_unicode(orig_seriesname)
                new_seriesname = as_unicode(new_seriesname)
            except:
                pass
            if orig_seriesname == new_seriesname:    #nothing was changed, net net
                continue
            s_index = as_unicode(seriesindex)
            s_index = as_unicode(s_index.replace(".00","",1))
            s_index = as_unicode(s_index.replace(".0","",1))
            new_full_series = new_seriesname + " [" + s_index + "]"
            if new_seriesname > " ":
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES(?,?) "
                my_cursor.execute(mysql,(book,new_seriesname))
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM books_custom_column_10_link WHERE book = ?  "
                my_cursor.execute(mysql,([book]))
                sleep(0.02)
                mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES(?,?,?) "
                my_cursor.execute(mysql,(book,book,book))
                sleep(0.02)
                mysql = "UPDATE custom_column_15 SET value = ? WHERE book = ? "
                my_cursor.execute(mysql,(new_full_series,book))
                sleep(0.02)
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM custom_column_10 WHERE id NOT IN(SELECT value FROM books_custom_column_10_link)"
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.1)
            else:
                pass
        try:
            my_cursor.execute("commit")
            sleep(0.1)
        except:
            pass
        my_db.close()
        self.force_refresh_of_cache(book_ids)
        sleep(0.1)
        self.workseriesreplace_dialog.show()
    def work_series_destroy_dialog(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.workseriesdestroy_dialog = WorkSeriesDestroyDialog(self.gui,self.qaction.icon(),self.guidb,self.execute_work_series_search_and_destroy)
        self.workseriesdestroy_dialog.show()
    def execute_work_series_search_and_destroy(self, work_series_keyword, use_substring_param):
        if not work_series_keyword > " ":
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series'), show=True)
        if work_series_keyword == "?":
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series'), show=True)
        if work_series_keyword.count("[") > 0:
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series, not the Name Plus Series Index (e.g. [2] )'), show=True)
        self.workseriesdestroy_dialog.hide()  #otherwise, user won't see refreshed values on gui until manually closed
        if use_substring_param == "True":
            use_substring = True
        else:
            use_substring = False
        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list)
        if n == 0:
            self.workseriesdestroy_dialog.show()
            return error_dialog(self.gui, _('No Books Selected'),
                                                      _('You must select one or more books to perform this action.'), show=True)
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
        del book_ids_list
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        for book in book_ids:
            mysql = "SELECT book,seriesname, \
                                (SELECT value FROM books_custom_column_10_link \
                                    WHERE book = __books_work_populate.book ) as link_value \
                            FROM  __books_work_populate WHERE seriesname NOT NULL AND book = ?"
            my_cursor.execute(mysql,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                continue
            else:
                if len(tmp_rows) == 0:
                    continue
                else:
                    for item in tmp_rows:
                        book,seriesname,link_value = item      #  "2639","Women's Murder Club"
                        break
            if not use_substring:
                if seriesname == work_series_keyword:
                    new_seriesname = 'DELETE'
                else:
                    new_seriesname = seriesname
            else:
                if not seriesname.count(work_series_keyword) > 0:   #just a partial match works here...
                    new_seriesname = seriesname
                else:
                    new_seriesname =  'DELETE'
            if not new_seriesname ==  'DELETE':
                continue
            else:
                my_cursor.execute("begin")
                mysql = "DELETE FROM books_custom_column_10_link WHERE book = ?  "
                my_cursor.execute(mysql,([book]))
                sleep(0.02)
                mysql = "DELETE FROM custom_column_15 WHERE book = ?  "
                my_cursor.execute(mysql,([book]))
                sleep(0.02)
                mysql = "UPDATE custom_column_12 SET value = 0.0 WHERE book = ?  "
                my_cursor.execute(mysql,([book]))
                sleep(0.02)
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM custom_column_10 WHERE id NOT IN(SELECT value FROM books_custom_column_10_link)"
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.1)
        my_db.close()
        self.force_refresh_of_cache(book_ids)
        sleep(0.1)
        self.workseriesdestroy_dialog.show()
    def work_series_add_dialog(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.workseriesadd_dialog = WorkSeriesAddDialog(self.gui,self.qaction.icon(),self.guidb,self.execute_work_series_add)
        self.workseriesadd_dialog.show()
    def execute_work_series_add(self, work_series_keyword, work_series_index):
        if not work_series_keyword > " ":
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series'), show=True)
        if work_series_keyword == "?":
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series'), show=True)
        if work_series_keyword.count("[") > 0:
            return error_dialog(self.gui, _('Invalid Work Series Specified'),
                                                      _('The Work Series is the Name of the Series, not the Name Plus Series Index (e.g. [2] )'), show=True)
        if work_series_index == 0:
            work_series_index = 1
        self.workseriesadd_dialog.hide()  #otherwise, user won't see refreshed values on gui until manually closed
        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list)
        if n == 0:
            self.workseriesadd_dialog.show()
            return error_dialog(self.gui, _('No Books Selected'),
                                                      _('You must select one or more books to perform this action.'), show=True)
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
        del book_ids_list
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        for book in book_ids:
            mysql = "SELECT book,seriesname \
                            FROM  __books_work_populate WHERE seriesname NOT NULL AND book = ?"
            my_cursor.execute(mysql,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                pass
            else:
                if len(tmp_rows) == 0:
                    pass
                else:
                    continue
            new_seriesname = work_series_keyword
            s_index = as_unicode(work_series_index)
            s_index = as_unicode(s_index.replace(".0","",1))
            new_full_series = new_seriesname + " [" + s_index + "]"
            if new_seriesname > " ":
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES(?,?) "
                my_cursor.execute(mysql,(book,new_seriesname))
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM books_custom_column_10_link WHERE book = ?  "
                my_cursor.execute(mysql,([book]))
                sleep(0.02)
                mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES(?,?,?) "
                my_cursor.execute(mysql,(book,book,book))
                sleep(0.02)
                mysql = "INSERT OR REPLACE INTO custom_column_12 (id,book,value) VALUES(?,?,?) "
                my_cursor.execute(mysql,(book,book,work_series_index))
                sleep(0.02)
                mysql = "INSERT OR REPLACE INTO custom_column_15 (id,book,value) VALUES(?,?,?) "
                my_cursor.execute(mysql,(book,book,new_full_series))
                sleep(0.02)
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM custom_column_10 WHERE id NOT IN(SELECT value FROM books_custom_column_10_link)"
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.1)
            else:
                pass
        try:
            my_cursor.execute("commit")
            sleep(0.1)
        except:
            pass
        my_db.close()
        self.force_refresh_of_cache(book_ids)
        sleep(0.1)
        self.workseriesadd_dialog.show()
    def work_title_change_dialog(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.worktitlechange_dialog = WorkTitleChangeDialog(self.gui,self.qaction.icon(),self.guidb,self.execute_work_title_change)
        self.worktitlechange_dialog.show()
    def execute_work_title_change(self, work_title_new):
        work_title_new = work_title_new.strip()
        if not work_title_new > " ":
            return error_dialog(self.gui, _('Invalid Work Title Specified'),
                                                      _('Invalid Work Title Specified'), show=True)
        if work_title_new == "?":
            return error_dialog(self.gui, _('Invalid Work Title Specified'),
                                                      _('Invalid Work Title Specified'), show=True)
        self.worktitlechange_dialog.hide()  #otherwise, user won't see refreshed values on gui until manually closed
        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list)
        if  n != 1:
            self.worktitlechange_dialog.show()
            return error_dialog(self.gui, _('Exactly One Book Must Be Selected'),
                                                      _('You must select exactly one book to perform this action.'), show=True)
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
        del book_ids_list
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        for book in book_ids:
            mysql = "SELECT book, booktitle \
                            FROM  __books_work_populate WHERE booktitle NOT NULL AND book = ?"
            my_cursor.execute(mysql,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                self.worktitlechange_dialog.show()
                return error_dialog(self.gui, _('No Work Title Exists'),
                                                      _('You Cannot Change What Does Not Exist.'), show=True)
            else:
                if len(tmp_rows) == 0:
                    self.worktitlechange_dialog.show()
                    return error_dialog(self.gui, _('No Work Title Exists'),
                                                          _('You Cannot Change What Does Not Exist.'), show=True)
                else:
                    pass
            if work_title_new > " ":
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE INTO custom_column_8 (id,value) VALUES(?,?) "
                my_cursor.execute(mysql,(book,work_title_new))
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM books_custom_column_8_link WHERE book = ?  "
                my_cursor.execute(mysql,([book]))
                sleep(0.02)
                mysql = "INSERT OR REPLACE INTO books_custom_column_8_link (id,book,value) VALUES(?,?,?) "
                my_cursor.execute(mysql,(book,book,book))
                sleep(0.02)
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM custom_column_8 WHERE id NOT IN(SELECT value FROM books_custom_column_8_link)"
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.1)
            else:
                pass
        try:
            my_cursor.execute("commit")
            sleep(0.1)
        except:
            pass
        my_db.close()
        self.force_refresh_of_cache(book_ids)
        sleep(0.1)
        self.worktitlechange_dialog.show()
    def work_author_change_dialog(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.workauthorchange_dialog = WorkAuthorChangeDialog(self.gui,self.qaction.icon(),self.guidb,self.execute_work_author_change)
        self.workauthorchange_dialog.show()
    def execute_work_author_change(self, work_author_new):
        work_author_new = work_author_new.strip()
        if not work_author_new > " ":
            return error_dialog(self.gui, _('Invalid Work Author Specified'),
                                                      _('Invalid Work Author Specified'), show=True)
        if work_author_new == "?":
            return error_dialog(self.gui, _('Invalid Work Author Specified'),
                                                      _('Invalid Work Author Specified'), show=True)
        self.workauthorchange_dialog.hide()  #otherwise, user won't see refreshed values on gui until manually closed
        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list)
        if  n != 1:
            self.workauthorchange_dialog.show()
            return error_dialog(self.gui, _('Exactly One Book Must Be Selected'),
                                                      _('You must select exactly one book to perform this action.'), show=True)
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
        del book_ids_list
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        for book in book_ids:
            mysql = "SELECT book, authname \
                            FROM  __books_work_populate \
                            WHERE book = ? \
                                AND book = (SELECT book FROM books_custom_column_18_link \
                                                                          WHERE books_custom_column_18_link.book = \
                                                                                __books_work_populate.book \
                                                                                AND books_custom_column_18_link .value =\
                                                                                (SELECT id FROM custom_column_18 WHERE value = 'book_ok')  ) \
                                AND authname NOT NULL"
            my_cursor.execute(mysql,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                self.workauthorchange_dialog.show()
                return error_dialog(self.gui, _('No Green Work Author Exists'),
                                                      _('You Can Only Change Work Authors with a Status of "book_ok".'), show=True)
            else:
                if len(tmp_rows) == 0:
                    self.workauthorchange_dialog.show()
                    return error_dialog(self.gui, _('No Green Work Author Exists'),
                                                      _('You Can Only Change Work Authors with a Status of "book_ok".'), show=True)
            if work_author_new > " ":
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE INTO custom_column_4 (id,value) VALUES(?,?) "
                my_cursor.execute(mysql,(book,work_author_new))
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM books_custom_column_4_link WHERE book = ?  "
                my_cursor.execute(mysql,([book]))
                sleep(0.02)
                mysql = "INSERT OR REPLACE INTO books_custom_column_4_link (id,book,value) VALUES(?,?,?) "
                my_cursor.execute(mysql,(book,book,book))
                sleep(0.02)
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM custom_column_4 WHERE id NOT IN(SELECT value FROM books_custom_column_4_link)"
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.1)
            else:
                pass
        try:
            my_cursor.execute("commit")
            sleep(0.1)
        except:
            pass
        my_db.close()
        self.force_refresh_of_cache(book_ids)
        sleep(0.1)
        self.workauthorchange_dialog.show()
    def work_series_index_change_dialog(self):
        self.guidb = self.gui.library_view.model().db
        self.ensure_correct_library()
        if not self.library_is_quarantine_db:
            self.library_changed()
            return
        self.workseriesindexchange_dialog = WorkSeriesIndexChangeDialog(self.gui,self.qaction.icon(),self.guidb,self.execute_work_series_index_change)
        self.workseriesindexchange_dialog.show()
    def execute_work_series_index_change(self, work_series_index):
        if work_series_index == 0:
            work_series_index = 1
        self.workseriesindexchange_dialog.hide()  #otherwise, user won't see refreshed values on gui until manually closed
        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list)
        if  n != 1:
            self.workseriesindexchange_dialog.show()
            return error_dialog(self.gui, _('Single Book Was Not Selected'),
                                                      _('You must select exactly one book to perform this action.'), show=True)
        book_ids = qs_convert_list_of_nominal_book_ids_to_integers(book_ids_list)
        del book_ids_list
        my_db,my_cursor,is_valid = self.apsw_connect_to_current_library()
        if not is_valid:
            return
        for book in book_ids:
            mysql = "SELECT book,seriesname \
                            FROM  __books_work_populate WHERE seriesname NOT NULL AND book = ?"
            my_cursor.execute(mysql,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                continue
            else:
                if len(tmp_rows) == 0:
                    continue
                else:
                    for row in tmp_rows:
                        book,seriesname = row
            new_seriesname = seriesname
            s_index = as_unicode(work_series_index)
            s_index = s_index.replace(".0","")
            new_full_series = new_seriesname + " [" + s_index + "]"
            if new_seriesname > " ":
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES(?,?) "
                my_cursor.execute(mysql,(book,new_seriesname))
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM books_custom_column_10_link WHERE book = ?  "
                my_cursor.execute(mysql,([book]))
                sleep(0.02)
                mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES(?,?,?) "
                my_cursor.execute(mysql,(book,book,book))
                sleep(0.02)
                mysql = "INSERT OR REPLACE INTO custom_column_12 (id,book,value) VALUES(?,?,?) "
                my_cursor.execute(mysql,(book,book,work_series_index))
                sleep(0.02)
                mysql = "INSERT OR REPLACE INTO custom_column_15 (id,book,value) VALUES(?,?,?) "
                my_cursor.execute(mysql,(book,book,new_full_series))
                sleep(0.02)
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM custom_column_10 WHERE id NOT IN(SELECT value FROM books_custom_column_10_link)"
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.1)
            else:
                pass
        try:
            my_cursor.execute("commit")
            sleep(0.1)
        except:
            pass
        my_db.close()
        self.force_refresh_of_cache(book_ids)
        sleep(0.1)
        self.workseriesindexchange_dialog.show()
    def create_ui_toast_dialog(self, msg_num):
        self.ui_toast_dialog = UIToastDialog(self.gui,self.qaction.icon(),msg_num)
        self.ui_toast_dialog.show()
        self.ui_toast_dialog.setModal(True)
        self.ui_toast_dialog.update()
        self.ui_toast_dialog.repaint()
    def create_ui_toast_dialog_for_jobs(self):
        self.create_ui_toast_dialog(3)
        sleep(1.00)
        self.ui_toast_dialog.close()
    def create_ui_toast_dialog_for_main_icon(self):
        self.create_ui_toast_dialog(4)
        sleep(1.25)
        self.ui_toast_dialog.close()
        self.guidb = self.gui.library_view.model().db
    def apsw_connect_to_current_library(self):
        self.guidb = self.gui.library_view.model().db
        is_valid = True
        path = self.guidb.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')
        self.library_db_path = path
        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            return None,None,False
        my_cursor = my_db.cursor()
        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds
        my_cursor.execute(mysql)
        return my_db,my_cursor,is_valid
