# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "3.6.106"    # Technical changes after Python 3.8 testing with Calibre 4.99.4

from polyglot.builtins import as_unicode

def add_book_awards(my_db, my_cursor, log):

    try:
        my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
    except:
        pass

    try:
        my_cursor.execute("\
            BEGIN TRANSACTION; \
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Wilson Tucker','The Year of the Quiet Sun','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Patricia A. McKillip','Winter Rose','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Kim Stanley Robinson','The Wild Shore','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jane Yolen','White Jenna','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'David Gerrold','When HARLIE Was One','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'George Alec Effinger','When Gravity Fails','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'George Alec Effinger','What Entropy Means to Me','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Norman Spinrad','The Void Captain!s Tale','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Avram Davidson','Vergil in Averno','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Suzy McKee Charnas','The Vampire Tapestry','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gene Wolfe','The Urth of the New Sun','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'David Brin','The Uplift War','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Robert Silverberg','Up the Line','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Samuel R. Delany','Triton','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Charles E. Gannon','Trial by Fire','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'James K. Morrow','Towing Jehovah','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Robert Silverberg','Tower of Glass','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Patricia A. McKillip','The Tower at Stony Wood','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Connie Willis','To Say Nothing of the Dog','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Wil McCarthy','To Crush the Moon','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'John Varley','Titan','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Saladin Ahmed','Throne of the Crescent Moon','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Liu Cixin','The Three-Body Problem','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Philip K. Dick','The Three Stigmata of Palmer Eldritch','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Robert Silverberg','Thorns','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'James K. Morrow','This Is the Way the World Ends','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Rachel Pollack','Temporary Agency','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula K. Le Guin','Tehanu: The Last Book of Earthsea','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'R.A. MacAvoy','Tea With the Black Dragon','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Pat Cadigan','Synners','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gene Wolfe','The Sword of the Lictor','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Richard A. Lupoff','Sword of Demon','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gardner Dozois','Strangers','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'George R.R. Martin','A Storm of Swords','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'David G. Compton','The Steel Crocodile','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'David Brin','Startide Rising','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Poul Anderson','The Star Fox','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'John Brunner','Stand on Zanzibar','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Orson Scott Card','Speaker for the Dead','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Joan D. Vinge','The Snow Queen','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Kurt Vonnegut','Slaughterhouse-Five','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jane Yolen','Sister Light, Sister Dark','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Nina Kiriki Hoffman','The Silent Strength of Stones','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'G.C. Edmondson','The Ship That Sailed the Time Stream','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gene Wolfe','The Shadow of the Torturer','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Mary Robinette Kowal','Shades of Milk and Honey','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Bruce Sterling','Schismatrix','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Karen Joy Fowler','Sarah Canary','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Nalo Hopkinson','The Salt Roads','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Avram Davidson','Rogue Dragon','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Richard Cowper','The Road to Corlay','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Larry Niven','Ringworld','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Russell Hoban','Riddley Walker','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Arthur C. Clarke','Rendezvous With Rama','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Barry N. Malzberg','The Remaking of Sigmund Freud','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'John E. Stith','Redshift Rendezvous','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Linda Nagata','The Red: First Light','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Orson Scott Card','Red Prophet','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Kim Stanley Robinson','Red Mars','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Tobias S. Buckell','Ragamuffin','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'A.A. Attanasio','Radix','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Catherine Asaro','The Quantum Rose','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ellen Kushner','The Privilege of the Sword','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Orson Scott Card','Prentice Alvin','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'David Brin','The Postman','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jack McDevitt','Polaris','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Keith Laumer','A Plague of Demons','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Robert A. Metzger','Picoverse','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Joanna Russ','Picnic on Paradise','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'China Miéville','Perdido Street Station','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'R.A. Lafferty','Past Master','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Octavia E. Butler','Parable of the Talents','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Octavia E. Butler','Parable of the Sower','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula K. Le Guin','The Other Wind','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'John C. Wright','Orphans of Chaos','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Robert Stallman','The Orphan','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'John Barnes','Orbital Resonance','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'James K. Morrow','Only Begotten Daughter','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Thomas M. Disch','On Wings of Song','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jack McDevitt','Omega','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jack McDevitt','Odyssey','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'William S. Burroughs','Nova Express','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gene Wolfe','Nightside the Long Sun','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Nalo Hopkinson','The New Moon!s Arms','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'William Gibson','Neuromancer','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'M.K. Hobson','The Native Star','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Greg Bear','Moving Mars','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Larry Niven','The Mote in God!s Eye','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Robert A. Heinlein','The Moon Is a Harsh Mistress','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'William Gibson','Mona Lisa Overdrive','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Sean Stewart','Mockingbird','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Walter Tevis','Mockingbird','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Maureen F. McHugh','Mission Child','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Katherine MacLean','The Missing Man','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'John Barnes','A Million Open Doors','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Nalo Hopkinson','Midnight Robber','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Walter Jon Williams','Metropolitan','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Lois McMaster Bujold','Memory','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Genevieve Valentine','Mechanique: A Tale of the Circus Tresaulti','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Robert Silverberg','The Masks of Time','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Valerie Martin','Mary Reilly','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Geoffrey A. Landis','Mars Crossing','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Kate Wilhelm','Margaret and I','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Julian May','The Many-Colored Land','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jack Dann','The Man Who Melted','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Terry Pratchett','Making Money','Nebula Award');\
            COMMIT; ")
    except Exception as e:
        log("Error in creating new Book Awards [1]")
        log( bytes(e))
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass

    try:
        my_cursor.execute("\
            BEGIN TRANSACTION; \
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jack Vance','Lyonesse','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'John Crowley','Little, Big','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Cory Doctorow','Little Brother','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Kathleen Ann Goonan','Light Music','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula K. Le Guin','The Left Hand of Darkness','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Catherine Asaro','The Last Hawk','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gene Wolfe','The Knight','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'N.K. Jemisin','The Kingdom of Gods','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Kate Elliott','King!s Dragon','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'N.K. Jemisin','The Killing Moon','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Leigh Kennedy','The Journal of Nicholas the American','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Susanna Clarke','Jonathan Strange & Mr Norrell','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Robert A. Heinlein','Job: A Comedy of Justice','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Frederik Pohl','Jem','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'John Brunner','The Jagged Orbit','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Mike Resnick','Ivory: A Legend of Past and Future','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Tina Connolly','Ironskin','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Italo Calvino','Invisible Cities','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Larry Niven','Inferno','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gregory Benford','In the Ocean of Night','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'N.K. Jemisin','The Hundred Thousand Kingdoms','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Harry Turtledove','How Few Remain','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Marion Zimmer Bradley','The Heritage of Hastur','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Brian Aldiss','Helliconia Winter','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Brian Aldiss','Helliconia Spring','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Algis Budrys','Hard Landing','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'T.J. Bass','Half Past Human','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jonathan Lethem','Gun, With Occasional Music','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Kim Stanley Robinson','Green Mars','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gregory Benford','Great Sky River','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'John Kessel','Good News From Outer Space','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Terry Pratchett','Going Postal','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Kameron Hurley','God!s War','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Katherine Addison','The Goblin Emperor','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Mary Robinette Kowal','Glamour in Glass','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jeffrey Ford','The Girl in the Glass','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Thomas M. Disch','The Genocides','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Frederik Pohl','Gateway','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'George R.R. Martin','A Game of Thrones','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Lewis Shiner','Frontera','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Richard Bowes','From the Files of the Time Rangers','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gene Wolfe','Free Live Free','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'R.A. Lafferty','Fourth Mansions','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Isaac Asimov','Foundation!s Edge','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Greg Bear','The Forge of God','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Joe Haldeman','The Forever War','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Joe Haldeman','Forever Peace','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Charles de Lint','Forests of the Heart','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Philip K. Dick','Flow My Tears, the Policeman Said','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Laura Anne Gilman','Flesh and Fire','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jack McDevitt','Firebird','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Charles E. Gannon','Fire With Fire','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Vernor Vinge','A Fire Upon the Deep','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jeff VanderMeer','Finch','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jo Walton','Farthing','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Lois McMaster Bujold','Falling Free','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Dan Simmons','The Fall of Hyperion','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'C.J. Cherryh','The Faded Sun: Kesrith','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Tim Powers','Expiration Date','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jeffrey Carver','Eternity!s End','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Hayden Howard','The Eskimo Invasion','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'James White','The Escape Orbit','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Orson Scott Card','Ender!s Game','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'China Miéville','Embassytown','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jack McDevitt','Echo','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Frank Herbert','Dune','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'George Turner','Drowning Towers','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Caitlín R. Kiernan','The Drowning Girl','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Philip K. Dick','Dr. Bloodmoney, or How We Got Along After the Bomb','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Cory Doctorow','Down and Out in the Magic Kingdom','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Connie Willis','Doomsday Book','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Philip K. Dick','Do Androids Dream of Electric Sheep?','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula K. Le Guin','The Dispossessed','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Lois McMaster Bujold','Diplomatic Immunity','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Tim Powers','Dinner at Deviant!s Palace','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Bruce Sterling','The Difference Engine','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Neal Stephenson','The Diamond Age','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'R.A. Lafferty','The Devil Is Dead','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Lewis Shiner','Deserted Cities of the Heart','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Vernor Vinge','A Deepness in the Sky','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Martha Wells','Death of the Necromancer','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Greg Bear','Darwin!s Radio','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Kathleen Ann Goonan','Crescent City Rhapsody','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'William Gibson','Count Zero','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jack McDevitt','Coming Home','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Wil McCarthy','The Collapsium','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Theodore L. Thomas','The Clone','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gene Wolfe','The Claw of the Conciliator','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'George R.R. Martin','A Clash of Kings','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Lois McMaster Bujold','A Civil Campaign','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Walter Jon Williams','City on Fire','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'China Miéville','The City & the City','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gene Wolfe','The Citadel of the Autarch','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Piers Anthony','Chthon','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jack McDevitt','Chindi','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Maureen F. McHugh','China Mountain Zhang','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Paul Park','Celestis','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jack McDevitt','Cauldron','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ken MacLeod','The Cassini Division','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gene Wolfe','Calde of the Long Sun','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Norman Spinrad','Bug Jack Barron','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jane Yolen','Briar Rose','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Cherie Priest','Boneshaker','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Michael Swanwick','Bones of the Earth','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Emma Bull','Bone Dance','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'James Blish','Black Easter','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Tanith Lee','The Birthgrave','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Frederik Pohl','Beyond the Blue Event Horizon','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Nancy Kress','Beggars in Spain','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Nancy Kress','Beggars and Choosers','Nebula Award');\
            COMMIT; ")
    except Exception as e:
        log("Error in creating new Book Awards [2]")
        log( bytes(e))
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass
    try:
        my_cursor.execute("\
            BEGIN TRANSACTION; \
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Lois McMaster Bujold','Barrayar','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Samuel R. Delany','Babel-17','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Kevin J. Anderson','Assemblers of Infinity','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jeff VanderMeer','Annihilation','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Joanna Russ','And Chaos Died','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ann Leckie','Ancillary Sword','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Neil Gaiman','American Gods','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Clifford D. Simak','All Flesh Is Grass','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Gregory Benford','Against Infinity','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Thomas M. Disch','334','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Randall Munroe','Xkcd: Time','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'John Chu','The Water That Falls on You From Nowhere','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Liu Cixin','The Three-Body Problem','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Charlie Jane Anders','Six Months, Three Days','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Brian K. Vaughan','Saga, Volume 1','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'G. Willow Wilson','Ms. Marvel, Vol. 1: No Normal','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ken Liu','Mono No Aware','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula Vernon','Digger: The Complete Omnibus','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula Vernon','Digger, Volume Two','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula Vernon','Digger, Volume Three','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula Vernon','Digger, Volume Six','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula Vernon','Digger, Volume One','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula Vernon','Digger, Volume Four','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ursula Vernon','Digger, Volume Five','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Thomas Olde Heuvelt','The Day the World Turned Upside Down','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Lynne M. Thomas','Chicks Dig Time Lords: A Celebration of Doctor Who by the Women Who Love It','Hugo Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Hank Phillippi Ryan','Writes of Passage: Adventures on the Writer!s Journey','Agatha Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Jeff VanderMeer','Wonderbook: The Illustrated Guide to Creating Imaginative Fiction','Locus Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Rocky Wood','Witch Hunts: A Graphic History of the Burning Times','Bram Stoker Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Ron Chernow','Washington: A Life','Pulitzer Prize');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'George R.R. Martin','Warriors','Locus Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Peter S. Beagle','Two Hearts','Nebula Award');\
            INSERT OR IGNORE INTO _book_awards VALUES (NULL,'Hank Phillippi Ryan','Truth Be Told','Agatha Award');\
            COMMIT; ")
    except Exception as e:
        log("Error in creating new Book Awards [3]")
        log( bytes(e))
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass

    try:
        my_cursor.execute("\
            BEGIN TRANSACTION; \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Kim Stanley Robinson','2312','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Vijay Seshadri','3 Sections','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'George R.R. Martin','A Dance with Dragons','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Charles Todd','A Question of Honor','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Richard Peck','A Year Down Yonder','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'James S.A. Corey','Abaddon!s Gate','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Eric J. Guignard','After Death...','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'John Curran','Agatha Christie!s Secret Notebooks','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Connie Willis','All Clear','Hugo Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Connie Willis','All Clear','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Erik Dussere','America Is Elsewhere: The Noir Tradition in the Age of Consumer Culture','Edgar Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'F. Paul Wilson','An Enemy of the State','Prometheus Hall of Fame Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Ann Leckie','Ancillary Justice','Hugo Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Ann Leckie','Ancillary Justice','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Ann Leckie','Ancillary Justice','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Jon Lellenberg','Arthur Conan Doyle: A Life in Letters','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Sarah Langan','Audrey!s Door','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'David Ferry','Bewilderment: New Poems and Translations','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Benjamin Kane Ethridge','Black and Orange','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Connie Willis','Blackout','Hugo Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Connie Willis','Blackout','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Steve Rasnic Tem','Blood Kin','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Richard Hammond','Can You Feel the Force?','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Lynne M. Thomas','Chicks Dig Time Lords: A Celebration of Doctor Who & the Women Who Love It','Hugo Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Phillip M. Hoose','Claudette Colvin: Twice Toward Justice','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Jared Diamond','Collapse: How Societies Choose to Fail or Succeed','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'John Emsley','Consumer!s Good Chemical Guide: A Jargon Free Guide to the Chemicals of Everyday Life','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Avi','Crispin: The Cross of Lead','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Philip Ball','Critical Mass: How One Thing Leads to Another','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Kwame Alexander','Crossover','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Elena Santangelo','Dame Agatha!s Shorts','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Leslie Budewitz','Death al Dente','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'G.M. Malliet','Death of a Cozy Writer','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Gregory Pardlo','Digest','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'William Gibson','Distrust That Particular Flavor','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Stephen King','Doctor Sleep','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Tom Bouman','Dry Bones in the Valley','Edgar Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Jonathan Maberry','Dust and Decay','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'David Bodanis','Electric Universe: How Electricity Switched on the Modern World','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Fredrik Logevall','Embers Of War: The Fall of an Empire and the Making of America!s Vietnam','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Elizabeth A. Fenn','Encounters at the Heart of the World: A History of the Mandan People','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Charles Stross','Equoid','Hugo Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Gary K. Wolfe','Evaporating Genres: Essays on Fantastic Literature','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Louise Glück','Faithful and Virtuous Night: Poems','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Lois McMaster Bujold','Falling Free','Prometheus Hall of Fame Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Jonathan Maberry','Flesh and Bone','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Joe McKinney','Flesh Eaters','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Kate DiCamillo','Flora and Ulysses: The Illuminated Adventures','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'John Lewis Gaddis','George F. Kennan: An American Life','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'William Alexander','Goblin Secrets','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Laura Amy Schlitz','Good Masters! Sweet Ladies!: Voices from a Medieval Village','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Nikky Finney','Head Off & Split','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'F. Paul Wilson','Healer','Prometheus Hall of Fame Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Louis Sachar','Holes','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Kathy Lynn Emerson','How to Write Killer Historical Mysteries: The Art & Adventure of Sleuthing Through the Past','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Mary Szybist','Incarnadine: Poems','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Thanhha Lai','Inside Out & Back Again','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Sinclair Lewis','It Can!t Happen Here','Prometheus Hall of Fame Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Paul Fleischman','Joyful Noise: Poems for Two Voices','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'China Miéville','Kraken','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Sara J. Henry','Learning to Swim','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Tim Weiner','Legacy of Ashes: The History of the CIA','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Russell Freedman','Lincoln: A Photobiography','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Susan M. Boyer','Lowcountry Boil','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Manning Marable','Malcolm X: A Life of Reinvention','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Robert Kunzig','Mapping the Deep: The Extraordinary Story of Ocean Science','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Megan Marshall','Margaret Fuller: A New American Life','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Stephen King','Mr. Mercedes','Edgar Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Maria Alexander','Mr. Wicker','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Rhys Bowen','Naughty in Nice','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'George R.R. Martin','Old Mars','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Lois McMaster Bujold','Paladin of Souls','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Arno Karlen','Plague!s Progress: A Social History Of Man And Disease','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Ursula K. Le Guin','Powers','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Rhys Bowen','Queen of Hearts','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'China Miéville','Railsea','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'William H. Patterson Jr.','Robert A. Heinlein: In Dialogue with His Century: Volume 1 : Learning Curve','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Jack McDevitt','Seeker','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Phyllis Reynolds Naylor','Shiloh','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Paolo Bacigalupi','Ship Breaker','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Catherynne M. Valente','Silently and Very Fast','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Lucy A. Snyder','Soft Apocalypses','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Cathy Fenner','Spectrum 20: The Best in Contemporary Fantastic Art','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Sharon Olds','Stag!s Leap: Poems','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Rocky Wood','Stephen King: A Literary Companion','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Richard Holmes','The Age of Wonder: How the Romantic Generation Discovered the Beauty and Terror of Science','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Charles Stross','The Apocalypse Codex','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'James Klise','The Art of Secrets','Edgar Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Connie Willis','The Best of Connie Willis: Award-Winning Stories','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Kay Ryan','The Best of It: New and Selected Poems','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Chris Grabenstein','The Black Heart Crypt','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Chris Grabenstein','The Crossroads','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Ursula K. Le Guin','The Dispossessed','Prometheus Hall of Fame Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Siddhartha Mukherjee','The Emperor of All Maladies: A Biography of Cancer','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Brandon Sanderson','The Emperor!s Soul','Hugo Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Eric Foner','The Fiery Trial: Abraham Lincoln and American Slavery','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'T.J. Stiles','The First Tycoon: The Epic Life of Cornelius Vanderbilt','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'T.J. Stiles','The First Tycoon: The Epic Life of Cornelius Vanderbilt','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Catherynne M. Valente','The Girl Who Circumnavigated Fairyland in a Ship of Her Own Making','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Catherynne M. Valente','The Girl Who Soared Over Fairyland and Cut the Moon in Two','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Lois Lowry','The Giver','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Chris Grabenstein','The Hanging Hill','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Susan Patron','The Higher Power of Lucky','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Daniel Stashower','The Hour of Peril: The Secret Plot to Murder Lincoln Before the Civil War','Edgar Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'N.K. Jemisin','The Hundred Thousand Kingdoms','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Robert Shea','The Illuminatus! Trilogy: The Eye in the Pyramid/The Golden Apple/Leviathan','Prometheus Hall of Fame Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'David Lambert','The Kingfisher Young People!s Book of Oceans','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Rachel Swirsky','The Lady Who Plucked Red Flowers Beneath the Queen!s Window','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Sarah Masters Buckey','The Light in the Cellar: A Molly Mystery','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Avery Aames','The Long Quiche Goodbye','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'J.R.R. Tolkien','The Lord of the Rings','Prometheus Hall of Fame Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Paul Hoffman','The Man Who Loved Only Numbers: The Story of Paul Erdős and the Search for Mathematical Truth','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Ted Chiang','The Merchant and the Alchemist!s Gate','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Karen Cushman','The Midwife!s Apprentice','Newbery Medal'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Penny Warner','The Mummy!s Curse','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Adam Johnson','The Orphan Master!s Son','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'David I. Kertzer','The Pope and Mussolini: The Secret History of Pius XI and the Rise of Fascism in Europe','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Nancy Holder','The Screaming Season','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Chris Abani','The Secret History of Las Vegas: A Novel','Edgar Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Neil Gaiman','The Sleeper and the Spindle','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Alan Bradley','The Sweetness at the Bottom of the Pie','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Stephen Greenblatt','The Swerve: How the World Became Modern','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'George Packer','The Unwinding: An Inner History of the New America','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Usman T. Malik','The Vaporization Enthalpy of a Peculiar Pakistani Family','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Alan Walker','The Wisdom of the Bones: In Search of Human Origins','Royal Society Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Kage Baker','The Women of Nell Gwynne!s','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Hank Phillippi Ryan','The Wrong Girl','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Michael Chabon','The Yiddish Policemen!s Union','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Margaret Maron','Three-Day Town','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Saladin Ahmed','Throne of the Crescent Moon','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Dan Fagin','Toms River: A Story of Science and Salvation','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Keith Waldrop','Transcendental Studies: A Trilogy','National Book Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Lisa Morton','Trick or Treat: A History of Halloween','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Nina Kiriki Hoffman','Trophy Wives: A Short Story','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Vernor Vinge','True Names: and the Opening of the Cyberspace Frontier','Prometheus Hall of Fame Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Hank Phillippi Ryan','Truth Be Told','Agatha Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Peter S. Beagle','Two Hearts','Nebula Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'George R.R. Martin','Warriors','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Ron Chernow','Washington: A Life','Pulitzer Prize'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Rocky Wood','Witch Hunts: A Graphic History of the Burning Times','Bram Stoker Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Jeff VanderMeer','Wonderbook: The Illustrated Guide to Creating Imaginative Fiction','Locus Award'); \
            INSERT OR IGNORE INTO _book_awards VALUES(NULL,'Hank Phillippi Ryan','Writes of Passage: Adventures on the Writer!s Journey','Agatha Award'); \
            COMMIT; ")
    except Exception as e:
        log("Error in creating new Book Awards [2]")
        log(as_unicode(e))
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass



    #-------------------------------------------------------------------------------------------------------------------------------------------------------------
    #Warning:  More than 5 spaces in a Work Tag *may* cause its deletion since it might be presumed to be junk/trash/erroneous/undesirable.

    #-------------------------------- new _book_awards go above this line -----------------------------------------------------------------------------------
    #-------------------------------- new _book_awards go above this line -----------------------------------------------------------------------------------
    #-------------------------------- new _book_awards go above this line -----------------------------------------------------------------------------------

    try:
        s1 = "!"
        s2 = "'"
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "UPDATE OR IGNORE _book_awards SET title =(replace(title,?,?)) "
        my_cursor.execute(mysql,(s1,s2))
        mysql = "UPDATE OR IGNORE _book_awards SET author =(replace(author,?,?)) "
        my_cursor.execute(mysql,(s1,s2))
        mysql = "UPDATE OR IGNORE _book_awards SET award =(replace(award,?,?)) "
        my_cursor.execute(mysql,(s1,s2))
        my_cursor.execute("COMMIT")
    except Exception as e:
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass

    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "DELETE FROM _book_awards WHERE author LIKE '%!%'  "
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _book_awards WHERE title LIKE '%!%'  "
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _book_awards WHERE award LIKE '%!%'  "
        my_cursor.execute(mysql)
        my_cursor.execute("COMMIT")
    except Exception as e:
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass

    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "DELETE FROM _global_authors WHERE name != trim(name)"
        my_cursor.execute(mysql)
        my_cursor.execute("COMMIT")
    except Exception as e:
        log(as_unicode(e))
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass


    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "INSERT OR IGNORE INTO _global_authors SELECT null,trim(author),' ',' '  FROM _book_awards WHERE trim(author) NOT IN(SELECT name FROM _global_authors)"
        my_cursor.execute(mysql)
        my_cursor.execute("COMMIT")
    except Exception as e:
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass

    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "DELETE FROM _global_authors WHERE name = 'Giedra Radvilavi i t' "
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _global_authors WHERE name = ''Juan Gabriel V squez"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _global_authors WHERE name = 'Jr.' "
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _global_authors WHERE name LIKE '% and %' "
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _pristine_authors WHERE name LIKE '% and %' "
        my_cursor.execute(mysql)
        my_cursor.execute("COMMIT")
    except Exception as e:
        try:
            my_cursor.execute("commit")    #to avoid any job failures due to an outstanding BEGIN TRANSACTION created elsewhere
        except:
            pass

