# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "3.6.110"  
import os, sys
import apsw, ast
from copy import deepcopy
import datetime
from difflib import SequenceMatcher
import re
from time import sleep
import time
from calibre import isbytestring
from calibre.constants import filesystem_encoding, DEBUG
from calibre.db.backend import DB
from calibre.gui2 import error_dialog, info_dialog
from calibre.utils.logging import Log as log
from polyglot.builtins import as_bytes, as_unicode, is_py3, iteritems, map, range, unicode_type
from polyglot.queue import Queue
from calibre_plugins.quarantine_and_scrub.config import prefs
from calibre_plugins.quarantine_and_scrub.titlecase import titlecase
from calibre_plugins.quarantine_and_scrub.copywork import (convert_identifiers_isbn_from_10_to_13,
                                                                    convert_isbn_check_digit_13, convert_isbn_convert_10_to_13)
from calibre_plugins.quarantine_and_scrub.heading import log_heading_common
from calibre_plugins.quarantine_and_scrub.booklevel_keywords import remove_bad_keywords
from calibre_plugins.quarantine_and_scrub.convert_types_to_other_types import (qs_standardize_any_string,
                                              qs_convert_list_of_nominal_book_ids_to_integers, qs_standardize_string_numerics)
from calibre_plugins.quarantine_and_scrub.debug_nicely import debug_nicely
notifications = Queue()
author_in_title = False
author_is_probably_good = False
author_is_really_title = False
author_is_valid_globally = False
book_awards_list = []
book_is_frozen = False
can_force_update_of_series = False
freeze_current_book = False
is_finished_scrub_title_index_series_in_title = False
is_finished_scrub_title_series_index_in_title = False
is_scrubbable = True
list_of_known_authors = []
list_of_known_books_swapped_author = []
my_book_ids_list = []
my_current_book_id = 0
my_guidb = ""
my_plugin_path = ""
my_terminate_early = False
partial_blankout_scenario = False
probable_seriesname_to_add_list = []
probable_tags_to_add_list = []
re_already_imported = False
scrubbed_books_final_list = []
series_in_author = False
series_in_title = False
series_is_valid_globally = False
series_re_pattern_to_remove = ""
series_regex_rules_list = []
seriesindex_is_probably_good = False
single_work_tags_all_list = []
tag_capitalization_regex_rules_list = []
tag_regex_rules_list = []
title_cc_control_rules_list = []
title_in_author = False
title_is_frozen = False
title_is_probably_good = False
title_regex_rules_list = []
work_author_name = ""
work_author_sort = ""
work_series_name = ""
work_title_name = ""
set_of_letters = set()
for c in 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZäëöüÜËÄÖáéíóúñçãÕõ':
    set_of_letters.add(c)
set_of_numbers =  set('0123456789')
set_of_symbols = set(".,[]{}|?!=;:-_=+*#@&!`~\\//")
set_of_symbols.add('"')
set_of_symbols.add("'")
set_of_symbols.add("'.,&-")
set_of_author_symbols = set("'.,&-")
set_of_numbers_letters = deepcopy(set_of_letters)
set_of_numbers_letters.add('0123456789')
set_of_numbers_letters_spaces = deepcopy(set_of_numbers_letters)
set_of_numbers_letters_spaces.add(" ")
set_of_numbers_letters_spaces.add("  ")
set_of_letters_and_author_symbols = deepcopy(set_of_letters)
set_of_letters_and_author_symbols.add("'.,&-")
set_of_title_characters = deepcopy(set_of_numbers_letters)
set_of_title_characters.add(".,[]{}|?!=;:-_=+*#@&!`~\\//")
set_of_numbers_and_symbols = deepcopy(set_of_numbers)
set_of_numbers_and_symbols.add(".,[]{}|?!=;:-_=+*#@&!`~\\//")
set_of_re_metacharacters = set(".^$*+?{}[]\|()")
fancy_quotes_set = set()
fancy_quotes_set.add("«")
fancy_quotes_set.add("‹")
fancy_quotes_set.add("»")
fancy_quotes_set.add("›")
fancy_quotes_set.add("„")
fancy_quotes_set.add("“")
fancy_quotes_set.add("‟")
fancy_quotes_set.add("”")
fancy_quotes_set.add("’")
fancy_quotes_set.add("❝")
fancy_quotes_set.add("❞")
fancy_quotes_set.add("❮")
fancy_quotes_set.add("❯")
fancy_quotes_set.add("⹂")
fancy_quotes_set.add("〝")
fancy_quotes_set.add("〞")
fancy_quotes_set.add("〟")
fancy_quotes_set.add("＂")
fancy_quotes_set.add("‚")
fancy_quotes_set.add("‘")
fancy_quotes_set.add("‛")
fancy_quotes_set.add("❛")
fancy_quotes_set.add("❜")
fancy_quotes_set.add("❟")
header_s1 = None
header_s2 = None
header_s3 = None
header_s4 = None
header_s5 = None
def main_scrub_book_level(self, guidb, book_ids, scrubbed_books_final, my_plugin_path, log=None, abort=None, notifications=True):
    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    global my_terminate_early
    global my_book_ids_list
    global scrubbed_books_final_list
    global my_guidb
    scrubbed_books_final_list = []
    sleep(0)
    my_guidb = guidb
    path = my_guidb.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')
    log("Library DB: " + path)
    try:
        my_db =apsw.Connection(path)
    except Exception as e:
        log(as_unicode(e))
        raise e
        return
    my_cursor = my_db.cursor()
    header_s1 =  "SQLite Version: " + as_unicode(apsw.SQLITE_VERSION_NUMBER) + "  [APSW]"
    header_s2  = "Database is SHARED, not EXCLUSIVE"
    header_s3 = "Beginning Book Level Scrubbing"
    log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
    mysql = "PRAGMA main.busy_timeout = 15000;"    
    my_cursor.execute(mysql)
    sleep(0.01)
    notifications.put((0.001, 'Doing Light Housekeeping Prior to Scrubbing'))
    my_book_ids_list = deepcopy(book_ids)
    del book_ids
    my_book_ids_list = qs_convert_list_of_nominal_book_ids_to_integers(my_book_ids_list)
    not_frozen_list = list(my_cursor.execute("SELECT book,value FROM custom_column_16 WHERE value = 0 AND book IS NOT NULL ") )
    not_frozen_set = set()
    for row in not_frozen_list:
        book,value = row
        not_frozen_set.add(book)
    book_ids = []
    for book in my_book_ids_list:
        if book in not_frozen_set:
            book_ids.append(book)
    log("Number of books originally selected: " + as_unicode(len(my_book_ids_list)) )
    log("Number of books already frozen or having no Work Data: " + as_unicode(len(my_book_ids_list) - len(not_frozen_set)) )
    log("Number of books to be scrubbed: " + as_unicode(len(book_ids)) )
    my_book_ids_list = deepcopy(book_ids)
    del book_ids
    del not_frozen_set
    del not_frozen_list
    change_work_series_full_to_standard(my_db,my_cursor,log)
    fix_author_name_null(my_db,my_cursor,log)
    titlecase_authors(my_db,my_cursor,notifications,log)
    remove_all_double_quotes(my_db,my_cursor,notifications,log)
    add_title_rule_table_rules(my_db,my_cursor,log)
    Create_SQLite_User_Functions(my_db,my_cursor,log)
    build_regex_list_from_tag_rules(my_db,my_cursor,log)
    build_regex_list_from_tag_capitalization_rules(my_db,my_cursor,log)
    build_regex_list_from_title_rules(my_db,my_cursor,log)
    build_regex_list_from_series_rules(my_db,my_cursor,log)
    build_rules_list_from_title_cc_control(my_db,my_cursor,log)
    build_book_awards_list(my_db,my_cursor,log)
    delete_unused_values(my_db,my_cursor,notifications,log)
    explode_custom_column_4_if_needed(my_db,my_cursor,log)
    explode_custom_column_8_if_needed(my_db,my_cursor,log)
    explode_custom_column_10_if_needed(my_db,my_cursor,log)
    explode_custom_column_13_if_needed(my_db,my_cursor,log)
    update_table_books_work(my_db,my_cursor,log)
    Scrub_Control(my_db,my_cursor,my_book_ids_list,notifications,log)
    notifications.put((0.99, 'Doing Final Light Housekeeping'))
    purge_transient_tables(my_db,my_cursor,log)
    sleep(0)
    my_db.close()
    scrubbed_books_final = deepcopy(scrubbed_books_final_list)
    log("Job complete.")
    notifications.put((0.99, 'Job is Complete.'))
    return scrubbed_books_final
def Scrub_Control(my_db,my_cursor,my_book_ids_list,notifications,log):
    log("Beginning Scrubbing")
    notifications.put((0.1, 'Beginning Book Level Scrubbing'))
    global author_is_probably_good
    global author_is_really_title
    global author_is_valid_globally
    global book_is_frozen
    global can_force_update_of_series
    global freeze_current_book
    global is_finished_scrub_title_index_series_in_title
    global is_finished_scrub_title_series_index_in_title
    global is_scrubbable
    global probable_seriesname_to_add_list
    global probable_tags_to_add_list
    global scrubbed_books_final_list
    global series_is_valid_globally
    global seriesindex_is_probably_good
    global single_work_tags_all_list
    global tags_to_subjects_list
    global title_is_frozen
    global title_is_probably_good
    single_work_tags_all_list  = []
    probable_seriesname_to_add_list = []
    probable_tags_to_add_list = []
    n0 = len(my_book_ids_list)
    log(" ")
    log(as_unicode(n0) + " Book(s) Being Scrubbed")
    if not n0 > 0:
        return
    my_counter = 0
    scrubbed_so_far = 0
    n1 = 0
    for my_current_book in my_book_ids_list:
        my_counter = my_counter + 1
        scrubbed_so_far = scrubbed_so_far + 1
        author_is_probably_good = False
        author_is_really_title = False
        author_is_valid_globally = False
        book_is_frozen = False
        can_force_update_of_series = False
        freeze_current_book = False
        is_finished_scrub_title_index_series_in_title = False
        is_finished_scrub_title_series_index_in_title = False
        is_scrubbable = True
        probable_seriesname_to_add_list[:] = []
        probable_tags_to_add_list[:] = []
        series_is_valid_globally = False
        seriesindex_is_probably_good = False
        title_is_frozen = False
        title_is_probably_good = False
        scrub_with_special_custom_column_title_cc_control_rules(my_db,my_cursor,my_current_book,notifications,log)
        scrub_manga_control(my_db,my_cursor,my_current_book,notifications,log)
        scrub_comicbook_control(my_db,my_cursor,my_current_book,notifications,log)
        scrub_magazine_control(my_db,my_cursor,my_current_book,notifications,log)
        if is_scrubbable:
            scrub_first_first_author(my_db,my_cursor,my_current_book,notifications,log)
            scrub_first_first_title(my_db,my_cursor,my_current_book,notifications,log) 
            scrub_first_first_series(my_db,my_cursor,my_current_book,notifications,log) 
            check_title_for_valid_patterns_to_not_scrub(my_db,my_cursor,my_current_book,notifications,log)
            scrub_author_name_goofy(my_db,my_cursor,my_current_book,notifications,log)       
            check_title_against_global_author_valid_values(my_db,my_cursor,my_current_book,notifications,log)
            scrub_isbn_in_author(my_db,my_cursor,my_current_book,notifications,log)
            scrub_isbn_in_title(my_db,my_cursor,my_current_book,notifications,log)
            scrub_the_lewis_the_lover_scenario(my_db,my_cursor,my_current_book,notifications,log)
            check_title_for_special_patterns_to_genericize(my_db,my_cursor,my_current_book,notifications,log)
            derive_tags_from_comments(my_db,my_cursor,my_current_book,notifications,log)
            scrub_misc_title_issues(my_db,my_cursor,my_current_book,notifications,log)            
            scrub_author_name_commas(my_db,my_cursor,my_current_book,notifications,log)   
            scrub_author_name_initials(my_db,my_cursor,my_current_book,notifications,log)      
            check_title_against_global_author_valid_values(my_db,my_cursor,my_current_book,notifications,log)
            check_author_against_global_valid_values(my_db,my_cursor,my_current_book,notifications,log)
            check_if_author_is_not_author_and_title_is_not_author(my_db,my_cursor,my_current_book,notifications,log)
            scrub_misc_title_issues(my_db,my_cursor,my_current_book,notifications,log)            
            check_title_for_valid_patterns_to_not_scrub(my_db,my_cursor,my_current_book,notifications,log)
            scrub_good_series_also_in_title(my_db,my_cursor,my_current_book,notifications,log)
            check_series_against_global_valid_values(my_db,my_cursor,my_current_book,notifications,log)
            check_title_against_global_author_valid_values(my_db,my_cursor,my_current_book,notifications,log)
            scrub_title_is_author_index_series(my_db,my_cursor,my_current_book,notifications,log)
            check_title_against_global_author_valid_values(my_db,my_cursor,my_current_book,notifications,log)
            scrub_title_is_author_series_index(my_db,my_cursor,my_current_book,notifications,log)
            scrub_switched_author_title(my_db,my_cursor,my_current_book,notifications,log)                     
            scrub_author_is_title_but_title_is_title_with_author_too(my_db,my_cursor,my_current_book,notifications,log)
            scrub_title_index_series_in_title(my_db,my_cursor,my_current_book,notifications,log)
            scrub_series_substring_across_author(my_db,my_cursor,my_current_book,notifications,log)                    
            scrub_series_substring(my_db,my_cursor,my_current_book,notifications,log)                                          
            scrub_obvious_series_still_in_title_within_delimiters(my_db,my_cursor,my_current_book,notifications,log)
            scrub_obvious_series_still_in_title_with_no_delimiters(my_db,my_cursor,my_current_book,notifications,log)
            check_title_against_global_author_valid_values(my_db,my_cursor,my_current_book,notifications,log)
            scrub_author_good_but_author_also_in_title(my_db,my_cursor,my_current_book,notifications,log)
            scrub_worktitle_workseries_swapped(my_db,my_cursor,my_current_book,notifications,log)
            scrub_work_series_with_numerics(my_db,my_cursor,my_current_book,notifications,log)
            scrub_misc_title_scenarios(my_db,my_cursor,my_current_book,notifications,log)
            check_title_against_global_author_valid_values(my_db,my_cursor,my_current_book,notifications,log)
            delete_unused_values(my_db,my_cursor,notifications,log)
            check_title_against_global_author_valid_values(my_db,my_cursor,my_current_book,notifications,log)
            scrub_final_author_title_switched(my_db,my_cursor,my_current_book,notifications,log)
            scrub_worktitle_workseries_swapped(my_db,my_cursor,my_current_book,notifications,log)
            scrub_misc_title_issues(my_db,my_cursor,my_current_book,notifications,log)            
            scrub_final_work_series_format(my_db,my_cursor,my_current_book,notifications,log)
            scrub_final_final_title(my_db,my_cursor,my_current_book,notifications,log) 
            probable_tags_to_add_list = add_book_awards(my_db,my_cursor,my_current_book,notifications,log, probable_tags_to_add_list)     
            scrub_tags(my_db,my_cursor,my_current_book,notifications,log, probable_tags_to_add_list)    
            add_missing_seriesname_from_web_detail(my_db,my_cursor,my_current_book,notifications,log) #prior to refreshing cc 15
            refresh_custom_column_15(my_db,my_cursor,my_current_book,notifications,log)
            update_work_columns_for_utf8_display(my_db,my_cursor,my_current_book,notifications,log)
        else:
            freeze_current_book = True
        set_work_freeze(my_db,my_cursor,my_current_book,notifications,log)
        n1 = n1 + 1
        pc = float(n1/n0)
        notifications.put((pc, 'Book Level Scrubbing'))
        sleep(0.01)
        if  my_counter == 20 :
            log(" ")
            log("Books Scrubbed So Far: ", as_unicode(scrubbed_so_far))
            sleep(0.1)
            my_counter = 0
    log(" ")
    log("Total Books Scrubbed: ", as_unicode(scrubbed_so_far))
    log(" ")
    log("Now Doing Miscellaneous Scrubbing.  This is for all books in the current library that have *any* work-data whatsoever.  The progress indicator will remain at 99% during this (long) process.  Be patient.")
    log(" ")
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [1 of 10]: Adding Tag Combinations'))
    add_tag_combinations(my_db,my_cursor,notifications,log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [2 of 10]: Applying Tag String Replacement Rules'))
    apply_tag_string_replacement_rules(my_db,my_cursor,log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [3 of 10]: Erasing Unused Values'))
    delete_unused_values(my_db,my_cursor,notifications,log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [4 of 10]: Fixing Missing Series Indexes'))
    set_null_seriesname_index_to_zero(my_db,my_cursor,notifications,log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [5 of 10]: Doing Light Housekeeping'))
    insert_single_tags_into_work_tags_single(my_db,my_cursor,notifications,log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [6 of 10]: Converting ISBN 10 to 13'))
    convert_identifiers_isbn_from_10_to_13(my_db,my_cursor,log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [7 of 10]: Changing Work Title to Web Title as Needed'))
    change_work_title_to_web_title_for_previously_validated_work_series(my_db,my_cursor,notifications,log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [8 of 10]: Changing Work Series Index to Web Series Index as Needed'))
    miscellany_change_work_index_to_web_index_standalone(my_db,my_cursor,notifications,log)      
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [9 of 10]: Applying Author Mapping Rules'))
    apply_author_mapping_rules(my_db,my_cursor,my_current_book,notifications,log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [10 of 10]: Finishing'))
    titlecase_authors(my_db,my_cursor,notifications,log)
    log("Book-Level Scrubbing is complete.")
def apply_author_mapping_rules(my_db,my_cursor,my_current_book,notifications,log):
    mysql = "UPDATE custom_column_4 SET value =(SELECT newname FROM _author_mapping WHERE name = custom_column_4.value ) \
                    WHERE value IN(SELECT name FROM  _author_mapping WHERE name = custom_column_4.value AND newname NOT NULL AND name NOT NULL)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
def scrub_author_name_commas(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_probably_good
    global freeze_current_book
    auth_list = []
    authname = ""
    mysql = "SELECT authname,'dummy' from __books_work_populate WHERE book = ?  "
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            authname,dummy = row
            break
    else:
        return
    authname = authname.replace("  "," ")
    author_is_garbage = False
    s_new_author_name = authname
    if s_new_author_name.endswith(","):
        s_new_author_name = s_new_author_name[0:-1]
        author_is_garbage = True
    n1 = s_new_author_name.count("|")
    if n1 == 1:
        s_new_author_name = s_new_author_name.replace("|", ",")
        author_is_garbage = True
    else:
        pass
    n2 = s_new_author_name.count(",")
    if n2 == 1:
        s_split = s_new_author_name.split(",")
        s1 = s_split[0]
        s2 = s_split[1]
        s1 = s1.replace(" ", "")
        s2 = s2.replace(" ", "")
        s_new_author_name = s2 + " " + s1
        author_is_garbage = True
    else:
        pass
    if not author_is_garbage:
       return
    else:
        mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,s_new_author_name,my_current_book)
        author_is_probably_good = True
def scrub_author_name_initials(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_probably_good
    mysql = "SELECT authname,'dummy' from __books_work_populate WHERE book = ?  "
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            authname,dummy = row
            break
    else:
        return
    n = authname.count(" ")
    if n > 2 :            
        return
    else:
        s_new_author_name = titlecase(authname)
        s_new_author_name = reformat_author_initials(s_new_author_name)      
        if s_new_author_name != authname:
            mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                    (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,s_new_author_name,my_current_book)
            author_is_probably_good = True
def check_author_against_global_valid_values(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_valid_globally
    global author_is_probably_good
    if author_is_valid_globally:
        return    
    author_is_valid_globally = False
    tmp_global_auth_rows = []
    mysql = "SELECT authname,'dummy' FROM __books_work_populate WHERE book = ?  "
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            tmp_auth,dummy = row
            tmp_auth = tmp_auth.replace('"', "")
            mysql = 'SELECT name from _global_authors WHERE name = ? '
            tmp_global_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_auth)
            if not tmp_global_auth_rows:
                tmp_global_auth_rows = []
            if len(tmp_global_auth_rows) > 0:
                author_is_valid_globally = True
            else:
                mysql = 'SELECT name from _pristine_authors WHERE name = ?  '
                tmp_global_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_auth)
                if not tmp_global_auth_rows:
                    tmp_global_auth_rows = []
                if len(tmp_global_auth_rows) > 0:
                    author_is_valid_globally = True
            break
    del tmp_global_auth_rows
    if author_is_valid_globally:
        author_is_probably_good = True
        return
    else:
        mysql = 'SELECT value FROM __books_work_status WHERE book = ? AND value = "auth_ok";'
        tmp_global_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
        if not tmp_global_auth_rows:
            return
        if len(tmp_global_auth_rows) > 0:
            author_is_valid_globally = True
            author_is_probably_good = True
def check_title_against_global_author_valid_values(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_valid_globally
    global author_is_probably_good
    if author_is_valid_globally:
        return
    if author_is_probably_good:
        return
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return
    is_title_a_valid_author = False
    mysql = 'SELECT booktitle,book FROM __books_work_populate WHERE book = ?  '
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            booktitle,book = row
            booktitle = booktitle.strip()
            mysql = 'SELECT name,NULL from _global_authors WHERE name = ?  ' 
            tmp_global_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=booktitle)
            if tmp_global_auth_rows:
                for row in tmp_global_auth_rows:
                    name,dummy = row
                    if name == booktitle:
                        is_title_a_valid_author = True
                        author_is_valid_globally = True
                    break
                break
            else:
                return
    else:
        return    
    if is_title_a_valid_author:
        new_auth = booktitle
    else:
        return    
    new_title = None
    mysql = 'SELECT authname,NULL FROM __books_work_populate WHERE book = ?  '
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            authname,dummy = row
            new_title = authname.strip()
            break
    if new_title is None:
        return
    check_author_against_global_valid_values(my_db,my_cursor,my_current_book,notifications,log)
    if author_is_valid_globally:
        author_is_probably_good = True
        title_is_probably_good = True
        return
    new_title = new_title.strip()
    if new_title.endswith("-"):
        new_title = new_title[0:-1]
    new_title = new_title.strip()
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,v1=new_title,v2=my_current_book)
    title_is_probably_good = False
    mysql = "SELECT id,'dummy' from custom_column_4 WHERE value = ? "
    tmp_id_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=new_auth)
    if not tmp_id_rows:
        tmp_id_rows = []
    if len(tmp_id_rows) > 0:
        sleep(.05)
        tmp_id,dummy = tmp_id_rows[0]
        mysql = "UPDATE books_custom_column_4_link SET value = ? WHERE book = ?  "
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_id,my_current_book)
        author_is_valid_globally = True
    else:
        sleep(.05)
        mysql = "INSERT OR REPLACE INTO custom_column_4 (id,value) VALUES (?,?)"
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,'null', new_auth)
        sleep(.05)
        mysql = "SELECT id,'dummy' from custom_column_4  WHERE value = ?  "
        tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=new_auth)
        if not tmp_auth_rows:
            return    
        if len(tmp_auth_rows) == 0:
            return    
        tmp_id,dummy = tmp_auth_rows[0]
        sleep(.05)
        mysql = "DELETE FROM books_custom_column_4_link WHERE book = ?  "
        execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
        sleep(.05)
        mysql = "INSERT INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?)"
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_id)
        author_is_valid_globally = True
def check_title_for_valid_patterns_to_not_scrub(my_db,my_cursor,my_current_book,notifications,log):
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return
    mysql = 'SELECT booktitle,NULL FROM __books_work_populate WHERE book = ? '
    tmp_title_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_title_rows:
        if len(tmp_title_rows) > 0:
            for row in tmp_title_rows:
                booktitle,dummy = row
                tmp_title = booktitle
                break
        else:
            return    
    else:
        return    
    tmp_title = tmp_title.replace("  ", " ")            
    tmp_title = tmp_title.strip()
    regex_dict = {}
    regex_dict[1] = "^[a-zA-Z0-9].+\s[&]\s[a-zA-Z0-9-].+"             
    regex_dict[2] = '^[a-zA-Z].+\s[1-9][ -]Book\s[a-zA-Z ].+'          
    regex_dict[3] = '^[a-zA-Z ].+[,]*\sBooks\s[0-9]+[0-9-]+'           
    regex_dict[4] = '^[a-zA-Z].+[:]*\s[1-9][ -]Book\s[a-zA-Z ].+'     
    regex_dict[5] = '^[a-zA-Z].+[:]\s[aA][a-zA-Z ]*\sThriller'           
    regex_dict[6] = 'Novel\s[12][09][0-9][0-9]\s'                             
    regex_dict[7] = '^[a-zA-Z ].+\sDigital Edition$'                         
    regex_dict[8] = '^[a-zA-Z ].+\s[0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]$' 
    regex_dict[9] = '^Encyclopedia\sof\s.+:\sVolume\s[0-9]+'       
    regex_dict[10] = "^[a-z ]+[']s\s[a-z ]+$"                                    
    regex_dict[11] = "^[a-z ]+\s[0-9]+\s[a-z ]+$"                           
    regex_dict[12] = "^dr[.][ ][a-z ]+$"                                            
    regex_dict[13] = "^[!!!!!!!!!!!!!!!!!!!!!!!]$"
    num_of_good_regexes = 13   
    for i in range(1,(num_of_good_regexes + 1)):
        p = re.compile(regex_dict[i], re.IGNORECASE)
        match1 = p.search(tmp_title)
        if match1:
            if i == 8:
                ns = tmp_title.count(" ")
                nd = tmp_title.count("-")
                if ns > 1 or nd > 0:    
                    title_is_probably_good = True
                    title_is_frozen = True
                else:
                    pass
            else:
                title_is_probably_good = True
                title_is_frozen = True
                break
    regex_dict[100] = '\(.+\)'  
    regex_dict[101] = '\[.+\]'  
    regex_dict[102] = "^.+,[a-zA-Z]+"                                                           
    regex_dict[103] = "^.+?\s.+?\s[-]\s[a-zA-Z]+[0-9]+\s[-]\s.+"                  
    regex_dict[104] = "^.+,\s[a-zA-Z]+"                                                        
    regex_dict[105] = "^[a-z &]+[0-9]+[ -]+"                                               
    regex_dict[106] = "/^.+\d -/"
    regex_dict[107] = "/^.+\d-/" 
    regex_dict[108] = "/^.+\d:/" 
    regex_dict[109] = "/^.+\d :/" #matches:  "Isles 4 : " or "ZZZZZZZ 9 : " or "ZZZZZZZ 99 :" but only if space between number and colon
    regex_dict[110] = "\s-\s[a-zA-Z]+[0-9]+\s-\s"                                     
    regex_dict[111] = "^.+\s[IV23456]+\s-\s.+"                                        
    last_bad_regex = 111
    for i in range(100,last_bad_regex):
        p = re.compile(regex_dict[i], re.IGNORECASE)
        match = p.search(tmp_title)
        if match:
            title_is_probably_good = False
            title_is_frozen = False
            break
def check_title_for_special_patterns_to_genericize(my_db,my_cursor,my_current_book,notifications,log):
    global probable_seriesname_to_add_list
    global probable_tags_to_add_list
    global title_is_probably_good
    global author_is_probably_good
    global series_is_valid_globally
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return  
    new_title = ""
    tmp_title = ""
    mysql = "SELECT booktitle,NULL FROM __books_work_populate WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        for row in tmp_rows:
            booktitle,dummy = row
            break
    else:
        return 
    need_to_update_title = False
    need_to_update_auth = False
    force_update = False
    my_re1 = "^[a-z ]+\s[0-9]+\s[a-z ]+$"  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
        return   
    else:
        pass
    tmp_title = tmp_title.strip()
    s_old = tmp_title
    tmp_title = remove_bad_keywords(tmp_title)
    tmp_title = tmp_title.replace("()", "")  
    tmp_title = tmp_title.replace("[]", "")
    tmp_title = tmp_title.replace("{}", "")
    if s_old != tmp_title:
        new_title = tmp_title
        force_update = True
    my_re1 = "^[A-Z][A-Z][A-Z]*[ ]+[0-9]+[ ][-][ ][A-Z a-z '&]+$"
    p1 = re.compile(my_re1) 
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s_split = tmp_title.split("-")  
            s_left = s_split[0]
            s_left = s_left.strip()     
            s_right = s_split[1]
            s_right = s_right.strip()
            s_left = s_left.replace("  "," ")
            s_split = s_left.split(" ")
            s_acronym = s_split[0]
            s_index = s_split[1]     
            s_index = s_index.strip()
            if s_index[0] == "0":
                s_index = s_index[1: ]
            s_acronym_first = s_acronym[0]
            tmp_rows = []
            del tmp_rows
            mysql = "SELECT seriesname,'dummy' FROM _global_web_series_detail WHERE booktitle = ? AND seriesindex = ? \
                                                                                                                    AND substr(seriesname,1) = ?"
            my_cursor.execute(mysql,(s_right,s_index,s_acronym_first))
            tmp_rows = my_cursor.fetchall()
            if tmp_rows:
                seriesname = "NOTFOUND"
                for row in tmp_rows:
                    seriesname,dummy = row
                if seriesname != "NOTFOUND":
                    tmp_title = s_right + "  [ " + seriesname + "   ,#" + as_unicode(s_index) + "  ]"
                    tmp_title = tmp_title.strip()
                    tmp_title = tmp_title.replace("  "," ")
                    need_to_update_title = True
                    title_is_probably_good = False
                    title_is_frozen = False
                    new_title = tmp_title   
                else:
                    new_title = s_right     
                    tmp_title = new_title
                    need_to_update_title = True
                    title_is_probably_good = True
                    title_is_frozen = True
            else:
                new_title = s_right     
                tmp_title = new_title
                need_to_update_title = True
                title_is_probably_good = True
                title_is_frozen = True
        except Exception as e:
            log("[fix 39:]  " + e)
            pass
    my_re1 = "^[a-z ]+[,]*[ ][the]*[ ]*book[ ][onetwhrfuivsxg]+[:][ ].+[,][ ]the$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = tmp_title
            s1 = s1[0:-4]
            s1 = s1.strip()
            if s1.endswith(","):
                s1 = s1[0:-1]
            s1 = s1.replace(",","")
            s1 = s1.replace("the book","#")
            s1 = s1.replace("the Book","#")
            s1 = s1.replace(" One","1")
            s1 = s1.replace(" Two","2")
            s1 = s1.replace(" Three","3")
            s1 = s1.replace(" Four","4")
            s1 = s1.replace(" Five","5")
            s1 = s1.replace(" Six","6")
            s1 = s1.replace(" Seven","7")
            s1 = s1.replace(" Eight","8")
            s1 = s1.replace(" Nine","9")
            s1 = s1.replace(" Ten","10")
            s1 = "[ " + s1
            s1 = s1.replace(":","]")
            tmp_title = s1                  
            tmp_title = tmp_title.strip()
            tmp_title = tmp_title.replace("  "," ")
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[a-z &']+[:][ ][a-z &']+[:][ ]book[ ][onetwhrfuivsxg]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = tmp_title  
            s1 = s1.replace(": book"," #")
            s1 = s1.replace(": Book"," #")
            s1 = s1.replace(" One","1")
            s1 = s1.replace(" Two","2")
            s1 = s1.replace(" Three","3")
            s1 = s1.replace(" Four","4")
            s1 = s1.replace(" Five","5")
            s1 = s1.replace(" Six","6")
            s1 = s1.replace(" Seven","7")
            s1 = s1.replace(" Eight","8")
            s1 = s1.replace(" Nine","9")
            s1 = s1.replace(" Ten","10")  
            s1 = s1.replace(":"," [ ")
            s1 = s1 + " ]"                     
            tmp_title = s1                  
            tmp_title = tmp_title.strip()
            tmp_title = tmp_title.replace("  "," ")
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[a-z &']+[:][ ]book[ ][onetwhrfuivsxg]+[:][ ][a-z ']+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = tmp_title  
            s1 = s1.replace(": book","[ #")
            s1 = s1.replace(": Book","[ #")
            s1 = s1.replace(" One","1 -")
            s1 = s1.replace(" Two","2 -")
            s1 = s1.replace(" Three","3 -")
            s1 = s1.replace(" Four","4 -")
            s1 = s1.replace(" Five","5 -")
            s1 = s1.replace(" Six","6 -")
            s1 = s1.replace(" Seven","7 -")
            s1 = s1.replace(" Eight","8 -")
            s1 = s1.replace(" Nine","9 -")
            s1 = s1.replace(" Ten","10 -")  
            s1 = s1.replace("-:", "|")        
            s1 = s1.replace("[", "|")        
            s_split = s1.split("|")
            tmp_title = s_split[0] + " [ " + s_split[2] + " " + s_split[1] + " ]"  
            tmp_title = tmp_title.strip()
            tmp_title = tmp_title.replace("  "," ")
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[a-z &']+[,][ ]Book[ ][onetwhrfuivsxg]+[ ][\(][a-z '&]+[\)]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = tmp_title  
            s1 = s1.replace(", book","[ #")
            s1 = s1.replace(", Book","[ #")
            s1 = s1.replace(" One","1 ")
            s1 = s1.replace(" Two","2 ")
            s1 = s1.replace(" Three","3 ")
            s1 = s1.replace(" Four","4 ")
            s1 = s1.replace(" Five","5 ")
            s1 = s1.replace(" Six","6 ")
            s1 = s1.replace(" Seven","7 ")
            s1 = s1.replace(" Eight","8 ")
            s1 = s1.replace(" Nine","9 ")
            s1 = s1.replace(" Ten","10 ")  
            s1 = s1.replace("(","")
            s1 = s1.replace(")"," ")            
            s_split = s1.split("[")
            s0 = s_split[0]     
            s1 = s_split[1]     
            s1 = s1.strip()
            n = s1.find(" ")
            s2 = s1[0:n]        
            s3 = s1[n: ]         
            tmp_title = s0 + " [" + s3 + " " + s2 + " ]" 
            tmp_title = tmp_title.strip()
            tmp_title = tmp_title.replace("  "," ")
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[a-z ',]+[,][ ][BookVolume]+[ ][OneTwhrFuivSxg0123456789]+[:][ ][a-z ',]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = tmp_title  
            s1 = "[ " + s1
            s1 = s1.replace(":"," ]")   
            s1 = s1.replace(", book"," #")
            s1 = s1.replace(", Book"," #") #     [Septimus Heap # One ] Magyk
            s1 = s1.replace(", volume"," #")
            s1 = s1.replace(", Volume"," #") #     [Septimus Heap # One ] Magyk
            s1 = s1.replace(" One","1 ")     
            s1 = s1.replace(" Two","2 ")
            s1 = s1.replace(" Three","3 ")
            s1 = s1.replace(" Four","4 ")
            s1 = s1.replace(" Five","5 ")
            s1 = s1.replace(" Six","6 ")
            s1 = s1.replace(" Seven","7 ")
            s1 = s1.replace(" Eight","8 ")
            s1 = s1.replace(" Nine","9 ")
            s1 = s1.replace(" Ten","10 ")
            tmp_title = s1 
            tmp_title = tmp_title.strip()
            tmp_title = tmp_title.replace("  "," ")
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^.+\s\(An\s[a-z ]+\sThriller\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        my_re_left =  "^.+\s\("     
        my_re_right = "\(An\s[a-z ]+\sThriller\)"   
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = s1
        s2 = tmp_title.replace(s1, "")
        s2 = s2.replace("(", "")
        s2 = s2.replace(")", "")
        s2 = s2.replace("Book", "") 
        s2 = s2.strip()
        s2 = titlecase(s2) 
        probable_tags_to_add_list.append("Thriller")
        s2 = s2.replace("An ", "") 
        s2 = s2.replace("Thriller", "") 
        s2 = s2.strip()
        probable_seriesname_to_add_list.append(s2)    
        s1 = s1.replace("(", "")
        s1 = titlecase(s1) 
        s1 = s1.strip()
        new_title = s1     
        need_to_update_title = True
    my_re1 = "^[a-z ]+[:][ ]A Novel of the[ ][a-z ]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s_split = s1.split(":")
            s_left = s_split[0]
            s_right = s_split[1]
            s_right = s_right.replace("a novel of the ","")
            s_right = s_right.replace("A Novel of the ","")
            tmp_title = s_left + " [ " + s_right + "]"
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[a-z ]+\s#[0-9]+[: ]\s[a-z ]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
        pass
    else:
        my_re_left =  "^[a-z ]+\s#[0-9]+[: ]"
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            log("ERROR[1]:  logic error in check_title_for_special_patterns_to_genericize")
            return
        else:
            s1 = match1.group(0)
            s1 = s1
        s2 = tmp_title.replace(s1, "")
        s1 = s1.replace(":", "")
        s1 = s1.strip()
        new_title = s2 + " [" + s1 + "]"
        need_to_update_title = True
    my_re1 = "^[a-z ]+[:-]\sBook\s[0-9]+\s\(.+\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        my_re_left =  "^[a-z ]+[:-]"
        my_re_middle = "^[a-z ]+[:-]\sBook\s[0-9]+\s"  
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = s1
        s2 = tmp_title.replace(s1, "")
        s2 = s2.replace("(", "")
        s2 = s2.replace(")", "")
        s2 = s2.replace("Book", "") 
        s2 = s2.strip()
        s2 = "#" + s2 
        s2 = titlecase(s2) 
        s1 = s1.replace(":", "")
        s1 = titlecase(s1) 
        s1 = s1.strip()
        new_title = s1 + " [" + s2 + "]"
        need_to_update_title = True
    my_re1 = "^[a-z ]+&[a-z ]+\([a-z ]+-\sBook\s[a-z ]*[0-9]+\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        my_re_left =  "^[a-z ]+&[a-z ]+"
        my_re_right = "\([a-z ]+-\sBook\s[a-z ]*[0-9]+\)"  
        my_re_numeric = "[0-9]+"
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = s1
        s2 = tmp_title.replace(s1, "")
        s2 = s2.replace("(", "")
        s2 = s2.replace(")", "") #     (Urban Fantasy - Book 2
        s2 = s2.replace("Book", "")
        s2 = s2.replace("-", "")
        s2 = s2.replace("  ", " ")
        s2 = s2.strip() #   'Urban Fantasy  2'
        s2 = titlecase(s2)
        s1 = titlecase(s1)
        s1 = s1.strip()
        p3 = re.compile(my_re_numeric, re.IGNORECASE)
        match3 = p3.search(s2)
        if not match3:
            sleep(60.0)
            return
        else:
            s3 = match3.group(0)
            s3 = s3
            s3 = qs_standardize_string_numerics(s3) #  2 or 22 or 222
            s2 = s2.replace(s3, "#" + s3), 1
        new_title = s1 + " [" + s2 + "]" #now:   Reap & Repent [Urban Fantasy
        new_title = new_title.replace("  ", " ")
        need_to_update_title = True
    my_re1 = "^[a-z ]+[0-9]+[ _:-]+[a-z ]+[,:-]*\s[a-z ]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        my_re_left =  "^[a-z ]+[0-9]+[ _:-]+"
        my_re_numeric = "[0-9]+"
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return    
        else:
            s1 = match1.group(0)
            s1 = s1
        s2 = tmp_title.replace(s1, "") #    Diva Takes the Cake,:- The
        s2 = s2.replace(",", "") #       Diva Takes the Cake The
        s2 = s2.replace(":", "") #       Diva Takes the Cake The
        s2 = s2.replace("-", "") #      Diva Takes the Cake The
        if s2.endswith("The"):
            s2 = s2[0:-3]
        s2 = s2.strip() #   'Diva Takes the Cake'
        s2 = titlecase(s2)
        s1 = titlecase(s1)
        s1 = s1.replace("_", "") #now:    xxx 02 :-
        s1 = s1.replace(":", "") #now:     xxx 02 -
        s1 = s1.replace("-", "") #now:    xxx 02
        s1 = s1.strip()
        p3 = re.compile(my_re_numeric, re.IGNORECASE)
        match3 = p3.search(s1)         
        if not match3:
            sleep(60.0)
            return    
        else:
            s3 = match3.group(0)
            s3 = s3
            s3 = qs_standardize_string_numerics(s3) #  2 or 22 or 222
            s1 = s1.replace(s3,("#" + s3))
        new_title = s2 + " [" + s1 + "]" #now:   Diva Takes the Cake [Diva #02]
        need_to_update_title = True
    my_re1 = "^.+\(.+[0-9]+[:-; ]+.+[0-9]+\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        my_re_left =  "^.+\("
        my_re_right = "\(.+[0-9]+[:-; ]+.+[0-9]+\)"  
        my_re_far_right = "[:-;]+.+[0-9]+\)"  
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = s1
            s1 = s1.replace("(", "") 
            s1 = s1.strip()
        s2 = tmp_title.replace(s1, "")
        s2 = s2.replace("(", "")
        s1 = titlecase(s1)
        s1 = s1.strip()
        p3 = re.compile(my_re_far_right, re.IGNORECASE)
        match3 = p3.search(tmp_title)
        if not match3:
            return
        else:
            s3 = match3.group(0)   
            s3 = s3
            s2 = s2.replace(s3, "") #     Moon #10
            s2 = s2.replace(")", "")
            s2 = s2.replace(":", "")
            s2 = s2.replace("-", "")
            s2 = s2.replace(";", "")
            s2 = s2.replace("  ", " ")
            s2 = s2.strip()
            s2 = titlecase(s2)
            new_title = s1 + " [" + s2 + "]" #now:   Dark Moon [Moon #10]
            new_title = new_title.replace("  ", " ")
            need_to_update_title = True
    if need_to_update_title:
        s1 = new_title
    else:
        s1 = tmp_title
    n1 = s1.count("Book One")
    if n1 > 0:
        s1 = s1.replace("Book One", "")
        s1 = s1.strip()
        if s1.endswith(","):
            s1 = s1[0:-1]
            s1 = s1.strip()
        s1 = s1 + " " + "#1"
        new_title = s1
        need_to_update_title = True
    n1 = s1.count("Book Two")
    if n1 > 0:
        s1 = s1.replace("Book Two", "")
        s1 = s1.strip()
        if s1.endswith(","):
            s1 = s1[0:-1]
            s1 = s1.strip()
        s1 = s1 + " " + "#2"
        new_title = s1
        need_to_update_title = True
    n1 = s1.count("Book Three")
    if n1 > 0:
        s1 = s1.replace("Book Three", "")
        s1 = s1.strip()
        if s1.endswith(","):
            s1 = s1[0:-1]
            s1 = s1.strip()
        s1 = s1 + " " + "#3"
        new_title = s1
        need_to_update_title = True
    n1 = s1.count("Book Four")
    if n1 > 0:
        s1 = s1.replace("Book Four", "")
        s1 = s1.strip()
        if s1.endswith(","):
            s1 = s1[0:-1]
            s1 = s1.strip()
        s1 = s1 + " " + "#4"
        new_title = s1
        need_to_update_title = True
    n1 = s1.count("Book Five")
    if n1 > 0:
        s1 = s1.replace("Book Five", "")
        s1 = s1.strip()
        if s1.endswith(","):
            s1 = s1[0:-1]
            s1 = s1.strip()
        s1 = s1 + " " + "#5"
        new_title = s1
        need_to_update_title = True
    n1 = s1.count("Book Six")
    if n1 > 0:
        s1 = s1.replace("Book Six", "")
        s1 = s1.strip()
        if s1.endswith(","):
            s1 = s1[0:-1]
            s1 = s1.strip()
        s1 = s1 + " " + "#6"
        new_title = s1
        need_to_update_title = True
    n1 = s1.count("Book Seven")
    if n1 > 0:
        s1 = s1.replace("Book Seven", "")
        s1 = s1.strip()
        if s1.endswith(","):
            s1 = s1[0:-1]
            s1 = s1.strip()
        s1 = s1 + " " + "#7"
        new_title = s1
        need_to_update_title = True
    n1 = s1.count("Book Eight")
    if n1 > 0:
        s1 = s1.replace("Book Eight", "")
        s1 = s1.strip()
        if s1.endswith(","):
            s1 = s1[0:-1]
            s1 = s1.strip()
        s1 = s1 + " " + "#8"
        new_title = s1
        need_to_update_title = True
    n1 = s1.count("Book Nine")
    if n1 > 0:
        s1 = s1.replace("Book Nine", "")
        s1 = s1.strip()
        if s1.endswith(","):
            s1 = s1[0:-1]
            s1 = s1.strip()
        s1 = s1 + " " + "#9"
        new_title = s1
        need_to_update_title = True
    n1 = s1.count("Book Ten")
    if n1 > 0:
        s1 = s1.replace("Book Ten", "")
        s1 = s1.strip()
        if s1.endswith(","):
            s1 = s1[0:-1]
            s1 = s1.strip()
        s1 = s1 + " " + "#10"
        new_title = s1
        need_to_update_title = True
    my_re1 = "^.+:.+,\sBook\s[0-9.a-z ]+" 
    my_re2 = "^.+:\sA\s.+\sNovella\s\(.+\)" 
    my_re3 = "^.+:\sA\s.+\sNovel\s\(.+\)" 
    my_re4 = "^.+:\sA\s.+\sBook\s\(.+\)" 
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(tmp_title)
    p4 = re.compile(my_re4, re.IGNORECASE)
    match4 = p4.search(tmp_title)
    if ((not match1) and (not match2) and (not match3) and (not match4)) or need_to_update_title :
        pass
    elif (match2 or match3 or match4): 
        nc = tmp_title.find(":")
        s1 = tmp_title[0:nc]
        np = tmp_title.find("(")
        s2 = tmp_title[np-1: ]
        s3 = s1 + " " + s2
        tmp_title = s3
        new_title = tmp_title.strip()
        need_to_update_title = True
    else:
        my_re_left =  "^.+:"     
        my_re_right = ":.+,\sBook\s[0-9.a-z ]+"   
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = s1
            s1 = s1.replace(":", "")
        s2 = tmp_title.replace(s1, "") #   ': A Bayou Stix Novella, Book 2.5 Bayou Stix
        s2 = s2.replace(":", "") #   ' A Bayou Stix Novella, Book 2.5 Bayou Stix
        s2 = s2.strip()
        s2 = s2.strip() #   'A Bayou Stix Novella, Book 2.5 Bayou Stix
        n1 = s2.count("Novella")
        n2 = s2.count("Novel")
        if s2.startswith("A "):
            n3 = 1
        else:
            n3 = 0
        if n1 > 0:
            s2 = s2.replace("Novella", "")
        if n2 > 0:
            s2 = s2.replace("Novel", "")
        if n3 > 0:
            s2 = s2.replace("A ", "")
        s2 = s2.replace("Book", "") #  Bayou Stix, 2.5 Bayou Stix
        nc = s2.count(",")
        if nc > 0:
            s2 = s2.replace(",", "|")
            tmp_list = s2.split("|")
            nr = len(tmp_list)
            if nr == 2:
                s_left = tmp_list[0]     
                s_left = s_left.strip()
                s_right = tmp_list[1] 
            if nr >= 3:
                s_left = tmp_list[0]
                s_left = s_left.strip()
                s_middle = tmp_list[1]
                s_right = tmp_list[2]
                if nr >= 4:
                    s_right = s_right + tmp_list[3]
            if nr == 2:
                n1 = s_right.count(s_left)
                if n1 > 0:
                    s_right = s_right.replace(s_left, "") # now 2.5
                    s_right = s_right.strip()
            if nr == 3:
                n1 = s_middle.count(s_left)
                n2 = s_right.count(s_left)
                if n1 > 0:
                    s_middle = s_middle.replace(s_left, "") # now 2.5 ???
                    s_middle = s_middle.strip()
                if n2 > 0:
                    s_right = s_right.replace(s_left, "") # now 2.5 ???
                    s_right = s_right.strip()
                    s_right = s_middle + " " + s_right
            new_title = s1 + " [" + s_left + " " + "#" + s_right+ "]"
            need_to_update_title = True
    my_re1 = "^.+\s-\sArticles by [a-z]+\s[a-z]+"        
    my_re2 = "^.+\s-\sby [a-z]+\s[a-z]+"                     
    my_re3 = "^.+\s-\sA Book by [a-z]+\s[a-z]+"        
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(tmp_title)
    if ((not match1) and (not match2) and (not match3)) or need_to_update_title :
        pass
    else:
        if match1:
            tmp_title = tmp_title.replace("- Articles", "")
            series_is_valid_globally = True
        if match2:
            tmp_title = tmp_title.replace("-", "")
            series_is_valid_globally = True
        if match3:
            tmp_title = tmp_title.replace("- A Book", "")
            series_is_valid_globally = True
        n = tmp_title.find(" by ")
        tmp_auth = tmp_title[n: ] #  by David Icke
        tmp_title = tmp_title[0:n] #  WAS HITLER a ROTHSCHILD by
        tmp_auth = tmp_auth.replace(" by ", "") #David Icke
        tmp_auth = tmp_auth.strip()
        tmp_title = tmp_title.replace(" by ", "") #WAS HITLER a ROTHSCHILD
        tmp_title = tmp_title.strip()
        new_title = tmp_title    
        new_title = titlecase(new_title) #  Was Hitler a Rothschild
        need_to_update_title = True
        title_is_probably_good = True
        new_auth = tmp_auth    
        need_to_update_auth = True
        author_is_probably_good = True
    my_re1 = "^[a-z ]+:\sVolume One:\s[a-z ]+"          
    my_re2 = "^[a-z ]+:\sVolume Two:\s[a-z ]+"          
    my_re3 = "^[a-z ]+:\sVolume Three:\s[a-z ]+"        
    my_re4 = "^[a-z ]+:\sVolume Four:\s[a-z ]+"         
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(tmp_title)
    p4 = re.compile(my_re4, re.IGNORECASE)
    match4 = p4.search(tmp_title)
    if ((not match1) and (not match2) and (not match3) and (not match4)) or need_to_update_title :
        pass
    else:
        if match1:
            tmp_title = tmp_title.replace(": Volume One:", " 1]")
        if match2:
            tmp_title = tmp_title.replace(": Volume Two:", " 2]")
        if match3:
            tmp_title = tmp_title.replace(": Volume Three:", " 3]")
        if match4:
            tmp_title = tmp_title.replace(": Volume Four:", " 4]")
        tmp_title = "[" + tmp_title
        need_to_update_title = True
        title_is_probably_good = False
        title_is_frozen = False
        new_title = tmp_title
    my_re1 = "^[a-z ]+\s[IV]+\s-\s[a-z ]+\(Volume\s[0-9]+\)"          
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1)  or need_to_update_title :
        pass
    else:                                                
        tmp_title = tmp_title[0:-11]
        tmp_title = tmp_title.replace(" I ", " 1]")
        tmp_title = tmp_title.replace(" II ", " 2]")
        tmp_title = tmp_title.replace(" III ", " 3]")
        tmp_title = tmp_title.replace(" IV ", " 4]")
        tmp_title = tmp_title.replace(" V ", " 5]")
        tmp_title = tmp_title.replace(" VI ", " 6]")
        tmp_title = "[" + tmp_title #   [This Game Has No Loyalty ] - Hustle for Life
        tmp_title = tmp_title.replace("-", "") #   [This Game Has No Loyalty ]  Hustle for Life
        tmp_title = tmp_title.replace("  ", " ") #change double spaces to space
        need_to_update_title = True
        title_is_probably_good = False
        title_is_frozen = False
        new_title = tmp_title
    my_re1 = "^.+\s-\s.+[0-9][0-9]*$"          
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1)  or need_to_update_title :
        pass
    else:                                                
        tmp_list = tmp_title.split("-")
        tmp_title = tmp_list[0]
        s = tmp_list[1]
        s = s.strip()
        s = s.replace("0", "")
        tmp_series = " [" + s + "]"
        tmp_title = tmp_title + tmp_series
        tmp_title = tmp_title.replace("-", "") #
        tmp_title = tmp_title.replace("  ", " ") #change double spaces to space
        need_to_update_title = True
        title_is_probably_good = False
        title_is_frozen = False
        new_title = tmp_title
    my_re1 = "^Books of [a-z ]*\sVol[ume]*[.]*\s[0-9]+\s-\s[a-z ']+$"          
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1)  or need_to_update_title :
        pass
    else:                                                
        tmp_list = tmp_title.split("-")
        tmp_title = tmp_list[1]    
        tmp_title = tmp_title.strip()
        s = tmp_list[0]                 
        s = s.replace("Volume", "")
        s = s.replace("Vol", "")
        s = s.replace(".", "")
        s = s.strip()
        tmp_series = " [" + s + "]"
        tmp_title = tmp_title+ tmp_series
        tmp_title = tmp_title.replace("-", "") #
        tmp_title = tmp_title.replace("  ", " ") #change double spaces to space
        need_to_update_title = True
        title_is_probably_good = False
        title_is_frozen = False
        new_title = tmp_title
    my_re1 = "[(]Book\s[0-9]+[ ]of\sthe\s[a-z -]+\sseries[)]$"          
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1)  or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s1 = s1
            s_split = tmp_title.split(s1)
            s0 = s_split[0]
            s1 = s1.replace(" of the ", ": ") #
            s1 = s1.replace(" Series", "") #
            tmp_title = s0+ " " + s1
            tmp_title = tmp_title.replace("  ", " ") #change double spaces to space
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    nc = tmp_title.find(":")
    ns = tmp_title.find("\\")
    nc1 = tmp_title.count(":")
    ns1 = tmp_title.count("\\")
    nd1 = tmp_title.count("-")
    nh1 = tmp_title.count("#")
    np1 = tmp_title.count("(")
    if nc1 == 0 or nc1 > 1 or (not ns1 > 1) or nd1 > 0 or nh1 > 0 or np1 > 0:
        pass
    else:
        if nc > 0 and ns > (nc + 2) :
            try:
                n = tmp_title.find(":")
                s1 = tmp_title[0:n]
                s1 = "[" + s1 + "]"
                s2 = tmp_title[n+1: ]
                tmp_title = s2+ " " + s1
                tmp_title = tmp_title.replace("\\", " & ")
                tmp_title = tmp_title.replace("  ", " ") #change double spaces to space
                tmp_title = tmp_title.strip()
                tmp_title = tmp_title.replace(" :", ":")
                need_to_update_title = True
                title_is_probably_good = False
                title_is_frozen = False
                new_title = tmp_title   
            except:
                pass
        else:
            pass
    my_re1 = "^[0-9]+[)][ ]"          
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1)  or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s1 = s1
            s_split = tmp_title.split(s1)
            s0 = s_split[1]
            tmp_title = s0
            tmp_title = tmp_title.replace("  ", " ") #change double spaces to space
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^(?P<g1>[a-z ]+[ ])[#][0-9]+[:][ ]+[a-z ]+[:][ ]+an[ ](?P=g1)[ ]*Novel$"          
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = tmp_title
            n = s1.rfind(":")
            s2 = s1[0:n]  
            if s2.endswith(":"):
                s2 = s2[0:-1]
            tmp_title = s2
            tmp_title = tmp_title.replace("  ", " ") #change double spaces to space
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[a-z ]+[ ][1-9]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = tmp_title
            s2 = s1[-2: ]  
            s2 = s2.strip()
            s1 = s1[0:-2]  
            s1 = s1 + " 0" + s2
            s1 = s1.strip()
            tmp_title = "Series=" + s1        
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[series=]*[a-z ]+[0][1-9]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            n = s1.find("0")
            tmp_title = s1[ :n]
            tmp_title = tmp_title.replace("0","")
            tmp_title = tmp_title.replace("Series=","")
            tmp_title = tmp_title.replace("series=","")
            s1 = s1.replace("=","")
            tmp_title = tmp_title + " [" + s1 + "]"
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "\s[(][2][0-9][0-9][0-9][)]$"          
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            tmp_title = tmp_title.replace(s1,"")
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "\s[(][1][9][0-9][0-9][)]$"          
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            tmp_title = tmp_title.replace(s1,"")
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "[:]\sa[n]*\s[a-z ]+\sThriller$|[:]\sa[n]*\s[a-z ]+\sMystery$|[:]\sa[n]*\s[a-z ]+\sRomance$|[:]\sa[n]*\s[a-z ]+\sNovel$|[:]\sa[n]*\s[a-z ]+\sNovella$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            tmp_title = tmp_title.replace(s1,"")
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[a-z ]+[;][ ][a-z ]+[ ][0-9]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            tmp_title = tmp_title.replace(";",":")
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[a-z ]+[ ][[][0-9]+[]][ ][a-z -]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            tmp_title = tmp_title.replace("[","") 
            tmp_title = "[" + tmp_title  
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[0-9]+[ ][a-z ]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            my_re1 = "^[0-9]+[ ]"
            p1 = re.compile(my_re1, re.IGNORECASE)
            match1 = p1.search(tmp_title)
            if (not match1):
                pass
            else:  
                s1 = match1.group(0)
                tmp_title = tmp_title.replace(s1,"") 
                tmp_title = tmp_title + " " + s1  
                tmp_title = tmp_title.replace("  ", " ")
                tmp_title = tmp_title.strip()
                need_to_update_title = True
                title_is_probably_good = False
                title_is_frozen = False
                new_title = tmp_title
        except:
            pass
    my_re1 = "[[][a][n]*[ ][a-z ]+[Novella][]]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s0 = s1
            if s1.startswith("[An "):
                s1 = s1.replace("[An ", "[")
            if s1.startswith("[A "):
                s1 = s1.replace("[A ", "[")
            s1 = s1.replace("Novella", "")
            s1 = s1.replace("Novel", "")       
            s1 = s1.replace("]", " #1]")                       
            tmp_title = tmp_title.replace(s0, "")
            tmp_title = tmp_title + " " + s1          
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[a-z ]+[:][a-z ]+[,][ ]*book[ ][0-9]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s0 = s1
            s_list = s0.split(":")
            s_left = s_list[0]
            s2 = s_list[1]
            s_list2 = s2.split(",")
            s_middle = s_list2[0]
            s_right = s_list2[1]
            s_right = s_right.strip()
            s_right = s_right.replace("Book"," ")
            s_right = s_right.replace("book"," ")
            s_right = s_right.strip()
            tmp_title = s_left + " [" + s_middle + " " + s_right + " ]"
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    my_re1 = "^[a-z ]+[:][a-z ]+[:][ ]*$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s_list = s1.split(":")
            s_left = s_list[0]
            s_right = s_list[1]
            s_right = s_right.strip()
            is_known = check_title_substring_for_known_seriesname(my_db,my_cursor,s_right,my_current_book)    
            if not is_known:
                tmp_title = s_left + ": " + s_right         
            else:
                tmp_title = s_left + " [" + s_right + " #1]"
                tmp_title = tmp_title.replace("  ", " ")
                tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except Exception as e:
            pass
    my_re1 = "^[a-z ]+[:][ ]*the[a-z ]+series$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s_list = s1.split(":")
            s_left = s_list[0]
            s_right = s_list[1]
            s_right = s_right.replace("The ", "")
            s_right = s_right.replace("the ", "")
            s_right = s_right.replace(" Series", "")
            s_right = s_right.replace(" series", "")
            s_right = s_right.strip()
            tmp_title = s_left + " [" + s_right + " #1]"   
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except Exception as e:
            pass
    my_re1 = "^[0-9]+[ -][a-z ]+[-][a-z ]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s_list = s1.split("-")
            s_left = s_list[0]
            s_left = s_left.strip()
            s_middle = s_list[1]
            s_middle = s_middle.strip()
            s_right = s_list[2] 
            s_right = s_right.replace("Stories", "",2)
            s_right = s_right.replace("stories", "",2)
            s_right = s_right.strip()
            tmp_title = s_middle + " [" + s_right + " #" + s_left + " ]"
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except Exception as e:
            pass
    my_re1 = "^[a-z ]+[:][ ]*[the]*[a-z ]+series[:][ ]*book[ ]+[0-9]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s_list = s1.split(":")
            s_left = s_list[0]
            s_left = s_left.strip()
            s_middle = s_list[1]
            s_middle = s_middle.strip()
            s_middle = s_middle.replace("Series", "",2)
            s_middle = s_middle.replace("series", "",2)
            s_middle = s_middle.strip()  
            s_right = s_list[2] 
            s_right = s_right.replace("Book", "",2)
            s_right = s_right.replace("book", "",2)
            s_right = s_right.strip()  
            tmp_title = s_left + " [" + s_middle + " #" + s_right + " ]"
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except Exception as e:
            pass
    my_re1 = "^[a-z ]+[:][a-z ]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s_split = s1.split(":")
            s_left = s_split[0]
            s_right = s_split[1]
            s_right = s_right.strip() #  The Sullivans
            is_known = check_title_substring_for_known_seriesname(my_db,my_cursor,s_right,my_current_book)    
            if not is_known:
                pass
            else:
                tmp_title = s_left + " [" + s_right + " #1]"
                tmp_title = tmp_title.replace("  ", " ")
                tmp_title = tmp_title.strip()
                need_to_update_title = True
                title_is_probably_good = False
                title_is_frozen = False
                new_title = tmp_title
        except:
            pass
    my_re1 = "^[0-9]+[ ]*[-][a-z ]+[:][a-z ]+[a-z][ ]*$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s_list = s1.split("-")
            s_left = s_list[0]
            s_left = s_left.strip()
            s_right = s_list[1]
            s_list2 = s_right.split(":")
            s_middle = s_list2[0]
            s_middle = s_middle.strip()
            s_middle = s_middle.strip()
            s_right = s_list2[1]
            s_right = s_right.strip()  
            tmp_title = s_middle + " [" + s_right + " #" + s_left + " ]"    
            tmp_title = tmp_title.replace("  ", " ")
            tmp_title = tmp_title.strip()
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except Exception as e:
            pass
    my_re1 = "^[\[][a-z ]+[0-9]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:  
        try:
            s1 = match1.group(0)
            s2 = s1
            s1 = s1 + " ]"
            s1 = s1.strip()
            my_re1 = "[0-9]+"
            p1 = re.compile(my_re1, re.IGNORECASE)
            match1 = p1.search(s1)
            s3 = match1.group(0)
            s2 = s2.replace(s3,"")
            s2 = s2.replace("[","")
            s2 = s2.strip()
            tmp_title = s2 + " " + s1  
            tmp_title = tmp_title.replace(s3,"#"+s3)  
            need_to_update_title = True
            title_is_probably_good = False
            title_is_frozen = False
            new_title = tmp_title
        except:
            pass
    if (not need_to_update_title) and (not force_update):
        pass
    else:
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;'
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,new_title,my_current_book)
    if not need_to_update_auth:
        return
    else:
        author_is_probably_good = True
        tmp_id_rows = []
        del tmp_id_rows
        tmp_id_rows = []
        mysql = 'SELECT id from custom_column_4 WHERE value = ? '
        tmp_id_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=new_auth)
        if tmp_id_rows:
            tmp_id = tmp_id_rows[0]
            tmp_id = qs_standardize_string_numerics(tmp_id,return_integer=True)
            mysql = "UPDATE books_custom_column_4_link SET value = ? WHERE book = ?  "
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_id,my_current_book)
        else:
            mysql = 'INSERT OR IGNORE INTO custom_column_4 (id,value) VALUES (null,?) ;'
            execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_auth )
            mysql = 'SELECT id,NULL from custom_column_4  WHERE value = ? '
            tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_auth)
            if not tmp_auth_rows:
                tmp_auth_rows = []
            if len(tmp_auth_rows) == 0:
                return    
            else:
                tmp_id,dummy = tmp_auth_rows[0]
                tmp_id = qs_standardize_string_numerics(tmp_id,return_integer=True)
            mysql = "DELETE FROM books_custom_column_4_link WHERE book = ?  "
            execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
            mysql = "INSERT  OR REPLACE INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?)"
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_id)
def check_title_substring_for_known_seriesname(my_db,my_cursor,s_substring,my_current_book):
    mysql = "SELECT Count(*)  WHERE \
                (   ? IN(SELECT name FROM _global_series) OR \
                    ? IN(SELECT name FROM _pristine_series) OR \
                    ? IN(SELECT value FROM custom_column_10 WHERE id != ? ) OR \
                    ? IN(SELECT seriesname FROM _global_web_author_series)  )   "
    my_cursor.execute(mysql,(s_substring,s_substring,s_substring,my_current_book,s_substring))
    count1 = my_cursor.fetchall()
    count1 = qs_standardize_string_numerics(count1)
    if count1 != "0" and count1 != "[0]":
        return True
    else:
        return False
def check_if_author_is_not_author_and_title_is_not_author(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_valid_globally
    global author_is_probably_good
    global title_is_probably_good
    global title_is_frozen
    if author_is_valid_globally:  
        return
    if author_is_probably_good:
        return
    if title_is_frozen or title_is_probably_good:
        return
    mysql = "SELECT authname,'dummy' FROM __books_work_populate WHERE book = ?  "
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_auth_rows:
        if len(tmp_auth_rows) > 0:
            tmp_auth,dummy = tmp_auth_rows[0]
        else:
            return
    else:
        return
    mysql = "SELECT booktitle,'dummy' FROM __books_work_populate WHERE book = ?  "
    tmp_title_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_title_rows:
        if len(tmp_title_rows) > 0:
            tmp_title,dummy = tmp_title_rows[0]
        else:
            return      
    else:
        return      
    title_is_probably_a_title = False
    nt = tmp_title.count(" ")
    if nt > 2:
         title_is_probably_a_title = True
    else:
         pass
    s = tmp_title.lower()
    nt1 = tmp_title.find("A ")
    nt2 = s.find("the")
    nt3 = s.find(" an ")
    nt4 = s.find(" of ")
    nt5 = s.find(" a ")
    nt6 = tmp_title.find(":")
    nt7 = tmp_title.find(" - ")
    nt8 = tmp_title.find("#")
    nt9 = tmp_title.find("(")
    nt10 = tmp_title.find("[")
    nt11 = tmp_title.find("*")
    nt12 = tmp_title.find("1")
    nt13 = tmp_title.find("2")
    nt14 = s.find(" series ")
    nt15 = s.find(" book ")
    nt16 = s.find(" novel ")
    nt17 = s.find(" novella ")
    nt18 = tmp_title.find("3")
    nt19 = tmp_title.find(" & ")
    if nt1 >= 0 or nt2 >= 0 or nt3 >= 0 or nt4 >= 0 or nt5 >= 0 or nt6 >= 0 or nt7 >= 0 or nt8 >= 0 or nt9 >= 0 \
                       or nt10 >= 0 or nt11 >= 0 or nt12 >= 0 or nt13 >= 0  or nt14 >= 0  or nt15 >= 0 or nt16 >= 0  or nt17 >= 0 \
                       or nt18 >= 0 or nt19 >= 0 :
        title_is_probably_a_title = True
    auth_is_probably_an_auth = True
    nt = tmp_auth.count(" ")
    if nt > 2:
         auth_is_probably_an_auth = False
    s = tmp_auth.lower()
    nt1 = tmp_auth.find(" A ")
    nt2 = s.find(" the ")
    nt3 = s.find(" an ")
    nt4 = s.find(" of ")
    nt5 = s.find(" a ")
    nt6 = tmp_auth.find(":")
    nt7 = tmp_auth.find(" - ")
    nt8 = tmp_auth.find("#")
    nt9 = tmp_auth.find("(")
    nt10 = tmp_auth.find("[")
    nt11 = tmp_auth.find("*")
    nt12 = tmp_auth.find("1")
    nt13 = tmp_auth.find("2")
    nt14 = s.find(" series ")
    nt15 = s.find(" book ")
    nt16 = s.find(" novel ")
    nt17 = s.find(" novella ")
    nt18 = tmp_auth.find("3")
    if nt1 >= 0 or nt2 >= 0 or nt3 >= 0 or nt4 >= 0 or nt5 >= 0 or nt6 >= 0 or nt7 >= 0 or nt8 >= 0 or nt9 >= 0 \
                       or nt10 >= 0 or nt11 >= 0 or nt12 >= 0 or nt13 >= 0  or nt14 >= 0  or nt15 >= 0 or nt16 >= 0  or nt17 >= 0:
        auth_is_probably_an_auth = False
    if auth_is_probably_an_auth:
        return
    else:
        if title_is_probably_a_title:
            pass
        else:
            return
    s_auth = tmp_auth.lower()
    s_title = tmp_title.lower()
    na = s_auth.find(s_title)
    nt = s_title.find(s_auth)
    if nt >= 0:
        new_title = tmp_title
    else:
        if na >= 0:
            new_title = tmp_auth
        else:
            new_title = tmp_auth + " - " + tmp_title
    new_auth = "_Unknown_"
    new_title = new_title.lower()
    new_title = titlecase(new_title)
    tmp_id_rows = []
    mysql = "SELECT id,'dummy' from custom_column_4 WHERE value = '_Unknown_' "
    tmp_id_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_id_rows:
        tmp_id_rows = []
    if len(tmp_id_rows) > 0:
        tmp_id,dummy = tmp_id_rows[0]
        mysql = "UPDATE books_custom_column_4_link SET value = ? WHERE book = ?  "
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_id,my_current_book)
    else:
        mysql = "INSERT OR IGNORE INTO custom_column_4 (id,value) VALUES (null, '_Unknown_') ;"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
        mysql = "SELECT id,'dummy' from custom_column_4  WHERE value = '_Unknown_' "
        tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
        if not tmp_auth_rows:
            return    
        if len(tmp_auth_rows) == 0:
            return   
        tmp_id,dummy = tmp_auth_rows[0]
        mysql = "DELETE FROM books_custom_column_4_link WHERE book = ?  "
        execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
        mysql = "INSERT  OR REPLACE INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?)"
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_id)
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;'
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,new_title,my_current_book)
    author_is_probably_good = True
    title_is_probably_good = False
def check_series_against_global_valid_values(my_db,my_cursor,my_current_book,notifications,log):
    global series_is_valid_globally
    series_is_valid_globally = False
    mysql = "SELECT seriesname,'dummy' FROM __books_work_populate WHERE book = ? "
    tmp_series_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_series_rows:
        if len(tmp_series_rows) > 0:
            for row in tmp_series_rows:
                tmp_series,dummy = row
                if tmp_series is not None:
                    n = tmp_series.count('"')
                    tmp_series = tmp_series.replace('"', "")
                    mysql = 'SELECT name from _global_series WHERE name = ? '
                    tmp_global_series_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_series)
                    if tmp_global_series_rows:
                        if len(tmp_global_series_rows) > 0:
                            series_is_valid_globally = True
                            break
def scrub_title_is_author_index_series(my_db,my_cursor,my_current_book,notifications,log): #fix:  "Drake, David - HS07 - the Sharp End"
    global author_is_valid_globally
    global author_is_probably_good
    global is_finished_scrub_title_index_series_in_title
    global series_re_pattern_to_remove
    if author_is_valid_globally:
        return
    if author_is_probably_good:
        return
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return
    mysql = 'SELECT booktitle,NULL FROM __books_work_populate WHERE book = ? '
    tmp_title_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    tmp_title = None
    if tmp_title_rows:
        for row in tmp_title_rows:
            tmp_title,dummy = row
            break
    if tmp_title is None:
        return    
    tmp_title = tmp_title.replace("  ", " ")           
    tmp_title = tmp_title.strip()
    my_re1 = "^.+,[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    my_re2 = "^.+?\s.+?\s[-]\s[a-zA-Z]+[0-9]+\s[-]\s.+"
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    my_re3= "^.+,\s[a-zA-Z]+"
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(tmp_title)
    series_re_pattern_to_remove = "-\s[a-z0-9]+\s-"
    if not match1 and not match2 and not match3:
        return
    if match1:
        match_type = "1"
    if match3:
        tmp_title = tmp_title.replace(", ", ",") #Turn Drake, David into Drake,David
        match_type = "1"
    if match2: #should have no comma if a true match2
        n1 = tmp_title.find(",")
        n2 = tmp_title.find("-")
        if  (n1 > 0) :
            if n1 < n2:
                match_type = "1"
            else:
                match_type = "2"
        else:
            match_type = "2"
    if match_type == "2":
        tmp_title = tmp_title.replace("  ", " ")
        s_tmp = tmp_title
        s_list1 = s_tmp.split("-")
        s_tmp3 = s_list1[1] #so everything to the right of the first dash
        s_tmp3 = s_tmp3 + s_list1[2]
        s_tmp2 = s_list1[0] #so everything to the left of the first dash
        s_list2 = s_tmp2.split(" ")
        s_first = s_list2[0]
        s_last = s_list2[1]
        s_new = s_tmp3
        s_new = s_new.replace(s_last, "")
        s_new = s_new.replace(s_first, "")
        s_new = s_new.replace(s_tmp2, "")
        s_new = s_new.replace("  ", " ")
        s_fullname = s_last + "," + s_first
        tmp_title = s_fullname + " -" + s_new #so now it should look like a match_type 1 title...
    else:
        pass
    n = tmp_title.find(" ")
    if n > 0 :
        tmp_string = tmp_title[0:n]
        tmp_title = tmp_title.replace(tmp_string, "")
    else:
        return
    orig_auth = tmp_string #save it for later so can .remove it from title...
    s_split = tmp_string.split(",")
    n = len(s_split)
    if not n > 1:
        return
    else:
        for row in s_split:
            pass
        pass
    try:
        s_last = s_split[0]
        s_first = s_split[1]
    except:
        return
    s_last = titlecase(s_last)
    s_first = titlecase(s_first)
    tmp_auth = s_first + ' ' + s_last
    need_to_update_author = False
    mysql = 'SELECT name from _global_authors WHERE name = ? '
    tmp_global_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_auth)
    if tmp_global_auth_rows:
        if len(tmp_global_auth_rows) > 0:
            author_is_valid_globally = True
            need_to_update_author = True
        else:
            need_to_update_author = True
    else:
        need_to_update_author = True
    if not need_to_update_author:
        return
    mysql = 'SELECT authname,booktitle FROM __books_work_populate WHERE book = ? '
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_rows:
        return
    else:
        n = len(tmp_rows)
        if n == 0:
            return
    w_auth = ""
    w_title = ""
    for row in tmp_rows:
        w_auth,w_title = row
        break
    w_new_title = w_title
    w_new_title = w_new_title.replace(tmp_auth, "")
    w_new_title = w_new_title.replace(s_first, "")
    w_new_title = w_new_title.replace(s_last, "")
    w_new_title = w_new_title.replace(orig_auth, "")
    w_new_title = w_new_title.replace("  ", " ")           
    n1 = w_new_title.find("-")
    w_new_title = w_new_title[n1: ] #rip off anything left from part1 prior to appending w_auth to the new title
    w_new_title = w_auth + " " + w_new_title       
    w_new_title = w_new_title.replace("  ", " ")
    x_list = w_new_title.split("-")
    if not x_list:
        pass
    else:
        n = len(x_list)
        if n > 1:
            sx0 = x_list[0]
            sx0 = sx0.strip()
            sx1 = x_list[1]
            sx1 = sx1.strip()
            if sx0 == sx1:
                w_new_title = sx0
            else:
                pass
        else:
            pass
    mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_auth,my_current_book)
    author_is_probably_good = True
    if w_new_title != "":
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,w_new_title,my_current_book)
    else:
        log("ERROR [1] in scrub_title_is_author_index_series(my_db,my_cursor,my_current_book,notifications,log): Notify Developer.  Thank you.")
    check_author_against_global_valid_values(my_db,my_cursor,my_current_book,notifications,log)
    is_finished_scrub_title_index_series_in_title = False
    scrub_title_index_series_in_title(my_db,my_cursor,my_current_book,notifications,log)
def scrub_title_is_author_series_index(my_db,my_cursor,my_current_book,notifications,log): #fix: "David Drake - Hammer's Slammers 07"
    global author_is_valid_globally
    global author_is_probably_good
    global is_finished_scrub_title_series_index_in_title
    if author_is_valid_globally:
        return
    if author_is_probably_good:
        return
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return
    mysql = 'SELECT booktitle,NULL FROM __books_work_populate WHERE book = ? '
    tmp_title_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    tmp_title = None
    if tmp_title_rows:
        for row in tmp_title_rows:
            tmp_title,dummy = row
            break
    if  tmp_title is None:
        return    
    tmp_title = tmp_title.replace("  ", " ")           
    tmp_title = tmp_title.strip()
    my_re1 = "^.+,[a-zA-Z]+.+-[ 'a-zA-Z]+[0-9]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    my_re2 = "^.+[a-zA-Z]\s.+[a-zA-Z]+\s-[ 'a-zA-Z]+[0-9]+"
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    my_re3= "^.+,[ a-zA-Z]+.+-[ 'a-zA-Z]+[0-9]+"
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(tmp_title)
    if not match1 and not match2 and not match3:
        return
    if match1:
        match_type = "1"
    if match3:
        tmp_title = tmp_title.replace(", ", ",") #Turn Drake, David into Drake,David
        match_type = "1"
    if match2: #should have no comma if a true match2
        n1 = tmp_title.find(",")
        n2 = tmp_title.find("-")
        if  (n1 > 0) :
            if n1 < n2:
                match_type = "1"
            else:
                match_type = "2"
        else:
            match_type = "2"
    if match_type == "2":
        tmp_title = tmp_title.replace("  ", " ")
        s_tmp = tmp_title
        s_list1 = []
        del s_list1
        s_list1 = s_tmp.split("-")
        s_tmp3 = s_list1[1] #so everything to the right of the first dash
        s_tmp2 = s_list1[0] #so everything to the left of the first dash
        s_list2 = s_tmp2.split(" ")
        s_first = s_list2[0]
        s_last = s_list2[1]
        s_new = s_tmp3
        s_new = s_new.replace(s_last, "")
        s_new = s_new.replace(s_first, "")
        s_new = s_new.replace(s_tmp2, "")
        s_new = s_new.replace("  ", " ")
        s_fullname = s_last + "," + s_first
        tmp_title = s_fullname + " -" + s_new #so now it should look like a match_type 1 title...
    else:
        pass
    n = tmp_title.find(" ")
    if n > 0 :
        tmp_string = tmp_title[0:n]
        tmp_title = tmp_title.replace(tmp_string, "")
    else:
        return
    orig_auth = tmp_string #save it for later so can .remove it from title...
    s_split = tmp_string.split(",")
    n = len(s_split)
    if not n > 1:
        return
    else:
        for row in s_split:
            pass
        pass
    try:
        s_last = s_split[0]
        s_first = s_split[1]
    except:
        return
    s_last = titlecase(s_last)
    s_first = titlecase(s_first)
    tmp_auth = s_first + ' ' + s_last
    need_to_update_author = False
    mysql = 'SELECT name from _global_authors WHERE name = ? '
    tmp_global_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_auth)
    if tmp_global_auth_rows:
        if len(tmp_global_auth_rows) > 0:
            author_is_valid_globally = True
            need_to_update_author = True
        else:
            need_to_update_author = True
    else:
        need_to_update_author = True
    if not need_to_update_author:
        return
    mysql = 'SELECT authname,booktitle FROM __books_work_populate WHERE book = ? '
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_rows:
        return  
    else:
        n = len(tmp_rows)
        if n == 0:
            return  
    w_auth = ""
    w_title = ""
    i = 0
    for row in tmp_rows:
        w_auth,w_title = row
        break
    w_new_title = w_title
    w_new_title = w_new_title.replace(tmp_auth, "")
    w_new_title = w_new_title.replace(s_first, "")
    w_new_title = w_new_title.replace(s_last, "")
    w_new_title = w_new_title.replace(orig_auth, "")
    w_new_title = w_new_title.replace("  ", " ")           
    n1 = w_new_title.find("-")
    w_new_title = w_new_title[n1: ] #rip off anything left from part1 prior to appending w_auth to the new title
    w_new_title = w_auth + " " + w_new_title       
    w_new_title = w_new_title.replace("  ", " ")
    mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_auth,my_current_book)
    author_is_probably_good = True
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,w_new_title,my_current_book)
    check_author_against_global_valid_values(my_db,my_cursor,my_current_book,notifications,log)
    is_finished_scrub_title_series_index_in_title = False
    scrub_title_series_index_in_title(my_db,my_cursor,my_current_book,notifications,log)
def scrub_first_first_author(my_db,my_cursor,my_current_book,notifications,log):
    mysql = "SELECT authname,NULL FROM __books_work_populate WHERE book = ?  "
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            tmp_auth,dummy = row 
            break
    else:
        return
    force_update_author = False
    force_update_title = False
    n = tmp_auth.count('"')
    if n > 0:
        tmp_auth = tmp_auth.replace('"', "")
        force_update_author = True
    n = tmp_auth.count('|')
    if n > 0:
        tmp_auth = tmp_auth.replace('|', ",")
        force_update_author = True
    if tmp_auth.startswith(";") or tmp_auth.startswith(",") :
        tmp_auth = tmp_auth[1: ]
        force_update_author = True
    ns = tmp_auth.find(';')
    if ns > 0:  
        tmp_auth = tmp_auth[0:ns]      
        tmp_auth = tmp_auth.replace(';', "")
        force_update_author = True
    nl = tmp_auth.count("(")
    nr = tmp_auth.count(")")
    if nl != nr:
        tmp_auth = tmp_auth.replace("(", "")
        tmp_auth = tmp_auth.replace(")", "")
        force_update_author = True
    nl = tmp_auth.count("[")
    nr = tmp_auth.count("]")
    if nl != nr:
        tmp_auth = tmp_auth.replace("[", "")
        tmp_auth = tmp_auth.replace("]", "")
        force_update_author = True
    nl = tmp_auth.count("{")
    nr = tmp_auth.count("}")
    if nl != nr:
        tmp_auth = tmp_auth.replace("{", "")
        tmp_auth = tmp_auth.replace("}", "")
        force_update_author = True
    orig_title = tmp_auth
    nw = tmp_auth.count("ikipedia")
    if nw > 0:
        tmp_auth = "Unknown"
        force_update_author = True
    if tmp_auth == "Anthology" :
        tmp_auth = "Unknown"
        force_update_author = True
    if tmp_auth == "Release: storemags & fantamag" :
        tmp_auth = "Magazines"
        force_update_author = True
    if tmp_auth.endswith(","):
        tmp_auth = tmp_auth[0:-1]
        tmp_auth = tmp_auth.strip()
        force_update_author = True
    if tmp_auth.startswith(","):
        tmp_auth = tmp_auth[1: ]
        tmp_auth = tmp_auth.strip()
        force_update_author = True
    my_re1 = "^[A-Z ]+$"  
    p1 = re.compile(my_re1)
    match1 = p1.search(tmp_auth)
    if match1:
        try:
            tmp_auth = tmp_auth.lower()
            tmp_auth = titlecase(tmp_auth)
            force_update_author = True
        except:
            tmp_auth = titlecase(tmp_auth)
            force_update_author = True
    my_re1 = "^[a-z ]+[-]\s[a-z 0-9]+[-][a-z ]+$"  
    p1 = re.compile(my_re1,re.IGNORECASE)
    match1 = p1.search(tmp_auth)
    if match1:
        n = tmp_auth.find("-")
        tmp_title = tmp_auth[n: ]
        if tmp_title.startswith("-"):
            tmp_title = tmp_title[1: ]
        tmp_title = tmp_title.strip()
        tmp_auth = tmp_auth[0:n]
        tmp_auth = tmp_auth.replace("-", "")
        tmp_auth = tmp_auth.strip()
        force_update_title = True
    my_re1 = "^[a-z]+,\s[a-z]+\s-\s[a-z ]+\s[/(][a-z ]+[#]*[0-9 ]+[/)]$"  
    p1 = re.compile(my_re1,re.IGNORECASE)
    match1 = p1.search(tmp_auth)
    if match1:
        n = tmp_auth.find("-")
        tmp_title = tmp_auth[n: ]
        if tmp_title.startswith("-"):
            tmp_title = tmp_title[1: ]
        tmp_title = tmp_title.strip()
        tmp_auth = tmp_auth[0:n]
        tmp_auth = tmp_auth.replace("-", "")
        tmp_auth = tmp_auth.strip()
        force_update_title = True
    if (not force_update_title) and (not force_update_author):
        return
    global fancy_quotes_set
    for quote in fancy_quotes_set:
        if force_update_author:
            tmp_auth = tmp_auth.replace(quote, "'")
        if force_update_title:
            tmp_title = tmp_title.replace(quote, "'")
    mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_auth,my_current_book)
    if force_update_title:
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
def fix_author_name_null(my_db,my_cursor,log):
    sleep(0.03)
    mysql = "DELETE FROM custom_column_4 WHERE value = NULL " 
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.03)
    mysql = "DELETE FROM books_custom_column_4_link WHERE value NOT IN (SELECT id FROM custom_column_4 WHERE id > 0 )"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.03)
    mysql = "INSERT OR REPLACE INTO custom_column_4 SELECT book,name FROM __book_author_name_sort WHERE name NOT NULL \
                                               AND book NOT IN (SELECT book FROM books_custom_column_4_link WHERE book > 0 ) ; "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.03)
    mysql = "INSERT or IGNORE INTO books_custom_column_4_link SELECT book,book,book FROM __book_author_name_sort \
                                                 WHERE book NOT IN (SELECT book FROM books_custom_column_4_link WHERE book > 0 );"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.03)
    mysql = 'UPDATE custom_column_8 SET value = "?" WHERE value = ""  '
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.02)
    mysql = "DELETE FROM books_custom_column_4_link WHERE book IN(SELECT book FROM __books_work_populate \
                                                                                            WHERE authname NOT NULL AND booktitle IS NULL \
                                                                                            AND seriesname  IS NULL AND seriesindex  IS NULL \
                                                                                            AND seriesfull  IS NULL AND tagsall  IS NULL)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.03)
    mysql = "DELETE FROM custom_column_4 WHERE id NOT IN(SELECT value FROM books_custom_column_4_link WHERE id > 0 )"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.03)
def scrub_author_name_goofy(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_valid_globally
    global author_is_probably_good
    global author_in_title
    global title_in_author
    global series_in_author
    global series_in_title
    global set_of_letters
    global set_of_numbers
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_author_symbols
    global set_of_letters_and_author_symbols
    global set_of_title_characters
    global set_of_numbers_and_symbols
    global author_is_really_title
    global title_is_probably_good
    if author_is_valid_globally:  
        return
    if author_is_probably_good:
        return
    scrub_isbn_in_author(my_db,my_cursor,my_current_book,notifications,log)
    s = ""
    auth_list = []
    mysql = "SELECT authname,'dummy' from __books_work_populate WHERE book = ?  "
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_auth_rows:
       for row in tmp_auth_rows:
            authname,dummy = row
            break
    else:
        return
    s_new_author_name = "tobedetermined"
    author_not_author = False
    author_needs_updating = False
    s = authname
    if set(s).issubset(set_of_symbols):
        author_needs_updating = True
        s_new_author_name = "_Unknown_"
    else:
        if set(s).issubset(set_of_numbers):
            author_needs_updating = True
            s_new_author_name = "_Unknown_"
        else:
            if set(s).issubset(set_of_numbers_and_symbols):
                author_needs_updating = True
                s_new_author_name = "_Unknown_"
            else:
                pass
    if s_new_author_name != "tobedetermined":
        s = s_new_author_name
        s = s.strip()
    n = s.count(".")
    if n > 3:
        s = s.replace(".", "", 50)
        s_new_author_name = s
        s = s_new_author_name
        author_needs_updating = True
    n = s.count("kindle@")
    if n > 0:
        s_new_author_name = "_Unknown_"
        s = s_new_author_name
        author_needs_updating = True
    n = s.count("@")
    if n > 0 and ((s.endswith(".com")  or s.endswith(".net")) ):
        s_new_author_name = "_Unknown_"
        s = s_new_author_name
        author_needs_updating = True
    n = s.count("http://")
    if n > 0:
        s_new_author_name = "_Unknown_"
        s = s_new_author_name
        author_needs_updating = True
    if s == '_'  or s == '__'  or s == '___':
        s_new_author_name = "_Unknown_"
        s = s_new_author_name
        author_needs_updating = True
    if s == 'admin'  or s == 'Admin'  or s == 'ADMIN':
        s_new_author_name = "_Unknown_"
        s = s_new_author_name
        author_needs_updating = True
    n1 = s.count("Edited by")
    n2 = s.count("edited by")
    if n1 > 0 or n2 > 0:
        s = s.replace("edited by", "Edited by")
        s_new_author_name = s
        author_needs_updating = True
        author_is_probably_good = True
        author_not_author = False
    n1 = s.count("(retail)")
    n2 = s.count(" retail ")
    n3 = s.count("(pdf)")
    n4 = s.count("pdf")
    n5 = s.count(" ")
    n6 = s.count("-")
    n7 = s.count(":")
    if n1 > 0 or n2 > 0 or n3 > 0 or n4 > 0:
        author_needs_updating = True
        s = s.replace("(retail)", "")
        s = s.replace(" retail ", "")
        s = s.replace("(pdf)", "")
        s = s.replace("pdf", "")
        s_new_author_name = s
    if n5 > 3 and (n6 > 0 or n7 > 0):
        author_is_really_title = True
        author_not_author = True
        s_new_author_name = s
    n1 = s.count(" (ed)")
    if n1 > 0:
        s = s.replace(" (ed)", "")
        s_new_author_name = s
        author_needs_updating = True
    n1 = s.count("(v1.0)")
    if n1 > 0:
        s = s.replace("(v1.0)", "")
        s_new_author_name = s
        author_needs_updating = True
    n1 = s.count("-")
    if n1 == 0:
        pass
    else:
        mysql = "SELECT booktitle,'dummy' from __books_work_populate WHERE book = ?  "
        tmp_title_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
        if tmp_title_rows:
           for row in tmp_title_rows:
                tmp_title,dummy = row
                break
        else:
            tmp_title = ""
        n1 = s.count(tmp_title)
        if n1 > 0:
            s = s.replace(tmp_title, "")
            s = s.replace("-", "")
            s = s.replace("  ", " ")
            s_new_author_name = s
            s_new_author_name = s_new_author_name.strip()
            author_not_author = False
            author_needs_updating = True
            author_is_really_title = False
            title_is_probably_good = True
    if (not author_needs_updating):
        if s_new_author_name == "tobedetermined" :
            return
    s_new_author_name = s_new_author_name.strip()
    mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  )'
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,s_new_author_name,my_current_book)
    if not author_not_author:
        author_is_probably_good = True
    if author_is_really_title:
        author_is_probably_good = False
        s_bad_author_name = s_new_author_name
        move_author_to_title(my_db,my_cursor,my_current_book,notifications,log, s_bad_author_name)
    scrub_isbn_in_title(my_db,my_cursor,my_current_book,notifications,log)
def move_author_to_title(my_db,my_cursor,my_current_book,notifications,log, s_bad_author_name):
    global author_is_really_title
    global author_is_probably_good
    if not author_is_really_title:
        return
    tmp_auth = s_bad_author_name #passed as a parameter
    mysql = "SELECT booktitle,'dummy' from __books_work_populate WHERE book = ?  "
    tmp_title_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_title_rows:
        tmp_title,dummy = tmp_title_rows[0] #only one title for a book, although there can be many authors
    else:
        tmp_title = ""
    tmp_title = tmp_title + "  " + tmp_auth
    sleep(0.03)
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
    s_unknown = "__Unknown__"
    author_is_probably_good = False
    mysql = "SELECT id,NULL from custom_column_4 WHERE value = ? "
    tmp_id_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=s_unknown)
    found = False
    if tmp_id_rows:
        if len(tmp_id_rows) > 0:
            found = True
            tmp_id,dummy = tmp_id_rows[0]
            sleep(0.02)
            mysql = 'UPDATE books_custom_column_4_link SET value = ? WHERE book = ?   '
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_id,my_current_book)
    if not found:
        sleep(0.02)
        mysql = "INSERT OR REPLACE INTO custom_column_4 (id,value) VALUES (?,?)"
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,None, s_unknown)
        sleep(0.02)
        mysql = 'SELECT id,NULL from custom_column_4  WHERE value = ? '
        tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=s_unknown)
        if not tmp_auth_rows:
            return
        else:
            if len(tmp_auth_rows) == 0:
                return
            tmp_id,dummy = tmp_auth_rows[0]
        sleep(0.02)
        mysql = "DELETE FROM books_custom_column_4_link WHERE book = ?  "
        execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
        sleep(0.02)
        mysql = "INSERT OR REPLACE INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?) "
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_id)
        sleep(0.02)
def scrub_switched_author_title(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_valid_globally
    global author_is_probably_good
    global author_in_title
    global title_in_author
    global series_in_author
    global series_in_title
    global set_of_letters
    global set_of_numbers
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_author_symbols
    global set_of_letters_and_author_symbols
    global set_of_title_characters
    global set_of_numbers_and_symbols
    global title_is_frozen
    if author_is_valid_globally:  
        return
    if author_is_probably_good:
        return
    if title_is_frozen:
        return
    mysql = "SELECT authname,'dummy' FROM __books_work_populate WHERE book = ?  "
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_auth_rows:
        return
    if len(tmp_auth_rows) == 0:
        return
    tmp_auth,dummy = tmp_auth_rows[0]
    if tmp_auth_rows:
        tmp_auth,dummy = tmp_auth_rows[0]
    mysql = "SELECT booktitle,'dummy' from __books_work_populate WHERE book = ?  "
    tmp_title_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    tmp_title = None
    if tmp_title_rows:
        if len(tmp_title_rows) > 0:
            tmp_title,dummy = tmp_title_rows[0]
    if tmp_title is None:
        tmp_title = "IGNORE_ME"
    tmp_auth = tmp_auth.replace(".", "")
    tmp_auth = tmp_auth.replace(",", "")
    if set(tmp_auth).issubset(set_of_letters) :   
        return
    else:
        if set(tmp_auth).issubset(set_of_letters_and_author_symbols):
            if set(tmp_title).issubset(set_of_title_characters):
                return
    author_in_title = False
    na = tmp_auth.count(" ")
    nt = tmp_title.count(" ")
    if (na == 1 or na == 2) and (nt == 0 or nt > 2):       
        return
    try:
        s = tmp_title.lower()
    except:
        pass
    nt1 = tmp_title.find("A ")    
    nt2 = s.find("the")
    nt3 = s.find(" an ")
    nt4 = s.find(" of ")
    nt5 = s.find(" a ")
    nt6 = tmp_title.find(":")
    nt7 = tmp_title.find(" - ")
    nt8 = tmp_title.find("#")
    nt9 = tmp_title.find("(")
    nt10 = tmp_title.find("[")
    nt11 = tmp_title.find("*")
    nt12 = tmp_title.find("1")
    nt13 = tmp_title.find("2")
    nt14 = s.find(" series ")
    nt15 = s.find(" book ")
    nt16 = s.find(" novel ")
    nt17 = s.find(" novella ")
    nt18 = tmp_title.find("3")
    if nt1 >= 0 or nt2 >= 0 or nt3 >= 0 or nt4 >= 0 or nt5 >= 0 or nt6 >= 0 or nt7 >= 0 or nt8 >= 0 or nt9 >= 0 \
                       or nt10 >= 0 or nt11 >= 0 or nt12 >= 0 or nt13 >= 0  or nt14 >= 0  or nt15 >= 0 or nt16 >= 0  or nt17 >= 0:
        return
    else:
        pass
    if tmp_title != "IGNORE_ME":
        tmp_title = tmp_title.replace(",", "")
        mysql = 'SELECT book,NULL from __book_author_name_sort WHERE name = ? '
        tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_title)
        if tmp_auth_rows:
            if len(tmp_auth_rows) > 0:
                author_in_title = True
                tmp_auth = tmp_title
    if tmp_title != "IGNORE_ME":
        mysql = 'SELECT name,NULL from _global_authors WHERE name = ? '
        tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_title)
        if tmp_auth_rows:
            if len(tmp_auth_rows) > 0:
                author_in_title = True
                tmp_auth,dummy = tmp_auth_rows[0]
    mysql = "SELECT authname,NULL from __books_work_populate WHERE book = ?  "
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_auth_rows:
        return
    else:
        tmp_auth,dummy = tmp_auth_rows[0]
        tmp_auth = tmp_auth.replace(",", "")
    if set(tmp_title).issubset(set_of_letters_and_author_symbols) :
        if not set(tmp_auth).issubset(set_of_letters_and_author_symbols) :
            author_in_title = True
    else:
        pass
    if not author_in_title:
        return
    c_work_author_table = "custom_column_4"      
    l_work_author_table = "books_custom_column_4_link" 
    c_work_title_table = "custom_column_8" 
    l_work_title_table = "books_custom_column_8_link" 
    tmp_id_rows = []
    mysql = 'SELECT id,NULL from custom_column_4 WHERE value = ? '
    tmp_id_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_title)
    if tmp_id_rows:
        if len(tmp_id_rows) > 0:
            tmp_id,dummy = tmp_id_rows[0]
            mysql = 'UPDATE books_custom_column_4_link SET value = ? WHERE book = ?   '
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_id,my_current_book)
    else:
        mysql = "INSERT OR REPLACE INTO custom_column_4 (id,value) VALUES (?,?)"
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,None, tmp_title)
        mysql = 'SELECT id,NULL from custom_column_4  WHERE value = ? '
        tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_title)
        if not tmp_auth_rows:
            return
        else:
            if len(tmp_auth_rows) > 0:
                tmp_id,dummy = tmp_auth_rows[0]
            else:
                return
        mysql = "DELETE FROM books_custom_column_4_link WHERE book = ?  "
        execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
        mysql = "INSERT OR REPLACE INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?) "
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_id)
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_auth,my_current_book)
def scrub_series_substring(my_db,my_cursor,my_current_book,notifications,log):  
    global author_in_title
    global author_is_valid_globally
    global partial_blankout_scenario
    global series_in_author
    global series_in_title
    global series_is_valid_globally
    global seriesindex_is_probably_good
    global set_of_author_symbols
    global set_of_letters
    global set_of_letters_and_author_symbols
    global set_of_numbers
    global set_of_numbers_and_symbols
    global set_of_numbers_letters
    global set_of_re_metacharacters
    global set_of_symbols
    global set_of_title_characters
    global title_in_author
    global title_is_frozen
    global title_is_probably_good
    if title_is_probably_good and title_is_frozen:
        return
    if partial_blankout_scenario:
        return
    series = ""
    title = ""
    series_index = ""
    mysql = "SELECT booktitle, seriesname, seriesindex from __books_work_populate WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        if len(tmp_rows) == 0:
            return
        for row in tmp_rows:
            title, series, series_index = row
    else:
        return
    if series == "" or series is None:
        return
    else:
        if title == "" or title is None:
            return
    if series_index is None:
        series_index = 0
    a = series
    b = title
    x = compute_similarity(a,b)
    if not x >= 0.50 :
        return
    else:
        pass
    my_re1 = "\s*[a-zA-Z]+/[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace("/", "&") #now:  Deserves to Die: Selena Alvarez&Regan Pescoli 6
    s_string = title
    n_start = 999
    n_end = 999
    s_string, n_start, n_end = find_numbers_in_letter_string(s_string, n_start, n_end)
    if n_start != 999 and n_end != 999:
        s_number = s_string[n_start:n_end]
        tmp_index = s_number
        tmp_index = qs_standardize_string_numerics(tmp_index) 
        title = title.replace(series, "")
        series = series.replace(tmp_index, "")
        title = title.replace(tmp_index, "")
        series_index = qs_standardize_string_numerics(tmp_index,return_integer=True)
        mysql = "INSERT OR REPLACE INTO custom_column_12 (id,book,value) VALUES (?,?,?)"
        execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book, series_index)
        seriesindex_is_probably_good = True
    else:
        pass
    series_index = as_unicode(series_index)
    backup_title = title
    title = title.replace(series, "")                
    title = title.replace(series_index, "")
    if not title > " ":
        title = backup_title
    s0 = series_index
    s0 = s0.replace(".0", "")  
    n1 = s0.find("0")
    if n1 == 0:        
        s0 = s0[1: ]   
    s0 = s0.replace("0", "") 
    series_index = s0
    s1 = series_index         
    s2 = "0" + s1              
    s3 = s1 + ":"              
    s4 = s2 + ":"             
    s5 = s1 + " -"            
    s6 = s1 + "-"              
    s7 = s2 + " -"            
    s8 = s2 + "-"              
    title = title.replace(s7, "")
    title = title.replace(s8, "")
    title = title.replace(s4, "")
    title = title.replace(s2, "")
    title = title.replace(s5, "")
    title = title.replace(s6, "")
    title = title.replace(s3, "")
    title = title.replace(s1, "")
    title = title.replace("()", "")  
    title = title.replace("  ", " ")            
    n = title.find(" ")
    if n == 0: #leading space
        l = len(title)
        if l > 0:
            title = title[1: ]
        else:
            title = "None - Blank [1]"
    else:
        l = len(title)
        if l > 0:
            pass
        else:
            title = "None - Blank [2]"
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
def scrub_author_good_but_author_also_in_title(my_db,my_cursor,my_current_book,notifications,log):
    mysql = "SELECT authname, booktitle FROM __books_work_populate WHERE book = ?  "
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            tmp_auth, tmp_title = row
            break
    else:
        return
    orig_title = tmp_title
    n_orig1 = len(tmp_title)
    my_re1 = "^[a-z ]+['][s]\s"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        return
    my_re1 = "^[a-z]+[,][ ][a-z][.]*[ ][a-z][.]*[ ]"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
        nd = tmp_auth.count(".")
        if nd > 2:         
            pass
        else:
            s_auth_list = tmp_auth.split(" ")
            n = len(s_auth_list)
            if n == 1: 
                s0 = s_auth_list[0]
                s0 = s0.replace(".", "", 5)
                na = tmp_title.count(s0)
                if na == 0:
                    return
            if n == 2: 
                s0 = s_auth_list[0]
                nd = s0.count(".")
                if nd > 0:      
                    pass
                    f_similarity  =  compute_similarity(orig_title, tmp_auth)
                    if f_similarity < .175 :
                        return
                    n = orig_title.count(" ")
                    if n < 3:
                        return
                else:
                    s0 = s0.replace(".", "", 5)
                    s1 = s_auth_list[1]
                    s1 = s1.replace(".", "", 5)
                    na = tmp_title.count((s0))     
                    nb = tmp_title.count((s1))     
                    if na == 0 and nb == 0:
                        return
            if n == 3:    
                s0 = s_auth_list[0]
                nd = s0.count(".")
                if nd > 0:      
                    pass
                else:
                    s0 = s0.replace(".", "", 5)
                    s1 = s_auth_list[1]
                    s1 = s1.replace(".", "", 5)
                    s2 = s_auth_list[2]
                    s2 = s2.replace(".", "", 5)
                    na = tmp_title.count((s0))    
                    nc = tmp_title.count(as_unicode(s2))     
                    if na == 0 and nc == 0:    
                        return
    else:  
        s = match1.group(0)
        tmp_title = tmp_title.replace(as_unicode(s), "") 
        tmp_title = tmp_title.strip()
        pass
    s = tmp_auth.replace(".", " ") #  R.E. Feist     &    R.E. Feist Serpentwar 3 Rage of a Demon King
    n = tmp_title.find(as_unicode(s))
    if n == 0:
        l = len(s)
        tmp_title = tmp_title[l: ]
        tmp_title = tmp_title.strip()
    tmp_title = tmp_title.replace(tmp_auth, "")  
    tmp_title = tmp_title.strip() #removes leading and trailing spaces
    a = tmp_auth # author is:  George Burt Washington  but title has a leading  Washington George Burt with no commas   or with commas or as George Burt Washington itself
    a_split = a.split(" ")
    n1 = len(a_split)
    if n1 == 2:        
        b = a_split[1] + " " + a_split[0]
        tmp_title = tmp_title.replace(b, "")
        b = a_split[1] + ", " + a_split[0]
        tmp_title = tmp_title.replace(b, "")
    else:
        if n1 == 3:   
            b = a_split[2] + " " + a_split[0]  + " " + a_split[1]#  Washington George Burt
            tmp_title = tmp_title.replace(b, "")
            b = a_split[2] + ", " + a_split[0]  + " " + a_split[1]#  Washington, George Burt
            tmp_title = tmp_title.replace(b, "")
        else:
            pass
    tmp_title = tmp_title.strip() #removes leading and trailing spaces
    n_orig2 = len(tmp_title)
    if (n_orig1 != n_orig2) or title_is_frozen:
        pass
    else:
        a = tmp_auth # author is:  K.R. Haynes
        t1 = tmp_title.replace(a, "")
        a = a.replace(".",". ")
        t2 = t1.replace(a, "")
        a = a.replace(".", "")
        t3 = t2.replace(a, "")
        a_split = a.split(" ")
        for row in a_split:
            a0 = row
            t4 = t3.replace(a0, "") #K.R. and next pass Haynes is Haynes
            a0 = a0.replace(".", ". ") #K.R. now K. R.  and next pass Haynes is Haynes
            t5 = t4.replace(a0, "") #now Title is:  Haynes, K. R. - the Light in Her Eyes [In Her Eyes]
            t6 = t5.replace(". ", "")
            if t6.startswith(","):
                t6 = t6[1: ]
            t6 = t6.strip()
            t3 = t6 #for next row
        tmp_title = t6
        tmp_title = tmp_title.replace("  ", " ")           
        tmp_title = tmp_title.strip() #removes leading and trailing spaces
        tmp_title = titlecase(tmp_title)
        tmp_title = tmp_title.strip() #removes leading and trailing spaces
    if tmp_title == "":
        tmp_title = "_Unknown_"
    if tmp_title == orig_title or tmp_title == "" or (not (tmp_title > " ")):
        return
    tmp_title = tmp_title.strip() #removes leading and trailing spaces
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
def scrub_author_is_title_but_title_is_title_with_author_too(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_valid_globally
    global author_is_probably_good
    global author_in_title
    global title_in_author
    if author_is_valid_globally:  
        return
    if author_is_probably_good:
        return
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return
    sleep(0.03)
    mysql = "DELETE FROM  _books_work WHERE  book = ? "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
    mysql =  "INSERT OR IGNORE INTO _books_work SELECT book,booktitle,authname,seriesname,seriesindex FROM __books_work_populate "
    mysql = mysql + " WHERE book = ? "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
    mysql = "UPDATE _books_work SET booktitle = (make_utf8_lowercase(booktitle) )  WHERE book = ? "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
    mysql = "UPDATE _books_work SET authorname = (make_utf8_lowercase(authorname) )  WHERE book = ? "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
    mysql = "DELETE FROM  _instr_title_author WHERE  book = ? "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
    mysql = "INSERT OR IGNORE INTO _instr_title_author (book, booktitle, authorname) \
                SELECT book, booktitle, authorname FROM __instr_title_author_author_title WHERE book = ? "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
    mysql = "SELECT booktitle, authorname FROM _instr_title_author WHERE book = ? "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_rows:
        return
    else:
        for row in tmp_rows:
            tmp_title, tmp_author = row
    p01 = "~"
    p02 = "-"
    p03 = ":"
    p04 = ";"
    s01 = "articles"
    s02 = "article"
    s03 = "a book"
    s04 = "books"
    s05 = "book"
    s06 = " by "
    a_in_t = tmp_title.find(tmp_author)    
    author_in_title = False
    if a_in_t >= 0: author_in_title = True
    if author_in_title: #author is a substring of title
        tmp_title = tmp_title.replace(tmp_author, "")                          
        tmp_title = tmp_title.replace(p01, "")
        tmp_title = tmp_title.replace(p02, "")
        tmp_title = tmp_title.replace(p03, "")
        tmp_title = tmp_title.replace(p04, "")
        tmp_title = tmp_title.replace(s01, "")
        tmp_title = tmp_title.replace(s02, "")
        tmp_title = tmp_title.replace(s03, "")
        tmp_title = tmp_title.replace(s04, "")
        tmp_title = tmp_title.replace(s05, "")
        tmp_title = tmp_title.replace(s06, "")
        tmp_title = tmp_title.replace("  ", " ") #change double spaces to single space
        tmp_title = tmp_title.strip()                                                                                   
        new_title = ""
        for char in tmp_title:
            s = char
            if s.isalpha():
                pass
            else:
                if s == " ":
                    pass
                else:
                    s = ""
            new_title = new_title + s
        tmp_title = new_title
    else:
        pass
    if tmp_title > " ":
        sleep(0.03)
        tmp_title = titlecase(tmp_title)
        mysql =  'INSERT OR REPLACE INTO custom_column_8 (id,value) VALUES (?,?) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_title)
        mysql =  'UPDATE books_custom_column_8_link SET value = ? WHERE book = ?  '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book)
    else:
        pass
def scrub_series_substring_across_author(my_db,my_cursor,my_current_book,notifications,log):
    global author_in_title
    global author_is_valid_globally
    global series_in_author
    global series_in_title
    global series_is_valid_globally
    global set_of_author_symbols
    global set_of_letters
    global set_of_letters_and_author_symbols
    global set_of_numbers
    global set_of_numbers_and_symbols
    global set_of_numbers_letters
    global set_of_re_metacharacters
    global set_of_symbols
    global set_of_title_characters
    global title_in_author
    global title_is_probably_good
    if series_is_valid_globally:
        return
    if title_is_probably_good:
        return
    if title_is_frozen:
        return
    set_title_probably_good_at_end = False
    series = ""
    title = ""
    series_index = ""
    mysql = "SELECT title, series, series_index from __book_meta_partial WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        for row in tmp_rows:
            title, series, series_index = row    
    mysql = "SELECT booktitle,'dummy' from __books_work_populate WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    tmp_title = None
    if tmp_rows:
        for row in tmp_rows:
            tmp_title,dummy = row
            break
    if tmp_title is None:
        return    
    real_title_backup = title #use later to find numerics
    title = title.replace(",", "")
    tmp_title = tmp_title.replace(",", "")
    if series == "None" or series is None:
        series = ""
    if series > " ":
        return
    else:
        if title == "":
            return
        else:
            pass
    tmp_auth = ""
    mysql = "SELECT authname,'dummy' from __book_meta_auth_series WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    tmp_auth = None
    if tmp_rows:
        for row in tmp_rows:
            tmp_auth,dummy = row
            break
    if tmp_auth is None:
        return
    tmp_series = []
    mysql = 'SELECT series,NULL from __book_meta_auth_series WHERE authname = ? '
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_auth)
    if tmp_rows:
        if len(tmp_rows) == 0:
            return
        for row in tmp_rows:
            if row is not None:
                series,dummy = row
                s = series
                if s is None:
                    continue
                tmp_series.append(s)
    else:
        return
    if len(tmp_series) == 0:
        return
    is_match = False
    tmp_match = ""
    for s in tmp_series:
        b = title
        x = compute_similarity(s,b)
        n = title.find(s)
        if x >= 0.50 or n >= 0:
            is_match = True
            tmp_match = s
        if is_match:
            break
    if not is_match:
        return
    else:
        if tmp_match == "":
            return
        else:
            pass
    tmp_title_with_possible_index = real_title_backup #tmp_title here is WORK title
    backup_real_title = real_title_backup
    title = tmp_title
    i = 100.5 #go in reverse so 10 is found before 01, and 01 is found before 0
    while i > 0.0 :
        i = (i - .5)
        s0 = as_unicode(i)
        s0 = s0.replace(".0", "")  
        n1 = s0.find("0")
        if n1 == 0:        
            s0 = s0[1: ]   
        s0 = s0.replace("0", "") 
        tmp_index = s0
        s1 = tmp_index           
        s2 = "0" + s1              
        s3 = s1 + ":"              
        s4 = s2 + ":"             
        s5 = s1 + " -"            
        s6 = s1 + "-"              
        s7 = s2 + " -"            
        s8 = s2 + "-"              
        title = title.replace(s7, "")
        title = title.replace(s8, "")
        title = title.replace(s4, "")
        title = title.replace(s2, "")
        title = title.replace(s5, "")
        title = title.replace(s6, "")
        title = title.replace(s3, "")
        title = title.replace(s1, "")
    title = title.replace("()", "")  
    title = title.replace("  ", " ")            
    n = title.find(" ")
    if n == 0: #leading space
        title = title[1: ]
    backup_title = title #for restoring later if indicated
    backup_title = backup_title.strip()
    n1  = len(title)
    title = title.replace(tmp_match, "")    
    title = title.strip()                                                                                                            
    n2 = len(title)
    if n1 != n2:
        if title.startswith("s "):
            title = title[1: ] #remove the leading "s " that is the artifact
        if title.startswith("es "):
            title = title[2: ] #remove the leading "es " that is the artifact
        if title.startswith("[s "):
            title = title[2: ] #remove the leading "[s " that is the artifact
        if title.startswith("[es "):
            title = title[3: ] #remove the leading "[es " that is the artifact
        title = title.strip()
        title = title.replace("[#]", "")
        title = title.replace("[ #]", "")
        title = title.replace("#]", "")
        title = title.replace("#.]", "")
        title = title.strip()
        if title.endswith("["):
            title = title[0:-1]
            title = title.strip()
        if title.endswith("[s"):
            title = title[0:-2]
            title = title.strip()
        if title.endswith("[es"):
            title = title[0:-3]
            title = title.strip()
        if title.endswith("Mr.") or title.endswith("Mrs.") or title.endswith("Ms.") or title.endswith("Dr."):
            title = backup_title
        if title.endswith("Mister"):
            title = backup_title
    if title == "" or title <= " ":
        title = backup_title
        title = title.strip()
        set_title_probably_good_at_end = True
        title_is_probably_good = False
    else:
        set_title_probably_good_at_end = False
    if not title_is_probably_good:
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id = ? '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
    else:
        pass
    mysql = "INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES (?,?)"
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_match)
    sleep(0.03)
    mysql = "DELETE FROM books_custom_column_10_link WHERE book =  ? AND book = ?  "
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book)
    sleep(0.03)
    mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?)  ;"
    execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book,my_current_book)
    s_num = "99999"
    s_num = find_part_number_in_title(as_unicode(real_title_backup))
    if s_num == "99999":
        s0 = "0"
    else:
        s0 = qs_standardize_string_numerics(s_num,return_integer=True)
    sleep(0.03)
    mysql = "DELETE FROM custom_column_12 WHERE book = ?  "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
    mysql = "INSERT INTO custom_column_12 (id,book,value) VALUES (null,?,?) "
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=s0)
    if set_title_probably_good_at_end:
        title_is_probably_good = True
def scrub_isbn_in_author(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_valid_globally
    global author_is_probably_good
    if author_is_valid_globally:  
        return
    if author_is_probably_good:
        return
    auth = ""
    orig_auth = ""
    mysql = "SELECT value,'dummy' FROM custom_column_4 WHERE custom_column_4.id IN \
                           (SELECT value from books_custom_column_4_link WHERE book = ?  )"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        if len(tmp_rows) == 0:
            return    
        for row in tmp_rows:
            orig_auth,dummy = row
            break
    else:
        return    
    auth = orig_auth
    if auth == "":
        return
    my_re13a = "^97[8-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"
    my_re13b = "^97[8-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    my_re10a = "^[0-1][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9X]"         
    my_re10b = "^[0-1][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    p13a = re.compile(my_re13a, re.IGNORECASE)
    match13a = p13a.search(auth)
    if match13a:
        auth = re.sub(my_re13a, "", auth)
    else:
        p13b = re.compile(my_re13b, re.IGNORECASE)
        match13b = p13b.search(auth)
        if match13b:
            auth = re.sub(my_re13b, "", auth)
        else:
            p10a = re.compile(my_re10a, re.IGNORECASE)
            match10a = p10a.search(auth)
            if match10a:
                auth = re.sub(my_re10a, "", auth)
            else:
                p10b = re.compile(my_re10b, re.IGNORECASE)
                match10b = p10b.search(auth)
                if match10b:
                    auth = re.sub(my_re10b, "", auth)
                else:
                    return
    auth = auth.replace("int.indd", "")
    auth = auth.replace("INT.INDD", "")
    auth = auth.replace(".indd", "")
    auth = auth.replace(".INDD", "")
    auth = auth.replace("_", "")
    auth = auth.replace(",", "")
    auth = auth.replace("  ", " ")           
    auth = auth.strip()                              
    auth = add_missing_spaces_to_camelback_strings(auth)
    auth = auth.strip()
    if auth != orig_auth:
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,auth,my_current_book)
        s_unknown = "_Unknown_"
        mysql = 'UPDATE custom_column_4 SET value =  ? WHERE  custom_column_4.id IN \
                                    (SELECT value FROM books_custom_column_4_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,s_unknown,my_current_book)
    else:
        return
    if match13a or match13b:
        isbn = orig_auth[0:13]
    else:
        isbn = orig_auth[0:10]
    good_isbn = False
    if match13a or match13b:
        good_isbn = calcisbn13checksum(isbn)
    else:
        good_isbn = calcisbn10checksum(isbn)
    if not good_isbn:
        return
    else:
        pass
    new_isbn = convert_isbn_convert_10_to_13(isbn)
    if new_isbn:
        new_isbn = as_unicode(new_isbn)
        if (new_isbn != isbn) and (new_isbn.isnumeric()) and (len(new_isbn) == 13) and (not new_isbn.startswith("978978")):
            log("Valid ISBN10 Converted to ISBN13:" + isbn) + " >>> " + as_unicode(new_isbn)
            isbn = new_isbn
        else:
            pass
    mysql = 'INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,"isbn",?)'
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(my_current_book,isbn))
        my_cursor.execute("commit")
        log("Valid ISBN extracted and updated for book with author of:", orig_auth)
    except Exception as e:
        log(as_unicode(e))
    scrub_misc_title_issues(my_db,my_cursor,my_current_book,notifications,log)
def scrub_isbn_in_title(my_db,my_cursor,my_current_book,notifications,log):
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return
    title = ""
    orig_title = ""
    mysql = "SELECT value,'dummy' FROM custom_column_8 WHERE custom_column_8.id IN \
                           (SELECT value from books_custom_column_8_link WHERE book = ? )"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        if len(tmp_rows) == 0:
            return
        for row in tmp_rows:
            orig_title,dummy = row
            break
    else:
        return    
    title = orig_title
    title = title.replace(",", "")
    orig_title = title
    if title == "":
        return
    n = title.count('"')  
    if n > 0:
        title = title.replace('"', "")
    my_re13a = "^97[8-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"
    my_re13b = "^97[8-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    my_re10a = "^[0-1][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9X]"         
    my_re10b = "^[0-1][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    p13a = re.compile(my_re13a, re.IGNORECASE)
    match13a = p13a.search(title)
    if match13a:
        title = re.sub(my_re13a, "", title)
    else:
        p13b = re.compile(my_re13b, re.IGNORECASE)
        match13b = p13b.search(title)
        if match13b:
            title = re.sub(my_re13b, "", title)
        else:
            p10a = re.compile(my_re10a, re.IGNORECASE)
            match10a = p10a.search(title)
            if match10a:
                title = re.sub(my_re10a, "", title)
            else:
                p10b = re.compile(my_re10b, re.IGNORECASE)
                match10b = p10b.search(title)
                if match10b:
                    title = re.sub(my_re10b, "", title)
                else:
                    return
    title = title.replace("int.indd", "")
    title = title.replace("INT.INDD", "")
    title = title.replace(".indd", "")
    title = title.replace(".INDD", "")
    title = title.replace("_", "")
    title = title.replace(",", "")
    title = title.replace("()", "") #caused by cutting out ISBN
    title = title.replace("[]", "")
    title = title.replace("  ", " ")           
    title = title.strip()                              
    title = add_missing_spaces_to_camelback_strings(title)
    title = title.strip()
    if title != orig_title:
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
    else:
        return
    if match13a or match13b:
        isbn = orig_title[0:13]
    else:
        isbn = orig_title[0:10]
    good_isbn = False
    if match13a or match13b:
        good_isbn = calcisbn13checksum(isbn)
    else:
        good_isbn = calcisbn10checksum(isbn)
    if not good_isbn:
        return
    else:
        pass
    new_isbn = convert_isbn_convert_10_to_13(isbn)
    if new_isbn:
        new_isbn = as_unicode(new_isbn)
        if (new_isbn != isbn) and (new_isbn.isnumeric()) and (len(new_isbn) == 13) and (not new_isbn.startswith("978978")):
            log("Valid ISBN10 Converted to ISBN13:" + isbn) + " >>> " + as_unicode(new_isbn)
            isbn = new_isbn
        else:
            pass
    try:
        mysql = 'INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,"isbn",?)'
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(my_current_book,isbn))
        my_cursor.execute("commit")
        log("Valid ISBN extracted and updated for book with title of:", orig_title)
    except Exception as e:
        log(as_unicode(e))
def scrub_misc_title_issues(my_db,my_cursor,my_current_book,notifications,log):
    global title_is_probably_good
    global title_is_frozen
    title = ""
    orig_title = ""
    mysql = "SELECT value,'dummy' from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value from books_custom_column_8_link WHERE book = ? )"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        if len(tmp_rows) == 0:
            return
        for row in tmp_rows:
            orig_title,dummy = row
            break
    title = orig_title
    if title == "":
        return
    title = remove_bad_keywords(title)
    if title.endswith(" La") or title.endswith(" la"):
        title = title[0:-3] #residual artifact from Novella
    title = title.replace("of S & Novellas", "of Novels & Novellas")
    my_re1 =  '\(.+\)'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        s = match1.group(0)
        n = s.find("Publishing")
        if n >= 0:
            title = re.sub(my_re1, "", title)
        else:
           return
    my_re2 =  '\[.+\]'  
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(title)
    if match2:
        s = match2.group(0)
        n = s.find("Publishing")
        if n >= 0:
            title = re.sub(my_re2, "", title)
        else:
           return
    title = title.replace("  ", " ") #change double spaces to single space
    title = title.strip()
    if title.endswith("-"): title = title[0:-1] #artifact from scrubbing
    title = title.replace("  ", " ") #change double spaces to single space
    title = title.strip()
    n = len(title)
    if n == 0 or title == " " or title == "" :
        title = "_Unknown_"
    else:
        pass
    title = titlecase(title)
    if title != orig_title:
        title_is_probably_good = False
        title = title.replace(",", "")
        title = title.replace("  ", " ")           
        title = title.strip()
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
    else:
        pass
def scrub_first_first_title(my_db,my_cursor,my_current_book,notifications,log): 
    global author_in_title
    global author_is_valid_globally
    global probable_tags_to_add_list
    global series_in_author
    global series_in_title
    global set_of_author_symbols
    global set_of_letters
    global set_of_letters_and_author_symbols
    global set_of_numbers
    global set_of_numbers_and_symbols
    global set_of_numbers_letters
    global set_of_re_metacharacters
    global set_of_symbols
    global set_of_title_characters
    global title_in_author
    global title_is_frozen
    global title_is_probably_good
    title_is_probably_good = False
    title_is_frozen = False
    force_update = False
    scrub_publisher_from_title(my_db,my_cursor,my_current_book,notifications,log)
    scrub_isbn_in_title(my_db,my_cursor,my_current_book,notifications,log)
    scrub_the_lewis_the_lover_scenario(my_db,my_cursor,my_current_book,notifications,log)
    check_title_for_special_patterns_to_genericize(my_db,my_cursor,my_current_book,notifications,log)
    title = ""
    orig_title = ""
    mysql = "SELECT value,'dummy' from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value from books_custom_column_8_link WHERE book = ? )"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        if len(tmp_rows) == 0:
            return
        for row in tmp_rows:
            orig_title,dummy = row
            break
    title = orig_title
    n = title.count('"')
    if n > 0:
        title = title.replace('"', "" , 10)  
        force_update = True
    n = title.count(':')
    if n > 1:
        title = title.replace(':', ' ', 10)  
    ns = title.count(" ")
    np = title.count("+")
    if np > ns:    
        title = title.replace("+", " ", 50)
        force_update = True
    ns = title.count(" ")
    np = title.count("_")
    if np > ns:    
        title = title.replace("_", " ", 50)
        force_update = True
    title = title.replace("()", "") 
    title = title.replace("[]", "")
    title = title.replace("{}", "")
    nl = title.count("[")
    nr = title.count("]")
    if nl != nr:
        title = title.replace("[", "")
        title = title.replace("]", "")
    nl = title.count("(")
    nr = title.count(")")
    if nl != nr:
        title = title.replace("(", "")
        title = title.replace(")", "")
    if title.endswith(", the") or title.endswith(", The"):
        title = title[0:-5]
        title = title.strip()
    title = title.replace(",", ", ")
    title = title.replace("  ", " ")
    has_letters = False
    has_hash = False
    has_parens = False
    for item in title:
        s = item
        if s.isalpha():
            has_letters = True
        if s == ")" or s == "(" :      
            has_parens = True
            break
    if has_letters and (not has_parens):
        s_original = title
        title = add_missing_spaces_to_camelback_strings(title)
        if len(title) < len(s_original):  
            title = s_original   
    else:
        pass
    orig_title = title
    tag_found = False
    nt = title.count("Sex")
    if nt > 0:
        probable_tags_to_add_list.append("Sex")
        tag_found = True
    nt = title.count("Wolf Pack")
    if nt > 0:
        probable_tags_to_add_list.append("Werewolves")
        tag_found = True
    nt = title.count("Werewol")
    if nt > 0:
        probable_tags_to_add_list.append("Werewolves")
        tag_found = True
    nt = title.count("Fae ")
    if nt > 0:
        probable_tags_to_add_list.append("Faeries")
        tag_found = True
    nt = title.count("Faer")
    if nt > 0:
        probable_tags_to_add_list.append("Faeries")
        tag_found = True
    nt = title.count("Witch")
    if nt > 0:
        probable_tags_to_add_list.append("Witches&Warlocks")
        tag_found = True
    nt = title.count("Warlock")
    if nt > 0:
        probable_tags_to_add_list.append("Witches&Warlocks")
        tag_found = True
    nt = title.count("Thriller")
    if nt > 0:
        probable_tags_to_add_list.append("Thriller")
        tag_found = True
    nt = title.count("Mystery")
    if nt > 0:
        probable_tags_to_add_list.append("Mystery")
        tag_found = True
    nt = title.count("Mysteries")
    if nt > 0:
        probable_tags_to_add_list.append("Mystery")
        tag_found = True
    nt = title.count("Adventure")
    if nt > 0:
        probable_tags_to_add_list.append("Action&Adventure")
        tag_found = True
    nt = title.count("Suspense")
    if nt > 0:
        probable_tags_to_add_list.append("Suspense")
        tag_found = True
    nt = title.count("Erotic")
    if nt > 0:
        probable_tags_to_add_list.append("Romance")
        tag_found = True
    nt = title.count("Romance")
    if nt > 0:
        probable_tags_to_add_list.append("Romance")
        tag_found = True
    nt = title.count("Paranormal")
    if nt > 0:
        probable_tags_to_add_list.append("Paranormal")
        tag_found = True
    nt = title.count("Romantic")
    if nt > 0:
        probable_tags_to_add_list.append("Romance")
        tag_found = True
    nt = title.count("Crime")
    if nt > 0:
        probable_tags_to_add_list.append("Crime")
        tag_found = True
    nt = title.count("Historical Romance")
    if nt > 0:
        probable_tags_to_add_list.append("Historical Romance")
        tag_found = True
    nt = title.count("Walking Dead")
    if nt > 0:
        probable_tags_to_add_list.append("Zombies")
        tag_found = True
    nt = title.count("Living Dead")
    if nt > 0:
        probable_tags_to_add_list.append("Zombies")
        tag_found = True
    nt = title.count(" Undead")
    if nt > 0:
        probable_tags_to_add_list.append("Zombies")
        tag_found = True
    nt = title.count("Zombie")
    if nt > 0:
        probable_tags_to_add_list.append("Zombies")
        tag_found = True
    nt = title.count("Vampire")
    if nt > 0:
        probable_tags_to_add_list.append("Vampires")
        tag_found = True
    nt = title.count("Fantasy")
    if nt > 0:
        probable_tags_to_add_list.append("Fantasy")
        tag_found = True
    nt = title.count("Shifter")
    if nt > 0:
        probable_tags_to_add_list.append("Shapeshifter")
        tag_found = True
    nt = title.count("Werebear")
    if nt > 0:
        probable_tags_to_add_list.append("Shapeshifter")
        tag_found = True
    nt = title.count(": A Novel")
    if nt > 0:
        probable_tags_to_add_list.append("Fiction")
        tag_found = True
    nt = title.count(" Novel ")
    if nt > 0:
        probable_tags_to_add_list.append("Fiction")
        tag_found = True
    nt = title.count("Magazine")
    if nt > 0:
        probable_tags_to_add_list.append("Magazines")
        tag_found = True
    nt = title.count("True Story")
    if nt > 0:
        probable_tags_to_add_list.append("Factual:True Story")
        tag_found = True
    if tag_found :
        log("New Work Tag(s) derived from book: ", title)
    my_re1 = "^[A-Z ]+$"  
    p1 = re.compile(my_re1)
    match1 = p1.search(title)
    if match1:
        try:
            title = title.lower() #have to lower case it before titlecasing it.
        except:
            pass
        title = titlecase(title)
        title_is_probably_good = True
        title_is_frozen = True
        force_update = True
    else:
        pass
    my_re1 = "^THE BOOK OF BOOKS"  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
        n1 = len(title)
        if n1 > 50:
            title = title[0:17]
            force_update = True
    else:
        pass
    my_re1 = "^[a-z ]+\s[0-9]+\s[a-z ]+$"  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
        return   
    else:
        pass
    my_re1 = "^[a-z ]+[ ][0-9]+[-][0-9]+$"  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
        return   
    else:
        pass
    my_re1 = "^Microsoft Word - [a-z]+\s[a-z]\s[a-z]+\s-\s"  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = False
        title_is_frozen = False
        title = title.replace("Microsoft Word - ", "")
        n = title.find("-")
        new_author = title[0:n-1]
        title = title[n+1: ]
        force_update = True
        force_author_update = True
    else:
        new_author = ""
        force_author_update = False
    n1 = len(title)
    title = title.replace("It's", "It is")
    title = title.replace("Don't", "Do not")
    title = title.replace("don't", "do not")
    title = title.replace("we're", "we are")
    title = title.replace("We're", "We are")
    title = title.replace("Novellas", "Novels")
    title = title.replace("Novella", "Novel")
    title = title.strip()
    n2 = len(title)
    if n1 != n2:
        force_update = True
    if "Epilogue" in title:
        title = title.replace("[Epilogue]", "")
        title = title.replace("(Epilogue)", "")
        force_update = True
    if "Free Magazines Download in PDF for iPad/PC" in title:
        title = title.replace("Free Magazines Download in PDF for iPad/PC", "")
        title = title.replace("Storemags -", "Magazine")
        title = title.strip()
        force_update = True
    if force_update:
        global fancy_quotes_set
        for quote in fancy_quotes_set:
            title = title.replace(quote, "'")
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
        orig_title = title #reset orig_title
        force_update = False
    if force_author_update:
        for quote in fancy_quotes_set:
            new_author = new_author.replace(quote, "'")
        mysql = 'UPDATE custom_column_4 SET value =  ? WHERE  custom_column_4.id IN \
                                    (SELECT value FROM books_custom_column_4_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,new_author,my_current_book)
        new_author = ""
        force_author_update = False
    if not force_update:
        my_re1 = '^[0-9]*[0-9]:[0-9][0-9]$'  
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_is_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
        my_re1 = "^[a-z ]+:\sA\s[a-z' ]+\s[NovelMysteryThrillerRomance]+$"  
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_is_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
        my_re1 = "^[a-z]+['][s]\s[a-z ]+$"  
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_is_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
        my_re1 = "^[a-z ]+$"  
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_is_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
        my_re1 = "^[0-9]+[:]\sA\sPortrait\sof[a-z ]+$"  
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_is_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
        my_re1 = "^The\s[0-9]+[thstrdn]+[a-z ]+$"          
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_is_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
    else:
        pass
    title = title.strip()
    if title == "":
        title = "_Unknown_"
    if title == "_":
        title = "_Unknown_"
    if title == "Untitled" or title == "untitled":
        title = "_Unknown_"
    if title.startswith("-") or title.startswith(":") or title.startswith(";"):
        title = title[1: ]
        title = title.strip() #removes leading and trailing spaces
    if title.endswith("-") or title.endswith(":") or title.endswith(";"):
        title = title[0:-1]
        title = title.strip() #removes leading and trailing spaces
    title = remove_bad_keywords(title)
    title = title.replace("()", "")
    title = title.replace("[]", "")
    n = title.count(" Boxed Set")
    if n > 0:
        title_is_probably_good = True
        title_is_frozen = True
    n = title.count("Multi-Author Bundle")
    if n > 0:
        title_is_probably_good = True
        title_is_frozen = True
    n = title.count("Bundle of Novel")
    if n > 0:
        title_is_probably_good = True
        title_is_frozen = True
    n1 = title.count("--")
    n2 = title.count("?")
    n3 = title.count(":")
    if n1 > 0 and (n2 > 0 or n3 > 0):
        title_is_probably_good = True
        title_is_frozen = True
    nl = title.count("(") 
    nr = title.count(")")
    if nl == 0 and nr == 1:
        title = title.replace(")", "")
    if nl == 1 and nr == 0:
        title = title.replace("(", "")
    title = title.replace(" II ", " 2 ")  
    title = title.replace(" III ", " 3 ")
    title = title.replace(" IV ", " 4 ")
    title = title.replace("Ifan ", "If an ")
    title = title.replace("Ifa ", "If a ")
    if title == "Collected Stories Of" or title == "Collected Stories of" :
        title = "Collected Stories"
    title = title.strip()
    n1 = title.count(": Part One:")
    n2 = title.count(": Part Two:")
    n3 = title.count(": Part Three:")
    n4 = title.count(": Part Four:")
    if n1 > 0 or n2 > 0 or n3 > 0 or n4 > 0:
        title = title.replace(": Part One:", " Part One [ #1  ") 
        title = title.replace(": Part Two:", " Part Two [ #2  ") 
        title = title.replace(": Part Three:", " Part Three [ #3  ")
        title = title.replace(": Part Four:", " Part Four [ #4  ")
        title = title + "]"
        title = title.replace("(", "")
        title = title.replace(")", "")
        title = title.replace("  ", " ")
        title = title.strip()
    my_re1 = "http://.+.com" 
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = re.sub(my_re1, "", title)
    my_re1 = "http://.+.org"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = re.sub(my_re1, "", title)
    my_re1 = "http://.+.net"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = re.sub(my_re1, "", title)
    title = title.replace(".com", ".xxxx")
    title = title.replace(".org", ".xxxx")
    title = title.replace(".html", ".xxxx")
    title = title.replace(".htm", ".xxxx")
    title = title.replace(".php", ".xxxx")
    n1 = title.find("http")
    n2 = title.find(".xxxx")      
    if n1 >= 0 and n2 >= 0:    
        s = title[n1:n2+5]
        title = title.replace(s, "")
        if title == "" or title == " ":
            title = "_Unknown_"
    else:
        if n1 >= 0: #example: http://www.mindmined.com/public_library/nonfiction/claire_wolfe
            n3 = title.rfind("/")
            if n3 > n1:
                s = title[n1:n3+1]
                title = title.replace(s, "")
                if title == "" or title == " ":
                    title = "_Unknown_"
            else:
                pass
    my_re1 = '^[Mr.]+\s[a-z ]+:\sA\s[a-z ]+\s[NovelMysteryThrillerRomanceNovella]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
        return
    else:
        pass
    title = remove_bad_keywords(title)
    title = title.strip()
    if title.endswith("a Thriller") or title.endswith("A Thriller"):
        title = title[0:-10]
        title = title.strip()
    if title.endswith("a Romance") or title.endswith("A Romance"):
        title = title[0:-9]
        title = title.strip()
    if title.endswith("-"):
        title = title[0:-1]
        title = title.strip()
    if title.endswith(":"):
        title = title[0:-1]
        title = title.strip()
    if title.endswith(";"):
        title = title[0:-1]
        title = title.strip()
    if title.endswith(","):
        title = title[0:-1]
        title = title.strip()
    if title.endswith(" La") or title.endswith(" la"):
        title = title[0:-3] #residual artifact from Novella
    title = title.replace("of S & Novellas", "of Novels & Novellas")
    title = title.replace("[Epilogue]", "")
    title = title.replace("Dept.", "Department")
    title = title.replace(": Vol ", " Volume ")
    title = title.replace("Vol.1", " Volume 1")
    title = title.replace("Vol1", " Volume 1")
    title = title.replace("Vol.2", " Volume 2")
    title = title.replace("Vol2", " Volume 2")
    title = title.replace("Vol.3", " Volume 3")
    title = title.replace("Vol3", " Volume 3")
    title = title.replace("Vol.4", " Volume 4")
    title = title.replace("Vol4", " Volume 4")
    title = title.replace("Vol.5", " Volume 5")
    title = title.replace("Vol5", " Volume 5")
    title = title.replace(": Vol ", " Volume ")
    title = title.replace("Vol.1", " Volume 1")
    title = title.replace("Vol1", " Volume 1")
    title = title.replace("Vol.2", " Volume 2")
    title = title.replace("Vol2", " Volume 2")
    title = title.replace("Vol.3", " Volume 3")
    title = title.replace("Vol3", " Volume 3")
    title = title.replace("Vol.4", " Volume 4")
    title = title.replace("Vol4", " Volume 4")
    title = title.replace("Vol.5", " Volume 5")
    title = title.replace("Vol5", " Volume 5")
    title = title.replace("Vol. 1", " Volume 1")
    title = title.replace("Vol 1", " Volume 1")
    title = title.replace("Vol. 2", " Volume 2")
    title = title.replace("Vol 2", " Volume 2")
    title = title.replace("Vol. 3", " Volume 3")
    title = title.replace("Vol 3", " Volume 3")
    title = title.replace("Vol. 4", " Volume 4")
    title = title.replace("Vol 4", " Volume 4")
    title = title.replace("Vol. 5", " Volume 5")
    title = title.replace("Vol 5", " Volume 5")
    title = title.replace("Vol. 1", " Volume 1")
    title = title.replace("Vol 1", " Volume 1")
    title = title.replace("Vol. 2", " Volume 2")
    title = title.replace("Vol 2", " Volume 2")
    title = title.replace("Vol. 3", " Volume 3")
    title = title.replace("Vol 3", " Volume 3")
    title = title.replace("Vol. 4", " Volume 4")
    title = title.replace("Vol 4", " Volume 4")
    title = title.replace("Vol. 5", " Volume 5")
    title = title.replace("Vol 5", " Volume 5")
    title = title.replace("[]", "")
    title = title.strip()
    title = title.replace("Not for Resale or Distribution", "")
    n = title.count(" Novel ")
    if n > 0:
        n = title.count("- a ")
        if n > 0:
            title = title.replace("- a ", "- ")
            title = title.replace(" Novel ", " ")
            n = title.count(": A ")
            if n > 0:
                title = title.replace(": A ", ": ")
    title = title.replace(" Novels", " ")
    title = title.replace(" Novel", " ")
    if title.endswith(": A"):
        title = title[0:-3]
    title = title.replace("  ", " ")
    title = title.strip()
    title = remove_bad_keywords(title)
    if title.endswith(", the"):
        title = title[ 0:-5]
    title = title.replace("  ", " ")  
    title = title.strip()
    n = title.count(".")
    if n > 1:
        title = title.replace(". "," " , 50)
        title = title.replace("."," " , 50)
        title = title.replace("  ", " ")  
        title = title.strip()
    else:
        pass
    title = title.replace("\\", " & ") #now:  Ice Lake: Gone Cold & Cold Heat & Stone Cold
    title = title.replace("  ", " ")  
    title = title.replace("  ", " ") #change double spaces to single space
    title = title.strip()
    if title.endswith("-"): title = title[0:-1] #artifact from scrubbing
    title = title.replace("  ", " ") #change double spaces to single space
    title = title.strip()
    n = title.count("-")
    if n > 2:
        title_is_frozen = True
    title = title.replace("( - ", "(")
    title = title.replace("  ", " ", 5)
    title = title.replace("( ", "(")
    title = title.replace("|", "") #causes regex errors
    title = title.replace(",:", "")
    np = title.count("(")
    nb = title.count("[")
    if np > 0 or nb > 0:
        n = title.count(".")
        if n > 1:
            title = title.replace(". ", " ", 50)
            title = title.replace(".", " ", 50)
    title = title.strip()
    title = title.replace("(-", "(")
    title = title.replace("( -", "(")
    title = title.replace("--", "-")
    title = title.replace("- -", "-")
    title = title.replace("()", "")
    title = title.replace("( )", "")
    title = title.replace("(  )", "")
    title = title.replace("(   )", "")
    if title.endswith(" La") or title.endswith(" la"):
        title = title[0:-3] #residual artifact from Novella
    title = title.replace("  ", " ")
    title = title.strip()
    if orig_title != title:
        force_update = True
    n1 = title.count(":")
    n2 = title.count(",")
    n3 = title.count(" ")
    n4 = title.count("'")
    n5 = len(title)
    if n5 >= 50 or n3 >= 10 or (n2 >= 3 and n1 > 0) or n4 >= 4:
        title_is_probably_good = True
        title_is_frozen = True
    title = title.replace("( - ", "(")
    title = title.replace("  ", " ", 5)
    title = title.replace("( ", "(")
    title = title.replace("|", "") #causes regex errors
    np = title.count("(")
    nb = title.count("[")
    if np > 0 or nb > 0:
        n = title.count(".")
        if n > 1:
            title = title.replace(". ", " ", 50)
            title = title.replace(".", " ", 50)
    title = title.strip()
    n = title.count(" ")
    if n == 0:
        title = add_missing_spaces_to_camelback_strings(title)
    my_re13a = "^97[8-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"
    my_re13b = "^97[8-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    my_re10a = "^[0-1][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9X]"         
    my_re10b = "^[0-1][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    p1 = re.compile(my_re13a, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
       title = title.replace("(97", "97") #break the matched parens
    p1 = re.compile(my_re10a, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
       title = title.replace("(0", "0") #break the matched parens
       title = title.replace("(1", "1") #break the matched parens
    try:
        title = title.lower()
    except:
        pass
    title = titlecase(title) #first titlecase so far; avoid earlier to matching for replacement false-negatives
    my_re1 = "\(A[n]*\s.+\s[ThrillerMysteryRomance]+\)$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        s0 = match1.group(0)
        s1 = match1.group(0)
        s1 = s1.replace("An ", "")
        s1 = s1.replace("A ",  "")
        s1 = s1.replace(" Thriller",  "")
        s1 = s1.replace(" Mystery",  "")
        s1 = s1.replace(" Romance",  "")
        s1 = s1.replace("(", "[")
        s1 = s1.replace(")", "]")
        title = title.replace(s0, s1)
    my_re1 = "\s*[a-zA-Z]+/[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace("/", "&") #now:  Deserves to Die: Selena Alvarez&Regan Pescoli 6
    my_re1 = "^.+\s\(.+\)\s\([a-z]+\s[0-9]+\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace(") (", " ")
        title = title.replace("Volume ", "#")
        title = title.replace("Part ", "#")
    if title != orig_title: #need to update prior to returning due to pattern matching logic just after this line
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
        orig_title = title #reset orig_title
    else:
        pass
    n1 = title.count("e-book boxed set")
    if n1 > 0:
        title = title.replace("e-book boxed set", "")
        title_is_probably_good = True
        title_is_frozen = True
    n1 = title.count("boxed set")
    if n1 > 0:
        title = title.replace("boxed set", "")
        title_is_probably_good = True
        title_is_frozen = True
    title = title.replace(" : ", ": ")
    my_re1 = '^[a-z]+\s[0-9.]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        try:
            title = title.lower()
            title = titlecase(title)
            force_update = True
        except:
            pass
    else:
        pass
    my_re1 = '^[a-z ]+;\s[Oor,]+\s[a-z .]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+:\s[a-z ]+:\s[a-z ]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+\s\([a-z ]+\s[MysteryThrillerSuspenseHorrorRomance]+\)$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace("Mystery", "")
        title = title.replace("Thriller", "")
        title = title.replace("Suspense", "")
        title = title.replace("Horror", "")
        title = title.replace("Romance", "")
        title = title.replace("(", ":")
        title = title.replace(")", " #1")
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+\s[0-9]+\s[a-z ]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace("-", ":")
        title = title.replace(" :", ":")
        title_is_probably_good = False
        title_is_frozen = False
    else:
        pass
    my_re1 = '^[a-z ]+\s[0-9]+\s[a-z ]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+-[a-z ]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+Dr\.\s[a-z]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+\s[0-9]+\s[a-z ]+'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z, ]+\sIssue\s[0-9]+'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+:\s[a-z ]+Volumes\s[0-9]+-[0-9]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z, ]+\s\([a-z, ]+\)$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+:\s[a-z, ]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ,]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[0-9][0-9][0-9][0-9]$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
        return
    else:
        pass
    my_re1 = '^[a-z ]+\sVol.\s[0-9]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+\sEpisode\s[0-9]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[1-2][0-9][0-9][0-9]\s[a-z, ]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z -]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = "^[a-z ]+[0-9]+$"  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_is_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+:\sA Novel of [MysteryThrillerSuspenseHorrorRomance]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.find(": ")
        title = title[0:n]
        title = title.replace(":", "")
        title_is_probably_good = True
        title_is_frozen = True
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+:\s[a-z ]+\\*'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.count("\\")
        if n > 1:
            title_is_probably_good = True
            title_is_frozen = True
        else:
            pass
    else:
        ns = title.count("\\")   
        nc = title.count(":")
        if nc == 1 and ns > 1:
            title_is_probably_good = True
            title_is_frozen = True
        else:
            pass
    my_re1 = '^[a-z ,]+:[a-z, ]+Trilogy\s\([a-z ,-]+Book\s[0-9]+\)$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        nc = title.find(":")
        np = title.find("(")
        s1 = title[0:nc]
        s2 = title[np: ]
        s1 = s1.replace(":", "")
        s2 = s2.replace("(", "")
        s2 = s2.replace(")", "")
        s1 = s1.strip()  
        s2 = s2.strip()  
        s2 = s2.replace("Book ", "#")  
        s2 = s2.replace("-", "")  
        title = s1 + " [" + s2 + "]"
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z, ]+[\(]Book One in the[ ][a-z, ]+[ ]series[\)]$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace("Book One in the", "#1")
        title = title.replace(" Series", "")
        title = title.strip()
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z, ]+\(Book Two in the\s[a-z, ]+\sseries\)$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace("Book Two in the", "#2")
        title = title.replace(" Series", "")   
        title = title.strip()
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z].+\sBook\sOne\s[a-z ]+:\s.+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n0 = title.find(":")
        sr = title[n0: ]    
        sr = sr.replace(":", "")
        sr = sr.strip()
        n1 = title.find("One ")
        sl = title[0:n1+4]
        sl = sl.strip()
        title = sl + ":  " + sr
        title = title.replace("Book One", "#1")
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z].+\sBook\sOne\s[a-z ]+:\s.+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n0 = title.find(":")
        sr = title[n0: ]    
        sr = sr.replace(":", "")
        sr = sr.strip()
        n1 = title.find("Two ")
        sl = title[0:n1+4]
        sl = sl.strip()
        title = sl + ":  " + sr
        title = title.replace("Book Two", "#2")
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '.+\([0-9]+\)$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.find("(")
        s1 = title[0:n-1] # Kiss and Tell
        s1 = s1.replace("(", "")
        s1 = s1.strip()
        s2 = title[n: ]    
        s2 = s2.replace("(", "")
        s2 = s2.replace(")", "")
        s2 = s2.strip()
        title = s2 + "  " + s1
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '.+\s9[0-9]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.find("9")
        s1 = title[0:n-1] # Kiss and Tell
        s1 = s1.strip()
        s2 = title[n: ]   
        s2 = s2.strip()
        title = s2 + "  " + s1
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+\s\(A\s[a-z ]+\sShort\sStory\)$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.find("(")
        title = title[0:n-1] # Watching Sin
        title_is_probably_good = True
        title_is_frozen = True
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+[0-9.]+:\s[a-z, ]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.find(":")
        s1 = title[0:n] #  Bridgertons 2.5:
        s2 = title[n: ]
        s1 = s1.replace(":", "")
        s1 = s1.strip()
        n = s1.rfind(" ")
        s1a = s1[0:n]
        s1b = s1[n: ]
        s1a = s1a.strip()
        s1b = s1b.strip()
        s1 = s1a + " #" + s1b
        s2 = s2.replace(":", "")
        s2 = s2.strip()
        title = "[" + s1 + "] " + s2
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+\s\(.+\s-\sBook\s[0-9]+\)$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace("- Book ", "")
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+\s\([a-z ]+\sBook\s[0-9.]+\)$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace("Book ", "")
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^.+,\sPart\s[0-9]+:\s.+'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace(", Part ", " #") # Just One Night #1: The Stranger      which is a valid pattern for later scrubbing
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^.+\s\(.+[,:]*\sNo\.\s[0-9]+\)$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace(", No. ", "")
        title = title.replace(": No. ", "")
        title = title.replace(" No. ", "")
        title = title.replace("- No. ", "")
        title = title.replace("(", "[")
        title = title.replace(")", "]")
        title_is_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+:\s[a-z]+,\s[a-z]+,\s[a-z]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    my_re2 = '^[a-z ]+:\s[a-z]+,\s[a-z]+,\s[a-z]+,\s[a-z]+$'  
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(title)
    my_re3 = '^[a-z ]+:\s[a-z&, ]+[0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]$'  
    p3 = re.compile(my_re2, re.IGNORECASE)
    match3 = p3.search(title)
    if match1 or match2 or match3:
        title_is_probably_good = True
        title_is_frozen = True
        force_update = False
    else:
        pass
    title = title.strip()
    nc = title.count(", ")
    ns = title.count(" ")
    np = title.count("(")
    nb = title.count("[")
    n0 = title.count(":")
    if nc == ns:
        if np == 0 and nb == 0 and nb == 0: 
            title_is_probably_good = True
            title_is_frozen = True
    n1 = title.count("And Other Stories")
    if n1 > 0:
         if np == 0 and nb == 0 and nb == 0: 
            title_is_probably_good = True
            title_is_frozen = True
    n1 = title.count(" (ed)")
    if n1 > 0:
        title = title.replace(" (ed)", "")
    if title == "":
        title = "_Unknown_"
    if title.endswith(":"):
        title = title[0:-1]
        title = title.strip()
    s_lower = title.lower()
    s_lower = title.replace(" ", "", 50)
    if s_lower.isalpha():
        title_is_probably_good = True
        title_is_frozen = True
    for quote in fancy_quotes_set:
        title = title.replace(quote, "'")
    if title != orig_title or force_update:
        title = title.replace("  ", " ")           
        title = title.strip()
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
    else:
        pass
    scrub_isbn_in_title(my_db,my_cursor,my_current_book,notifications,log)
def scrub_final_final_title(my_db,my_cursor,my_current_book,notifications,log):
    global title_is_probably_good
    global title_is_frozen
    title = ""
    orig_title = ""
    mysql = "SELECT value,'dummy' from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value from books_custom_column_8_link WHERE book = ? )"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        orig_title = "ERROR"
        for row in tmp_rows:
            orig_title,dummy = row
            break
    title = orig_title
    title = title.replace(",", "")
    title = remove_bad_keywords(title)
    global fancy_quotes_set
    for quote in fancy_quotes_set:
        title = title.replace(quote, "'")
    if title.endswith("-"):    
        title = title[0:-1]
    if title.endswith("#"):    
        title = title[0:-1]
    if title.endswith("\\"):    
        title = title[0:-1]
    if title.endswith("/"):    
        title = title[0:-1]
    if title.endswith("."):    
        title = title[0:-1]
    if title.endswith(":"):    
        title = title[0:-1]
    if title.endswith(","):    
        title = title[0:-1]
    if title.endswith(" By"):    
        title = title[0:-3]
    if title.endswith(" Of"):    
        title = title[0:-3]
    if title.endswith("Number 1 In"):    
        title = title[0:-11]
    if title.endswith("Number 2 In"):    
        title = title[0:-11]
    if title.endswith("Number 3 In"):    
        title = title[0:-11]
    if title.endswith("Number 4 In"):    
        title = title[0:-11]
    if title.endswith("Number 5 In"):    
        title = title[0:-11]
    if title.endswith(" The"):    
        title = title[0:-4]
    if title.startswith("'s"):    
        title = title[2: ]
    if title.startswith("'S"):    
        title = title[2: ]
    if title.startswith(":"):    
        title = title[1: ]
    if title.startswith("Book the "):    
        title = title[5: ]
    if title.startswith("book the "):    
        title = title[5: ]
    if title.startswith("The: "):    
        title = title[5: ]
    if title.startswith("The : "):    
        title = title[6: ]
    if title.startswith(".00"):    
        title = title[3: ]
        title = title.strip()
    if title.startswith("-"):       
        title = title[1: ]
        title = title.strip()
    force_update = False
    if title == "" or title == None:
        title = "?"
        force_update = True
    my_re1 = '[M][r][A-Z]'  
    p1 = re.compile(my_re1)
    match1 = p1.search(title)
    if match1:
        s1 = match1.group(0)
        s2 = "Mr. " + s1[2:3]
        title = title.replace(s1, s2)
        force_update = True
    my_re1 = '[M][r][s][A-Z]'  
    p1 = re.compile(my_re1)
    match1 = p1.search(title)
    if match1:
        s1 = match1.group(0)
        s2 = "Mrs. " + s1[4:5]
        title = title.replace(s1, s2)
        force_update = True
    my_re1 = '[M][s][A-Z]'  
    p1 = re.compile(my_re1)
    match1 = p1.search(title)
    if match1:
        s1 = match1.group(0)
        s2 = "Ms. " + s1[4:5]
        title = title.replace(s1, s2)
        force_update = True
    title = title.replace("  ", " ")
    title = title.strip()
    if title != orig_title:
        title = add_missing_spaces_to_camelback_strings(title)
        force_update = True
    if title.startswith("Mr "):
        title = title.replace("Mr ", "Mr. ")
    if title.startswith("Ms "):
        title = title.replace("Ms ", "Ms. ")
    s = title
    title = process_title_using_title_rules(s,log)   
    if s != title:
        special_update = True
    else:
        special_update = False
    if not force_update:
        my_re1 = '^[a-z ]+:\s[a-z, ]+$'  
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            if special_update:
                update_title_only_special(my_db,my_cursor,title, my_current_book,notifications,log)
            return
        else:
            pass
        my_re1 = '^[0-9]*[0-9]:[0-9][0-9]$'  
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            if special_update:
                update_title_only_special(my_db,my_cursor,title, my_current_book,notifications,log)
            return
        else:
            pass
        my_re1 = '^[0-9][0-9][0-9][0-9]$'  
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            if special_update:
                update_title_only_special(my_db,my_cursor,title, my_current_book,notifications,log)
            return
        else:
            pass
        my_re1 = '^[a-z ,]+$'  
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            if special_update:
                update_title_only_special(my_db,my_cursor,title, my_current_book,notifications,log)
            return
        else:
            pass
        my_re1 = "^[a-z ]+[']s\s[a-z ]+$"  
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            if special_update:
                update_title_only_special(my_db,my_cursor,title, my_current_book,notifications,log)
            return
    n1 = title.count("(")
    n2 = title.count(")")
    if n1 == 1 and n2 == 0:     
        title = title.replace("(", "")
        force_update = True
    if n1 == 0 and n2 == 1:    
        title = title.replace(")", "")
        force_update = True
    if title == "Collected Stories of" :
        title = "Collected Stories"
        force_update = True
    title = title.replace("?s", "'s")
    title = title.replace("?S", "'s")
    title = title.replace("Lamour", "L'amour")
    title = title.replace("Dont", "Don't")
    title = title.replace("A?", "A")
    title = title.replace("Thriller La -", "Thriller -") 
    title = title.replace(" [ 1]", "")
    title = title.replace(" [ 2]", "")
    title = title.replace(" [ 3]", "")
    title = title.replace(" [ 4]", "")
    title = title.replace(" [ 5]", "")
    title = title.replace(" [ 5]", "")
    if title.startswith("It Is "):
        title = title.replace("It Is ", "It's ")
    if title.endswith(" The"):
        title = "The " + title[0:-3]
        title = title.strip()
    title = title.strip()
    n1 = len(title)
    n2 = title.count("_Unknown_")
    if n1 == 9 and n2 > 0:
        force_update = False
    else:
        title = title.replace("_Unknown_", "") # "_Unknown_ Children's Miscellany Too- More Useless Information That's Essential to Know"
        title = title.strip()
        force_update = True
    if title == "Untitled" or title == "untitled":
        title = "_Unknown_"
        force_update = True
    if title == "Unknown_" :
        title = "_Unknown_"
        force_update = True
    n1 = title.count("Volume I")
    if n1 > 0:
        force_update = True
    if title_is_frozen:
        if (not force_update) and (not special_update):
            return
    orig_title = title
    if title == "":
        return
    if title == "_":
        title = "_Unknown_"
    title = add_missing_spaces_to_camelback_strings(title) #apparently removes a leading "_" too....
    if title == "Untitled" or title == "untitled":
        title = "_Unknown_"
    if title == "Unknown_" :
        title = "_Unknown_"
    if title.isupper():
        title = title.lower() #so titlecase will work on it
    title = title.replace("()", "")
    title = title.replace("[]", "")
    title = title.replace("Dont", "Don't")
    title = title.strip()
    n1 = len(title)
    n2 = title.count("_Unknown_")
    if n1 == 9 and n2 > 0:
        force_update = False
    else:
        title = title.replace("_Unknown_", "") # "_Unknown_ Children's Miscellany Too- More Useless Information That's Essential to Know"
        title = title.strip()
        force_update = True
    title = titlecase(title)
    title = title.strip()
    my_re1 = "^(?P<grp1>[a-z]+\s[a-z]+)\s.+[ ](?P=grp1)$"    
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        s1 = match1.group('grp1')    
        n = title.rfind(s1)
        if n == 0:
            pass
        else:
            title = title[0:n-1]   
            if any(char.isdigit() for char in title):
                title = s1    
            else:
                pass  
            title = title.strip()
            force_update = True
    s = title
    title = process_title_using_title_rules(s,log)   
    if s != title:
        special_update = True
    if title == "":
        title = "?"
        special_update = True
    if (title != orig_title) or force_update or special_update:
        title_is_probably_good = True
        title = title.replace("  ", " ")           
        title = title.strip()
        if title == "":
            title = "?"
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
    else:
        pass
def update_title_only_special(my_db,my_cursor,title, my_current_book,notifications,log):
    global title_is_probably_good
    title_is_probably_good = True
    title = title.replace("  ", " ")           
    title = title.strip()
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
def scrub_obvious_series_still_in_title_within_delimiters(my_db,my_cursor,my_current_book,notifications,log): #fix: Pulse - Part Four (The Pulse Series)
    global can_force_update_of_series
    global title_is_probably_good
    global title_is_frozen
    title = ""
    orig_title = ""
    real_title = ""
    mysql = "SELECT title,'dummy' from books WHERE id = ? "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        for row in tmp_rows:
            title,dummy = row
            real_title = title
            break
    else:
        return
    mysql = "SELECT value,'dummy' from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value from books_custom_column_8_link WHERE book = ? )"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    orig_title = None
    if tmp_rows:
        for row in tmp_rows:
            orig_title,dummy = row
            break
    if orig_title is None:
        return
    title = orig_title
    if title == "":
        return
    else:
        if not ("(" in title and ")" in title):
            if not ("[" in title and "]" in title):
                if not ("<" in title and ">" in title):
                    if not ("{" in title and "}" in title):
                        return
    p1 = title.find("(")
    p2 = title.find(")")
    if p1 >= 0 and p2 >= 0:
        if p2 < p1:
            return
        else:
            title = title.replace("(","[")     
            title = title.replace(")","]")     
            pass
    p1 = title.find("[")
    p2 = title.find("]")
    if p1 >= 0 and p2 >= 0:
        if p2 < p1:
            return
        else:
            pass
    p1 = title.find("<")
    p2 = title.find(">")
    if p1 >= 0 and p2 >= 0:
        if p2 < p1:
            return
        else:
            pass
    p1 = title.find("{")
    p2 = title.find("}")
    if p1 >= 0 and p2 >= 0:
        if p2 < p1:
            return
        else:
            pass
    title = title.replace("Book One in the ", "1 ")
    title = title.replace("Series", "")
    tmp_series = ""
    was_genericized = False
    title = title.strip()
    title = title.replace("  "," ")   
    title = title.replace(", #",",#") 
    if title.endswith("]") and (",#" in title):           
        re_x = "[\[][\'\& \- a-z \.]+[,][ ]*[#][0-9]+[.]*[0-9]*[ ]*[\]]$"
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(title)
            if matchx:       
                was_genericized = True
                s_split = title.split("[")
                title = s_split[0]
                title = title.strip()
                tmp_series = s_split[1]
                tmp_series = tmp_series.replace(", #",",#")   
                tmp_series = tmp_series.replace(",#","   ,#  ")   
                s_split = tmp_series.split(",#")
                tmp_series = s_split[0]
                tmp_series = tmp_series.strip()
                tmp_index = s_split[1]
                tmp_index = tmp_index.replace("]", "")
                tmp_index = tmp_index.strip()
                mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
                execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
                title_is_probably_good = True
                title_is_frozen = True
                can_force_update_of_series = True
                tmp_series = as_unicode(tmp_series)
                tmp_index = as_unicode(tmp_index)
                generic_update_work_series_seriesindex(my_db,my_cursor,my_current_book,tmp_series,tmp_index,log)
                return
            else:
                pass
        except Exception as e:
            log("ERROR: scrub_obvious_series_still_in_title_within_delimiters:  " + as_unicode(e) + "Please forward this log to the Developer.  Thank you.")
            pass
    was_genericized = False
    title = title.strip()
    if title.endswith("]") and "#" in title:
        re_x = "[\[][\'\& \- a-z \.]+[ ]*[#][0-9]+[.]*[0-9]*[ ]*[\]]$"
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(title)
            if matchx:       
                was_genericized = True
                s_split = title.split("[")
                title = s_split[0]
                title = title.strip()
                tmp_series = s_split[1]
                tmp_series = tmp_series.replace("#"," #")   
                s_split = tmp_series.split("#")
                tmp_series = s_split[0]
                tmp_series = tmp_series.strip()
                tmp_index = s_split[1]
                tmp_index = tmp_index.replace("]", "")
                tmp_index = tmp_index.strip()
                mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
                execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
                title_is_probably_good = True
                title_is_frozen = True
                can_force_update_of_series = True
                generic_update_work_series_seriesindex(my_db,my_cursor,my_current_book,tmp_series, tmp_index,log)
                return
            else:
                pass
        except:
            pass
    my_re1 = '\(.+\)'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        s = match1.group(0)
        title = title.replace(s, "")
        tmp_series = s
    else:
        my_re2 =  '\[.+\]'  
        p2 = re.compile(my_re2, re.IGNORECASE)
        match2 = p2.search(title)
        if match2:
            s = match2.group(0)
            title = title.replace(s, "")
            tmp_series = s
        else:
           pass
    title = title.replace("[", "(") #should not find any, but just in case
    title = title.replace("]", ")")
    title = title.replace("<", "(")
    title = title.replace(">", ")")
    title = title.replace("{", "(")
    title = title.replace("}", ")")
    my_re3 = '\(.+\)'  
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(title)
    if match3:
        s = match3.group(0)
        title = title.replace(s, "", 3)
        tmp_series = s
    else:
        pass
    if (not match1) and (not match2) and (not match3):
        return    
    title = title.replace(":", "")
    title = title.replace(";", "")
    multi_book_book = False
    try:
        my_re1 = "[0-9]+[-][0-9]+"
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if not match1:
            title = title.replace("-", "")
        else:
            s1 = match1.group(0)
            title = title.replace(s1,"^^|^|^^")
            title = title.replace("-", "")
            title = title.replace("^^|^|^^",s1)
            tmp_series = title.replace(s1,"")  
            multi_book_book = True
    except:
        title = title.replace("-", "")
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;'
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,title,my_current_book)
    title_is_probably_good = True
    tmp_series = tmp_series.replace("[", "(")
    tmp_series = tmp_series.replace("]", ")")
    tmp_series = tmp_series.replace("<", "(")
    tmp_series = tmp_series.replace(">", ")")
    tmp_series = tmp_series.replace("{", "(")
    tmp_series = tmp_series.replace("}", ")")
    tmp_series = tmp_series.replace("(", "")                    
    tmp_series = tmp_series.replace(")", "")
    tmp_series = tmp_series.replace("Book", "")              
    tmp_series = tmp_series.replace("book", "")             
    tmp_series = tmp_series.replace("#", "")                    
    tmp_series = tmp_series.strip()
    if not was_genericized:
        if not  multi_book_book:     
            tmp_index = "0"
            tmp_index = find_part_number_in_title(as_unicode(real_title))
        else:
            tmp_index = "1"             
    tmp_series = tmp_series.replace(tmp_index, "")       
    tmp_series = tmp_series.replace("  ", " ")
    tmp_series = tmp_series.strip()
    can_force_update_of_series = True
    generic_update_work_series_seriesindex(my_db,my_cursor,my_current_book,tmp_series, tmp_index,log)
def scrub_obvious_series_still_in_title_with_no_delimiters(my_db,my_cursor,my_current_book,notifications,log):   
    global set_of_author_symbols
    global set_of_letters
    global set_of_letters_and_author_symbols
    global set_of_numbers
    global set_of_numbers_and_symbols
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_title_characters
    global title_is_frozen
    global title_is_probably_good
    if title_is_probably_good or title_is_frozen:
        return
    title = ""
    orig_title = ""
    tmp_title = ""
    tmp_series = ""
    tmp_index = ""
    mysql = "SELECT value,'dummy' from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value from books_custom_column_8_link WHERE book = ? )"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        for row in tmp_rows:
            orig_title,dummy = row
            break
    else:
        return
    title = orig_title
    if title == "":
        return
    elif ("(" in title and ")" in title):
        return
    elif ("[" in title and "]" in title):
        return
    elif ("<" in title and ">" in title):
        return
    elif ("{" in title and "}" in title):
        return
    n1 = title.count(":")
    n2 = title.count(",")
    n3 = title.count("-")
    n4 = title.count(".")
    n5 = title.count("#")
    n6 = 0
    if any(char.isdigit() for char in title):
        n6 = 1
    if n6 > 0:
        pass
    else:
        if n4 == 1:
            if n1 == 0 and n2 == 0 and n3 == 0 and n5 == 0:
                return      
        else:
            if n2 == 1:
                if n1 == 0 and n3 == 0 and n4 == 0 and n5 == 0:
                    return      
    my_re1 = "\s*[a-zA-Z]+/[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = title.replace("/", "&") #now:  Deserves to Die: Selena Alvarez&Regan Pescoli 6
    p1 = title.find(":")
    p2 = title.find(",")
    p3 = title.find("-")
    p4 = title.find(".")
    p5 = title.find("#")
    t1 = title.find("Book")
    t2 = title.find("Series")
    t1a = title.find(" book")
    t2a = title.find(" series")
    if t1 >=0:
        pass
    else:
        if t1a >= 0:
            t1 = t1a
    if t2 >=0:
        pass
    else:
        if t2a >= 0:
            t2 = t2a
    found_digit = False
    dstart = 9999
    dend = 0
    i = -1
    for c in title:
        i = i + 1
        if c.isdigit():
            found_digit = True
            if dstart == 9999:
                dstart = i
                dend = i + 1 #init
            else:
                dend = i
        else:
            pass
    if found_digit:
        try:
            dend = dend + 1
            seriesindex = title[dstart:dend]
        except Exception as e:
            seriesindex = '0'
    else:
        seriesindex = '0'
    found_alpha = False
    for c in seriesindex:
        if not c.isdigit():
            found_alpha = True
    if found_alpha:
        seriesindex = '0'
        found_good_index = False
    else:
        found_good_index = True
    if p1 >= 0:
        is_colon = True
    else:
        is_colon = False
    if p2 >= 0:
        is_comma = True
    else:
        is_comma = False
    if p3 >= 0:
        is_dash = True
    else:
        is_dash = False
    if p4 >= 0:
        is_dot = True
    else:
        is_dot = False
    if p5 >= 0:
        is_hash = True
    else:
        is_hash = False
    if t1 >= 0:
        is_book = True
    else:
        is_book = False
    if t2 >= 0:
        is_series = True
    else:
        is_series = False
    colon_to_left_of_comma = False
    colon_to_left_of_dash = False
    colon_to_left_of_dot = False
    colon_to_left_of_hash = False
    colon_to_left_of_book = False
    colon_to_left_of_series = False
    comma_to_left_of_colon = False
    comma_to_left_of_dash = False
    comma_to_left_of_dot = False
    comma_to_left_of_hash = False
    comma_to_left_of_book = False
    comma_to_left_of_series = False
    dash_to_left_of_colon = False
    dash_to_left_of_comma = False
    dash_to_left_of_dot = False
    dash_to_left_of_hash = False
    dash_to_left_of_book = False
    dash_to_left_of_series = False
    dot_to_left_of_colon = False
    dot_to_left_of_comma = False
    dot_to_left_of_dash = False
    dot_to_left_of_hash = False
    dot_to_left_of_book = False
    dot_to_left_of_series = False
    hash_to_left_of_colon = False
    hash_to_left_of_comma = False
    hash_to_left_of_dash = False
    hash_to_left_of_dot = False
    hash_to_left_of_book = False
    hash_to_left_of_series = False
    book_to_left_of_colon = False
    book_to_left_of_comma = False
    book_to_left_of_dash = False
    book_to_left_of_dot = False
    book_to_left_of_hash = False
    book_to_left_of_series = False
    title_copy = title
    try:
        title_copy = title_copy.lower()
    except:
        pass
    a1 = title_copy.find("ty-one")
    a2 = title_copy.find("ty-two")
    a3 = title_copy.find("ty-three")
    a4 = title_copy.find("ty-four")
    a5 = title_copy.find("ty-five")
    a6 = title_copy.find("ty-six")
    a7 = title_copy.find("ty-seven")
    a8 = title_copy.find("ty-eight")
    a9 = title_copy.find("ty-nine")
    if a1 >= 0 or a2 >=0 or a3 >=0 or a4 >=0 or a5 >= 0 or a6 >=0 or a7 >=0 or a8 >=0 or a9 >=0:
        is_dash = False
    if is_colon:
        if is_comma:
            if p1 < p2:
                colon_to_left_of_comma = True
            else:
                colon_to_left_of_comma = False
        if is_dash:
            if p1 < p3:
                colon_to_left_of_dash = True
            else:
                colon_to_left_of_dash = False
        if is_dot:
            if p1 < p4:
                colon_to_left_of_dot = True
            else:
                colon_to_left_of_dot = False
        if is_hash:
            if p1 < p5:
                colon_to_left_of_hash = True
            else:
                colon_to_left_of_hash = False
        if is_book:
            if p1 < t1:
                colon_to_left_of_book = True    
            else:
                colon_to_left_of_book = False
        if is_series:
            if p1 < t2:
                colon_to_left_of_series = True   
            else:
                colon_to_left_of_series = False
    if is_comma:
        if is_colon:
            if p2 < p1:
                comma_to_left_of_colon = True
            else:
                comma_to_left_of_colon = False
        if is_dash:
            if p2 < p3:
                comma_to_left_of_dash = True
            else:
                comma_to_left_of_dash = False
        if is_dot:
            if p2 < p4:
                comma_to_left_of_dot = True
            else:
                comma_to_left_of_dot = False
        if is_hash:
            if p2 < p5:
                comma_to_left_of_hash = True
            else:
                comma_to_left_of_hash = False
        if is_book:
            if p2 < t1:
                comma_to_left_of_book = True    
            else:
                comma_to_left_of_book = False
        if is_series:
            if p2 < t2:
                comma_to_left_of_series = True   
            else:
                comma_to_left_of_series = False
    if is_dash:
        if is_colon:
            if p3 < p1:
                dash_to_left_of_colon = True
            else:
                dash_to_left_of_colon = False
        if is_comma:
            if p3 < p2:
                dash_to_left_of_comma = True
            else:
                dash_to_left_of_comma = False
        if is_dot:
            if p3 < p4:
                dash_to_left_of_dot = True
            else:
                dash_to_left_of_dot = False
        if is_hash:
            if p3 < p5:
                dash_to_left_of_hash = True
            else:
                dash_to_left_of_hash = False
        if is_book:
            if p3 < t1:
                dash_to_left_of_book = True    
            else:
                dash_to_left_of_book = False
        if is_series:
            if p3 < t2:
                dash_to_left_of_series = True   
            else:
                dash_to_left_of_series = False
    if is_dot:
        if is_colon:
            if p4 < p1:
                dot_to_left_of_colon = True
            else:
                dot_to_left_of_colon = False
        if is_comma:
            if p4 < p2:
                dot_to_left_of_comma = True
            else:
                dot_to_left_of_comma = False
        if is_dash:
            if p4 < p3:
                dot_to_left_of_dash = True
            else:
                dot_to_left_of_dash = False
        if is_hash:
            if p4 < p5:
                dot_to_left_of_hash = True
            else:
                dot_to_left_of_hash = False
        if is_book:
            if p4 < t1:
                dot_to_left_of_book = True    
            else:
                dot_to_left_of_book = False
        if is_series:
            if p4 < t2:
                dot_to_left_of_series = True   
            else:
                dot_to_left_of_series = False
    if is_hash:
        if is_colon:
            if p5 < p1:
                hash_to_left_of_colon = True
            else:
                hash_to_left_of_colon = False
        if is_comma:
            if p5 < p2:
                hash_to_left_of_comma = True
            else:
                hash_to_left_of_comma = False
        if is_dash:
            if p5 < p3:
                hash_to_left_of_dash = True
            else:
                hash_to_left_of_dash = False
        if is_dot:
            if p5 < p4:
                hash_to_left_of_dot = True
            else:
                hash_to_left_of_dot = False
        if is_book:
            if p5 < t1:
                hash_to_left_of_book = True    
            else:
                hash_to_left_of_book = False
        if is_series:
            if p5 < t2:
                hash_to_left_of_series = True   
            else:
                hash_to_left_of_series = False
    if is_book:
        if is_colon:
            if t1 < p1:
                book_to_left_of_colon = True
            else:
                book_to_left_of_colon = False
        if is_comma:
            if t1 < p2:
                book_to_left_of_comma = True
            else:
                book_to_left_of_comma = False
        if is_dash:
            if t1 < p3:
                book_to_left_of_dash = True
            else:
                book_to_left_of_dash = False
        if is_dot:
            if t1 < p4:
                book_to_left_of_dot = True
            else:
                book_to_left_of_dot = False
        if is_hash:
            if t1 < p5:
                book_to_left_of_hash = True
            else:
                book_to_left_of_hash = False
        if is_series:
            if t1 < t2:
                book_to_left_of_series = True   
            else:
                book_to_left_of_series = False
    else:
        pass
    tmp_title = title
    tmp_title = title
    my_re1 = "/^.+\d -/"
    my_re2 = "/^.+\d-/" 
    my_re3 = "/^.+\d:/" 
    my_re4 = "/^.+\d :/" #matches:  "Isles 4 : " or "ZZZZZZZ 9 : " or "ZZZZZZZ 99 :" but only if space between number and colon
    my_re5 = "^[a-z &]+[0-9]+[ -]+"  
    my_re6 = "^.+\s[IV23456]+\s-\s.+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    p2 = re.compile(my_re2, re.IGNORECASE)
    p3 = re.compile(my_re3, re.IGNORECASE)
    p4 = re.compile(my_re4, re.IGNORECASE)
    p5 = re.compile(my_re5, re.IGNORECASE)
    p6 = re.compile(my_re6, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    match2 = p2.search(tmp_title)
    match3 = p3.search(tmp_title)
    match4 = p4.search(tmp_title)
    match5 = p5.search(tmp_title)
    match6 = p6.search(tmp_title)
    was_split_already = False
    if match1 and not was_split_already:
        tmp_title = tmp_title.replace(" -", "|")
        title_split = tmp_title.split("|")
        tmp_title = title_split[1]
        tmp_series = title_split[0]
        was_split_already = True
    if match2 and not was_split_already:
        tmp_title = tmp_title.replace("-", "|")
        title_split = tmp_title.split("|")
        tmp_title = title_split[1]
        tmp_series = title_split[0]
        was_split_already = True
    if match3 and not was_split_already:
        tmp_title = tmp_title.replace(":", "|")
        title_split = tmp_title.split("|")
        tmp_title = title_split[1]
        tmp_series = title_split[0]
        was_split_already = True
        tmp_title = title
    if match4 and not was_split_already:
        tmp_title = tmp_title.replace(" :", "|")
        title_split = tmp_title.split("|")
        tmp_title = title_split[1]
        tmp_series = title_split[0]
        was_split_already = True
        tmp_title = title
        tmp_series = tmp_series
    if (match5 or match6) and not was_split_already:
        n = tmp_title.count("-")
        if n == 0:
            return
        else:
            tmp_title = tmp_title.replace("-", "|")
            title_split = tmp_title.split("|")
            tmp_title = title_split[1]    
            tmp_series = title_split[0] 
            was_split_already = True
            tmp_title = tmp_title.strip()
            tmp_series = tmp_series.strip()
    if was_split_already:
        s_string = tmp_series
        n_start = 999
        n_end = 999
        s_string, n_start, n_end = find_numbers_in_letter_string(s_string, n_start, n_end)
        if n_start != 999 and n_end != 999:
            s_number = tmp_series[n_start:n_end]   
            tmp_series = tmp_series[0:(n_start - 1)]
            if set(s_number).issubset(set_of_numbers):
                seriesindex = s_number 
                seriesindex = qs_standardize_string_numerics(seriesindex)
                found_good_index = True
            else:
                found_good_index = False
                seriesindex = '0'
        else:
            found_good_index = False
    scenario_passed = '0'
    if is_colon and not was_split_already:
        if (is_comma and colon_to_left_of_comma) or (not is_comma and not colon_to_left_of_comma):
            if (is_dash and colon_to_left_of_dash) or (not is_dash and not colon_to_left_of_dash):
                if (is_dot and colon_to_left_of_dot) or (not is_dot and not colon_to_left_of_dot):
                    if (is_hash and colon_to_left_of_hash) or (not is_hash and not colon_to_left_of_hash):
                        if (is_book and colon_to_left_of_book) or (not is_book and not colon_to_left_of_book):
                            if (is_series and colon_to_left_of_series) or (not is_series and not colon_to_left_of_series):
                                tmp_title = tmp_title.replace(":", "|")
                                title_split = tmp_title.split("|")
                                if title_split:
                                    try:
                                        tmp_title = title_split[0]
                                        tmp_series = title_split[1]
                                        was_split_already = True
                                        scenario_passed = '1'
                                    except:
                                        pass
                                else:
                                    pass
    if is_comma and not was_split_already:
        if (is_colon and comma_to_left_of_colon) or (not is_colon and not comma_to_left_of_colon):
           if (is_dash and comma_to_left_of_dash) or (not is_dash and not comma_to_left_of_dash):
                if (is_dot and comma_to_left_of_dot) or (not is_dot and not comma_to_left_of_dot):
                    if (is_hash and comma_to_left_of_hash) or (not is_hash and not comma_to_left_of_hash):
                        if (is_book and comma_to_left_of_book) or (not is_book and not comma_to_left_of_book):
                            if (is_series and comma_to_left_of_series) or (not is_series and not comma_to_left_of_series):
                                tmp_title = tmp_title.replace(",", "|")
                                title_split = tmp_title.split("|")
                                if title_split:
                                    try:
                                        tmp_title = title_split[0]
                                        tmp_series = title_split[1]
                                        was_split_already = True
                                        scenario_passed = '2'
                                    except:
                                        pass
                                else:
                                    pass
    if is_dash and not was_split_already:
        if (is_colon and dash_to_left_of_colon) or (not is_colon and not dash_to_left_of_colon):
            if (is_comma and dash_to_left_of_comma) or (not is_comma and not dash_to_left_of_comma):
                if (is_dot and dash_to_left_of_dot) or (not is_dot and not dash_to_left_of_dot):
                    if (is_hash and dash_to_left_of_hash) or (not is_hash and not dash_to_left_of_hash):
                        if (is_book and dash_to_left_of_book) or (not is_book and not dash_to_left_of_book):
                            if (is_series and dash_to_left_of_series) or (not is_series and not dash_to_left_of_series):
                                tmp_title = tmp_title.replace("-", "|")
                                title_split = tmp_title.split("|")
                                if title_split:
                                    try:
                                        tmp_title = title_split[0]
                                        tmp_series = title_split[1]
                                        was_split_already = True
                                        scenario_passed = '3'
                                    except:
                                        pass
                                else:
                                    pass
    if is_dot and not was_split_already:
        if (is_colon and dot_to_left_of_colon) or (not is_colon and not dot_to_left_of_colon):
            if (is_comma and dot_to_left_of_comma) or (not is_comma and not dot_to_left_of_comma):
                if (is_dash and dot_to_left_of_dash) or (not is_dash and not dot_to_left_of_dash):
                    if (is_hash and dot_to_left_of_hash) or (not is_hash and not dot_to_left_of_hash):
                        if (is_book and dot_to_left_of_book) or (not is_book and not dot_to_left_of_book):
                            if (is_series and dot_to_left_of_series) or (not is_series and not dot_to_left_of_series):
                                tmp_title = tmp_title.replace(".", "|")
                                title_split = tmp_title.split("|")
                                if title_split:
                                    try:
                                        tmp_title = title_split[0]
                                        tmp_series = title_split[1]
                                        was_split_already = True
                                        scenario_passed = '4'
                                    except:
                                        pass
                                else:
                                    pass
    if is_book and not was_split_already:
       if (is_colon and book_to_left_of_colon) or (not is_colon and not book_to_left_of_colon):
           if (is_comma and book_to_left_of_comma) or (not is_comma and not book_to_left_of_comma):
               if (is_dash and book_to_left_of_dash) or (not is_dash and not book_to_left_of_dash):
                    if (is_dot and book_to_left_of_dot) or (not is_dot and not book_to_left_of_dot):
                        if (is_hash and book_to_left_of_hash) or (not is_hash and not book_to_left_of_hash):
                            if (is_series and book_to_left_of_series) or (not is_series and not book_to_left_of_series):
                                tmp_title = tmp_title.replace(" book", " Book")
                                if is_colon:
                                    tmp_title = tmp_title.replace(":", "|")
                                else:
                                    if is_dash:
                                        tmp_title = tmp_title.replace("-", "|")
                                    else:
                                        pass
                                title_split = tmp_title.split("|")
                                if title_split:
                                    try:
                                        tmp_title = title_split[1]
                                        tmp_series = title_split[0] 
                                        was_split_already = True
                                        scenario_passed = '5'
                                    except:
                                        pass
                                else:
                                    pass
    if is_hash and not was_split_already:
       if (is_colon and hash_to_left_of_colon) or (not is_colon and not hash_to_left_of_colon):
           if (is_comma and hash_to_left_of_comma) or (not is_comma and not hash_to_left_of_comma):
               if (is_dash and hash_to_left_of_dash) or (not is_dash and not hash_to_left_of_dash):
                    if (is_dot and hash_to_left_of_dot) or (not is_dot and not hash_to_left_of_dot):
                        if (is_book and hash_to_left_of_book) or (not is_book and not hash_to_left_of_book):
                            if (is_series and hash_to_left_of_series) or (not is_series and not hash_to_left_of_series):
                                if is_colon:
                                    tmp_title = tmp_title.replace(":", "|")
                                else:
                                    if is_dash:
                                        tmp_title = tmp_title.replace("-", "|")
                                    else:
                                        pass
                                    title_split = tmp_title.split("|")
                                    if title_split:
                                        try:
                                            tmp_title = title_split[1]
                                            tmp_series = title_split[0]  
                                            was_split_already = True
                                            scenario_passed = '6'
                                        except:
                                            pass
                                    else:
                                        pass
    if not was_split_already:
        return
    tmp_title = tmp_title
    tmp_title = tmp_title.replace("  ", " ") #replace double spaces with single space
    tmp_title = tmp_title.strip()
    if scenario_passed == '3':
        tmp_title2 = ""
        tmp_series_number = ""
        need_to_swap1 = True
        s_string = tmp_title
        n_start = '999'
        n_end = '999'
        s_string,n_start,n_end = find_numbers_in_letter_string(s_string, n_start, n_end)
        n_start = int(n_start)
        n_end = int(n_end)
        if n_start != 999 and n_end != 999:
            need_to_swap1 = True
            s_number = tmp_title[n_start:n_end + 1]
            tmp_title2 = tmp_title[0:(n_start - 1)] 
            tmp_series_number = s_number
            tmp_series_number = qs_standardize_string_numerics(tmp_series_number)
        else:
            need_to_swap1 = False 
        tmp_series2 = ""
        tmp_series_number2 = ""
        need_to_swap2 = True
        s_string = tmp_series
        n_start = 999
        n_end = 999
        find_numbers_in_letter_string(s_string, n_start, n_end)
        n_start = int(n_start)
        n_end = int(n_end)
        if n_start != 999 and n_end != 999:
            need_to_swap2 = False #tmp_series has numerics
            s_number = tmp_series[n_start:n_end]
            tmp_series2 = tmp_series[0:(n_start - 1)]
            tmp_series_number2 = s_number
            tmp_series_number2 = qs_standardize_string_numerics(tmp_series_number2)
        else:
            need_to_swap2 = True
        if need_to_swap1 and need_to_swap2:
            tmp_title = tmp_series
            tmp_series = tmp_title2
            if tmp_series_number != "":
                seriesindex = tmp_series_number
                found_good_index = True
            else:
                pass
        else:
            pass
        if not need_to_swap2:
            if tmp_series_number2 != "":
                seriesindex = tmp_series_number2
                found_good_index = True
            else:
                pass
        else:
            pass
    else:
        pass
    tmp_title = tmp_title.replace("|", " ")
    tmp_title = tmp_title.replace("  ", " ") #remove extraneous spaces
    tmp_title = tmp_title.strip()
    tmp_series = tmp_series.replace("|", " ")
    tmp_series = tmp_series.replace("  ", " ")
    tmp_series = tmp_series.strip()
    if found_good_index:
        tmp_series = tmp_series.replace(seriesindex, "") #now: Heart's Desire,  Series - Book #
        tmp_index = seriesindex
    if was_split_already:
        if not found_good_index:
            s_string = tmp_series
            n_start = 999
            n_end = 999
            find_numbers_in_letter_string(s_string, n_start, n_end)
            if n_start != 999 and n_end != 999:
                s_number = tmp_series[n_start:n_end]   
                tmp_series = tmp_series[0:(n_start - 1)]
                if set(s_number).issubset(set_of_numbers):
                    seriesindex = s_number 
                    seriesindex = qs_standardize_string_numerics(seriesindex)
                    found_good_index = True
                else:
                    found_good_index = False
            else:
                found_good_index = False
    if found_good_index:
        tmp_series = tmp_series.replace(seriesindex, "") #now: Heart's Desire,  Series - Book #
        tmp_index = seriesindex
        tmp_index = tmp_index
        tmp_index = qs_standardize_string_numerics(tmp_index)
    else:
        seriesindex = '0'
        tmp_index = '0'
    tmp_series = tmp_series.replace('#', "")
    tmp_series = tmp_series.replace('Book', "")
    tmp_series = tmp_series.replace('book', "")
    tmp_series = tmp_series.replace('-', "")
    tmp_series = tmp_series.replace('Series', "")
    tmp_series = tmp_series.replace('series', "")
    tmp_series = tmp_series.replace(',', "")
    tmp_series = tmp_series.replace("  ", " ")
    tmp_series = tmp_series.strip()
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
    tmp_index = qs_standardize_string_numerics(tmp_index,return_integer=False,return_float=True)
    if tmp_series > " ":
        generic_update_work_series_seriesindex(my_db,my_cursor,my_current_book,tmp_series, tmp_index,log)
def scrub_the_lewis_the_lover_scenario(my_db,my_cursor,my_current_book,notifications,log):
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return
    mysql = "SELECT booktitle,'dummy' FROM __books_work_populate WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        for row in tmp_rows:
            tmp_title,dummy = row
            break
    else:
        return    
    n = tmp_title.count('"')
    if n > 0:
        tmp_title = tmp_title.replace('"', "")
    my_re1 = "^[a-z&]+\.[0-9]+\.[a-z]+\.[a-z]+\.[a-z.]+19[0-9][0-9]"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
       scrub_the_lewis_the_lover_scenario_more(my_db,my_cursor,my_current_book,notifications,log)
       return
    my_re_all = my_re1
    my_re_series_index =  "^[a-z&]+\.[0-9]+\."
    my_re_all_up_to_year = "^[a-z&]+\.[0-9]+\.[a-z]+\.[a-z]+\.[a-z.]+"
    p1 = re.compile(my_re_series_index, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
        return
    else:
        s1 = match1.group(0)
        s1 = s1
    p2 = re.compile(my_re_all_up_to_year, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    if not match2:
        return
    else:
        s2 = match2.group(0)
        s2 = s2
    s3 = s2.replace(s1, "") #The.Rider.Of.Lost.Creek.
    tmp_series = s1.replace(".", " ", 50)
    tmp_series = tmp_series.strip()
    tmp_title = s3.replace(".", " ", 50)
    tmp_title = tmp_title.strip()
    new_title = tmp_title + " " + "[" + tmp_series + "]"
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                            (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,new_title,my_current_book)
def scrub_the_lewis_the_lover_scenario_more(my_db,my_cursor,my_current_book,notifications,log):
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return
    mysql = "SELECT booktitle,'dummy' FROM __books_work_populate WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        for row in tmp_rows:
            tmp_title,dummy = row
            break
    else:
        return    
    n = tmp_title.count('"')
    if n > 0:
        tmp_title = tmp_title.replace('"', "")
    my_re1 = "^Novel[.][0-9]+[.][a-z']+[.]*[a-z']*[.]*[a-z']*[.]+19[0-9][0-9]$"    
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
        return
    s0 = tmp_title[6: ] 
    n1 = s0.find(".")
    s1 = s0[n+1: ]      
    n2 = s1.rfind(".")
    s2 = s1[0:n2]       
    s2 = s2.replace(".", " ", 50)    
    new_title = s2.strip()
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                            (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,new_title,my_current_book)
def scrub_good_series_also_in_title(my_db,my_cursor,my_current_book,notifications,log):
    global title_is_probably_good
    global title_is_frozen
    global partial_blankout_scenario
    partial_blankout_scenario = False  
    if title_is_probably_good or title_is_frozen:
        return
    tmp_title = ""
    tmp_series = ""
    tmp_seriesfull = ""
    mysql = "SELECT booktitle, seriesname, seriesfull FROM __books_work_populate WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        if len(tmp_rows) > 0:
            for row in tmp_rows:
                tmp_title, tmp_series, tmp_seriesfull = row
                break
        else:
            return    
    else:
        return    
    if tmp_title == "" or tmp_series == "" or tmp_seriesfull == "":
        return    
    if tmp_title is None or tmp_series is None or tmp_seriesfull is None:
        return    
    orig_title = tmp_title
    backup_title = orig_title
    tmp_seriesfull = tmp_seriesfull.replace("[", "")
    tmp_seriesfull = tmp_seriesfull.replace("]", "")         
    n_start = 999
    n_end = 999
    s_string = tmp_seriesfull
    s_string, n_start, n_end = find_numbers_in_letter_string(s_string, n_start, n_end)
    if n_start != 999 and n_end != 999:
        s_number = tmp_seriesfull[n_start:n_end]   
    else:
        return    
    s_number = qs_standardize_string_numerics(s_number)
    if s_number == " " or s_number == "":
        return    
    try:
        s_int = int(s_number)
    except:
        pass
    if s_int < 10 :
        tmp_seriesfull = tmp_seriesfull.replace(" 1", " 01")
        tmp_seriesfull = tmp_seriesfull.replace(" 2", " 02")
        tmp_seriesfull = tmp_seriesfull.replace(" 3", " 03")
        tmp_seriesfull = tmp_seriesfull.replace(" 4", " 04")
        tmp_seriesfull = tmp_seriesfull.replace(" 5", " 05")
        tmp_seriesfull = tmp_seriesfull.replace(" 6", " 06")
        tmp_seriesfull = tmp_seriesfull.replace(" 7", " 07")
        tmp_seriesfull = tmp_seriesfull.replace(" 8", " 08")
        tmp_seriesfull = tmp_seriesfull.replace(" 9", " 09")
    else:
        pass
    search_1 = "(" + tmp_seriesfull + ""
    search_2 = "(" + tmp_seriesfull + ""
    search_2 = search_2.replace("0", "")
    search_3 = "(" + tmp_series + ""
    search_4 = tmp_series
    search_5 = tmp_seriesfull
    search_6 = tmp_seriesfull
    search_6 = search_6.replace("0", "")
    n1 = tmp_title.find(search_1)
    n2 = tmp_title.find(search_2)
    n3 = tmp_title.find(search_3)
    n4 = tmp_title.find(search_4)
    n5 = tmp_title.find(search_5)
    n6 = tmp_title.find(search_6)
    if n1 >= 0:
        tmp_title = tmp_title.replace(search_1, "")
    if n2 >= 0:
        tmp_title = tmp_title.replace(search_2, "")
    if n3 >= 0:
        tmp_title = tmp_title.replace(search_3, "")
    if n5 >= 0:
        tmp_title = tmp_title.replace(search_5, "")
    if n6 >= 0:
        tmp_title = tmp_title.replace(search_6, "")
    if n4 >= 0:
        tmp_title = tmp_title.replace(search_4, "")
    tmp_title = tmp_title.strip()
    if tmp_title.startswith(":") or tmp_title.startswith("-"):
        tmp_title = tmp_title[1: ]
        tmp_title = tmp_title.strip()
    tmp_title = tmp_title.strip()
    if tmp_title.endswith("-"):
        tmp_title = tmp_title[0:-1]
    tmp_title = tmp_title.replace("  ", " ") #double spaces to single space
    tmp_title = tmp_title.strip()
    if not tmp_title > " ": #example:  true title was Deadlocked but the true seriesname was also Deadlocked, so true title replaced/blanked out erroneously.
        tmp_title = tmp_series
    force_update = False
    n = tmp_title.find("[")
    tmp_title1 = tmp_title[0:n]
    tmp_title1 = tmp_title1.strip()
    if tmp_title1.endswith(" the") or tmp_title1.endswith(" a") or tmp_title1.endswith(" an") \
                                                  or tmp_title1.endswith(" The") or tmp_title1.endswith(" A") or tmp_title1.endswith(" An") :
        tmp_title = orig_title
        tmp_title = tmp_title.strip()
        partial_blankout_scenario = True  
        force_update = True
    if not force_update:
        n_series = orig_title.count(as_unicode("[" + tmp_series))  
        n_far_test = orig_title.find("[")
        if n_series > 0 and n_far_test > 3:
            n_tmp_series = len(tmp_series) 
            n_left_bracket_tmp = tmp_title.find("[")
            n_left_bracket_orig = orig_title.find("[")
            if n_left_bracket_tmp == n_left_bracket_orig:
                s_orig = orig_title[n_left_bracket_orig: ]
                s_tmp = tmp_title[n_left_bracket_tmp:]
                n_s_orig = len(s_orig)
                n_s_tmp = len(s_tmp)
                if n_s_orig != n_s_tmp:
                    s_tmp_title = tmp_title[0:n_left_bracket_tmp]
                    s_tmp_title = s_tmp_title+ s_orig
                    tmp_title = s_tmp_title
                    partial_blankout_scenario = True 
                else:
                    partial_blankout_scenario = False
    if orig_title != tmp_title or force_update:
        if tmp_title > " ":
            title_is_probably_good = True
            tmp_title = titlecase(tmp_title)
            mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                        (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
        else:
            title_is_probably_good = True
            pass
def scrub_title_index_series_in_title(my_db,my_cursor,my_current_book,notifications,log):
    global is_finished_scrub_title_index_series_in_title
    global series_re_pattern_to_remove
    if is_finished_scrub_title_index_series_in_title:
        return
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return
    mysql = 'SELECT booktitle,NULL FROM __books_work_populate WHERE book = ? '
    tmp_title_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_title_rows:
        for row in tmp_title_rows:
            tmp_title,dummy = row
            break
    else:
        return    
    tmp_title = tmp_title.strip()
    tmp_title = tmp_title.replace("Book One in the ", "1 ")
    tmp_title = tmp_title.replace("Series", "")
    my_re1 = "^.+[a-zA-Z]\s-\s[a-zA-Z]+[0-9]+\s-\s[a-zA-Z]+.+" 
    my_re2 = "^.*[a-zA-Z]\s-"                                                         
    my_re3 = "\s-\s[a-zA-Z]+[0-9]+\s-\s"                                       
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
        return
    s_part1 = re.sub(my_re2, "", tmp_title)          
    s_part2 = re.sub(my_re3, "|", tmp_title)                       
    s_list1 = s_part1.split("-")
    s_list2 = s_part2.split("|")
    try:
        s_left = s_list2[0]
        s_middle = s_list1[0]
        s_right = s_list2[1]
    except:
        return
    s_part1 = as_unicode(s_left)       
    s_part2 = as_unicode(s_middle) 
    s_part3 = as_unicode(s_right)     
    s_part1 = s_part1.strip()
    s_part2 = s_part2.replace(" ", "")
    s_part2 = s_part2.replace("-", "")
    s_new2 = ""
    for s in s_part2:
        if s.isdigit():
            s_new2 = s_new2 + s
    s_part2 = s_new2
    s_part3 = s_part3.strip()
    s_part1 = add_missing_spaces_to_camelback_strings(s_part1)
    s_part1 = titlecase(s_part1)
    seriesindex = qs_standardize_string_numerics(s_new2) #new series index
    seriesindex = strip_leading_trailing_zeroes_from_series_index(seriesindex)
    s_part3= add_missing_spaces_to_camelback_strings(s_part3) #new series
    s_part3 = titlecase(s_part3)
    s_answer = "NO"  
    s_string = s_part1
    s_answer = check_string_is_valid_series(my_db,my_cursor,s_string,log)
    if s_answer == "YES":
        s1 = s_part3
        s_part3 = s_part1
        s_part1 = s1
    if s_part3 > " " and seriesindex > '0':
        tmp_series = as_unicode(s_part3)
        tmp_index = as_unicode(seriesindex)
        generic_update_work_series_seriesindex(my_db,my_cursor,my_current_book,tmp_series,tmp_index,log)
    if s_part1 > " ":
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,s_part1,my_current_book)
        is_finished_scrub_title_index_series_in_title = True
def scrub_title_series_index_in_title(my_db,my_cursor,my_current_book,notifications,log): #fix: The Sharp End - Hammer's Slammers 07
    global is_finished_scrub_title_series_index_in_title
    if is_finished_scrub_title_series_index_in_title:
        return
    global title_is_probably_good
    global title_is_frozen
    if title_is_probably_good or title_is_frozen:
        return
    mysql = 'SELECT booktitle,NULL FROM __books_work_populate WHERE book = ? '
    tmp_title_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_title_rows:
        for row in tmp_title_rows:
            tmp_title,dummy = row
            break
    else:
        return    
    tmp_title = tmp_title.strip()
    my_re1 = "^.+[ a-zA-Z]-[ a-zA-Z]+[' a-zA-Z]+[0-9]+" 
    my_re2 = "^.+[ a-zA-Z]-"                                             
    my_re3 = "[0-9]+"                                                        
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
        return
    s_save_numerics = tmp_title #need the 07 for tmp_index later...
    s_save_numerics = s_save_numerics.replace("-", "")
    s_save_numerics = s_save_numerics.replace("'", "")
    s_save_numerics = s_save_numerics.replace(" ", "")
    s_part1 = re.sub(my_re3, "", tmp_title)          
    s_part1= as_unicode(s_part1)
    s_part1 = s_part1.strip()
    tmp_title = s_part1.replace("-", "|")                             
    s_part3 = s_save_numerics          
    s_part3 = as_unicode(s_part3)
    s_string = s_part3     
    n_start = 999
    n_end = 999
    s_string,n_start,n_end = find_numbers_in_letter_string(s_string, n_start, n_end)
    if n_start != 999 and n_end != 999:
        s_number = s_string[n_start:n_end]
        tmp_index = s_number
        tmp_index = qs_standardize_string_numerics(tmp_index) 
    else:
        tmp_index = ""
    s_list1 = tmp_title.split("|")          
    n = len(s_list1)
    try:
        s_left = s_list1[0]
        tmp_title = as_unicode(s_left)
        s_right = s_list1[1]
        tmp_series = as_unicode(s_right)
    except:
        return
    tmp_title = tmp_title.strip()
    tmp_title = add_missing_spaces_to_camelback_strings(tmp_title)      
    tmp_title = titlecase(tmp_title)
    tmp_series= add_missing_spaces_to_camelback_strings(tmp_series) 
    tmp_series = titlecase(tmp_series)
    tmp_index = qs_standardize_string_numerics(tmp_index)                 
    tmp_index = strip_leading_trailing_zeroes_from_series_index(tmp_index)
    s_answer = "NO"  
    s_string = tmp_title
    s_answer = check_string_is_valid_series(my_db,my_cursor,s_string,log)
    if s_answer == "YES":
        s1 = tmp_series
        tmp_series = tmp_title
        tmp_title = s1
    if tmp_series > " " and tmp_index > '0':
        tmp_series = as_unicode(tmp_series)
        tmp_index = as_unicode(tmp_index)
        generic_update_work_series_seriesindex(my_db,my_cursor,my_current_book,tmp_series,tmp_index,log)
    if tmp_title > " ":
        tmp_title = as_unicode(tmp_title)
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
        is_finished_scrub_title_series_index_in_title = True
def check_string_is_valid_series(my_db,my_cursor,s_string,log):
    s_answer = "NO"
    s_string = as_unicode(s_string )
    s_string = s_string.replace("  ", " ") #change double spaces to single space
    s_string = s_string.replace(",", "") #remove commas
    s_string = s_string.replace("[", "")
    s_string = s_string.replace("]", "")
    s_string = s_string.replace("(", "")
    s_string = s_string.replace(")", "")
    s_string = s_string.replace("'", "")
    s_string = s_string.replace('"', "")
    s_string = s_string.replace("  ", " ") #change double spaces to single space
    s_string = s_string.strip()
    mysql = "SELECT id from  _global_series WHERE name = " + s_string + "  "
    tmp_series_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_series_rows:
        if len(tmp_series_rows) > 0:
            s_answer = "YES"
            return s_answer
    mysql = "SELECT id from  _pristine_series WHERE name = " + s_string + "  "
    tmp_series_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_series_rows:
        if len(tmp_series_rows) > 0:
            s_answer = "YES"
    return s_answer
def generic_update_work_series_seriesindex(my_db,my_cursor,my_current_book,tmp_series,tmp_index,log):
    global can_force_update_of_series
    global series_is_valid_globally
    global seriesindex_is_probably_good
    global set_of_symbols
    global freeze_current_book
    freeze_current_book = True
    s_space = " "
    tmp_index = qs_standardize_string_numerics(tmp_index,return_integer=False,return_float=True)
    if not tmp_series:
        return
    if not isinstance(tmp_series,unicode_type):
        log("ERROR: tmp_series is not a string: " + as_unicode(type(tmp_series)))
        return
    if tmp_series == "":
        return
    if tmp_series.isdigit():
        return
    if tmp_series == s_space:
        return
    if tmp_series is None:
        return
    if tmp_series == "None":
        return
    n = len(tmp_series)
    if n < 2:
        return
    x = set(tmp_series)
    if x.issubset(set_of_symbols):
        return
    my_re1 = "\s*[a-zA-Z]+/[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_series)
    if match1:
        tmp_series = tmp_series.replace("/", "&") #now:  Deserves to Die: Selena Alvarez&Regan Pescoli 6
    tmp_series = tmp_series.replace("|", "") #remove any artifact from scrubbing
    tmp_series, tmp_index = scrub_work_series_with_trilogy(tmp_series, tmp_index)
    probable_seriesname_to_add_list.append(tmp_series)
    tmp_series = tmp_series.lower()
    tmp_series = titlecase(tmp_series)
    mysql = 'SELECT seriesid,NULL FROM __books_work_ids WHERE book = ? '
    tmp_series_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    no_series_id_found = True
    if tmp_series_rows:
        if len(tmp_series_rows) > 0:
            tmp_id,dummy = tmp_series_rows[0]
            no_series_id_found = False
        else:
            no_series_id_found = True
    else:
        no_series_id_found = True
    if not isinstance(tmp_id,int):
        no_series_id_found = True
    tmp_series = add_missing_spaces_to_camelback_strings(tmp_series)
    tmp_series = tmp_series.replace(" Fbi", "FBI")
    tmp_series = tmp_series.replace(" Cia", "CIA")
    tmp_series = tmp_series.replace(" Nsa", "NSA")
    tmp_series = tmp_series.replace(" Usa", "USA")
    tmp_series = tmp_series.replace("Fbi", "FBI")
    tmp_series = tmp_series.replace("Cia", "CIA")
    tmp_series = tmp_series.replace("Nsa", "NSA")
    tmp_series = tmp_series.replace("Usa", "USA")
    tmp_series = tmp_series.replace("AnFbi", "An FBI")
    tmp_series = tmp_series.replace("AnFBI", "An FBI")
    tmp_series = tmp_series.replace("ACia", "A CIA")
    tmp_series = tmp_series.replace("ACIA", "A CIA")
    tmp_series = tmp_series.strip()
    s = tmp_series
    tmp_series = process_series_using_series_rules(s,log)
    if s != tmp_series:
        can_force_update_of_series = True
    if can_force_update_of_series and tmp_series != "" and tmp_series > " ":
        mysql = 'UPDATE custom_column_10 SET value =  ? WHERE  custom_column_10.id IN \
                                    (SELECT value FROM books_custom_column_10_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_series,my_current_book)
        sleep(0.02)
        mysql = "INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES (?,?)"
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_series)
        sleep(0.02)
        mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?)"
        execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book,my_current_book)
        check_series_against_global_valid_values(my_db,my_cursor,my_current_book,notifications,log)
    else:
        if not series_is_valid_globally:
            if tmp_series != "" and tmp_series > " ":
                if no_series_id_found: #work series name not found for this book, so add it and then link it
                    mysql = "INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES (?,?)"
                    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_series)
                    sleep(0.02)
                    mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?)"
                    execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book,my_current_book)
                else: #work series name was found, so link tmp_id to the current book
                    mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?)"
                    execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book, tmp_id)
                check_series_against_global_valid_values(my_db,my_cursor,my_current_book,notifications,log)
            else:
                seriesindex_is_probably_good = False
                can_force_update_of_series = False
                return
        else:
            pass
    if can_force_update_of_series:
        seriesindex_is_probably_good = False
    if seriesindex_is_probably_good:
        return
    if tmp_index == "" or tmp_index == s_space:
        return
    if determine_if_is_number(tmp_index):
        if float(tmp_index) > 500:
            tmp_index = 0
        try:
            mysql = 'DELETE FROM custom_column_12 WHERE book = ? '
            execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
            mysql = 'INSERT INTO custom_column_12 (id,book,value) VALUES (null,?,?) '
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=tmp_index)
            seriesindex_is_probably_good = True
        except Exception as e:
            return
    else:
        pass
    refresh_custom_column_15(my_db,my_cursor,my_current_book,notifications,log)
    can_force_update_of_series = False
def scrub_work_series_with_trilogy(tmp_series, tmp_index): #fix: The Unfailing Light (The Katerina Trilogy 2)
    s = tmp_series
    tmp_lc = s.lower()
    n1 = tmp_lc.count("trilogy")
    if n1 == 0:
        return tmp_series, tmp_index
    s = s.replace("- trilogy", "")
    s = s.replace("- Trilogy", "")
    tmp_series = s
    found_good_index = False
    seriesindex = '0'
    s_string = s #example:  The Katerina Trilogy 2
    n_start = 999
    n_end = 999
    s_string, n_start, n_end = find_numbers_in_letter_string(s_string, n_start, n_end)
    if n_start != 999 and n_end != 999:
        s_number = tmp_series[n_start:n_end]   
        tmp_series = tmp_series[0:(n_start - 1)] 
        if set(s_number).issubset(set_of_numbers):
            seriesindex = s_number 
            tmp_index = qs_standardize_string_numerics(seriesindex,return_integer=False,return_float=True)
    return tmp_series, tmp_index
def scrub_work_series_with_numerics(my_db,my_cursor,my_current_book,notifications,log): #fix: The Shadow Dance Club 4
    global set_of_numbers
    global is_finished_scrub_title_series_index_in_title
    global is_finished_scrub_title_index_series_in_title
    global can_force_update_of_series
    if is_finished_scrub_title_series_index_in_title or is_finished_scrub_title_index_series_in_title:
        return
    tmp_series = ""
    tmp_index = ""
    mysql = "SELECT seriesname, seriesindex FROM __books_work_populate WHERE book = ?  " 
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        tmp_series = None
        for row in tmp_rows:
            tmp_series,tmp_index = row
            break
    else:
        return    
    if tmp_series == None:
        return       
    if tmp_series == "":
        return
    else:
        tmp_index = qs_standardize_string_numerics(tmp_index,return_integer=False,return_float=True)
    my_re1 = "\s*[a-zA-Z]+/[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_series)
    if match1:
        tmp_series = tmp_series.replace("/", "&") #now:  Deserves to Die: Selena Alvarez&Regan Pescoli 6
    found_good_index = False
    seriesindex = '0'
    s_string = tmp_series #example:  The Shadow Dance Club 4      OR !!!       3: Elizabeth and Richard
    n_start = 999
    n_end = 999
    s_string, n_start, n_end = find_numbers_in_letter_string(s_string, n_start, n_end)
    n_start = int(n_start)
    n_end = int(n_end)
    if n_start != 999 and n_end != 999 :
        s_number = tmp_series[n_start:n_end]   
        if n_start != 0:         
            tmp_series = tmp_series[0:(n_start - 1)] 
        tmp_series = as_unicode(tmp_series)
        if set(s_number).issubset(set_of_numbers):
            seriesindex = s_number 
            seriesindex = qs_standardize_string_numerics(seriesindex,return_integer=False,return_float=True)
            found_good_index = True
            tmp_series = tmp_series.replace(as_unicode(s_number), "")
            can_force_update_of_series = True
    else:
        pass
    if found_good_index and seriesindex != '0':
        tmp_index = seriesindex
    if tmp_index == "":
        tmp_index = seriesindex
    tmp_index = tmp_index
    tmp_index = qs_standardize_string_numerics(tmp_index,return_integer=True,return_float=False)
    tmp_series = tmp_series.replace(as_unicode(tmp_index), "")
    tmp_series = tmp_series.replace("  ", " ")
    tmp_series = tmp_series.replace("[]", "")
    tmp_series = tmp_series.replace("()", "")
    tmp_series = tmp_series.replace("  ", " ") #change double spaces to single space
    tmp_series = tmp_series.replace(",", "") #remove commas
    tmp_series = tmp_series.replace("[", "")
    tmp_series = tmp_series.replace("]", "")
    tmp_series = tmp_series.replace("'", "")
    tmp_series = tmp_series.replace('"', "")
    tmp_series = tmp_series.replace("  ", " ") #change double spaces to single space
    tmp_series = tmp_series.strip()
    if tmp_series != "" and tmp_series > " ":
        generic_update_work_series_seriesindex(my_db,my_cursor,my_current_book,tmp_series,tmp_index,log)
def scrub_worktitle_workseries_swapped(my_db,my_cursor,my_current_book,notifications,log):
    global title_is_probably_good
    global seriesindex_is_probably_good
    if title_is_probably_good:
        return
    mysql = "SELECT booktitle, seriesname, seriesindex from __books_work_populate WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    series = None
    title = None
    if tmp_rows:
        for row in tmp_rows:
            title,series,series_index = row
    else:
        return
    if series is None or title is None:
        return
    if series_index is None:
        series_index = "0"
    else:
        series_index = as_unicode(series_index)
    series_index = series_index.replace(".0", "") # 3.0 now 3 but 3.5 still 3.5
    nt = title.find(series_index)
    ns = series.find(series_index)
    need_to_update = False
    if nt > 0 and ns < 0 and series_index != "0":
        tmp_title = series #now:  Fish & Chips
        tmp_series = title #now:  Cut & Run 03
        tmp_series = tmp_series.replace(series_index, "")
        need_to_update = True
    tmp_index =  "0" + series_index
    nt = title.find(tmp_index)
    ns = series.find(tmp_index)
    if nt > 0 and ns < 0 and tmp_index != "00": 
        tmp_title = series
        tmp_series = title
        tmp_series = tmp_series.replace(tmp_index, "")
        need_to_update = True
    else:
        pass
    case_b_valid = True
    if (not series_index == "0") and (not series_index == 0):
        case_b_valid = False
    if not (series.isalpha()):
        s_string = series
        n_start = 999
        n_end = 999
        s_string, n_start, n_end  = find_numbers_in_letter_string(s_string, n_start, n_end)
        if n_start != 999 and n_end != 999:
            case_b_valid = False
    if not title.isalpha():
        s_string = title
        n_start = 999
        n_end = 999
        s_string, n_start, n_end  = find_numbers_in_letter_string(s_string, n_start, n_end)
        if n_start != 999 and n_end != 999:
            pass
    else:
        case_b_valid = False
    if case_b_valid:
        mysql = "SELECT title,'dummy' from books WHERE id = ? "
        tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
        if tmp_rows:
            for row in tmp_rows:
                s_title,dummy = row
                break
        else:
             return
        n1 = s_title.find(title)
        n2 = s_title.find(":")
        n3 = s_title.find("-")
        if n1 < 0:
            case_b_valid = False
        if n2 < 0 and n3 < 0:
            case_b_valid = False
    else:
        pass
    if not case_b_valid and not need_to_update:
        return
    if case_b_valid:
        tmp_title = series
        tmp_series = title
        s_string = tmp_series
        s_start = 999
        s_end = 999
        s_string, n_start, n_end  = find_numbers_in_letter_string(s_string, n_start, n_end)
        if n_start != 999 and n_end != 999:
            s_number = tmp_series[n_start:n_end] 
            s_number = qs_standardize_string_numerics(s_number)
            tmp_series = tmp_series.replace(s_number, "") #example:  Dork Diaries
            if not s_number.isalpha():
                tmp_index = s_number 
            else:
                tmp_index = '0'
        else:
            return
        need_to_update = True
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
    title_is_probably_good = True
    mysql = 'UPDATE custom_column_10 SET value =  ? WHERE  custom_column_10.id IN \
                                (SELECT value FROM books_custom_column_10_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_series,my_current_book)
    mysql = 'UPDATE custom_column_12 SET value =  ? WHERE  book = ? '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_index,my_current_book)
    seriesindex_is_probably_good = True
def scrub_tags(my_db,my_cursor,my_current_book,notifications,log, probable_tags_to_add_list):
    global set_of_author_symbols
    global set_of_letters
    global set_of_letters_and_author_symbols
    global set_of_numbers
    global set_of_numbers_and_symbols
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_title_characters
    global tag_regex_rules_list
    global tag_capitalization_regex_rules_list
    global single_work_tags_all_list
    probable_tags_to_add_list = list(set(probable_tags_to_add_list))
    npt = len(probable_tags_to_add_list )
    mysql = 'SELECT value,NULL FROM custom_column_13 WHERE custom_column_13.id IN \
                                (SELECT value FROM books_custom_column_13_link WHERE book = ? )'
    tmp_tag_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_tag_rows:
        tmp_tag_rows = []
    if len(tmp_tag_rows) == 0:
        if npt == 0:
            return
        else:
            tmp_temp = ""
            for item in probable_tags_to_add_list:
                tmp_temp = tmp_temp + item + ", "
            tmp_tag_rows = []
            tmp_tag_rows.append(as_unicode(tmp_temp))
    else:
        value,dummy = tmp_tag_rows[0]
        tmp_tag_rows[0] = value
        if npt == 0:
            pass
        else:
            tmp_temp = ""
            for item in probable_tags_to_add_list:
                tmp_temp = tmp_temp.strip() + item.strip() + ", " 
            tmp_tag_rows.append(as_unicode(tmp_temp))
    tmp_tag_rows.sort()
    tmp_tags = ""
    tmp_tags_concat = ""
    for tmp_tags in tmp_tag_rows:
        if tmp_tags > " ":
            tmp_tags_concat = tmp_tags_concat + ", " + tmp_tags.strip()
    tmp_tags = tmp_tags_concat
    orig_tags = tmp_tags
    if tmp_tags == "":
        tmp_tags = "DELETE"
    tmp_tags = tmp_tags.replace(",,", ",")
    tmp_tags = tmp_tags.replace(", ,", ",")
    if ";" in tmp_tags:
        tmp_tags = tmp_tags.replace(";", ",")
    tmp_tags = tmp_tags.replace(" & ", "&") #for better matching to bisac subjects, and for standardization
    tmp_tags = tmp_tags.replace(" &", "&") #for better matching to bisac subjects, and for standardization
    tmp_tags = tmp_tags.replace("& ", "&") #for better matching to bisac subjects, and for standardization
    new_tags = ""
    tmp_tags = tmp_tags.strip()
    if tmp_tags.endswith(","): #erroneous, so fix it here
        tmp_tags = tmp_tags[ :-1]
    if tmp_tags.startswith(","): #erroneous, so fix it here
        tmp_tags = tmp_tags[ 1: ]
    if tmp_tags.startswith(", "): #erroneous, so fix it here
        tmp_tags = tmp_tags[ 2: ]
    tmp_tags = tmp_tags.strip()
    n = tmp_tags.count(",")
    if n > 0: #meaning at least 2 tags concatenated
        tag_rows = tmp_tags.split(",")
        multiple_tags = True
    else: #single tag with no commas so nothing to split
        tag_rows = []
        tag_rows.append(as_unicode(tmp_tags))
        multiple_tags = False
    if not tag_rows:
        return
    tag_rows = list(set(tag_rows))
    tag_rows.sort()
    for tmp_tag in tag_rows:
        force_update = False
        n1 = tmp_tag.find("(*_*)")
        if n1 >= 0:
            tmp_tag = ""
        tmp_tag = tmp_tag.replace("(", "")
        tmp_tag = tmp_tag.replace(")", "")
        tmp_tag = tmp_tag.strip()
        if tmp_tags.endswith(","): 
            tmp_tags = tmp_tags[ :-1]
        if tmp_tags.startswith(", "): 
            tmp_tags = tmp_tags[ 2: ]
        if tmp_tags.startswith(","): 
            tmp_tags = tmp_tags[ 1: ]
        tmp_tag = tmp_tag.strip()
        tmp_tag = remove_bad_keywords(tmp_tag)
        orig_tmp_tag = tmp_tag
        tmp_tag = tmp_tag.lower()
        tmp_tag = scrub_isbn_in_tags(my_db,my_cursor,my_current_book,tmp_tag,notifications,log)   
        tmp_tag = tmp_tag.replace(", ", "")
        tmp_tag = tmp_tag.strip()
        if tmp_tag == "":
            tmp_tag = "DELETE"
        if not tmp_tag == "DELETE":
            my_cursor.execute("SELECT oldtag,newtag,purgetag FROM _tag_rules WHERE oldtag = ?", ([orig_tmp_tag])) 
            tagdata = my_cursor.fetchall()
            if tagdata:
                if len(tagdata) > 0:
                    check_regex = False
                    for row in tagdata:
                        oldtag,newtag,purgetag = row
                        if purgetag >= 1:
                            tmp_tag = "DELETE"
                        else:
                            tmp_tag = newtag
                            if tmp_tag == "":
                                tmp_tag = "DELETE"
                            if tmp_tag != "":
                                force_update = True
                                check_regex = True
                            else:
                                tmp_tag = "DELETE"
                else:
                    check_regex = True
            else:
                check_regex = True
            if not check_regex:
                pass
            else:
                for row in tag_regex_rules_list:
                    rule_list = row.split("<|!!|>")
                    re1 = rule_list[0]
                    try:
                        p1 = re.compile(re1, re.IGNORECASE)
                        match1 = p1.search(tmp_tag)
                        if match1:
                            if rule_list[2] >= '1':
                                tmp_tag = "DELETE"
                                break
                            else:
                                if rule_list[1] > " " and rule_list[1] != "None" :
                                    tmp_tag = rule_list[1]
                                    force_update = True
                                    break
                                else:
                                    log("REGEX rule is inconsistent; please correct; rule bypassed:", re1)
                                    break
                        else:
                            continue
                    except Exception as e:
                        log("Table _tag_rules REGEX Rule Compile Error:" + e)
                        log("REGEX rule was:" + re1)
                        log("Please fix your REGEX rule via table _tag_rules maintenance.  Bypassing bad rule and continuing.")
                        continue
        tmp_tag = tmp_tag.replace(", None, ", ", ")
        tmp_tag = tmp_tag.replace(",None, ", ",")
        tmp_tag = tmp_tag.replace("None, ", "")
        tmp_tag = tmp_tag.replace("Glbt", "GLBT")
        tmp_tag = tmp_tag.replace("Cia", "CIA")
        tmp_tag = tmp_tag.replace("Nsa", "NSA")
        tmp_tag = tmp_tag.replace("Usa", "Usa")
        tmp_tag = tmp_tag.replace(" adult", " Adult")   
        if tmp_tag == "":
            tmp_tag = "DELETE"
        n1 = len(tmp_tag)
        if n1 > 50:    
            tmp_tag = ""
        tmp_tag = tmp_tag.strip()   
        n1 = tmp_tag.count(" ")
        if n1 > 5:    
            tmp_tag = ""
        if tmp_tag == "":
            tmp_tag = "DELETE"
        if set(tmp_tag).issubset(set_of_numbers):
            tmp_tag = "DELETE"
        if set(tmp_tag).issubset(set_of_symbols): 
            tmp_tag = "DELETE"
        my_BISAC = "^[A-Z][A-Z][A-Z][0-9][0-9][0-9][0-9][0-9][$0-9]"
        p1 = re.compile(my_BISAC, re.IGNORECASE)
        match1 = p1.search(as_unicode(tmp_tag))
        if match1:
            try:
                tmp_tag = tmp_tag.upper()
            except:
                pass
            mysql = 'SELECT subject,NULL FROM _global_subject_codes WHERE code = ? AND subject IS NOT NULL AND code IS NOT NULL'
            tmp_subject_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_tag)
            tmp_tag = None
            if not tmp_subject_rows:
                continue
            elif len(tmp_subject_rows) > 0:
                tmp_tag,dummy = tmp_subject_rows[0] #example:  Fiction:Thriller
                force_update = True
            else:
                continue
            if tmp_tag is None:
                continue
            else:
                tmp_tag = tmp_tag.strip()
                s_tmp = tmp_tag[0:3]
                s_code = s_tmp + "000000"                      
                s_code = s_code.replace(",", "")
                mysql = 'SELECT subject,NULL FROM _global_subject_codes WHERE code = ? AND subject IS NOT NULL AND code IS NOT NULL'
                tmp_subject_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=s_code)
                if tmp_subject_rows:
                    if len(tmp_subject_rows) > 0:
                        tmp_tag,null = tmp_subject_rows[0] #example:  Fiction:General
                        force_update = True
                    else:
                        log("Subject Code Not Found in Q&S Table:", s_code)
                        pass
                else:
                    log("Subject Code Not Found in Q&S Table:", s_code)
                    pass
        else:
            pass
        tmp_tag = tmp_tag
        if tmp_tag != "DELETE" and tmp_tag != "" and tmp_tag != "NONE":
            if not force_update:  
                try:
                    tmp_tag = tmp_tag.lower()
                except:
                    pass
                tmp_tag = titlecase(tmp_tag)
            if multiple_tags:
                tmp_tag = tmp_tag.strip()
                n = len(as_unicode(tmp_tag))
                if n > 0:
                    try:
                        if "(*_*)" in tmp_tag:
                            continue
                        else:
                            pass
                    except:
                        continue
                    tmp_tag = check_other_names_as_tagname(my_db,my_cursor,log,tmp_tag,my_current_book)
                    if tmp_tag != "":
                        n1 = new_tags.find(tmp_tag)
                        single_work_tags_all_list.append(tmp_tag)   
                        if n1 < 0:
                            new_tags = new_tags + tmp_tag + ', '
                        else:
                            pass
                    else:
                        pass
                else:
                    pass
            else:
                pass
        else:
            pass
    if new_tags == "None":
        new_tags = "DELETE"
    if new_tags == "":
        new_tags = "DELETE"
    if not multiple_tags:
        new_tags = tmp_tag
        new_tags = new_tags.strip()
        if new_tags.endswith(","): #erroneous, so fix it here
            new_tags = new_tags[ :-1]
        single_work_tags_all_list.append(new_tags)   
    if multiple_tags:
        new_tags = new_tags.strip()
        if new_tags.endswith(","): #erroneous, so fix it here
            new_tags = new_tags[ :-1]
        if new_tags.startswith(","): #erroneous, so fix it here
            new_tags = new_tags[ 1: ]
    new_tags = new_tags.strip()
    if new_tags == "None":
        new_tags = "DELETE"
    n1 = new_tags.count("None") 
    if n1 > 0:
        new_tags = new_tags.replace("None", "", 5) #multiple tags, some good, some None
        new_tags = new_tags.strip()
        if new_tags.endswith(","): #erroneous, so fix it here
            new_tags = new_tags[ :-1]
        if new_tags.startswith(","): #erroneous, so fix it here
            new_tags = new_tags[ 1: ]
        new_tags = new_tags.strip()
    tmp_tags = tmp_tags.replace(",,", ",")
    tmp_tags = tmp_tags.replace(", , ", ", ")
    tmp_tags = tmp_tags.replace(", ,", ",")
    tmp_tags = tmp_tags.replace("«", "")
    tmp_tags = tmp_tags.replace("»", "")
    tmp_tags = tmp_tags.replace("‹", "")
    tmp_tags = tmp_tags.replace("›", "")
    tmp_tags = tmp_tags.replace("from:", "")
    tmp_tags = tmp_tags.replace("From:", "")
    tmp_tags = tmp_tags.replace("to:", "")
    tmp_tags = tmp_tags.replace("To:", "")
    tmp_tags = tmp_tags.replace("–", "")
    tmp_tags = tmp_tags.replace("—", "") 
    tmp_tags = tmp_tags.replace("†", "")
    tmp_tags = tmp_tags.replace("‡", "")
    tmp_tags = tmp_tags.replace("§", "")
    tmp_tags = tmp_tags.replace("•", "")
    tmp_tags = tmp_tags.replace("¶", "")
    tmp_tags = tmp_tags.replace("®", "")
    tmp_tags = tmp_tags.replace("©", "")
    tmp_tags = tmp_tags.replace("°", "")
    if new_tags == "DELETE":
        new_tags = ""
        force_update = False
    new_tags = apply_tag_capitalization_rules(new_tags,log)
    if (orig_tags != new_tags and new_tags != "") or (force_update):
        if new_tags == "":
            log("LOGIC ERROR IN new_tags; == """)
            pass
        else:
            new_tags = as_unicode(new_tags)
            mysql = 'DELETE FROM books_custom_column_13_link WHERE book = ? AND book = ? '
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book)
            mysql = "INSERT OR REPLACE INTO custom_column_13 (id,value) VALUES (?,?)"
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,new_tags)
            sleep(0.03)
            mysql = 'INSERT OR REPLACE INTO books_custom_column_13_link (id,book,value) VALUES (?,?,?) ;'
            execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book,my_current_book)
    else:
        if new_tags == "":
            mysql = 'DELETE FROM books_custom_column_13_link WHERE book = ? AND book = ? '
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book)
        else:
            pass
    del tag_rows
    del new_tags
    probable_tags_to_add_list[:] = []
def check_other_names_as_tagname(my_db,my_cursor,log,tmp_tag,my_current_book):
    tmp_tag = tmp_tag.strip()
    if tmp_tag == "" or (not len(tmp_tag) > 0 ):
        return
    s = tmp_tag
    tmp_tag = tmp_tag.replace('"', "")
    if s != tmp_tag:
        return tmp_tag
    sleep(0.03)
    mysql = 'SELECT exists (SELECT value FROM custom_column_4 WHERE value  = ? AND id = ? ) '
    tmp_exist = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=tmp_tag,v2=my_current_book)
    if not tmp_exist:
        return
    else:
        for row in tmp_exist:
            for col in row:
                answer = as_unicode(col)
                if answer == "1":
                    log(" ")
                    log("Author as a Tag Has Been Removed:   " + tmp_tag)
                    tmp_tag = ""
                    return tmp_tag
            break
    sleep(0.03)
    mysql = "SELECT exists  (SELECT value FROM custom_column_8 WHERE value  = ? AND id = ? ) "
    tmp_exist = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=tmp_tag,v2=my_current_book)
    if not tmp_exist:
        return
    else:
        for row in tmp_exist:
            for col in row:
                answer = as_unicode(col)
                if answer == "1":
                    log(" ")
                    log("Title as a Tag Has Been Removed:   " + tmp_tag)
                    tmp_tag = ""
                    return tmp_tag
            break
    sleep(0.03)
    mysql = 'SELECT exists (SELECT value FROM custom_column_10 WHERE value  = ? AND id = ? ) '
    tmp_exist = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=tmp_tag,v2=my_current_book)
    if not tmp_exist:
        return
    else:
        for row in tmp_exist:
            for col in row:
                answer = as_unicode(col)
                if answer == "1":
                    log(" ")
                    log("Series Name as a Tag Has Been Removed:   " + tmp_tag)
                    tmp_tag = ""
                    return tmp_tag
            break
    sleep(0.03)
    n1 = tmp_tag.count(" ")
    if n1 == 0:  
        return tmp_tag
    n1 = len(tmp_tag)
    if n1 < 11:
        return tmp_tag
    mysql = "SELECT exists (SELECT value FROM custom_column_4 WHERE value LIKE  '%" + tmp_tag.strip() + "%' )"
    tmp_exist = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_exist:
        return
    else:
        for row in tmp_exist:
            for col in row:
                answer = as_unicode(col )
                if answer == "1":
                    log(" ")
                    log("Tag with Author Name Has Been Removed:   " + tmp_tag)
                    tmp_tag = ""
                    return tmp_tag
            break
    sleep(0.03)
    mysql = "SELECT exists (SELECT value FROM custom_column_10 WHERE value LIKE  '%" + tmp_tag.strip() + "%' )"
    tmp_exist = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_exist:
        return
    else:
        for row in tmp_exist:
            for col in row:
                answer = as_unicode(col)
                if answer == "1":
                    log(" ")
                    log("Tag with Series Name Has Been Removed:   " + tmp_tag)
                    tmp_tag = ""
                    return tmp_tag
            break
    return tmp_tag
def scrub_isbn_in_tags(my_db,my_cursor,my_current_book,tmp_tag,notifications,log):
    tmp_tag = tmp_tag.replace("isbn:", "")
    tmp_tag = tmp_tag.replace("isbn", "")
    tag = tmp_tag.strip()
    orig_tag = tag
    my_re13a = "^97[8-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"
    my_re13b = "^97[8-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    my_re13c = "97[8-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"
    my_re10a = "^[0-1][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9X]"         
    my_re10b = "^[0-1][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    p13a = re.compile(my_re13a, re.IGNORECASE)
    match13a = p13a.search(tag)
    if match13a:
        tag = re.sub(my_re13a, "", tag)
    else:
        p13b = re.compile(my_re13b, re.IGNORECASE)
        match13b = p13b.search(tag)
        if match13b:
            tag = re.sub(my_re13b, "", tag)
        else:
            p13c = re.compile(my_re13c, re.IGNORECASE)
            match13c = p13c.search(tag)
            if match13c:
                tag = re.sub(my_re13c, "", tag)
            else:
                p10a = re.compile(my_re10a, re.IGNORECASE)
                match10a = p10a.search(tag)
                if match10a:
                    tag = re.sub(my_re10a, "", tag)
                else:
                    p10b = re.compile(my_re10b, re.IGNORECASE)
                    match10b = p10b.search(tag)
                    if match10b:
                        tag = re.sub(my_re10b, "", tag)
                    else:
                        return tag
    tag = tag.replace(",", "")
    tag = tag.replace("_", "")
    tag = tag.replace("'", "")
    tag = tag.replace("  ", " ")           
    tag = tag.strip()                              
    isbn = orig_tag.replace(as_unicode(tag), "") #i.e., isbn is removed from tag; probably nothing now
    isbn = isbn.replace(" ", "")
    isbn = isbn.replace("-", "")
    isbn = isbn.replace("_", "")
    isbn = isbn.replace(":", "")
    isbn = isbn.strip()
    good_isbn = False
    if match13a or match13b:
        good_isbn = calcisbn13checksum(isbn)
    else:
        good_isbn = calcisbn10checksum(isbn)
    if not good_isbn:
        return tag
    else:
        pass
    new_isbn = convert_isbn_convert_10_to_13(isbn)
    new_isbn = as_unicode(new_isbn)
    if new_isbn:
        if (new_isbn != isbn) and (new_isbn.isnumeric()) and (len(new_isbn) == 13) and (not new_isbn.startswith("978978")):
            log("Valid ISBN10 Converted to ISBN13:" + isbn) + " >>> " + as_unicode(new_isbn)
            isbn = new_isbn
    mysql = 'INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,"isbn",?)'
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(my_current_book,isbn))
        my_cursor.execute("commit")
        log("Valid ISBN extracted and updated for book with tag of:", orig_tag)
    except Exception as e:
        log(as_unicode(e))
        pass #not going to stop just for this
    return tag
def scrub_final_author_title_switched(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_probably_good
    global author_is_valid_globally
    global title_is_probably_good
    if author_is_valid_globally:
        return
    if author_is_probably_good:
        return
    if title_is_probably_good:
        return
    tmp_title = ""
    tmp_author_id = '0'
    mysql = 'SELECT value,NULL from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value from books_custom_column_8_link WHERE book = ? )'
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_rows:
        return
    else:
        for row in tmp_rows:
            tmp_title,dummy = row
            break
    author_is_valid_globally = False
    mysql = 'SELECT * from _global_authors WHERE name = ? '
    tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_title)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            author_is_valid_globally = True
            break
    else:
        mysql = 'SELECT * from _pristine_authors WHERE name = ? '
        tmp_auth_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=tmp_title)
        if tmp_auth_rows:
            for row in tmp_auth_rows:
                author_is_valid_globally = True
                break
    if not author_is_valid_globally:
        return
    new_title = ""
    mysql = 'SELECT authname,NULL FROM __books_work_populate  WHERE book = ? '
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_rows:
        return
    else:
        for row in tmp_rows:
            new_title,dummy = row
            break
    mysql = "SELECT value,NULL FROM books_custom_column_4_link WHERE book = ? "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_rows:
        return
    else:
        for row in tmp_rows:
            tmp_author_id,dummy = row
            break
    new_title = add_missing_spaces_to_camelback_strings(new_title)
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,new_title,my_current_book)
    new_author = tmp_title #actual name in custom_column_8
    new_author = add_missing_spaces_to_camelback_strings(new_author)
    mysql = 'SELECT id,NULL FROM custom_column_4 WHERE value = ? '
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=new_author)
    tmp_author_id = "00000"
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            tmp_author_id,dummy = row
            break
    if tmp_author_id == "00000":
        mysql = "INSERT OR IGNORE INTO custom_column_4 (id,value) VALUES (?,?)"
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,'null', new_author)
        mysql = "SELECT id,value FROM custom_column_4 WHERE value = ?  "
        tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=new_author)
        if not tmp_rows:
            return
        if len(tmp_rows) == 0:
            return
        for row in tmp_rows:
            tmp_author_id,value = row
            mysql = 'UPDATE books_custom_column_4_link SET value = ? WHERE book = ?  ;'
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_author_id,my_current_book)
    else:
        mysql = 'UPDATE books_custom_column_4_link SET value = ? WHERE book = ?  ;'
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_author_id,my_current_book)
def scrub_final_work_series_format(my_db,my_cursor,my_current_book,notifications,log):
    global can_force_update_of_series
    global probable_seriesname_to_add_list
    can_force_update_of_series = False
    nps = len(probable_seriesname_to_add_list)
    if nps == 0:
        no_probable_seriesname_to_add_list = True
    else:
        no_probable_seriesname_to_add_list = False
    mysql = "SELECT seriesname, seriesindex FROM __books_work_populate WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if tmp_rows:
        tmp_series = None
        for row in tmp_rows:
            tmp_series,tmp_index = row
            break
    else:
        if no_probable_seriesname_to_add_list:
            return    
        else:
            pass  
    if tmp_series == None:
        if no_probable_seriesname_to_add_list:
            return   
        else:
            tmp_series = probable_seriesname_to_add_list[0]
            tmp_index = "0"
    tmp_index = qs_standardize_string_numerics(tmp_index,return_integer=False,return_float=True)
    tmp_index = as_unicode(tmp_index)
    if (tmp_series == "" or tmp_series == "None" )  and no_probable_seriesname_to_add_list:  
        return
    if (tmp_series == "" or tmp_series == "None" ) and no_probable_seriesname_to_add_list:   
        return
    else:
        pass
    if no_probable_seriesname_to_add_list:
        pass
    else:
        if tmp_series > " " and tmp_series != "None" and tmp_series != "None" :
            pass
        else:
            tmp_series = probable_seriesname_to_add_list[0]
            can_force_update_of_series = True
    orig_series = tmp_series
    tmp_series = tmp_series.replace("Series=", "")
    tmp_series = tmp_series.replace("#", "")
    tmp_series = tmp_series.replace("html", "")
    tmp_series = tmp_series.replace("Html", "")
    tmp_series = tmp_series.replace("bookzz.org", "")
    tmp_series = tmp_series.replace("Bookzz.org", "")
    tmp_series = tmp_series.replace("Fantasy Paranormal Romance", "")
    tmp_series = tmp_series.replace("BDSM Erotic Romance", "")
    tmp_series = tmp_series.replace("Short Story", "")
    tmp_series = tmp_series.replace("Kindle Single", "")
    tmp_series = tmp_series.replace("Book One in the", "")
    tmp_series = tmp_series.replace("S of ", "")
    tmp_series = tmp_series.replace("Romance / Romantic Suspense", "")
    tmp_series = tmp_series.replace("Domination / Erotic Romance", "")
    tmp_series = tmp_series.replace("With Bonus Material", "")
    tmp_series = tmp_series.replace("BBW Billionaire Erotic Romance Novella", "")
    tmp_series = tmp_series.replace("()", "")
    tmp_series = tmp_series.replace("[]", "")
    tmp_series = tmp_series.strip()
    if tmp_series.endswith(" Articles by"):
        tmp_series = tmp_series.replace(" Articles by", "")
    if tmp_series.endswith(" Novel"):
        tmp_series = tmp_series[0:-6]
    if tmp_series.startswith("A of the "):
        tmp_series = tmp_series[9: ]
    if tmp_series.startswith("Of the "):
        tmp_series = tmp_series[7: ]
    s0 = tmp_index
    s0 = s0.replace(".0","")
    s0 = s0.strip()
    tmp_series = tmp_series.strip()
    if tmp_series.endswith(".0"):
        tmp_series = tmp_series[0:-2]
    if tmp_series.endswith(s0):
        n0 = len(tmp_series)
        n1 = len(s0)
        tmp_series = tmp_series[0:(n0-n1)]
    tmp_series = remove_bad_keywords(tmp_series)
    tmp_series = tmp_series.replace(" Part One", "")
    tmp_series = tmp_series.replace(" Part Two", "")
    tmp_series = tmp_series.replace(" Part Three", "")
    tmp_series = tmp_series.replace("&&", "&")
    tmp_series = tmp_series.replace("&", " & ") #capitalize e.g.  Talon&chantry should be Talon&Chantry, so make it Talon & Chantry
    tmp_series = tmp_series.replace("  ", " ")
    tmp_series = titlecase(tmp_series)
    tmp_series = tmp_series.replace(" Fbi", "FBI")
    tmp_series = tmp_series.replace(" Cia", "CIA")
    tmp_series = tmp_series.replace(" Nsa", "NSA")
    tmp_series = tmp_series.replace(" Usa", "USA")
    tmp_series = tmp_series.replace("Fbi", "FBI")
    tmp_series = tmp_series.replace("Cia", "CIA")
    tmp_series = tmp_series.replace("Nsa", "NSA")
    tmp_series = tmp_series.replace("Usa", "USA")
    tmp_series = tmp_series.replace("Nypd", "NYPD")
    tmp_series = tmp_series.replace("AnFBI ", "An FBI ")
    tmp_series = tmp_series.replace("ACIA ", "A CIA ")
    tmp_series = tmp_series.replace("Dci ", "DCI ")
    tmp_series = tmp_series.replace("Di ", "DI ")
    tmp_series = tmp_series.strip()
    if tmp_series.endswith("Novel"):
        if tmp_series.startswith("A ") or tmp_series.startswith("An "):
            tmp_series = tmp_series[2:-5]
            tmp_series = tmp_series.strip()
    if tmp_series == "Vol":
        tmp_series == "Volume"
    if tmp_series.endswith(" S"):
        if tmp_series.startswith("The "):
            tmp_series = tmp_series[ :-1] + "Books"
    if tmp_series.endswith("."):          
        tmp_series = tmp_series[0:-1]
    if tmp_series.isupper():
        try:
            tmp_series = tmp_series.lower()
            tmp_series = tmp_series.title()
        except:
            pass
    if tmp_series == "":
        can_force_update_of_series = True
    has_letters = False
    has_hash = False
    has_parens = False
    for item in tmp_series:
        s = item
        if s.isalpha():
            has_letters = True
        if s == ")" or s == "(" :      
            has_parens = True
            break
    if has_letters and (not has_parens):
        s_original = tmp_series
        tmp_series = add_missing_spaces_to_camelback_strings(tmp_series)
        if len(tmp_series) < len(s_original):  
            tmp_series = s_original   
    else:
        pass
    tmp_series = tmp_series.strip()
    mysql = 'SELECT value,NULL from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value from books_custom_column_8_link WHERE book = ? )'
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            tmp_title,dummy = row
            break
        if tmp_index == 0 or tmp_index == "0":
            if tmp_series == tmp_title:
                tmp_series = ""
    tmp_series = tmp_series.replace("()", "")
    mysql = "SELECT series_index,'dummy' FROM books WHERE id = ? "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_rows:
        tmp_index = "" #do not want to update it from here
    else:
        for row in tmp_rows:
            real_index,dummy = row
            real_index = as_unicode(real_index)
            if (real_index > tmp_index) or (real_index > "0.0" and tmp_index == "0.0") :
                if (tmp_index == "0.5" or tmp_index == "0.50") and (real_index == "1" or real_index == "1.0"):
                    pass
                else:
                    tmp_index = real_index
            else:
                tmp_index = "" #do not want to update it from here
            break
    s = tmp_series
    tmp_series = process_series_using_series_rules(s,log)   
    if s != tmp_series:
        can_force_update_of_series = True
    if tmp_series != orig_series or tmp_index != "" or can_force_update_of_series :
        if (tmp_series != "" and tmp_series > " "):
            can_force_update_of_series = True
            generic_update_work_series_seriesindex(my_db,my_cursor,my_current_book,tmp_series, tmp_index,log)
        else:
            mysql = 'UPDATE custom_column_10 SET value =  ? WHERE  custom_column_10.id IN \
                            (SELECT value FROM books_custom_column_10_link WHERE book = ? ) '
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,"None",my_current_book)
            mysql = "DELETE FROM books_custom_column_10_link WHERE book = ? AND book != ?  ;"
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,"DUMMY")
            mysql = "DELETE FROM custom_column_10 WHERE value = ?   AND value != ? ;"
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,"None", "DUMMY")
            mysql = "UPDATE custom_column_12 SET value = 0 WHERE book = ? AND book != ?  ;"
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,"DUMMY")
    else:
        pass
def scrub_misc_title_scenarios(my_db,my_cursor,my_current_book,notifications,log):
    global title_is_probably_good
    mysql = "SELECT booktitle, seriesname, seriesindex FROM __books_work_populate WHERE book = ?  "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    tmp_title = None
    if tmp_rows:
        for row in tmp_rows:
            tmp_title,tmp_series,tmp_seriesindex = row
            break
    if tmp_title is None:
        return
    tmp_seriesindex = qs_standardize_string_numerics(tmp_seriesindex,return_integer=False,return_float=True)
    my_re1 = '^[0-9]*[0-9]:[0-9][0-9]$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        return
    my_re1 = '^[0-9][0-9][0-9][0-9]$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        return
    my_re1 = '^[a-z ]+\sEpisode\s[0-9]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        return
    my_re1 = '^[a-z ]+[0-9]+$'  
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        return
    if tmp_series is None:
        tmp_series = ""
    if tmp_seriesindex is None:
        tmp_seriesindex = "0"
    if not (  (tmp_title == "_Unknown_" or tmp_title == "" or tmp_title == " ") and (tmp_series > " " ) \
                                                      and (tmp_seriesindex == "0.0" or tmp_seriesindex == "0")  ):
        fix_01 = False     
    else:
        fix_01 = True
    fix_02 = False
    if fix_01:
        pass
    else:
        n1 = tmp_title.count("#")
        n2 = tmp_title.count("[ ")
        n3 = tmp_title.count("]")
        s = tmp_title[-2: ]
        s = s.strip()
        n4 = 0
        try:
            sn = int(s)
            n4 = 999
            nv = tmp_title.count("Vol")
            nb = tmp_title.count("Book")
            nd = tmp_title.count("-")
            nc = tmp_title.count(":")
            ni = tmp_title.count("Issue")
            if nv == 0 and nb == 0 and nd == 0 and ni == 0 and nc == 0:
                tmp_title = tmp_title.replace(as_unicode(sn), "") #remove an ending NUMBER from title, such as Deadlocked 4 but NOT  Book 4  or Vol 4  or Issue 4
                tmp_title = tmp_title.strip()
                fix_02 = True
        except:
            n4 == 0
        if n1 == 0 and n2 == 0 and n3 == 0:
            pass
        else:
            orig_title = tmp_title
            if not fix_02:
                for index in range(0, 100):
                    i = as_unicode(index)
                    s4 = "[ #" + i + "]"
                    n4 = tmp_title.count(s4)
                    s5 = "[ #" + "0" + i + "]"
                    n5 = tmp_title.count(s5)
                    s6 = "#" + i
                    n6 = tmp_title.count(s6)
                    if n4 > 0:
                        tmp_title = tmp_title.replace(s4, "")
                    if n5 > 0:
                        tmp_title = tmp_title.replace(s5, "")
                    if n6 > 0:
                        tmp_title = tmp_title.replace(s6, "")
            else:
                pass
            if orig_title != tmp_title:
                fix_02 = True
    fix_03 = False #remove some garbage from title at very end of scrubbing (only)
    orig_title = tmp_title
    tmp_title = tmp_title.replace("[]", "") #residual artifact
    tmp_title = tmp_title.replace("[ ]", "") #residual artifact
    tmp_title = tmp_title.replace(" C I A", " CIA ") #residual artifact
    tmp_title = tmp_title.replace(" C I a", " CIA ") #residual artifact
    tmp_title = tmp_title.replace(" W T C", " WTC ") #residual artifact
    tmp_title = tmp_title.replace(" N S A", " NSA ") #residual artifact
    tmp_title = tmp_title.replace(" U S A", " USA ") #residual artifact
    tmp_title = tmp_title.replace(" F B I", " FBI ") #residual artifact
    tmp_title = tmp_title.replace("L a ", "L.A. ") #residual artifact
    tmp_title = tmp_title.replace(": A Thriller", "") #residual artifact
    tmp_title = tmp_title.replace(": a Thriller", "") #residual artifact
    tmp_title = tmp_title.replace(": An Thriller", "") #residual artifact
    tmp_title = tmp_title.replace(": an Thriller", "") #residual artifact
    tmp_title = tmp_title.replace(": A Novella", "") #residual artifact
    tmp_title = tmp_title.replace(": a Novella", "") #residual artifact
    tmp_title = tmp_title.replace(": A Novel", "") #residual artifact
    tmp_title = tmp_title.replace(": a Novel", "") #residual artifact
    tmp_title = tmp_title.replace(": A Mystery", "") #residual artifact
    tmp_title = tmp_title.replace(": a Mystery", "") #residual artifact
    tmp_title = tmp_title.replace(": An Novella", "") #residual artifact
    tmp_title = tmp_title.replace(": an Novella", "") #residual artifact
    tmp_title = tmp_title.replace(": An Novel", "") #residual artifact
    tmp_title = tmp_title.replace(": an Novel", "") #residual artifact
    tmp_title = tmp_title.replace(": An Mystery", "") #residual artifact
    tmp_title = tmp_title.replace(": an Mystery", "") #residual artifact
    if tmp_title.startswith("Book 1"):
        tmp_title = tmp_title.replace("Book 1", "") #residual artifact
    if tmp_title.startswith("Book 2"):
        tmp_title = tmp_title.replace("Book 2", "") #residual artifact
    if tmp_title.endswith(" La") or tmp_title.endswith(" la"):
        tmp_title = tmp_title[0:-3] #residual artifact from Novella
    if tmp_title.endswith("- 1"):
        tmp_title = tmp_title[0:-3] #residual artifact from   - 1.pdf
        tmp_title = tmp_title.strip()
    tmp_title = titlecase(tmp_title)
    if orig_title != tmp_title:
        if not fix_01:
            fix_03 = True
    if (not fix_01) and (not fix_02) and (not fix_03):
        return
    if not fix_01:
        pass
    else:
        tmp_title = tmp_series
        tmp_series = "DELETEME"
        title_is_probably_good = True
        n = tmp_title.count(".")
        if n > 5:
            tmp_title = tmp_title.replace(".", " ", 50)
        tmp_title = titlecase(tmp_title)
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
        mysql = "DELETE FROM books_custom_column_10_link WHERE book = ?  OR book = ? "  
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book)
        fix_01 = False
    if (not fix_02) and (not fix_03):
        pass
    else:
        tmp_title = tmp_title.strip()
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
        fix_02 = False
        fix_03 = False
def set_work_freeze(my_db,my_cursor,my_current_book,notifications,log):
    global freeze_current_book
    if not freeze_current_book:
        return
    mysql = "DELETE FROM custom_column_16 WHERE book = ?"
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    mysql = "INSERT INTO custom_column_16 (id,book,value) VALUES (null, ?, ?)"
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,1)
    add_book_to_scrubbed_books_final_list(my_db,my_cursor,my_current_book,notifications,log)
    mysql = "SELECT id,'dummy' FROM custom_column_18 WHERE value = 'book_ok' "
    tmp_id_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_id_rows:
        tmp_id_rows = []
    if len(tmp_id_rows) == 0:
        sleep(.02)
        mysql = "INSERT OR IGNORE INTO custom_column_18 (id,value) VALUES (null, 'book_ok') "
        execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
        sleep(.02)
        mysql = "SELECT id,NULL FROM custom_column_18 WHERE value = 'book_ok' "
        tmp_id_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    tmp_id,dummy = tmp_id_rows[0]
    sleep(.02)
    mysql = "DELETE FROM books_custom_column_18_link WHERE book = ?  "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,my_current_book)
    sleep(.02)
    mysql = "INSERT OR REPLACE INTO books_custom_column_18_link (id,book,value) VALUES (null,?,?) "
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_id)
def add_book_to_scrubbed_books_final_list(my_db,my_cursor,my_current_book,notifications,log):
    global scrubbed_books_final_list
    book_dict_authname = {}
    book_dict_book = {}
    book_dict_booktitle = {}
    book_dict_seriesfull = {}
    book_dict_seriesindex = {}
    book_dict_seriesname = {}
    book_dict_tags = {}
    book_list_of_dicts = []
    mysql = "SELECT book, authname, booktitle, seriesname, seriesindex, seriesfull, tagsall \
                                FROM __books_work_populate WHERE book = ? "
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_rows:
        return
    if len(tmp_rows) == 0:
        return
    for row in tmp_rows: 
        book, authname, booktitle, seriesname, seriesindex, seriesfull, tagsall = row
        book = int(book)
        book_dict_book["calibre_id"] = book
        book_list_of_dicts.append(book_dict_book)
        if authname == "Unknown":
            authname = "_Unknown_" 
        book_dict_authname[book] = authname
        book_list_of_dicts.append(book_dict_authname)
        book_dict_booktitle[book] = booktitle
        book_list_of_dicts.append(book_dict_booktitle)
        book_dict_seriesname [book] = seriesname
        book_list_of_dicts.append(book_dict_seriesname)
        book_dict_seriesindex[book] = seriesindex
        book_list_of_dicts.append(book_dict_seriesindex)
        book_dict_seriesfull[book] = seriesfull
        book_list_of_dicts.append(book_dict_seriesfull)
        book_dict_tags[book] = tagsall
        book_list_of_dicts.append(book_dict_tags)
    scrubbed_books_final_list.append(book_list_of_dicts)
    del tmp_rows
    del book_list_of_dicts
    del book_dict_book
    del book_dict_authname
    del book_dict_booktitle
    del book_dict_seriesname
    del book_dict_seriesindex
    del book_dict_seriesfull
    del book_dict_tags
def skip_frozen_book(my_db,my_cursor,my_current_book,notifications,log):
    global book_is_frozen
    book_is_frozen = False
    mysql = 'SELECT value,NULL FROM custom_column_16 WHERE book = ? '
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_rows:
        book_is_frozen = False
    else:
        if len(tmp_rows) > 0:
            s,dummy = tmp_rows[0]
            s = bool(s)
            if s:
                book_is_frozen = True
    if not book_is_frozen:
        mysql = "SELECT exists (SELECT book FROM books_custom_column_18_link WHERE book =  ? ) "
        tmp_rows = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=None)
        if not tmp_rows:
            book_is_frozen = True
        else:
            if len(tmp_rows) == 0:
                book_is_frozen = True
def delete_unused_values(my_db,my_cursor,notifications,log):
    mysql = 'DELETE FROM custom_column_4 WHERE id IN __author_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    mysql = 'DELETE FROM custom_column_8 WHERE id IN __title_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    mysql = 'DELETE FROM custom_column_10 WHERE id IN __series_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    mysql = 'DELETE FROM custom_column_13 WHERE id IN __tags_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
def add_missing_spaces_to_camelback_strings(s):  
    s = s.replace("  ", " ") #change double spaces to single space
    s = s.strip()
    n = s.find(" ")
    if n > 0: #multiple words
        if n > 1: #do not change if has more than 2 words
            s = s.replace("NotSo", "Not-So-") #common error to have removed dashes from not-so-something...
            s = s.replace("notso", "not-so-") #common error to have removed dashes from not-so-something...
            return s
        else:
            s_list = s.split(" ")
            n = len(s_list)
    else:
        n = 0
    found_reason_to_return = False
    if n > 1:
        i = 0
        while i < n:
            s1 = s_list[i]
            if s1.islower() or s1.isupper(): #e.g. SEAL or any lowercase; they are not camelback
                pass
            else:
                s2 = s1[0:-1]
                if s2.isupper():
                    found_reason_to_return = True
            i = i + 1
    else:
        if s.islower() or s.isupper():
            found_reason_to_return = True
        else:
            s1 = s[0:-1] #e.g. SEAL in SEALs
            if s1.isupper():
                found_reason_to_return = True
    if found_reason_to_return:
        return s
    s = s[0:1].upper() + s[1: ] #The first letter must be upper case or the first word will be dropped...
    try:
        pos = [i for i,e in enumerate(s) if e.isupper()]
        parts = []
        for j in range(len(pos)):
            try:
                parts.append(as_unicode(s[pos[j]:pos[j+1]]))
            except IndexError:
                parts.append(as_unicode(s[pos[j]:]))
        parts = parts.replace(",", "") #remove commas
        parts = parts.replace("[", "")
        parts = parts.replace("]", "")
        parts = parts.replace("'", "") #cannot due to possessive in work_series:  e.g. Hammer's Slammers, BUT causes all kinds of sql issues....
        parts = parts.replace('"', "")
        parts = parts.replace("  ", " ") #change double spaces to single space
        if parts.startswith(" "):
            parts = parts[1: ]
        return parts
    except:
        return s
def determine_if_is_number(s):
    try:
        float(s)
        return True
    except ValueError:
        return False
def find_numbers_in_letter_string(s_string, n_start, n_end):
    s_apostrophe = "'"
    s_space = " "
    s_split_symbol = "|"
    s_colon = ":"
    s_bracketl = "["
    s_bracketr = "]"
    s_amp = "&"
    n_utf8 = s_string.count("\\")
    if n_utf8 > 0:                                                  
        n_start = 999
        n_end = 999
        return s_string, n_start, n_end
    for item in s_string:
        c = item
        if ( (not c.isalpha()) and (not c.isdigit()) and (not (c == s_space)) and (not (c == s_apostrophe)) and (not( c == s_split_symbol)) \
                                         and (not (c == s_colon)) and (not (c == s_bracketl)) and (not (c == s_bracketr)) \
                                        and (not (c == s_amp))         ):
            n_start = 999
            n_end = 999
            return s_string, n_start, n_end
        else:
            pass
    n_start = 999
    n_end = 999
    i = -1
    for item in s_string:
        c = item
        i = i + 1
        if (not c.isdigit()):
            if n_start != 999:
                if (not c == "."):
                    n_end = i -1
                    break
                else:
                    n_end = i
            else:
                    pass #a letter or space, not a number, prior to the first number, such as:  abcdefg 98
        else:
            if n_start == 999:
                n_start = i
            else:
                n_end = i
    if n_start != 999 :
        if n_end == 999 :
            n = len(s_string)
            n_end = n
            return s_string, n_start, n_end
    if n_end != 999 :
        n_end = n_end + 1
    return s_string, n_start, n_end
def find_part_number_in_title(s):
    s_orig = s
    s = qs_standardize_any_string(s)
    s = s.lower()
    n1 = 0
    n2 = 0
    n3 = 0
    n4 = 0
    n5 = 0
    n6 = 0
    n7 = 0
    n8 = 0
    n9 = 0
    n10 = 0
    n1 = s.count("part one")
    n2 = s.count("part two")
    n3 = s.count("part three")
    n4 = s.count("part four")
    n5 = s.count("part five")
    n6 = s.count("part six")
    n7 = s.count("part seven")
    n8 = s.count("part eight")
    n9 = s.count("part nine")
    n10 = s.count("part ten")
    n = "0"
    if n1 > 0: n = "1"
    if n2 > 0: n = "2"
    if n3 > 0: n = "3"
    if n4 > 0: n = "4"
    if n5 > 0: n = "5"
    if n6 > 0: n = "6"
    if n7 > 0: n = "7"
    if n8 > 0: n = "8"
    if n9 > 0: n = "9"
    if n10 > 0: n = "10"
    n = qs_standardize_string_numerics(n)
    if n != "0":
        return n
    my_re1 = "[0-9]+[.]*[5]*[0]*"     
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(s_orig)
    if match1:
        s_num = match1.group(0)
        s_num = qs_standardize_string_numerics(s_num)
        return s_num
    n0 = 0
    n1 = 0
    n15 = 0
    n2 = 0
    n25 = 0
    n3 = 0
    n35 = 0
    n4 = 0
    n5 = 0
    n6 = 0
    n7 = 0
    n8 = 0
    n9 = 0
    n10 = 0
    n0 = s.count("#.5")
    if n0 == 0:
        n0 = s.count("#0.5")
    n1 = s.count("#1")
    n15 = s.count("#1.5")
    n2 = s.count("#2")
    n25 = s.count("#2.5")
    n3 = s.count("#3")
    n35 = s.count("#3.5")
    n4 = s.count("#4")
    n5 = s.count("#5")
    n6 = s.count("#6")
    n7 = s.count("#7")
    n8 = s.count("#8")
    n9 = s.count("#9")
    n10 = s.count("#10")
    n = "0"
    if n0 > 0: n = "0.5"
    if n1 > 0: n = "1"
    if n15 > 0: n = "1.5"
    if n2 > 0: n = "2"
    if n25 > 0: n = "2.5"
    if n3 > 0: n = "3"
    if n35 > 0: n = "3.5"
    if n4 > 0: n = "4"
    if n5 > 0: n = "5"
    if n6 > 0: n = "6"
    if n7 > 0: n = "7"
    if n8 > 0: n = "8"
    if n9 > 0: n = "9"
    if n10 > 0: n = "10"
    n = qs_standardize_string_numerics(n)
    if n != "0":
        return n
    n0 = 0
    n1 = 0
    n15 = 0
    n2 = 0
    n25 = 0
    n3 = 0
    n35 = 0
    n4 = 0
    n5 = 0
    n6 = 0
    n7 = 0
    n8 = 0
    n9 = 0
    n10 = 0
    n0 = s.count("# .5")
    if n0 == 0:
        n0 = s.count("# 0.5")
    n1 = s.count("# 1")
    n2 = s.count("# 2")
    n3 = s.count("# 3")
    n15 = s.count("# 1")
    n25 = s.count("# 2")
    n35 = s.count("# 3")
    n4 = s.count("# 4")
    n5 = s.count("# 5")
    n6 = s.count("# 6")
    n7 = s.count("# 7")
    n8 = s.count("# 8")
    n9 = s.count("# 9")
    n10 = s.count("# 10")
    n = "0"
    if n0 > 0: n = "0.5"
    if n1 > 0: n = "1"
    if n15 > 0: n = "1.5"
    if n2 > 0: n = "2"
    if n25 > 0: n = "2.5"
    if n3 > 0: n = "3"
    if n35 > 0: n = "3.5"
    if n4 > 0: n = "4"
    if n5 > 0: n = "5"
    if n6 > 0: n = "6"
    if n7 > 0: n = "7"
    if n8 > 0: n = "8"
    if n9 > 0: n = "9"
    if n10 > 0: n = "10"
    n = qs_standardize_string_numerics(n)
    if n != "0":
        return n
    return "0"
def strip_leading_trailing_zeroes_from_series_index(s_string):
    s_string = s_string.replace(" 01", " 1")
    s_string = s_string.replace(" 02", " 2")
    s_string = s_string.replace(" 03", " 3")
    s_string = s_string.replace(" 04", " 4")
    s_string = s_string.replace(" 05", " 5")
    s_string = s_string.replace(" 06", " 6")
    s_string = s_string.replace(" 07", " 7")
    s_string = s_string.replace(" 08", " 8")
    s_string = s_string.replace(" 09", " 9")
    s_string = s_string.replace(".000", "")  
    s_string = s_string.replace(".00", "")    
    s_string = s_string.replace(".0", "")      
    s_string = s_string.replace(".10", ".1")                
    s_string = s_string.replace(".20", ".2")
    s_string = s_string.replace(".30", ".3")
    s_string = s_string.replace(".40", ".4")
    s_string = s_string.replace(".50", ".5")
    s_string = s_string.replace(".60", ".6")
    s_string = s_string.replace(".70", ".7")
    s_string = s_string.replace(".80", ".8")
    s_string = s_string.replace(".90", ".9")
    return s_string
def refresh_custom_column_15(my_db,my_cursor,my_current_book,notifications,log):
    c_work_series_full_table = "custom_column_15"
    mysql = "DELETE FROM custom_column_15 WHERE book = ? "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    c_work_series_full_table = "custom_column_15" 
    mysql = "INSERT or IGNORE INTO custom_column_15 SELECT book,book,seriesfull FROM __series_work_full WHERE book = ? "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    c_work_series_full_table = "custom_column_15" 
    mysql =  "UPDATE custom_column_15 SET value=REPLACE(value,'.0','') WHERE book = ? "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    c_work_series_full_table = "custom_column_15" 
    mysql =  "UPDATE custom_column_15 SET value=REPLACE(value,'.5]','.50]') WHERE book = ? "
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
def compute_similarity(a,b):
    try:
        p = SequenceMatcher(None, a, b).ratio()
        if p:
            return p
        else:
            return 0.0000
    except:
        return 0.0000
def print_blanks(n):
    if not DEBUG:
        return
    n1 = int(n)
    if n1 <1:
        n1 = 1
    for i in range (1, n1):
        pass
def reformat_author_initials(author):
    initials_mode = 'A.B.'
    ignore_words = ['von', 'van', 'jr', 'jr.', 'sr', 'sr.', 'st', 'st.',
                    'ed', 'ed.', 'dr', 'dr.', 'phd', 'ph.d', 'ph.d.']
    ignore_upper_words = ['ii', 'iii']
    ignore_words_map = dict((k,True) for k in ignore_words)
    parts = author.split()
    new_parts = []
    append_to_previous = False
    for tok in parts:
        if len(tok) == 0:
            continue
        handled = False
        if tok.lower() in ignore_words_map and tok.upper() != tok:
            pass
        elif tok.lower() in ignore_upper_words:
            pass
        elif tok.isdigit():
            pass
        elif '.' in tok or (tok.upper() == tok and len(tok) <= 2):
            if initials_mode == 'A.B.':
                new_tok = ''
                for c in tok.replace('.',''):
                    new_tok += c + '.'
                if append_to_previous:
                    new_parts[-1] = new_parts[-1] + new_tok
                else:
                    new_parts.append(new_tok)
                    append_to_previous = True
            else:
                return author
            handled = True
        if not handled:
            new_parts.append(tok)
            append_to_previous = False
    return ' '.join(new_parts)
def Create_SQLite_User_Functions(my_db,my_cursor,log):
        global my_terminate_early
        try:
            my_db.createscalarfunction("update_utf8_for_display", SQLite_User_Function_1)
        except:
            my_terminate_early = True
            log("Create_SQLite_User_Function 1 failed...cannot proceed...")
        sleep(0.1)
        try:
            my_db.createscalarfunction("make_utf8_lowercase", SQLite_User_Function_2)
        except:
            my_terminate_early = True
            log("Create_SQLite_User_Function 2 failed...cannot proceed...")
        sleep(0.1)
        try:
            my_db.createscalarfunction("regexp", SQLite_User_Function_3)
        except Exception as e:
            my_terminate_early = True
            log("Create_SQLite_User_Function [3] failed...cannot proceed...")
        sleep(0.1)
def SQLite_User_Function_1(s):
    if s is None: #ignore Nulls being passed by SQLite
        return s
    if not s > " ":
        return s
    t = as_unicode(s)
    if t.count(".") < 2:
        t = titlecase(t) #uses custom function for advanced English-only titlecase
    t = t.strip()
    return t
def SQLite_User_Function_2(s):
    if s is None: #ignore Nulls being passed by SQLite
        return s
    if not s > " ":
        return s
    if isinstance(s, unicode_type):
        s = s.lower()
    return s
def SQLite_User_Function_3(regexpr,avalue):
    global re_already_imported
    if not re_already_imported:
        import re
        re_already_imported = True
    if regexpr:
        if avalue:
            try:
                s_string = avalue
                re_string = regexpr
                p = re.compile(re_string, re.IGNORECASE)
                match = p.search(s_string)
                if match:
                    return True
                else:
                    return False
            except Exception as e:
                return false
from string import digits
from locale import atoi
def calcisbn10checksum(isbn):
    try:
        if len(isbn)!=10:
            s = "INVALID"
            return s
        else:
            return 0 == sum((10-w)*atoi('10' if d == 'X' else d)
                            for w,d in enumerate(isbn.upper()))%11
    except:
        s = "INVALID"
        return s
def calcisbn13checksum(isbn):
    try:
        if len(isbn)!=13 :
            s = "INVALID"
            return s
        c=(10-(sum(atoi(d) for d in isbn[0:12:2])
                     +sum(3*atoi(d) for d in isbn[1:12:2]))%10)%10
        return atoi(isbn[12]) == c
    except:
        s = "INVALID"
        return s
def explode_custom_column_10_if_needed(my_db,my_cursor,log):
    sleep(0.1)
    mysql = "INSERT or REPLACE INTO custom_column_10 (id,value) SELECT book, seriesname FROM __books_work_populate WHERE seriesname > ' '  ; "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "UPDATE books_custom_column_10_link  SET value = books_custom_column_10_link.book "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "DELETE FROM custom_column_10 WHERE id NOT IN (SELECT value FROM books_custom_column_10_link)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
def explode_custom_column_4_if_needed(my_db,my_cursor,log):
    sleep(0.5)
    mysql = "DELETE FROM custom_column_4 WHERE value = null " 
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "INSERT or REPLACE INTO custom_column_4 (id,value) SELECT book, authname FROM __books_work_populate WHERE authname NOT NULL ; "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "UPDATE books_custom_column_4_link  SET value = books_custom_column_4_link.book "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "DELETE FROM custom_column_4 WHERE id NOT IN (SELECT value FROM books_custom_column_4_link)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "UPDATE custom_column_4 SET value = (SELECT authorname FROM _books_work WHERE book = custom_column_4.id) \
                    WHERE custom_column_4.id IN(SELECT book FROM _books_work WHERE book NOT NULL)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.5)
def explode_custom_column_8_if_needed(my_db,my_cursor,log):
    sleep(0.1)
    mysql = "INSERT or REPLACE INTO custom_column_8 (id,value) SELECT book, booktitle FROM __books_work_populate WHERE booktitle > ' '  ; "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "UPDATE books_custom_column_8_link  SET value = books_custom_column_8_link.book "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "DELETE FROM custom_column_8 WHERE id NOT IN (SELECT value FROM books_custom_column_8_link)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
def explode_custom_column_13_if_needed(my_db,my_cursor,log):
    sleep(0.1)
    mysql = "INSERT or REPLACE INTO custom_column_13 (id,value) SELECT book, tagsall FROM __books_work_populate WHERE tagsall NOT NULL  ; "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "UPDATE books_custom_column_13_link  SET value = books_custom_column_13_link.book "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "DELETE FROM custom_column_13 WHERE id NOT IN (SELECT value FROM books_custom_column_13_link)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
def update_table_books_work(my_db,my_cursor,log):
    sleep(0.5)
    mysql = "DELETE FROM  _books_work WHERE book >= '0' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    mysql =  "INSERT OR IGNORE INTO _books_work SELECT book,booktitle,authname,seriesname,seriesindex FROM __books_work_populate"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.5)
    mysql = "UPDATE _books_work SET booktitle = (make_utf8_lowercase(booktitle) );"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    mysql = "UPDATE _books_work SET authorname = (make_utf8_lowercase(authorname) );"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.5)
    mysql = "DELETE FROM  _instr_title_author WHERE book >= 0 "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    mysql = "INSERT INTO _instr_title_author (book,booktitle,authorname) SELECT * FROM __instr_title_author_author_title"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.5)
def build_regex_list_from_tag_rules(my_db,my_cursor,log):
    global tag_regex_rules_list
    tag_regex_rules_list[:] = []
    sleep(0.5)
    mysql = "SELECT oldtag,newtag,purgetag FROM _tag_rules WHERE oldtag LIKE '/%' AND oldtag LIKE '%/'   ;  "
    tmp_rule_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rule_list:
        tag_regex_rules_list.append(as_unicode("^DELETE$"))
        return
    else:
        if len(tmp_rule_list) == 0:
            tag_regex_rules_list.append(as_unicode("^DELETE$"))
            return
        else:
            for item in tmp_rule_list:
                oldtag, newtag, purgetag = item
                if oldtag is None:
                    continue
                if newtag is None:
                    continue
                if purgetag is None:
                    purgetag = 0
                purgetag = as_unicode(purgetag)
                s = oldtag
                s = s[1:] #remove the first /
                if s.endswith("/"):
                    s = s[0: -1] #remove the trailing /
                new_row = s + "<|!!|>" + newtag + "<|!!|>" + purgetag
                tag_regex_rules_list.append(new_row)
            if len(tag_regex_rules_list) == 0:
                tag_regex_rules_list.append(as_unicode("^DELETE$"))
                return
def build_regex_list_from_tag_capitalization_rules(my_db,my_cursor,log):
    global tag_capitalization_regex_rules_list
    tag_capitalization_regex_rules_list[:] = []
    sleep(1.0)
    mysql = "SELECT regex,rule,priority FROM _tag_capitalization_rules WHERE regex NOT NULL \
                    AND rule NOT NULL AND priority NOT NULL  AND regex NOT LIKE '%,%'   "
    tmp_rule_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rule_list:
          return
    else:
        if len(tmp_rule_list) == 0:
            tag_capitalization_regex_rules_list.append(as_unicode("^DELETE$"))
            return
        else:
            for item in tmp_rule_list:
                regex, rule, priority = item
                s1 = regex
                s2 = rule
                s3 = as_unicode(priority)
                s3 = "000" + s3
                s3 = s3[-3: ]
                new_row = s3 + "<|!!|>" + s1 + "<|!!|>" + s2     
                tag_capitalization_regex_rules_list.append(as_unicode(new_row))
            if len(tag_capitalization_regex_rules_list) == 0:
                tag_capitalization_regex_rules_list.append(as_unicode("^DELETE$"))
                return
    tag_capitalization_regex_rules_list.sort(reverse=True)  
def apply_tag_capitalization_rules(tmp_tag,log):
    global tag_capitalization_regex_rules_list
    for row in tag_capitalization_regex_rules_list:
        rule_list = row.split("<|!!|>")
        priority = rule_list[0]
        re1 = rule_list[1]
        rule = rule_list[2]
        try:
            p1 = re.compile(re1, re.IGNORECASE)
            match1 = p1.search(tmp_tag)
            if match1:
                if rule == "titlecase":
                    tmp_tag = re.sub(re1, do_titlecase, tmp_tag, count=0, flags=re.IGNORECASE)
                    continue
                else:
                    if rule == "uppercase":
                        tmp_tag = re.sub(re1, do_uppercase, tmp_tag, count=0, flags=re.IGNORECASE)
                        continue
                    else:
                        if rule == "lowercase":
                            tmp_tag = re.sub(re1, do_lowercase, tmp_tag, count=0, flags=re.IGNORECASE)
                            continue
                        else:
                            if rule == "delete":
                                tmp_tag = re.sub(re1, do_delete, tmp_tag, count=0, flags=re.IGNORECASE)
                                continue
                            else:
                                if rule == "addspace_left":
                                    tmp_tag = re.sub(re1, do_addspace_left, tmp_tag, count=0, flags=re.IGNORECASE)
                                    continue
                                else:
                                    if rule == "addspace_right":
                                        tmp_tag = re.sub(re1, do_addspace_right, tmp_tag, count=0, flags=re.IGNORECASE)
                                        continue
                                    else:
                                        continue
            else:
                continue
        except Exception as e:
            continue
    return tmp_tag
def do_titlecase(matchobj):
    s = ""
    if matchobj.group(0):
        s = matchobj.group(0)
    s = s.title()
    return s
def do_uppercase(matchobj):
    s = ""
    if matchobj.group(0):
        s = matchobj.group(0)
    s = s.upper()
    return s
def do_lowercase(matchobj):
    s = ""
    if matchobj.group(0):
        s = matchobj.group(0)
    s = s.lower()
    return s
def do_delete(matchobj):
    s = ""
    return s
def do_addspace_left(matchobj):
    s = ""
    if matchobj.group(0):
        s = matchobj.group(0)
    s = " " + s
    return s
def do_addspace_right(matchobj):
    s = ""
    if matchobj.group(0):
        s = matchobj.group(0)
    s =  s + " "
    return s
def set_null_seriesname_index_to_zero(my_db,my_cursor,notifications,log):
    my_cursor.execute("begin")
    mysql = "UPDATE custom_column_12 SET value = '0' WHERE book IN(SELECT book  FROM __books_work_populate WHERE seriesname IS NULL AND seriesindex != '0')"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
    sleep(0.03)
def change_work_title_to_web_title_for_previously_validated_work_series(my_db,my_cursor,notifications,log):
    sleep(0.02)
    try:
        miscellaneous_scrubbing_5_mine_global_historical_data_for_use_in_renaming(my_db,my_cursor,notifications,log)
    except:
        pass
    mysql = "SELECT work_author FROM _web_series_rename_detail"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_rows:
        n = len(tmp_rows)
        if n == 0:
            table_is_empty = True
        else:
            table_is_empty = False
        del tmp_rows
    else:
        table_is_empty = True
    if table_is_empty:
        try:
            sleep(0.02)
            mysql = "DELETE FROM _web_series_rename_detail_cumulative WHERE  work_series = web_series \
                                OR web_series IS NULL OR work_series IS NULL OR work_series = 'Novel'  OR  work_series = 'novel' \
                                OR work_series = ' '  OR  work_series = ''      ;  "
            execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
            sleep(0.02)
            mysql = "INSERT OR IGNORE INTO _web_series_rename_detail SELECT * FROM _web_series_rename_detail_cumulative \
                                                            WHERE work_series IN(SELECT value FROM custom_column_10 WHERE value NOT NULL)  "
            execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
            sleep(0.02)
        except:
            try:
                my_cursor.execute("commit")
            except:
                pass
    book_ok_list = []
    mysql = "SELECT book,'dummy' FROM __books_work_status WHERE value = 'book_ok' "
    tmp_rows_bws = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_rows_bws:
        n = len(tmp_rows_bws)
        if n == 0:
            log("No Work Titles to Rename[no statuses of book_ok found]")
            return
        else:
            for row in tmp_rows_bws:
                book,dummy = row
                book = int(book)
                book_ok_list.append(book)
            del tmp_rows_bws
            book_ok_set = set(book_ok_list)
            del book_ok_list
            log("Books with a status of 'book_ok' found for potential renaming: " + as_unicode(n))
    else:
        log("No Work Titles to Rename[no statuses of book_ok found]")
        del book_ok_list
        return
    gwsd_dict = {}
    mysql = "SELECT booktitle,authname FROM _global_web_series_detail"
    tmp_rows_gwsd = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_rows_gwsd is not None:
        if isinstance(tmp_rows_gwsd,list):
            n = len(tmp_rows_gwsd)
            if n == 0:
                log("No Work Titles to Rename[no wssvd found]")
                return
            else:
                for row in tmp_rows_gwsd:
                    if row is not None:
                        if isinstance(row,tuple):
                            booktitle,authname = row
                            if isinstance(booktitle,unicode_type) and isinstance(authname,unicode_type):
                                booktitle = booktitle.lower()
                                authname = authname.lower()
                                gwsd_dict[booktitle] = authname
                            else:
                                continue
                del tmp_rows_gwsd
                log("WSSVD history items available for use in potential renaming: " + as_unicode(n))
        else:
            log("No Work Titles to Rename[no wssvd found]")
            del gwsd_dict
            return
    else:
        log("No Work Titles to Rename[no wssvd found]")
        del gwsd_dict
        return
    mysql = "SELECT web_authname, web_seriesname, web_booktitle, web_seriesindex, work_booktitle, work_index, book \
                    FROM __web_booktitle_wrong_work_booktitle_part2  "
    tmp_rows_wbwwbp2 = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_rows_wbwwbp2:
        n = len(tmp_rows_wbwwbp2)
        if n == 0:
            log("No Work Titles to Rename[no candidates found]")
            return
        else:
            log("Number of candidates for potential renaming of Work Title to Web Title: " + as_unicode(n))
    else:
        log("No Work Titles to Rename[no candidates found]")
        return
    working_list = []
    for row in tmp_rows_wbwwbp2:
        web_authname, web_seriesname, web_booktitle, web_seriesindex, work_booktitle, work_index, book = row
        book = int(book)
        web_booktitle = web_booktitle.lower()
        web_authname = web_authname.lower()
        if not book in book_ok_set:
            continue
        if work_booktitle in gwsd_dict: 
            authname = gwsd_dict[work_booktitle]
            if authname == web_authname:
                continue
        working_list.append(row)
    del gwsd_dict
    del tmp_rows_wbwwbp2
    del book_ok_set
    if len(working_list) == 0:
        del working_list
        log("No Work Titles to Rename[all candidates already match]")
        return
    n_counter = 0
    for row in working_list:
        web_authname, web_seriesname, web_booktitle, web_seriesindex, work_booktitle, work_index, book = row
        work_booktitle = work_booktitle.lower()
        web_booktitle = web_booktitle.lower()
        n_similarity = compute_similarity(work_booktitle, web_booktitle)
        if (work_booktitle in web_booktitle) or (web_booktitle in work_booktitle) or n_similarity >= .80 :
            book = int(book)
            web_booktitle = web_booktitle.title()
            sleep(0.1)
            mysql = "UPDATE custom_column_8 SET value = ?  WHERE  custom_column_8.id = ? "
            execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,web_booktitle, book)
            n_counter = n_counter + 1
            log(" ")
            log(as_unicode("[ " + work_booktitle) + " ] Changed to:  [" + as_unicode(web_booktitle) + " ] for Series:  [ " + as_unicode(web_seriesname) + " ]   Similarity was: [ " + as_unicode(n_similarity) + " ]" )
        else:
            if web_seriesindex != "0":        
                log(as_unicode("[ " + work_booktitle) + " ] Was NOT Changed to:  [" + as_unicode(web_booktitle) + " ] for Series:  [ " + as_unicode(web_seriesname) + " ]   Similarity was: [ " + as_unicode(n_similarity) + " ]   Manual Review of Work Series Index Required." )
                pass
    del working_list
    log(" ")
    log("-------------------------------------------------------------------------------------------------------------------------------------------")
    log(" ")
    log("Total Incorrect Book Work Titles Changed to Correct Book Web Titles for Identical Series/Indexes:  " + as_unicode(n_counter))
    log(" ")
    log("-------------------------------------------------------------------------------------------------------------------------------------------")
    try:
        my_cursor.execute("begin")
        mysql = "UPDATE custom_column_12 SET value = 1 WHERE book IN(SELECT book FROM custom_column_15 WHERE custom_column_15.value LIKE '%[0]%' )"
        my_cursor.execute(mysql)
        sleep(0.1)
        mysql = "UPDATE custom_column_15 SET value = (replace(value,'[0]','[1]')) WHERE custom_column_15.value LIKE '%[0]%'  "
        my_cursor.execute(mysql)
        sleep(0.1)
        my_cursor.execute("commit")
    except:
        try:
            my_cursor.execute("commit")
        except:
            pass
    if table_is_empty: 
        try:
            my_cursor.execute("begin")
            mysql = "DELETE FROM _web_series_rename_detail"
            my_cursor.execute(mysql)
            sleep(0.1)
            my_cursor.execute("commit")
        except:
            try:
                my_cursor.execute("commit")
            except:
                pass
def remove_all_double_quotes(my_db,my_cursor,notifications,log):
    sleep(0.1)
    s1 = '"'
    s2 = ''
    mysql = ""
    try:
        my_cursor.execute("begin")
        mysql = 'UPDATE custom_column_4 SET value = replace(custom_column_4.value,?,?)'
        my_cursor.execute(mysql,(s1,s2))
        mysql = 'UPDATE custom_column_8 SET value = replace(custom_column_8.value,?,?)'
        my_cursor.execute(mysql,(s1,s2))
        mysql = 'UPDATE custom_column_10 SET value = replace(custom_column_10.value,?,?)'
        my_cursor.execute(mysql,(s1,s2))
        mysql = 'UPDATE custom_column_13 SET value = replace(custom_column_13.value,?,?)'
        my_cursor.execute(mysql,(s1,s2))
        mysql = 'UPDATE custom_column_15 SET value = replace(custom_column_15.value,?,?)'
        my_cursor.execute(mysql,(s1,s2))
        my_cursor.execute("commit")
    except Exception as e:
        raise e
def insert_single_tags_into_work_tags_single(my_db,my_cursor,notifications,log):
    global single_work_tags_all_list
    if not single_work_tags_all_list:
        return
    else:
        n = len(single_work_tags_all_list)
        if n == 0:
            return
    tmp_set = set(single_work_tags_all_list)
    single_work_tags_all_list = list(tmp_set)  
    try:
        sleep(0.3)
        my_cursor.execute("begin")
        for row in single_work_tags_all_list:
            s1 = row
            if (not s1 > " "):
                continue
            s1 = s1.replace(" & ", "&")
            s1 = s1.replace(" / ", ":")        
            s1 = s1.replace("Fiction - ", "Fiction:")
            for x in range(1,4):
                n = s1.count(":")
                if n > 1:
                    three_tuple = s1.rpartition(":")    
                    a,b,c = three_tuple
                    b = "-"     
                    s1 = a + b + c       
                else:
                    break
            n = s1.count(":")
            s1 = s1.replace(" Stories", "")
            s1 = s1.replace(" Tales", "")
            s2 = 'tbd'
            mysql = 'INSERT OR IGNORE INTO _tags_work_single (tag,subject) VALUES (?,?)'
            my_cursor.execute(mysql,(s1,s2))
        my_cursor.execute("commit")
    except Exception as e:
        raise e
    try:
        sleep(0.3)
        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO _tags_work_single SELECT tag, subject FROM __tags_work_single_subject WHERE tag NOT NULL AND subject NOT NULL"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        raise e
    try:
        sleep(0.3)
        my_cursor.execute("begin")
        mysql = 'UPDATE _tags_work_single SET tag = (update_utf8_for_display(tag) ) '
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except:
        try:
            my_cursor.execute("commit")
        except:
            pass
    try:
        sleep(0.3)
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO _tag_priorities SELECT tag,'0' FROM _tags_work_single \
                        WHERE tag NOT IN(SELECT tag FROM _tag_priorities WHERE tag = _tags_work_single.tag)"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        log(" ")
        log("Work Tags missing from table _tag_priorities (if any) have been added with a Priority = 0. ")
        log(" ")
    except:
        try:
            my_cursor.execute("commit")
        except:
            pass
    try:
        mysql = "SELECT tag,priority FROM _tag_priorities WHERE priority = 0  AND (tag LIKE '%fict%' OR tag LIKE '%fact%') AND tag LIKE '%:%' AND tag LIKE 'F%'"
        tmp_rule_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
        if not tmp_rule_list:
            pass
        else:
            if len(tmp_rule_list) == 0:
                pass
            else:
                my_cursor.execute("begin")
                for item in tmp_rule_list:           
                    tag,priority = item
                    tag = apply_tag_capitalization_rules(as_unicode(tag),log)
                    n_100 = 100
                    mysql = "INSERT OR IGNORE INTO _tag_priorities (tag,priority) VALUES (?,?) ;"
                    my_cursor.execute(mysql,(tag,n_100))
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM _tag_priorities WHERE priority = 0  AND (tag LIKE '%fict%' OR tag LIKE '%fact%') AND tag LIKE '%:%' AND tag LIKE 'F%'"
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.03)
                my_cursor.execute("begin")
                mysql = "DELETE FROM _tag_priorities WHERE tag LIKE '%978%' OR tag IN(SELECT code FROM _global_subject_codes WHERE code = tag)  "
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.03)
    except Exception as e:
        try:
            my_cursor.execute("commit")
        except:
            pass
def build_regex_list_from_title_rules(my_db,my_cursor,log):
    global title_regex_rules_list
    title_regex_rules_list[:] = []
    sleep(0.5)
    mysql = "SELECT priority,oldword,newword,purgeword FROM _title_rules ORDER BY priority DESC  ;  "
    tmp_rule_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rule_list:
        log("ERROR: No Title Rules Table Entries Found")
        return
    else:
        if len(tmp_rule_list) == 0:
            title_regex_rules_list.append(as_unicode("^DELETE$"))
            log("WARNING: No Title Rules Table Entries Found")
            return
        else:
            for item in tmp_rule_list:           
                priority,oldword, newword, purgeword = item
                if oldword is None:
                    continue
                if newword is None:
                    newword = ""
                if purgeword is None:
                    purgeword = "0"
                else:
                    purgeword = as_unicode(purgeword)
                s = oldword
                if s.startswith("/"):
                    s = s[1:] #remove the first /
                if s.endswith("/"):
                    s = s[0: -1] #remove the trailing /
                new_row = s + "<|!!|>" + newword + "<|!!|>" + purgeword 
                title_regex_rules_list.append(new_row)
def build_regex_list_from_series_rules(my_db,my_cursor,log):
    global series_regex_rules_list
    series_regex_rules_list[:] = []
    sleep(0.5)
    mysql = "SELECT priority,oldword,newword,purgeword FROM _series_rules ORDER BY priority DESC  ;  "
    tmp_rule_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rule_list:
        log("ERROR: No series Rules Table Entries Found")
        return
    else:
        if len(tmp_rule_list) == 0:
            series_regex_rules_list.append(as_unicode("^DELETE$"))
            log("WARNING: No series Rules Table Entries Found")
            return
        else:
            for item in tmp_rule_list:           
                priority,oldword, newword, purgeword = item
                if oldword is None:
                    continue
                if newword is None:
                    newword = ""
                if purgeword is None:
                    purgeword = "0"
                else:
                    purgeword = as_unicode(purgeword)
                s = oldword
                if s.startswith("/"):
                    s = s[1:] #remove the first /
                if s.endswith("/"):
                    s = s[0: -1] #remove the trailing /
                new_row = s + "<|!!|>" + newword + "<|!!|>" + purgeword 
                series_regex_rules_list.append(new_row)
def process_title_using_title_rules(s,log):
    global title_regex_rules_list
    title = s
    for row in title_regex_rules_list:
        rule_list = row.split("<|!!|>")
        re1 = rule_list[0]
        try:
            p1 = re.compile(re1, re.IGNORECASE)      
            match1 = p1.search(title)
            if match1:
                newword = rule_list[1]
                purgeword = rule_list[2]
                if ((not newword) or newword == "None") and purgeword == "1" :
                    title = re.sub(re1, "", title)
                    continue
                else:
                    if (newword) and (newword != "None") and (purgeword != "1") :
                        newword = newword.replace('"', "")
                        newword = newword.replace("'", "")
                        s = match1.group(0)
                        title = title.replace(s, newword)
                        title = title.strip()
                        title = title.replace("  ", " ")
                        continue
                    else:
                        continue
            else:
                continue
        except Exception as e:
            log("Table _title_rules REGEX Rule Compile Error:" + e)
            log("REGEX rule was:" + re1)
            log("Please fix your REGEX rule via table _title_rules maintenance.  Bypassing bad rule and continuing.")
            continue
    return title
def process_series_using_series_rules(s,log):
    global series_regex_rules_list
    series = s
    for row in series_regex_rules_list:
        rule_list = row.split("<|!!|>")
        re1 = rule_list[0]
        try:
            p1 = re.compile(re1, re.IGNORECASE)      
            match1 = p1.search(series)
            if match1:
                newword = rule_list[1]
                purgeword = rule_list[2]
                if ((not newword) or newword == "None") and purgeword == "1" :
                    series = re.sub(re1, "", series)
                    continue
                else:
                    if (newword) and (newword != "None") and (purgeword != "1") :
                        newword = newword.replace('"', "")
                        newword = newword.replace("'", "")
                        s = match1.group(0)
                        series = series.replace(s, newword)
                        series = series.strip()
                        series = series.replace("  ", " ")
                        continue
                    else:
                        continue
            else:
                continue
        except Exception as e:
            log("Table _series_rules REGEX Rule Compile Error:" + e)
            log("REGEX rule was:" + re1)
            log("Please fix your REGEX rule via table _series_rules maintenance.  Bypassing bad rule and continuing.")
            continue
    series = series.replace("  ", " ")
    series = series.strip()
    return series
def derive_tags_from_comments(my_db,my_cursor,my_current_book,notifications,log):
    global probable_tags_to_add_list
    mysql = "SELECT tag,'dummy' FROM _tags_by_comment WHERE EXISTS (SELECT text FROM comments  WHERE book = ? \
                        AND comments.text LIKE '%'||_tags_by_comment.comment||'%' ) "
    tmp_list = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=None)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                tmp_tag,dummy = row
                if tmp_tag is None:
                    continue
                tmp_tag = tmp_tag.strip()
                if tmp_tag != "":
                    probable_tags_to_add_list.append(tmp_tag)
def add_tag_combinations(my_db,my_cursor,notifications,log):
    for x in range(0, 5):
        mysql = "UPDATE custom_column_13 SET value = (SELECT bigtag FROM __tag_combination_rules_by_id_part2 \
                    WHERE  __tag_combination_rules_by_id_part2.id = custom_column_13.id) \
                    WHERE custom_column_13.id IN(SELECT id FROM __tag_combination_rules_by_id_part2)"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
def convert_isbn_check_digit_13(isbn):
    try:
        assert len(isbn) == 12
        sum = 0
        for i in range(len(isbn)):
            c = int(isbn[i])
            if i % 2: w = 3
            else: w = 1
            sum += w * c
        r = 10 - (sum % 10)
        if r == 10: return '0'
        else: return r
    except:
        return isbn
def convert_isbn_convert_10_to_13(isbn):
    try:
        assert len(isbn) == 10
        prefix = '978' + isbn[:-1]
        check = convert_isbn_check_digit_13(prefix)
        return prefix + check
    except:
        return isbn
def purge_transient_tables(my_db,my_cursor,log):
    sleep(0.1)
    mysql = "DELETE FROM  _books_work  ; "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "DELETE FROM  _instr_title_author  ; "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "DELETE FROM  _instr_series_series  ; "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
def apply_tag_string_replacement_rules(my_db,my_cursor,log):
    sleep(0.1)
    mysql = "SELECT book, tagsall,old_string,new_string FROM __tag_string_replacement_rules_part1 "
    tmp_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                book,tagsall,old_string,new_string = row
                sleep(0.1)
                try:
                    my_cursor.execute("begin")
                    mysql = "UPDATE custom_column_13 SET value = (replace(value,?,?)) WHERE custom_column_13.id = ?"
                    my_cursor.execute(mysql,(old_string,new_string,book))
                    my_cursor.execute("commit")
                except:
                    try:
                        my_cursor.execute("commit")
                        continue
                    except:
                        continue
            try:
                my_cursor.execute("commit")
            except:
                pass
def scrub_manga_control(my_db,my_cursor,my_current_book,notifications,log):
    re1 = "[c][h]*[apter]*[ ]*[0-9]+[-][0-9]+"
    re2 = "v[olume ]*[0-9]+[ _]*c[hapter ]*[0-9]+"
    re3 = "ch[0-9]+"
    re4 = "[0-9]+"
    re_list = []
    re_list.append(as_unicode(re1))
    re_list[0] = re1
    re_list.append(as_unicode(re2))
    re_list[1] = re2
    re_list.append(as_unicode(re3))
    re_list[2] = re3
    re_list.append(as_unicode(re4))
    re_list[3] = re4
    update_auth = False
    can_update_title = False
    update_series = False
    update_index = False
    update_tags = False
    mysql = "SELECT  booktitle,seriesname,seriesindex FROM __manga_metadata WHERE book = ? "
    tmp_list = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=None)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                booktitle,seriesname,seriesindex = row
                break
    if not booktitle:
        booktitle = "NONE"
        can_update_title = True
    if not seriesname:
        seriesname = "NONE"
        update_series = True
    if not seriesindex:
        seriesindex = "0"
        update_index = True
    tmp_title = booktitle
    tmp_series = seriesname
    tmp_seriesindex = seriesindex
    tmp_seriesindex = qs_standardize_string_numerics(tmp_seriesindex,return_integer=False,return_float=True)
    log(" ")
    log("Special Manga Processing for:  " + tmp_title)
    for x in range(0,4):
        re_x = re_list[x]
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(tmp_title)
            if matchx:
                if x == 0:                     
                    s0 = matchx.group(0)
                    s_split = tmp_title.split(s0)
                    tmp_title = s_split[0]
                    tmp_title = tmp_title.replace("_"," ",20)
                    can_update_title = True
                    if tmp_series == "NONE":
                        tmp_series = matchx.group(0)
                        update_series = True
                        tmp_seriesindex = "1"
                        update_index = True
                    break
                elif x == 1:                  
                    s1 = matchx.group(0)
                    s1 = s1
                    s1 = s1.lower()
                    s0 = s1
                    s_split = s1.split("c")
                    s2 = s_split[1]
                    case_1 = False
                    if tmp_series == "NONE":
                        tmp_series = s0
                        tmp_series = tmp_series.strip()
                        ns = tmp_series.count(" ")
                        nu = tmp_series.count("_")
                        nv = tmp_series.count("volume")
                        if nv == 0:
                            case_1 = True
                        if case_1:
                            if ns > 0:
                                s_split = tmp_series.split(" ")
                            else:
                                s_split = tmp_series.split("_")
                            tmp_series = s_split[0]
                            tmp_series = tmp_series.strip()
                            tmp_series = tmp_series.replace("v","Manga Volume ")
                        else:
                            s_split = tmp_series.split("c")
                            tmp_series = s_split[0]
                            tmp_series = tmp_series.strip()
                            tmp_series = tmp_series.replace("volume", "Manga Volume ")
                        update_series = True
                        tmp_seriesindex = qs_standardize_string_numerics(s2)
                    if not case_1:
                        tmp_seriesindex = tmp_seriesindex.replace("hapter", "")
                    if tmp_seriesindex.startswith("0"):
                        tmp_seriesindex = tmp_seriesindex[1: ]
                        if len(tmp_seriesindex) == 0:
                            tmp_seriesindex = "0"
                    update_index = True
                    s0 = matchx.group(0)
                    s_split = tmp_title.split(s0)
                    tmp_title = s_split[0]
                    tmp_title = tmp_title.replace("_"," ",20)
                    can_update_title = True
                    break
                elif x == 2:                  
                    s1 = matchx.group(0)
                    s1 = s1
                    s0 = s1
                    s1 = s1.lower()
                    s1 = s1.replace("ch", "")
                    if tmp_series == "NONE":
                        tmp_series = "Chapter"
                        update_series = True
                    tmp_seriesindex = qs_standardize_string_numerics(s1)
                    update_index = True
                    s0 = matchx.group(0)
                    s_split = tmp_title.split(s0)
                    tmp_title = s_split[0]
                    tmp_title = tmp_title.replace("_"," ",20)
                    can_update_title = True
                    break
                elif x == 3:                  
                    s1 = matchx.group(0)
                    s1 = s1
                    s0 = tmp_title.replace(s1,"",2)
                    if tmp_series == "NONE":
                        tmp_series = "Manga"
                        update_series = True
                    tmp_seriesindex = qs_standardize_string_numerics(s1)
                    update_index = True
                    break
                else:
                    log("No Manga Pattern Found: " + tmp_title)
                    break
        except Exception as e:
            log("Manga regex error: " + re_x) + "  " + as_unicode(e)
            continue
    re_x = "^[\[][a-z ]+[\]]"
    try:
        px = re.compile(re_x, re.IGNORECASE)
        matchx = px.search(tmp_title)
        if matchx:
            s1 = matchx.group(0)
            s1 = s1
            tmp_title = tmp_title.replace(s1,"",2)
            can_update_title = True
    except:
        pass
    re_x = "[(][size]+.+GB[)]"
    try:
        px = re.compile(re_x, re.IGNORECASE)
        matchx = px.search(tmp_title)
        if matchx:
            s1 = matchx.group(0)
            s1 = s1
            tmp_title = tmp_title.replace(s1,"",2)
            can_update_title = True
    except:
        pass
    n0 = len(tmp_title)
    tmp_title = tmp_title.replace("[", "")
    tmp_title = tmp_title.replace("]", "")
    tmp_title = tmp_title.replace("(", "")
    tmp_title = tmp_title.replace(")", "")
    tmp_title = tmp_title.replace(".png", "")
    tmp_title = tmp_title.replace(".zip", "")
    tmp_title = tmp_title.replace(".rar", "")
    n1 = len(tmp_title)
    if n0 != n1:
        can_update_title = True
    s_old = tmp_title
    tmp_title = tmp_title.replace("_"," ",20)
    if s_old != tmp_title:
        can_update_title = True
    tmp_title = tmp_title.strip()
    n = len(tmp_title)
    if n < 3:
        tmp_title = "Japan " + tmp_title
        tmp_title = tmp_title.title()
        can_update_title = True
    old_tmp_title = tmp_title
    tmp_title = tmp_title.replace("volume", "  Volume")
    tmp_title = tmp_title.replace("Volume", "  Volume")
    tmp_title = tmp_title.replace("  ", " ")
    tmp_title = tmp_title.strip()
    if old_tmp_title != tmp_title:
        can_update_title = True
    old_tmp_series = tmp_series
    tmp_series = tmp_series.replace("MangaVolume", "Manga Volume")
    tmp_series = tmp_series.replace("Mangavolume", "Manga Volume")
    tmp_series = tmp_series.replace("mangavolume", "Manga Volume")
    tmp_series = tmp_series.replace("mangaVolume", "Manga Volume")
    tmp_series = tmp_series.replace("olume0", "olume  0")
    tmp_series = tmp_series.replace("volume", "  Volume")
    tmp_series = tmp_series.replace("  ", " ")
    tmp_series = tmp_series.strip()
    if old_tmp_series != tmp_series:
        update_series = True
    if can_update_title:
        tmp_title = tmp_title.strip()
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id = ? '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
    if update_series:
        tmp_series = tmp_series.strip()
        tmp_series = tmp_series.title()
        mysql = 'INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES (?,?) '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,my_current_book,tmp_series)
        mysql = 'INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?) '
        execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book,my_current_book)
    if update_index:
        tmp_seriesindex = as_unicode(tmp_seriesindex)
        tmp_seriesindex = tmp_seriesindex.strip()
        tmp_seriesindex = float(tmp_seriesindex)
        mysql = 'INSERT OR REPLACE INTO custom_column_12 (id,book,value) VALUES (?,?,?) '
        execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,my_current_book,my_current_book,tmp_seriesindex)
def add_missing_seriesname_from_web_detail(my_db,my_cursor,my_current_book,notifications,log):
    mysql =  "SELECT __books_work_populate.book AS book, \
                                 __books_work_populate.booktitle AS title,\
                                 _global_web_series_detail.seriesname AS globalseries,\
                                 _global_web_series_detail.seriesindex AS globalindex \
                      FROM __books_work_populate,_global_web_series_detail \
                    WHERE __books_work_populate.book = ?  \
                    AND __books_work_populate.seriesname IS NULL \
                    AND __books_work_populate.authname NOT NULL \
                    AND __books_work_populate.booktitle NOT NULL \
                    AND __books_work_populate.authname = _global_web_series_detail.authname \
                    AND __books_work_populate.booktitle = _global_web_series_detail.booktitle"
    tmp_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                book,title,seriesname,seriesindex = row
                mysql = 'INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES (?,?)  '
                execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,book,seriesname)
                sleep(0.02)
                mysql = 'INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?) '
                execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,book,book,book)
                sleep(0.02)
                mysql = 'INSERT OR REPLACE INTO custom_column_12 (id,book,value) VALUES (?,?,?) '
                execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,book,book,seriesindex)
                sleep(0.02)
            seriesindex = qs_standardize_string_numerics(seriesindex,return_integer=False,return_float=True)
            log("[For Book]: " + title + "     [Missing Work Series Added per Historically Cumulative Web Data]:   " + as_unicode(seriesname) + "      [Index]:   " + as_unicode(seriesindex))
def scrub_first_first_series(my_db,my_cursor,my_current_book,notifications,log):
    mysql = "SELECT seriesname,'dummy' FROM __books_work_populate \
                    WHERE __books_work_populate.seriesname IS NOT NULL \
                    AND book = ?  "
    tmp_list = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=None)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                seriesname,dummy = row
    force_update = False
    re1 = "^[a-z ]+[0-9]+[;:,-]+[a-z ]+[0-9]+$"
    try:
        p1 = re.compile(re1, re.IGNORECASE)
        match1 = p1.search(seriesname)
        if match1:
            newseries = seriesname
            newseries = newseries.replace(";", "~~~")
            newseries = newseries.replace(":", "~~~")
            newseries = newseries.replace(",", "~~~")
            newseries = newseries.replace("-", "~~~")
            s_split = newseries.split("~~~")
            newseries = s_split[0]
            newseries = newseries.strip()
            force_update = True
        else:
            pass
    except:
        pass
    if not force_update:
        newseries = seriesname
        newseries = newseries.replace(".ICA ",".",2)
        newseries = newseries.replace("._."," ")
        n = newseries.count(".")
        if n > 2:
            newseries = newseries.replace("."," ")
        newseries = newseries.replace(" SciFan ","")
        newseries = newseries.replace(" ICA ","")
        newseries = newseries.replace("Serified","")
        re1 = "[\(][#]*[0-9]+[ ]of[ ][0-9]+[\)]"
        try:
            p1 = re.compile(re1, re.IGNORECASE)
            match1 = p1.search(newseries)
            if match1:
                s0 = match1.group(0)
                newseries = newseries.replace(s0,"",2)
        except:
            pass
        if newseries != seriesname:
            newseries = newseries.replace("  ", " ")
            newseries = newseries.strip()
            force_update = True
    else:
        pass
    if not force_update:
        return
    mysql = "UPDATE custom_column_10 SET value = ? WHERE id = ?"
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,newseries,my_current_book)
    sleep(0.02)
def scrub_with_special_custom_column_title_cc_control_rules(my_db,my_cursor,my_current_book,notifications,log):
    global title_cc_control_rules_list
    if len(title_cc_control_rules_list) == 0 :
        return
    rule_1 = False
    rule_2 = False
    rule_3 = False
    mysql = "SELECT booktitle,'dummy' FROM __books_work_populate  WHERE book = ? "
    tmp_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    if not tmp_list:
        log("ERROR: No Work Title Found For Book: " + my_current_book)
        return
    else:
        if len(tmp_list) == 0:
            log("ERROR: No Work Title Found For Book: " + my_current_book)
            return
        else:
            for row in tmp_list:
                title,dummy = row
                break
    n1 = title.count("{{")
    n2 = title.count("]:")
    if n1 == 0 and n2 == 0:
        return   
    new_title = "tbd"
    force_update = False
    for row in title_cc_control_rules_list:
        cc_number, datatype, rule = row
        rule_1 = False
        rule_2 = False
        if rule == "1":
            rule_1 = True
        if rule == "2":
            rule_2 = True
        if not rule_1 and not rule_2 :
            log("Invalid rule configured in table _title_cc_control: " + rule)
            continue
        re1 = get_table_title_cc_control_rule_regex(rule) 
        log("rule 0 checkpoint")
        try:
            p1 = re.compile(re1, re.IGNORECASE)
            match1 = p1.search(title)  
            if match1:
                log("rule 0.0 checkpoint")
                s = match1.group(0)
                s_test = s
                n = s_test.count(as_unicode(cc_number))
                if n == 0:
                    continue
                if rule_1:
                    log("rule 1 checkpoint")
                    new_title,new_cc_value = apply_table_title_cc_control_rule_1(title,s,cc_number,log)
                    if new_title == "NONE":
                        continue
                    else:
                        force_update = True
                if rule_2:
                    log("rule 2 checkpoint")
                    new_title,new_cc_value = apply_table_title_cc_control_rule_2(title,s,cc_number,log)
                    if new_title == "NONE":
                        continue
                    else:
                        force_update = True
                log("rule 0.1 checkpoint")
                if not force_update:
                    continue
                if new_title == title:
                    continue
                log("rule 0.2 checkpoint")
                update_non_qs_custom_columns_generic(my_db,my_cursor,log,cc_number,datatype,new_cc_value,my_current_book)
                mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                            (SELECT value FROM books_custom_column_8_link WHERE book = ? ) '
                execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,new_title,my_current_book)
                log(" ")
                log("Custom Column Value Derived from book with a title of: " + title )
                return
            else:
                continue
        except Exception as e:
            log("scrub_with_special_custom_column_title_cc_control_rules:   Table title_cc_control related processing Error:" + as_unicode(e))
            log("Rule was:" + rule)
            log("Please notify the developer of these messages by Private Message so it can be corrected.")
            return
def update_non_qs_custom_columns_generic(my_db,my_cursor,log,cc_number,datatype,new_cc_value,book):
    text_cc_table = "custom_column_ZZ"
    text_cc_link_table = "books_custom_column_ZZ_link"
    comment_cc_table = "custom_column_ZZ"
    cc_number = as_unicode(cc_number)
    if datatype != 'text' and datatype != 'comments' :
        log("ERROR: table _title_cc_control row has a datatype value error: " + datatype)
        return
    else:
        if datatype == "text":
            text_cc_table = text_cc_table.replace("ZZ", cc_number)
            text_cc_link_table = text_cc_link_table.replace("ZZ", cc_number)
            normalized = True
        else:
            comment_cc_table = comment_cc_table.replace("ZZ", cc_number)
            normalized = False
    sleep(0.1)
    if not normalized:
        mysql = "DELETE FROM  [TABLE]  WHERE book = ?  "
        mysql = mysql.replace("[TABLE]", comment_cc_table)
        execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=book)
        sleep(0.1)
        mysql = "INSERT OR REPLACE INTO  [TABLE]  (id,book,value) VALUES (?,?,?) "
        mysql = mysql.replace("[TABLE]", comment_cc_table)
        execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,book, book,new_cc_value)
        return
    if normalized:
        mysql = "SELECT id,'dummy' FROM [TABLE]  WHERE value = ?"
        mysql = mysql.replace("[TABLE]", text_cc_table)
        my_cursor.execute(mysql, ([new_cc_value]))
        tmp_rows = my_cursor.fetchall()
        id = None
        if not tmp_rows:
            id = "0"
        else:
            if len(tmp_rows) == 0:
                id = "0"
            else:
                for row in tmp_rows:
                    id,dummy = row
        if id == "0" or id is None:    
            mysql = "INSERT OR REPLACE INTO  [TABLE]  (id,value) VALUES (null,?) "
            mysql = mysql.replace("[TABLE]", text_cc_table)
            execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=new_cc_value)
            sleep(0.1)
        mysql = "DELETE FROM  [TABLE]  WHERE book = ?  "
        mysql = mysql.replace("[TABLE]", text_cc_link_table)
        execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=book)
        sleep(0.1)
        mysql = "SELECT id,'dummy' FROM [TABLE]  WHERE value = ?"
        mysql = mysql.replace("[TABLE]", text_cc_table)
        my_cursor.execute(mysql, (new_cc_value,))
        tmp_rows = my_cursor.fetchall()
        id = None
        if not tmp_rows:
            id = "0"
        else:
            if len(tmp_rows) == 0:
                id = "0"
            else:
                for row in tmp_rows:
                    id,dummy = row
        if id == "0" or id is None:
            log("ERROR: base custom table value does not exist although it was just added; continuing.")
            log("Book: " + as_unicode(book) + "  Table: " + as_unicode(text_cc_table))
            return
        mysql = "INSERT OR REPLACE INTO [LINKTABLE]  (id,book,value) VALUES ( null,?,?) "
        mysql = mysql.replace("[LINKTABLE]", text_cc_link_table)
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,v1=book,v2=id)
        sleep(0.1)
        mysql = "DELETE FROM  [TABLE]  WHERE id NOT IN(SELECT value FROM [LINKTABLE] WHERE book NOT NULL )"      
        mysql = mysql.replace("[TABLE]", text_cc_table)
        mysql = mysql.replace("[LINKTABLE]", text_cc_link_table)
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
        return
def build_rules_list_from_title_cc_control(my_db,my_cursor,log):
    global title_cc_control_rules_list
    title_cc_control_rules_list[:] = []
    mysql = "SELECT cc_number, datatype, rule FROM _title_cc_control WHERE active = 1 OR active = '1' OR active = 'true' OR active = 'TRUE' OR active = 'True'  "
    tmp_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                cc_number, datatype, rule = row
                cc_number = as_unicode(cc_number)
                rule = as_unicode(rule)
                title_cc_control_rules_list.append(row)
    title_cc_control_rules_list.sort()
def get_table_title_cc_control_rule_regex(rule):
    regex = "NONE"
    if rule == "1":
        regex = "[\{][\{][2-9][0-9][\}][:].+[\}]"            
    else:
        if rule == "2":
            regex = "[\[][0-9]+[\]][:].+[\]]"                  
    return regex
def apply_table_title_cc_control_rule_1(title,group0,cc_number,log):
    n = group0.count("}:")
    if n == 0:
        log("apply_table_title_cc_control_rule_1 Error:  invalid pattern passed to it.")
        return "NONE", "NONE"
    s_remove = group0 
    new_cc_value = group0 
    s_list = new_cc_value.split("}:") 
    s0 = s_list[0] 
    s0 = s0 + "}:"
    new_cc_value = new_cc_value.replace(s0,"") 
    new_cc_value = new_cc_value[0:-1]                  
    new_cc_value = new_cc_value.strip()
    new_title = title.replace(s_remove,"") 
    new_title = new_title.strip()
    return new_title,new_cc_value     
def apply_table_title_cc_control_rule_2(title,group0,cc_number,log):
    n = group0.count("]:")
    if n == 0:
        log("apply_table_title_cc_control_rule_2 Error:  invalid pattern passed to it.")
        return "NONE", "NONE"
    s_remove = group0 
    new_cc_value = group0 
    s_list = new_cc_value.split("]:") 
    s0 = s_list[0] 
    s0 = s0 + "]:"
    new_cc_value = new_cc_value.replace(s0,"") 
    new_cc_value = new_cc_value[0:-1]                  
    new_cc_value = new_cc_value.strip()
    new_title = title.replace(s_remove,"") 
    new_title = new_title.strip()
    return new_title,new_cc_value     
def add_title_rule_table_rules(my_db,my_cursor,log):
    try:
        sleep(0.03)
        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/[ ]raf[ ]/',' RAF ','0');"
        my_cursor.execute(mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/^raf[ ]/','RAF ','0');"
        my_cursor.execute(mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/^I[ ]AM[ ]/','I Am ','0');"
        my_cursor.execute(mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/[ ]atm[ ]/',' ATM ','0');"
        my_cursor.execute(mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/^atm[ ]*/','ATM ','0');"
        my_cursor.execute(mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/[-;:,]$/',' ','0');"
        my_cursor.execute(mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/[\[]the$/',' ','0');"
        my_cursor.execute(mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/^the[ ][:]/',' ','0');"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        try:
            my_cursor.execute("commit")
        except:
            pass
def scrub_comicbook_control(my_db,my_cursor,my_current_book,notifications,log):
    global author_is_probably_good
    global is_finished_scrub_title_index_series_in_title
    global is_finished_scrub_title_series_index_in_title
    global probable_tags_to_add_list
    global seriesindex_is_probably_good
    global title_is_frozen
    global title_is_probably_good
    author_is_probably_good = False
    is_finished_scrub_title_index_series_in_title = False
    is_finished_scrub_title_series_index_in_title = False
    seriesindex_is_probably_good = False
    title_is_frozen = False
    title_is_probably_good = False
    re1 = "^[a-z ]+[0-9]+[ ]+[\(][1-2][0-9][0-9][0-9][\)][ ][\(][a-z -]+[\)][ ][\(][a-z -]+[\)]$"
    re2 = "^[a-z ']+[ ][-][ ][a-z ']+[ ][-][ ][a-z -']+[,]*[#]*[0-9]+$"
    re3 = "^[a-z -]+[&][a-z -]+[ ][-][ ][a-z '-]+[,]*[#]*[0-9]+$"
    re4 = "^Marvel\'s[ ]['a-z -]+[,]*[#]*[0-9]+$"
    re5 = "^['a-z -]+[,]*[#]*[0-9]+$"
    re6 = "^['a-z ]+[ ][-][a-z .&]+[ ][,]*[#]*[0-9]+$"
    re_list = [] 
    re_list.append(as_unicode(re1))
    re_list[0] = re1
    re_list.append(as_unicode(re2))
    re_list[1] = re2
    re_list.append(as_unicode(re3))
    re_list[2] = re3
    re_list.append(as_unicode(re4))
    re_list[3] = re4
    re_list.append(as_unicode(re5))
    re_list[4] = re5
    re_list.append(as_unicode(re6))
    re_list[5] = re6
    can_update_author = False
    can_update_title = False
    update_series = False
    update_index = False
    if not isinstance(my_current_book,int):
        msg = "ERROR IN MY_CURRENT_BOOK: NOT AN INTEGER! " + as_unicode(my_current_book)
        log(msg)
        my_current_book = int(my_current_book)
    mysql = "SELECT book,authname,booktitle FROM __books_work_populate \
                            WHERE book IN(SELECT book FROM data WHERE format = 'CBR' OR format = 'CBZ' )  \
                            OR (tagsall LIKE '%CBR%' OR tagsall LIKE '%CBZ%' OR tagsall LIKE '%Graphic Novel%'  )  \
                            AND book NOT IN(SELECT book FROM __manga_metadata WHERE book = ?  )  \
                            AND book = ? "
    tmp_list = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=my_current_book)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                book,authname,booktitle = row
                break
    if not authname:
        authname = "unknown"
        can_update_author = True
    if not booktitle:
        booktitle = "NONE"
        can_update_title = True
    tmp_author = authname
    tmp_title = booktitle
    orig_title = booktitle
    probable_tags_to_add_list.append("Graphic Novel")
    probable_tags_to_add_list.append("Comics")
    log(" ")
    log("Special CBZ/CBR/Graphic Novel Processing for Title: " + tmp_title)
    if tmp_author == 'unknown' or tmp_author == 'Unknown':
        tmp_author = "C.B. Artist"
        can_update_author = True
        author_is_probably_good = True
    else:
        if (any(char.isdigit() for char in tmp_title)) and (any(char.isdigit() for char in tmp_author)):
            if tmp_title.count(" ") == 1:  
                s_new = ""
                n_new = ""
                for char in tmp_title:
                    if char.isdigit():
                        n_new = n_new + char
                    else:
                        s_new = s_new + char
                s1 = ""
                if n_new.isdigit():
                    if n_new == "1":
                        s1 = "One"
                    if n_new == "2":
                        s1 = "Two"
                    if n_new == "3":
                        s1 = "Three"
                    if n_new == "4":
                        s1 = "Four"
                    if n_new == "5":
                        s1 = "Five"
                else:
                    pass
                tmp_title = s_new + " " + s1
                tmp_title = tmp_title.strip()
            else:
                pass
        else:
            pass
        tmp_title = tmp_title + "  [ " + tmp_author + "  ] "
        tmp_author = "C.B. Artist"
        author_is_probably_good = True
        can_update_author = True
        can_update_title = True
    tmp_title = remove_bad_keywords(tmp_title)
    re_x = "[\(][1-2][0-9][0-9][0-9][\)]"        
    try:
        px = re.compile(re_x, re.IGNORECASE)
        matchx = px.search(tmp_title)
        if matchx:
            s0 = matchx.group(0)
            tmp_title = tmp_title.replace(s0, "")
            can_update_title = True
        else:
            pass
    except:
        pass
    for x in range(0,10):
        re_x = "[a-z][-][a-z]"    
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(tmp_title)
            if matchx:
                s0 = matchx.group(0)
                s1 = s0.replace("-"," ")
                tmp_title = tmp_title.replace(s0, s1)
                can_update_title = True
            else:
                break
        except:
            pass
    tmp_title = tmp_title.replace(" 1", " ,#1")
    tmp_title = tmp_title.replace(" 2", " ,#2")
    tmp_title = tmp_title.replace(" 3", " ,#3")
    tmp_title = tmp_title.replace(" 4", " ,#4")
    tmp_title = tmp_title.replace(" 5", " ,#5")
    tmp_title = tmp_title.replace(" 6", " ,#6")
    tmp_title = tmp_title.replace(" 7", " ,#7")
    tmp_title = tmp_title.replace(" 8", " ,#8")
    tmp_title = tmp_title.replace(" 9", " ,#9")
    tmp_title = tmp_title.replace(" 01", " ,#1")
    tmp_title = tmp_title.replace(" 02", " ,#2")
    tmp_title = tmp_title.replace(" 03", " ,#3")
    tmp_title = tmp_title.replace(" 04", " ,#4")
    tmp_title = tmp_title.replace(" 05", " ,#5")
    tmp_title = tmp_title.replace(" 06", " ,#6")
    tmp_title = tmp_title.replace(" 07", " ,#7")
    tmp_title = tmp_title.replace(" 08", " ,#8")
    tmp_title = tmp_title.replace(" 09", " ,#9")
    tmp_title = tmp_title.replace(" 00000", " 0")
    tmp_title = tmp_title.replace(" 0000", " 0")
    tmp_title = tmp_title.replace(" 000", " 0")
    tmp_title = tmp_title.replace(" 00", " 0")
    tmp_title = tmp_title.replace(" 0", " ,#")
    tmp_title = tmp_title.replace("#0","#")
    tmp_title = tmp_title.replace(" #"," ,#")
    tmp_title = tmp_title.replace("0 ","0.0 ")
    if ",#" in tmp_title:
        tmp_title = tmp_title.replace(".1 ",".0 ")     
        tmp_title = tmp_title.replace(".2 ",".0 ")
        tmp_title = tmp_title.replace(".3 ",".0 ")
        tmp_title = tmp_title.replace(".4 ",".0 ")
        tmp_title = tmp_title.replace(".6 ",".0 ")
        tmp_title = tmp_title.replace(".7 ",".0 ")
        tmp_title = tmp_title.replace(".8 ",".0 ")
        tmp_title = tmp_title.replace(".9 ",".0 ")
        tmp_title = tmp_title.replace(".00",".0")
        tmp_title = tmp_title.replace("1 ","1.0 ")     
        tmp_title = tmp_title.replace("2 ","2.0 ")
        tmp_title = tmp_title.replace("3 ","3.0 ")
        tmp_title = tmp_title.replace("4 ","4.0 ")
        tmp_title = tmp_title.replace("5 ","5.0 ")
        tmp_title = tmp_title.replace("6 ","6.0 ")
        tmp_title = tmp_title.replace("7 ","7.0 ")
        tmp_title = tmp_title.replace("8 ","8.0 ")
        tmp_title = tmp_title.replace("9 ","9.0 ")
    tmp_title = tmp_title.strip()
    tmp_title = tmp_title.replace("  "," ",20)
    tmp_author = tmp_author.strip()
    pattern = 999
    if not can_update_title:
        for x in range(0,6):
            re_x = re_list[x]
            try:
                px = re.compile(re_x, re.IGNORECASE)
                matchx = px.search(tmp_title)
                if matchx:
                    if x == 0:                     
                        pattern = 0
                        break
                    elif x == 1:                  
                        pattern = 1
                        break
                    elif x == 2:                  
                        pattern = 2
                        break
                    elif x == 3:                  
                        pattern = 3
                        break
                    elif x == 4:                  
                        pattern = 4
                        break
                    elif x == 5:                  
                        pattern = 5
                        break
                else:
                    pass
            except:
                log("Graphic Novel Title Search Pattern Compile Error:" + re_x)
                pass
    else:
        pass
    if pattern == 0  :           
        can_update_title = True
    if pattern == 1:                  
        re_x = re2
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(tmp_title)
            if matchx:       
                s0 = matchx.group(0)
                s0 = s0.strip()
                s_split = s0.split(" - ")
                n = len(s_split)
                if n != 3:
                    pass
                else:
                    tmp_title = s_split[0] + "  "  + s_split[1] + "   [ " + s_split[2] + " ]"
                    can_update_title = True
            else:
                pass
        except:
            pass
    if pattern == 2:                      
        re_x = re3
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(tmp_title)
            if matchx:       
                s0 = matchx.group(0)
                s0 = s0.strip()
                s_split = s0.split(" - ")
                n = len(s_split)
                if n != 2:
                    pass
                else:
                    s_split[1] = s_split[1].replace(" #"," ,#")
                    tmp_title = s_split[0] + "   [ " + s_split[1] + " ]"
                    can_update_title = True
            else:
                pass
        except:
            pass
    if pattern == 3:                       
        pass   
    if pattern == 4:                       
        s0 = tmp_title
        s_split = s0.split(" - ")
        n = len(s_split)
        if n != 2:
            pass
        else:
            s_split[1] = s_split[1].replace(" #"," ,#")
            tmp_title = s_split[0] + "   [ " + s_split[1] + " ]"
            can_update_title = True
    if pattern == 5:                       
        s0 = tmp_title
        s_split = s0.split(" - ")
        n = len(s_split)
        if n != 2:
            pass
        else:
            s_split[1] = s_split[1].replace(" #"," ,#")
            tmp_title = s_split[0] + "   [ " + s_split[1] + " ]"
            can_update_title = True
    tmp_title = tmp_title.replace(" #"," ,#")
    tmp_title = tmp_title.replace(",,"," ,")
    if ",#" in tmp_title and (not "[" in tmp_title):
        can_update_title = True
        s_split = tmp_title.split(",#")
        s0 = s_split[0]    
        tmp_title = s0 + "  [ " + tmp_title + " ]"  
    tmp_title = tmp_title.strip()
    if tmp_title.endswith("]"):
        re_x = "[\(][a-z ]+[\)]"
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(tmp_title)
            for x in range(0,7):  
                if matchx:       
                    s0 = matchx.group(0) 
                    tmp_title = tmp_title.replace(s0,"",2)
                    can_update_title = True
                else:
                    break
        except:
            pass
    if orig_title != tmp_title:
        can_update_title = True
    if can_update_author:
        tmp_author = tmp_author.strip()
        mysql = 'UPDATE custom_column_4 SET value =  ? WHERE  custom_column_4.id = ? '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_author,my_current_book)
        sleep(.1)
    if can_update_title:
        tmp_title = tmp_title.strip()
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id = ? '
        execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,tmp_title,my_current_book)
        sleep(.1)
def scrub_magazine_control(my_db,my_cursor,my_current_book,notifications,log):
    global is_scrubbable
    mysql = "SELECT book,authname,booktitle FROM __books_work_populate WHERE book = ? "
    tmp_list = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=None)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                book,authname,booktitle = row
                break
    re_x = "^[a-z '&]+[ ]*[-][ ]*(January|February|March|April|May|June|July|August|September|October|November|December)[ ][0-9]*[,]*[ ]*[1-2][0-9][0-9][0-9]"
    try:
        px = re.compile(re_x, re.IGNORECASE)
        matchx = px.search(booktitle)
        if matchx:
            is_scrubbable = False
            log(" ")
            log("Book or Magazine Not Scrubbed (Not Changed): " + booktitle)
            return
        else:
            return
    except:
        return
def add_book_awards(my_db,my_cursor,my_current_book,notifications,log, probable_tags_to_add_list):
    global book_awards_list
    mysql = "SELECT authname,booktitle FROM __books_work_populate WHERE book = ?"
    tmp_list = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=None)
    if not tmp_list:
        return probable_tags_to_add_list
    else:
        if len(tmp_list) == 0:
            return probable_tags_to_add_list
        else:
            for row in tmp_list:
                authname,booktitle = row
                break
    for row in book_awards_list:
        author,title,award = row
        try:
            author = author.title()
            title = title.title()
            authname = authname.title()
            booktitle = booktitle.title()
        except:
            pass
        x1 = compute_similarity(author,authname)
        x2 = compute_similarity(title,booktitle)
        if x1 >= 0.85 and x2 >= 0.85 :
            probable_tags_to_add_list.append(as_unicode(award))
            log("Award Added as Work Tag: " + award + "  " + as_unicode(booktitle) + "  " + as_unicode(authname))
            try:
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE INTO _book_awards_mapping (book,award) VALUES (?,?)"    
                my_cursor.execute(mysql,(my_current_book,award))
                my_cursor.execute("commit")
                sleep(.05)
            except Exception as e:
                log(as_unicode(e))
                try:
                    my_cursor.execute("commit")
                except:
                    pass
    n = len(probable_tags_to_add_list)
    for row in probable_tags_to_add_list:
        pass
    return probable_tags_to_add_list
def  build_book_awards_list(my_db,my_cursor,log):
    global book_awards_list
    book_awards_list = []
    mysql = "SELECT author,title,award FROM _book_awards"
    tmp_list = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                book_awards_list.append(row)
def  scrub_publisher_from_title(my_db,my_cursor,my_current_book,notifications,log):
    try:
        mysql = "SELECT book FROM __instr_publisher_title WHERE book = ? AND __instr_publisher_title.booktitle != __instr_publisher_title.publisher ; "
        tmp_list = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=None)
        if not tmp_list:
            return
        else:
            if len(tmp_list) == 0:
                return
    except Exception as e:
        log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
        log("ERROR in scrub_publisher_from_title: " + e)
        log("Did you run the After Version Upgrade job first?  It creates new Tables and Views, including __instr_publisher_title .")
        log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
        try:
            my_cursor.execute("commit")
            return
        except:
            return
    sleep(0.03)
    mysql = "UPDATE custom_column_8 SET value =(SELECT newtitle FROM __instr_publisher_title WHERE __instr_publisher_title.book = ?  ) \
                    WHERE custom_column_8.id = ? "
    execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,v1=my_current_book,v2=my_current_book)
def miscellany_change_work_index_to_web_index_standalone(my_db,my_cursor,notifications,log):
    n3 = 0
    sleep(0.5)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [8 of 10]: Changing Work Series Index to Web Series Index as Needed [Part 8.1]'))
    mysql = "SELECT book, authname, booktitle, seriesname, seriesindex  FROM __books_work_populate WHERE seriesname NOT NULL AND authname NOT NULL AND booktitle NOT NULL AND BOOK NOT NULL"
    tmp_rows_bwp = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_rows_bwp:
        pass
    else:
        log("a.Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + as_unicode(n3))
        return
    if len(tmp_rows_bwp) == 0:
        log("b.Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + as_unicode(n3))
        return
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [8 of 10]: Changing Work Series Index to Web Series Index as Needed [Part 8.2]'))
    mysql = "SELECT web_authname, web_seriesname, web_booktitle, web_seriesindex  \
                     FROM __web_global_authors_series_titles_indexes \
                     WHERE web_seriesindex NOT NULL AND web_seriesindex != '0' \
                         AND web_seriesname NOT NULL AND web_booktitle NOT NULL AND web_authname NOT NULL"
    tmp_rows_wgasti = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_rows_wgasti:
        pass
    else:
        log("a..Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + as_unicode(n3))
        return
    if len(tmp_rows_wgasti) == 0:
        log("b..Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + as_unicode(n3))
        return
    working_list = []
    for row in tmp_rows_bwp:
        book, authname, booktitle, seriesname, seriesindex = row
        for item in tmp_rows_wgasti:
            web_authname, web_seriesname, web_booktitle, web_seriesindex = item
            try:
                if authname.lower() == web_authname.lower():
                    if seriesname.lower() == web_seriesname.lower():
                        if booktitle.lower() == web_booktitle.lower():
                            working_list.append(book)  
                            break
            except:
                pass
    if len(working_list) == 0:
        log("...Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + as_unicode(n3))
        return
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [8 of 10]: Changing Work Series Index to Web Series Index as Needed [Part 8.3]'))
    mysql = "SELECT book,work_seriesindex,web_seriesindex FROM __web_global_seriesindex_not_match_work_seriesindex WHERE book NOT NULL"
    tmp_rows_wgsnmwsi = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if tmp_rows_wgsnmwsi:
        n2 = len(tmp_rows_wgsnmwsi)
        if n2 > 0:
            log("-------------------------------------------------------------------------------------------------------------------------------------------")
            tmp_dict = {}
            for item in tmp_rows_wgsnmwsi:
                book,work_seriesindex,web_seriesindex = item
                book = int(book)
                tmp_dict[book] = item
            for row in working_list:      
                book = row
                book = qs_standardize_string_numerics(book)
                book = book.strip()
                if book in tmp_dict:      
                    line = tmp_dict[book]
                    book,work_seriesindex,web_seriesindex = line
                    if not web_seriesindex:
                        continue
                    if not web_seriesindex > 0:
                        continue
                    if work_seriesindex == web_seriesindex:
                        continue
                else:
                    continue
                book = int(book)
                mysql = "UPDATE custom_column_12 SET value = ? \
                                    WHERE custom_column_12.book = ? \
                                        AND custom_column_12.value = ? "
                execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,web_seriesindex, book, work_seriesindex)
                n3 = n3 + 1
                log("book, work series index, web series index: " + book) + "   " + as_unicode(work_seriesindex) + "   " + as_unicode(web_seriesindex)
                refresh_custom_column_15(my_db,my_cursor,book, None,log)
            log(" ")
            log("-------------------------------------------------------------------------------------------------------------------------------------------")
            log(" ")
            log("Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + as_unicode(n3))
            log(" ")
            log("-------------------------------------------------------------------------------------------------------------------------------------------")
            log(" ")
        else:
            log("....Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + as_unicode(n3))
            return
    else:
        log(".....Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + as_unicode(n3))
        return
def change_work_series_full_to_standard(my_db,my_cursor,log):
    try:
        my_cursor.execute("\
                            BEGIN TRANSACTION;\
                            UPDATE custom_columns SET datatype = 'comments' WHERE id = 15 AND label = 'work_series_full' AND normalized = 0 AND datatype = 'text' ; \
                            COMMIT;")
    except Exception as e:
        pass
def miscellaneous_scrubbing_5_mine_global_historical_data_for_use_in_renaming(my_db,my_cursor,notifications,log):
    n_count = 0
    tmp_books_list = miscellaneous_scrubbing_5_fetch_all_books_with_series(my_db,my_cursor,log)
    tmp_series_list = miscellaneous_scrubbing_5_fetch_series(my_db,my_cursor,log,tmp_books_list)
    for row in tmp_series_list:       
        s = row
        s_list = s.split("||@||")
        work_auth = s_list[0]
        work_series = s_list[1]
        work_series = work_series.replace("'", "")
        work_series = work_series.replace('"', "")
        work_auth = work_auth.replace("'", "")
        work_auth = work_auth.replace('"', "")
        generic_series = miscellaneous_scrubbing_5__genericize_seriesname(work_series)
        mysql = "SELECT authname,seriesname FROM _global_web_author_series \
                                WHERE (authname = '[work_auth]' ) \
                                    AND ( (seriesname = '[work_series]' ) OR \
                                             (seriesname like '%[work_series]%' ) OR \
                                             (seriesname like '%[generic_series]%' ) OR \
                                             (seriesname = '[generic_series]' ) \
                                            ) "
        mysql = mysql.replace("[work_auth]", work_auth)
        mysql = mysql.replace("[work_series]", work_series)
        mysql = mysql.replace("[generic_series]", generic_series)
        tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
        if not tmp_rows:
            continue
        else:
            for row in tmp_rows:
                web_auth, web_series_name = row
                mysql = 'INSERT OR IGNORE INTO _web_series_rename_detail_cumulative (work_series,work_author,web_series,web_author) VALUES (?,?,?,?) '
                execute_mysql_for_custom_column_generic_4_args(my_db,my_cursor,log,mysql,work_series, work_auth, web_series_name, web_auth)
                sleep(0.02)
                n_count = n_count + 1
            del tmp_rows
    log("Number of Historically Cumulative Web Source Records Matching Current List of Work Series Names: " + as_unicode(n_count))
    mysql = 'INSERT OR REPLACE INTO _web_author_series SELECT * FROM _global_web_author_series'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    mysql = 'INSERT OR REPLACE INTO _web_series_detail SELECT * FROM _global_web_series_detail'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    log(" ")
    log("All Historically Cumulative Web Source Records from All Q&S Libraries are Available for Use in Renaming in This Q&S Library.")
    log(" ")
def miscellaneous_scrubbing_5_fetch_series(my_db,my_cursor,log,tmp_books_list):
    tmp_series_list = []
    tmp_rows_save = []
    tmp_rows = []
    for row in tmp_books_list:
        my_book = int(row)
        mysql = 'SELECT authname,seriesname FROM __books_work_populate  WHERE seriesname NOT NULL AND book = ?  ;'
        sleep(0.01)
        tmp_rows = execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=my_book,v2=None)
        if not tmp_rows:
            tmp_rows = []
        else:
            for item in tmp_rows:
                tmp_rows_save.append(item)
        del tmp_rows
    if not tmp_rows_save:
        return tmp_series_list
    tmp_rows_save_set = set(tmp_rows_save)
    tmp_rows_save = list(tmp_rows_save_set) 
    n = len(tmp_rows_save)
    log("Number of Unique Series Selected: " + as_unicode(n))
    if n == 0:
        return tmp_series_list
    for row in tmp_rows_save:
        authname, seriesname = row
        auth_list = authname.split(" ")
        n = len(auth_list)
        if n == 0:
            pass
        else:
            if n == 1:
                pass
            else:
                if n == 2:
                    pass
                else:
                    if n == 3:
                        authname = auth_list[0] + " " + auth_list[2]
                    else:
                        pass
        s = authname + "||@||" + seriesname
        tmp_series_list.append( s)
    tmp_series_list.sort()
    return tmp_series_list
def miscellaneous_scrubbing_5_fetch_all_books_with_series(my_db,my_cursor,log):
    tmp_books_list = []
    mysql = 'SELECT id,NULL FROM custom_column_10 ;'
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            book,dummy = row
            tmp_books_list.append(book)
    return  tmp_books_list
def update_work_columns_for_utf8_display(my_db,my_cursor,my_current_book,notifications,log):
    sleep(0.04)
    mysql = 'UPDATE custom_column_4 SET value = (update_utf8_for_display(value) ) WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  )'
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
    mysql = 'UPDATE custom_column_8 SET value = (update_utf8_for_display(value) ) WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ?  )'
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
    mysql = 'UPDATE custom_column_10 SET value = (update_utf8_for_display(value) ) WHERE  custom_column_10.id IN \
                                (SELECT value FROM books_custom_column_10_link WHERE book = ?  )'
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
    mysql = 'UPDATE custom_column_13 SET value = (update_utf8_for_display(value) ) WHERE  custom_column_13.id IN \
                                (SELECT value FROM books_custom_column_13_link WHERE book = ?  )'
    execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=my_current_book)
    sleep(0.03)
def titlecase_authors(my_db,my_cursor,notifications,log):
    sleep(.1)
    rows = list(my_cursor.execute("SELECT id,value FROM custom_column_4") )
    mysql = "UPDATE custom_column_4 SET value = ? WHERE id = ?"
    my_cursor.execute("begin")
    for row in rows:
        id,value = row
        value = titlecase(value)
        value = value.strip()
        my_cursor.execute(mysql,(value,id))
    my_cursor.execute("commit")
    log("Work Authors title-cased: " +as_unicode(len(rows)) )
    sleep(0)
def execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None):
    sleep(0.1)
    if v1 == 'null':
        v1 = None
    try:
        if v1 is None:
            my_cursor.execute(mysql)
        else:
            my_cursor.execute(mysql,([v1]))
        tmp_rows = my_cursor.fetchall()
        if tmp_rows:
            return tmp_rows
        else:
            tmp_rows = []
            return tmp_rows
    except Exception as e:
        log("v1: " + as_unicode(v1))
        log(as_unicode(e))
        my_db.close()
        raise e
def execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=None,v2=None):
    sleep(0.03)
    tmp_rows = []
    if v1 is None:
        return tmp_rows
    v2_was_null = False
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2_was_null = True
        v2 = None
    try:
        if v2 is None and not v2_was_null:
            my_cursor.execute(mysql,([v1]))
        else:
            my_cursor.execute(mysql,(v1,v2))
        tmp_rows = my_cursor.fetchall()
        if tmp_rows:
            return tmp_rows
        else:
            tmp_rows = []
            return tmp_rows
    except Exception as e:
        log("execute_mysql_fetchall_complex_generic ", as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
def execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql):
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.03)
def execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    s1 = ""
    if v1 == None:
        s1 = "IGNORE"
    if v1 == 'null':
        v1 = None
    try:
        my_cursor.execute("begin")
        if s1 == "IGNORE":
            my_cursor.execute(mysql)
        else:
            my_cursor.execute(mysql,([v1]))
        my_cursor.execute("commit")
    except Exception as e:
        e = as_unicode(e)
        log("execute_mysql_for_custom_column_generic_1_arg: " + e )
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.03)
def execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,v1=None,v2=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    s2 = ""
    if v2 == "" or v2 is None:     
        s2 = "IGNORE"
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2 = None
    try:
        my_cursor.execute("begin")
        if s2 != "IGNORE":
            my_cursor.execute(mysql,(v1,v2))
        else:
            my_cursor.execute(mysql,([v1]))
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic_2_arg: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.03)
def execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql,v1=None,v2=None,v3=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2 = None
    if v3 == 'null':
        v3 = None
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(v1,v2,v3))
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic_3_arg: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.03)
def execute_mysql_for_custom_column_generic_4_args(my_db,my_cursor,log,mysql,v1=None,v2=None,v3=None,v4=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2 = None
    if v3 == 'null':
        v3 = None
    if v4 == 'null':
        v4 = None
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(v1,v2,v3,v4))
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic_4_arg: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.03)
