#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import os
from xml.sax.saxutils import escape
from htmllangtextparser import HTMLLangTextParser
from textwordparser import getSpellingSafeText, parse_text_into_words
from pluginhunspellml import HunspellMLChecker

_SEP_ = '|'
_MAXSUGGEST = 5

def run(bk):
    ''' main routine '''

    if bk.launcher_version() <  20200804:
        print("This plugin requires Sigil 1.4.0 or later to operate")
        return 0
    
    loaded_dicts = {}

    # get Hunspell dictionary folders
    dic_dirs = bk.get_dictionary_dirs();

    # get default spellcheck lang
    default_language = bk.sigil_spellcheck_lang.replace("_","-")

    # load the hunspell spellchecker library
    hsp = HunspellMLChecker(bk.get_hunspell_library_path())
    # hsp = HunspellMLChecker(bk._w.get_hunspell_path())
    
    # load preferences
    prefs = bk.getPrefs()

    # enumerate dictionaries
    if prefs == {}:
        # search dictionary folders for aff files
        for dic_dir in dic_dirs:
            for aff_file in list(filter(lambda x: x.endswith('.aff'), os.listdir(dic_dir))):
                dic_basename = aff_file[:aff_file.index('.')]
                dic_path = os.path.join(dic_dir, aff_file[:aff_file.index('.')])

                # make sure that the dic file exists,too
                if os.path.exists(dic_path + '.dic'):
                    if dic_basename.replace('_', '-') not in dic_dirs:
                        prefs[dic_basename.replace('_', '-')] = dic_path

                        # add base language path as fallback. e.g. en-US => en
                        if len(dic_basename) > 3:
                            prefs[dic_basename[:2]] = dic_path
        bk.savePrefs(prefs)

    # select files to be processed
    selected_files = []
    for file_name in list(bk.selected_iter()):
        if bk.id_to_mime(file_name[1]) == 'application/xhtml+xml':
            selected_files.append((file_name[1], bk.id_to_href(file_name[1]))) 

    if selected_files != []:
        file_list = selected_files
    else:
        file_list = list(bk.text_iter())

    # process file list
    for (man_id, href) in file_list:

        bookpath = bk.id_to_bookpath(man_id)
        print('Processing ', bookpath, '...')
        data = bk.readfile(man_id)
        p = HTMLLangTextParser(default_language, data)
        for soffset, lang, text in p.langtext_iter():
            if text.strip() != "":
                # load any required dictionaries if not already loaded
                if lang not in loaded_dicts:
                    if lang not in prefs:
                        # display missing dictionary warning if needed
                        message = 'Language code [' + lang + ']: Dictionary not found.'
                        bk.add_extended_result('warning', escape(bookpath), 1, 0, message)
                    else:
                        # load spellcheck files
                        aff_file = prefs[lang] + '.aff'
                        dic_file = prefs[lang] + '.dic'
                        dickey = hsp.loadDictionary(aff_file, dic_file)
                        loaded_dicts[lang] = dickey
                dickey = loaded_dicts.get(lang, None)
                if dickey:
                    wcs = hsp.get_wordchars(dickey)
                    wordlist = parse_text_into_words(wcs, True, lang, text, soffset)
                    for entry in wordlist:
                        woffset, code, word = entry.split('|')
                        correct = hsp.check(dickey, getSpellingSafeText(word))
                        if not correct:
                            # get suggestions
                            suggests = hsp.suggest(dickey, getSpellingSafeText(word))
                            if len(suggests) > _MAXSUGGEST:
                                suggests = suggests[0:_MAXSUGGEST]
                            message = 'Language code [' + code + ']: Spelling error? ' +  word + ' => ' + ', '.join(suggests)
                            bk.add_extended_result('warning', escape(bookpath), -1, woffset, message)
                                        
    # close all dictionaries and clean up
    for code in loaded_dicts.keys():
        dickey = loaded_dicts[code]
        hsp.cleanUp(dickey)
    return 0


def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
