#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys
from time import sleep
from cutils import show_msgbox 
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 


if sys.platform == 'linux' or \
    sys.platform == 'darwin':
    options.LINUX_MACHINE = True

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
class SelectDialog(Tk):

    def __init__(self, bk):
        super().__init__()
        self.bk = bk
        self.resizable(width=True, height=True)
        self.minsize(500, 150)
        self.maxsize(800, 700)
        self.title('StylePropertiesCleanup')
        centeredWindow(self, 538, 280)
        self.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
        
    def setup_UI(self):
    
        self.mainframe = Frame(self)
        self.mainframe.pack(side=TOP, fill=BOTH, expand=True)
        
        self.InfoLabel = Label(self.mainframe, text=" ",
                        fg     = '#0000FF',
                        font    =('Helvetica', '11'),                         
                        anchor = E
                        )     
        self.InfoLabel.grid(column=1, sticky=W, row=0, padx=370, pady=10)       
        
       #**** create the entry text *****#                
        self.InfoLabel2 = Label(self.mainframe, text="Type style property name(s):",
                        font   = ('Helvetica', '11'),                      
                        anchor = E
                        )
        self.InfoLabel2.grid(column=1, row=1, sticky=W, padx=30)
 
        #**** create the entry textbox *****#                
        self.textbox = StringVar()
        self.EntrySelect = Entry(self.mainframe, 
                        width  = 40,
                 textvariable  = self.textbox                       
                        )
        self.EntrySelect.grid(column=1, row=1, sticky=W, pady=15, padx=233)
        self.EntrySelect.focus()
        
        #**** create the checkbuttons *****#
        self.CSS = tk.BooleanVar()   
        self.chkbCSS = Checkbutton(self.mainframe,        
                        text    = "Remove style properties from epub CSS only",
                        font    = ('Helvetica', '11'),
                       offvalue = False, 
                       onvalue  = True,
                     variable   = self.CSS                      
                        )
        self.chkbCSS.grid(row=2, column=1, sticky=W, padx=75, pady=5)            
                        
        
        self.HTML = tk.BooleanVar()           
        self.chkbHTML = Checkbutton(self.mainframe, 
                        text    = "Remove style properties from epub HTML only",  
                         font   = ('Helvetica', '11'),
                       offvalue = False, 
                       onvalue  = True,                                       
                     variable   = self.HTML
                        )
        self.chkbHTML.grid(row=3, column=1, sticky=W, padx=75, pady=5)           

        self.ImpHTML = tk.BooleanVar()           
        self.chkbImpHTML = Checkbutton(self.mainframe, 
                        text    = "Remove style properties from Imported HTML only",  
                         font   = ('Helvetica', '11'),
                       offvalue = False, 
                       onvalue  = True,                                       
                     variable   = self.ImpHTML
                        )
        self.chkbImpHTML.grid(row=4, column=1, sticky=W, padx=75, pady=5)                   
                   
        #**** create blank space text *****#                
        self.Label1 = Label(self.mainframe, text=" ").grid()
 
        #**** create the OK button *****#
        self.frame1 = Frame(self).pack(side=TOP)   
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', '11'), background='#E0E0E0', width=20, relief=GROOVE) 
        self.okButton = ttk.Button(self.frame1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        )
        self.okButton.pack()     
        
        #**** create the status bar *****#
        self.frame1 = Frame(self).pack(side=TOP)    
        self.status = Label(self.frame1, text=" ",
                        font   =('Helvetica', '11'),
                        relief = FLAT,
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.pack(side=LEFT, pady=10, padx=5) 
        
        # adjust window layout for Linux
        if options.LINUX_MACHINE == True:
            centeredWindow(self, 480, 280)
            self.InfoLabel.grid(padx=333)   
            self.InfoLabel2.grid(padx=60)
            self.EntrySelect.config(width=20)
            self.EntrySelect.grid(padx=268)
            self.chkbCSS.grid(pady=5)                  
            
        if options.FILE_TYPE == 'HTML':
            self.chkbCSS.config(state='disabled')
            self.chkbHTML.config(state='disabled')
            self.ImpHTML.set(True)
            self.InfoLabel.config(text="Input File: HTML  ")
        else:
            self.chkbImpHTML.config(state='disabled')
            self.InfoLabel.config(text="Input File: EPUB  ")          
            
        self.grab_set()
            
    def onOK(self):
    
        if self.textbox.get() == '' or self.textbox.get() == None:
            msg = 'No style properties were entered in the textbox.\n\nPlease try again.'
            title = 'Error'
            show_msgbox(title, msg, msgtype='error')
            options.TEXTBOX_ENTRY = False
            options.SYS_EXIT = True
        elif not (self.CSS.get() == True or self.HTML.get() == True or self.ImpHTML.get() == True):
            msg = 'No actions were selected from the checkboxes.\n\nPlease try again.'
            title = 'Error'
            show_msgbox(title, msg, msgtype='error')
            options.CHECKBOX_ENTRY = False
            options.SYS_EXIT = True
            
        options.STYLE_PROPERTY_STR = self.textbox.get()
        options.RUN_removeStylePropertyEpubCSS = self.CSS.get()
        options.RUN_removeStylePropertyEpubHTML = self.HTML.get()
        options.RUN_removeStylePropertyImpHTML = self.ImpHTML.get()

        print('>>> textbox set to ...' + self.textbox.get())
        ('>>> In dialog: RUN_removeStylePropertyEpubCSS set to...' + str(options.RUN_removeStylePropertyEpubCSS))        
        ('>>> In dialog: RUN_removeStylePropertyEpubHTML set to...' + str(options.RUN_removeStylePropertyEpubHTML))
        ('>>> In dialog: RUN_removeStylePropertyImpHTML set to...' + str(options.RUN_removeStylePropertyImpHTML))                
    
        self.destroy() 
        self.quit()
            
     
    def onCancel(self):
        options.SYS_EXIT = True
        self.destroy()  
        return(0)
  
