#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys, codecs, shutil, inspect, re, time
from decimal import *
from PIL import Image
import options
import tkinter as tk
import tkinter.messagebox as mbox

__all__=["removeStylePropertyEpubCSS", "removeStylePropertyEpubHTML", "removeStylePropertyImpHTML", "checkStyles", "copyTextFiles2Dir", "copyCSSFiles2Dir", "writeFiles2CSS", "writeFiles2Epub", "cleanExit", "svgAttributes2CamelCase", "checkStyles", "fileNotLoadedError", "showResults"]

try:

    from sigil_bs4 import BeautifulSoup, Comment
except:
    from bs4 import BeautifulSoup, Comment  
    
    
def removeStylePropertyEpubCSS(wdir, s_fnames):
    """ Remove class property from epub CSS only
    """
    print(">>> In removeStylePropertyEpubCSS...")  
    print(">>> options.RUN_removeStylePropertyEpubCSS is..." + str(options.RUN_removeStylePropertyEpubCSS))
    
    if options.RUN_removeStylePropertyEpubCSS == False:
        return(0)        
    
    
    # preformat the stylesheets to standard input format
    for fname in s_fnames:
        fname = os.path.join(wdir, fname)
        output = os.path.join(wdir, 'char_space.html')
        outfp = open(output, 'wt', encoding='utf-8')
        with open(fname, 'rt', encoding='utf8') as infp:      
            for line in infp:
                # change from single line to stacked format
                if '{' in line and ':' in line and '}' in line:
                    line = line.replace('{', '{\n')
                    line = line.replace(';', ';\n')
                    line = line.replace('}\n', '\n}\n')
                outfp.write(line)    
    outfp.close()
    os.remove(fname)
    os.rename(output, fname)                  
    
    # get the selected properties string    
    property_str = options.STYLE_PROPERTY_STR
    property_str = property_str.strip()
    
    if ',' in property_str:
        # convert comma delimited string to string      
        property_str = property_str.replace(',', ',,')
        property_str = property_str.replace(' ', ',')
        property_str = property_str.replace(' ', '')
        property_str = property_str.replace(',', ' ')
        property_str = property_str.replace('  ', ' ')        
    else:
        # prepare space delimted string for conversion
        property_str = property_str.replace('  ',' ')
    
    # convert to list for easier handling     
    p_list = list(property_str.split())
    
    # add end colon to avoid any search problems
    property_list = []
    for item in p_list:
        property_list.append(item + ':')
        
    style_property = ''
    total_count = 0

    # remove selected style properties from all epub stylesheets
    for fname in s_fnames:
        fname = os.path.join(wdir, fname)    
        output = os.path.join(wdir, 'char_space.html')
        outfp = open(output, 'wt', encoding='utf-8')
        with open(fname, 'rt', encoding='utf8') as infp:      
            for line in infp:
                for style_property in property_list:
                    if line.strip().startswith(style_property):                        
                        line = ''
                        total_count += 1                                 
                outfp.write(line)
        options.REMOVED_PROPERTIES_COUNT = total_count        
        outfp.close()
        os.remove(fname)
        os.rename(output, fname)
        
    return(0)
    
def removeStylePropertyEpubHTML(wdir, t_fnames):
    """ Remove style property from epub html
        or imported html only
    """       
    print(">>> In removeStylePropertyHTML...")    
    print(">>> options.RUN_eemoveStylePropertyHTML is..." + str(options.RUN_removeStylePropertyEpubHTML))
    
    if options.RUN_removeStylePropertyEpubHTML == False:
        return(0)    
        
    print("Running removeStylePropertyHTML()...")        
    # get the style property    
    
    property_str = options.STYLE_PROPERTY_STR
    property_str = property_str.strip()
   
    if ',' in property_str:
        # prepare comma delimited string for conversion to list 
        property_str = property_str.strip()       
        property_str = property_str.replace(',', ',,')
        property_str = property_str.replace(' ', ',')
        property_str = property_str.replace(' ', '')
        property_str = property_str.replace(',', ' ')
        property_str = property_str.replace('  ', ' ')        
    else:
        # prepare space delimited string for conversion
        property_str = property_str.replace('  ',' ')
    
    #print(' >>> property_str after format...' + property_str)
    
    #convert to list for easier handling  
    property_list = list(property_str.split()) 

    #print(' >>> property_list...' + str(property_list))
    #time.sleep(200)
    
    style_property = ''     
    total_count = 0
    
    # globally remove the style properties from the html
    for file in t_fnames:
        file = os.path.join(wdir, file)
        outfile = os.path.join(wdir, 'remove_adhoc_stuff.xhtml')
        outfp = open(outfile, 'wt', encoding='utf-8')
        html = open(file, 'rt', encoding='utf-8').read()
        
        soup = BeautifulSoup(html, 'html.parser')

        count = 0
        for tag in soup.find_all(True):
            for style_property in property_list: 
                count = 0
                if tag.has_attr('style'):
                    # prepare the style string before the split
                    properties_str = str(tag['style'])
                    properties_str = properties_str.replace(' ','')
                    properties_str = properties_str.replace(';','; ')
                    properties_str = properties_str.strip()
                    if style_property.strip() in properties_str.strip():
                        properties_list = list(properties_str.split(" ")) 
                        for property in properties_list: 
                            if style_property.strip() in property.strip():
                                del properties_list[count]
                                total_count += 1                              
                                # reformat the style string for normal display                            
                                properties_s = ''.join(properties_list)
                                properties_s = properties_s.replace(':',': ')
                                properties_s = properties_s.replace(';','; ')
                                tag['style'] = properties_s
                                if tag['style'] == '' or None:
                                    del tag['style']    
                                    if '<span>' in str(tag):
                                        tag.unwrap()                                     
                            count += 1 
              
        options.REMOVED_PROPERTIES_COUNT = total_count
        print("total_count..." + str(total_count))
        outfp.writelines(str(soup))
        #outfp.writelines(str(soup.prettyprint_xhtml(indent_level=0, eventual_encoding="utf-8", formatter="minimal", indent_chars="  "))) 
        
        outfp.close()
        os.remove(file)
        os.rename(outfile, file)
        
        svgAttributes2CamelCase(wdir, file)    
        prettifyXHTMLFile(wdir, file)   
                                                  
    return(0)

def removeStylePropertyImpHTML(wdir, t_fnames):
    """ Remove style property from epub html
        or imported html only
    """       
    print(">>> In removeStylePropertyHTML...")    
    print(">>> options.RUN_eemoveStylePropertyHTML is..." + str(options.RUN_removeStylePropertyImpHTML))
    
    if options.RUN_removeStylePropertyImpHTML == False:
        return(0)    
        
    print("Running removeStylePropertyHTML()...")        
    # get the style property    
    
    property_str = options.STYLE_PROPERTY_STR
    property_str = property_str.strip()
   
    if ',' in property_str:
        # prepare comma delimited string for conversion to list 
        property_str = property_str.strip()       
        property_str = property_str.replace(',', ',,')
        property_str = property_str.replace(' ', ',')
        property_str = property_str.replace(' ', '')
        property_str = property_str.replace(',', ' ')
        property_str = property_str.replace('  ', ' ')        
    else:
        # prepare space delimited string for conversion
        property_str = property_str.replace('  ',' ')
    
    #print(' >>> property_str after format...' + property_str)
    
    #convert to list for easier handling  
    property_list = list(property_str.split()) 

    #print(' >>> property_list...' + str(property_list))
    #time.sleep(200)
    
    style_property = ''     
    total_count = 0
    
    # globally remove the style properties from the html
    for file in t_fnames:
        file = os.path.join(wdir, file)
        outfile = os.path.join(wdir, 'remove_adhoc_stuff.xhtml')
        outfp = open(outfile, 'wt', encoding='utf-8')
        html = open(file, 'rt', encoding='utf-8').read()
        
        soup = BeautifulSoup(html, 'html.parser')
        
        count = 0
        for tag in soup.find_all(True):
            for style_property in property_list: 
                count = 0
                if tag.has_attr('style'):
                    # prepare the style string before the split
                    properties_str = str(tag['style'])
                    properties_str = properties_str.replace(' ','')
                    properties_str = properties_str.replace(';','; ')
                    properties_str = properties_str.strip()
                    if style_property.strip() in properties_str.strip():
                        properties_list = list(properties_str.split(" ")) 
                        for property in properties_list: 
                            if style_property.strip() in property.strip():
                                del properties_list[count]
                                total_count += 1                              
                                # reformat the style string for normal display                            
                                properties_s = ''.join(properties_list)
                                properties_s = properties_s.replace(':',': ')
                                properties_s = properties_s.replace(';','; ')
                                tag['style'] = properties_s
                                if tag['style'] == '' or None:
                                    del tag['style']    
                                    if '<span>' in str(tag):
                                        tag.unwrap()                                     
                            count += 1 
              
        options.REMOVED_PROPERTIES_COUNT = total_count
        print("total_count..." + str(total_count))
        outfp.writelines(str(soup))
        #outfp.writelines(str(soup.prettyprint_xhtml(indent_level=0, eventual_encoding="utf-8", formatter="minimal", indent_chars="  "))) 
        
        outfp.close()
        os.remove(file)
        os.rename(outfile, file)
        
        svgAttributes2CamelCase(wdir, file)    
        prettifyXHTMLFile2(wdir, file)   
                                                  
    return(0)
    
def checkStyles(wdir, fnames):
    #  check if the input file is an HTML file
    file = os.path.join(wdir, fnames[0])
    with open(file, 'rt', encoding='utf-8') as fp:       
        for line in fp: 
            if '<style>' in line or '<style type="text/css">'in line:          
                options.HTML_STYLES = True
                break                 
    return(0)    
    
def copyTextFiles2Dir(bk, wdir):
    t_ids = list()
    t_hrefs = list()
    t_fnames = list()
    
    for (id, href) in bk.text_iter():
        t_ids.append(id)
        t_hrefs.append(href)
        t_fnames.append(os.path.basename(href))
    
    # copy all xhtml files to the working dir    
    file = str()
    t_fnames_r = list()
    t_ids_r = list()
    i = 0      
    for id in t_ids:
        file = os.path.join(wdir, t_fnames[i])
        if 'cover.xhtml' in file or \
            'cover.html' in file or \
            'cover.htm' in file:
            i = i + 1
            continue    
        
        print(' -- Copy to work dir...' + t_fnames[i])
        with open(file, 'wt', encoding='utf-8') as outfp:
            data = bk.readfile(id)
            html = BeautifulSoup(data, 'html.parser')
            t_fnames_r.append(t_fnames[i])
            t_ids_r.append(id)
            outfp.write(str(html))
            i = i + 1
    
    return(t_ids_r, t_fnames_r) 
                
def copyCSSFiles2Dir(bk, wdir):
    s_ids = list()
    s_hrefs = list()
    s_fnames = list()
    for (i, h) in bk.css_iter():
        s_ids.append(i)
        s_hrefs.append(h)
        s_fnames.append(os.path.basename(h))
        
    j = 0    
    for sid in s_ids:
        file = os.path.join(wdir, s_fnames[j])
        print(' -- Write to work dir...' + file)
        with open(file, 'wt', encoding='utf-8') as outfp: 
            data = bk.readfile(sid)
            html = BeautifulSoup(data, 'html.parser')
            outfp.write(str(html))                
            j = j + 1     
            
    return(s_ids, s_fnames) 
    
def writeFiles2CSS(bk, wdir, ids, s_fnames): 
    # no css files with imported html docs

    count = len(s_fnames)
    if count == 0: 
        return(0)
    
    i = 1
    print(' ')  
    
    i = 0
    print(' ')  
    for file in s_fnames:
        prettifyCSS(wdir, file)    
        print(' -- Write to epub CSS...' + str(file))        
        with open(os.path.join(wdir, file), 'rt', encoding='utf-8') as fp:              # input file is epub 
            data = fp.read()          
            bk.writefile(ids[i], data)
            i = i + 1
                        
    return(0)                  
    
def writeFiles2Epub(bk, wdir, ids, fnames):

    print(' >>> In writeFiles2Epub()...' )       
    for file in fnames:    
       print(file)    

    count = len(fnames)
    if count == 0: 
        return(0)
    
    i = 0
    print(' ')  
    for file in fnames:
        print(' -- Write files to epub...' + fnames[i])
        file = os.path.join(wdir, file)
        with open(file, 'rt', encoding='utf-8') as fp:
            data = fp.read()           
            bk.writefile(ids[i], data)
            i = i + 1
                            
    return(0)  
    
def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))
        
def cleanExit(wdir):
    shutil.rmtree(wdir, ignore_errors=True)
    return(0)    
        
def svgAttributes2CamelCase(wdir, file):
    
    file = os.path.join(wdir, file)
    file = os.path.join(wdir, os.path.basename(file))       
    output = os.path.join(wdir, 'reformat.html')
    outfp = open(output, 'wt', encoding='utf-8')
    html = open(file, 'rt', encoding='utf-8').read()

    soup = BeautifulSoup(html, 'html.parser')
    
    for svg in soup.find_all('svg'):
    
        # reformat the par to camel case
        if svg.has_attr('preserveaspectratio'):
            par = svg['preserveaspectratio']
            del svg['preserveaspectratio']
            svg['preserveAspectRatio'] = par
        
        # reformat the vb to camel case
        if svg.has_attr('viewbox'):
            vb = svg['viewbox']
            del svg['viewbox']
            svg['viewBox'] = vb
            
        if not svg.has_attr('xmlns:xlink'):
            svg['xmlns:xlink'] = "http://www.w3.org/1999/xlink"        
               
    outfp.writelines(str(soup.prettyprint_xhtml(indent_level=0, eventual_encoding="utf-8", formatter="minimal", indent_chars="  ")))
    outfp.close()
    os.remove(file)
    os.rename(output, file)        
    return(0)
    
def fileNotLoadedError(title, msgtype):
    msg = 'You have not loaded an epub or html file into Sigil.\n\n' + \
          'You must first load an epub or html file into Sigil and then run this plugin. Please try again.'
    
    print('\n >>> Warning!! You have not loaded an epub or html file into Sigil.')
    print(' >>> You must first load an epub or html file into Sigil and then run this plugin. Please try again.')    
          
    show_msgbox(title, msg, msgtype='error')
    
    return(0)       
   
def prettifyCSS(wdir, css):
    # ensure no blank lines in the css
    css = os.path.join(wdir, css)
    output = os.path.join(wdir, 'link_rel.html')
    outfp = open(output, 'wt', encoding='utf-8')
    with open(css, 'rt', encoding='utf8') as infp:      
        for line in infp:
            if line.strip() == '':
                continue                     
            outfp.write(line.strip() + '\n')                  
  
    outfp.close()
    os.remove(css)
    os.rename(output, css)
    
    output = os.path.join(wdir, 'remove_curly.html')
    outfp = open(output, 'wt', encoding='utf-8')
    with open(css, 'rt', encoding='utf8') as fp:  
        data = fp.read()
        if '\n}\n}\n' in data:
            data = data.replace('\n}\n}\n', '\n}\n')
            
    outfp.writelines(data)
    outfp.close()
    os.remove(css)
    os.rename(output, css)    
    return(0)    

def prettifyXHTMLFile(wdir, file):
    # reformat and prettify the XHTML file
    outfile= os.path.join(wdir, 'final_one.css')
    infp = open(file, 'rt', encoding='utf-8')
    outfp = open(outfile, 'wt', encoding='utf-8') 
    for line in infp:
        
        if line.strip().startswith('<?xml') or \
            line.strip().startswith('<!DOCTYPE') or \
            line.strip().startswith('<html') or \
            line.strip().startswith('<head>') or \
            line.strip().startswith('<meta')or \
            line.strip().startswith('<title>') or \
            line.strip().startswith('<link') or \
            line.strip().startswith('</head>') or \
            line.strip().startswith('<body') or \
            line.strip().startswith('<body>'):
            line = line.strip()
            if not line:
                continue
            if line.startswith('<meta') or \
                line.startswith('<title>') or \
                line.startswith('<link'):
                line = '  ' + line      
            if line.startswith('<body'):
                line = '\n' + line
            if line.startswith('</body>'):
                outfp.write('\n' + line.rstrip() + '\n')
            else:
                outfp.write(line.rstrip() + '\n')    
        else:
            line = line.strip()
            if not line or line == ';':
                continue            
            if line.startswith('<p') or line.startswith('<li'):
                line = '  ' + line            
            outfp.write('\n' + line + '\n')    
            
    infp.close()
    outfp.close()
    os.remove(file)
    os.rename(outfile, file)
    return(0)         
    
def prettifyXHTMLFile2(wdir, file):
    # reformat and prettify the imported HTML file
    outfile= os.path.join(wdir, 'final_one.css')
    infp = open(file, 'rt', encoding='utf-8')
    outfp = open(outfile, 'wt', encoding='utf-8') 
    for line in infp:
    
        if line.strip() == '':
            line = ''
            outfp.write(line)
            continue
        
        if '<?xml' in line:
            outfp.write(line)
            for line in infp:
                if '</head>' not in line:
                    if line.strip() == '' or '<![CDATA[' in line or ']]>' in line:
                        line = ''
                    elif line.strip().startswith('"http:'):
                        line = '  ' + line.strip() + '\n'
                    elif line.strip().startswith('<html'):
                        line = '\n' + line                    
                    elif '<style>' in line:
                        line = '<style type="text/css">\n'
                    outfp.write(line)                 
                else:
                    outfp.write(line)
                    break
            continue
        
        if line.strip().startswith('<?xml') or \
            line.strip().startswith('<!DOCTYPE') or \
            line.strip().startswith('<html') or \
            line.strip().startswith('<meta')or \
            line.strip().startswith('<title>') or \
            line.strip().startswith('<link') or \
            line.strip().startswith('</head>') or \
            line.strip().startswith('<body') or \
            line.strip().startswith('<body>'):
            line = line.strip()
            if not line:
                continue   
            if line.startswith('<meta') or \
                line.startswith('<title>') or \
                line.startswith('<link'):
                line = '  ' + line      
            if line.startswith('<body'):
                line = '\n' + line
            if line.startswith('</body>'):
                outfp.write('\n' + line.rstrip() + '\n')
            else:
                outfp.write(line.rstrip() + '\n')    
        else:
            line = line.strip()                
            if line.startswith('<p') or line.startswith('<li'):
                line = '  ' + line                 
            outfp.write('\n' + line + '\n')    
            
    infp.close()
    outfp.close()
    os.remove(file)
    os.rename(outfile, file)
    return(0)             

def showResults():
    msg = 'Plugin results:\n\nTotal style properties removed =  ' + str(options.REMOVED_PROPERTIES_COUNT) 
    title = 'Totals'
    show_msgbox(title, msg, msgtype='info')
    return(0)

