#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#


import os, os.path, sys, codecs, shutil, inspect, time
from tempfile import mkdtemp                  
from cutils import *
from cutils import show_msgbox
from updater import updateCheck
from dialogs import SelectDialog
import options
import tkinter as tk


SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=4002126&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
options.PLUGIN_PATH = PLUGIN_PATH


def is_connected():
    try:
        sock = socket.create_connection(('8.8.8.8', 53), 1)
        sock.close()
        return True
    except:
        pass

    return False        
    
def run(bk):
    print('Python version: ', sys.version, '\n')
    print('Running StylePropertiesCleanup...\n')
    
    if is_connected: 
        #check for new plugin versions
        latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
        if latest_version and latest_version != installed_version:
            options.NEW_PLUGIN_VERSION = True
            options.MSG_NEW_VERSION_AVAILABLE = "A new plugin version is now available from MR - v" + latest_version     
    
    # create a working directory
    WDIR = mkdtemp()
    
    # copy the CSS, images and xhtml files to the work dir
    t_ids, t_fnames = copyTextFiles2Dir(bk, WDIR)           # copy epub text files
    s_ids, s_fnames = copyCSSFiles2Dir(bk, WDIR)            # copy epub css files
    
    # check the file type -- html or epub
    if len(t_fnames) == 1 and len(s_fnames) == 0:
        options.FILE_TYPE = 'HTML' 
        # check the a loaded html file is there
        if t_fnames[0] == 'Section0001.xhtml':
            fileNotLoadedError('File Not Loaded Warning', 'warning')
            cleanExit(WDIR)
            return(0)
    else:          
        options.FILE_TYPE = 'EPUB'
    
    # show the StylePropertiesCleanup dialog    
    win_dialog = SelectDialog(bk)
    win_dialog.mainloop()
    
    #if dialog 'Cancel' or exit 
    # is pressed then exit run()
    if options.SYS_EXIT == True:
       cleanExit(WDIR)
       return(0)     

    # process the user selected task
    removeStylePropertyEpubCSS(WDIR, s_fnames)                     # remove style property from epub stylesheets only
    removeStylePropertyEpubHTML(WDIR, t_fnames)                    # remove style property from epub html only
    removeStylePropertyImpHTML(WDIR, t_fnames)                        # remove style property from imported html only 
    #time.sleep(300)
    
    if options.SYS_EXIT == True:
       cleanExit(WDIR)
       return(0)     
    
    # write the modified files back to the epub
    writeFiles2Epub(bk, WDIR, t_ids, t_fnames)
    writeFiles2CSS(bk, WDIR, s_ids, s_fnames)
    
    # Report total no. properties removed
    showResults()
    
    # inform user if new plugin version is available
    if options.NEW_PLUGIN_VERSION == True:
        msg = options.MSG_NEW_VERSION_AVAILABLE
        show_msgbox('StylePropertiesCleanup', msg, msgtype='info') 
        
    
    print('\n -- Completed SUCCESSFULLY...')
    cleanExit(WDIR)
    return(0)                
    
def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())                         