#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys, shutil
import options
import time
import html
import tkinter as tk
import tkinter.messagebox as mbox

try:
    from sigil_bs4 import BeautifulSoup, Comment, Tag
except:
    from bs4 import BeautifulSoup, Comment, Tag
    
    
def processAllTasks(bk, wdir):
  
    # get all the heading names from the NCX file    
    ncx_heading_names  = getNCXHeadings(bk, wdir)
    cover_file_name = ''
    title_file_name = ''
    print('>>> ncx heading names ...' + str(ncx_heading_names).lower() + '\n\n')
    
    # get each xhtml file and process it
    k = 0  
    for (id, href) in bk.text_iter():
        html = bk.readfile(id)
        soup = BeautifulSoup(html, 'html.parser')
        
        #-------------------------------------------------------------#    
        # add ncx heading names to all html heading title attr values #
        #-------------------------------------------------------------#
        
        search = ['p','h1','h2']     
        for tag in soup.find_all(search, limit=1):
            
            # find h1 tags with heading text
            if 'h1' in str(tag) and tag.get_text():
                if 'span' in str(tag):
                    tag_string = getSpanStrings(str(tag))
                else:
                    tag_string = tag.get_text()      
                for i, heading in enumerate(ncx_heading_names):
                    if tag_string.lower() in heading.lower():
                        tag['title'] = ncx_heading_names[i]                        
            
            # if h1 doesn't have a text heading just add title=''
            if 'h1' in str(tag) and (tag.get_text() == '' or \
                tag.get_text() == None or tag.get_text() == ' '):
                    tag['title'] = ''
            
        bk.writefile(id, str(soup.prettyprint_xhtml(indent_level=0, eventual_encoding="utf-8", formatter="minimal", indent_chars="  ")))
  
    # get the relevant ids and file names
    ids = []
    fnames = []
    for (id, href) in bk.text_iter():
        ids.append(id)
        fnames.append(os.path.join(wdir, os.path.basename(href)))
    
    id2 = ''    
    # get each xhtml file and copy to work dir
    for i, id2 in enumerate(ids):
        with open(fnames[i], 'wt', encoding='utf-8') as outfp:
            data = bk.readfile(id2)
            html = BeautifulSoup(data, 'html.parser')
            outfp.write(str(html))
            
    # this is a frig because there's just no way of
    # searching for p tags headings that contain 
    # no text so I've had to hard code it using 
    # the epub filename or file position instead 
    # - there's just no other way. Ugh!    
    for j, file in enumerate(fnames):
        if j < 2:       
            output = os.path.join(wdir, 'lastone.xhtml')
            outfp = open(output, 'wt', encoding='utf-8')
            with open(file, 'rt', encoding='utf-8') as infp:
                for line in infp:
                    if '<body' in line:
                        line = line + '\n\n<![CDATA[ NCX heading = "' + ncx_heading_names[j]  + '"]]>\n\n'                    
                    outfp.write(line)
            outfp.close()
            os.remove(file)
            os.rename(output, file)
            continue
            
        if os.path.basename(file) == "carte.xhtml":        
            output = os.path.join(wdir, 'lastone2.xhtml')
            outfp = open(output, 'wt', encoding='utf-8')
            with open(file, 'rt', encoding='utf-8') as infp:
                for line in infp:
                    if '<body' in line:
                        line = line + '\n\n<![CDATA[ NCX heading = "' + ncx_heading_names[j]  + '"]]>\n\n'                    
                    outfp.write(line)
            outfp.close()
            os.remove(file)
            os.rename(output, file)
            continue
            
          
    #--------------------------------------#    
    # finally prettify the epub html files #
    #--------------------------------------#        
      
    # prettify the file and write it back to epub
    for i, file in enumerate(fnames):
        prettifyXHTMLFile(wdir, file) 
        with open(file, 'rt', encoding='utf-8') as fp:
            data = fp.read()
            html = BeautifulSoup(data, 'html.parser')             
            bk.writefile(ids[i], str(html))
 
    #time.sleep(200)
    return(0)

def getNCXHeadings(bk, wdir):
    ncx_heading_list = []
    
    outfile = os.path.join(wdir, 'ncx.test')
    with open(outfile, 'wt', encoding='utf-8') as outfp:
        data = bk.readfile(bk.gettocid())
        soup = BeautifulSoup(data, 'xml')
        for tag in soup.navMap.find_all('text'):
            ncx_heading_list.append(str(tag.get_text()).strip())  
        outfp.write(str(soup))          
    
    return(ncx_heading_list)    
    
def prettifyXHTMLFile(wdir, file):
    # reformat and prettify the XHTML file
    outfile= os.path.join(wdir, 'final_one.css')
    infp = open(file, 'rt', encoding='utf-8')
    outfp = open(outfile, 'wt', encoding='utf-8') 
    for line in infp:
        
        if line.strip().startswith('<?xml') or \
            line.strip().startswith('<!DOCTYPE') or \
            line.strip().startswith('<html') or \
            line.strip().startswith('<head>') or \
            line.strip().startswith('<meta')or \
            line.strip().startswith('<title>') or \
            line.strip().startswith('<link') or \
            line.strip().startswith('</head>') or \
            line.strip().startswith('<body') or \
            line.strip().startswith('<body>'):
            line = line.strip()
            if not line:
                continue
            if line.startswith('<meta') or \
                line.startswith('<title>') or \
                line.startswith('<link'):
                line = '  ' + line      
            if line.startswith('<body'):
                line = '\n' + line
            if line.startswith('</body>'):
                outfp.write('\n' + line.rstrip() + '\n')
            else:
                outfp.write(line.rstrip() + '\n')    
        else:
            line = line.strip()
            if not line or line == ';':
                continue            
            if line.startswith('<p') or line.startswith('<li'):
                line = '  ' + line            
            outfp.write('\n' + line + '\n')    
            
    infp.close()
    outfp.close()
    os.remove(file)
    os.rename(outfile, file)
    return(0)         
    
def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))    
        
def cleanExit(wdir):
    """ Clean up and remove all work directories and files """
    shutil.rmtree(wdir, ignore_errors=True)
    return(0)   
    
def svgAttributes2CamelCase(wdir, file):
    
    file = os.path.join(wdir, file)
    file = os.path.join(wdir, os.path.basename(file))       
    output = os.path.join(wdir, 'reformat.html')
    outfp = open(output, 'wt', encoding='utf-8')
    html = open(file, 'rt', encoding='utf-8').read()

    soup = BeautifulSoup(html, 'html.parser')
    
    for svg in soup.find_all('svg'):
    
        # reformat the par to camel case
        if svg.has_attr('preserveaspectratio'):
            par = svg['preserveaspectratio']
            del svg['preserveaspectratio']
            svg['preserveAspectRatio'] = par
        
        # reformat the vb to camel case
        if svg.has_attr('viewbox'):
            vb = svg['viewbox']
            del svg['viewbox']
            svg['viewBox'] = vb
               
    outfp.writelines(str(soup.prettyprint_xhtml(indent_level=0, eventual_encoding="utf-8", formatter="minimal", indent_chars="  ")))
    outfp.close()
    os.remove(file)
    os.rename(output, file)        
    return(0)        
 
def getSpanStrings(html): 
    span_strings = ''
    soup = BeautifulSoup(html, 'html.parser')
    for span in soup.find_all('span'):
        span_strings = span_strings + str(span.get_text())
    return(span_strings)        
    
    

