/*
	This is a small example how to use chm library. 
	(C) Mikhail Kostousov <mikhail.kostousov@gmail.com>


    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/


#ifdef QTOPIA
#include <qtopia/qpeapplication.h>
#else
#include <qapplication.h>
#endif

#include <qregexp.h>
#include <sys/stat.h>

#include "chmfile.h"

int main(int argv,char **argc)
{	
	QString chmFileName;
	QString dir="./";
	int i=0;
	while(i<argv)
	{
		if ((QString(argc[i])=="-f")&& i+1 < argv)
		{
			chmFileName=argc[++i];
		}else if ((QString(argc[i])=="-d")&& i+1 < argv)
		{
			dir=argc[++i];
		}else if (QString(argc[i])=="-h")
		{
		    printf("usage:\n %s -f <filename> [-d direcotoryName]\n",argc[0]);
		    return 0;
		}
		i++;

	}
	if (!dir.contains(QRegExp("/$"))) dir+="/";
	mkdir(dir.latin1(),0777);
	ChmDirectoryMap chmDirectoryMap;
	QByteArray byteArray;
	Chm chm;
	chm.read(chmFileName,chmDirectoryMap,byteArray);	//open and decompress chm file
	char *buf=byteArray.data();				//get byte buf

	for (ChmDirectoryMap::Iterator it=chmDirectoryMap.begin();it!=chmDirectoryMap.end();it++)	//Follow entry by entry whole book
	{

		QString fileName=it.key();
		if ((!fileName.contains(QRegExp("/(#|\\$)")))&& (fileName.contains(QRegExp("^/"))))	//if entry is a regular file or directory
		{
			QString dirName;
			if (fileName.contains(QRegExp("^/[^/]+/")))					//if entry is a directory
			{
				int dirIndex=1;
				int i=dirIndex;
				while (i>0)								//we create recursive directories
				{
					dirIndex=i;
					i=fileName.find("/",dirIndex+1);
					mkdir((dir+fileName.mid(1,dirIndex-1)).latin1(),0777);		//it's not so good, we need to check is the directory 
													//exists or not

				}
			}
			if (fileName.contains(QRegExp("[^/]$")))					//if entry is a file
			{       
				printf("%s\n",fileName.latin1());
				FILE *f=fopen((dir+fileName.right(fileName.length()-1)).latin1(),"wb");	//we create file
				fwrite(buf+it.data().offset,1,it.data().length,f);			//put data from buffer
				fclose(f);								
			}
		}
	}
	return 0;	

}
