#
#	This program converets chm file to pdf
#	(C) Mikhail Kostousov <mikhail.kostousov@gmail.com>
#
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Library General Public License for more details.
#
#    You should have received a copy of the GNU Library General Public License
#    along with this library; see the file COPYING.LIB.  If not, write to
#    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#    Boston, MA 02111-1307, USA.
#


#!/bin/bash

CHM_FILE=$1
BASE_NAME=`basename "$CHM_FILE" .chm`
DIR=/tmp/$BASE_NAME


### for iLiad
HTMLDOC_ATTR="--webpage --fontsize 10 --size 12x15cm --left 2mm --right 2mm --bottom 2mm --top 8mm --header ... --browserwidth 768 --no-overflow -t pdf"

### Usual A4
#HTMLDOC_ATTR="--webpage --fontsize 10 --size A4 --header ... --browserwidth 768 --no-overflow -t pdf"

chm2html -f  $CHM_FILE -d $DIR > /dev/null

downlink.pl $DIR/\@contents

FILE_LIST=`cat $DIR/\@contents | grep html | gawk '{ a = tolower($line) };  { print a } ' | sed -e 's/.*"\([^"]*html\)".*/\1/' `
PWD=`pwd`
OLDDIR=$PWD

for i in $FILE_LIST; do
downlink.pl $DIR/$i;
done

cd $DIR
htmldoc $FILE_LIST $HTMLDOC_ATTR  -f $OLDDIR/$BASE_NAME.pdf
cd $OLDDIR

rm -Rf $DIR
