#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2011, Kovid Goyal <kovid@kovidgoyal.net>'
__docformat__ = 'restructuredtext en'

from PyQt5.Qt import (QWidget, QGridLayout, QLabel, QComboBox, QCheckBox,
        QHBoxLayout, QVBoxLayout, QRadioButton, QSpinBox, QGroupBox)
    
from calibre.utils.config import JSONConfig

# This is where all preferences for this plugin will be stored
# Remember that this name (i.e. plugins/copy_cover_to_device) is also
# in a global namespace, so make it as unique as possible.
# You should always prefix your config file name with plugins/,
# so as to ensure you dont accidentally clobber a calibre config file
prefs = JSONConfig('plugins/copy_cover_to_device')

# Set defaults
prefs.defaults['screen_size'] = '600,800'
prefs.defaults['keep_aspect'] = False
prefs.defaults['multi_copy'] = False
prefs.defaults['overwrite_prev'] = True
prefs.defaults['kindle_restart'] = False
prefs.defaults['random'] = False

class ConfigWidget(QWidget):

    def __init__(self):
        QWidget.__init__(self)
        
        SCREEN_SIZES = ['600,800', '600,1024', '758,1024', '824,1200', '1072,1448']
        self.l = QVBoxLayout()
        self.setLayout(self.l)
        
        shapesizebox = QGroupBox('Size && shape of cover images:')
        grid = QGridLayout()
        sizelabel = QLabel('Device &screen-size (width, height):')
        grid.addWidget(sizelabel, 0, 0)
        
        self.screensizecombo = QComboBox()
        self.screensizecombo.addItems(SCREEN_SIZES)
        self.screensizecombo.setCurrentIndex(SCREEN_SIZES.index(prefs['screen_size']))
        grid.addWidget(self.screensizecombo, 0, 1)
        sizelabel.setBuddy(self.screensizecombo)

        self.keepaspectcheck = QCheckBox('&Keep aspect ratio when copying?')
        self.keepaspectcheck.setCheckable(True)
        grid.addWidget(self.keepaspectcheck, 1, 0)
        self.keepaspectcheck.setChecked(prefs['keep_aspect'])
        
        shapesizebox.setLayout(grid)
        self.l.addWidget(shapesizebox)
        
        self.multicopybox = QGroupBox('Allow copy/storage of &multiple covers?')
        self.multicopybox.setCheckable(True)
        self.multicopybox.setChecked(prefs['multi_copy'])
        
        mbox = QVBoxLayout()
        
        fhkbox = QGroupBox('&File housekeeping on device')
        rbox = QVBoxLayout()
        self.overwriteButton1 = QRadioButton("Remove old cover images before copying new")
        overwriteButton2 = QRadioButton("Add to existing cover images")
        self.overwriteButton1.setChecked(prefs['overwrite_prev'])
        overwriteButton2.setChecked(not self.overwriteButton1.isChecked())
        
        rbox.addWidget(self.overwriteButton1)
        rbox.addWidget(overwriteButton2)
        fhkbox.setLayout(rbox)
        
        mbox.addWidget(fhkbox)
        
        self.randomcheck = QCheckBox('Copy covers in random se&quence')
        self.randomcheck.setCheckable(True)
        self.randomcheck.setChecked(prefs['random'])
        mbox.addWidget(self.randomcheck)
        self.multicopybox.setLayout(mbox)
        self.l.addWidget(self.multicopybox)
        
        kindlebox = QGroupBox('Kindle with Custom Screensaver only')
        kbox = QVBoxLayout()
        self.kindle_restartcheck = QCheckBox('Auto &restart after disconnecting')
        self.kindle_restartcheck.setCheckable(True)
        self.kindle_restartcheck.setChecked(prefs['kindle_restart'])
        kbox.addWidget(self.kindle_restartcheck)
        kindlebox.setLayout(kbox)
        self.l.addWidget(kindlebox)
        self.l.addStretch()
        
    def save_settings(self):
        prefs['screen_size'] = self.screensizecombo.currentText()
        prefs['keep_aspect'] = self.keepaspectcheck.isChecked()
        prefs['multi_copy'] = self.multicopybox.isChecked()
        prefs['overwrite_prev'] = self.overwriteButton1.isChecked() \
                                or not self.multicopybox.isChecked()
        prefs['kindle_restart'] = self.kindle_restartcheck.isChecked()
        prefs['random'] = self.randomcheck.isChecked() and \
                          self.multicopybox.isChecked()
        