from calibre.customize.conversion import OutputFormatPlugin, OptionRecommendation
from calibre.ebooks.conversion.plugins.txt_output import TXTOutput, NEWLINE_TYPES



class MarkdownOutput(TXTOutput):
    name = "Markdown Output"
    author = "The_book"
    version = (1, 0, 3)
    file_type = "md"
    commit_name = "md_output"
    ui_data = {
        "newline_types": NEWLINE_TYPES,
    }

    options = {
        OptionRecommendation(
            name="newline",
            recommended_value="system",
            level=OptionRecommendation.LOW,
            short_switch="n",
            choices=NEWLINE_TYPES,
            help=_(
                "Type of newline to use. Options are %s. Default is 'system'. "
                "Use 'old_mac' for compatibility with Mac OS 9 and earlier. "
                "For macOS use 'unix'. 'system' will default to the newline "
                "type used by this OS."
            )
            % sorted(NEWLINE_TYPES),
        ),
        OptionRecommendation(
            name="txt_output_encoding",
            recommended_value="utf-8",
            level=OptionRecommendation.LOW,
            help=_(
                "Specify the character encoding of the output document. "
                "The default is utf-8."
            ),
        ),
        OptionRecommendation(
            name="inline_toc",
            recommended_value=False,
            level=OptionRecommendation.LOW,
            help=_("Add Table of Contents to beginning of the book."),
        ),
        OptionRecommendation(
            name="max_line_length",
            recommended_value=0,
            level=OptionRecommendation.LOW,
            help=_(
                "The maximum number of characters per line. This splits on "
                "the first space before the specified value. If no space is found "
                "the line will be broken at the space after and will exceed the "
                "specified value. Also, there is a minimum of 25 characters. "
                "Use 0 to disable line splitting."
            ),
        ),
        OptionRecommendation(
            name="force_max_line_length",
            recommended_value=False,
            level=OptionRecommendation.LOW,
            help=_(
                "Force splitting on the max-line-length value when no space "
                "is present. Also allows max-line-length to be below the minimum"
            ),
        ),
        OptionRecommendation(
            name="keep_links",
            recommended_value=True,
            level=OptionRecommendation.LOW,
            help=_("Do not remove links within the document. "),
        ),
        OptionRecommendation(
            name="keep_image_references",
            recommended_value=True,
            level=OptionRecommendation.LOW,
            help=_("Do not remove image references within the document. "),
        ),
    }

    def convert(self, oeb_book, output_path, input_plugin, opts, log):
        setattr(opts, "txt_output_formatting", "markdown")
        TXTOutput.convert(self, oeb_book, output_path, input_plugin, opts, log)
    def gui_configuration_widget(
        self, parent, get_option_by_name, get_option_help, db, book_id=None
    ):
        from calibre_plugins.markdown_output.ui import PluginWidget
        return PluginWidget(parent, get_option_by_name, get_option_help, db, book_id)