from calibre.gui2.convert.txt_output import PluginWidget as TXTPluginWidget
from calibre.gui2.convert.txt_output_ui import Ui_Form as TXTUIForm
from calibre.gui2.convert import Widget

option = (
    "newline",
    "max_line_length",
    "force_max_line_length",
    "inline_toc",
    "keep_links",
    "keep_image_references",
    "txt_output_encoding",
)


class PluginWidget(TXTPluginWidget, TXTUIForm):

    TITLE = _("Markdown output")
    HELP = _("Options specific to") + " Markdown " + _("output")
    COMMIT_NAME = "Markdown_output"
    # ICON = I('mimetypes/txt.png')

    def __init__(self, parent, get_option, get_help, db=None, book_id=None):
        Widget.__init__(self, parent, option)
        self.db, self.book_id = db, book_id
        for x in get_option('newline').option.choices:
            self.opt_newline.addItem(x)

        self.initialize_options(get_option, get_help, db, book_id)
