#!/usr/bin/env python
# -*- coding: utf-8 -*-

### From PrefsExampleSimple_v0.0.2
from __future__ import unicode_literals, division, absolute_import, print_function
#
import sys, os, re
import inspect # From PrefsExampleSimple_v0.0.2

from sigil_bs4 import BeautifulSoup
from sigil_bs4.builder._lxml import LXMLTreeBuilderForXML # From xmlsouptest
### From PrefsExampleSimple_v0.0.2 

SCRIPT_DIR = os.path.normpath(os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe()))))
PLUGIN_NAME = os.path.split(SCRIPT_DIR)[-1]
PLUG_DIR = os.path.dirname(SCRIPT_DIR)

prefs = {}
#
# protect editable string from mistype
def sanitize(string):
    string=string.replace(' ','')
    string=string.replace(',,',',')
    string=string.lower()
    return string

def run(bk):

    # protect against epub3 epubs being sent to plugin: from ePub3-itizer
    epubversion = "2.0"
    if bk.launcher_version() >= 20160102:
        epubversion = bk.epub_version()
    if epubversion.startswith("3"):
        print("Error: plugin requires a valid epub 2.0 ebook as input")
        return -1
    
    # # From PrefsExampleSimple_v0.0.2
    # global prefs
    
    # # Get preferences from json prefs  
    # prefs = bk.getPrefs()
    
    # # Or use defaults if json doesn't yet exist (first run, or file deleted)
    # prefs.defaults['CalibreCC'] = '#orpub,#ordate'
    # prefs.defaults['SourceTag'] = 'OCR,gutenberg,fadedpage'
    # prefs.defaults['SourceLink'] = 'OCR,www.gutenberg.org,www.fadedpage.com'
    
    # prefs['CalibreCC'] = sanitize(prefs['CalibreCC'])
    # prefs['SourceTag'] = sanitize(prefs['SourceTag'])
    # prefs['SourceLink'] = sanitize(prefs['SourceLink'])
    
    # # print the settings (either from last run or defaults if never run)
    # print ('Set Date of Creation from: ', prefs['CalibreCC'],' (in preferences) and delete Date')
    # print ('Set Source from <dc:subject>[...]</dc:subject> in ', prefs['SourceTag'], ' to: ', prefs['SourceLink'], ' (in preferences) and delete <dc:subject>[...]</dc:subject>')
    # print ('delete all <meta name="calibre:user_...".../>')
    # print ('\n')
    # #
    # To report:
    deleted=[]
    changed=[]
    skipped=[]
    
    # get the metadata in opf
    metadata = bk.getmetadataxml()
    ##### Uncomment either for the metada_soup to work
    # print(bk.getmetadataxml()) 
    print(metadata)
    ############
    metadata_soup = BeautifulSoup(bk.getmetadataxml(), 'lxml') # 'lxml', 'xml'
    print('soup= ',metadata_soup, '\n')
    # normalize author(s)
    dc_creators = metadata_soup.find('dc:creator', attrs={'opf:role':'aut'}) #
    print(dc_creators, 'should be list\n')
    try: # one author or several? 
        dc_creators[0][opf:role] # error for single
    except:
        dc_creators = [dc_creators] # catch
    for dc_creator in dc_creators:
        print(dc_creator, 'should be whole tag\n')
        print('old author: ', dc_creator.name, '\n')
        if ',' in dc_creator.string:
            authorSort = dc_creator.string
            authorNameL = authorSort.split(',') # Seems one must make a copy before proceeding
            print(authorNameL, ' authorSort')
            authorName = authorNameL[1] + ' ' + authorNameL[0] #, maxsplit=1
            print(authorName, ' authorName')
            dc_creator.string = authorName 
            changed = changed + [(dc_creator,authorName)]
        elif ',' in dc_creator.string:
            authorName = dc_creator.string
            print(authorName, ' authorName\n')
            authorNameL = authorName.rsplit(' ')
            authorSort = authorNameL[1] + ',' + authorNameL[0]
            print(authorSort, ' authorSort\n')
        else:
            authorName = dc_creator.string
            authorSort = dc_creator.string
        dc_creator['opf:file-as'] = authorSort
        changed = changed + [(dc_creator,'file:as' + authorSort)]
    print(changed)
    # source
    # dc_source = metadata_soup.find('dc:source')
    # if not dc_language:
        # dc_language = metadata_soup.new_tag('dc:source')
        # metadata_soup.metadata.append(dc_source)
    # dc_language.string = ''
    # new_metadata = metadata_soup.decodexml(indent_level=0, formatter='minimal', indent_chars="  ")
    # print(new_metadata)
    
    # bk.setmetadataxml(new_metadata)
    print('\nDone')
    
    
    return 0

def main():
    print("I reached main when I should not have")
    return -1
    
if __name__ == "__main__":
    sys.exit(main())