#!/usr/bin/env python
# -*- coding: utf-8 -*-

### From PrefsExampleSimple_v0.0.2
from __future__ import unicode_literals, division, absolute_import, print_function
#
import sys, os, re
import inspect # From PrefsExampleSimple_v0.0.2

from sigil_bs4 import BeautifulSoup 

### From PrefsExampleSimple_v0.0.2

SCRIPT_DIR = os.path.normpath(os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe()))))
PLUGIN_NAME = os.path.split(SCRIPT_DIR)[-1]
PLUG_DIR = os.path.dirname(SCRIPT_DIR)

# From https://www.mobileread.com/forums/showpost.php?p=3637451&postcount=262
from PyQt5.QtWidgets import QApplication, QMessageBox 

prefs = {}
#
# protect editable string from mistype
def sanitize(string):
    if string != (' '):
        string = string.replace(' ','')
        string = string.replace(',,',',')
        string = string.lower()
        lstring = string.split(',')
        ostring = sorted(lstring)[0]
        for s in sorted(lstring)[1:]: # list of comma-separated strings
            ostring = ostring + "," + s
        # MUST be list of words(=tag names) comma-separated strings & without spaces
        string = ostring.replace(' ','')
    else:
        string = ' ' # Avoid bk.savePrefs(prefs) deleting the "tags" entry?--general havoc
    return string

def set_mode():
    # # From https://www.mobileread.com/forums/showpost.php?p=3637451&postcount=262
    app = QApplication(sys.argv)

    msg = QMessageBox()
    msg.setWindowTitle("Set Mode")
    msg.setText("Only Report, No Changes?")
    msg.setStandardButtons(QMessageBox.Yes | QMessageBox.No)
    testmode = [0,1][msg.exec_()== QMessageBox.Yes]
    
    if testmode:
        print('\nOnly Report.')
    else:
        print('\nApply Changes.')
    
    return testmode


def run(bk):
    
    # From PrefsExampleSimple_v0.0.2
    global prefs
    deftags = 'a,b,blockquote,br,i,li,small,sub,sup'
    defmeta = True
    # Get preferences from json prefs  
    prefs = bk.getPrefs()
    
    # Or use defaults if json doesn't yet exist (first run, or file deleted)
    prefs.defaults['tags'] = deftags
    prefs.defaults['metas'] = defmeta
    
    prefs['tags'] = sanitize(prefs['tags'])
    
    # print the settings (either from last run or defaults if never run)
    print ('Delete calibre class from: ', prefs['tags'], '(in preferences)\nDelete metas: ', prefs['metas'], ' (in preferences)')
    print ('\n')
    #
    # To report:
    deletec=[]
    deletem=[]
    skip=[]
    testmode = set_mode() # Whether apply changes
    
    # get all html files
    for (html_id, href) in bk.text_iter():
        file_name = os.path.basename(href)
        html = bk.readfile(html_id)
        
        # convert html to soup
        soup = BeautifulSoup(html, 'html.parser')
        orig_html = str(soup)

        # get all tags in prefs['tags'] with class='*calibre*' (containing all those characters, in fact)
        ttags = prefs['tags'].split(',')
        tags = soup.find_all(ttags, class_=re.compile("calibre"))
        for tag in tags:
            theclass = tag['class'] # list under 'html.parser': can be multivalued
            if len(theclass) == 1: # not a multivalued class
            # update the report list?
                if not (tag.name, theclass) in deletec:
                    deletec = deletec + [(tag.name, theclass)]
                # remove class attribute 
                del tag['class']
            else:
            # update the report list?
                if not (tag.name, theclass) in skip:
                    skip = skip + [(tag.name, theclass)]
        
    # this clears the plug-in console: add at end
        if prefs['metas']:
            metas = soup.find_all('meta', attrs={'name': True})
            for meta in metas:
                # exclude 'calibre:cover', remove others
                if not 'cover' in meta['name']: # works here: string, and NOT for classes: list
                    # update the report list?
                    if not (meta.name, meta['name']) in deletem:
                        deletem = deletem + [(meta.name, meta['name'])] 
                    meta.decompose() # all previous print statements lost here
                else:
                    skip = skip + [(meta.name, meta['name'])]
        # update file with changes
        if str(soup) != orig_html and not testmode:
            bk.writefile(html_id, str(soup))
            print(file_name, 'updated')
    if testmode:
        print('TO DO')
    else:
        print('Done')

    # write a list of changes for checking
    print('Globally deleted classes: ', deletec,)
    print('Globally skipped: ', skip,)
    if prefs['metas']:
        print('Globally deleted metas: ', deletem,)

    # Save prefs to json
    prefs['metas'] = prefs['metas']
    bk.savePrefs(prefs)
    
    # Show where the json file gets written
    print ('\n')
    json_path = os.path.join(os.path.dirname(PLUG_DIR), 'plugins_prefs', PLUGIN_NAME, '{0}.json'.format(PLUGIN_NAME))
    print ('JSON file saved as:', json_path)
    print ('\n')
    print ('Clicking the "Open Preferences Location" button from Sigil\'s "Edit->Preferences" menu/dialog will get you most of the way there.')

    return 0

def main():
    print("I reached main when I should not have")
    return -1
    
if __name__ == "__main__":
    sys.exit(main())
