#!/usr/bin/env python
# -*- coding: utf-8 -*-

### From PrefsExampleSimple_v0.0.2
from __future__ import unicode_literals, division, absolute_import, print_function
#
import sys, os, re
import inspect # From PrefsExampleSimple_v0.0.2

from sigil_bs4 import BeautifulSoup
### From PrefsExampleSimple_v0.0.2
# # Only needed for open/select file From PrefsExampleSimple_v0.0.2
# import tkinter
# import tkinter.filedialog as tkinter_filedialog 

SCRIPT_DIR = os.path.normpath(os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe()))))
PLUGIN_NAME = os.path.split(SCRIPT_DIR)[-1]
PLUG_DIR = os.path.dirname(SCRIPT_DIR)

prefs = {}
#
# protect editable string from mistype
def sanitize(string):
    if len(string) > 0:
        string=string.replace(' ','')
        string=string.replace(',,',',')
        string=string.lower()
    else:
        string = ' ' # Avoid bk.savePrefs(prefs) deleting the "tags" entry?--general havoc
    return string

def run(bk):
    
    # From PrefsExampleSimple_v0.0.2
    global prefs
    deftags = 'i,b,small,sup,sub,br,a,li,blockquote'
    defmeta = True
    # Get preferences from json prefs  
    prefs = bk.getPrefs()
    
    # Or use defaults if json doesn't yet exist (first run, or file deleted)
    prefs.defaults['tags'] = deftags
    prefs.defaults['metas'] = defmeta
    
    prefs['tags'] = sanitize(prefs['tags'])
    
    # print the settings (either from last run or defaults if never run)
    print ('Delete calibre class from: ', prefs['tags'], 'Delete metas: ', prefs['metas'], ' (in preferences)')
    print ('\n')
    #
    # To report:
    deletec=[]
    deletem=[]
    skip=[]
    
    # get all html files
    for (html_id, href) in bk.text_iter():
        file_name = os.path.basename(href)
        html = bk.readfile(html_id)
        
        # convert html to soup
        soup = BeautifulSoup(html, 'html.parser')
        orig_html = str(soup)
        # get all tags in prefs['tags'] with class='*calibre*' (containing all those characters, in fact)
        ttags = [True,prefs['tags'].split(',')][len(prefs['tags']) > 0 or 0] # evaluates to 1|0 for tags|no tags
        tags = soup.find_all(ttags, class_=re.compile("calibre"))
        for tag in tags:
            theclass = tag['class'] # list under 'html.parser': can be multivalued
            if len(theclass) == 1: # not a multivalued class
            # update the report list?
                if not (tag.name, theclass) in deletec:
                    deletec = deletec + [(tag.name, theclass)]
                # remove class attribute 
                del tag['class']
            else:
            # update the report list?
                if not (tag.name, theclass) in skip:
                    skip = skip + [(tag.name, theclass)]
        
    # this clears the plug-in console: add at end
        if prefs['metas']:
            metas = soup.find_all('meta', attrs={'name': True})
            for meta in metas:
                # exclude 'calibre:cover', remove others
                if not 'cover' in meta['name']: # works here: string, and NOT for classes: list
                    # update the report list?
                    if not (meta.name, meta['name']) in deletem:
                        deletem = deletem + [(meta.name, meta['name'])] 
                    meta.decompose() # all previous print statements lost here
                else:
                    skip = skip + [(meta.name, meta['name'])]

        # update file with changes
        if str(soup) != orig_html:
            bk.writefile(html_id, str(soup))
            print(file_name, 'updated')

    print('Done')

    # write a list of changes for checking
    print('Globally deleted classes: ', deletec,)
    print('Globally skipped: ', skip,)
    if prefs['metas']:
        print('Globally deleted metas: ', deletem,)

    # Save prefs to json
    prefs['metas'] = prefs['metas']
    bk.savePrefs(prefs)
    
    # Show where the json file gets written
    print ('\n')
    json_path = os.path.join(os.path.dirname(PLUG_DIR), 'plugins_prefs', PLUGIN_NAME, '{0}.json'.format(PLUGIN_NAME))
    print ('JSON file saved as:', json_path)
    print ('\n')
    print ('Clicking the "Open Preferences Location" button from Sigil\'s "Edit->Preferences" menu/dialog will get you most of the way there.')

    return 0

def main():
    print("I reached main when I should not have")
    return -1
    
if __name__ == "__main__":
    sys.exit(main())
